/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/autoscaling/AutoScalingClient.h>
#include <aws/autoscaling/AutoScalingEndpointProvider.h>
#include <aws/autoscaling/AutoScalingEndpointRules.h>
#include <aws/autoscaling/AutoScalingErrorMarshaller.h>
#include <aws/autoscaling/AutoScalingErrors.h>
#include <aws/autoscaling/AutoScalingRequest.h>
#include <aws/autoscaling/AutoScalingServiceClientModel.h>
#include <aws/autoscaling/AutoScaling_EXPORTS.h>
#include <aws/autoscaling/model/AcceleratorCountRequest.h>
#include <aws/autoscaling/model/AcceleratorManufacturer.h>
#include <aws/autoscaling/model/AcceleratorName.h>
#include <aws/autoscaling/model/AcceleratorTotalMemoryMiBRequest.h>
#include <aws/autoscaling/model/AcceleratorType.h>
#include <aws/autoscaling/model/Activity.h>
#include <aws/autoscaling/model/AdjustmentType.h>
#include <aws/autoscaling/model/Alarm.h>
#include <aws/autoscaling/model/AlarmSpecification.h>
#include <aws/autoscaling/model/AttachInstancesRequest.h>
#include <aws/autoscaling/model/AttachLoadBalancerTargetGroupsRequest.h>
#include <aws/autoscaling/model/AttachLoadBalancerTargetGroupsResult.h>
#include <aws/autoscaling/model/AttachLoadBalancersRequest.h>
#include <aws/autoscaling/model/AttachLoadBalancersResult.h>
#include <aws/autoscaling/model/AttachTrafficSourcesRequest.h>
#include <aws/autoscaling/model/AttachTrafficSourcesResult.h>
#include <aws/autoscaling/model/AutoScalingGroup.h>
#include <aws/autoscaling/model/AutoScalingInstanceDetails.h>
#include <aws/autoscaling/model/AvailabilityZoneDistribution.h>
#include <aws/autoscaling/model/AvailabilityZoneImpairmentPolicy.h>
#include <aws/autoscaling/model/BareMetal.h>
#include <aws/autoscaling/model/BaselineEbsBandwidthMbpsRequest.h>
#include <aws/autoscaling/model/BaselinePerformanceFactorsRequest.h>
#include <aws/autoscaling/model/BatchDeleteScheduledActionRequest.h>
#include <aws/autoscaling/model/BatchDeleteScheduledActionResult.h>
#include <aws/autoscaling/model/BatchPutScheduledUpdateGroupActionRequest.h>
#include <aws/autoscaling/model/BatchPutScheduledUpdateGroupActionResult.h>
#include <aws/autoscaling/model/BlockDeviceMapping.h>
#include <aws/autoscaling/model/BurstablePerformance.h>
#include <aws/autoscaling/model/CancelInstanceRefreshRequest.h>
#include <aws/autoscaling/model/CancelInstanceRefreshResult.h>
#include <aws/autoscaling/model/CapacityDistributionStrategy.h>
#include <aws/autoscaling/model/CapacityForecast.h>
#include <aws/autoscaling/model/CapacityReservationPreference.h>
#include <aws/autoscaling/model/CapacityReservationSpecification.h>
#include <aws/autoscaling/model/CapacityReservationTarget.h>
#include <aws/autoscaling/model/CompleteLifecycleActionRequest.h>
#include <aws/autoscaling/model/CompleteLifecycleActionResult.h>
#include <aws/autoscaling/model/CpuManufacturer.h>
#include <aws/autoscaling/model/CpuPerformanceFactorRequest.h>
#include <aws/autoscaling/model/CreateAutoScalingGroupRequest.h>
#include <aws/autoscaling/model/CreateLaunchConfigurationRequest.h>
#include <aws/autoscaling/model/CreateOrUpdateTagsRequest.h>
#include <aws/autoscaling/model/CustomizedMetricSpecification.h>
#include <aws/autoscaling/model/DeleteAutoScalingGroupRequest.h>
#include <aws/autoscaling/model/DeleteLaunchConfigurationRequest.h>
#include <aws/autoscaling/model/DeleteLifecycleHookRequest.h>
#include <aws/autoscaling/model/DeleteLifecycleHookResult.h>
#include <aws/autoscaling/model/DeleteNotificationConfigurationRequest.h>
#include <aws/autoscaling/model/DeletePolicyRequest.h>
#include <aws/autoscaling/model/DeleteScheduledActionRequest.h>
#include <aws/autoscaling/model/DeleteTagsRequest.h>
#include <aws/autoscaling/model/DeleteWarmPoolRequest.h>
#include <aws/autoscaling/model/DeleteWarmPoolResult.h>
#include <aws/autoscaling/model/DescribeAccountLimitsRequest.h>
#include <aws/autoscaling/model/DescribeAccountLimitsResult.h>
#include <aws/autoscaling/model/DescribeAdjustmentTypesRequest.h>
#include <aws/autoscaling/model/DescribeAdjustmentTypesResult.h>
#include <aws/autoscaling/model/DescribeAutoScalingGroupsRequest.h>
#include <aws/autoscaling/model/DescribeAutoScalingGroupsResult.h>
#include <aws/autoscaling/model/DescribeAutoScalingInstancesRequest.h>
#include <aws/autoscaling/model/DescribeAutoScalingInstancesResult.h>
#include <aws/autoscaling/model/DescribeAutoScalingNotificationTypesRequest.h>
#include <aws/autoscaling/model/DescribeAutoScalingNotificationTypesResult.h>
#include <aws/autoscaling/model/DescribeInstanceRefreshesRequest.h>
#include <aws/autoscaling/model/DescribeInstanceRefreshesResult.h>
#include <aws/autoscaling/model/DescribeLaunchConfigurationsRequest.h>
#include <aws/autoscaling/model/DescribeLaunchConfigurationsResult.h>
#include <aws/autoscaling/model/DescribeLifecycleHookTypesRequest.h>
#include <aws/autoscaling/model/DescribeLifecycleHookTypesResult.h>
#include <aws/autoscaling/model/DescribeLifecycleHooksRequest.h>
#include <aws/autoscaling/model/DescribeLifecycleHooksResult.h>
#include <aws/autoscaling/model/DescribeLoadBalancerTargetGroupsRequest.h>
#include <aws/autoscaling/model/DescribeLoadBalancerTargetGroupsResult.h>
#include <aws/autoscaling/model/DescribeLoadBalancersRequest.h>
#include <aws/autoscaling/model/DescribeLoadBalancersResult.h>
#include <aws/autoscaling/model/DescribeMetricCollectionTypesRequest.h>
#include <aws/autoscaling/model/DescribeMetricCollectionTypesResult.h>
#include <aws/autoscaling/model/DescribeNotificationConfigurationsRequest.h>
#include <aws/autoscaling/model/DescribeNotificationConfigurationsResult.h>
#include <aws/autoscaling/model/DescribePoliciesRequest.h>
#include <aws/autoscaling/model/DescribePoliciesResult.h>
#include <aws/autoscaling/model/DescribeScalingActivitiesRequest.h>
#include <aws/autoscaling/model/DescribeScalingActivitiesResult.h>
#include <aws/autoscaling/model/DescribeScalingProcessTypesRequest.h>
#include <aws/autoscaling/model/DescribeScalingProcessTypesResult.h>
#include <aws/autoscaling/model/DescribeScheduledActionsRequest.h>
#include <aws/autoscaling/model/DescribeScheduledActionsResult.h>
#include <aws/autoscaling/model/DescribeTagsRequest.h>
#include <aws/autoscaling/model/DescribeTagsResult.h>
#include <aws/autoscaling/model/DescribeTerminationPolicyTypesRequest.h>
#include <aws/autoscaling/model/DescribeTerminationPolicyTypesResult.h>
#include <aws/autoscaling/model/DescribeTrafficSourcesRequest.h>
#include <aws/autoscaling/model/DescribeTrafficSourcesResult.h>
#include <aws/autoscaling/model/DescribeWarmPoolRequest.h>
#include <aws/autoscaling/model/DescribeWarmPoolResult.h>
#include <aws/autoscaling/model/DesiredConfiguration.h>
#include <aws/autoscaling/model/DetachInstancesRequest.h>
#include <aws/autoscaling/model/DetachInstancesResult.h>
#include <aws/autoscaling/model/DetachLoadBalancerTargetGroupsRequest.h>
#include <aws/autoscaling/model/DetachLoadBalancerTargetGroupsResult.h>
#include <aws/autoscaling/model/DetachLoadBalancersRequest.h>
#include <aws/autoscaling/model/DetachLoadBalancersResult.h>
#include <aws/autoscaling/model/DetachTrafficSourcesRequest.h>
#include <aws/autoscaling/model/DetachTrafficSourcesResult.h>
#include <aws/autoscaling/model/DisableMetricsCollectionRequest.h>
#include <aws/autoscaling/model/Ebs.h>
#include <aws/autoscaling/model/EnableMetricsCollectionRequest.h>
#include <aws/autoscaling/model/EnabledMetric.h>
#include <aws/autoscaling/model/EnterStandbyRequest.h>
#include <aws/autoscaling/model/EnterStandbyResult.h>
#include <aws/autoscaling/model/ExecutePolicyRequest.h>
#include <aws/autoscaling/model/ExitStandbyRequest.h>
#include <aws/autoscaling/model/ExitStandbyResult.h>
#include <aws/autoscaling/model/FailedScheduledUpdateGroupActionRequest.h>
#include <aws/autoscaling/model/Filter.h>
#include <aws/autoscaling/model/GetPredictiveScalingForecastRequest.h>
#include <aws/autoscaling/model/GetPredictiveScalingForecastResult.h>
#include <aws/autoscaling/model/ImpairedZoneHealthCheckBehavior.h>
#include <aws/autoscaling/model/Instance.h>
#include <aws/autoscaling/model/InstanceGeneration.h>
#include <aws/autoscaling/model/InstanceMaintenancePolicy.h>
#include <aws/autoscaling/model/InstanceMetadataEndpointState.h>
#include <aws/autoscaling/model/InstanceMetadataHttpTokensState.h>
#include <aws/autoscaling/model/InstanceMetadataOptions.h>
#include <aws/autoscaling/model/InstanceMonitoring.h>
#include <aws/autoscaling/model/InstanceRefresh.h>
#include <aws/autoscaling/model/InstanceRefreshLivePoolProgress.h>
#include <aws/autoscaling/model/InstanceRefreshProgressDetails.h>
#include <aws/autoscaling/model/InstanceRefreshStatus.h>
#include <aws/autoscaling/model/InstanceRefreshWarmPoolProgress.h>
#include <aws/autoscaling/model/InstanceRequirements.h>
#include <aws/autoscaling/model/InstanceReusePolicy.h>
#include <aws/autoscaling/model/InstancesDistribution.h>
#include <aws/autoscaling/model/LaunchConfiguration.h>
#include <aws/autoscaling/model/LaunchTemplate.h>
#include <aws/autoscaling/model/LaunchTemplateOverrides.h>
#include <aws/autoscaling/model/LaunchTemplateSpecification.h>
#include <aws/autoscaling/model/LifecycleHook.h>
#include <aws/autoscaling/model/LifecycleHookSpecification.h>
#include <aws/autoscaling/model/LifecycleState.h>
#include <aws/autoscaling/model/LoadBalancerState.h>
#include <aws/autoscaling/model/LoadBalancerTargetGroupState.h>
#include <aws/autoscaling/model/LoadForecast.h>
#include <aws/autoscaling/model/LocalStorage.h>
#include <aws/autoscaling/model/LocalStorageType.h>
#include <aws/autoscaling/model/MemoryGiBPerVCpuRequest.h>
#include <aws/autoscaling/model/MemoryMiBRequest.h>
#include <aws/autoscaling/model/Metric.h>
#include <aws/autoscaling/model/MetricCollectionType.h>
#include <aws/autoscaling/model/MetricDataQuery.h>
#include <aws/autoscaling/model/MetricDimension.h>
#include <aws/autoscaling/model/MetricGranularityType.h>
#include <aws/autoscaling/model/MetricStat.h>
#include <aws/autoscaling/model/MetricStatistic.h>
#include <aws/autoscaling/model/MetricType.h>
#include <aws/autoscaling/model/MixedInstancesPolicy.h>
#include <aws/autoscaling/model/NetworkBandwidthGbpsRequest.h>
#include <aws/autoscaling/model/NetworkInterfaceCountRequest.h>
#include <aws/autoscaling/model/NotificationConfiguration.h>
#include <aws/autoscaling/model/PerformanceFactorReferenceRequest.h>
#include <aws/autoscaling/model/PredefinedLoadMetricType.h>
#include <aws/autoscaling/model/PredefinedMetricPairType.h>
#include <aws/autoscaling/model/PredefinedMetricSpecification.h>
#include <aws/autoscaling/model/PredefinedScalingMetricType.h>
#include <aws/autoscaling/model/PredictiveScalingConfiguration.h>
#include <aws/autoscaling/model/PredictiveScalingCustomizedCapacityMetric.h>
#include <aws/autoscaling/model/PredictiveScalingCustomizedLoadMetric.h>
#include <aws/autoscaling/model/PredictiveScalingCustomizedScalingMetric.h>
#include <aws/autoscaling/model/PredictiveScalingMaxCapacityBreachBehavior.h>
#include <aws/autoscaling/model/PredictiveScalingMetricSpecification.h>
#include <aws/autoscaling/model/PredictiveScalingMode.h>
#include <aws/autoscaling/model/PredictiveScalingPredefinedLoadMetric.h>
#include <aws/autoscaling/model/PredictiveScalingPredefinedMetricPair.h>
#include <aws/autoscaling/model/PredictiveScalingPredefinedScalingMetric.h>
#include <aws/autoscaling/model/ProcessType.h>
#include <aws/autoscaling/model/PutLifecycleHookRequest.h>
#include <aws/autoscaling/model/PutLifecycleHookResult.h>
#include <aws/autoscaling/model/PutNotificationConfigurationRequest.h>
#include <aws/autoscaling/model/PutScalingPolicyRequest.h>
#include <aws/autoscaling/model/PutScalingPolicyResult.h>
#include <aws/autoscaling/model/PutScheduledUpdateGroupActionRequest.h>
#include <aws/autoscaling/model/PutWarmPoolRequest.h>
#include <aws/autoscaling/model/PutWarmPoolResult.h>
#include <aws/autoscaling/model/RecordLifecycleActionHeartbeatRequest.h>
#include <aws/autoscaling/model/RecordLifecycleActionHeartbeatResult.h>
#include <aws/autoscaling/model/RefreshPreferences.h>
#include <aws/autoscaling/model/RefreshStrategy.h>
#include <aws/autoscaling/model/ResponseMetadata.h>
#include <aws/autoscaling/model/ResumeProcessesRequest.h>
#include <aws/autoscaling/model/RollbackDetails.h>
#include <aws/autoscaling/model/RollbackInstanceRefreshRequest.h>
#include <aws/autoscaling/model/RollbackInstanceRefreshResult.h>
#include <aws/autoscaling/model/ScaleInProtectedInstances.h>
#include <aws/autoscaling/model/ScalingActivityStatusCode.h>
#include <aws/autoscaling/model/ScalingPolicy.h>
#include <aws/autoscaling/model/ScheduledUpdateGroupAction.h>
#include <aws/autoscaling/model/ScheduledUpdateGroupActionRequest.h>
#include <aws/autoscaling/model/SetDesiredCapacityRequest.h>
#include <aws/autoscaling/model/SetInstanceHealthRequest.h>
#include <aws/autoscaling/model/SetInstanceProtectionRequest.h>
#include <aws/autoscaling/model/SetInstanceProtectionResult.h>
#include <aws/autoscaling/model/StandbyInstances.h>
#include <aws/autoscaling/model/StartInstanceRefreshRequest.h>
#include <aws/autoscaling/model/StartInstanceRefreshResult.h>
#include <aws/autoscaling/model/StepAdjustment.h>
#include <aws/autoscaling/model/SuspendProcessesRequest.h>
#include <aws/autoscaling/model/SuspendedProcess.h>
#include <aws/autoscaling/model/Tag.h>
#include <aws/autoscaling/model/TagDescription.h>
#include <aws/autoscaling/model/TargetTrackingConfiguration.h>
#include <aws/autoscaling/model/TargetTrackingMetricDataQuery.h>
#include <aws/autoscaling/model/TargetTrackingMetricStat.h>
#include <aws/autoscaling/model/TerminateInstanceInAutoScalingGroupRequest.h>
#include <aws/autoscaling/model/TerminateInstanceInAutoScalingGroupResult.h>
#include <aws/autoscaling/model/TotalLocalStorageGBRequest.h>
#include <aws/autoscaling/model/TrafficSourceIdentifier.h>
#include <aws/autoscaling/model/TrafficSourceState.h>
#include <aws/autoscaling/model/UpdateAutoScalingGroupRequest.h>
#include <aws/autoscaling/model/VCpuCountRequest.h>
#include <aws/autoscaling/model/WarmPoolConfiguration.h>
#include <aws/autoscaling/model/WarmPoolState.h>
#include <aws/autoscaling/model/WarmPoolStatus.h>

using AutoScalingIncludeTest = ::testing::Test;

TEST_F(AutoScalingIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::AutoScaling::AutoScalingClient>("AutoScalingIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
