/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/awstransfer/TransferClient.h>
#include <aws/awstransfer/TransferEndpointProvider.h>
#include <aws/awstransfer/TransferEndpointRules.h>
#include <aws/awstransfer/TransferErrorMarshaller.h>
#include <aws/awstransfer/TransferErrors.h>
#include <aws/awstransfer/TransferRequest.h>
#include <aws/awstransfer/TransferServiceClientModel.h>
#include <aws/awstransfer/Transfer_EXPORTS.h>
#include <aws/awstransfer/model/AgreementStatusType.h>
#include <aws/awstransfer/model/As2ConnectorConfig.h>
#include <aws/awstransfer/model/As2Transport.h>
#include <aws/awstransfer/model/CertificateStatusType.h>
#include <aws/awstransfer/model/CertificateType.h>
#include <aws/awstransfer/model/CertificateUsageType.h>
#include <aws/awstransfer/model/CompressionEnum.h>
#include <aws/awstransfer/model/ConnectorFileTransferResult.h>
#include <aws/awstransfer/model/CopyStepDetails.h>
#include <aws/awstransfer/model/CreateAccessRequest.h>
#include <aws/awstransfer/model/CreateAccessResult.h>
#include <aws/awstransfer/model/CreateAgreementRequest.h>
#include <aws/awstransfer/model/CreateAgreementResult.h>
#include <aws/awstransfer/model/CreateConnectorRequest.h>
#include <aws/awstransfer/model/CreateConnectorResult.h>
#include <aws/awstransfer/model/CreateProfileRequest.h>
#include <aws/awstransfer/model/CreateProfileResult.h>
#include <aws/awstransfer/model/CreateServerRequest.h>
#include <aws/awstransfer/model/CreateServerResult.h>
#include <aws/awstransfer/model/CreateUserRequest.h>
#include <aws/awstransfer/model/CreateUserResult.h>
#include <aws/awstransfer/model/CreateWebAppRequest.h>
#include <aws/awstransfer/model/CreateWebAppResult.h>
#include <aws/awstransfer/model/CreateWorkflowRequest.h>
#include <aws/awstransfer/model/CreateWorkflowResult.h>
#include <aws/awstransfer/model/CustomDirectoriesType.h>
#include <aws/awstransfer/model/CustomStepDetails.h>
#include <aws/awstransfer/model/CustomStepStatus.h>
#include <aws/awstransfer/model/DecryptStepDetails.h>
#include <aws/awstransfer/model/DeleteAccessRequest.h>
#include <aws/awstransfer/model/DeleteAgreementRequest.h>
#include <aws/awstransfer/model/DeleteCertificateRequest.h>
#include <aws/awstransfer/model/DeleteConnectorRequest.h>
#include <aws/awstransfer/model/DeleteHostKeyRequest.h>
#include <aws/awstransfer/model/DeleteProfileRequest.h>
#include <aws/awstransfer/model/DeleteServerRequest.h>
#include <aws/awstransfer/model/DeleteSshPublicKeyRequest.h>
#include <aws/awstransfer/model/DeleteStepDetails.h>
#include <aws/awstransfer/model/DeleteUserRequest.h>
#include <aws/awstransfer/model/DeleteWebAppCustomizationRequest.h>
#include <aws/awstransfer/model/DeleteWebAppRequest.h>
#include <aws/awstransfer/model/DeleteWorkflowRequest.h>
#include <aws/awstransfer/model/DescribeAccessRequest.h>
#include <aws/awstransfer/model/DescribeAccessResult.h>
#include <aws/awstransfer/model/DescribeAgreementRequest.h>
#include <aws/awstransfer/model/DescribeAgreementResult.h>
#include <aws/awstransfer/model/DescribeCertificateRequest.h>
#include <aws/awstransfer/model/DescribeCertificateResult.h>
#include <aws/awstransfer/model/DescribeConnectorRequest.h>
#include <aws/awstransfer/model/DescribeConnectorResult.h>
#include <aws/awstransfer/model/DescribeExecutionRequest.h>
#include <aws/awstransfer/model/DescribeExecutionResult.h>
#include <aws/awstransfer/model/DescribeHostKeyRequest.h>
#include <aws/awstransfer/model/DescribeHostKeyResult.h>
#include <aws/awstransfer/model/DescribeProfileRequest.h>
#include <aws/awstransfer/model/DescribeProfileResult.h>
#include <aws/awstransfer/model/DescribeSecurityPolicyRequest.h>
#include <aws/awstransfer/model/DescribeSecurityPolicyResult.h>
#include <aws/awstransfer/model/DescribeServerRequest.h>
#include <aws/awstransfer/model/DescribeServerResult.h>
#include <aws/awstransfer/model/DescribeUserRequest.h>
#include <aws/awstransfer/model/DescribeUserResult.h>
#include <aws/awstransfer/model/DescribeWebAppCustomizationRequest.h>
#include <aws/awstransfer/model/DescribeWebAppCustomizationResult.h>
#include <aws/awstransfer/model/DescribeWebAppRequest.h>
#include <aws/awstransfer/model/DescribeWebAppResult.h>
#include <aws/awstransfer/model/DescribeWorkflowRequest.h>
#include <aws/awstransfer/model/DescribeWorkflowResult.h>
#include <aws/awstransfer/model/DescribedAccess.h>
#include <aws/awstransfer/model/DescribedAgreement.h>
#include <aws/awstransfer/model/DescribedCertificate.h>
#include <aws/awstransfer/model/DescribedConnector.h>
#include <aws/awstransfer/model/DescribedExecution.h>
#include <aws/awstransfer/model/DescribedHostKey.h>
#include <aws/awstransfer/model/DescribedIdentityCenterConfig.h>
#include <aws/awstransfer/model/DescribedProfile.h>
#include <aws/awstransfer/model/DescribedSecurityPolicy.h>
#include <aws/awstransfer/model/DescribedServer.h>
#include <aws/awstransfer/model/DescribedUser.h>
#include <aws/awstransfer/model/DescribedWebApp.h>
#include <aws/awstransfer/model/DescribedWebAppCustomization.h>
#include <aws/awstransfer/model/DescribedWebAppIdentityProviderDetails.h>
#include <aws/awstransfer/model/DescribedWorkflow.h>
#include <aws/awstransfer/model/DirectoryListingOptimization.h>
#include <aws/awstransfer/model/Domain.h>
#include <aws/awstransfer/model/EfsFileLocation.h>
#include <aws/awstransfer/model/EncryptionAlg.h>
#include <aws/awstransfer/model/EncryptionType.h>
#include <aws/awstransfer/model/EndpointDetails.h>
#include <aws/awstransfer/model/EndpointType.h>
#include <aws/awstransfer/model/EnforceMessageSigningType.h>
#include <aws/awstransfer/model/ExecutionError.h>
#include <aws/awstransfer/model/ExecutionErrorType.h>
#include <aws/awstransfer/model/ExecutionResults.h>
#include <aws/awstransfer/model/ExecutionStatus.h>
#include <aws/awstransfer/model/ExecutionStepResult.h>
#include <aws/awstransfer/model/FileLocation.h>
#include <aws/awstransfer/model/HomeDirectoryMapEntry.h>
#include <aws/awstransfer/model/HomeDirectoryType.h>
#include <aws/awstransfer/model/IdentityCenterConfig.h>
#include <aws/awstransfer/model/IdentityProviderDetails.h>
#include <aws/awstransfer/model/IdentityProviderType.h>
#include <aws/awstransfer/model/ImportCertificateRequest.h>
#include <aws/awstransfer/model/ImportCertificateResult.h>
#include <aws/awstransfer/model/ImportHostKeyRequest.h>
#include <aws/awstransfer/model/ImportHostKeyResult.h>
#include <aws/awstransfer/model/ImportSshPublicKeyRequest.h>
#include <aws/awstransfer/model/ImportSshPublicKeyResult.h>
#include <aws/awstransfer/model/InputFileLocation.h>
#include <aws/awstransfer/model/ListAccessesRequest.h>
#include <aws/awstransfer/model/ListAccessesResult.h>
#include <aws/awstransfer/model/ListAgreementsRequest.h>
#include <aws/awstransfer/model/ListAgreementsResult.h>
#include <aws/awstransfer/model/ListCertificatesRequest.h>
#include <aws/awstransfer/model/ListCertificatesResult.h>
#include <aws/awstransfer/model/ListConnectorsRequest.h>
#include <aws/awstransfer/model/ListConnectorsResult.h>
#include <aws/awstransfer/model/ListExecutionsRequest.h>
#include <aws/awstransfer/model/ListExecutionsResult.h>
#include <aws/awstransfer/model/ListFileTransferResultsRequest.h>
#include <aws/awstransfer/model/ListFileTransferResultsResult.h>
#include <aws/awstransfer/model/ListHostKeysRequest.h>
#include <aws/awstransfer/model/ListHostKeysResult.h>
#include <aws/awstransfer/model/ListProfilesRequest.h>
#include <aws/awstransfer/model/ListProfilesResult.h>
#include <aws/awstransfer/model/ListSecurityPoliciesRequest.h>
#include <aws/awstransfer/model/ListSecurityPoliciesResult.h>
#include <aws/awstransfer/model/ListServersRequest.h>
#include <aws/awstransfer/model/ListServersResult.h>
#include <aws/awstransfer/model/ListTagsForResourceRequest.h>
#include <aws/awstransfer/model/ListTagsForResourceResult.h>
#include <aws/awstransfer/model/ListUsersRequest.h>
#include <aws/awstransfer/model/ListUsersResult.h>
#include <aws/awstransfer/model/ListWebAppsRequest.h>
#include <aws/awstransfer/model/ListWebAppsResult.h>
#include <aws/awstransfer/model/ListWorkflowsRequest.h>
#include <aws/awstransfer/model/ListWorkflowsResult.h>
#include <aws/awstransfer/model/ListedAccess.h>
#include <aws/awstransfer/model/ListedAgreement.h>
#include <aws/awstransfer/model/ListedCertificate.h>
#include <aws/awstransfer/model/ListedConnector.h>
#include <aws/awstransfer/model/ListedExecution.h>
#include <aws/awstransfer/model/ListedHostKey.h>
#include <aws/awstransfer/model/ListedProfile.h>
#include <aws/awstransfer/model/ListedServer.h>
#include <aws/awstransfer/model/ListedUser.h>
#include <aws/awstransfer/model/ListedWebApp.h>
#include <aws/awstransfer/model/ListedWorkflow.h>
#include <aws/awstransfer/model/LoggingConfiguration.h>
#include <aws/awstransfer/model/MapType.h>
#include <aws/awstransfer/model/MdnResponse.h>
#include <aws/awstransfer/model/MdnSigningAlg.h>
#include <aws/awstransfer/model/OverwriteExisting.h>
#include <aws/awstransfer/model/PosixProfile.h>
#include <aws/awstransfer/model/PreserveContentType.h>
#include <aws/awstransfer/model/PreserveFilenameType.h>
#include <aws/awstransfer/model/ProfileType.h>
#include <aws/awstransfer/model/Protocol.h>
#include <aws/awstransfer/model/ProtocolDetails.h>
#include <aws/awstransfer/model/ResourceExistsException.h>
#include <aws/awstransfer/model/ResourceNotFoundException.h>
#include <aws/awstransfer/model/S3FileLocation.h>
#include <aws/awstransfer/model/S3InputFileLocation.h>
#include <aws/awstransfer/model/S3StorageOptions.h>
#include <aws/awstransfer/model/S3Tag.h>
#include <aws/awstransfer/model/SecurityPolicyProtocol.h>
#include <aws/awstransfer/model/SecurityPolicyResourceType.h>
#include <aws/awstransfer/model/SendWorkflowStepStateRequest.h>
#include <aws/awstransfer/model/SendWorkflowStepStateResult.h>
#include <aws/awstransfer/model/ServiceMetadata.h>
#include <aws/awstransfer/model/SetStatOption.h>
#include <aws/awstransfer/model/SftpAuthenticationMethods.h>
#include <aws/awstransfer/model/SftpConnectorConfig.h>
#include <aws/awstransfer/model/SftpConnectorConnectionDetails.h>
#include <aws/awstransfer/model/SigningAlg.h>
#include <aws/awstransfer/model/SshPublicKey.h>
#include <aws/awstransfer/model/StartDirectoryListingRequest.h>
#include <aws/awstransfer/model/StartDirectoryListingResult.h>
#include <aws/awstransfer/model/StartFileTransferRequest.h>
#include <aws/awstransfer/model/StartFileTransferResult.h>
#include <aws/awstransfer/model/StartRemoteDeleteRequest.h>
#include <aws/awstransfer/model/StartRemoteDeleteResult.h>
#include <aws/awstransfer/model/StartRemoteMoveRequest.h>
#include <aws/awstransfer/model/StartRemoteMoveResult.h>
#include <aws/awstransfer/model/StartServerRequest.h>
#include <aws/awstransfer/model/State.h>
#include <aws/awstransfer/model/StopServerRequest.h>
#include <aws/awstransfer/model/Tag.h>
#include <aws/awstransfer/model/TagResourceRequest.h>
#include <aws/awstransfer/model/TagStepDetails.h>
#include <aws/awstransfer/model/TestConnectionRequest.h>
#include <aws/awstransfer/model/TestConnectionResult.h>
#include <aws/awstransfer/model/TestIdentityProviderRequest.h>
#include <aws/awstransfer/model/TestIdentityProviderResult.h>
#include <aws/awstransfer/model/ThrottlingException.h>
#include <aws/awstransfer/model/TlsSessionResumptionMode.h>
#include <aws/awstransfer/model/TransferTableStatus.h>
#include <aws/awstransfer/model/UntagResourceRequest.h>
#include <aws/awstransfer/model/UpdateAccessRequest.h>
#include <aws/awstransfer/model/UpdateAccessResult.h>
#include <aws/awstransfer/model/UpdateAgreementRequest.h>
#include <aws/awstransfer/model/UpdateAgreementResult.h>
#include <aws/awstransfer/model/UpdateCertificateRequest.h>
#include <aws/awstransfer/model/UpdateCertificateResult.h>
#include <aws/awstransfer/model/UpdateConnectorRequest.h>
#include <aws/awstransfer/model/UpdateConnectorResult.h>
#include <aws/awstransfer/model/UpdateHostKeyRequest.h>
#include <aws/awstransfer/model/UpdateHostKeyResult.h>
#include <aws/awstransfer/model/UpdateProfileRequest.h>
#include <aws/awstransfer/model/UpdateProfileResult.h>
#include <aws/awstransfer/model/UpdateServerRequest.h>
#include <aws/awstransfer/model/UpdateServerResult.h>
#include <aws/awstransfer/model/UpdateUserRequest.h>
#include <aws/awstransfer/model/UpdateUserResult.h>
#include <aws/awstransfer/model/UpdateWebAppCustomizationRequest.h>
#include <aws/awstransfer/model/UpdateWebAppCustomizationResult.h>
#include <aws/awstransfer/model/UpdateWebAppIdentityCenterConfig.h>
#include <aws/awstransfer/model/UpdateWebAppIdentityProviderDetails.h>
#include <aws/awstransfer/model/UpdateWebAppRequest.h>
#include <aws/awstransfer/model/UpdateWebAppResult.h>
#include <aws/awstransfer/model/UserDetails.h>
#include <aws/awstransfer/model/WebAppEndpointPolicy.h>
#include <aws/awstransfer/model/WebAppIdentityProviderDetails.h>
#include <aws/awstransfer/model/WebAppUnits.h>
#include <aws/awstransfer/model/WorkflowDetail.h>
#include <aws/awstransfer/model/WorkflowDetails.h>
#include <aws/awstransfer/model/WorkflowStep.h>
#include <aws/awstransfer/model/WorkflowStepType.h>

using TransferIncludeTest = ::testing::Test;

TEST_F(TransferIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::Transfer::TransferClient>("TransferIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
