/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/backup/BackupClient.h>
#include <aws/backup/BackupEndpointProvider.h>
#include <aws/backup/BackupEndpointRules.h>
#include <aws/backup/BackupErrorMarshaller.h>
#include <aws/backup/BackupErrors.h>
#include <aws/backup/BackupRequest.h>
#include <aws/backup/BackupServiceClientModel.h>
#include <aws/backup/Backup_EXPORTS.h>
#include <aws/backup/model/AdvancedBackupSetting.h>
#include <aws/backup/model/AggregationPeriod.h>
#include <aws/backup/model/AlreadyExistsException.h>
#include <aws/backup/model/AssociateBackupVaultMpaApprovalTeamRequest.h>
#include <aws/backup/model/BackupJob.h>
#include <aws/backup/model/BackupJobState.h>
#include <aws/backup/model/BackupJobStatus.h>
#include <aws/backup/model/BackupJobSummary.h>
#include <aws/backup/model/BackupPlan.h>
#include <aws/backup/model/BackupPlanInput.h>
#include <aws/backup/model/BackupPlanTemplatesListMember.h>
#include <aws/backup/model/BackupPlansListMember.h>
#include <aws/backup/model/BackupRule.h>
#include <aws/backup/model/BackupRuleInput.h>
#include <aws/backup/model/BackupSelection.h>
#include <aws/backup/model/BackupSelectionsListMember.h>
#include <aws/backup/model/BackupVaultEvent.h>
#include <aws/backup/model/BackupVaultListMember.h>
#include <aws/backup/model/CalculatedLifecycle.h>
#include <aws/backup/model/CancelLegalHoldRequest.h>
#include <aws/backup/model/CancelLegalHoldResult.h>
#include <aws/backup/model/Condition.h>
#include <aws/backup/model/ConditionParameter.h>
#include <aws/backup/model/ConditionType.h>
#include <aws/backup/model/Conditions.h>
#include <aws/backup/model/ConflictException.h>
#include <aws/backup/model/ControlInputParameter.h>
#include <aws/backup/model/ControlScope.h>
#include <aws/backup/model/CopyAction.h>
#include <aws/backup/model/CopyJob.h>
#include <aws/backup/model/CopyJobState.h>
#include <aws/backup/model/CopyJobStatus.h>
#include <aws/backup/model/CopyJobSummary.h>
#include <aws/backup/model/CreateBackupPlanRequest.h>
#include <aws/backup/model/CreateBackupPlanResult.h>
#include <aws/backup/model/CreateBackupSelectionRequest.h>
#include <aws/backup/model/CreateBackupSelectionResult.h>
#include <aws/backup/model/CreateBackupVaultRequest.h>
#include <aws/backup/model/CreateBackupVaultResult.h>
#include <aws/backup/model/CreateFrameworkRequest.h>
#include <aws/backup/model/CreateFrameworkResult.h>
#include <aws/backup/model/CreateLegalHoldRequest.h>
#include <aws/backup/model/CreateLegalHoldResult.h>
#include <aws/backup/model/CreateLogicallyAirGappedBackupVaultRequest.h>
#include <aws/backup/model/CreateLogicallyAirGappedBackupVaultResult.h>
#include <aws/backup/model/CreateReportPlanRequest.h>
#include <aws/backup/model/CreateReportPlanResult.h>
#include <aws/backup/model/CreateRestoreAccessBackupVaultRequest.h>
#include <aws/backup/model/CreateRestoreAccessBackupVaultResult.h>
#include <aws/backup/model/CreateRestoreTestingPlanRequest.h>
#include <aws/backup/model/CreateRestoreTestingPlanResult.h>
#include <aws/backup/model/CreateRestoreTestingSelectionRequest.h>
#include <aws/backup/model/CreateRestoreTestingSelectionResult.h>
#include <aws/backup/model/DateRange.h>
#include <aws/backup/model/DeleteBackupPlanRequest.h>
#include <aws/backup/model/DeleteBackupPlanResult.h>
#include <aws/backup/model/DeleteBackupSelectionRequest.h>
#include <aws/backup/model/DeleteBackupVaultAccessPolicyRequest.h>
#include <aws/backup/model/DeleteBackupVaultLockConfigurationRequest.h>
#include <aws/backup/model/DeleteBackupVaultNotificationsRequest.h>
#include <aws/backup/model/DeleteBackupVaultRequest.h>
#include <aws/backup/model/DeleteFrameworkRequest.h>
#include <aws/backup/model/DeleteRecoveryPointRequest.h>
#include <aws/backup/model/DeleteReportPlanRequest.h>
#include <aws/backup/model/DeleteRestoreTestingPlanRequest.h>
#include <aws/backup/model/DeleteRestoreTestingSelectionRequest.h>
#include <aws/backup/model/DependencyFailureException.h>
#include <aws/backup/model/DescribeBackupJobRequest.h>
#include <aws/backup/model/DescribeBackupJobResult.h>
#include <aws/backup/model/DescribeBackupVaultRequest.h>
#include <aws/backup/model/DescribeBackupVaultResult.h>
#include <aws/backup/model/DescribeCopyJobRequest.h>
#include <aws/backup/model/DescribeCopyJobResult.h>
#include <aws/backup/model/DescribeFrameworkRequest.h>
#include <aws/backup/model/DescribeFrameworkResult.h>
#include <aws/backup/model/DescribeGlobalSettingsRequest.h>
#include <aws/backup/model/DescribeGlobalSettingsResult.h>
#include <aws/backup/model/DescribeProtectedResourceRequest.h>
#include <aws/backup/model/DescribeProtectedResourceResult.h>
#include <aws/backup/model/DescribeRecoveryPointRequest.h>
#include <aws/backup/model/DescribeRecoveryPointResult.h>
#include <aws/backup/model/DescribeRegionSettingsRequest.h>
#include <aws/backup/model/DescribeRegionSettingsResult.h>
#include <aws/backup/model/DescribeReportJobRequest.h>
#include <aws/backup/model/DescribeReportJobResult.h>
#include <aws/backup/model/DescribeReportPlanRequest.h>
#include <aws/backup/model/DescribeReportPlanResult.h>
#include <aws/backup/model/DescribeRestoreJobRequest.h>
#include <aws/backup/model/DescribeRestoreJobResult.h>
#include <aws/backup/model/DisassociateBackupVaultMpaApprovalTeamRequest.h>
#include <aws/backup/model/DisassociateRecoveryPointFromParentRequest.h>
#include <aws/backup/model/DisassociateRecoveryPointRequest.h>
#include <aws/backup/model/ExportBackupPlanTemplateRequest.h>
#include <aws/backup/model/ExportBackupPlanTemplateResult.h>
#include <aws/backup/model/Framework.h>
#include <aws/backup/model/FrameworkControl.h>
#include <aws/backup/model/GetBackupPlanFromJSONRequest.h>
#include <aws/backup/model/GetBackupPlanFromJSONResult.h>
#include <aws/backup/model/GetBackupPlanFromTemplateRequest.h>
#include <aws/backup/model/GetBackupPlanFromTemplateResult.h>
#include <aws/backup/model/GetBackupPlanRequest.h>
#include <aws/backup/model/GetBackupPlanResult.h>
#include <aws/backup/model/GetBackupSelectionRequest.h>
#include <aws/backup/model/GetBackupSelectionResult.h>
#include <aws/backup/model/GetBackupVaultAccessPolicyRequest.h>
#include <aws/backup/model/GetBackupVaultAccessPolicyResult.h>
#include <aws/backup/model/GetBackupVaultNotificationsRequest.h>
#include <aws/backup/model/GetBackupVaultNotificationsResult.h>
#include <aws/backup/model/GetLegalHoldRequest.h>
#include <aws/backup/model/GetLegalHoldResult.h>
#include <aws/backup/model/GetRecoveryPointIndexDetailsRequest.h>
#include <aws/backup/model/GetRecoveryPointIndexDetailsResult.h>
#include <aws/backup/model/GetRecoveryPointRestoreMetadataRequest.h>
#include <aws/backup/model/GetRecoveryPointRestoreMetadataResult.h>
#include <aws/backup/model/GetRestoreJobMetadataRequest.h>
#include <aws/backup/model/GetRestoreJobMetadataResult.h>
#include <aws/backup/model/GetRestoreTestingInferredMetadataRequest.h>
#include <aws/backup/model/GetRestoreTestingInferredMetadataResult.h>
#include <aws/backup/model/GetRestoreTestingPlanRequest.h>
#include <aws/backup/model/GetRestoreTestingPlanResult.h>
#include <aws/backup/model/GetRestoreTestingSelectionRequest.h>
#include <aws/backup/model/GetRestoreTestingSelectionResult.h>
#include <aws/backup/model/GetSupportedResourceTypesRequest.h>
#include <aws/backup/model/GetSupportedResourceTypesResult.h>
#include <aws/backup/model/Index.h>
#include <aws/backup/model/IndexAction.h>
#include <aws/backup/model/IndexStatus.h>
#include <aws/backup/model/IndexedRecoveryPoint.h>
#include <aws/backup/model/InvalidParameterValueException.h>
#include <aws/backup/model/InvalidRequestException.h>
#include <aws/backup/model/InvalidResourceStateException.h>
#include <aws/backup/model/KeyValue.h>
#include <aws/backup/model/LatestMpaApprovalTeamUpdate.h>
#include <aws/backup/model/LatestRevokeRequest.h>
#include <aws/backup/model/LegalHold.h>
#include <aws/backup/model/LegalHoldStatus.h>
#include <aws/backup/model/Lifecycle.h>
#include <aws/backup/model/LimitExceededException.h>
#include <aws/backup/model/ListBackupJobSummariesRequest.h>
#include <aws/backup/model/ListBackupJobSummariesResult.h>
#include <aws/backup/model/ListBackupJobsRequest.h>
#include <aws/backup/model/ListBackupJobsResult.h>
#include <aws/backup/model/ListBackupPlanTemplatesRequest.h>
#include <aws/backup/model/ListBackupPlanTemplatesResult.h>
#include <aws/backup/model/ListBackupPlanVersionsRequest.h>
#include <aws/backup/model/ListBackupPlanVersionsResult.h>
#include <aws/backup/model/ListBackupPlansRequest.h>
#include <aws/backup/model/ListBackupPlansResult.h>
#include <aws/backup/model/ListBackupSelectionsRequest.h>
#include <aws/backup/model/ListBackupSelectionsResult.h>
#include <aws/backup/model/ListBackupVaultsRequest.h>
#include <aws/backup/model/ListBackupVaultsResult.h>
#include <aws/backup/model/ListCopyJobSummariesRequest.h>
#include <aws/backup/model/ListCopyJobSummariesResult.h>
#include <aws/backup/model/ListCopyJobsRequest.h>
#include <aws/backup/model/ListCopyJobsResult.h>
#include <aws/backup/model/ListFrameworksRequest.h>
#include <aws/backup/model/ListFrameworksResult.h>
#include <aws/backup/model/ListIndexedRecoveryPointsRequest.h>
#include <aws/backup/model/ListIndexedRecoveryPointsResult.h>
#include <aws/backup/model/ListLegalHoldsRequest.h>
#include <aws/backup/model/ListLegalHoldsResult.h>
#include <aws/backup/model/ListProtectedResourcesByBackupVaultRequest.h>
#include <aws/backup/model/ListProtectedResourcesByBackupVaultResult.h>
#include <aws/backup/model/ListProtectedResourcesRequest.h>
#include <aws/backup/model/ListProtectedResourcesResult.h>
#include <aws/backup/model/ListRecoveryPointsByBackupVaultRequest.h>
#include <aws/backup/model/ListRecoveryPointsByBackupVaultResult.h>
#include <aws/backup/model/ListRecoveryPointsByLegalHoldRequest.h>
#include <aws/backup/model/ListRecoveryPointsByLegalHoldResult.h>
#include <aws/backup/model/ListRecoveryPointsByResourceRequest.h>
#include <aws/backup/model/ListRecoveryPointsByResourceResult.h>
#include <aws/backup/model/ListReportJobsRequest.h>
#include <aws/backup/model/ListReportJobsResult.h>
#include <aws/backup/model/ListReportPlansRequest.h>
#include <aws/backup/model/ListReportPlansResult.h>
#include <aws/backup/model/ListRestoreAccessBackupVaultsRequest.h>
#include <aws/backup/model/ListRestoreAccessBackupVaultsResult.h>
#include <aws/backup/model/ListRestoreJobSummariesRequest.h>
#include <aws/backup/model/ListRestoreJobSummariesResult.h>
#include <aws/backup/model/ListRestoreJobsByProtectedResourceRequest.h>
#include <aws/backup/model/ListRestoreJobsByProtectedResourceResult.h>
#include <aws/backup/model/ListRestoreJobsRequest.h>
#include <aws/backup/model/ListRestoreJobsResult.h>
#include <aws/backup/model/ListRestoreTestingPlansRequest.h>
#include <aws/backup/model/ListRestoreTestingPlansResult.h>
#include <aws/backup/model/ListRestoreTestingSelectionsRequest.h>
#include <aws/backup/model/ListRestoreTestingSelectionsResult.h>
#include <aws/backup/model/ListTagsRequest.h>
#include <aws/backup/model/ListTagsResult.h>
#include <aws/backup/model/MissingParameterValueException.h>
#include <aws/backup/model/MpaRevokeSessionStatus.h>
#include <aws/backup/model/MpaSessionStatus.h>
#include <aws/backup/model/ProtectedResource.h>
#include <aws/backup/model/ProtectedResourceConditions.h>
#include <aws/backup/model/PutBackupVaultAccessPolicyRequest.h>
#include <aws/backup/model/PutBackupVaultLockConfigurationRequest.h>
#include <aws/backup/model/PutBackupVaultNotificationsRequest.h>
#include <aws/backup/model/PutRestoreValidationResultRequest.h>
#include <aws/backup/model/RecoveryPointByBackupVault.h>
#include <aws/backup/model/RecoveryPointByResource.h>
#include <aws/backup/model/RecoveryPointCreator.h>
#include <aws/backup/model/RecoveryPointMember.h>
#include <aws/backup/model/RecoveryPointSelection.h>
#include <aws/backup/model/RecoveryPointStatus.h>
#include <aws/backup/model/ReportDeliveryChannel.h>
#include <aws/backup/model/ReportDestination.h>
#include <aws/backup/model/ReportJob.h>
#include <aws/backup/model/ReportPlan.h>
#include <aws/backup/model/ReportSetting.h>
#include <aws/backup/model/ResourceNotFoundException.h>
#include <aws/backup/model/RestoreAccessBackupVaultListMember.h>
#include <aws/backup/model/RestoreDeletionStatus.h>
#include <aws/backup/model/RestoreJobCreator.h>
#include <aws/backup/model/RestoreJobState.h>
#include <aws/backup/model/RestoreJobStatus.h>
#include <aws/backup/model/RestoreJobSummary.h>
#include <aws/backup/model/RestoreJobsListMember.h>
#include <aws/backup/model/RestoreTestingPlanForCreate.h>
#include <aws/backup/model/RestoreTestingPlanForGet.h>
#include <aws/backup/model/RestoreTestingPlanForList.h>
#include <aws/backup/model/RestoreTestingPlanForUpdate.h>
#include <aws/backup/model/RestoreTestingRecoveryPointSelection.h>
#include <aws/backup/model/RestoreTestingRecoveryPointSelectionAlgorithm.h>
#include <aws/backup/model/RestoreTestingRecoveryPointType.h>
#include <aws/backup/model/RestoreTestingSelectionForCreate.h>
#include <aws/backup/model/RestoreTestingSelectionForGet.h>
#include <aws/backup/model/RestoreTestingSelectionForList.h>
#include <aws/backup/model/RestoreTestingSelectionForUpdate.h>
#include <aws/backup/model/RestoreValidationStatus.h>
#include <aws/backup/model/RevokeRestoreAccessBackupVaultRequest.h>
#include <aws/backup/model/ServiceUnavailableException.h>
#include <aws/backup/model/StartBackupJobRequest.h>
#include <aws/backup/model/StartBackupJobResult.h>
#include <aws/backup/model/StartCopyJobRequest.h>
#include <aws/backup/model/StartCopyJobResult.h>
#include <aws/backup/model/StartReportJobRequest.h>
#include <aws/backup/model/StartReportJobResult.h>
#include <aws/backup/model/StartRestoreJobRequest.h>
#include <aws/backup/model/StartRestoreJobResult.h>
#include <aws/backup/model/StopBackupJobRequest.h>
#include <aws/backup/model/StorageClass.h>
#include <aws/backup/model/TagResourceRequest.h>
#include <aws/backup/model/UntagResourceRequest.h>
#include <aws/backup/model/UpdateBackupPlanRequest.h>
#include <aws/backup/model/UpdateBackupPlanResult.h>
#include <aws/backup/model/UpdateFrameworkRequest.h>
#include <aws/backup/model/UpdateFrameworkResult.h>
#include <aws/backup/model/UpdateGlobalSettingsRequest.h>
#include <aws/backup/model/UpdateRecoveryPointIndexSettingsRequest.h>
#include <aws/backup/model/UpdateRecoveryPointIndexSettingsResult.h>
#include <aws/backup/model/UpdateRecoveryPointLifecycleRequest.h>
#include <aws/backup/model/UpdateRecoveryPointLifecycleResult.h>
#include <aws/backup/model/UpdateRegionSettingsRequest.h>
#include <aws/backup/model/UpdateReportPlanRequest.h>
#include <aws/backup/model/UpdateReportPlanResult.h>
#include <aws/backup/model/UpdateRestoreTestingPlanRequest.h>
#include <aws/backup/model/UpdateRestoreTestingPlanResult.h>
#include <aws/backup/model/UpdateRestoreTestingSelectionRequest.h>
#include <aws/backup/model/UpdateRestoreTestingSelectionResult.h>
#include <aws/backup/model/VaultState.h>
#include <aws/backup/model/VaultType.h>

using BackupIncludeTest = ::testing::Test;

TEST_F(BackupIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::Backup::BackupClient>("BackupIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
