/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/batch/BatchClient.h>
#include <aws/batch/BatchEndpointProvider.h>
#include <aws/batch/BatchEndpointRules.h>
#include <aws/batch/BatchErrorMarshaller.h>
#include <aws/batch/BatchErrors.h>
#include <aws/batch/BatchRequest.h>
#include <aws/batch/BatchServiceClientModel.h>
#include <aws/batch/Batch_EXPORTS.h>
#include <aws/batch/model/ArrayJobDependency.h>
#include <aws/batch/model/ArrayProperties.h>
#include <aws/batch/model/ArrayPropertiesDetail.h>
#include <aws/batch/model/ArrayPropertiesSummary.h>
#include <aws/batch/model/AssignPublicIp.h>
#include <aws/batch/model/AttemptContainerDetail.h>
#include <aws/batch/model/AttemptDetail.h>
#include <aws/batch/model/AttemptEcsTaskDetails.h>
#include <aws/batch/model/AttemptTaskContainerDetails.h>
#include <aws/batch/model/CEState.h>
#include <aws/batch/model/CEStatus.h>
#include <aws/batch/model/CEType.h>
#include <aws/batch/model/CRAllocationStrategy.h>
#include <aws/batch/model/CRType.h>
#include <aws/batch/model/CRUpdateAllocationStrategy.h>
#include <aws/batch/model/CancelJobRequest.h>
#include <aws/batch/model/CancelJobResult.h>
#include <aws/batch/model/ComputeEnvironmentDetail.h>
#include <aws/batch/model/ComputeEnvironmentOrder.h>
#include <aws/batch/model/ComputeResource.h>
#include <aws/batch/model/ComputeResourceUpdate.h>
#include <aws/batch/model/ConsumableResourceProperties.h>
#include <aws/batch/model/ConsumableResourceRequirement.h>
#include <aws/batch/model/ConsumableResourceSummary.h>
#include <aws/batch/model/ContainerDetail.h>
#include <aws/batch/model/ContainerOverrides.h>
#include <aws/batch/model/ContainerProperties.h>
#include <aws/batch/model/ContainerSummary.h>
#include <aws/batch/model/CreateComputeEnvironmentRequest.h>
#include <aws/batch/model/CreateComputeEnvironmentResult.h>
#include <aws/batch/model/CreateConsumableResourceRequest.h>
#include <aws/batch/model/CreateConsumableResourceResult.h>
#include <aws/batch/model/CreateJobQueueRequest.h>
#include <aws/batch/model/CreateJobQueueResult.h>
#include <aws/batch/model/CreateSchedulingPolicyRequest.h>
#include <aws/batch/model/CreateSchedulingPolicyResult.h>
#include <aws/batch/model/DeleteComputeEnvironmentRequest.h>
#include <aws/batch/model/DeleteComputeEnvironmentResult.h>
#include <aws/batch/model/DeleteConsumableResourceRequest.h>
#include <aws/batch/model/DeleteConsumableResourceResult.h>
#include <aws/batch/model/DeleteJobQueueRequest.h>
#include <aws/batch/model/DeleteJobQueueResult.h>
#include <aws/batch/model/DeleteSchedulingPolicyRequest.h>
#include <aws/batch/model/DeleteSchedulingPolicyResult.h>
#include <aws/batch/model/DeregisterJobDefinitionRequest.h>
#include <aws/batch/model/DeregisterJobDefinitionResult.h>
#include <aws/batch/model/DescribeComputeEnvironmentsRequest.h>
#include <aws/batch/model/DescribeComputeEnvironmentsResult.h>
#include <aws/batch/model/DescribeConsumableResourceRequest.h>
#include <aws/batch/model/DescribeConsumableResourceResult.h>
#include <aws/batch/model/DescribeJobDefinitionsRequest.h>
#include <aws/batch/model/DescribeJobDefinitionsResult.h>
#include <aws/batch/model/DescribeJobQueuesRequest.h>
#include <aws/batch/model/DescribeJobQueuesResult.h>
#include <aws/batch/model/DescribeJobsRequest.h>
#include <aws/batch/model/DescribeJobsResult.h>
#include <aws/batch/model/DescribeSchedulingPoliciesRequest.h>
#include <aws/batch/model/DescribeSchedulingPoliciesResult.h>
#include <aws/batch/model/Device.h>
#include <aws/batch/model/DeviceCgroupPermission.h>
#include <aws/batch/model/EFSAuthorizationConfig.h>
#include <aws/batch/model/EFSAuthorizationConfigIAM.h>
#include <aws/batch/model/EFSTransitEncryption.h>
#include <aws/batch/model/EFSVolumeConfiguration.h>
#include <aws/batch/model/Ec2Configuration.h>
#include <aws/batch/model/EcsProperties.h>
#include <aws/batch/model/EcsPropertiesDetail.h>
#include <aws/batch/model/EcsPropertiesOverride.h>
#include <aws/batch/model/EcsTaskDetails.h>
#include <aws/batch/model/EcsTaskProperties.h>
#include <aws/batch/model/EksAttemptContainerDetail.h>
#include <aws/batch/model/EksAttemptDetail.h>
#include <aws/batch/model/EksConfiguration.h>
#include <aws/batch/model/EksContainer.h>
#include <aws/batch/model/EksContainerDetail.h>
#include <aws/batch/model/EksContainerEnvironmentVariable.h>
#include <aws/batch/model/EksContainerOverride.h>
#include <aws/batch/model/EksContainerResourceRequirements.h>
#include <aws/batch/model/EksContainerSecurityContext.h>
#include <aws/batch/model/EksContainerVolumeMount.h>
#include <aws/batch/model/EksEmptyDir.h>
#include <aws/batch/model/EksHostPath.h>
#include <aws/batch/model/EksMetadata.h>
#include <aws/batch/model/EksPersistentVolumeClaim.h>
#include <aws/batch/model/EksPodProperties.h>
#include <aws/batch/model/EksPodPropertiesDetail.h>
#include <aws/batch/model/EksPodPropertiesOverride.h>
#include <aws/batch/model/EksProperties.h>
#include <aws/batch/model/EksPropertiesDetail.h>
#include <aws/batch/model/EksPropertiesOverride.h>
#include <aws/batch/model/EksSecret.h>
#include <aws/batch/model/EksVolume.h>
#include <aws/batch/model/EphemeralStorage.h>
#include <aws/batch/model/EvaluateOnExit.h>
#include <aws/batch/model/FairsharePolicy.h>
#include <aws/batch/model/FargatePlatformConfiguration.h>
#include <aws/batch/model/FirelensConfiguration.h>
#include <aws/batch/model/FirelensConfigurationType.h>
#include <aws/batch/model/FrontOfQueueDetail.h>
#include <aws/batch/model/FrontOfQueueJobSummary.h>
#include <aws/batch/model/GetJobQueueSnapshotRequest.h>
#include <aws/batch/model/GetJobQueueSnapshotResult.h>
#include <aws/batch/model/Host.h>
#include <aws/batch/model/ImagePullSecret.h>
#include <aws/batch/model/JQState.h>
#include <aws/batch/model/JQStatus.h>
#include <aws/batch/model/JobDefinition.h>
#include <aws/batch/model/JobDefinitionType.h>
#include <aws/batch/model/JobDependency.h>
#include <aws/batch/model/JobDetail.h>
#include <aws/batch/model/JobQueueDetail.h>
#include <aws/batch/model/JobStateTimeLimitAction.h>
#include <aws/batch/model/JobStateTimeLimitActionsAction.h>
#include <aws/batch/model/JobStateTimeLimitActionsState.h>
#include <aws/batch/model/JobStatus.h>
#include <aws/batch/model/JobSummary.h>
#include <aws/batch/model/JobTimeout.h>
#include <aws/batch/model/KeyValuePair.h>
#include <aws/batch/model/KeyValuesPair.h>
#include <aws/batch/model/LaunchTemplateSpecification.h>
#include <aws/batch/model/LaunchTemplateSpecificationOverride.h>
#include <aws/batch/model/LinuxParameters.h>
#include <aws/batch/model/ListConsumableResourcesRequest.h>
#include <aws/batch/model/ListConsumableResourcesResult.h>
#include <aws/batch/model/ListJobsByConsumableResourceRequest.h>
#include <aws/batch/model/ListJobsByConsumableResourceResult.h>
#include <aws/batch/model/ListJobsByConsumableResourceSummary.h>
#include <aws/batch/model/ListJobsRequest.h>
#include <aws/batch/model/ListJobsResult.h>
#include <aws/batch/model/ListSchedulingPoliciesRequest.h>
#include <aws/batch/model/ListSchedulingPoliciesResult.h>
#include <aws/batch/model/ListTagsForResourceRequest.h>
#include <aws/batch/model/ListTagsForResourceResult.h>
#include <aws/batch/model/LogConfiguration.h>
#include <aws/batch/model/LogDriver.h>
#include <aws/batch/model/MountPoint.h>
#include <aws/batch/model/NetworkConfiguration.h>
#include <aws/batch/model/NetworkInterface.h>
#include <aws/batch/model/NodeDetails.h>
#include <aws/batch/model/NodeOverrides.h>
#include <aws/batch/model/NodeProperties.h>
#include <aws/batch/model/NodePropertiesSummary.h>
#include <aws/batch/model/NodePropertyOverride.h>
#include <aws/batch/model/NodeRangeProperty.h>
#include <aws/batch/model/OrchestrationType.h>
#include <aws/batch/model/PlatformCapability.h>
#include <aws/batch/model/RegisterJobDefinitionRequest.h>
#include <aws/batch/model/RegisterJobDefinitionResult.h>
#include <aws/batch/model/RepositoryCredentials.h>
#include <aws/batch/model/ResourceRequirement.h>
#include <aws/batch/model/ResourceType.h>
#include <aws/batch/model/RetryAction.h>
#include <aws/batch/model/RetryStrategy.h>
#include <aws/batch/model/RuntimePlatform.h>
#include <aws/batch/model/SchedulingPolicyDetail.h>
#include <aws/batch/model/SchedulingPolicyListingDetail.h>
#include <aws/batch/model/Secret.h>
#include <aws/batch/model/ShareAttributes.h>
#include <aws/batch/model/SubmitJobRequest.h>
#include <aws/batch/model/SubmitJobResult.h>
#include <aws/batch/model/TagResourceRequest.h>
#include <aws/batch/model/TagResourceResult.h>
#include <aws/batch/model/TaskContainerDependency.h>
#include <aws/batch/model/TaskContainerDetails.h>
#include <aws/batch/model/TaskContainerOverrides.h>
#include <aws/batch/model/TaskContainerProperties.h>
#include <aws/batch/model/TaskPropertiesOverride.h>
#include <aws/batch/model/TerminateJobRequest.h>
#include <aws/batch/model/TerminateJobResult.h>
#include <aws/batch/model/Tmpfs.h>
#include <aws/batch/model/Ulimit.h>
#include <aws/batch/model/UntagResourceRequest.h>
#include <aws/batch/model/UntagResourceResult.h>
#include <aws/batch/model/UpdateComputeEnvironmentRequest.h>
#include <aws/batch/model/UpdateComputeEnvironmentResult.h>
#include <aws/batch/model/UpdateConsumableResourceRequest.h>
#include <aws/batch/model/UpdateConsumableResourceResult.h>
#include <aws/batch/model/UpdateJobQueueRequest.h>
#include <aws/batch/model/UpdateJobQueueResult.h>
#include <aws/batch/model/UpdatePolicy.h>
#include <aws/batch/model/UpdateSchedulingPolicyRequest.h>
#include <aws/batch/model/UpdateSchedulingPolicyResult.h>
#include <aws/batch/model/UserdataType.h>
#include <aws/batch/model/Volume.h>

using BatchIncludeTest = ::testing::Test;

TEST_F(BatchIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::Batch::BatchClient>("BatchIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
