/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/bcm-pricing-calculator/BCMPricingCalculatorClient.h>
#include <aws/bcm-pricing-calculator/BCMPricingCalculatorEndpointProvider.h>
#include <aws/bcm-pricing-calculator/BCMPricingCalculatorEndpointRules.h>
#include <aws/bcm-pricing-calculator/BCMPricingCalculatorErrorMarshaller.h>
#include <aws/bcm-pricing-calculator/BCMPricingCalculatorErrors.h>
#include <aws/bcm-pricing-calculator/BCMPricingCalculatorRequest.h>
#include <aws/bcm-pricing-calculator/BCMPricingCalculatorServiceClientModel.h>
#include <aws/bcm-pricing-calculator/BCMPricingCalculator_EXPORTS.h>
#include <aws/bcm-pricing-calculator/model/AddReservedInstanceAction.h>
#include <aws/bcm-pricing-calculator/model/AddSavingsPlanAction.h>
#include <aws/bcm-pricing-calculator/model/BatchCreateBillScenarioCommitmentModificationEntry.h>
#include <aws/bcm-pricing-calculator/model/BatchCreateBillScenarioCommitmentModificationError.h>
#include <aws/bcm-pricing-calculator/model/BatchCreateBillScenarioCommitmentModificationErrorCode.h>
#include <aws/bcm-pricing-calculator/model/BatchCreateBillScenarioCommitmentModificationItem.h>
#include <aws/bcm-pricing-calculator/model/BatchCreateBillScenarioCommitmentModificationRequest.h>
#include <aws/bcm-pricing-calculator/model/BatchCreateBillScenarioCommitmentModificationResult.h>
#include <aws/bcm-pricing-calculator/model/BatchCreateBillScenarioUsageModificationEntry.h>
#include <aws/bcm-pricing-calculator/model/BatchCreateBillScenarioUsageModificationError.h>
#include <aws/bcm-pricing-calculator/model/BatchCreateBillScenarioUsageModificationErrorCode.h>
#include <aws/bcm-pricing-calculator/model/BatchCreateBillScenarioUsageModificationItem.h>
#include <aws/bcm-pricing-calculator/model/BatchCreateBillScenarioUsageModificationRequest.h>
#include <aws/bcm-pricing-calculator/model/BatchCreateBillScenarioUsageModificationResult.h>
#include <aws/bcm-pricing-calculator/model/BatchCreateWorkloadEstimateUsageCode.h>
#include <aws/bcm-pricing-calculator/model/BatchCreateWorkloadEstimateUsageEntry.h>
#include <aws/bcm-pricing-calculator/model/BatchCreateWorkloadEstimateUsageError.h>
#include <aws/bcm-pricing-calculator/model/BatchCreateWorkloadEstimateUsageItem.h>
#include <aws/bcm-pricing-calculator/model/BatchCreateWorkloadEstimateUsageRequest.h>
#include <aws/bcm-pricing-calculator/model/BatchCreateWorkloadEstimateUsageResult.h>
#include <aws/bcm-pricing-calculator/model/BatchDeleteBillScenarioCommitmentModificationError.h>
#include <aws/bcm-pricing-calculator/model/BatchDeleteBillScenarioCommitmentModificationErrorCode.h>
#include <aws/bcm-pricing-calculator/model/BatchDeleteBillScenarioCommitmentModificationRequest.h>
#include <aws/bcm-pricing-calculator/model/BatchDeleteBillScenarioCommitmentModificationResult.h>
#include <aws/bcm-pricing-calculator/model/BatchDeleteBillScenarioUsageModificationError.h>
#include <aws/bcm-pricing-calculator/model/BatchDeleteBillScenarioUsageModificationErrorCode.h>
#include <aws/bcm-pricing-calculator/model/BatchDeleteBillScenarioUsageModificationRequest.h>
#include <aws/bcm-pricing-calculator/model/BatchDeleteBillScenarioUsageModificationResult.h>
#include <aws/bcm-pricing-calculator/model/BatchDeleteWorkloadEstimateUsageError.h>
#include <aws/bcm-pricing-calculator/model/BatchDeleteWorkloadEstimateUsageRequest.h>
#include <aws/bcm-pricing-calculator/model/BatchDeleteWorkloadEstimateUsageResult.h>
#include <aws/bcm-pricing-calculator/model/BatchUpdateBillScenarioCommitmentModificationEntry.h>
#include <aws/bcm-pricing-calculator/model/BatchUpdateBillScenarioCommitmentModificationError.h>
#include <aws/bcm-pricing-calculator/model/BatchUpdateBillScenarioCommitmentModificationErrorCode.h>
#include <aws/bcm-pricing-calculator/model/BatchUpdateBillScenarioCommitmentModificationRequest.h>
#include <aws/bcm-pricing-calculator/model/BatchUpdateBillScenarioCommitmentModificationResult.h>
#include <aws/bcm-pricing-calculator/model/BatchUpdateBillScenarioUsageModificationEntry.h>
#include <aws/bcm-pricing-calculator/model/BatchUpdateBillScenarioUsageModificationError.h>
#include <aws/bcm-pricing-calculator/model/BatchUpdateBillScenarioUsageModificationErrorCode.h>
#include <aws/bcm-pricing-calculator/model/BatchUpdateBillScenarioUsageModificationRequest.h>
#include <aws/bcm-pricing-calculator/model/BatchUpdateBillScenarioUsageModificationResult.h>
#include <aws/bcm-pricing-calculator/model/BatchUpdateWorkloadEstimateUsageEntry.h>
#include <aws/bcm-pricing-calculator/model/BatchUpdateWorkloadEstimateUsageError.h>
#include <aws/bcm-pricing-calculator/model/BatchUpdateWorkloadEstimateUsageRequest.h>
#include <aws/bcm-pricing-calculator/model/BatchUpdateWorkloadEstimateUsageResult.h>
#include <aws/bcm-pricing-calculator/model/BillEstimateCommitmentSummary.h>
#include <aws/bcm-pricing-calculator/model/BillEstimateCostSummary.h>
#include <aws/bcm-pricing-calculator/model/BillEstimateInputCommitmentModificationSummary.h>
#include <aws/bcm-pricing-calculator/model/BillEstimateInputUsageModificationSummary.h>
#include <aws/bcm-pricing-calculator/model/BillEstimateLineItemSummary.h>
#include <aws/bcm-pricing-calculator/model/BillEstimateStatus.h>
#include <aws/bcm-pricing-calculator/model/BillEstimateSummary.h>
#include <aws/bcm-pricing-calculator/model/BillInterval.h>
#include <aws/bcm-pricing-calculator/model/BillScenarioCommitmentModificationAction.h>
#include <aws/bcm-pricing-calculator/model/BillScenarioCommitmentModificationItem.h>
#include <aws/bcm-pricing-calculator/model/BillScenarioStatus.h>
#include <aws/bcm-pricing-calculator/model/BillScenarioSummary.h>
#include <aws/bcm-pricing-calculator/model/BillScenarioUsageModificationItem.h>
#include <aws/bcm-pricing-calculator/model/ConflictException.h>
#include <aws/bcm-pricing-calculator/model/CostAmount.h>
#include <aws/bcm-pricing-calculator/model/CostDifference.h>
#include <aws/bcm-pricing-calculator/model/CreateBillEstimateRequest.h>
#include <aws/bcm-pricing-calculator/model/CreateBillEstimateResult.h>
#include <aws/bcm-pricing-calculator/model/CreateBillScenarioRequest.h>
#include <aws/bcm-pricing-calculator/model/CreateBillScenarioResult.h>
#include <aws/bcm-pricing-calculator/model/CreateWorkloadEstimateRequest.h>
#include <aws/bcm-pricing-calculator/model/CreateWorkloadEstimateResult.h>
#include <aws/bcm-pricing-calculator/model/CurrencyCode.h>
#include <aws/bcm-pricing-calculator/model/DeleteBillEstimateRequest.h>
#include <aws/bcm-pricing-calculator/model/DeleteBillEstimateResult.h>
#include <aws/bcm-pricing-calculator/model/DeleteBillScenarioRequest.h>
#include <aws/bcm-pricing-calculator/model/DeleteBillScenarioResult.h>
#include <aws/bcm-pricing-calculator/model/DeleteWorkloadEstimateRequest.h>
#include <aws/bcm-pricing-calculator/model/DeleteWorkloadEstimateResult.h>
#include <aws/bcm-pricing-calculator/model/Expression.h>
#include <aws/bcm-pricing-calculator/model/ExpressionFilter.h>
#include <aws/bcm-pricing-calculator/model/FilterTimestamp.h>
#include <aws/bcm-pricing-calculator/model/GetBillEstimateRequest.h>
#include <aws/bcm-pricing-calculator/model/GetBillEstimateResult.h>
#include <aws/bcm-pricing-calculator/model/GetBillScenarioRequest.h>
#include <aws/bcm-pricing-calculator/model/GetBillScenarioResult.h>
#include <aws/bcm-pricing-calculator/model/GetPreferencesRequest.h>
#include <aws/bcm-pricing-calculator/model/GetPreferencesResult.h>
#include <aws/bcm-pricing-calculator/model/GetWorkloadEstimateRequest.h>
#include <aws/bcm-pricing-calculator/model/GetWorkloadEstimateResult.h>
#include <aws/bcm-pricing-calculator/model/HistoricalUsageEntity.h>
#include <aws/bcm-pricing-calculator/model/InternalServerException.h>
#include <aws/bcm-pricing-calculator/model/ListBillEstimateCommitmentsRequest.h>
#include <aws/bcm-pricing-calculator/model/ListBillEstimateCommitmentsResult.h>
#include <aws/bcm-pricing-calculator/model/ListBillEstimateInputCommitmentModificationsRequest.h>
#include <aws/bcm-pricing-calculator/model/ListBillEstimateInputCommitmentModificationsResult.h>
#include <aws/bcm-pricing-calculator/model/ListBillEstimateInputUsageModificationsRequest.h>
#include <aws/bcm-pricing-calculator/model/ListBillEstimateInputUsageModificationsResult.h>
#include <aws/bcm-pricing-calculator/model/ListBillEstimateLineItemsFilter.h>
#include <aws/bcm-pricing-calculator/model/ListBillEstimateLineItemsFilterName.h>
#include <aws/bcm-pricing-calculator/model/ListBillEstimateLineItemsRequest.h>
#include <aws/bcm-pricing-calculator/model/ListBillEstimateLineItemsResult.h>
#include <aws/bcm-pricing-calculator/model/ListBillEstimatesFilter.h>
#include <aws/bcm-pricing-calculator/model/ListBillEstimatesFilterName.h>
#include <aws/bcm-pricing-calculator/model/ListBillEstimatesRequest.h>
#include <aws/bcm-pricing-calculator/model/ListBillEstimatesResult.h>
#include <aws/bcm-pricing-calculator/model/ListBillScenarioCommitmentModificationsRequest.h>
#include <aws/bcm-pricing-calculator/model/ListBillScenarioCommitmentModificationsResult.h>
#include <aws/bcm-pricing-calculator/model/ListBillScenarioUsageModificationsRequest.h>
#include <aws/bcm-pricing-calculator/model/ListBillScenarioUsageModificationsResult.h>
#include <aws/bcm-pricing-calculator/model/ListBillScenariosFilter.h>
#include <aws/bcm-pricing-calculator/model/ListBillScenariosFilterName.h>
#include <aws/bcm-pricing-calculator/model/ListBillScenariosRequest.h>
#include <aws/bcm-pricing-calculator/model/ListBillScenariosResult.h>
#include <aws/bcm-pricing-calculator/model/ListTagsForResourceRequest.h>
#include <aws/bcm-pricing-calculator/model/ListTagsForResourceResult.h>
#include <aws/bcm-pricing-calculator/model/ListUsageFilter.h>
#include <aws/bcm-pricing-calculator/model/ListUsageFilterName.h>
#include <aws/bcm-pricing-calculator/model/ListWorkloadEstimateUsageRequest.h>
#include <aws/bcm-pricing-calculator/model/ListWorkloadEstimateUsageResult.h>
#include <aws/bcm-pricing-calculator/model/ListWorkloadEstimatesFilter.h>
#include <aws/bcm-pricing-calculator/model/ListWorkloadEstimatesFilterName.h>
#include <aws/bcm-pricing-calculator/model/ListWorkloadEstimatesRequest.h>
#include <aws/bcm-pricing-calculator/model/ListWorkloadEstimatesResult.h>
#include <aws/bcm-pricing-calculator/model/MatchOption.h>
#include <aws/bcm-pricing-calculator/model/NegateReservedInstanceAction.h>
#include <aws/bcm-pricing-calculator/model/NegateSavingsPlanAction.h>
#include <aws/bcm-pricing-calculator/model/PurchaseAgreementType.h>
#include <aws/bcm-pricing-calculator/model/RateType.h>
#include <aws/bcm-pricing-calculator/model/ResourceNotFoundException.h>
#include <aws/bcm-pricing-calculator/model/ServiceQuotaExceededException.h>
#include <aws/bcm-pricing-calculator/model/TagResourceRequest.h>
#include <aws/bcm-pricing-calculator/model/TagResourceResult.h>
#include <aws/bcm-pricing-calculator/model/ThrottlingException.h>
#include <aws/bcm-pricing-calculator/model/UntagResourceRequest.h>
#include <aws/bcm-pricing-calculator/model/UntagResourceResult.h>
#include <aws/bcm-pricing-calculator/model/UpdateBillEstimateRequest.h>
#include <aws/bcm-pricing-calculator/model/UpdateBillEstimateResult.h>
#include <aws/bcm-pricing-calculator/model/UpdateBillScenarioRequest.h>
#include <aws/bcm-pricing-calculator/model/UpdateBillScenarioResult.h>
#include <aws/bcm-pricing-calculator/model/UpdatePreferencesRequest.h>
#include <aws/bcm-pricing-calculator/model/UpdatePreferencesResult.h>
#include <aws/bcm-pricing-calculator/model/UpdateWorkloadEstimateRequest.h>
#include <aws/bcm-pricing-calculator/model/UpdateWorkloadEstimateResult.h>
#include <aws/bcm-pricing-calculator/model/UsageAmount.h>
#include <aws/bcm-pricing-calculator/model/UsageQuantity.h>
#include <aws/bcm-pricing-calculator/model/UsageQuantityResult.h>
#include <aws/bcm-pricing-calculator/model/ValidationException.h>
#include <aws/bcm-pricing-calculator/model/ValidationExceptionField.h>
#include <aws/bcm-pricing-calculator/model/ValidationExceptionReason.h>
#include <aws/bcm-pricing-calculator/model/WorkloadEstimateCostStatus.h>
#include <aws/bcm-pricing-calculator/model/WorkloadEstimateRateType.h>
#include <aws/bcm-pricing-calculator/model/WorkloadEstimateStatus.h>
#include <aws/bcm-pricing-calculator/model/WorkloadEstimateSummary.h>
#include <aws/bcm-pricing-calculator/model/WorkloadEstimateUpdateUsageErrorCode.h>
#include <aws/bcm-pricing-calculator/model/WorkloadEstimateUsageItem.h>
#include <aws/bcm-pricing-calculator/model/WorkloadEstimateUsageQuantity.h>

using BCMPricingCalculatorIncludeTest = ::testing::Test;

TEST_F(BCMPricingCalculatorIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::BCMPricingCalculator::BCMPricingCalculatorClient>("BCMPricingCalculatorIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
