/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/bedrock-agent/BedrockAgentClient.h>
#include <aws/bedrock-agent/BedrockAgentEndpointProvider.h>
#include <aws/bedrock-agent/BedrockAgentEndpointRules.h>
#include <aws/bedrock-agent/BedrockAgentErrorMarshaller.h>
#include <aws/bedrock-agent/BedrockAgentErrors.h>
#include <aws/bedrock-agent/BedrockAgentRequest.h>
#include <aws/bedrock-agent/BedrockAgentServiceClientModel.h>
#include <aws/bedrock-agent/BedrockAgent_EXPORTS.h>
#include <aws/bedrock-agent/model/APISchema.h>
#include <aws/bedrock-agent/model/ActionGroupExecutor.h>
#include <aws/bedrock-agent/model/ActionGroupSignature.h>
#include <aws/bedrock-agent/model/ActionGroupState.h>
#include <aws/bedrock-agent/model/ActionGroupSummary.h>
#include <aws/bedrock-agent/model/Agent.h>
#include <aws/bedrock-agent/model/AgentActionGroup.h>
#include <aws/bedrock-agent/model/AgentAlias.h>
#include <aws/bedrock-agent/model/AgentAliasHistoryEvent.h>
#include <aws/bedrock-agent/model/AgentAliasRoutingConfigurationListItem.h>
#include <aws/bedrock-agent/model/AgentAliasStatus.h>
#include <aws/bedrock-agent/model/AgentAliasSummary.h>
#include <aws/bedrock-agent/model/AgentCollaboration.h>
#include <aws/bedrock-agent/model/AgentCollaborator.h>
#include <aws/bedrock-agent/model/AgentCollaboratorSummary.h>
#include <aws/bedrock-agent/model/AgentDescriptor.h>
#include <aws/bedrock-agent/model/AgentFlowNodeConfiguration.h>
#include <aws/bedrock-agent/model/AgentKnowledgeBase.h>
#include <aws/bedrock-agent/model/AgentKnowledgeBaseSummary.h>
#include <aws/bedrock-agent/model/AgentStatus.h>
#include <aws/bedrock-agent/model/AgentSummary.h>
#include <aws/bedrock-agent/model/AgentVersion.h>
#include <aws/bedrock-agent/model/AgentVersionSummary.h>
#include <aws/bedrock-agent/model/AliasInvocationState.h>
#include <aws/bedrock-agent/model/AnyToolChoice.h>
#include <aws/bedrock-agent/model/AssociateAgentCollaboratorRequest.h>
#include <aws/bedrock-agent/model/AssociateAgentCollaboratorResult.h>
#include <aws/bedrock-agent/model/AssociateAgentKnowledgeBaseRequest.h>
#include <aws/bedrock-agent/model/AssociateAgentKnowledgeBaseResult.h>
#include <aws/bedrock-agent/model/AutoToolChoice.h>
#include <aws/bedrock-agent/model/BedrockDataAutomationConfiguration.h>
#include <aws/bedrock-agent/model/BedrockEmbeddingModelConfiguration.h>
#include <aws/bedrock-agent/model/BedrockFoundationModelConfiguration.h>
#include <aws/bedrock-agent/model/BedrockFoundationModelContextEnrichmentConfiguration.h>
#include <aws/bedrock-agent/model/ByteContentDoc.h>
#include <aws/bedrock-agent/model/CachePointBlock.h>
#include <aws/bedrock-agent/model/CachePointType.h>
#include <aws/bedrock-agent/model/ChatPromptTemplateConfiguration.h>
#include <aws/bedrock-agent/model/ChunkingConfiguration.h>
#include <aws/bedrock-agent/model/ChunkingStrategy.h>
#include <aws/bedrock-agent/model/CollectorFlowNodeConfiguration.h>
#include <aws/bedrock-agent/model/ConcurrencyType.h>
#include <aws/bedrock-agent/model/ConditionFlowNodeConfiguration.h>
#include <aws/bedrock-agent/model/ConfluenceAuthType.h>
#include <aws/bedrock-agent/model/ConfluenceCrawlerConfiguration.h>
#include <aws/bedrock-agent/model/ConfluenceDataSourceConfiguration.h>
#include <aws/bedrock-agent/model/ConfluenceHostType.h>
#include <aws/bedrock-agent/model/ConfluenceSourceConfiguration.h>
#include <aws/bedrock-agent/model/ContentBlock.h>
#include <aws/bedrock-agent/model/ContentDataSourceType.h>
#include <aws/bedrock-agent/model/ContextEnrichmentConfiguration.h>
#include <aws/bedrock-agent/model/ContextEnrichmentType.h>
#include <aws/bedrock-agent/model/ConversationRole.h>
#include <aws/bedrock-agent/model/CrawlFilterConfiguration.h>
#include <aws/bedrock-agent/model/CrawlFilterConfigurationType.h>
#include <aws/bedrock-agent/model/CreateAgentActionGroupRequest.h>
#include <aws/bedrock-agent/model/CreateAgentActionGroupResult.h>
#include <aws/bedrock-agent/model/CreateAgentAliasRequest.h>
#include <aws/bedrock-agent/model/CreateAgentAliasResult.h>
#include <aws/bedrock-agent/model/CreateAgentRequest.h>
#include <aws/bedrock-agent/model/CreateAgentResult.h>
#include <aws/bedrock-agent/model/CreateDataSourceRequest.h>
#include <aws/bedrock-agent/model/CreateDataSourceResult.h>
#include <aws/bedrock-agent/model/CreateFlowAliasRequest.h>
#include <aws/bedrock-agent/model/CreateFlowAliasResult.h>
#include <aws/bedrock-agent/model/CreateFlowRequest.h>
#include <aws/bedrock-agent/model/CreateFlowResult.h>
#include <aws/bedrock-agent/model/CreateFlowVersionRequest.h>
#include <aws/bedrock-agent/model/CreateFlowVersionResult.h>
#include <aws/bedrock-agent/model/CreateKnowledgeBaseRequest.h>
#include <aws/bedrock-agent/model/CreateKnowledgeBaseResult.h>
#include <aws/bedrock-agent/model/CreatePromptRequest.h>
#include <aws/bedrock-agent/model/CreatePromptResult.h>
#include <aws/bedrock-agent/model/CreatePromptVersionRequest.h>
#include <aws/bedrock-agent/model/CreatePromptVersionResult.h>
#include <aws/bedrock-agent/model/CreationMode.h>
#include <aws/bedrock-agent/model/CuratedQuery.h>
#include <aws/bedrock-agent/model/CustomContent.h>
#include <aws/bedrock-agent/model/CustomControlMethod.h>
#include <aws/bedrock-agent/model/CustomDocumentIdentifier.h>
#include <aws/bedrock-agent/model/CustomOrchestration.h>
#include <aws/bedrock-agent/model/CustomS3Location.h>
#include <aws/bedrock-agent/model/CustomSourceType.h>
#include <aws/bedrock-agent/model/CustomTransformationConfiguration.h>
#include <aws/bedrock-agent/model/CyclicConnectionFlowValidationDetails.h>
#include <aws/bedrock-agent/model/DataDeletionPolicy.h>
#include <aws/bedrock-agent/model/DataSource.h>
#include <aws/bedrock-agent/model/DataSourceConfiguration.h>
#include <aws/bedrock-agent/model/DataSourceStatus.h>
#include <aws/bedrock-agent/model/DataSourceSummary.h>
#include <aws/bedrock-agent/model/DataSourceType.h>
#include <aws/bedrock-agent/model/DeleteAgentActionGroupRequest.h>
#include <aws/bedrock-agent/model/DeleteAgentActionGroupResult.h>
#include <aws/bedrock-agent/model/DeleteAgentAliasRequest.h>
#include <aws/bedrock-agent/model/DeleteAgentAliasResult.h>
#include <aws/bedrock-agent/model/DeleteAgentRequest.h>
#include <aws/bedrock-agent/model/DeleteAgentResult.h>
#include <aws/bedrock-agent/model/DeleteAgentVersionRequest.h>
#include <aws/bedrock-agent/model/DeleteAgentVersionResult.h>
#include <aws/bedrock-agent/model/DeleteDataSourceRequest.h>
#include <aws/bedrock-agent/model/DeleteDataSourceResult.h>
#include <aws/bedrock-agent/model/DeleteFlowAliasRequest.h>
#include <aws/bedrock-agent/model/DeleteFlowAliasResult.h>
#include <aws/bedrock-agent/model/DeleteFlowRequest.h>
#include <aws/bedrock-agent/model/DeleteFlowResult.h>
#include <aws/bedrock-agent/model/DeleteFlowVersionRequest.h>
#include <aws/bedrock-agent/model/DeleteFlowVersionResult.h>
#include <aws/bedrock-agent/model/DeleteKnowledgeBaseDocumentsRequest.h>
#include <aws/bedrock-agent/model/DeleteKnowledgeBaseDocumentsResult.h>
#include <aws/bedrock-agent/model/DeleteKnowledgeBaseRequest.h>
#include <aws/bedrock-agent/model/DeleteKnowledgeBaseResult.h>
#include <aws/bedrock-agent/model/DeletePromptRequest.h>
#include <aws/bedrock-agent/model/DeletePromptResult.h>
#include <aws/bedrock-agent/model/DisassociateAgentCollaboratorRequest.h>
#include <aws/bedrock-agent/model/DisassociateAgentCollaboratorResult.h>
#include <aws/bedrock-agent/model/DisassociateAgentKnowledgeBaseRequest.h>
#include <aws/bedrock-agent/model/DisassociateAgentKnowledgeBaseResult.h>
#include <aws/bedrock-agent/model/DocumentContent.h>
#include <aws/bedrock-agent/model/DocumentIdentifier.h>
#include <aws/bedrock-agent/model/DocumentMetadata.h>
#include <aws/bedrock-agent/model/DocumentStatus.h>
#include <aws/bedrock-agent/model/DuplicateConditionExpressionFlowValidationDetails.h>
#include <aws/bedrock-agent/model/DuplicateConnectionsFlowValidationDetails.h>
#include <aws/bedrock-agent/model/EmbeddingDataType.h>
#include <aws/bedrock-agent/model/EmbeddingModelConfiguration.h>
#include <aws/bedrock-agent/model/EnrichmentStrategyConfiguration.h>
#include <aws/bedrock-agent/model/EnrichmentStrategyMethod.h>
#include <aws/bedrock-agent/model/FieldForReranking.h>
#include <aws/bedrock-agent/model/FixedSizeChunkingConfiguration.h>
#include <aws/bedrock-agent/model/FlowAliasConcurrencyConfiguration.h>
#include <aws/bedrock-agent/model/FlowAliasRoutingConfigurationListItem.h>
#include <aws/bedrock-agent/model/FlowAliasSummary.h>
#include <aws/bedrock-agent/model/FlowCondition.h>
#include <aws/bedrock-agent/model/FlowConditionalConnectionConfiguration.h>
#include <aws/bedrock-agent/model/FlowConnection.h>
#include <aws/bedrock-agent/model/FlowConnectionConfiguration.h>
#include <aws/bedrock-agent/model/FlowConnectionType.h>
#include <aws/bedrock-agent/model/FlowDataConnectionConfiguration.h>
#include <aws/bedrock-agent/model/FlowDefinition.h>
#include <aws/bedrock-agent/model/FlowNode.h>
#include <aws/bedrock-agent/model/FlowNodeConfiguration.h>
#include <aws/bedrock-agent/model/FlowNodeIODataType.h>
#include <aws/bedrock-agent/model/FlowNodeInput.h>
#include <aws/bedrock-agent/model/FlowNodeInputCategory.h>
#include <aws/bedrock-agent/model/FlowNodeOutput.h>
#include <aws/bedrock-agent/model/FlowNodeType.h>
#include <aws/bedrock-agent/model/FlowStatus.h>
#include <aws/bedrock-agent/model/FlowSummary.h>
#include <aws/bedrock-agent/model/FlowValidation.h>
#include <aws/bedrock-agent/model/FlowValidationDetails.h>
#include <aws/bedrock-agent/model/FlowValidationSeverity.h>
#include <aws/bedrock-agent/model/FlowValidationType.h>
#include <aws/bedrock-agent/model/FlowVersionSummary.h>
#include <aws/bedrock-agent/model/Function.h>
#include <aws/bedrock-agent/model/FunctionSchema.h>
#include <aws/bedrock-agent/model/GetAgentActionGroupRequest.h>
#include <aws/bedrock-agent/model/GetAgentActionGroupResult.h>
#include <aws/bedrock-agent/model/GetAgentAliasRequest.h>
#include <aws/bedrock-agent/model/GetAgentAliasResult.h>
#include <aws/bedrock-agent/model/GetAgentCollaboratorRequest.h>
#include <aws/bedrock-agent/model/GetAgentCollaboratorResult.h>
#include <aws/bedrock-agent/model/GetAgentKnowledgeBaseRequest.h>
#include <aws/bedrock-agent/model/GetAgentKnowledgeBaseResult.h>
#include <aws/bedrock-agent/model/GetAgentRequest.h>
#include <aws/bedrock-agent/model/GetAgentResult.h>
#include <aws/bedrock-agent/model/GetAgentVersionRequest.h>
#include <aws/bedrock-agent/model/GetAgentVersionResult.h>
#include <aws/bedrock-agent/model/GetDataSourceRequest.h>
#include <aws/bedrock-agent/model/GetDataSourceResult.h>
#include <aws/bedrock-agent/model/GetFlowAliasRequest.h>
#include <aws/bedrock-agent/model/GetFlowAliasResult.h>
#include <aws/bedrock-agent/model/GetFlowRequest.h>
#include <aws/bedrock-agent/model/GetFlowResult.h>
#include <aws/bedrock-agent/model/GetFlowVersionRequest.h>
#include <aws/bedrock-agent/model/GetFlowVersionResult.h>
#include <aws/bedrock-agent/model/GetIngestionJobRequest.h>
#include <aws/bedrock-agent/model/GetIngestionJobResult.h>
#include <aws/bedrock-agent/model/GetKnowledgeBaseDocumentsRequest.h>
#include <aws/bedrock-agent/model/GetKnowledgeBaseDocumentsResult.h>
#include <aws/bedrock-agent/model/GetKnowledgeBaseRequest.h>
#include <aws/bedrock-agent/model/GetKnowledgeBaseResult.h>
#include <aws/bedrock-agent/model/GetPromptRequest.h>
#include <aws/bedrock-agent/model/GetPromptResult.h>
#include <aws/bedrock-agent/model/GuardrailConfiguration.h>
#include <aws/bedrock-agent/model/HierarchicalChunkingConfiguration.h>
#include <aws/bedrock-agent/model/HierarchicalChunkingLevelConfiguration.h>
#include <aws/bedrock-agent/model/IncludeExclude.h>
#include <aws/bedrock-agent/model/IncompatibleConnectionDataTypeFlowValidationDetails.h>
#include <aws/bedrock-agent/model/IncompatibleLoopNodeType.h>
#include <aws/bedrock-agent/model/InferenceConfiguration.h>
#include <aws/bedrock-agent/model/IngestKnowledgeBaseDocumentsRequest.h>
#include <aws/bedrock-agent/model/IngestKnowledgeBaseDocumentsResult.h>
#include <aws/bedrock-agent/model/IngestionJob.h>
#include <aws/bedrock-agent/model/IngestionJobFilter.h>
#include <aws/bedrock-agent/model/IngestionJobFilterAttribute.h>
#include <aws/bedrock-agent/model/IngestionJobFilterOperator.h>
#include <aws/bedrock-agent/model/IngestionJobSortBy.h>
#include <aws/bedrock-agent/model/IngestionJobSortByAttribute.h>
#include <aws/bedrock-agent/model/IngestionJobStatistics.h>
#include <aws/bedrock-agent/model/IngestionJobStatus.h>
#include <aws/bedrock-agent/model/IngestionJobSummary.h>
#include <aws/bedrock-agent/model/InlineCodeFlowNodeConfiguration.h>
#include <aws/bedrock-agent/model/InlineContent.h>
#include <aws/bedrock-agent/model/InlineContentType.h>
#include <aws/bedrock-agent/model/InputFlowNodeConfiguration.h>
#include <aws/bedrock-agent/model/IntermediateStorage.h>
#include <aws/bedrock-agent/model/InvalidLoopBoundaryFlowValidationDetails.h>
#include <aws/bedrock-agent/model/IteratorFlowNodeConfiguration.h>
#include <aws/bedrock-agent/model/KendraKnowledgeBaseConfiguration.h>
#include <aws/bedrock-agent/model/KnowledgeBase.h>
#include <aws/bedrock-agent/model/KnowledgeBaseConfiguration.h>
#include <aws/bedrock-agent/model/KnowledgeBaseDocument.h>
#include <aws/bedrock-agent/model/KnowledgeBaseDocumentDetail.h>
#include <aws/bedrock-agent/model/KnowledgeBaseFlowNodeConfiguration.h>
#include <aws/bedrock-agent/model/KnowledgeBaseOrchestrationConfiguration.h>
#include <aws/bedrock-agent/model/KnowledgeBasePromptTemplate.h>
#include <aws/bedrock-agent/model/KnowledgeBaseState.h>
#include <aws/bedrock-agent/model/KnowledgeBaseStatus.h>
#include <aws/bedrock-agent/model/KnowledgeBaseStorageType.h>
#include <aws/bedrock-agent/model/KnowledgeBaseSummary.h>
#include <aws/bedrock-agent/model/KnowledgeBaseType.h>
#include <aws/bedrock-agent/model/LambdaFunctionFlowNodeConfiguration.h>
#include <aws/bedrock-agent/model/LexFlowNodeConfiguration.h>
#include <aws/bedrock-agent/model/ListAgentActionGroupsRequest.h>
#include <aws/bedrock-agent/model/ListAgentActionGroupsResult.h>
#include <aws/bedrock-agent/model/ListAgentAliasesRequest.h>
#include <aws/bedrock-agent/model/ListAgentAliasesResult.h>
#include <aws/bedrock-agent/model/ListAgentCollaboratorsRequest.h>
#include <aws/bedrock-agent/model/ListAgentCollaboratorsResult.h>
#include <aws/bedrock-agent/model/ListAgentKnowledgeBasesRequest.h>
#include <aws/bedrock-agent/model/ListAgentKnowledgeBasesResult.h>
#include <aws/bedrock-agent/model/ListAgentVersionsRequest.h>
#include <aws/bedrock-agent/model/ListAgentVersionsResult.h>
#include <aws/bedrock-agent/model/ListAgentsRequest.h>
#include <aws/bedrock-agent/model/ListAgentsResult.h>
#include <aws/bedrock-agent/model/ListDataSourcesRequest.h>
#include <aws/bedrock-agent/model/ListDataSourcesResult.h>
#include <aws/bedrock-agent/model/ListFlowAliasesRequest.h>
#include <aws/bedrock-agent/model/ListFlowAliasesResult.h>
#include <aws/bedrock-agent/model/ListFlowVersionsRequest.h>
#include <aws/bedrock-agent/model/ListFlowVersionsResult.h>
#include <aws/bedrock-agent/model/ListFlowsRequest.h>
#include <aws/bedrock-agent/model/ListFlowsResult.h>
#include <aws/bedrock-agent/model/ListIngestionJobsRequest.h>
#include <aws/bedrock-agent/model/ListIngestionJobsResult.h>
#include <aws/bedrock-agent/model/ListKnowledgeBaseDocumentsRequest.h>
#include <aws/bedrock-agent/model/ListKnowledgeBaseDocumentsResult.h>
#include <aws/bedrock-agent/model/ListKnowledgeBasesRequest.h>
#include <aws/bedrock-agent/model/ListKnowledgeBasesResult.h>
#include <aws/bedrock-agent/model/ListPromptsRequest.h>
#include <aws/bedrock-agent/model/ListPromptsResult.h>
#include <aws/bedrock-agent/model/ListTagsForResourceRequest.h>
#include <aws/bedrock-agent/model/ListTagsForResourceResult.h>
#include <aws/bedrock-agent/model/LoopControllerFlowNodeConfiguration.h>
#include <aws/bedrock-agent/model/LoopFlowNodeConfiguration.h>
#include <aws/bedrock-agent/model/LoopIncompatibleNodeTypeFlowValidationDetails.h>
#include <aws/bedrock-agent/model/LoopInputFlowNodeConfiguration.h>
#include <aws/bedrock-agent/model/MalformedConditionExpressionFlowValidationDetails.h>
#include <aws/bedrock-agent/model/MalformedNodeInputExpressionFlowValidationDetails.h>
#include <aws/bedrock-agent/model/MemoryConfiguration.h>
#include <aws/bedrock-agent/model/MemoryType.h>
#include <aws/bedrock-agent/model/Message.h>
#include <aws/bedrock-agent/model/MetadataAttribute.h>
#include <aws/bedrock-agent/model/MetadataAttributeValue.h>
#include <aws/bedrock-agent/model/MetadataConfigurationForReranking.h>
#include <aws/bedrock-agent/model/MetadataSourceType.h>
#include <aws/bedrock-agent/model/MetadataValueType.h>
#include <aws/bedrock-agent/model/MismatchedNodeInputTypeFlowValidationDetails.h>
#include <aws/bedrock-agent/model/MismatchedNodeOutputTypeFlowValidationDetails.h>
#include <aws/bedrock-agent/model/MissingConnectionConfigurationFlowValidationDetails.h>
#include <aws/bedrock-agent/model/MissingDefaultConditionFlowValidationDetails.h>
#include <aws/bedrock-agent/model/MissingEndingNodesFlowValidationDetails.h>
#include <aws/bedrock-agent/model/MissingLoopControllerNodeFlowValidationDetails.h>
#include <aws/bedrock-agent/model/MissingLoopInputNodeFlowValidationDetails.h>
#include <aws/bedrock-agent/model/MissingNodeConfigurationFlowValidationDetails.h>
#include <aws/bedrock-agent/model/MissingNodeInputFlowValidationDetails.h>
#include <aws/bedrock-agent/model/MissingNodeOutputFlowValidationDetails.h>
#include <aws/bedrock-agent/model/MissingStartingNodesFlowValidationDetails.h>
#include <aws/bedrock-agent/model/MongoDbAtlasConfiguration.h>
#include <aws/bedrock-agent/model/MongoDbAtlasFieldMapping.h>
#include <aws/bedrock-agent/model/MultipleLoopControllerNodesFlowValidationDetails.h>
#include <aws/bedrock-agent/model/MultipleLoopInputNodesFlowValidationDetails.h>
#include <aws/bedrock-agent/model/MultipleNodeInputConnectionsFlowValidationDetails.h>
#include <aws/bedrock-agent/model/NeptuneAnalyticsConfiguration.h>
#include <aws/bedrock-agent/model/NeptuneAnalyticsFieldMapping.h>
#include <aws/bedrock-agent/model/OpenSearchManagedClusterConfiguration.h>
#include <aws/bedrock-agent/model/OpenSearchManagedClusterFieldMapping.h>
#include <aws/bedrock-agent/model/OpenSearchServerlessConfiguration.h>
#include <aws/bedrock-agent/model/OpenSearchServerlessFieldMapping.h>
#include <aws/bedrock-agent/model/OrchestrationExecutor.h>
#include <aws/bedrock-agent/model/OrchestrationType.h>
#include <aws/bedrock-agent/model/OutputFlowNodeConfiguration.h>
#include <aws/bedrock-agent/model/ParameterDetail.h>
#include <aws/bedrock-agent/model/ParsingConfiguration.h>
#include <aws/bedrock-agent/model/ParsingModality.h>
#include <aws/bedrock-agent/model/ParsingPrompt.h>
#include <aws/bedrock-agent/model/ParsingStrategy.h>
#include <aws/bedrock-agent/model/PatternObjectFilter.h>
#include <aws/bedrock-agent/model/PatternObjectFilterConfiguration.h>
#include <aws/bedrock-agent/model/PerformanceConfigLatency.h>
#include <aws/bedrock-agent/model/PerformanceConfiguration.h>
#include <aws/bedrock-agent/model/PineconeConfiguration.h>
#include <aws/bedrock-agent/model/PineconeFieldMapping.h>
#include <aws/bedrock-agent/model/PrepareAgentRequest.h>
#include <aws/bedrock-agent/model/PrepareAgentResult.h>
#include <aws/bedrock-agent/model/PrepareFlowRequest.h>
#include <aws/bedrock-agent/model/PrepareFlowResult.h>
#include <aws/bedrock-agent/model/PromptAgentResource.h>
#include <aws/bedrock-agent/model/PromptConfiguration.h>
#include <aws/bedrock-agent/model/PromptFlowNodeConfiguration.h>
#include <aws/bedrock-agent/model/PromptFlowNodeInlineConfiguration.h>
#include <aws/bedrock-agent/model/PromptFlowNodeResourceConfiguration.h>
#include <aws/bedrock-agent/model/PromptFlowNodeSourceConfiguration.h>
#include <aws/bedrock-agent/model/PromptGenAiResource.h>
#include <aws/bedrock-agent/model/PromptInferenceConfiguration.h>
#include <aws/bedrock-agent/model/PromptInputVariable.h>
#include <aws/bedrock-agent/model/PromptMetadataEntry.h>
#include <aws/bedrock-agent/model/PromptModelInferenceConfiguration.h>
#include <aws/bedrock-agent/model/PromptOverrideConfiguration.h>
#include <aws/bedrock-agent/model/PromptState.h>
#include <aws/bedrock-agent/model/PromptSummary.h>
#include <aws/bedrock-agent/model/PromptTemplateConfiguration.h>
#include <aws/bedrock-agent/model/PromptTemplateType.h>
#include <aws/bedrock-agent/model/PromptType.h>
#include <aws/bedrock-agent/model/PromptVariant.h>
#include <aws/bedrock-agent/model/QueryEngineType.h>
#include <aws/bedrock-agent/model/QueryGenerationColumn.h>
#include <aws/bedrock-agent/model/QueryGenerationConfiguration.h>
#include <aws/bedrock-agent/model/QueryGenerationContext.h>
#include <aws/bedrock-agent/model/QueryGenerationTable.h>
#include <aws/bedrock-agent/model/RdsConfiguration.h>
#include <aws/bedrock-agent/model/RdsFieldMapping.h>
#include <aws/bedrock-agent/model/RedisEnterpriseCloudConfiguration.h>
#include <aws/bedrock-agent/model/RedisEnterpriseCloudFieldMapping.h>
#include <aws/bedrock-agent/model/RedshiftConfiguration.h>
#include <aws/bedrock-agent/model/RedshiftProvisionedAuthConfiguration.h>
#include <aws/bedrock-agent/model/RedshiftProvisionedAuthType.h>
#include <aws/bedrock-agent/model/RedshiftProvisionedConfiguration.h>
#include <aws/bedrock-agent/model/RedshiftQueryEngineAwsDataCatalogStorageConfiguration.h>
#include <aws/bedrock-agent/model/RedshiftQueryEngineConfiguration.h>
#include <aws/bedrock-agent/model/RedshiftQueryEngineRedshiftStorageConfiguration.h>
#include <aws/bedrock-agent/model/RedshiftQueryEngineStorageConfiguration.h>
#include <aws/bedrock-agent/model/RedshiftQueryEngineStorageType.h>
#include <aws/bedrock-agent/model/RedshiftQueryEngineType.h>
#include <aws/bedrock-agent/model/RedshiftServerlessAuthConfiguration.h>
#include <aws/bedrock-agent/model/RedshiftServerlessAuthType.h>
#include <aws/bedrock-agent/model/RedshiftServerlessConfiguration.h>
#include <aws/bedrock-agent/model/RelayConversationHistory.h>
#include <aws/bedrock-agent/model/RequireConfirmation.h>
#include <aws/bedrock-agent/model/RerankingMetadataSelectionMode.h>
#include <aws/bedrock-agent/model/RerankingMetadataSelectiveModeConfiguration.h>
#include <aws/bedrock-agent/model/RetrievalFlowNodeConfiguration.h>
#include <aws/bedrock-agent/model/RetrievalFlowNodeS3Configuration.h>
#include <aws/bedrock-agent/model/RetrievalFlowNodeServiceConfiguration.h>
#include <aws/bedrock-agent/model/S3Content.h>
#include <aws/bedrock-agent/model/S3DataSourceConfiguration.h>
#include <aws/bedrock-agent/model/S3Identifier.h>
#include <aws/bedrock-agent/model/S3Location.h>
#include <aws/bedrock-agent/model/SalesforceAuthType.h>
#include <aws/bedrock-agent/model/SalesforceCrawlerConfiguration.h>
#include <aws/bedrock-agent/model/SalesforceDataSourceConfiguration.h>
#include <aws/bedrock-agent/model/SalesforceSourceConfiguration.h>
#include <aws/bedrock-agent/model/SeedUrl.h>
#include <aws/bedrock-agent/model/SemanticChunkingConfiguration.h>
#include <aws/bedrock-agent/model/ServerSideEncryptionConfiguration.h>
#include <aws/bedrock-agent/model/SessionSummaryConfiguration.h>
#include <aws/bedrock-agent/model/SharePointAuthType.h>
#include <aws/bedrock-agent/model/SharePointCrawlerConfiguration.h>
#include <aws/bedrock-agent/model/SharePointDataSourceConfiguration.h>
#include <aws/bedrock-agent/model/SharePointHostType.h>
#include <aws/bedrock-agent/model/SharePointSourceConfiguration.h>
#include <aws/bedrock-agent/model/SortOrder.h>
#include <aws/bedrock-agent/model/SpecificToolChoice.h>
#include <aws/bedrock-agent/model/SqlKnowledgeBaseConfiguration.h>
#include <aws/bedrock-agent/model/StartIngestionJobRequest.h>
#include <aws/bedrock-agent/model/StartIngestionJobResult.h>
#include <aws/bedrock-agent/model/StepType.h>
#include <aws/bedrock-agent/model/StopIngestionJobRequest.h>
#include <aws/bedrock-agent/model/StopIngestionJobResult.h>
#include <aws/bedrock-agent/model/StorageConfiguration.h>
#include <aws/bedrock-agent/model/StorageFlowNodeConfiguration.h>
#include <aws/bedrock-agent/model/StorageFlowNodeS3Configuration.h>
#include <aws/bedrock-agent/model/StorageFlowNodeServiceConfiguration.h>
#include <aws/bedrock-agent/model/SupplementalDataStorageConfiguration.h>
#include <aws/bedrock-agent/model/SupplementalDataStorageLocation.h>
#include <aws/bedrock-agent/model/SupplementalDataStorageLocationType.h>
#include <aws/bedrock-agent/model/SupportedLanguages.h>
#include <aws/bedrock-agent/model/SystemContentBlock.h>
#include <aws/bedrock-agent/model/TagResourceRequest.h>
#include <aws/bedrock-agent/model/TagResourceResult.h>
#include <aws/bedrock-agent/model/TextContentDoc.h>
#include <aws/bedrock-agent/model/TextPromptTemplateConfiguration.h>
#include <aws/bedrock-agent/model/Tool.h>
#include <aws/bedrock-agent/model/ToolChoice.h>
#include <aws/bedrock-agent/model/ToolConfiguration.h>
#include <aws/bedrock-agent/model/ToolInputSchema.h>
#include <aws/bedrock-agent/model/ToolSpecification.h>
#include <aws/bedrock-agent/model/Transformation.h>
#include <aws/bedrock-agent/model/TransformationFunction.h>
#include <aws/bedrock-agent/model/TransformationLambdaConfiguration.h>
#include <aws/bedrock-agent/model/Type.h>
#include <aws/bedrock-agent/model/UnfulfilledNodeInputFlowValidationDetails.h>
#include <aws/bedrock-agent/model/UnknownConnectionConditionFlowValidationDetails.h>
#include <aws/bedrock-agent/model/UnknownConnectionSourceFlowValidationDetails.h>
#include <aws/bedrock-agent/model/UnknownConnectionSourceOutputFlowValidationDetails.h>
#include <aws/bedrock-agent/model/UnknownConnectionTargetFlowValidationDetails.h>
#include <aws/bedrock-agent/model/UnknownConnectionTargetInputFlowValidationDetails.h>
#include <aws/bedrock-agent/model/UnknownNodeInputFlowValidationDetails.h>
#include <aws/bedrock-agent/model/UnknownNodeOutputFlowValidationDetails.h>
#include <aws/bedrock-agent/model/UnreachableNodeFlowValidationDetails.h>
#include <aws/bedrock-agent/model/UnsatisfiedConnectionConditionsFlowValidationDetails.h>
#include <aws/bedrock-agent/model/UnspecifiedFlowValidationDetails.h>
#include <aws/bedrock-agent/model/UntagResourceRequest.h>
#include <aws/bedrock-agent/model/UntagResourceResult.h>
#include <aws/bedrock-agent/model/UpdateAgentActionGroupRequest.h>
#include <aws/bedrock-agent/model/UpdateAgentActionGroupResult.h>
#include <aws/bedrock-agent/model/UpdateAgentAliasRequest.h>
#include <aws/bedrock-agent/model/UpdateAgentAliasResult.h>
#include <aws/bedrock-agent/model/UpdateAgentCollaboratorRequest.h>
#include <aws/bedrock-agent/model/UpdateAgentCollaboratorResult.h>
#include <aws/bedrock-agent/model/UpdateAgentKnowledgeBaseRequest.h>
#include <aws/bedrock-agent/model/UpdateAgentKnowledgeBaseResult.h>
#include <aws/bedrock-agent/model/UpdateAgentRequest.h>
#include <aws/bedrock-agent/model/UpdateAgentResult.h>
#include <aws/bedrock-agent/model/UpdateDataSourceRequest.h>
#include <aws/bedrock-agent/model/UpdateDataSourceResult.h>
#include <aws/bedrock-agent/model/UpdateFlowAliasRequest.h>
#include <aws/bedrock-agent/model/UpdateFlowAliasResult.h>
#include <aws/bedrock-agent/model/UpdateFlowRequest.h>
#include <aws/bedrock-agent/model/UpdateFlowResult.h>
#include <aws/bedrock-agent/model/UpdateKnowledgeBaseRequest.h>
#include <aws/bedrock-agent/model/UpdateKnowledgeBaseResult.h>
#include <aws/bedrock-agent/model/UpdatePromptRequest.h>
#include <aws/bedrock-agent/model/UpdatePromptResult.h>
#include <aws/bedrock-agent/model/UrlConfiguration.h>
#include <aws/bedrock-agent/model/ValidateFlowDefinitionRequest.h>
#include <aws/bedrock-agent/model/ValidateFlowDefinitionResult.h>
#include <aws/bedrock-agent/model/ValidationException.h>
#include <aws/bedrock-agent/model/ValidationExceptionField.h>
#include <aws/bedrock-agent/model/VectorIngestionConfiguration.h>
#include <aws/bedrock-agent/model/VectorKnowledgeBaseConfiguration.h>
#include <aws/bedrock-agent/model/VectorSearchBedrockRerankingConfiguration.h>
#include <aws/bedrock-agent/model/VectorSearchBedrockRerankingModelConfiguration.h>
#include <aws/bedrock-agent/model/VectorSearchRerankingConfiguration.h>
#include <aws/bedrock-agent/model/VectorSearchRerankingConfigurationType.h>
#include <aws/bedrock-agent/model/WebCrawlerConfiguration.h>
#include <aws/bedrock-agent/model/WebCrawlerLimits.h>
#include <aws/bedrock-agent/model/WebDataSourceConfiguration.h>
#include <aws/bedrock-agent/model/WebScopeType.h>
#include <aws/bedrock-agent/model/WebSourceConfiguration.h>

using BedrockAgentIncludeTest = ::testing::Test;

TEST_F(BedrockAgentIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::BedrockAgent::BedrockAgentClient>("BedrockAgentIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
