/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/bedrock-agent-runtime/BedrockAgentRuntimeClient.h>
#include <aws/bedrock-agent-runtime/BedrockAgentRuntimeEndpointProvider.h>
#include <aws/bedrock-agent-runtime/BedrockAgentRuntimeEndpointRules.h>
#include <aws/bedrock-agent-runtime/BedrockAgentRuntimeErrorMarshaller.h>
#include <aws/bedrock-agent-runtime/BedrockAgentRuntimeErrors.h>
#include <aws/bedrock-agent-runtime/BedrockAgentRuntimeRequest.h>
#include <aws/bedrock-agent-runtime/BedrockAgentRuntimeServiceClientModel.h>
#include <aws/bedrock-agent-runtime/BedrockAgentRuntime_EXPORTS.h>
#include <aws/bedrock-agent-runtime/model/APISchema.h>
#include <aws/bedrock-agent-runtime/model/ActionGroupExecutor.h>
#include <aws/bedrock-agent-runtime/model/ActionGroupInvocationInput.h>
#include <aws/bedrock-agent-runtime/model/ActionGroupInvocationOutput.h>
#include <aws/bedrock-agent-runtime/model/ActionGroupSignature.h>
#include <aws/bedrock-agent-runtime/model/ActionInvocationType.h>
#include <aws/bedrock-agent-runtime/model/AgentActionGroup.h>
#include <aws/bedrock-agent-runtime/model/AgentCollaboration.h>
#include <aws/bedrock-agent-runtime/model/AgentCollaboratorInputPayload.h>
#include <aws/bedrock-agent-runtime/model/AgentCollaboratorInvocationInput.h>
#include <aws/bedrock-agent-runtime/model/AgentCollaboratorInvocationOutput.h>
#include <aws/bedrock-agent-runtime/model/AgentCollaboratorOutputPayload.h>
#include <aws/bedrock-agent-runtime/model/AnalyzePromptEvent.h>
#include <aws/bedrock-agent-runtime/model/ApiInvocationInput.h>
#include <aws/bedrock-agent-runtime/model/ApiParameter.h>
#include <aws/bedrock-agent-runtime/model/ApiRequestBody.h>
#include <aws/bedrock-agent-runtime/model/ApiResult.h>
#include <aws/bedrock-agent-runtime/model/AttributeType.h>
#include <aws/bedrock-agent-runtime/model/Attribution.h>
#include <aws/bedrock-agent-runtime/model/BadGatewayException.h>
#include <aws/bedrock-agent-runtime/model/BedrockModelConfigurations.h>
#include <aws/bedrock-agent-runtime/model/BedrockRerankingConfiguration.h>
#include <aws/bedrock-agent-runtime/model/BedrockRerankingModelConfiguration.h>
#include <aws/bedrock-agent-runtime/model/BedrockSessionContentBlock.h>
#include <aws/bedrock-agent-runtime/model/ByteContentDoc.h>
#include <aws/bedrock-agent-runtime/model/ByteContentFile.h>
#include <aws/bedrock-agent-runtime/model/Caller.h>
#include <aws/bedrock-agent-runtime/model/Citation.h>
#include <aws/bedrock-agent-runtime/model/CitationEvent.h>
#include <aws/bedrock-agent-runtime/model/CodeInterpreterInvocationInput.h>
#include <aws/bedrock-agent-runtime/model/CodeInterpreterInvocationOutput.h>
#include <aws/bedrock-agent-runtime/model/Collaborator.h>
#include <aws/bedrock-agent-runtime/model/CollaboratorConfiguration.h>
#include <aws/bedrock-agent-runtime/model/ConditionResultEvent.h>
#include <aws/bedrock-agent-runtime/model/ConfirmationState.h>
#include <aws/bedrock-agent-runtime/model/ContentBlock.h>
#include <aws/bedrock-agent-runtime/model/ContentBody.h>
#include <aws/bedrock-agent-runtime/model/ConversationHistory.h>
#include <aws/bedrock-agent-runtime/model/ConversationRole.h>
#include <aws/bedrock-agent-runtime/model/CreateInvocationRequest.h>
#include <aws/bedrock-agent-runtime/model/CreateInvocationResult.h>
#include <aws/bedrock-agent-runtime/model/CreateSessionRequest.h>
#include <aws/bedrock-agent-runtime/model/CreateSessionResult.h>
#include <aws/bedrock-agent-runtime/model/CreationMode.h>
#include <aws/bedrock-agent-runtime/model/CustomControlMethod.h>
#include <aws/bedrock-agent-runtime/model/CustomOrchestration.h>
#include <aws/bedrock-agent-runtime/model/CustomOrchestrationTrace.h>
#include <aws/bedrock-agent-runtime/model/CustomOrchestrationTraceEvent.h>
#include <aws/bedrock-agent-runtime/model/DeleteAgentMemoryRequest.h>
#include <aws/bedrock-agent-runtime/model/DeleteAgentMemoryResult.h>
#include <aws/bedrock-agent-runtime/model/DeleteSessionRequest.h>
#include <aws/bedrock-agent-runtime/model/DeleteSessionResult.h>
#include <aws/bedrock-agent-runtime/model/DependencyFailedException.h>
#include <aws/bedrock-agent-runtime/model/EndSessionRequest.h>
#include <aws/bedrock-agent-runtime/model/EndSessionResult.h>
#include <aws/bedrock-agent-runtime/model/ExecutionType.h>
#include <aws/bedrock-agent-runtime/model/ExternalSource.h>
#include <aws/bedrock-agent-runtime/model/ExternalSourceType.h>
#include <aws/bedrock-agent-runtime/model/ExternalSourcesGenerationConfiguration.h>
#include <aws/bedrock-agent-runtime/model/ExternalSourcesRetrieveAndGenerateConfiguration.h>
#include <aws/bedrock-agent-runtime/model/FailureTrace.h>
#include <aws/bedrock-agent-runtime/model/FieldForReranking.h>
#include <aws/bedrock-agent-runtime/model/FilePart.h>
#include <aws/bedrock-agent-runtime/model/FileSource.h>
#include <aws/bedrock-agent-runtime/model/FileSourceType.h>
#include <aws/bedrock-agent-runtime/model/FileUseCase.h>
#include <aws/bedrock-agent-runtime/model/FilterAttribute.h>
#include <aws/bedrock-agent-runtime/model/FinalResponse.h>
#include <aws/bedrock-agent-runtime/model/FlowCompletionEvent.h>
#include <aws/bedrock-agent-runtime/model/FlowCompletionReason.h>
#include <aws/bedrock-agent-runtime/model/FlowErrorCode.h>
#include <aws/bedrock-agent-runtime/model/FlowExecutionContent.h>
#include <aws/bedrock-agent-runtime/model/FlowExecutionError.h>
#include <aws/bedrock-agent-runtime/model/FlowExecutionErrorType.h>
#include <aws/bedrock-agent-runtime/model/FlowExecutionEvent.h>
#include <aws/bedrock-agent-runtime/model/FlowExecutionEventType.h>
#include <aws/bedrock-agent-runtime/model/FlowExecutionInputEvent.h>
#include <aws/bedrock-agent-runtime/model/FlowExecutionOutputEvent.h>
#include <aws/bedrock-agent-runtime/model/FlowExecutionStatus.h>
#include <aws/bedrock-agent-runtime/model/FlowExecutionSummary.h>
#include <aws/bedrock-agent-runtime/model/FlowFailureEvent.h>
#include <aws/bedrock-agent-runtime/model/FlowInput.h>
#include <aws/bedrock-agent-runtime/model/FlowInputContent.h>
#include <aws/bedrock-agent-runtime/model/FlowInputField.h>
#include <aws/bedrock-agent-runtime/model/FlowMultiTurnInputContent.h>
#include <aws/bedrock-agent-runtime/model/FlowMultiTurnInputRequestEvent.h>
#include <aws/bedrock-agent-runtime/model/FlowOutputContent.h>
#include <aws/bedrock-agent-runtime/model/FlowOutputEvent.h>
#include <aws/bedrock-agent-runtime/model/FlowOutputField.h>
#include <aws/bedrock-agent-runtime/model/FlowResponseStream.h>
#include <aws/bedrock-agent-runtime/model/FlowTrace.h>
#include <aws/bedrock-agent-runtime/model/FlowTraceCondition.h>
#include <aws/bedrock-agent-runtime/model/FlowTraceConditionNodeResultEvent.h>
#include <aws/bedrock-agent-runtime/model/FlowTraceEvent.h>
#include <aws/bedrock-agent-runtime/model/FlowTraceNodeActionEvent.h>
#include <aws/bedrock-agent-runtime/model/FlowTraceNodeInputContent.h>
#include <aws/bedrock-agent-runtime/model/FlowTraceNodeInputEvent.h>
#include <aws/bedrock-agent-runtime/model/FlowTraceNodeInputField.h>
#include <aws/bedrock-agent-runtime/model/FlowTraceNodeOutputContent.h>
#include <aws/bedrock-agent-runtime/model/FlowTraceNodeOutputEvent.h>
#include <aws/bedrock-agent-runtime/model/FlowTraceNodeOutputField.h>
#include <aws/bedrock-agent-runtime/model/FunctionDefinition.h>
#include <aws/bedrock-agent-runtime/model/FunctionInvocationInput.h>
#include <aws/bedrock-agent-runtime/model/FunctionParameter.h>
#include <aws/bedrock-agent-runtime/model/FunctionResult.h>
#include <aws/bedrock-agent-runtime/model/FunctionSchema.h>
#include <aws/bedrock-agent-runtime/model/GenerateQueryRequest.h>
#include <aws/bedrock-agent-runtime/model/GenerateQueryResult.h>
#include <aws/bedrock-agent-runtime/model/GeneratedQuery.h>
#include <aws/bedrock-agent-runtime/model/GeneratedQueryType.h>
#include <aws/bedrock-agent-runtime/model/GeneratedResponsePart.h>
#include <aws/bedrock-agent-runtime/model/GenerationConfiguration.h>
#include <aws/bedrock-agent-runtime/model/GetAgentMemoryRequest.h>
#include <aws/bedrock-agent-runtime/model/GetAgentMemoryResult.h>
#include <aws/bedrock-agent-runtime/model/GetExecutionFlowSnapshotRequest.h>
#include <aws/bedrock-agent-runtime/model/GetExecutionFlowSnapshotResult.h>
#include <aws/bedrock-agent-runtime/model/GetFlowExecutionRequest.h>
#include <aws/bedrock-agent-runtime/model/GetFlowExecutionResult.h>
#include <aws/bedrock-agent-runtime/model/GetInvocationStepRequest.h>
#include <aws/bedrock-agent-runtime/model/GetInvocationStepResult.h>
#include <aws/bedrock-agent-runtime/model/GetSessionRequest.h>
#include <aws/bedrock-agent-runtime/model/GetSessionResult.h>
#include <aws/bedrock-agent-runtime/model/GuadrailAction.h>
#include <aws/bedrock-agent-runtime/model/GuardrailAction.h>
#include <aws/bedrock-agent-runtime/model/GuardrailAssessment.h>
#include <aws/bedrock-agent-runtime/model/GuardrailConfiguration.h>
#include <aws/bedrock-agent-runtime/model/GuardrailConfigurationWithArn.h>
#include <aws/bedrock-agent-runtime/model/GuardrailContentFilter.h>
#include <aws/bedrock-agent-runtime/model/GuardrailContentFilterConfidence.h>
#include <aws/bedrock-agent-runtime/model/GuardrailContentFilterType.h>
#include <aws/bedrock-agent-runtime/model/GuardrailContentPolicyAction.h>
#include <aws/bedrock-agent-runtime/model/GuardrailContentPolicyAssessment.h>
#include <aws/bedrock-agent-runtime/model/GuardrailCustomWord.h>
#include <aws/bedrock-agent-runtime/model/GuardrailEvent.h>
#include <aws/bedrock-agent-runtime/model/GuardrailManagedWord.h>
#include <aws/bedrock-agent-runtime/model/GuardrailManagedWordType.h>
#include <aws/bedrock-agent-runtime/model/GuardrailPiiEntityFilter.h>
#include <aws/bedrock-agent-runtime/model/GuardrailPiiEntityType.h>
#include <aws/bedrock-agent-runtime/model/GuardrailRegexFilter.h>
#include <aws/bedrock-agent-runtime/model/GuardrailSensitiveInformationPolicyAction.h>
#include <aws/bedrock-agent-runtime/model/GuardrailSensitiveInformationPolicyAssessment.h>
#include <aws/bedrock-agent-runtime/model/GuardrailTopic.h>
#include <aws/bedrock-agent-runtime/model/GuardrailTopicPolicyAction.h>
#include <aws/bedrock-agent-runtime/model/GuardrailTopicPolicyAssessment.h>
#include <aws/bedrock-agent-runtime/model/GuardrailTopicType.h>
#include <aws/bedrock-agent-runtime/model/GuardrailTrace.h>
#include <aws/bedrock-agent-runtime/model/GuardrailWordPolicyAction.h>
#include <aws/bedrock-agent-runtime/model/GuardrailWordPolicyAssessment.h>
#include <aws/bedrock-agent-runtime/model/ImageBlock.h>
#include <aws/bedrock-agent-runtime/model/ImageFormat.h>
#include <aws/bedrock-agent-runtime/model/ImageInput.h>
#include <aws/bedrock-agent-runtime/model/ImageInputFormat.h>
#include <aws/bedrock-agent-runtime/model/ImageInputSource.h>
#include <aws/bedrock-agent-runtime/model/ImageSource.h>
#include <aws/bedrock-agent-runtime/model/ImplicitFilterConfiguration.h>
#include <aws/bedrock-agent-runtime/model/InferenceConfig.h>
#include <aws/bedrock-agent-runtime/model/InferenceConfiguration.h>
#include <aws/bedrock-agent-runtime/model/InlineAgentFilePart.h>
#include <aws/bedrock-agent-runtime/model/InlineAgentPayloadPart.h>
#include <aws/bedrock-agent-runtime/model/InlineAgentResponseStream.h>
#include <aws/bedrock-agent-runtime/model/InlineAgentReturnControlPayload.h>
#include <aws/bedrock-agent-runtime/model/InlineAgentTracePart.h>
#include <aws/bedrock-agent-runtime/model/InlineBedrockModelConfigurations.h>
#include <aws/bedrock-agent-runtime/model/InlineSessionState.h>
#include <aws/bedrock-agent-runtime/model/InputFile.h>
#include <aws/bedrock-agent-runtime/model/InputPrompt.h>
#include <aws/bedrock-agent-runtime/model/InputQueryType.h>
#include <aws/bedrock-agent-runtime/model/InternalServerException.h>
#include <aws/bedrock-agent-runtime/model/InvocationInput.h>
#include <aws/bedrock-agent-runtime/model/InvocationInputMember.h>
#include <aws/bedrock-agent-runtime/model/InvocationResultMember.h>
#include <aws/bedrock-agent-runtime/model/InvocationStep.h>
#include <aws/bedrock-agent-runtime/model/InvocationStepPayload.h>
#include <aws/bedrock-agent-runtime/model/InvocationStepSummary.h>
#include <aws/bedrock-agent-runtime/model/InvocationSummary.h>
#include <aws/bedrock-agent-runtime/model/InvocationType.h>
#include <aws/bedrock-agent-runtime/model/InvokeAgentHandler.h>
#include <aws/bedrock-agent-runtime/model/InvokeAgentInitialResponse.h>
#include <aws/bedrock-agent-runtime/model/InvokeAgentRequest.h>
#include <aws/bedrock-agent-runtime/model/InvokeFlowHandler.h>
#include <aws/bedrock-agent-runtime/model/InvokeFlowInitialResponse.h>
#include <aws/bedrock-agent-runtime/model/InvokeFlowRequest.h>
#include <aws/bedrock-agent-runtime/model/InvokeInlineAgentHandler.h>
#include <aws/bedrock-agent-runtime/model/InvokeInlineAgentInitialResponse.h>
#include <aws/bedrock-agent-runtime/model/InvokeInlineAgentRequest.h>
#include <aws/bedrock-agent-runtime/model/KnowledgeBase.h>
#include <aws/bedrock-agent-runtime/model/KnowledgeBaseConfiguration.h>
#include <aws/bedrock-agent-runtime/model/KnowledgeBaseLookupInput.h>
#include <aws/bedrock-agent-runtime/model/KnowledgeBaseLookupOutput.h>
#include <aws/bedrock-agent-runtime/model/KnowledgeBaseQuery.h>
#include <aws/bedrock-agent-runtime/model/KnowledgeBaseRetrievalConfiguration.h>
#include <aws/bedrock-agent-runtime/model/KnowledgeBaseRetrievalResult.h>
#include <aws/bedrock-agent-runtime/model/KnowledgeBaseRetrieveAndGenerateConfiguration.h>
#include <aws/bedrock-agent-runtime/model/KnowledgeBaseVectorSearchConfiguration.h>
#include <aws/bedrock-agent-runtime/model/ListFlowExecutionEventsRequest.h>
#include <aws/bedrock-agent-runtime/model/ListFlowExecutionEventsResult.h>
#include <aws/bedrock-agent-runtime/model/ListFlowExecutionsRequest.h>
#include <aws/bedrock-agent-runtime/model/ListFlowExecutionsResult.h>
#include <aws/bedrock-agent-runtime/model/ListInvocationStepsRequest.h>
#include <aws/bedrock-agent-runtime/model/ListInvocationStepsResult.h>
#include <aws/bedrock-agent-runtime/model/ListInvocationsRequest.h>
#include <aws/bedrock-agent-runtime/model/ListInvocationsResult.h>
#include <aws/bedrock-agent-runtime/model/ListSessionsRequest.h>
#include <aws/bedrock-agent-runtime/model/ListSessionsResult.h>
#include <aws/bedrock-agent-runtime/model/ListTagsForResourceRequest.h>
#include <aws/bedrock-agent-runtime/model/ListTagsForResourceResult.h>
#include <aws/bedrock-agent-runtime/model/Memory.h>
#include <aws/bedrock-agent-runtime/model/MemorySessionSummary.h>
#include <aws/bedrock-agent-runtime/model/MemoryType.h>
#include <aws/bedrock-agent-runtime/model/Message.h>
#include <aws/bedrock-agent-runtime/model/Metadata.h>
#include <aws/bedrock-agent-runtime/model/MetadataAttributeSchema.h>
#include <aws/bedrock-agent-runtime/model/MetadataConfigurationForReranking.h>
#include <aws/bedrock-agent-runtime/model/ModelInvocationInput.h>
#include <aws/bedrock-agent-runtime/model/ModelPerformanceConfiguration.h>
#include <aws/bedrock-agent-runtime/model/NodeErrorCode.h>
#include <aws/bedrock-agent-runtime/model/NodeExecutionContent.h>
#include <aws/bedrock-agent-runtime/model/NodeFailureEvent.h>
#include <aws/bedrock-agent-runtime/model/NodeInputEvent.h>
#include <aws/bedrock-agent-runtime/model/NodeInputField.h>
#include <aws/bedrock-agent-runtime/model/NodeOutputEvent.h>
#include <aws/bedrock-agent-runtime/model/NodeOutputField.h>
#include <aws/bedrock-agent-runtime/model/NodeType.h>
#include <aws/bedrock-agent-runtime/model/Observation.h>
#include <aws/bedrock-agent-runtime/model/OptimizePromptHandler.h>
#include <aws/bedrock-agent-runtime/model/OptimizePromptInitialResponse.h>
#include <aws/bedrock-agent-runtime/model/OptimizePromptRequest.h>
#include <aws/bedrock-agent-runtime/model/OptimizedPrompt.h>
#include <aws/bedrock-agent-runtime/model/OptimizedPromptEvent.h>
#include <aws/bedrock-agent-runtime/model/OptimizedPromptStream.h>
#include <aws/bedrock-agent-runtime/model/OrchestrationConfiguration.h>
#include <aws/bedrock-agent-runtime/model/OrchestrationExecutor.h>
#include <aws/bedrock-agent-runtime/model/OrchestrationModelInvocationOutput.h>
#include <aws/bedrock-agent-runtime/model/OrchestrationTrace.h>
#include <aws/bedrock-agent-runtime/model/OrchestrationType.h>
#include <aws/bedrock-agent-runtime/model/OutputFile.h>
#include <aws/bedrock-agent-runtime/model/Parameter.h>
#include <aws/bedrock-agent-runtime/model/ParameterDetail.h>
#include <aws/bedrock-agent-runtime/model/ParameterType.h>
#include <aws/bedrock-agent-runtime/model/PayloadPart.h>
#include <aws/bedrock-agent-runtime/model/PayloadType.h>
#include <aws/bedrock-agent-runtime/model/PerformanceConfigLatency.h>
#include <aws/bedrock-agent-runtime/model/PerformanceConfiguration.h>
#include <aws/bedrock-agent-runtime/model/PostProcessingModelInvocationOutput.h>
#include <aws/bedrock-agent-runtime/model/PostProcessingParsedResponse.h>
#include <aws/bedrock-agent-runtime/model/PostProcessingTrace.h>
#include <aws/bedrock-agent-runtime/model/PreProcessingModelInvocationOutput.h>
#include <aws/bedrock-agent-runtime/model/PreProcessingParsedResponse.h>
#include <aws/bedrock-agent-runtime/model/PreProcessingTrace.h>
#include <aws/bedrock-agent-runtime/model/PromptConfiguration.h>
#include <aws/bedrock-agent-runtime/model/PromptCreationConfigurations.h>
#include <aws/bedrock-agent-runtime/model/PromptOverrideConfiguration.h>
#include <aws/bedrock-agent-runtime/model/PromptState.h>
#include <aws/bedrock-agent-runtime/model/PromptTemplate.h>
#include <aws/bedrock-agent-runtime/model/PromptType.h>
#include <aws/bedrock-agent-runtime/model/PropertyParameters.h>
#include <aws/bedrock-agent-runtime/model/PutInvocationStepRequest.h>
#include <aws/bedrock-agent-runtime/model/PutInvocationStepResult.h>
#include <aws/bedrock-agent-runtime/model/QueryGenerationInput.h>
#include <aws/bedrock-agent-runtime/model/QueryTransformationConfiguration.h>
#include <aws/bedrock-agent-runtime/model/QueryTransformationMode.h>
#include <aws/bedrock-agent-runtime/model/QueryTransformationType.h>
#include <aws/bedrock-agent-runtime/model/Rationale.h>
#include <aws/bedrock-agent-runtime/model/RawResponse.h>
#include <aws/bedrock-agent-runtime/model/ReasoningContentBlock.h>
#include <aws/bedrock-agent-runtime/model/ReasoningTextBlock.h>
#include <aws/bedrock-agent-runtime/model/RelayConversationHistory.h>
#include <aws/bedrock-agent-runtime/model/RepromptResponse.h>
#include <aws/bedrock-agent-runtime/model/RequestBody.h>
#include <aws/bedrock-agent-runtime/model/RequireConfirmation.h>
#include <aws/bedrock-agent-runtime/model/RerankDocument.h>
#include <aws/bedrock-agent-runtime/model/RerankDocumentType.h>
#include <aws/bedrock-agent-runtime/model/RerankQuery.h>
#include <aws/bedrock-agent-runtime/model/RerankQueryContentType.h>
#include <aws/bedrock-agent-runtime/model/RerankRequest.h>
#include <aws/bedrock-agent-runtime/model/RerankResult.h>
#include <aws/bedrock-agent-runtime/model/RerankSdkResult.h>
#include <aws/bedrock-agent-runtime/model/RerankSource.h>
#include <aws/bedrock-agent-runtime/model/RerankSourceType.h>
#include <aws/bedrock-agent-runtime/model/RerankTextDocument.h>
#include <aws/bedrock-agent-runtime/model/RerankingConfiguration.h>
#include <aws/bedrock-agent-runtime/model/RerankingConfigurationType.h>
#include <aws/bedrock-agent-runtime/model/RerankingMetadataSelectionMode.h>
#include <aws/bedrock-agent-runtime/model/RerankingMetadataSelectiveModeConfiguration.h>
#include <aws/bedrock-agent-runtime/model/ResponseState.h>
#include <aws/bedrock-agent-runtime/model/ResponseStream.h>
#include <aws/bedrock-agent-runtime/model/RetrievalFilter.h>
#include <aws/bedrock-agent-runtime/model/RetrievalResultConfluenceLocation.h>
#include <aws/bedrock-agent-runtime/model/RetrievalResultContent.h>
#include <aws/bedrock-agent-runtime/model/RetrievalResultContentColumn.h>
#include <aws/bedrock-agent-runtime/model/RetrievalResultContentColumnType.h>
#include <aws/bedrock-agent-runtime/model/RetrievalResultContentType.h>
#include <aws/bedrock-agent-runtime/model/RetrievalResultCustomDocumentLocation.h>
#include <aws/bedrock-agent-runtime/model/RetrievalResultKendraDocumentLocation.h>
#include <aws/bedrock-agent-runtime/model/RetrievalResultLocation.h>
#include <aws/bedrock-agent-runtime/model/RetrievalResultLocationType.h>
#include <aws/bedrock-agent-runtime/model/RetrievalResultS3Location.h>
#include <aws/bedrock-agent-runtime/model/RetrievalResultSalesforceLocation.h>
#include <aws/bedrock-agent-runtime/model/RetrievalResultSharePointLocation.h>
#include <aws/bedrock-agent-runtime/model/RetrievalResultSqlLocation.h>
#include <aws/bedrock-agent-runtime/model/RetrievalResultWebLocation.h>
#include <aws/bedrock-agent-runtime/model/RetrieveAndGenerateConfiguration.h>
#include <aws/bedrock-agent-runtime/model/RetrieveAndGenerateInput.h>
#include <aws/bedrock-agent-runtime/model/RetrieveAndGenerateOutput.h>
#include <aws/bedrock-agent-runtime/model/RetrieveAndGenerateOutputEvent.h>
#include <aws/bedrock-agent-runtime/model/RetrieveAndGenerateRequest.h>
#include <aws/bedrock-agent-runtime/model/RetrieveAndGenerateResult.h>
#include <aws/bedrock-agent-runtime/model/RetrieveAndGenerateSessionConfiguration.h>
#include <aws/bedrock-agent-runtime/model/RetrieveAndGenerateStreamHandler.h>
#include <aws/bedrock-agent-runtime/model/RetrieveAndGenerateStreamInitialResponse.h>
#include <aws/bedrock-agent-runtime/model/RetrieveAndGenerateStreamRequest.h>
#include <aws/bedrock-agent-runtime/model/RetrieveAndGenerateStreamResponseOutput.h>
#include <aws/bedrock-agent-runtime/model/RetrieveAndGenerateType.h>
#include <aws/bedrock-agent-runtime/model/RetrieveRequest.h>
#include <aws/bedrock-agent-runtime/model/RetrieveResult.h>
#include <aws/bedrock-agent-runtime/model/RetrievedReference.h>
#include <aws/bedrock-agent-runtime/model/ReturnControlPayload.h>
#include <aws/bedrock-agent-runtime/model/ReturnControlResults.h>
#include <aws/bedrock-agent-runtime/model/RoutingClassifierModelInvocationOutput.h>
#include <aws/bedrock-agent-runtime/model/RoutingClassifierTrace.h>
#include <aws/bedrock-agent-runtime/model/S3Identifier.h>
#include <aws/bedrock-agent-runtime/model/S3Location.h>
#include <aws/bedrock-agent-runtime/model/S3ObjectDoc.h>
#include <aws/bedrock-agent-runtime/model/S3ObjectFile.h>
#include <aws/bedrock-agent-runtime/model/SatisfiedCondition.h>
#include <aws/bedrock-agent-runtime/model/SearchType.h>
#include <aws/bedrock-agent-runtime/model/SessionState.h>
#include <aws/bedrock-agent-runtime/model/SessionStatus.h>
#include <aws/bedrock-agent-runtime/model/SessionSummary.h>
#include <aws/bedrock-agent-runtime/model/Source.h>
#include <aws/bedrock-agent-runtime/model/Span.h>
#include <aws/bedrock-agent-runtime/model/StartFlowExecutionRequest.h>
#include <aws/bedrock-agent-runtime/model/StartFlowExecutionResult.h>
#include <aws/bedrock-agent-runtime/model/StopFlowExecutionRequest.h>
#include <aws/bedrock-agent-runtime/model/StopFlowExecutionResult.h>
#include <aws/bedrock-agent-runtime/model/StreamingConfigurations.h>
#include <aws/bedrock-agent-runtime/model/TagResourceRequest.h>
#include <aws/bedrock-agent-runtime/model/TagResourceResult.h>
#include <aws/bedrock-agent-runtime/model/TextInferenceConfig.h>
#include <aws/bedrock-agent-runtime/model/TextPrompt.h>
#include <aws/bedrock-agent-runtime/model/TextResponsePart.h>
#include <aws/bedrock-agent-runtime/model/TextToSqlConfiguration.h>
#include <aws/bedrock-agent-runtime/model/TextToSqlConfigurationType.h>
#include <aws/bedrock-agent-runtime/model/TextToSqlKnowledgeBaseConfiguration.h>
#include <aws/bedrock-agent-runtime/model/Trace.h>
#include <aws/bedrock-agent-runtime/model/TracePart.h>
#include <aws/bedrock-agent-runtime/model/TransformationConfiguration.h>
#include <aws/bedrock-agent-runtime/model/Type.h>
#include <aws/bedrock-agent-runtime/model/UntagResourceRequest.h>
#include <aws/bedrock-agent-runtime/model/UntagResourceResult.h>
#include <aws/bedrock-agent-runtime/model/UpdateSessionRequest.h>
#include <aws/bedrock-agent-runtime/model/UpdateSessionResult.h>
#include <aws/bedrock-agent-runtime/model/Usage.h>
#include <aws/bedrock-agent-runtime/model/VectorSearchBedrockRerankingConfiguration.h>
#include <aws/bedrock-agent-runtime/model/VectorSearchBedrockRerankingModelConfiguration.h>
#include <aws/bedrock-agent-runtime/model/VectorSearchRerankingConfiguration.h>
#include <aws/bedrock-agent-runtime/model/VectorSearchRerankingConfigurationType.h>

using BedrockAgentRuntimeIncludeTest = ::testing::Test;

TEST_F(BedrockAgentRuntimeIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::BedrockAgentRuntime::BedrockAgentRuntimeClient>("BedrockAgentRuntimeIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
