/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/bedrock/BedrockClient.h>
#include <aws/bedrock/BedrockEndpointProvider.h>
#include <aws/bedrock/BedrockEndpointRules.h>
#include <aws/bedrock/BedrockErrorMarshaller.h>
#include <aws/bedrock/BedrockErrors.h>
#include <aws/bedrock/BedrockRequest.h>
#include <aws/bedrock/BedrockServiceClientModel.h>
#include <aws/bedrock/Bedrock_EXPORTS.h>
#include <aws/bedrock/model/AgreementAvailability.h>
#include <aws/bedrock/model/AgreementStatus.h>
#include <aws/bedrock/model/ApplicationType.h>
#include <aws/bedrock/model/AuthorizationStatus.h>
#include <aws/bedrock/model/AutomatedEvaluationConfig.h>
#include <aws/bedrock/model/AutomatedEvaluationCustomMetricConfig.h>
#include <aws/bedrock/model/AutomatedEvaluationCustomMetricSource.h>
#include <aws/bedrock/model/BatchDeleteEvaluationJobError.h>
#include <aws/bedrock/model/BatchDeleteEvaluationJobItem.h>
#include <aws/bedrock/model/BatchDeleteEvaluationJobRequest.h>
#include <aws/bedrock/model/BatchDeleteEvaluationJobResult.h>
#include <aws/bedrock/model/BedrockEvaluatorModel.h>
#include <aws/bedrock/model/ByteContentDoc.h>
#include <aws/bedrock/model/CloudWatchConfig.h>
#include <aws/bedrock/model/CommitmentDuration.h>
#include <aws/bedrock/model/CreateCustomModelRequest.h>
#include <aws/bedrock/model/CreateCustomModelResult.h>
#include <aws/bedrock/model/CreateEvaluationJobRequest.h>
#include <aws/bedrock/model/CreateEvaluationJobResult.h>
#include <aws/bedrock/model/CreateFoundationModelAgreementRequest.h>
#include <aws/bedrock/model/CreateFoundationModelAgreementResult.h>
#include <aws/bedrock/model/CreateGuardrailRequest.h>
#include <aws/bedrock/model/CreateGuardrailResult.h>
#include <aws/bedrock/model/CreateGuardrailVersionRequest.h>
#include <aws/bedrock/model/CreateGuardrailVersionResult.h>
#include <aws/bedrock/model/CreateInferenceProfileRequest.h>
#include <aws/bedrock/model/CreateInferenceProfileResult.h>
#include <aws/bedrock/model/CreateMarketplaceModelEndpointRequest.h>
#include <aws/bedrock/model/CreateMarketplaceModelEndpointResult.h>
#include <aws/bedrock/model/CreateModelCopyJobRequest.h>
#include <aws/bedrock/model/CreateModelCopyJobResult.h>
#include <aws/bedrock/model/CreateModelCustomizationJobRequest.h>
#include <aws/bedrock/model/CreateModelCustomizationJobResult.h>
#include <aws/bedrock/model/CreateModelImportJobRequest.h>
#include <aws/bedrock/model/CreateModelImportJobResult.h>
#include <aws/bedrock/model/CreateModelInvocationJobRequest.h>
#include <aws/bedrock/model/CreateModelInvocationJobResult.h>
#include <aws/bedrock/model/CreatePromptRouterRequest.h>
#include <aws/bedrock/model/CreatePromptRouterResult.h>
#include <aws/bedrock/model/CreateProvisionedModelThroughputRequest.h>
#include <aws/bedrock/model/CreateProvisionedModelThroughputResult.h>
#include <aws/bedrock/model/CustomMetricBedrockEvaluatorModel.h>
#include <aws/bedrock/model/CustomMetricDefinition.h>
#include <aws/bedrock/model/CustomMetricEvaluatorModelConfig.h>
#include <aws/bedrock/model/CustomModelSummary.h>
#include <aws/bedrock/model/CustomModelUnits.h>
#include <aws/bedrock/model/CustomizationConfig.h>
#include <aws/bedrock/model/CustomizationType.h>
#include <aws/bedrock/model/DataProcessingDetails.h>
#include <aws/bedrock/model/DeleteCustomModelRequest.h>
#include <aws/bedrock/model/DeleteCustomModelResult.h>
#include <aws/bedrock/model/DeleteFoundationModelAgreementRequest.h>
#include <aws/bedrock/model/DeleteFoundationModelAgreementResult.h>
#include <aws/bedrock/model/DeleteGuardrailRequest.h>
#include <aws/bedrock/model/DeleteGuardrailResult.h>
#include <aws/bedrock/model/DeleteImportedModelRequest.h>
#include <aws/bedrock/model/DeleteImportedModelResult.h>
#include <aws/bedrock/model/DeleteInferenceProfileRequest.h>
#include <aws/bedrock/model/DeleteInferenceProfileResult.h>
#include <aws/bedrock/model/DeleteMarketplaceModelEndpointRequest.h>
#include <aws/bedrock/model/DeleteMarketplaceModelEndpointResult.h>
#include <aws/bedrock/model/DeleteModelInvocationLoggingConfigurationRequest.h>
#include <aws/bedrock/model/DeleteModelInvocationLoggingConfigurationResult.h>
#include <aws/bedrock/model/DeletePromptRouterRequest.h>
#include <aws/bedrock/model/DeletePromptRouterResult.h>
#include <aws/bedrock/model/DeleteProvisionedModelThroughputRequest.h>
#include <aws/bedrock/model/DeleteProvisionedModelThroughputResult.h>
#include <aws/bedrock/model/DeregisterMarketplaceModelEndpointRequest.h>
#include <aws/bedrock/model/DeregisterMarketplaceModelEndpointResult.h>
#include <aws/bedrock/model/DimensionalPriceRate.h>
#include <aws/bedrock/model/DistillationConfig.h>
#include <aws/bedrock/model/EndpointConfig.h>
#include <aws/bedrock/model/EntitlementAvailability.h>
#include <aws/bedrock/model/EvaluationBedrockModel.h>
#include <aws/bedrock/model/EvaluationConfig.h>
#include <aws/bedrock/model/EvaluationDataset.h>
#include <aws/bedrock/model/EvaluationDatasetLocation.h>
#include <aws/bedrock/model/EvaluationDatasetMetricConfig.h>
#include <aws/bedrock/model/EvaluationInferenceConfig.h>
#include <aws/bedrock/model/EvaluationInferenceConfigSummary.h>
#include <aws/bedrock/model/EvaluationJobStatus.h>
#include <aws/bedrock/model/EvaluationJobType.h>
#include <aws/bedrock/model/EvaluationModelConfig.h>
#include <aws/bedrock/model/EvaluationModelConfigSummary.h>
#include <aws/bedrock/model/EvaluationOutputDataConfig.h>
#include <aws/bedrock/model/EvaluationPrecomputedInferenceSource.h>
#include <aws/bedrock/model/EvaluationPrecomputedRagSourceConfig.h>
#include <aws/bedrock/model/EvaluationPrecomputedRetrieveAndGenerateSourceConfig.h>
#include <aws/bedrock/model/EvaluationPrecomputedRetrieveSourceConfig.h>
#include <aws/bedrock/model/EvaluationRagConfigSummary.h>
#include <aws/bedrock/model/EvaluationSummary.h>
#include <aws/bedrock/model/EvaluationTaskType.h>
#include <aws/bedrock/model/EvaluatorModelConfig.h>
#include <aws/bedrock/model/ExternalSource.h>
#include <aws/bedrock/model/ExternalSourceType.h>
#include <aws/bedrock/model/ExternalSourcesGenerationConfiguration.h>
#include <aws/bedrock/model/ExternalSourcesRetrieveAndGenerateConfiguration.h>
#include <aws/bedrock/model/FilterAttribute.h>
#include <aws/bedrock/model/FineTuningJobStatus.h>
#include <aws/bedrock/model/FoundationModelDetails.h>
#include <aws/bedrock/model/FoundationModelLifecycle.h>
#include <aws/bedrock/model/FoundationModelLifecycleStatus.h>
#include <aws/bedrock/model/FoundationModelSummary.h>
#include <aws/bedrock/model/GenerationConfiguration.h>
#include <aws/bedrock/model/GetCustomModelRequest.h>
#include <aws/bedrock/model/GetCustomModelResult.h>
#include <aws/bedrock/model/GetEvaluationJobRequest.h>
#include <aws/bedrock/model/GetEvaluationJobResult.h>
#include <aws/bedrock/model/GetFoundationModelAvailabilityRequest.h>
#include <aws/bedrock/model/GetFoundationModelAvailabilityResult.h>
#include <aws/bedrock/model/GetFoundationModelRequest.h>
#include <aws/bedrock/model/GetFoundationModelResult.h>
#include <aws/bedrock/model/GetGuardrailRequest.h>
#include <aws/bedrock/model/GetGuardrailResult.h>
#include <aws/bedrock/model/GetImportedModelRequest.h>
#include <aws/bedrock/model/GetImportedModelResult.h>
#include <aws/bedrock/model/GetInferenceProfileRequest.h>
#include <aws/bedrock/model/GetInferenceProfileResult.h>
#include <aws/bedrock/model/GetMarketplaceModelEndpointRequest.h>
#include <aws/bedrock/model/GetMarketplaceModelEndpointResult.h>
#include <aws/bedrock/model/GetModelCopyJobRequest.h>
#include <aws/bedrock/model/GetModelCopyJobResult.h>
#include <aws/bedrock/model/GetModelCustomizationJobRequest.h>
#include <aws/bedrock/model/GetModelCustomizationJobResult.h>
#include <aws/bedrock/model/GetModelImportJobRequest.h>
#include <aws/bedrock/model/GetModelImportJobResult.h>
#include <aws/bedrock/model/GetModelInvocationJobRequest.h>
#include <aws/bedrock/model/GetModelInvocationJobResult.h>
#include <aws/bedrock/model/GetModelInvocationLoggingConfigurationRequest.h>
#include <aws/bedrock/model/GetModelInvocationLoggingConfigurationResult.h>
#include <aws/bedrock/model/GetPromptRouterRequest.h>
#include <aws/bedrock/model/GetPromptRouterResult.h>
#include <aws/bedrock/model/GetProvisionedModelThroughputRequest.h>
#include <aws/bedrock/model/GetProvisionedModelThroughputResult.h>
#include <aws/bedrock/model/GetUseCaseForModelAccessRequest.h>
#include <aws/bedrock/model/GetUseCaseForModelAccessResult.h>
#include <aws/bedrock/model/GuardrailConfiguration.h>
#include <aws/bedrock/model/GuardrailContentFilter.h>
#include <aws/bedrock/model/GuardrailContentFilterAction.h>
#include <aws/bedrock/model/GuardrailContentFilterConfig.h>
#include <aws/bedrock/model/GuardrailContentFilterType.h>
#include <aws/bedrock/model/GuardrailContentFiltersTier.h>
#include <aws/bedrock/model/GuardrailContentFiltersTierConfig.h>
#include <aws/bedrock/model/GuardrailContentFiltersTierName.h>
#include <aws/bedrock/model/GuardrailContentPolicy.h>
#include <aws/bedrock/model/GuardrailContentPolicyConfig.h>
#include <aws/bedrock/model/GuardrailContextualGroundingAction.h>
#include <aws/bedrock/model/GuardrailContextualGroundingFilter.h>
#include <aws/bedrock/model/GuardrailContextualGroundingFilterConfig.h>
#include <aws/bedrock/model/GuardrailContextualGroundingFilterType.h>
#include <aws/bedrock/model/GuardrailContextualGroundingPolicy.h>
#include <aws/bedrock/model/GuardrailContextualGroundingPolicyConfig.h>
#include <aws/bedrock/model/GuardrailCrossRegionConfig.h>
#include <aws/bedrock/model/GuardrailCrossRegionDetails.h>
#include <aws/bedrock/model/GuardrailFilterStrength.h>
#include <aws/bedrock/model/GuardrailManagedWords.h>
#include <aws/bedrock/model/GuardrailManagedWordsConfig.h>
#include <aws/bedrock/model/GuardrailManagedWordsType.h>
#include <aws/bedrock/model/GuardrailModality.h>
#include <aws/bedrock/model/GuardrailPiiEntity.h>
#include <aws/bedrock/model/GuardrailPiiEntityConfig.h>
#include <aws/bedrock/model/GuardrailPiiEntityType.h>
#include <aws/bedrock/model/GuardrailRegex.h>
#include <aws/bedrock/model/GuardrailRegexConfig.h>
#include <aws/bedrock/model/GuardrailSensitiveInformationAction.h>
#include <aws/bedrock/model/GuardrailSensitiveInformationPolicy.h>
#include <aws/bedrock/model/GuardrailSensitiveInformationPolicyConfig.h>
#include <aws/bedrock/model/GuardrailStatus.h>
#include <aws/bedrock/model/GuardrailSummary.h>
#include <aws/bedrock/model/GuardrailTopic.h>
#include <aws/bedrock/model/GuardrailTopicAction.h>
#include <aws/bedrock/model/GuardrailTopicConfig.h>
#include <aws/bedrock/model/GuardrailTopicPolicy.h>
#include <aws/bedrock/model/GuardrailTopicPolicyConfig.h>
#include <aws/bedrock/model/GuardrailTopicType.h>
#include <aws/bedrock/model/GuardrailTopicsTier.h>
#include <aws/bedrock/model/GuardrailTopicsTierConfig.h>
#include <aws/bedrock/model/GuardrailTopicsTierName.h>
#include <aws/bedrock/model/GuardrailWord.h>
#include <aws/bedrock/model/GuardrailWordAction.h>
#include <aws/bedrock/model/GuardrailWordConfig.h>
#include <aws/bedrock/model/GuardrailWordPolicy.h>
#include <aws/bedrock/model/GuardrailWordPolicyConfig.h>
#include <aws/bedrock/model/HumanEvaluationConfig.h>
#include <aws/bedrock/model/HumanEvaluationCustomMetric.h>
#include <aws/bedrock/model/HumanWorkflowConfig.h>
#include <aws/bedrock/model/ImportedModelSummary.h>
#include <aws/bedrock/model/InferenceProfileModel.h>
#include <aws/bedrock/model/InferenceProfileModelSource.h>
#include <aws/bedrock/model/InferenceProfileStatus.h>
#include <aws/bedrock/model/InferenceProfileSummary.h>
#include <aws/bedrock/model/InferenceProfileType.h>
#include <aws/bedrock/model/InferenceType.h>
#include <aws/bedrock/model/InvocationLogSource.h>
#include <aws/bedrock/model/InvocationLogsConfig.h>
#include <aws/bedrock/model/JobStatusDetails.h>
#include <aws/bedrock/model/KbInferenceConfig.h>
#include <aws/bedrock/model/KnowledgeBaseConfig.h>
#include <aws/bedrock/model/KnowledgeBaseRetrievalConfiguration.h>
#include <aws/bedrock/model/KnowledgeBaseRetrieveAndGenerateConfiguration.h>
#include <aws/bedrock/model/KnowledgeBaseVectorSearchConfiguration.h>
#include <aws/bedrock/model/LegalTerm.h>
#include <aws/bedrock/model/ListCustomModelsRequest.h>
#include <aws/bedrock/model/ListCustomModelsResult.h>
#include <aws/bedrock/model/ListEvaluationJobsRequest.h>
#include <aws/bedrock/model/ListEvaluationJobsResult.h>
#include <aws/bedrock/model/ListFoundationModelAgreementOffersRequest.h>
#include <aws/bedrock/model/ListFoundationModelAgreementOffersResult.h>
#include <aws/bedrock/model/ListFoundationModelsRequest.h>
#include <aws/bedrock/model/ListFoundationModelsResult.h>
#include <aws/bedrock/model/ListGuardrailsRequest.h>
#include <aws/bedrock/model/ListGuardrailsResult.h>
#include <aws/bedrock/model/ListImportedModelsRequest.h>
#include <aws/bedrock/model/ListImportedModelsResult.h>
#include <aws/bedrock/model/ListInferenceProfilesRequest.h>
#include <aws/bedrock/model/ListInferenceProfilesResult.h>
#include <aws/bedrock/model/ListMarketplaceModelEndpointsRequest.h>
#include <aws/bedrock/model/ListMarketplaceModelEndpointsResult.h>
#include <aws/bedrock/model/ListModelCopyJobsRequest.h>
#include <aws/bedrock/model/ListModelCopyJobsResult.h>
#include <aws/bedrock/model/ListModelCustomizationJobsRequest.h>
#include <aws/bedrock/model/ListModelCustomizationJobsResult.h>
#include <aws/bedrock/model/ListModelImportJobsRequest.h>
#include <aws/bedrock/model/ListModelImportJobsResult.h>
#include <aws/bedrock/model/ListModelInvocationJobsRequest.h>
#include <aws/bedrock/model/ListModelInvocationJobsResult.h>
#include <aws/bedrock/model/ListPromptRoutersRequest.h>
#include <aws/bedrock/model/ListPromptRoutersResult.h>
#include <aws/bedrock/model/ListProvisionedModelThroughputsRequest.h>
#include <aws/bedrock/model/ListProvisionedModelThroughputsResult.h>
#include <aws/bedrock/model/ListTagsForResourceRequest.h>
#include <aws/bedrock/model/ListTagsForResourceResult.h>
#include <aws/bedrock/model/LoggingConfig.h>
#include <aws/bedrock/model/MarketplaceModelEndpoint.h>
#include <aws/bedrock/model/MarketplaceModelEndpointSummary.h>
#include <aws/bedrock/model/ModelCopyJobStatus.h>
#include <aws/bedrock/model/ModelCopyJobSummary.h>
#include <aws/bedrock/model/ModelCustomization.h>
#include <aws/bedrock/model/ModelCustomizationJobStatus.h>
#include <aws/bedrock/model/ModelCustomizationJobSummary.h>
#include <aws/bedrock/model/ModelDataSource.h>
#include <aws/bedrock/model/ModelImportJobStatus.h>
#include <aws/bedrock/model/ModelImportJobSummary.h>
#include <aws/bedrock/model/ModelInvocationJobInputDataConfig.h>
#include <aws/bedrock/model/ModelInvocationJobOutputDataConfig.h>
#include <aws/bedrock/model/ModelInvocationJobS3InputDataConfig.h>
#include <aws/bedrock/model/ModelInvocationJobS3OutputDataConfig.h>
#include <aws/bedrock/model/ModelInvocationJobStatus.h>
#include <aws/bedrock/model/ModelInvocationJobSummary.h>
#include <aws/bedrock/model/ModelModality.h>
#include <aws/bedrock/model/ModelStatus.h>
#include <aws/bedrock/model/Offer.h>
#include <aws/bedrock/model/OfferType.h>
#include <aws/bedrock/model/OrchestrationConfiguration.h>
#include <aws/bedrock/model/OutputDataConfig.h>
#include <aws/bedrock/model/PerformanceConfigLatency.h>
#include <aws/bedrock/model/PerformanceConfiguration.h>
#include <aws/bedrock/model/PricingTerm.h>
#include <aws/bedrock/model/PromptRouterStatus.h>
#include <aws/bedrock/model/PromptRouterSummary.h>
#include <aws/bedrock/model/PromptRouterTargetModel.h>
#include <aws/bedrock/model/PromptRouterType.h>
#include <aws/bedrock/model/PromptTemplate.h>
#include <aws/bedrock/model/ProvisionedModelStatus.h>
#include <aws/bedrock/model/ProvisionedModelSummary.h>
#include <aws/bedrock/model/PutModelInvocationLoggingConfigurationRequest.h>
#include <aws/bedrock/model/PutModelInvocationLoggingConfigurationResult.h>
#include <aws/bedrock/model/PutUseCaseForModelAccessRequest.h>
#include <aws/bedrock/model/PutUseCaseForModelAccessResult.h>
#include <aws/bedrock/model/QueryTransformationConfiguration.h>
#include <aws/bedrock/model/QueryTransformationType.h>
#include <aws/bedrock/model/RAGConfig.h>
#include <aws/bedrock/model/RatingScaleItem.h>
#include <aws/bedrock/model/RatingScaleItemValue.h>
#include <aws/bedrock/model/RegionAvailability.h>
#include <aws/bedrock/model/RegisterMarketplaceModelEndpointRequest.h>
#include <aws/bedrock/model/RegisterMarketplaceModelEndpointResult.h>
#include <aws/bedrock/model/RequestMetadataBaseFilters.h>
#include <aws/bedrock/model/RequestMetadataFilters.h>
#include <aws/bedrock/model/RetrievalFilter.h>
#include <aws/bedrock/model/RetrieveAndGenerateConfiguration.h>
#include <aws/bedrock/model/RetrieveAndGenerateType.h>
#include <aws/bedrock/model/RetrieveConfig.h>
#include <aws/bedrock/model/RoutingCriteria.h>
#include <aws/bedrock/model/S3Config.h>
#include <aws/bedrock/model/S3DataSource.h>
#include <aws/bedrock/model/S3InputFormat.h>
#include <aws/bedrock/model/S3ObjectDoc.h>
#include <aws/bedrock/model/SageMakerEndpoint.h>
#include <aws/bedrock/model/SearchType.h>
#include <aws/bedrock/model/SortByProvisionedModels.h>
#include <aws/bedrock/model/SortJobsBy.h>
#include <aws/bedrock/model/SortModelsBy.h>
#include <aws/bedrock/model/SortOrder.h>
#include <aws/bedrock/model/Status.h>
#include <aws/bedrock/model/StatusDetails.h>
#include <aws/bedrock/model/StopEvaluationJobRequest.h>
#include <aws/bedrock/model/StopEvaluationJobResult.h>
#include <aws/bedrock/model/StopModelCustomizationJobRequest.h>
#include <aws/bedrock/model/StopModelCustomizationJobResult.h>
#include <aws/bedrock/model/StopModelInvocationJobRequest.h>
#include <aws/bedrock/model/StopModelInvocationJobResult.h>
#include <aws/bedrock/model/SupportTerm.h>
#include <aws/bedrock/model/Tag.h>
#include <aws/bedrock/model/TagResourceRequest.h>
#include <aws/bedrock/model/TagResourceResult.h>
#include <aws/bedrock/model/TeacherModelConfig.h>
#include <aws/bedrock/model/TermDetails.h>
#include <aws/bedrock/model/TextInferenceConfig.h>
#include <aws/bedrock/model/TooManyTagsException.h>
#include <aws/bedrock/model/TrainingDataConfig.h>
#include <aws/bedrock/model/TrainingDetails.h>
#include <aws/bedrock/model/TrainingMetrics.h>
#include <aws/bedrock/model/UntagResourceRequest.h>
#include <aws/bedrock/model/UntagResourceResult.h>
#include <aws/bedrock/model/UpdateGuardrailRequest.h>
#include <aws/bedrock/model/UpdateGuardrailResult.h>
#include <aws/bedrock/model/UpdateMarketplaceModelEndpointRequest.h>
#include <aws/bedrock/model/UpdateMarketplaceModelEndpointResult.h>
#include <aws/bedrock/model/UpdateProvisionedModelThroughputRequest.h>
#include <aws/bedrock/model/UpdateProvisionedModelThroughputResult.h>
#include <aws/bedrock/model/ValidationDataConfig.h>
#include <aws/bedrock/model/ValidationDetails.h>
#include <aws/bedrock/model/Validator.h>
#include <aws/bedrock/model/ValidatorMetric.h>
#include <aws/bedrock/model/ValidityTerm.h>
#include <aws/bedrock/model/VpcConfig.h>

using BedrockIncludeTest = ::testing::Test;

TEST_F(BedrockIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::Bedrock::BedrockClient>("BedrockIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
