/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/bedrock-runtime/BedrockRuntimeClient.h>
#include <aws/bedrock-runtime/BedrockRuntimeEndpointProvider.h>
#include <aws/bedrock-runtime/BedrockRuntimeEndpointRules.h>
#include <aws/bedrock-runtime/BedrockRuntimeErrorMarshaller.h>
#include <aws/bedrock-runtime/BedrockRuntimeErrors.h>
#include <aws/bedrock-runtime/BedrockRuntimeRequest.h>
#include <aws/bedrock-runtime/BedrockRuntimeServiceClientModel.h>
#include <aws/bedrock-runtime/BedrockRuntime_EXPORTS.h>
#include <aws/bedrock-runtime/model/AnyToolChoice.h>
#include <aws/bedrock-runtime/model/ApplyGuardrailRequest.h>
#include <aws/bedrock-runtime/model/ApplyGuardrailResult.h>
#include <aws/bedrock-runtime/model/AsyncInvokeOutputDataConfig.h>
#include <aws/bedrock-runtime/model/AsyncInvokeS3OutputDataConfig.h>
#include <aws/bedrock-runtime/model/AsyncInvokeStatus.h>
#include <aws/bedrock-runtime/model/AsyncInvokeSummary.h>
#include <aws/bedrock-runtime/model/AutoToolChoice.h>
#include <aws/bedrock-runtime/model/BidirectionalInputPayloadPart.h>
#include <aws/bedrock-runtime/model/BidirectionalOutputPayloadPart.h>
#include <aws/bedrock-runtime/model/CachePointBlock.h>
#include <aws/bedrock-runtime/model/CachePointType.h>
#include <aws/bedrock-runtime/model/ContentBlock.h>
#include <aws/bedrock-runtime/model/ContentBlockDelta.h>
#include <aws/bedrock-runtime/model/ContentBlockDeltaEvent.h>
#include <aws/bedrock-runtime/model/ContentBlockStart.h>
#include <aws/bedrock-runtime/model/ContentBlockStartEvent.h>
#include <aws/bedrock-runtime/model/ContentBlockStopEvent.h>
#include <aws/bedrock-runtime/model/ConversationRole.h>
#include <aws/bedrock-runtime/model/ConverseMetrics.h>
#include <aws/bedrock-runtime/model/ConverseOutput.h>
#include <aws/bedrock-runtime/model/ConverseRequest.h>
#include <aws/bedrock-runtime/model/ConverseResult.h>
#include <aws/bedrock-runtime/model/ConverseStreamHandler.h>
#include <aws/bedrock-runtime/model/ConverseStreamInitialResponse.h>
#include <aws/bedrock-runtime/model/ConverseStreamMetadataEvent.h>
#include <aws/bedrock-runtime/model/ConverseStreamMetrics.h>
#include <aws/bedrock-runtime/model/ConverseStreamOutput.h>
#include <aws/bedrock-runtime/model/ConverseStreamRequest.h>
#include <aws/bedrock-runtime/model/ConverseStreamTrace.h>
#include <aws/bedrock-runtime/model/ConverseTrace.h>
#include <aws/bedrock-runtime/model/DocumentBlock.h>
#include <aws/bedrock-runtime/model/DocumentFormat.h>
#include <aws/bedrock-runtime/model/DocumentSource.h>
#include <aws/bedrock-runtime/model/GetAsyncInvokeRequest.h>
#include <aws/bedrock-runtime/model/GetAsyncInvokeResult.h>
#include <aws/bedrock-runtime/model/GuardrailAction.h>
#include <aws/bedrock-runtime/model/GuardrailAssessment.h>
#include <aws/bedrock-runtime/model/GuardrailConfiguration.h>
#include <aws/bedrock-runtime/model/GuardrailContentBlock.h>
#include <aws/bedrock-runtime/model/GuardrailContentFilter.h>
#include <aws/bedrock-runtime/model/GuardrailContentFilterConfidence.h>
#include <aws/bedrock-runtime/model/GuardrailContentFilterStrength.h>
#include <aws/bedrock-runtime/model/GuardrailContentFilterType.h>
#include <aws/bedrock-runtime/model/GuardrailContentPolicyAction.h>
#include <aws/bedrock-runtime/model/GuardrailContentPolicyAssessment.h>
#include <aws/bedrock-runtime/model/GuardrailContentQualifier.h>
#include <aws/bedrock-runtime/model/GuardrailContentSource.h>
#include <aws/bedrock-runtime/model/GuardrailContextualGroundingFilter.h>
#include <aws/bedrock-runtime/model/GuardrailContextualGroundingFilterType.h>
#include <aws/bedrock-runtime/model/GuardrailContextualGroundingPolicyAction.h>
#include <aws/bedrock-runtime/model/GuardrailContextualGroundingPolicyAssessment.h>
#include <aws/bedrock-runtime/model/GuardrailConverseContentBlock.h>
#include <aws/bedrock-runtime/model/GuardrailConverseContentQualifier.h>
#include <aws/bedrock-runtime/model/GuardrailConverseImageBlock.h>
#include <aws/bedrock-runtime/model/GuardrailConverseImageFormat.h>
#include <aws/bedrock-runtime/model/GuardrailConverseImageSource.h>
#include <aws/bedrock-runtime/model/GuardrailConverseTextBlock.h>
#include <aws/bedrock-runtime/model/GuardrailCoverage.h>
#include <aws/bedrock-runtime/model/GuardrailCustomWord.h>
#include <aws/bedrock-runtime/model/GuardrailImageBlock.h>
#include <aws/bedrock-runtime/model/GuardrailImageCoverage.h>
#include <aws/bedrock-runtime/model/GuardrailImageFormat.h>
#include <aws/bedrock-runtime/model/GuardrailImageSource.h>
#include <aws/bedrock-runtime/model/GuardrailInvocationMetrics.h>
#include <aws/bedrock-runtime/model/GuardrailManagedWord.h>
#include <aws/bedrock-runtime/model/GuardrailManagedWordType.h>
#include <aws/bedrock-runtime/model/GuardrailOutputContent.h>
#include <aws/bedrock-runtime/model/GuardrailOutputScope.h>
#include <aws/bedrock-runtime/model/GuardrailPiiEntityFilter.h>
#include <aws/bedrock-runtime/model/GuardrailPiiEntityType.h>
#include <aws/bedrock-runtime/model/GuardrailRegexFilter.h>
#include <aws/bedrock-runtime/model/GuardrailSensitiveInformationPolicyAction.h>
#include <aws/bedrock-runtime/model/GuardrailSensitiveInformationPolicyAssessment.h>
#include <aws/bedrock-runtime/model/GuardrailStreamConfiguration.h>
#include <aws/bedrock-runtime/model/GuardrailStreamProcessingMode.h>
#include <aws/bedrock-runtime/model/GuardrailTextBlock.h>
#include <aws/bedrock-runtime/model/GuardrailTextCharactersCoverage.h>
#include <aws/bedrock-runtime/model/GuardrailTopic.h>
#include <aws/bedrock-runtime/model/GuardrailTopicPolicyAction.h>
#include <aws/bedrock-runtime/model/GuardrailTopicPolicyAssessment.h>
#include <aws/bedrock-runtime/model/GuardrailTopicType.h>
#include <aws/bedrock-runtime/model/GuardrailTrace.h>
#include <aws/bedrock-runtime/model/GuardrailTraceAssessment.h>
#include <aws/bedrock-runtime/model/GuardrailUsage.h>
#include <aws/bedrock-runtime/model/GuardrailWordPolicyAction.h>
#include <aws/bedrock-runtime/model/GuardrailWordPolicyAssessment.h>
#include <aws/bedrock-runtime/model/ImageBlock.h>
#include <aws/bedrock-runtime/model/ImageFormat.h>
#include <aws/bedrock-runtime/model/ImageSource.h>
#include <aws/bedrock-runtime/model/InferenceConfiguration.h>
#include <aws/bedrock-runtime/model/InvokeModelRequest.h>
#include <aws/bedrock-runtime/model/InvokeModelResult.h>
#include <aws/bedrock-runtime/model/InvokeModelWithBidirectionalStreamHandler.h>
#include <aws/bedrock-runtime/model/InvokeModelWithBidirectionalStreamInitialResponse.h>
#include <aws/bedrock-runtime/model/InvokeModelWithBidirectionalStreamInput.h>
#include <aws/bedrock-runtime/model/InvokeModelWithBidirectionalStreamOutput.h>
#include <aws/bedrock-runtime/model/InvokeModelWithBidirectionalStreamRequest.h>
#include <aws/bedrock-runtime/model/InvokeModelWithResponseStreamHandler.h>
#include <aws/bedrock-runtime/model/InvokeModelWithResponseStreamInitialResponse.h>
#include <aws/bedrock-runtime/model/InvokeModelWithResponseStreamRequest.h>
#include <aws/bedrock-runtime/model/ListAsyncInvokesRequest.h>
#include <aws/bedrock-runtime/model/ListAsyncInvokesResult.h>
#include <aws/bedrock-runtime/model/Message.h>
#include <aws/bedrock-runtime/model/MessageStartEvent.h>
#include <aws/bedrock-runtime/model/MessageStopEvent.h>
#include <aws/bedrock-runtime/model/ModelErrorException.h>
#include <aws/bedrock-runtime/model/ModelStreamErrorException.h>
#include <aws/bedrock-runtime/model/PayloadPart.h>
#include <aws/bedrock-runtime/model/PerformanceConfigLatency.h>
#include <aws/bedrock-runtime/model/PerformanceConfiguration.h>
#include <aws/bedrock-runtime/model/PromptRouterTrace.h>
#include <aws/bedrock-runtime/model/PromptVariableValues.h>
#include <aws/bedrock-runtime/model/ReasoningContentBlock.h>
#include <aws/bedrock-runtime/model/ReasoningContentBlockDelta.h>
#include <aws/bedrock-runtime/model/ReasoningTextBlock.h>
#include <aws/bedrock-runtime/model/ResponseStream.h>
#include <aws/bedrock-runtime/model/S3Location.h>
#include <aws/bedrock-runtime/model/SortAsyncInvocationBy.h>
#include <aws/bedrock-runtime/model/SortOrder.h>
#include <aws/bedrock-runtime/model/SpecificToolChoice.h>
#include <aws/bedrock-runtime/model/StartAsyncInvokeRequest.h>
#include <aws/bedrock-runtime/model/StartAsyncInvokeResult.h>
#include <aws/bedrock-runtime/model/StopReason.h>
#include <aws/bedrock-runtime/model/SystemContentBlock.h>
#include <aws/bedrock-runtime/model/Tag.h>
#include <aws/bedrock-runtime/model/TokenUsage.h>
#include <aws/bedrock-runtime/model/Tool.h>
#include <aws/bedrock-runtime/model/ToolChoice.h>
#include <aws/bedrock-runtime/model/ToolConfiguration.h>
#include <aws/bedrock-runtime/model/ToolInputSchema.h>
#include <aws/bedrock-runtime/model/ToolResultBlock.h>
#include <aws/bedrock-runtime/model/ToolResultContentBlock.h>
#include <aws/bedrock-runtime/model/ToolResultStatus.h>
#include <aws/bedrock-runtime/model/ToolSpecification.h>
#include <aws/bedrock-runtime/model/ToolUseBlock.h>
#include <aws/bedrock-runtime/model/ToolUseBlockDelta.h>
#include <aws/bedrock-runtime/model/ToolUseBlockStart.h>
#include <aws/bedrock-runtime/model/Trace.h>
#include <aws/bedrock-runtime/model/VideoBlock.h>
#include <aws/bedrock-runtime/model/VideoFormat.h>
#include <aws/bedrock-runtime/model/VideoSource.h>

using BedrockRuntimeIncludeTest = ::testing::Test;

TEST_F(BedrockRuntimeIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::BedrockRuntime::BedrockRuntimeClient>("BedrockRuntimeIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
