/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/ce/CostExplorerClient.h>
#include <aws/ce/CostExplorerEndpointProvider.h>
#include <aws/ce/CostExplorerEndpointRules.h>
#include <aws/ce/CostExplorerErrorMarshaller.h>
#include <aws/ce/CostExplorerErrors.h>
#include <aws/ce/CostExplorerRequest.h>
#include <aws/ce/CostExplorerServiceClientModel.h>
#include <aws/ce/CostExplorer_EXPORTS.h>
#include <aws/ce/model/AccountScope.h>
#include <aws/ce/model/AnalysisDetails.h>
#include <aws/ce/model/AnalysisStatus.h>
#include <aws/ce/model/AnalysisSummary.h>
#include <aws/ce/model/AnalysisType.h>
#include <aws/ce/model/Anomaly.h>
#include <aws/ce/model/AnomalyDateInterval.h>
#include <aws/ce/model/AnomalyFeedbackType.h>
#include <aws/ce/model/AnomalyMonitor.h>
#include <aws/ce/model/AnomalyScore.h>
#include <aws/ce/model/AnomalySubscription.h>
#include <aws/ce/model/AnomalySubscriptionFrequency.h>
#include <aws/ce/model/ApproximationDimension.h>
#include <aws/ce/model/CommitmentPurchaseAnalysisConfiguration.h>
#include <aws/ce/model/ComparisonMetricValue.h>
#include <aws/ce/model/Context.h>
#include <aws/ce/model/CostAllocationTag.h>
#include <aws/ce/model/CostAllocationTagBackfillRequest.h>
#include <aws/ce/model/CostAllocationTagBackfillStatus.h>
#include <aws/ce/model/CostAllocationTagStatus.h>
#include <aws/ce/model/CostAllocationTagStatusEntry.h>
#include <aws/ce/model/CostAllocationTagType.h>
#include <aws/ce/model/CostAndUsageComparison.h>
#include <aws/ce/model/CostCategory.h>
#include <aws/ce/model/CostCategoryInheritedValueDimension.h>
#include <aws/ce/model/CostCategoryInheritedValueDimensionName.h>
#include <aws/ce/model/CostCategoryProcessingStatus.h>
#include <aws/ce/model/CostCategoryReference.h>
#include <aws/ce/model/CostCategoryRule.h>
#include <aws/ce/model/CostCategoryRuleType.h>
#include <aws/ce/model/CostCategoryRuleVersion.h>
#include <aws/ce/model/CostCategorySplitChargeMethod.h>
#include <aws/ce/model/CostCategorySplitChargeRule.h>
#include <aws/ce/model/CostCategorySplitChargeRuleParameter.h>
#include <aws/ce/model/CostCategorySplitChargeRuleParameterType.h>
#include <aws/ce/model/CostCategoryStatus.h>
#include <aws/ce/model/CostCategoryStatusComponent.h>
#include <aws/ce/model/CostCategoryValues.h>
#include <aws/ce/model/CostComparisonDriver.h>
#include <aws/ce/model/CostDriver.h>
#include <aws/ce/model/Coverage.h>
#include <aws/ce/model/CoverageByTime.h>
#include <aws/ce/model/CoverageCost.h>
#include <aws/ce/model/CoverageHours.h>
#include <aws/ce/model/CoverageNormalizedUnits.h>
#include <aws/ce/model/CreateAnomalyMonitorRequest.h>
#include <aws/ce/model/CreateAnomalyMonitorResult.h>
#include <aws/ce/model/CreateAnomalySubscriptionRequest.h>
#include <aws/ce/model/CreateAnomalySubscriptionResult.h>
#include <aws/ce/model/CreateCostCategoryDefinitionRequest.h>
#include <aws/ce/model/CreateCostCategoryDefinitionResult.h>
#include <aws/ce/model/CurrentInstance.h>
#include <aws/ce/model/DateInterval.h>
#include <aws/ce/model/DeleteAnomalyMonitorRequest.h>
#include <aws/ce/model/DeleteAnomalyMonitorResult.h>
#include <aws/ce/model/DeleteAnomalySubscriptionRequest.h>
#include <aws/ce/model/DeleteAnomalySubscriptionResult.h>
#include <aws/ce/model/DeleteCostCategoryDefinitionRequest.h>
#include <aws/ce/model/DeleteCostCategoryDefinitionResult.h>
#include <aws/ce/model/DescribeCostCategoryDefinitionRequest.h>
#include <aws/ce/model/DescribeCostCategoryDefinitionResult.h>
#include <aws/ce/model/Dimension.h>
#include <aws/ce/model/DimensionValues.h>
#include <aws/ce/model/DimensionValuesWithAttributes.h>
#include <aws/ce/model/DiskResourceUtilization.h>
#include <aws/ce/model/DynamoDBCapacityDetails.h>
#include <aws/ce/model/EBSResourceUtilization.h>
#include <aws/ce/model/EC2InstanceDetails.h>
#include <aws/ce/model/EC2ResourceDetails.h>
#include <aws/ce/model/EC2ResourceUtilization.h>
#include <aws/ce/model/EC2Specification.h>
#include <aws/ce/model/ESInstanceDetails.h>
#include <aws/ce/model/ElastiCacheInstanceDetails.h>
#include <aws/ce/model/ErrorCode.h>
#include <aws/ce/model/Expression.h>
#include <aws/ce/model/FindingReasonCode.h>
#include <aws/ce/model/ForecastResult.h>
#include <aws/ce/model/GenerationStatus.h>
#include <aws/ce/model/GenerationSummary.h>
#include <aws/ce/model/GetAnomaliesRequest.h>
#include <aws/ce/model/GetAnomaliesResult.h>
#include <aws/ce/model/GetAnomalyMonitorsRequest.h>
#include <aws/ce/model/GetAnomalyMonitorsResult.h>
#include <aws/ce/model/GetAnomalySubscriptionsRequest.h>
#include <aws/ce/model/GetAnomalySubscriptionsResult.h>
#include <aws/ce/model/GetApproximateUsageRecordsRequest.h>
#include <aws/ce/model/GetApproximateUsageRecordsResult.h>
#include <aws/ce/model/GetCommitmentPurchaseAnalysisRequest.h>
#include <aws/ce/model/GetCommitmentPurchaseAnalysisResult.h>
#include <aws/ce/model/GetCostAndUsageComparisonsRequest.h>
#include <aws/ce/model/GetCostAndUsageComparisonsResult.h>
#include <aws/ce/model/GetCostAndUsageRequest.h>
#include <aws/ce/model/GetCostAndUsageResult.h>
#include <aws/ce/model/GetCostAndUsageWithResourcesRequest.h>
#include <aws/ce/model/GetCostAndUsageWithResourcesResult.h>
#include <aws/ce/model/GetCostCategoriesRequest.h>
#include <aws/ce/model/GetCostCategoriesResult.h>
#include <aws/ce/model/GetCostComparisonDriversRequest.h>
#include <aws/ce/model/GetCostComparisonDriversResult.h>
#include <aws/ce/model/GetCostForecastRequest.h>
#include <aws/ce/model/GetCostForecastResult.h>
#include <aws/ce/model/GetDimensionValuesRequest.h>
#include <aws/ce/model/GetDimensionValuesResult.h>
#include <aws/ce/model/GetReservationCoverageRequest.h>
#include <aws/ce/model/GetReservationCoverageResult.h>
#include <aws/ce/model/GetReservationPurchaseRecommendationRequest.h>
#include <aws/ce/model/GetReservationPurchaseRecommendationResult.h>
#include <aws/ce/model/GetReservationUtilizationRequest.h>
#include <aws/ce/model/GetReservationUtilizationResult.h>
#include <aws/ce/model/GetRightsizingRecommendationRequest.h>
#include <aws/ce/model/GetRightsizingRecommendationResult.h>
#include <aws/ce/model/GetSavingsPlanPurchaseRecommendationDetailsRequest.h>
#include <aws/ce/model/GetSavingsPlanPurchaseRecommendationDetailsResult.h>
#include <aws/ce/model/GetSavingsPlansCoverageRequest.h>
#include <aws/ce/model/GetSavingsPlansCoverageResult.h>
#include <aws/ce/model/GetSavingsPlansPurchaseRecommendationRequest.h>
#include <aws/ce/model/GetSavingsPlansPurchaseRecommendationResult.h>
#include <aws/ce/model/GetSavingsPlansUtilizationDetailsRequest.h>
#include <aws/ce/model/GetSavingsPlansUtilizationDetailsResult.h>
#include <aws/ce/model/GetSavingsPlansUtilizationRequest.h>
#include <aws/ce/model/GetSavingsPlansUtilizationResult.h>
#include <aws/ce/model/GetTagsRequest.h>
#include <aws/ce/model/GetTagsResult.h>
#include <aws/ce/model/GetUsageForecastRequest.h>
#include <aws/ce/model/GetUsageForecastResult.h>
#include <aws/ce/model/Granularity.h>
#include <aws/ce/model/Group.h>
#include <aws/ce/model/GroupDefinition.h>
#include <aws/ce/model/GroupDefinitionType.h>
#include <aws/ce/model/Impact.h>
#include <aws/ce/model/InstanceDetails.h>
#include <aws/ce/model/ListCommitmentPurchaseAnalysesRequest.h>
#include <aws/ce/model/ListCommitmentPurchaseAnalysesResult.h>
#include <aws/ce/model/ListCostAllocationTagBackfillHistoryRequest.h>
#include <aws/ce/model/ListCostAllocationTagBackfillHistoryResult.h>
#include <aws/ce/model/ListCostAllocationTagsRequest.h>
#include <aws/ce/model/ListCostAllocationTagsResult.h>
#include <aws/ce/model/ListCostCategoryDefinitionsRequest.h>
#include <aws/ce/model/ListCostCategoryDefinitionsResult.h>
#include <aws/ce/model/ListSavingsPlansPurchaseRecommendationGenerationRequest.h>
#include <aws/ce/model/ListSavingsPlansPurchaseRecommendationGenerationResult.h>
#include <aws/ce/model/ListTagsForResourceRequest.h>
#include <aws/ce/model/ListTagsForResourceResult.h>
#include <aws/ce/model/LookbackPeriodInDays.h>
#include <aws/ce/model/MatchOption.h>
#include <aws/ce/model/MemoryDBInstanceDetails.h>
#include <aws/ce/model/Metric.h>
#include <aws/ce/model/MetricValue.h>
#include <aws/ce/model/ModifyRecommendationDetail.h>
#include <aws/ce/model/MonitorDimension.h>
#include <aws/ce/model/MonitorType.h>
#include <aws/ce/model/NetworkResourceUtilization.h>
#include <aws/ce/model/NumericOperator.h>
#include <aws/ce/model/OfferingClass.h>
#include <aws/ce/model/PaymentOption.h>
#include <aws/ce/model/PlatformDifference.h>
#include <aws/ce/model/ProvideAnomalyFeedbackRequest.h>
#include <aws/ce/model/ProvideAnomalyFeedbackResult.h>
#include <aws/ce/model/RDSInstanceDetails.h>
#include <aws/ce/model/RecommendationDetailData.h>
#include <aws/ce/model/RecommendationDetailHourlyMetrics.h>
#include <aws/ce/model/RecommendationTarget.h>
#include <aws/ce/model/RedshiftInstanceDetails.h>
#include <aws/ce/model/ReservationAggregates.h>
#include <aws/ce/model/ReservationCoverageGroup.h>
#include <aws/ce/model/ReservationPurchaseRecommendation.h>
#include <aws/ce/model/ReservationPurchaseRecommendationDetail.h>
#include <aws/ce/model/ReservationPurchaseRecommendationMetadata.h>
#include <aws/ce/model/ReservationPurchaseRecommendationSummary.h>
#include <aws/ce/model/ReservationUtilizationGroup.h>
#include <aws/ce/model/ReservedCapacityDetails.h>
#include <aws/ce/model/ResourceDetails.h>
#include <aws/ce/model/ResourceNotFoundException.h>
#include <aws/ce/model/ResourceTag.h>
#include <aws/ce/model/ResourceUtilization.h>
#include <aws/ce/model/ResultByTime.h>
#include <aws/ce/model/RightsizingRecommendation.h>
#include <aws/ce/model/RightsizingRecommendationConfiguration.h>
#include <aws/ce/model/RightsizingRecommendationMetadata.h>
#include <aws/ce/model/RightsizingRecommendationSummary.h>
#include <aws/ce/model/RightsizingType.h>
#include <aws/ce/model/RootCause.h>
#include <aws/ce/model/RootCauseImpact.h>
#include <aws/ce/model/SavingsPlans.h>
#include <aws/ce/model/SavingsPlansAmortizedCommitment.h>
#include <aws/ce/model/SavingsPlansCoverage.h>
#include <aws/ce/model/SavingsPlansCoverageData.h>
#include <aws/ce/model/SavingsPlansDataType.h>
#include <aws/ce/model/SavingsPlansDetails.h>
#include <aws/ce/model/SavingsPlansPurchaseAnalysisConfiguration.h>
#include <aws/ce/model/SavingsPlansPurchaseAnalysisDetails.h>
#include <aws/ce/model/SavingsPlansPurchaseRecommendation.h>
#include <aws/ce/model/SavingsPlansPurchaseRecommendationDetail.h>
#include <aws/ce/model/SavingsPlansPurchaseRecommendationMetadata.h>
#include <aws/ce/model/SavingsPlansPurchaseRecommendationSummary.h>
#include <aws/ce/model/SavingsPlansSavings.h>
#include <aws/ce/model/SavingsPlansUtilization.h>
#include <aws/ce/model/SavingsPlansUtilizationAggregates.h>
#include <aws/ce/model/SavingsPlansUtilizationByTime.h>
#include <aws/ce/model/SavingsPlansUtilizationDetail.h>
#include <aws/ce/model/ServiceSpecification.h>
#include <aws/ce/model/SortDefinition.h>
#include <aws/ce/model/SortOrder.h>
#include <aws/ce/model/StartCommitmentPurchaseAnalysisRequest.h>
#include <aws/ce/model/StartCommitmentPurchaseAnalysisResult.h>
#include <aws/ce/model/StartCostAllocationTagBackfillRequest.h>
#include <aws/ce/model/StartCostAllocationTagBackfillResult.h>
#include <aws/ce/model/StartSavingsPlansPurchaseRecommendationGenerationRequest.h>
#include <aws/ce/model/StartSavingsPlansPurchaseRecommendationGenerationResult.h>
#include <aws/ce/model/Subscriber.h>
#include <aws/ce/model/SubscriberStatus.h>
#include <aws/ce/model/SubscriberType.h>
#include <aws/ce/model/SupportedSavingsPlansType.h>
#include <aws/ce/model/TagResourceRequest.h>
#include <aws/ce/model/TagResourceResult.h>
#include <aws/ce/model/TagValues.h>
#include <aws/ce/model/TargetInstance.h>
#include <aws/ce/model/TermInYears.h>
#include <aws/ce/model/TerminateRecommendationDetail.h>
#include <aws/ce/model/TooManyTagsException.h>
#include <aws/ce/model/TotalImpactFilter.h>
#include <aws/ce/model/UntagResourceRequest.h>
#include <aws/ce/model/UntagResourceResult.h>
#include <aws/ce/model/UpdateAnomalyMonitorRequest.h>
#include <aws/ce/model/UpdateAnomalyMonitorResult.h>
#include <aws/ce/model/UpdateAnomalySubscriptionRequest.h>
#include <aws/ce/model/UpdateAnomalySubscriptionResult.h>
#include <aws/ce/model/UpdateCostAllocationTagsStatusError.h>
#include <aws/ce/model/UpdateCostAllocationTagsStatusRequest.h>
#include <aws/ce/model/UpdateCostAllocationTagsStatusResult.h>
#include <aws/ce/model/UpdateCostCategoryDefinitionRequest.h>
#include <aws/ce/model/UpdateCostCategoryDefinitionResult.h>
#include <aws/ce/model/UtilizationByTime.h>

using CostExplorerIncludeTest = ::testing::Test;

TEST_F(CostExplorerIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::CostExplorer::CostExplorerClient>("CostExplorerIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
