/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/chime/ChimeClient.h>
#include <aws/chime/ChimeEndpointProvider.h>
#include <aws/chime/ChimeEndpointRules.h>
#include <aws/chime/ChimeErrorMarshaller.h>
#include <aws/chime/ChimeErrors.h>
#include <aws/chime/ChimeRequest.h>
#include <aws/chime/ChimeServiceClientModel.h>
#include <aws/chime/Chime_EXPORTS.h>
#include <aws/chime/model/AccessDeniedException.h>
#include <aws/chime/model/Account.h>
#include <aws/chime/model/AccountSettings.h>
#include <aws/chime/model/AccountStatus.h>
#include <aws/chime/model/AccountType.h>
#include <aws/chime/model/AlexaForBusinessMetadata.h>
#include <aws/chime/model/AssociatePhoneNumberWithUserRequest.h>
#include <aws/chime/model/AssociatePhoneNumberWithUserResult.h>
#include <aws/chime/model/AssociateSigninDelegateGroupsWithAccountRequest.h>
#include <aws/chime/model/AssociateSigninDelegateGroupsWithAccountResult.h>
#include <aws/chime/model/BadRequestException.h>
#include <aws/chime/model/BatchCreateRoomMembershipRequest.h>
#include <aws/chime/model/BatchCreateRoomMembershipResult.h>
#include <aws/chime/model/BatchDeletePhoneNumberRequest.h>
#include <aws/chime/model/BatchDeletePhoneNumberResult.h>
#include <aws/chime/model/BatchSuspendUserRequest.h>
#include <aws/chime/model/BatchSuspendUserResult.h>
#include <aws/chime/model/BatchUnsuspendUserRequest.h>
#include <aws/chime/model/BatchUnsuspendUserResult.h>
#include <aws/chime/model/BatchUpdatePhoneNumberRequest.h>
#include <aws/chime/model/BatchUpdatePhoneNumberResult.h>
#include <aws/chime/model/BatchUpdateUserRequest.h>
#include <aws/chime/model/BatchUpdateUserResult.h>
#include <aws/chime/model/Bot.h>
#include <aws/chime/model/BotType.h>
#include <aws/chime/model/BusinessCallingSettings.h>
#include <aws/chime/model/CallingNameStatus.h>
#include <aws/chime/model/ConflictException.h>
#include <aws/chime/model/ConversationRetentionSettings.h>
#include <aws/chime/model/CreateAccountRequest.h>
#include <aws/chime/model/CreateAccountResult.h>
#include <aws/chime/model/CreateBotRequest.h>
#include <aws/chime/model/CreateBotResult.h>
#include <aws/chime/model/CreateMeetingDialOutRequest.h>
#include <aws/chime/model/CreateMeetingDialOutResult.h>
#include <aws/chime/model/CreatePhoneNumberOrderRequest.h>
#include <aws/chime/model/CreatePhoneNumberOrderResult.h>
#include <aws/chime/model/CreateRoomMembershipRequest.h>
#include <aws/chime/model/CreateRoomMembershipResult.h>
#include <aws/chime/model/CreateRoomRequest.h>
#include <aws/chime/model/CreateRoomResult.h>
#include <aws/chime/model/CreateUserRequest.h>
#include <aws/chime/model/CreateUserResult.h>
#include <aws/chime/model/DeleteAccountRequest.h>
#include <aws/chime/model/DeleteAccountResult.h>
#include <aws/chime/model/DeleteEventsConfigurationRequest.h>
#include <aws/chime/model/DeletePhoneNumberRequest.h>
#include <aws/chime/model/DeleteRoomMembershipRequest.h>
#include <aws/chime/model/DeleteRoomRequest.h>
#include <aws/chime/model/DisassociatePhoneNumberFromUserRequest.h>
#include <aws/chime/model/DisassociatePhoneNumberFromUserResult.h>
#include <aws/chime/model/DisassociateSigninDelegateGroupsFromAccountRequest.h>
#include <aws/chime/model/DisassociateSigninDelegateGroupsFromAccountResult.h>
#include <aws/chime/model/EmailStatus.h>
#include <aws/chime/model/ErrorCode.h>
#include <aws/chime/model/EventsConfiguration.h>
#include <aws/chime/model/ForbiddenException.h>
#include <aws/chime/model/GetAccountRequest.h>
#include <aws/chime/model/GetAccountResult.h>
#include <aws/chime/model/GetAccountSettingsRequest.h>
#include <aws/chime/model/GetAccountSettingsResult.h>
#include <aws/chime/model/GetBotRequest.h>
#include <aws/chime/model/GetBotResult.h>
#include <aws/chime/model/GetEventsConfigurationRequest.h>
#include <aws/chime/model/GetEventsConfigurationResult.h>
#include <aws/chime/model/GetGlobalSettingsRequest.h>
#include <aws/chime/model/GetGlobalSettingsResult.h>
#include <aws/chime/model/GetPhoneNumberOrderRequest.h>
#include <aws/chime/model/GetPhoneNumberOrderResult.h>
#include <aws/chime/model/GetPhoneNumberRequest.h>
#include <aws/chime/model/GetPhoneNumberResult.h>
#include <aws/chime/model/GetPhoneNumberSettingsRequest.h>
#include <aws/chime/model/GetPhoneNumberSettingsResult.h>
#include <aws/chime/model/GetRetentionSettingsRequest.h>
#include <aws/chime/model/GetRetentionSettingsResult.h>
#include <aws/chime/model/GetRoomRequest.h>
#include <aws/chime/model/GetRoomResult.h>
#include <aws/chime/model/GetUserRequest.h>
#include <aws/chime/model/GetUserResult.h>
#include <aws/chime/model/GetUserSettingsRequest.h>
#include <aws/chime/model/GetUserSettingsResult.h>
#include <aws/chime/model/Invite.h>
#include <aws/chime/model/InviteStatus.h>
#include <aws/chime/model/InviteUsersRequest.h>
#include <aws/chime/model/InviteUsersResult.h>
#include <aws/chime/model/License.h>
#include <aws/chime/model/ListAccountsRequest.h>
#include <aws/chime/model/ListAccountsResult.h>
#include <aws/chime/model/ListBotsRequest.h>
#include <aws/chime/model/ListBotsResult.h>
#include <aws/chime/model/ListPhoneNumberOrdersRequest.h>
#include <aws/chime/model/ListPhoneNumberOrdersResult.h>
#include <aws/chime/model/ListPhoneNumbersRequest.h>
#include <aws/chime/model/ListPhoneNumbersResult.h>
#include <aws/chime/model/ListRoomMembershipsRequest.h>
#include <aws/chime/model/ListRoomMembershipsResult.h>
#include <aws/chime/model/ListRoomsRequest.h>
#include <aws/chime/model/ListRoomsResult.h>
#include <aws/chime/model/ListSupportedPhoneNumberCountriesRequest.h>
#include <aws/chime/model/ListSupportedPhoneNumberCountriesResult.h>
#include <aws/chime/model/ListUsersRequest.h>
#include <aws/chime/model/ListUsersResult.h>
#include <aws/chime/model/LogoutUserRequest.h>
#include <aws/chime/model/LogoutUserResult.h>
#include <aws/chime/model/Member.h>
#include <aws/chime/model/MemberError.h>
#include <aws/chime/model/MemberType.h>
#include <aws/chime/model/MembershipItem.h>
#include <aws/chime/model/NotFoundException.h>
#include <aws/chime/model/OrderedPhoneNumber.h>
#include <aws/chime/model/OrderedPhoneNumberStatus.h>
#include <aws/chime/model/PhoneNumber.h>
#include <aws/chime/model/PhoneNumberAssociation.h>
#include <aws/chime/model/PhoneNumberAssociationName.h>
#include <aws/chime/model/PhoneNumberCapabilities.h>
#include <aws/chime/model/PhoneNumberCountry.h>
#include <aws/chime/model/PhoneNumberError.h>
#include <aws/chime/model/PhoneNumberOrder.h>
#include <aws/chime/model/PhoneNumberOrderStatus.h>
#include <aws/chime/model/PhoneNumberProductType.h>
#include <aws/chime/model/PhoneNumberStatus.h>
#include <aws/chime/model/PhoneNumberType.h>
#include <aws/chime/model/PutEventsConfigurationRequest.h>
#include <aws/chime/model/PutEventsConfigurationResult.h>
#include <aws/chime/model/PutRetentionSettingsRequest.h>
#include <aws/chime/model/PutRetentionSettingsResult.h>
#include <aws/chime/model/RedactConversationMessageRequest.h>
#include <aws/chime/model/RedactConversationMessageResult.h>
#include <aws/chime/model/RedactRoomMessageRequest.h>
#include <aws/chime/model/RedactRoomMessageResult.h>
#include <aws/chime/model/RegenerateSecurityTokenRequest.h>
#include <aws/chime/model/RegenerateSecurityTokenResult.h>
#include <aws/chime/model/RegistrationStatus.h>
#include <aws/chime/model/ResetPersonalPINRequest.h>
#include <aws/chime/model/ResetPersonalPINResult.h>
#include <aws/chime/model/ResourceLimitExceededException.h>
#include <aws/chime/model/RestorePhoneNumberRequest.h>
#include <aws/chime/model/RestorePhoneNumberResult.h>
#include <aws/chime/model/RetentionSettings.h>
#include <aws/chime/model/Room.h>
#include <aws/chime/model/RoomMembership.h>
#include <aws/chime/model/RoomMembershipRole.h>
#include <aws/chime/model/RoomRetentionSettings.h>
#include <aws/chime/model/SearchAvailablePhoneNumbersRequest.h>
#include <aws/chime/model/SearchAvailablePhoneNumbersResult.h>
#include <aws/chime/model/ServiceFailureException.h>
#include <aws/chime/model/ServiceUnavailableException.h>
#include <aws/chime/model/SigninDelegateGroup.h>
#include <aws/chime/model/TelephonySettings.h>
#include <aws/chime/model/ThrottledClientException.h>
#include <aws/chime/model/UnauthorizedClientException.h>
#include <aws/chime/model/UnprocessableEntityException.h>
#include <aws/chime/model/UpdateAccountRequest.h>
#include <aws/chime/model/UpdateAccountResult.h>
#include <aws/chime/model/UpdateAccountSettingsRequest.h>
#include <aws/chime/model/UpdateAccountSettingsResult.h>
#include <aws/chime/model/UpdateBotRequest.h>
#include <aws/chime/model/UpdateBotResult.h>
#include <aws/chime/model/UpdateGlobalSettingsRequest.h>
#include <aws/chime/model/UpdatePhoneNumberRequest.h>
#include <aws/chime/model/UpdatePhoneNumberRequestItem.h>
#include <aws/chime/model/UpdatePhoneNumberResult.h>
#include <aws/chime/model/UpdatePhoneNumberSettingsRequest.h>
#include <aws/chime/model/UpdateRoomMembershipRequest.h>
#include <aws/chime/model/UpdateRoomMembershipResult.h>
#include <aws/chime/model/UpdateRoomRequest.h>
#include <aws/chime/model/UpdateRoomResult.h>
#include <aws/chime/model/UpdateUserRequest.h>
#include <aws/chime/model/UpdateUserRequestItem.h>
#include <aws/chime/model/UpdateUserResult.h>
#include <aws/chime/model/UpdateUserSettingsRequest.h>
#include <aws/chime/model/User.h>
#include <aws/chime/model/UserError.h>
#include <aws/chime/model/UserSettings.h>
#include <aws/chime/model/UserType.h>
#include <aws/chime/model/VoiceConnectorSettings.h>

using ChimeIncludeTest = ::testing::Test;

TEST_F(ChimeIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::Chime::ChimeClient>("ChimeIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
