/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/chime-sdk-media-pipelines/ChimeSDKMediaPipelinesClient.h>
#include <aws/chime-sdk-media-pipelines/ChimeSDKMediaPipelinesEndpointProvider.h>
#include <aws/chime-sdk-media-pipelines/ChimeSDKMediaPipelinesEndpointRules.h>
#include <aws/chime-sdk-media-pipelines/ChimeSDKMediaPipelinesErrorMarshaller.h>
#include <aws/chime-sdk-media-pipelines/ChimeSDKMediaPipelinesErrors.h>
#include <aws/chime-sdk-media-pipelines/ChimeSDKMediaPipelinesRequest.h>
#include <aws/chime-sdk-media-pipelines/ChimeSDKMediaPipelinesServiceClientModel.h>
#include <aws/chime-sdk-media-pipelines/ChimeSDKMediaPipelines_EXPORTS.h>
#include <aws/chime-sdk-media-pipelines/model/ActiveSpeakerOnlyConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/ActiveSpeakerPosition.h>
#include <aws/chime-sdk-media-pipelines/model/AmazonTranscribeCallAnalyticsProcessorConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/AmazonTranscribeProcessorConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/ArtifactsConcatenationConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/ArtifactsConcatenationState.h>
#include <aws/chime-sdk-media-pipelines/model/ArtifactsConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/ArtifactsState.h>
#include <aws/chime-sdk-media-pipelines/model/AudioArtifactsConcatenationState.h>
#include <aws/chime-sdk-media-pipelines/model/AudioArtifactsConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/AudioChannelsOption.h>
#include <aws/chime-sdk-media-pipelines/model/AudioConcatenationConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/AudioMuxType.h>
#include <aws/chime-sdk-media-pipelines/model/BadRequestException.h>
#include <aws/chime-sdk-media-pipelines/model/BorderColor.h>
#include <aws/chime-sdk-media-pipelines/model/CallAnalyticsLanguageCode.h>
#include <aws/chime-sdk-media-pipelines/model/CanvasOrientation.h>
#include <aws/chime-sdk-media-pipelines/model/ChannelDefinition.h>
#include <aws/chime-sdk-media-pipelines/model/ChimeSdkMeetingConcatenationConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/ChimeSdkMeetingConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/ChimeSdkMeetingLiveConnectorConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/CompositedVideoArtifactsConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/CompositedVideoConcatenationConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/ConcatenationSink.h>
#include <aws/chime-sdk-media-pipelines/model/ConcatenationSinkType.h>
#include <aws/chime-sdk-media-pipelines/model/ConcatenationSource.h>
#include <aws/chime-sdk-media-pipelines/model/ConcatenationSourceType.h>
#include <aws/chime-sdk-media-pipelines/model/ConflictException.h>
#include <aws/chime-sdk-media-pipelines/model/ContentArtifactsConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/ContentConcatenationConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/ContentMuxType.h>
#include <aws/chime-sdk-media-pipelines/model/ContentRedactionOutput.h>
#include <aws/chime-sdk-media-pipelines/model/ContentShareLayoutOption.h>
#include <aws/chime-sdk-media-pipelines/model/ContentType.h>
#include <aws/chime-sdk-media-pipelines/model/CreateMediaCapturePipelineRequest.h>
#include <aws/chime-sdk-media-pipelines/model/CreateMediaCapturePipelineResult.h>
#include <aws/chime-sdk-media-pipelines/model/CreateMediaConcatenationPipelineRequest.h>
#include <aws/chime-sdk-media-pipelines/model/CreateMediaConcatenationPipelineResult.h>
#include <aws/chime-sdk-media-pipelines/model/CreateMediaInsightsPipelineConfigurationRequest.h>
#include <aws/chime-sdk-media-pipelines/model/CreateMediaInsightsPipelineConfigurationResult.h>
#include <aws/chime-sdk-media-pipelines/model/CreateMediaInsightsPipelineRequest.h>
#include <aws/chime-sdk-media-pipelines/model/CreateMediaInsightsPipelineResult.h>
#include <aws/chime-sdk-media-pipelines/model/CreateMediaLiveConnectorPipelineRequest.h>
#include <aws/chime-sdk-media-pipelines/model/CreateMediaLiveConnectorPipelineResult.h>
#include <aws/chime-sdk-media-pipelines/model/CreateMediaPipelineKinesisVideoStreamPoolRequest.h>
#include <aws/chime-sdk-media-pipelines/model/CreateMediaPipelineKinesisVideoStreamPoolResult.h>
#include <aws/chime-sdk-media-pipelines/model/CreateMediaStreamPipelineRequest.h>
#include <aws/chime-sdk-media-pipelines/model/CreateMediaStreamPipelineResult.h>
#include <aws/chime-sdk-media-pipelines/model/DataChannelConcatenationConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/DeleteMediaCapturePipelineRequest.h>
#include <aws/chime-sdk-media-pipelines/model/DeleteMediaInsightsPipelineConfigurationRequest.h>
#include <aws/chime-sdk-media-pipelines/model/DeleteMediaPipelineKinesisVideoStreamPoolRequest.h>
#include <aws/chime-sdk-media-pipelines/model/DeleteMediaPipelineRequest.h>
#include <aws/chime-sdk-media-pipelines/model/ErrorCode.h>
#include <aws/chime-sdk-media-pipelines/model/ForbiddenException.h>
#include <aws/chime-sdk-media-pipelines/model/FragmentSelector.h>
#include <aws/chime-sdk-media-pipelines/model/FragmentSelectorType.h>
#include <aws/chime-sdk-media-pipelines/model/GetMediaCapturePipelineRequest.h>
#include <aws/chime-sdk-media-pipelines/model/GetMediaCapturePipelineResult.h>
#include <aws/chime-sdk-media-pipelines/model/GetMediaInsightsPipelineConfigurationRequest.h>
#include <aws/chime-sdk-media-pipelines/model/GetMediaInsightsPipelineConfigurationResult.h>
#include <aws/chime-sdk-media-pipelines/model/GetMediaPipelineKinesisVideoStreamPoolRequest.h>
#include <aws/chime-sdk-media-pipelines/model/GetMediaPipelineKinesisVideoStreamPoolResult.h>
#include <aws/chime-sdk-media-pipelines/model/GetMediaPipelineRequest.h>
#include <aws/chime-sdk-media-pipelines/model/GetMediaPipelineResult.h>
#include <aws/chime-sdk-media-pipelines/model/GetSpeakerSearchTaskRequest.h>
#include <aws/chime-sdk-media-pipelines/model/GetSpeakerSearchTaskResult.h>
#include <aws/chime-sdk-media-pipelines/model/GetVoiceToneAnalysisTaskRequest.h>
#include <aws/chime-sdk-media-pipelines/model/GetVoiceToneAnalysisTaskResult.h>
#include <aws/chime-sdk-media-pipelines/model/GridViewConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/HighlightColor.h>
#include <aws/chime-sdk-media-pipelines/model/HorizontalLayoutConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/HorizontalTilePosition.h>
#include <aws/chime-sdk-media-pipelines/model/IssueDetectionConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/KeywordMatchConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/KinesisDataStreamSinkConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/KinesisVideoStreamConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/KinesisVideoStreamConfigurationUpdate.h>
#include <aws/chime-sdk-media-pipelines/model/KinesisVideoStreamPoolConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/KinesisVideoStreamPoolStatus.h>
#include <aws/chime-sdk-media-pipelines/model/KinesisVideoStreamPoolSummary.h>
#include <aws/chime-sdk-media-pipelines/model/KinesisVideoStreamRecordingSourceRuntimeConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/KinesisVideoStreamSourceRuntimeConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/KinesisVideoStreamSourceTaskConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/LambdaFunctionSinkConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/LayoutOption.h>
#include <aws/chime-sdk-media-pipelines/model/ListMediaCapturePipelinesRequest.h>
#include <aws/chime-sdk-media-pipelines/model/ListMediaCapturePipelinesResult.h>
#include <aws/chime-sdk-media-pipelines/model/ListMediaInsightsPipelineConfigurationsRequest.h>
#include <aws/chime-sdk-media-pipelines/model/ListMediaInsightsPipelineConfigurationsResult.h>
#include <aws/chime-sdk-media-pipelines/model/ListMediaPipelineKinesisVideoStreamPoolsRequest.h>
#include <aws/chime-sdk-media-pipelines/model/ListMediaPipelineKinesisVideoStreamPoolsResult.h>
#include <aws/chime-sdk-media-pipelines/model/ListMediaPipelinesRequest.h>
#include <aws/chime-sdk-media-pipelines/model/ListMediaPipelinesResult.h>
#include <aws/chime-sdk-media-pipelines/model/ListTagsForResourceRequest.h>
#include <aws/chime-sdk-media-pipelines/model/ListTagsForResourceResult.h>
#include <aws/chime-sdk-media-pipelines/model/LiveConnectorMuxType.h>
#include <aws/chime-sdk-media-pipelines/model/LiveConnectorRTMPConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/LiveConnectorSinkConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/LiveConnectorSinkType.h>
#include <aws/chime-sdk-media-pipelines/model/LiveConnectorSourceConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/LiveConnectorSourceType.h>
#include <aws/chime-sdk-media-pipelines/model/MediaCapturePipeline.h>
#include <aws/chime-sdk-media-pipelines/model/MediaCapturePipelineSourceConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/MediaCapturePipelineSummary.h>
#include <aws/chime-sdk-media-pipelines/model/MediaConcatenationPipeline.h>
#include <aws/chime-sdk-media-pipelines/model/MediaEncoding.h>
#include <aws/chime-sdk-media-pipelines/model/MediaInsightsPipeline.h>
#include <aws/chime-sdk-media-pipelines/model/MediaInsightsPipelineConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/MediaInsightsPipelineConfigurationElement.h>
#include <aws/chime-sdk-media-pipelines/model/MediaInsightsPipelineConfigurationElementType.h>
#include <aws/chime-sdk-media-pipelines/model/MediaInsightsPipelineConfigurationSummary.h>
#include <aws/chime-sdk-media-pipelines/model/MediaInsightsPipelineElementStatus.h>
#include <aws/chime-sdk-media-pipelines/model/MediaLiveConnectorPipeline.h>
#include <aws/chime-sdk-media-pipelines/model/MediaPipeline.h>
#include <aws/chime-sdk-media-pipelines/model/MediaPipelineElementStatus.h>
#include <aws/chime-sdk-media-pipelines/model/MediaPipelineSinkType.h>
#include <aws/chime-sdk-media-pipelines/model/MediaPipelineSourceType.h>
#include <aws/chime-sdk-media-pipelines/model/MediaPipelineStatus.h>
#include <aws/chime-sdk-media-pipelines/model/MediaPipelineStatusUpdate.h>
#include <aws/chime-sdk-media-pipelines/model/MediaPipelineSummary.h>
#include <aws/chime-sdk-media-pipelines/model/MediaPipelineTaskStatus.h>
#include <aws/chime-sdk-media-pipelines/model/MediaStreamPipeline.h>
#include <aws/chime-sdk-media-pipelines/model/MediaStreamPipelineSinkType.h>
#include <aws/chime-sdk-media-pipelines/model/MediaStreamSink.h>
#include <aws/chime-sdk-media-pipelines/model/MediaStreamSource.h>
#include <aws/chime-sdk-media-pipelines/model/MediaStreamType.h>
#include <aws/chime-sdk-media-pipelines/model/MeetingEventsConcatenationConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/NotFoundException.h>
#include <aws/chime-sdk-media-pipelines/model/PartialResultsStability.h>
#include <aws/chime-sdk-media-pipelines/model/ParticipantRole.h>
#include <aws/chime-sdk-media-pipelines/model/PostCallAnalyticsSettings.h>
#include <aws/chime-sdk-media-pipelines/model/PresenterOnlyConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/PresenterPosition.h>
#include <aws/chime-sdk-media-pipelines/model/RealTimeAlertConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/RealTimeAlertRule.h>
#include <aws/chime-sdk-media-pipelines/model/RealTimeAlertRuleType.h>
#include <aws/chime-sdk-media-pipelines/model/RecordingFileFormat.h>
#include <aws/chime-sdk-media-pipelines/model/RecordingStreamConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/ResolutionOption.h>
#include <aws/chime-sdk-media-pipelines/model/ResourceLimitExceededException.h>
#include <aws/chime-sdk-media-pipelines/model/S3BucketSinkConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/S3RecordingSinkConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/S3RecordingSinkRuntimeConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/SelectedVideoStreams.h>
#include <aws/chime-sdk-media-pipelines/model/SentimentConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/SentimentType.h>
#include <aws/chime-sdk-media-pipelines/model/ServiceFailureException.h>
#include <aws/chime-sdk-media-pipelines/model/ServiceUnavailableException.h>
#include <aws/chime-sdk-media-pipelines/model/SnsTopicSinkConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/SourceConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/SpeakerSearchTask.h>
#include <aws/chime-sdk-media-pipelines/model/SqsQueueSinkConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/SseAwsKeyManagementParams.h>
#include <aws/chime-sdk-media-pipelines/model/StartSpeakerSearchTaskRequest.h>
#include <aws/chime-sdk-media-pipelines/model/StartSpeakerSearchTaskResult.h>
#include <aws/chime-sdk-media-pipelines/model/StartVoiceToneAnalysisTaskRequest.h>
#include <aws/chime-sdk-media-pipelines/model/StartVoiceToneAnalysisTaskResult.h>
#include <aws/chime-sdk-media-pipelines/model/StopSpeakerSearchTaskRequest.h>
#include <aws/chime-sdk-media-pipelines/model/StopVoiceToneAnalysisTaskRequest.h>
#include <aws/chime-sdk-media-pipelines/model/StreamChannelDefinition.h>
#include <aws/chime-sdk-media-pipelines/model/StreamConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/Tag.h>
#include <aws/chime-sdk-media-pipelines/model/TagResourceRequest.h>
#include <aws/chime-sdk-media-pipelines/model/TagResourceResult.h>
#include <aws/chime-sdk-media-pipelines/model/ThrottledClientException.h>
#include <aws/chime-sdk-media-pipelines/model/TileOrder.h>
#include <aws/chime-sdk-media-pipelines/model/TimestampRange.h>
#include <aws/chime-sdk-media-pipelines/model/TranscriptionMessagesConcatenationConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/UnauthorizedClientException.h>
#include <aws/chime-sdk-media-pipelines/model/UntagResourceRequest.h>
#include <aws/chime-sdk-media-pipelines/model/UntagResourceResult.h>
#include <aws/chime-sdk-media-pipelines/model/UpdateMediaInsightsPipelineConfigurationRequest.h>
#include <aws/chime-sdk-media-pipelines/model/UpdateMediaInsightsPipelineConfigurationResult.h>
#include <aws/chime-sdk-media-pipelines/model/UpdateMediaInsightsPipelineStatusRequest.h>
#include <aws/chime-sdk-media-pipelines/model/UpdateMediaPipelineKinesisVideoStreamPoolRequest.h>
#include <aws/chime-sdk-media-pipelines/model/UpdateMediaPipelineKinesisVideoStreamPoolResult.h>
#include <aws/chime-sdk-media-pipelines/model/VerticalLayoutConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/VerticalTilePosition.h>
#include <aws/chime-sdk-media-pipelines/model/VideoArtifactsConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/VideoAttribute.h>
#include <aws/chime-sdk-media-pipelines/model/VideoConcatenationConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/VideoMuxType.h>
#include <aws/chime-sdk-media-pipelines/model/VocabularyFilterMethod.h>
#include <aws/chime-sdk-media-pipelines/model/VoiceAnalyticsConfigurationStatus.h>
#include <aws/chime-sdk-media-pipelines/model/VoiceAnalyticsLanguageCode.h>
#include <aws/chime-sdk-media-pipelines/model/VoiceAnalyticsProcessorConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/VoiceEnhancementSinkConfiguration.h>
#include <aws/chime-sdk-media-pipelines/model/VoiceToneAnalysisTask.h>

using ChimeSDKMediaPipelinesIncludeTest = ::testing::Test;

TEST_F(ChimeSDKMediaPipelinesIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::ChimeSDKMediaPipelines::ChimeSDKMediaPipelinesClient>("ChimeSDKMediaPipelinesIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
