/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/chime-sdk-messaging/ChimeSDKMessagingClient.h>
#include <aws/chime-sdk-messaging/ChimeSDKMessagingEndpointProvider.h>
#include <aws/chime-sdk-messaging/ChimeSDKMessagingEndpointRules.h>
#include <aws/chime-sdk-messaging/ChimeSDKMessagingErrorMarshaller.h>
#include <aws/chime-sdk-messaging/ChimeSDKMessagingErrors.h>
#include <aws/chime-sdk-messaging/ChimeSDKMessagingRequest.h>
#include <aws/chime-sdk-messaging/ChimeSDKMessagingServiceClientModel.h>
#include <aws/chime-sdk-messaging/ChimeSDKMessaging_EXPORTS.h>
#include <aws/chime-sdk-messaging/model/AllowNotifications.h>
#include <aws/chime-sdk-messaging/model/AppInstanceUserMembershipSummary.h>
#include <aws/chime-sdk-messaging/model/AssociateChannelFlowRequest.h>
#include <aws/chime-sdk-messaging/model/BadRequestException.h>
#include <aws/chime-sdk-messaging/model/BatchChannelMemberships.h>
#include <aws/chime-sdk-messaging/model/BatchCreateChannelMembershipError.h>
#include <aws/chime-sdk-messaging/model/BatchCreateChannelMembershipRequest.h>
#include <aws/chime-sdk-messaging/model/BatchCreateChannelMembershipResult.h>
#include <aws/chime-sdk-messaging/model/Channel.h>
#include <aws/chime-sdk-messaging/model/ChannelAssociatedWithFlowSummary.h>
#include <aws/chime-sdk-messaging/model/ChannelBan.h>
#include <aws/chime-sdk-messaging/model/ChannelBanSummary.h>
#include <aws/chime-sdk-messaging/model/ChannelFlow.h>
#include <aws/chime-sdk-messaging/model/ChannelFlowCallbackRequest.h>
#include <aws/chime-sdk-messaging/model/ChannelFlowCallbackResult.h>
#include <aws/chime-sdk-messaging/model/ChannelFlowSummary.h>
#include <aws/chime-sdk-messaging/model/ChannelMembership.h>
#include <aws/chime-sdk-messaging/model/ChannelMembershipForAppInstanceUserSummary.h>
#include <aws/chime-sdk-messaging/model/ChannelMembershipPreferences.h>
#include <aws/chime-sdk-messaging/model/ChannelMembershipSummary.h>
#include <aws/chime-sdk-messaging/model/ChannelMembershipType.h>
#include <aws/chime-sdk-messaging/model/ChannelMessage.h>
#include <aws/chime-sdk-messaging/model/ChannelMessageCallback.h>
#include <aws/chime-sdk-messaging/model/ChannelMessagePersistenceType.h>
#include <aws/chime-sdk-messaging/model/ChannelMessageStatus.h>
#include <aws/chime-sdk-messaging/model/ChannelMessageStatusStructure.h>
#include <aws/chime-sdk-messaging/model/ChannelMessageSummary.h>
#include <aws/chime-sdk-messaging/model/ChannelMessageType.h>
#include <aws/chime-sdk-messaging/model/ChannelMode.h>
#include <aws/chime-sdk-messaging/model/ChannelModeratedByAppInstanceUserSummary.h>
#include <aws/chime-sdk-messaging/model/ChannelModerator.h>
#include <aws/chime-sdk-messaging/model/ChannelModeratorSummary.h>
#include <aws/chime-sdk-messaging/model/ChannelPrivacy.h>
#include <aws/chime-sdk-messaging/model/ChannelSummary.h>
#include <aws/chime-sdk-messaging/model/ConflictException.h>
#include <aws/chime-sdk-messaging/model/CreateChannelBanRequest.h>
#include <aws/chime-sdk-messaging/model/CreateChannelBanResult.h>
#include <aws/chime-sdk-messaging/model/CreateChannelFlowRequest.h>
#include <aws/chime-sdk-messaging/model/CreateChannelFlowResult.h>
#include <aws/chime-sdk-messaging/model/CreateChannelMembershipRequest.h>
#include <aws/chime-sdk-messaging/model/CreateChannelMembershipResult.h>
#include <aws/chime-sdk-messaging/model/CreateChannelModeratorRequest.h>
#include <aws/chime-sdk-messaging/model/CreateChannelModeratorResult.h>
#include <aws/chime-sdk-messaging/model/CreateChannelRequest.h>
#include <aws/chime-sdk-messaging/model/CreateChannelResult.h>
#include <aws/chime-sdk-messaging/model/DeleteChannelBanRequest.h>
#include <aws/chime-sdk-messaging/model/DeleteChannelFlowRequest.h>
#include <aws/chime-sdk-messaging/model/DeleteChannelMembershipRequest.h>
#include <aws/chime-sdk-messaging/model/DeleteChannelMessageRequest.h>
#include <aws/chime-sdk-messaging/model/DeleteChannelModeratorRequest.h>
#include <aws/chime-sdk-messaging/model/DeleteChannelRequest.h>
#include <aws/chime-sdk-messaging/model/DeleteMessagingStreamingConfigurationsRequest.h>
#include <aws/chime-sdk-messaging/model/DescribeChannelBanRequest.h>
#include <aws/chime-sdk-messaging/model/DescribeChannelBanResult.h>
#include <aws/chime-sdk-messaging/model/DescribeChannelFlowRequest.h>
#include <aws/chime-sdk-messaging/model/DescribeChannelFlowResult.h>
#include <aws/chime-sdk-messaging/model/DescribeChannelMembershipForAppInstanceUserRequest.h>
#include <aws/chime-sdk-messaging/model/DescribeChannelMembershipForAppInstanceUserResult.h>
#include <aws/chime-sdk-messaging/model/DescribeChannelMembershipRequest.h>
#include <aws/chime-sdk-messaging/model/DescribeChannelMembershipResult.h>
#include <aws/chime-sdk-messaging/model/DescribeChannelModeratedByAppInstanceUserRequest.h>
#include <aws/chime-sdk-messaging/model/DescribeChannelModeratedByAppInstanceUserResult.h>
#include <aws/chime-sdk-messaging/model/DescribeChannelModeratorRequest.h>
#include <aws/chime-sdk-messaging/model/DescribeChannelModeratorResult.h>
#include <aws/chime-sdk-messaging/model/DescribeChannelRequest.h>
#include <aws/chime-sdk-messaging/model/DescribeChannelResult.h>
#include <aws/chime-sdk-messaging/model/DisassociateChannelFlowRequest.h>
#include <aws/chime-sdk-messaging/model/ElasticChannelConfiguration.h>
#include <aws/chime-sdk-messaging/model/ErrorCode.h>
#include <aws/chime-sdk-messaging/model/ExpirationCriterion.h>
#include <aws/chime-sdk-messaging/model/ExpirationSettings.h>
#include <aws/chime-sdk-messaging/model/FallbackAction.h>
#include <aws/chime-sdk-messaging/model/ForbiddenException.h>
#include <aws/chime-sdk-messaging/model/GetChannelMembershipPreferencesRequest.h>
#include <aws/chime-sdk-messaging/model/GetChannelMembershipPreferencesResult.h>
#include <aws/chime-sdk-messaging/model/GetChannelMessageRequest.h>
#include <aws/chime-sdk-messaging/model/GetChannelMessageResult.h>
#include <aws/chime-sdk-messaging/model/GetChannelMessageStatusRequest.h>
#include <aws/chime-sdk-messaging/model/GetChannelMessageStatusResult.h>
#include <aws/chime-sdk-messaging/model/GetMessagingSessionEndpointRequest.h>
#include <aws/chime-sdk-messaging/model/GetMessagingSessionEndpointResult.h>
#include <aws/chime-sdk-messaging/model/GetMessagingStreamingConfigurationsRequest.h>
#include <aws/chime-sdk-messaging/model/GetMessagingStreamingConfigurationsResult.h>
#include <aws/chime-sdk-messaging/model/Identity.h>
#include <aws/chime-sdk-messaging/model/InvocationType.h>
#include <aws/chime-sdk-messaging/model/LambdaConfiguration.h>
#include <aws/chime-sdk-messaging/model/ListChannelBansRequest.h>
#include <aws/chime-sdk-messaging/model/ListChannelBansResult.h>
#include <aws/chime-sdk-messaging/model/ListChannelFlowsRequest.h>
#include <aws/chime-sdk-messaging/model/ListChannelFlowsResult.h>
#include <aws/chime-sdk-messaging/model/ListChannelMembershipsForAppInstanceUserRequest.h>
#include <aws/chime-sdk-messaging/model/ListChannelMembershipsForAppInstanceUserResult.h>
#include <aws/chime-sdk-messaging/model/ListChannelMembershipsRequest.h>
#include <aws/chime-sdk-messaging/model/ListChannelMembershipsResult.h>
#include <aws/chime-sdk-messaging/model/ListChannelMessagesRequest.h>
#include <aws/chime-sdk-messaging/model/ListChannelMessagesResult.h>
#include <aws/chime-sdk-messaging/model/ListChannelModeratorsRequest.h>
#include <aws/chime-sdk-messaging/model/ListChannelModeratorsResult.h>
#include <aws/chime-sdk-messaging/model/ListChannelsAssociatedWithChannelFlowRequest.h>
#include <aws/chime-sdk-messaging/model/ListChannelsAssociatedWithChannelFlowResult.h>
#include <aws/chime-sdk-messaging/model/ListChannelsModeratedByAppInstanceUserRequest.h>
#include <aws/chime-sdk-messaging/model/ListChannelsModeratedByAppInstanceUserResult.h>
#include <aws/chime-sdk-messaging/model/ListChannelsRequest.h>
#include <aws/chime-sdk-messaging/model/ListChannelsResult.h>
#include <aws/chime-sdk-messaging/model/ListSubChannelsRequest.h>
#include <aws/chime-sdk-messaging/model/ListSubChannelsResult.h>
#include <aws/chime-sdk-messaging/model/ListTagsForResourceRequest.h>
#include <aws/chime-sdk-messaging/model/ListTagsForResourceResult.h>
#include <aws/chime-sdk-messaging/model/MessageAttributeValue.h>
#include <aws/chime-sdk-messaging/model/MessagingDataType.h>
#include <aws/chime-sdk-messaging/model/MessagingSessionEndpoint.h>
#include <aws/chime-sdk-messaging/model/NotFoundException.h>
#include <aws/chime-sdk-messaging/model/Processor.h>
#include <aws/chime-sdk-messaging/model/ProcessorConfiguration.h>
#include <aws/chime-sdk-messaging/model/PushNotificationConfiguration.h>
#include <aws/chime-sdk-messaging/model/PushNotificationPreferences.h>
#include <aws/chime-sdk-messaging/model/PushNotificationType.h>
#include <aws/chime-sdk-messaging/model/PutChannelExpirationSettingsRequest.h>
#include <aws/chime-sdk-messaging/model/PutChannelExpirationSettingsResult.h>
#include <aws/chime-sdk-messaging/model/PutChannelMembershipPreferencesRequest.h>
#include <aws/chime-sdk-messaging/model/PutChannelMembershipPreferencesResult.h>
#include <aws/chime-sdk-messaging/model/PutMessagingStreamingConfigurationsRequest.h>
#include <aws/chime-sdk-messaging/model/PutMessagingStreamingConfigurationsResult.h>
#include <aws/chime-sdk-messaging/model/RedactChannelMessageRequest.h>
#include <aws/chime-sdk-messaging/model/RedactChannelMessageResult.h>
#include <aws/chime-sdk-messaging/model/ResourceLimitExceededException.h>
#include <aws/chime-sdk-messaging/model/SearchChannelsRequest.h>
#include <aws/chime-sdk-messaging/model/SearchChannelsResult.h>
#include <aws/chime-sdk-messaging/model/SearchField.h>
#include <aws/chime-sdk-messaging/model/SearchFieldKey.h>
#include <aws/chime-sdk-messaging/model/SearchFieldOperator.h>
#include <aws/chime-sdk-messaging/model/SendChannelMessageRequest.h>
#include <aws/chime-sdk-messaging/model/SendChannelMessageResult.h>
#include <aws/chime-sdk-messaging/model/ServiceFailureException.h>
#include <aws/chime-sdk-messaging/model/ServiceUnavailableException.h>
#include <aws/chime-sdk-messaging/model/SortOrder.h>
#include <aws/chime-sdk-messaging/model/StreamingConfiguration.h>
#include <aws/chime-sdk-messaging/model/SubChannelSummary.h>
#include <aws/chime-sdk-messaging/model/Tag.h>
#include <aws/chime-sdk-messaging/model/TagResourceRequest.h>
#include <aws/chime-sdk-messaging/model/Target.h>
#include <aws/chime-sdk-messaging/model/ThrottledClientException.h>
#include <aws/chime-sdk-messaging/model/UnauthorizedClientException.h>
#include <aws/chime-sdk-messaging/model/UntagResourceRequest.h>
#include <aws/chime-sdk-messaging/model/UpdateChannelFlowRequest.h>
#include <aws/chime-sdk-messaging/model/UpdateChannelFlowResult.h>
#include <aws/chime-sdk-messaging/model/UpdateChannelMessageRequest.h>
#include <aws/chime-sdk-messaging/model/UpdateChannelMessageResult.h>
#include <aws/chime-sdk-messaging/model/UpdateChannelReadMarkerRequest.h>
#include <aws/chime-sdk-messaging/model/UpdateChannelReadMarkerResult.h>
#include <aws/chime-sdk-messaging/model/UpdateChannelRequest.h>
#include <aws/chime-sdk-messaging/model/UpdateChannelResult.h>

using ChimeSDKMessagingIncludeTest = ::testing::Test;

TEST_F(ChimeSDKMessagingIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::ChimeSDKMessaging::ChimeSDKMessagingClient>("ChimeSDKMessagingIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
