/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/cleanrooms/CleanRoomsClient.h>
#include <aws/cleanrooms/CleanRoomsEndpointProvider.h>
#include <aws/cleanrooms/CleanRoomsEndpointRules.h>
#include <aws/cleanrooms/CleanRoomsErrorMarshaller.h>
#include <aws/cleanrooms/CleanRoomsErrors.h>
#include <aws/cleanrooms/CleanRoomsRequest.h>
#include <aws/cleanrooms/CleanRoomsServiceClientModel.h>
#include <aws/cleanrooms/CleanRooms_EXPORTS.h>
#include <aws/cleanrooms/model/AccessDeniedException.h>
#include <aws/cleanrooms/model/AccessDeniedExceptionReason.h>
#include <aws/cleanrooms/model/AdditionalAnalyses.h>
#include <aws/cleanrooms/model/AggregateColumn.h>
#include <aws/cleanrooms/model/AggregateFunctionName.h>
#include <aws/cleanrooms/model/AggregationConstraint.h>
#include <aws/cleanrooms/model/AggregationType.h>
#include <aws/cleanrooms/model/AnalysisFormat.h>
#include <aws/cleanrooms/model/AnalysisMethod.h>
#include <aws/cleanrooms/model/AnalysisParameter.h>
#include <aws/cleanrooms/model/AnalysisRule.h>
#include <aws/cleanrooms/model/AnalysisRuleAggregation.h>
#include <aws/cleanrooms/model/AnalysisRuleCustom.h>
#include <aws/cleanrooms/model/AnalysisRuleIdMappingTable.h>
#include <aws/cleanrooms/model/AnalysisRuleList.h>
#include <aws/cleanrooms/model/AnalysisRulePolicy.h>
#include <aws/cleanrooms/model/AnalysisRulePolicyV1.h>
#include <aws/cleanrooms/model/AnalysisRuleType.h>
#include <aws/cleanrooms/model/AnalysisSchema.h>
#include <aws/cleanrooms/model/AnalysisSource.h>
#include <aws/cleanrooms/model/AnalysisSourceMetadata.h>
#include <aws/cleanrooms/model/AnalysisTemplate.h>
#include <aws/cleanrooms/model/AnalysisTemplateArtifact.h>
#include <aws/cleanrooms/model/AnalysisTemplateArtifactMetadata.h>
#include <aws/cleanrooms/model/AnalysisTemplateArtifacts.h>
#include <aws/cleanrooms/model/AnalysisTemplateSummary.h>
#include <aws/cleanrooms/model/AnalysisTemplateValidationStatus.h>
#include <aws/cleanrooms/model/AnalysisTemplateValidationStatusDetail.h>
#include <aws/cleanrooms/model/AnalysisTemplateValidationStatusReason.h>
#include <aws/cleanrooms/model/AnalysisTemplateValidationType.h>
#include <aws/cleanrooms/model/AnalysisType.h>
#include <aws/cleanrooms/model/AnalyticsEngine.h>
#include <aws/cleanrooms/model/AthenaTableReference.h>
#include <aws/cleanrooms/model/BatchGetCollaborationAnalysisTemplateError.h>
#include <aws/cleanrooms/model/BatchGetCollaborationAnalysisTemplateRequest.h>
#include <aws/cleanrooms/model/BatchGetCollaborationAnalysisTemplateResult.h>
#include <aws/cleanrooms/model/BatchGetSchemaAnalysisRuleError.h>
#include <aws/cleanrooms/model/BatchGetSchemaAnalysisRuleRequest.h>
#include <aws/cleanrooms/model/BatchGetSchemaAnalysisRuleResult.h>
#include <aws/cleanrooms/model/BatchGetSchemaError.h>
#include <aws/cleanrooms/model/BatchGetSchemaRequest.h>
#include <aws/cleanrooms/model/BatchGetSchemaResult.h>
#include <aws/cleanrooms/model/BilledJobResourceUtilization.h>
#include <aws/cleanrooms/model/BilledResourceUtilization.h>
#include <aws/cleanrooms/model/Collaboration.h>
#include <aws/cleanrooms/model/CollaborationAnalysisTemplate.h>
#include <aws/cleanrooms/model/CollaborationAnalysisTemplateSummary.h>
#include <aws/cleanrooms/model/CollaborationConfiguredAudienceModelAssociation.h>
#include <aws/cleanrooms/model/CollaborationConfiguredAudienceModelAssociationSummary.h>
#include <aws/cleanrooms/model/CollaborationIdNamespaceAssociation.h>
#include <aws/cleanrooms/model/CollaborationIdNamespaceAssociationSummary.h>
#include <aws/cleanrooms/model/CollaborationJobLogStatus.h>
#include <aws/cleanrooms/model/CollaborationPrivacyBudgetSummary.h>
#include <aws/cleanrooms/model/CollaborationPrivacyBudgetTemplate.h>
#include <aws/cleanrooms/model/CollaborationPrivacyBudgetTemplateSummary.h>
#include <aws/cleanrooms/model/CollaborationQueryLogStatus.h>
#include <aws/cleanrooms/model/CollaborationSummary.h>
#include <aws/cleanrooms/model/Column.h>
#include <aws/cleanrooms/model/ComputeConfiguration.h>
#include <aws/cleanrooms/model/ConfigurationDetails.h>
#include <aws/cleanrooms/model/ConfiguredAudienceModelAssociation.h>
#include <aws/cleanrooms/model/ConfiguredAudienceModelAssociationSummary.h>
#include <aws/cleanrooms/model/ConfiguredTable.h>
#include <aws/cleanrooms/model/ConfiguredTableAnalysisRule.h>
#include <aws/cleanrooms/model/ConfiguredTableAnalysisRulePolicy.h>
#include <aws/cleanrooms/model/ConfiguredTableAnalysisRulePolicyV1.h>
#include <aws/cleanrooms/model/ConfiguredTableAnalysisRuleType.h>
#include <aws/cleanrooms/model/ConfiguredTableAssociation.h>
#include <aws/cleanrooms/model/ConfiguredTableAssociationAnalysisRule.h>
#include <aws/cleanrooms/model/ConfiguredTableAssociationAnalysisRuleAggregation.h>
#include <aws/cleanrooms/model/ConfiguredTableAssociationAnalysisRuleCustom.h>
#include <aws/cleanrooms/model/ConfiguredTableAssociationAnalysisRuleList.h>
#include <aws/cleanrooms/model/ConfiguredTableAssociationAnalysisRulePolicy.h>
#include <aws/cleanrooms/model/ConfiguredTableAssociationAnalysisRulePolicyV1.h>
#include <aws/cleanrooms/model/ConfiguredTableAssociationAnalysisRuleType.h>
#include <aws/cleanrooms/model/ConfiguredTableAssociationSummary.h>
#include <aws/cleanrooms/model/ConfiguredTableSummary.h>
#include <aws/cleanrooms/model/ConflictException.h>
#include <aws/cleanrooms/model/ConflictExceptionReason.h>
#include <aws/cleanrooms/model/ConsolidatedPolicy.h>
#include <aws/cleanrooms/model/ConsolidatedPolicyAggregation.h>
#include <aws/cleanrooms/model/ConsolidatedPolicyCustom.h>
#include <aws/cleanrooms/model/ConsolidatedPolicyList.h>
#include <aws/cleanrooms/model/ConsolidatedPolicyV1.h>
#include <aws/cleanrooms/model/CreateAnalysisTemplateRequest.h>
#include <aws/cleanrooms/model/CreateAnalysisTemplateResult.h>
#include <aws/cleanrooms/model/CreateCollaborationRequest.h>
#include <aws/cleanrooms/model/CreateCollaborationResult.h>
#include <aws/cleanrooms/model/CreateConfiguredAudienceModelAssociationRequest.h>
#include <aws/cleanrooms/model/CreateConfiguredAudienceModelAssociationResult.h>
#include <aws/cleanrooms/model/CreateConfiguredTableAnalysisRuleRequest.h>
#include <aws/cleanrooms/model/CreateConfiguredTableAnalysisRuleResult.h>
#include <aws/cleanrooms/model/CreateConfiguredTableAssociationAnalysisRuleRequest.h>
#include <aws/cleanrooms/model/CreateConfiguredTableAssociationAnalysisRuleResult.h>
#include <aws/cleanrooms/model/CreateConfiguredTableAssociationRequest.h>
#include <aws/cleanrooms/model/CreateConfiguredTableAssociationResult.h>
#include <aws/cleanrooms/model/CreateConfiguredTableRequest.h>
#include <aws/cleanrooms/model/CreateConfiguredTableResult.h>
#include <aws/cleanrooms/model/CreateIdMappingTableRequest.h>
#include <aws/cleanrooms/model/CreateIdMappingTableResult.h>
#include <aws/cleanrooms/model/CreateIdNamespaceAssociationRequest.h>
#include <aws/cleanrooms/model/CreateIdNamespaceAssociationResult.h>
#include <aws/cleanrooms/model/CreateMembershipRequest.h>
#include <aws/cleanrooms/model/CreateMembershipResult.h>
#include <aws/cleanrooms/model/CreatePrivacyBudgetTemplateRequest.h>
#include <aws/cleanrooms/model/CreatePrivacyBudgetTemplateResult.h>
#include <aws/cleanrooms/model/CustomMLMemberAbility.h>
#include <aws/cleanrooms/model/DataEncryptionMetadata.h>
#include <aws/cleanrooms/model/DeleteAnalysisTemplateRequest.h>
#include <aws/cleanrooms/model/DeleteAnalysisTemplateResult.h>
#include <aws/cleanrooms/model/DeleteCollaborationRequest.h>
#include <aws/cleanrooms/model/DeleteCollaborationResult.h>
#include <aws/cleanrooms/model/DeleteConfiguredAudienceModelAssociationRequest.h>
#include <aws/cleanrooms/model/DeleteConfiguredAudienceModelAssociationResult.h>
#include <aws/cleanrooms/model/DeleteConfiguredTableAnalysisRuleRequest.h>
#include <aws/cleanrooms/model/DeleteConfiguredTableAnalysisRuleResult.h>
#include <aws/cleanrooms/model/DeleteConfiguredTableAssociationAnalysisRuleRequest.h>
#include <aws/cleanrooms/model/DeleteConfiguredTableAssociationAnalysisRuleResult.h>
#include <aws/cleanrooms/model/DeleteConfiguredTableAssociationRequest.h>
#include <aws/cleanrooms/model/DeleteConfiguredTableAssociationResult.h>
#include <aws/cleanrooms/model/DeleteConfiguredTableRequest.h>
#include <aws/cleanrooms/model/DeleteConfiguredTableResult.h>
#include <aws/cleanrooms/model/DeleteIdMappingTableRequest.h>
#include <aws/cleanrooms/model/DeleteIdMappingTableResult.h>
#include <aws/cleanrooms/model/DeleteIdNamespaceAssociationRequest.h>
#include <aws/cleanrooms/model/DeleteIdNamespaceAssociationResult.h>
#include <aws/cleanrooms/model/DeleteMemberRequest.h>
#include <aws/cleanrooms/model/DeleteMemberResult.h>
#include <aws/cleanrooms/model/DeleteMembershipRequest.h>
#include <aws/cleanrooms/model/DeleteMembershipResult.h>
#include <aws/cleanrooms/model/DeletePrivacyBudgetTemplateRequest.h>
#include <aws/cleanrooms/model/DeletePrivacyBudgetTemplateResult.h>
#include <aws/cleanrooms/model/DifferentialPrivacyAggregationType.h>
#include <aws/cleanrooms/model/DifferentialPrivacyColumn.h>
#include <aws/cleanrooms/model/DifferentialPrivacyConfiguration.h>
#include <aws/cleanrooms/model/DifferentialPrivacyParameters.h>
#include <aws/cleanrooms/model/DifferentialPrivacyPreviewAggregation.h>
#include <aws/cleanrooms/model/DifferentialPrivacyPreviewParametersInput.h>
#include <aws/cleanrooms/model/DifferentialPrivacyPrivacyBudget.h>
#include <aws/cleanrooms/model/DifferentialPrivacyPrivacyBudgetAggregation.h>
#include <aws/cleanrooms/model/DifferentialPrivacyPrivacyImpact.h>
#include <aws/cleanrooms/model/DifferentialPrivacySensitivityParameters.h>
#include <aws/cleanrooms/model/DifferentialPrivacyTemplateParametersInput.h>
#include <aws/cleanrooms/model/DifferentialPrivacyTemplateParametersOutput.h>
#include <aws/cleanrooms/model/DifferentialPrivacyTemplateUpdateParameters.h>
#include <aws/cleanrooms/model/DirectAnalysisConfigurationDetails.h>
#include <aws/cleanrooms/model/FilterableMemberStatus.h>
#include <aws/cleanrooms/model/GetAnalysisTemplateRequest.h>
#include <aws/cleanrooms/model/GetAnalysisTemplateResult.h>
#include <aws/cleanrooms/model/GetCollaborationAnalysisTemplateRequest.h>
#include <aws/cleanrooms/model/GetCollaborationAnalysisTemplateResult.h>
#include <aws/cleanrooms/model/GetCollaborationConfiguredAudienceModelAssociationRequest.h>
#include <aws/cleanrooms/model/GetCollaborationConfiguredAudienceModelAssociationResult.h>
#include <aws/cleanrooms/model/GetCollaborationIdNamespaceAssociationRequest.h>
#include <aws/cleanrooms/model/GetCollaborationIdNamespaceAssociationResult.h>
#include <aws/cleanrooms/model/GetCollaborationPrivacyBudgetTemplateRequest.h>
#include <aws/cleanrooms/model/GetCollaborationPrivacyBudgetTemplateResult.h>
#include <aws/cleanrooms/model/GetCollaborationRequest.h>
#include <aws/cleanrooms/model/GetCollaborationResult.h>
#include <aws/cleanrooms/model/GetConfiguredAudienceModelAssociationRequest.h>
#include <aws/cleanrooms/model/GetConfiguredAudienceModelAssociationResult.h>
#include <aws/cleanrooms/model/GetConfiguredTableAnalysisRuleRequest.h>
#include <aws/cleanrooms/model/GetConfiguredTableAnalysisRuleResult.h>
#include <aws/cleanrooms/model/GetConfiguredTableAssociationAnalysisRuleRequest.h>
#include <aws/cleanrooms/model/GetConfiguredTableAssociationAnalysisRuleResult.h>
#include <aws/cleanrooms/model/GetConfiguredTableAssociationRequest.h>
#include <aws/cleanrooms/model/GetConfiguredTableAssociationResult.h>
#include <aws/cleanrooms/model/GetConfiguredTableRequest.h>
#include <aws/cleanrooms/model/GetConfiguredTableResult.h>
#include <aws/cleanrooms/model/GetIdMappingTableRequest.h>
#include <aws/cleanrooms/model/GetIdMappingTableResult.h>
#include <aws/cleanrooms/model/GetIdNamespaceAssociationRequest.h>
#include <aws/cleanrooms/model/GetIdNamespaceAssociationResult.h>
#include <aws/cleanrooms/model/GetMembershipRequest.h>
#include <aws/cleanrooms/model/GetMembershipResult.h>
#include <aws/cleanrooms/model/GetPrivacyBudgetTemplateRequest.h>
#include <aws/cleanrooms/model/GetPrivacyBudgetTemplateResult.h>
#include <aws/cleanrooms/model/GetProtectedJobRequest.h>
#include <aws/cleanrooms/model/GetProtectedJobResult.h>
#include <aws/cleanrooms/model/GetProtectedQueryRequest.h>
#include <aws/cleanrooms/model/GetProtectedQueryResult.h>
#include <aws/cleanrooms/model/GetSchemaAnalysisRuleRequest.h>
#include <aws/cleanrooms/model/GetSchemaAnalysisRuleResult.h>
#include <aws/cleanrooms/model/GetSchemaRequest.h>
#include <aws/cleanrooms/model/GetSchemaResult.h>
#include <aws/cleanrooms/model/GlueTableReference.h>
#include <aws/cleanrooms/model/Hash.h>
#include <aws/cleanrooms/model/IdMappingConfig.h>
#include <aws/cleanrooms/model/IdMappingTable.h>
#include <aws/cleanrooms/model/IdMappingTableInputReferenceConfig.h>
#include <aws/cleanrooms/model/IdMappingTableInputReferenceProperties.h>
#include <aws/cleanrooms/model/IdMappingTableInputSource.h>
#include <aws/cleanrooms/model/IdMappingTableSchemaTypeProperties.h>
#include <aws/cleanrooms/model/IdMappingTableSummary.h>
#include <aws/cleanrooms/model/IdNamespaceAssociation.h>
#include <aws/cleanrooms/model/IdNamespaceAssociationInputReferenceConfig.h>
#include <aws/cleanrooms/model/IdNamespaceAssociationInputReferenceProperties.h>
#include <aws/cleanrooms/model/IdNamespaceAssociationInputReferencePropertiesSummary.h>
#include <aws/cleanrooms/model/IdNamespaceAssociationSummary.h>
#include <aws/cleanrooms/model/IdNamespaceType.h>
#include <aws/cleanrooms/model/JobComputePaymentConfig.h>
#include <aws/cleanrooms/model/JoinOperator.h>
#include <aws/cleanrooms/model/JoinRequiredOption.h>
#include <aws/cleanrooms/model/ListAnalysisTemplatesRequest.h>
#include <aws/cleanrooms/model/ListAnalysisTemplatesResult.h>
#include <aws/cleanrooms/model/ListCollaborationAnalysisTemplatesRequest.h>
#include <aws/cleanrooms/model/ListCollaborationAnalysisTemplatesResult.h>
#include <aws/cleanrooms/model/ListCollaborationConfiguredAudienceModelAssociationsRequest.h>
#include <aws/cleanrooms/model/ListCollaborationConfiguredAudienceModelAssociationsResult.h>
#include <aws/cleanrooms/model/ListCollaborationIdNamespaceAssociationsRequest.h>
#include <aws/cleanrooms/model/ListCollaborationIdNamespaceAssociationsResult.h>
#include <aws/cleanrooms/model/ListCollaborationPrivacyBudgetTemplatesRequest.h>
#include <aws/cleanrooms/model/ListCollaborationPrivacyBudgetTemplatesResult.h>
#include <aws/cleanrooms/model/ListCollaborationPrivacyBudgetsRequest.h>
#include <aws/cleanrooms/model/ListCollaborationPrivacyBudgetsResult.h>
#include <aws/cleanrooms/model/ListCollaborationsRequest.h>
#include <aws/cleanrooms/model/ListCollaborationsResult.h>
#include <aws/cleanrooms/model/ListConfiguredAudienceModelAssociationsRequest.h>
#include <aws/cleanrooms/model/ListConfiguredAudienceModelAssociationsResult.h>
#include <aws/cleanrooms/model/ListConfiguredTableAssociationsRequest.h>
#include <aws/cleanrooms/model/ListConfiguredTableAssociationsResult.h>
#include <aws/cleanrooms/model/ListConfiguredTablesRequest.h>
#include <aws/cleanrooms/model/ListConfiguredTablesResult.h>
#include <aws/cleanrooms/model/ListIdMappingTablesRequest.h>
#include <aws/cleanrooms/model/ListIdMappingTablesResult.h>
#include <aws/cleanrooms/model/ListIdNamespaceAssociationsRequest.h>
#include <aws/cleanrooms/model/ListIdNamespaceAssociationsResult.h>
#include <aws/cleanrooms/model/ListMembersRequest.h>
#include <aws/cleanrooms/model/ListMembersResult.h>
#include <aws/cleanrooms/model/ListMembershipsRequest.h>
#include <aws/cleanrooms/model/ListMembershipsResult.h>
#include <aws/cleanrooms/model/ListPrivacyBudgetTemplatesRequest.h>
#include <aws/cleanrooms/model/ListPrivacyBudgetTemplatesResult.h>
#include <aws/cleanrooms/model/ListPrivacyBudgetsRequest.h>
#include <aws/cleanrooms/model/ListPrivacyBudgetsResult.h>
#include <aws/cleanrooms/model/ListProtectedJobsRequest.h>
#include <aws/cleanrooms/model/ListProtectedJobsResult.h>
#include <aws/cleanrooms/model/ListProtectedQueriesRequest.h>
#include <aws/cleanrooms/model/ListProtectedQueriesResult.h>
#include <aws/cleanrooms/model/ListSchemasRequest.h>
#include <aws/cleanrooms/model/ListSchemasResult.h>
#include <aws/cleanrooms/model/ListTagsForResourceRequest.h>
#include <aws/cleanrooms/model/ListTagsForResourceResult.h>
#include <aws/cleanrooms/model/MLMemberAbilities.h>
#include <aws/cleanrooms/model/MLPaymentConfig.h>
#include <aws/cleanrooms/model/MemberAbility.h>
#include <aws/cleanrooms/model/MemberSpecification.h>
#include <aws/cleanrooms/model/MemberStatus.h>
#include <aws/cleanrooms/model/MemberSummary.h>
#include <aws/cleanrooms/model/Membership.h>
#include <aws/cleanrooms/model/MembershipJobComputePaymentConfig.h>
#include <aws/cleanrooms/model/MembershipJobLogStatus.h>
#include <aws/cleanrooms/model/MembershipMLPaymentConfig.h>
#include <aws/cleanrooms/model/MembershipModelInferencePaymentConfig.h>
#include <aws/cleanrooms/model/MembershipModelTrainingPaymentConfig.h>
#include <aws/cleanrooms/model/MembershipPaymentConfiguration.h>
#include <aws/cleanrooms/model/MembershipProtectedJobOutputConfiguration.h>
#include <aws/cleanrooms/model/MembershipProtectedJobResultConfiguration.h>
#include <aws/cleanrooms/model/MembershipProtectedQueryOutputConfiguration.h>
#include <aws/cleanrooms/model/MembershipProtectedQueryResultConfiguration.h>
#include <aws/cleanrooms/model/MembershipQueryComputePaymentConfig.h>
#include <aws/cleanrooms/model/MembershipQueryLogStatus.h>
#include <aws/cleanrooms/model/MembershipStatus.h>
#include <aws/cleanrooms/model/MembershipSummary.h>
#include <aws/cleanrooms/model/ModelInferencePaymentConfig.h>
#include <aws/cleanrooms/model/ModelTrainingPaymentConfig.h>
#include <aws/cleanrooms/model/ParameterType.h>
#include <aws/cleanrooms/model/PaymentConfiguration.h>
#include <aws/cleanrooms/model/PopulateIdMappingTableRequest.h>
#include <aws/cleanrooms/model/PopulateIdMappingTableResult.h>
#include <aws/cleanrooms/model/PreviewPrivacyImpactParametersInput.h>
#include <aws/cleanrooms/model/PreviewPrivacyImpactRequest.h>
#include <aws/cleanrooms/model/PreviewPrivacyImpactResult.h>
#include <aws/cleanrooms/model/PrivacyBudget.h>
#include <aws/cleanrooms/model/PrivacyBudgetSummary.h>
#include <aws/cleanrooms/model/PrivacyBudgetTemplate.h>
#include <aws/cleanrooms/model/PrivacyBudgetTemplateAutoRefresh.h>
#include <aws/cleanrooms/model/PrivacyBudgetTemplateParametersInput.h>
#include <aws/cleanrooms/model/PrivacyBudgetTemplateParametersOutput.h>
#include <aws/cleanrooms/model/PrivacyBudgetTemplateSummary.h>
#include <aws/cleanrooms/model/PrivacyBudgetTemplateUpdateParameters.h>
#include <aws/cleanrooms/model/PrivacyBudgetType.h>
#include <aws/cleanrooms/model/PrivacyImpact.h>
#include <aws/cleanrooms/model/ProtectedJob.h>
#include <aws/cleanrooms/model/ProtectedJobAnalysisType.h>
#include <aws/cleanrooms/model/ProtectedJobConfigurationDetails.h>
#include <aws/cleanrooms/model/ProtectedJobDirectAnalysisConfigurationDetails.h>
#include <aws/cleanrooms/model/ProtectedJobError.h>
#include <aws/cleanrooms/model/ProtectedJobMemberOutputConfigurationInput.h>
#include <aws/cleanrooms/model/ProtectedJobMemberOutputConfigurationOutput.h>
#include <aws/cleanrooms/model/ProtectedJobOutput.h>
#include <aws/cleanrooms/model/ProtectedJobOutputConfigurationInput.h>
#include <aws/cleanrooms/model/ProtectedJobOutputConfigurationOutput.h>
#include <aws/cleanrooms/model/ProtectedJobParameters.h>
#include <aws/cleanrooms/model/ProtectedJobReceiverConfiguration.h>
#include <aws/cleanrooms/model/ProtectedJobResult.h>
#include <aws/cleanrooms/model/ProtectedJobResultConfigurationInput.h>
#include <aws/cleanrooms/model/ProtectedJobResultConfigurationOutput.h>
#include <aws/cleanrooms/model/ProtectedJobS3Output.h>
#include <aws/cleanrooms/model/ProtectedJobS3OutputConfigurationInput.h>
#include <aws/cleanrooms/model/ProtectedJobS3OutputConfigurationOutput.h>
#include <aws/cleanrooms/model/ProtectedJobSingleMemberOutput.h>
#include <aws/cleanrooms/model/ProtectedJobStatistics.h>
#include <aws/cleanrooms/model/ProtectedJobStatus.h>
#include <aws/cleanrooms/model/ProtectedJobSummary.h>
#include <aws/cleanrooms/model/ProtectedJobType.h>
#include <aws/cleanrooms/model/ProtectedQuery.h>
#include <aws/cleanrooms/model/ProtectedQueryDistributeOutput.h>
#include <aws/cleanrooms/model/ProtectedQueryDistributeOutputConfiguration.h>
#include <aws/cleanrooms/model/ProtectedQueryDistributeOutputConfigurationLocation.h>
#include <aws/cleanrooms/model/ProtectedQueryError.h>
#include <aws/cleanrooms/model/ProtectedQueryMemberOutputConfiguration.h>
#include <aws/cleanrooms/model/ProtectedQueryOutput.h>
#include <aws/cleanrooms/model/ProtectedQueryOutputConfiguration.h>
#include <aws/cleanrooms/model/ProtectedQueryResult.h>
#include <aws/cleanrooms/model/ProtectedQueryResultConfiguration.h>
#include <aws/cleanrooms/model/ProtectedQueryS3Output.h>
#include <aws/cleanrooms/model/ProtectedQueryS3OutputConfiguration.h>
#include <aws/cleanrooms/model/ProtectedQuerySQLParameters.h>
#include <aws/cleanrooms/model/ProtectedQuerySingleMemberOutput.h>
#include <aws/cleanrooms/model/ProtectedQueryStatistics.h>
#include <aws/cleanrooms/model/ProtectedQueryStatus.h>
#include <aws/cleanrooms/model/ProtectedQuerySummary.h>
#include <aws/cleanrooms/model/ProtectedQueryType.h>
#include <aws/cleanrooms/model/QueryComputePaymentConfig.h>
#include <aws/cleanrooms/model/QueryConstraint.h>
#include <aws/cleanrooms/model/QueryConstraintRequireOverlap.h>
#include <aws/cleanrooms/model/ReceiverConfiguration.h>
#include <aws/cleanrooms/model/ResourceNotFoundException.h>
#include <aws/cleanrooms/model/ResourceType.h>
#include <aws/cleanrooms/model/ResultFormat.h>
#include <aws/cleanrooms/model/S3Location.h>
#include <aws/cleanrooms/model/ScalarFunctions.h>
#include <aws/cleanrooms/model/Schema.h>
#include <aws/cleanrooms/model/SchemaAnalysisRuleRequest.h>
#include <aws/cleanrooms/model/SchemaConfiguration.h>
#include <aws/cleanrooms/model/SchemaStatus.h>
#include <aws/cleanrooms/model/SchemaStatusDetail.h>
#include <aws/cleanrooms/model/SchemaStatusReason.h>
#include <aws/cleanrooms/model/SchemaStatusReasonCode.h>
#include <aws/cleanrooms/model/SchemaSummary.h>
#include <aws/cleanrooms/model/SchemaType.h>
#include <aws/cleanrooms/model/SchemaTypeProperties.h>
#include <aws/cleanrooms/model/SelectedAnalysisMethod.h>
#include <aws/cleanrooms/model/ServiceQuotaExceededException.h>
#include <aws/cleanrooms/model/SnowflakeTableReference.h>
#include <aws/cleanrooms/model/SnowflakeTableSchema.h>
#include <aws/cleanrooms/model/SnowflakeTableSchemaV1.h>
#include <aws/cleanrooms/model/StartProtectedJobRequest.h>
#include <aws/cleanrooms/model/StartProtectedJobResult.h>
#include <aws/cleanrooms/model/StartProtectedQueryRequest.h>
#include <aws/cleanrooms/model/StartProtectedQueryResult.h>
#include <aws/cleanrooms/model/TableReference.h>
#include <aws/cleanrooms/model/TagResourceRequest.h>
#include <aws/cleanrooms/model/TagResourceResult.h>
#include <aws/cleanrooms/model/TargetProtectedJobStatus.h>
#include <aws/cleanrooms/model/TargetProtectedQueryStatus.h>
#include <aws/cleanrooms/model/UntagResourceRequest.h>
#include <aws/cleanrooms/model/UntagResourceResult.h>
#include <aws/cleanrooms/model/UpdateAnalysisTemplateRequest.h>
#include <aws/cleanrooms/model/UpdateAnalysisTemplateResult.h>
#include <aws/cleanrooms/model/UpdateCollaborationRequest.h>
#include <aws/cleanrooms/model/UpdateCollaborationResult.h>
#include <aws/cleanrooms/model/UpdateConfiguredAudienceModelAssociationRequest.h>
#include <aws/cleanrooms/model/UpdateConfiguredAudienceModelAssociationResult.h>
#include <aws/cleanrooms/model/UpdateConfiguredTableAnalysisRuleRequest.h>
#include <aws/cleanrooms/model/UpdateConfiguredTableAnalysisRuleResult.h>
#include <aws/cleanrooms/model/UpdateConfiguredTableAssociationAnalysisRuleRequest.h>
#include <aws/cleanrooms/model/UpdateConfiguredTableAssociationAnalysisRuleResult.h>
#include <aws/cleanrooms/model/UpdateConfiguredTableAssociationRequest.h>
#include <aws/cleanrooms/model/UpdateConfiguredTableAssociationResult.h>
#include <aws/cleanrooms/model/UpdateConfiguredTableRequest.h>
#include <aws/cleanrooms/model/UpdateConfiguredTableResult.h>
#include <aws/cleanrooms/model/UpdateIdMappingTableRequest.h>
#include <aws/cleanrooms/model/UpdateIdMappingTableResult.h>
#include <aws/cleanrooms/model/UpdateIdNamespaceAssociationRequest.h>
#include <aws/cleanrooms/model/UpdateIdNamespaceAssociationResult.h>
#include <aws/cleanrooms/model/UpdateMembershipRequest.h>
#include <aws/cleanrooms/model/UpdateMembershipResult.h>
#include <aws/cleanrooms/model/UpdatePrivacyBudgetTemplateRequest.h>
#include <aws/cleanrooms/model/UpdatePrivacyBudgetTemplateResult.h>
#include <aws/cleanrooms/model/UpdateProtectedJobRequest.h>
#include <aws/cleanrooms/model/UpdateProtectedJobResult.h>
#include <aws/cleanrooms/model/UpdateProtectedQueryRequest.h>
#include <aws/cleanrooms/model/UpdateProtectedQueryResult.h>
#include <aws/cleanrooms/model/ValidationException.h>
#include <aws/cleanrooms/model/ValidationExceptionField.h>
#include <aws/cleanrooms/model/ValidationExceptionReason.h>
#include <aws/cleanrooms/model/WorkerComputeConfiguration.h>
#include <aws/cleanrooms/model/WorkerComputeType.h>

using CleanRoomsIncludeTest = ::testing::Test;

TEST_F(CleanRoomsIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::CleanRooms::CleanRoomsClient>("CleanRoomsIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
