/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/cleanroomsml/CleanRoomsMLClient.h>
#include <aws/cleanroomsml/CleanRoomsMLEndpointProvider.h>
#include <aws/cleanroomsml/CleanRoomsMLEndpointRules.h>
#include <aws/cleanroomsml/CleanRoomsMLErrorMarshaller.h>
#include <aws/cleanroomsml/CleanRoomsMLErrors.h>
#include <aws/cleanroomsml/CleanRoomsMLRequest.h>
#include <aws/cleanroomsml/CleanRoomsMLServiceClientModel.h>
#include <aws/cleanroomsml/CleanRoomsML_EXPORTS.h>
#include <aws/cleanroomsml/model/AudienceDestination.h>
#include <aws/cleanroomsml/model/AudienceExportJobStatus.h>
#include <aws/cleanroomsml/model/AudienceExportJobSummary.h>
#include <aws/cleanroomsml/model/AudienceGenerationJobDataSource.h>
#include <aws/cleanroomsml/model/AudienceGenerationJobStatus.h>
#include <aws/cleanroomsml/model/AudienceGenerationJobSummary.h>
#include <aws/cleanroomsml/model/AudienceModelStatus.h>
#include <aws/cleanroomsml/model/AudienceModelSummary.h>
#include <aws/cleanroomsml/model/AudienceQualityMetrics.h>
#include <aws/cleanroomsml/model/AudienceSize.h>
#include <aws/cleanroomsml/model/AudienceSizeConfig.h>
#include <aws/cleanroomsml/model/AudienceSizeType.h>
#include <aws/cleanroomsml/model/CancelTrainedModelInferenceJobRequest.h>
#include <aws/cleanroomsml/model/CancelTrainedModelRequest.h>
#include <aws/cleanroomsml/model/CollaborationConfiguredModelAlgorithmAssociationSummary.h>
#include <aws/cleanroomsml/model/CollaborationMLInputChannelSummary.h>
#include <aws/cleanroomsml/model/CollaborationTrainedModelExportJobSummary.h>
#include <aws/cleanroomsml/model/CollaborationTrainedModelInferenceJobSummary.h>
#include <aws/cleanroomsml/model/CollaborationTrainedModelSummary.h>
#include <aws/cleanroomsml/model/ColumnSchema.h>
#include <aws/cleanroomsml/model/ColumnType.h>
#include <aws/cleanroomsml/model/ComputeConfiguration.h>
#include <aws/cleanroomsml/model/ConfiguredAudienceModelOutputConfig.h>
#include <aws/cleanroomsml/model/ConfiguredAudienceModelStatus.h>
#include <aws/cleanroomsml/model/ConfiguredAudienceModelSummary.h>
#include <aws/cleanroomsml/model/ConfiguredModelAlgorithmAssociationSummary.h>
#include <aws/cleanroomsml/model/ConfiguredModelAlgorithmSummary.h>
#include <aws/cleanroomsml/model/ContainerConfig.h>
#include <aws/cleanroomsml/model/CreateAudienceModelRequest.h>
#include <aws/cleanroomsml/model/CreateAudienceModelResult.h>
#include <aws/cleanroomsml/model/CreateConfiguredAudienceModelRequest.h>
#include <aws/cleanroomsml/model/CreateConfiguredAudienceModelResult.h>
#include <aws/cleanroomsml/model/CreateConfiguredModelAlgorithmAssociationRequest.h>
#include <aws/cleanroomsml/model/CreateConfiguredModelAlgorithmAssociationResult.h>
#include <aws/cleanroomsml/model/CreateConfiguredModelAlgorithmRequest.h>
#include <aws/cleanroomsml/model/CreateConfiguredModelAlgorithmResult.h>
#include <aws/cleanroomsml/model/CreateMLInputChannelRequest.h>
#include <aws/cleanroomsml/model/CreateMLInputChannelResult.h>
#include <aws/cleanroomsml/model/CreateTrainedModelRequest.h>
#include <aws/cleanroomsml/model/CreateTrainedModelResult.h>
#include <aws/cleanroomsml/model/CreateTrainingDatasetRequest.h>
#include <aws/cleanroomsml/model/CreateTrainingDatasetResult.h>
#include <aws/cleanroomsml/model/DataSource.h>
#include <aws/cleanroomsml/model/Dataset.h>
#include <aws/cleanroomsml/model/DatasetInputConfig.h>
#include <aws/cleanroomsml/model/DatasetType.h>
#include <aws/cleanroomsml/model/DeleteAudienceGenerationJobRequest.h>
#include <aws/cleanroomsml/model/DeleteAudienceModelRequest.h>
#include <aws/cleanroomsml/model/DeleteConfiguredAudienceModelPolicyRequest.h>
#include <aws/cleanroomsml/model/DeleteConfiguredAudienceModelRequest.h>
#include <aws/cleanroomsml/model/DeleteConfiguredModelAlgorithmAssociationRequest.h>
#include <aws/cleanroomsml/model/DeleteConfiguredModelAlgorithmRequest.h>
#include <aws/cleanroomsml/model/DeleteMLConfigurationRequest.h>
#include <aws/cleanroomsml/model/DeleteMLInputChannelDataRequest.h>
#include <aws/cleanroomsml/model/DeleteTrainedModelOutputRequest.h>
#include <aws/cleanroomsml/model/DeleteTrainingDatasetRequest.h>
#include <aws/cleanroomsml/model/Destination.h>
#include <aws/cleanroomsml/model/GetAudienceGenerationJobRequest.h>
#include <aws/cleanroomsml/model/GetAudienceGenerationJobResult.h>
#include <aws/cleanroomsml/model/GetAudienceModelRequest.h>
#include <aws/cleanroomsml/model/GetAudienceModelResult.h>
#include <aws/cleanroomsml/model/GetCollaborationConfiguredModelAlgorithmAssociationRequest.h>
#include <aws/cleanroomsml/model/GetCollaborationConfiguredModelAlgorithmAssociationResult.h>
#include <aws/cleanroomsml/model/GetCollaborationMLInputChannelRequest.h>
#include <aws/cleanroomsml/model/GetCollaborationMLInputChannelResult.h>
#include <aws/cleanroomsml/model/GetCollaborationTrainedModelRequest.h>
#include <aws/cleanroomsml/model/GetCollaborationTrainedModelResult.h>
#include <aws/cleanroomsml/model/GetConfiguredAudienceModelPolicyRequest.h>
#include <aws/cleanroomsml/model/GetConfiguredAudienceModelPolicyResult.h>
#include <aws/cleanroomsml/model/GetConfiguredAudienceModelRequest.h>
#include <aws/cleanroomsml/model/GetConfiguredAudienceModelResult.h>
#include <aws/cleanroomsml/model/GetConfiguredModelAlgorithmAssociationRequest.h>
#include <aws/cleanroomsml/model/GetConfiguredModelAlgorithmAssociationResult.h>
#include <aws/cleanroomsml/model/GetConfiguredModelAlgorithmRequest.h>
#include <aws/cleanroomsml/model/GetConfiguredModelAlgorithmResult.h>
#include <aws/cleanroomsml/model/GetMLConfigurationRequest.h>
#include <aws/cleanroomsml/model/GetMLConfigurationResult.h>
#include <aws/cleanroomsml/model/GetMLInputChannelRequest.h>
#include <aws/cleanroomsml/model/GetMLInputChannelResult.h>
#include <aws/cleanroomsml/model/GetTrainedModelInferenceJobRequest.h>
#include <aws/cleanroomsml/model/GetTrainedModelInferenceJobResult.h>
#include <aws/cleanroomsml/model/GetTrainedModelRequest.h>
#include <aws/cleanroomsml/model/GetTrainedModelResult.h>
#include <aws/cleanroomsml/model/GetTrainingDatasetRequest.h>
#include <aws/cleanroomsml/model/GetTrainingDatasetResult.h>
#include <aws/cleanroomsml/model/GlueDataSource.h>
#include <aws/cleanroomsml/model/InferenceContainerConfig.h>
#include <aws/cleanroomsml/model/InferenceContainerExecutionParameters.h>
#include <aws/cleanroomsml/model/InferenceInstanceType.h>
#include <aws/cleanroomsml/model/InferenceOutputConfiguration.h>
#include <aws/cleanroomsml/model/InferenceReceiverMember.h>
#include <aws/cleanroomsml/model/InferenceResourceConfig.h>
#include <aws/cleanroomsml/model/InputChannel.h>
#include <aws/cleanroomsml/model/InputChannelDataSource.h>
#include <aws/cleanroomsml/model/InstanceType.h>
#include <aws/cleanroomsml/model/ListAudienceExportJobsRequest.h>
#include <aws/cleanroomsml/model/ListAudienceExportJobsResult.h>
#include <aws/cleanroomsml/model/ListAudienceGenerationJobsRequest.h>
#include <aws/cleanroomsml/model/ListAudienceGenerationJobsResult.h>
#include <aws/cleanroomsml/model/ListAudienceModelsRequest.h>
#include <aws/cleanroomsml/model/ListAudienceModelsResult.h>
#include <aws/cleanroomsml/model/ListCollaborationConfiguredModelAlgorithmAssociationsRequest.h>
#include <aws/cleanroomsml/model/ListCollaborationConfiguredModelAlgorithmAssociationsResult.h>
#include <aws/cleanroomsml/model/ListCollaborationMLInputChannelsRequest.h>
#include <aws/cleanroomsml/model/ListCollaborationMLInputChannelsResult.h>
#include <aws/cleanroomsml/model/ListCollaborationTrainedModelExportJobsRequest.h>
#include <aws/cleanroomsml/model/ListCollaborationTrainedModelExportJobsResult.h>
#include <aws/cleanroomsml/model/ListCollaborationTrainedModelInferenceJobsRequest.h>
#include <aws/cleanroomsml/model/ListCollaborationTrainedModelInferenceJobsResult.h>
#include <aws/cleanroomsml/model/ListCollaborationTrainedModelsRequest.h>
#include <aws/cleanroomsml/model/ListCollaborationTrainedModelsResult.h>
#include <aws/cleanroomsml/model/ListConfiguredAudienceModelsRequest.h>
#include <aws/cleanroomsml/model/ListConfiguredAudienceModelsResult.h>
#include <aws/cleanroomsml/model/ListConfiguredModelAlgorithmAssociationsRequest.h>
#include <aws/cleanroomsml/model/ListConfiguredModelAlgorithmAssociationsResult.h>
#include <aws/cleanroomsml/model/ListConfiguredModelAlgorithmsRequest.h>
#include <aws/cleanroomsml/model/ListConfiguredModelAlgorithmsResult.h>
#include <aws/cleanroomsml/model/ListMLInputChannelsRequest.h>
#include <aws/cleanroomsml/model/ListMLInputChannelsResult.h>
#include <aws/cleanroomsml/model/ListTagsForResourceRequest.h>
#include <aws/cleanroomsml/model/ListTagsForResourceResult.h>
#include <aws/cleanroomsml/model/ListTrainedModelInferenceJobsRequest.h>
#include <aws/cleanroomsml/model/ListTrainedModelInferenceJobsResult.h>
#include <aws/cleanroomsml/model/ListTrainedModelsRequest.h>
#include <aws/cleanroomsml/model/ListTrainedModelsResult.h>
#include <aws/cleanroomsml/model/ListTrainingDatasetsRequest.h>
#include <aws/cleanroomsml/model/ListTrainingDatasetsResult.h>
#include <aws/cleanroomsml/model/LogsConfigurationPolicy.h>
#include <aws/cleanroomsml/model/LogsStatus.h>
#include <aws/cleanroomsml/model/MLInputChannelStatus.h>
#include <aws/cleanroomsml/model/MLInputChannelSummary.h>
#include <aws/cleanroomsml/model/MLOutputConfiguration.h>
#include <aws/cleanroomsml/model/MetricDefinition.h>
#include <aws/cleanroomsml/model/MetricsConfigurationPolicy.h>
#include <aws/cleanroomsml/model/MetricsStatus.h>
#include <aws/cleanroomsml/model/ModelInferenceDataSource.h>
#include <aws/cleanroomsml/model/ModelTrainingDataChannel.h>
#include <aws/cleanroomsml/model/NoiseLevelType.h>
#include <aws/cleanroomsml/model/PolicyExistenceCondition.h>
#include <aws/cleanroomsml/model/PrivacyConfiguration.h>
#include <aws/cleanroomsml/model/PrivacyConfigurationPolicies.h>
#include <aws/cleanroomsml/model/ProtectedQueryInputParameters.h>
#include <aws/cleanroomsml/model/ProtectedQuerySQLParameters.h>
#include <aws/cleanroomsml/model/PutConfiguredAudienceModelPolicyRequest.h>
#include <aws/cleanroomsml/model/PutConfiguredAudienceModelPolicyResult.h>
#include <aws/cleanroomsml/model/PutMLConfigurationRequest.h>
#include <aws/cleanroomsml/model/RelevanceMetric.h>
#include <aws/cleanroomsml/model/ResourceConfig.h>
#include <aws/cleanroomsml/model/S3ConfigMap.h>
#include <aws/cleanroomsml/model/SharedAudienceMetrics.h>
#include <aws/cleanroomsml/model/StartAudienceExportJobRequest.h>
#include <aws/cleanroomsml/model/StartAudienceGenerationJobRequest.h>
#include <aws/cleanroomsml/model/StartAudienceGenerationJobResult.h>
#include <aws/cleanroomsml/model/StartTrainedModelExportJobRequest.h>
#include <aws/cleanroomsml/model/StartTrainedModelInferenceJobRequest.h>
#include <aws/cleanroomsml/model/StartTrainedModelInferenceJobResult.h>
#include <aws/cleanroomsml/model/StatusDetails.h>
#include <aws/cleanroomsml/model/StoppingCondition.h>
#include <aws/cleanroomsml/model/TagOnCreatePolicy.h>
#include <aws/cleanroomsml/model/TagResourceRequest.h>
#include <aws/cleanroomsml/model/TagResourceResult.h>
#include <aws/cleanroomsml/model/TrainedModelExportFileType.h>
#include <aws/cleanroomsml/model/TrainedModelExportJobStatus.h>
#include <aws/cleanroomsml/model/TrainedModelExportOutputConfiguration.h>
#include <aws/cleanroomsml/model/TrainedModelExportReceiverMember.h>
#include <aws/cleanroomsml/model/TrainedModelExportsConfigurationPolicy.h>
#include <aws/cleanroomsml/model/TrainedModelExportsMaxSize.h>
#include <aws/cleanroomsml/model/TrainedModelExportsMaxSizeUnitType.h>
#include <aws/cleanroomsml/model/TrainedModelInferenceJobStatus.h>
#include <aws/cleanroomsml/model/TrainedModelInferenceJobSummary.h>
#include <aws/cleanroomsml/model/TrainedModelInferenceJobsConfigurationPolicy.h>
#include <aws/cleanroomsml/model/TrainedModelInferenceMaxOutputSize.h>
#include <aws/cleanroomsml/model/TrainedModelInferenceMaxOutputSizeUnitType.h>
#include <aws/cleanroomsml/model/TrainedModelStatus.h>
#include <aws/cleanroomsml/model/TrainedModelSummary.h>
#include <aws/cleanroomsml/model/TrainedModelsConfigurationPolicy.h>
#include <aws/cleanroomsml/model/TrainingDatasetStatus.h>
#include <aws/cleanroomsml/model/TrainingDatasetSummary.h>
#include <aws/cleanroomsml/model/UntagResourceRequest.h>
#include <aws/cleanroomsml/model/UntagResourceResult.h>
#include <aws/cleanroomsml/model/UpdateConfiguredAudienceModelRequest.h>
#include <aws/cleanroomsml/model/UpdateConfiguredAudienceModelResult.h>
#include <aws/cleanroomsml/model/WorkerComputeConfiguration.h>
#include <aws/cleanroomsml/model/WorkerComputeType.h>

using CleanRoomsMLIncludeTest = ::testing::Test;

TEST_F(CleanRoomsMLIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::CleanRoomsML::CleanRoomsMLClient>("CleanRoomsMLIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
