/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/cloudfront/CloudFrontClient.h>
#include <aws/cloudfront/CloudFrontEndpointProvider.h>
#include <aws/cloudfront/CloudFrontEndpointRules.h>
#include <aws/cloudfront/CloudFrontErrorMarshaller.h>
#include <aws/cloudfront/CloudFrontErrors.h>
#include <aws/cloudfront/CloudFrontRequest.h>
#include <aws/cloudfront/CloudFrontServiceClientModel.h>
#include <aws/cloudfront/CloudFront_EXPORTS.h>
#include <aws/cloudfront/model/ActiveTrustedKeyGroups.h>
#include <aws/cloudfront/model/ActiveTrustedSigners.h>
#include <aws/cloudfront/model/AliasICPRecordal.h>
#include <aws/cloudfront/model/Aliases.h>
#include <aws/cloudfront/model/AllowedMethods.h>
#include <aws/cloudfront/model/AnycastIpList.h>
#include <aws/cloudfront/model/AnycastIpListCollection.h>
#include <aws/cloudfront/model/AnycastIpListSummary.h>
#include <aws/cloudfront/model/AssociateAlias2020_05_31Request.h>
#include <aws/cloudfront/model/AssociateDistributionTenantWebACL2020_05_31Request.h>
#include <aws/cloudfront/model/AssociateDistributionTenantWebACL2020_05_31Result.h>
#include <aws/cloudfront/model/AssociateDistributionWebACL2020_05_31Request.h>
#include <aws/cloudfront/model/AssociateDistributionWebACL2020_05_31Result.h>
#include <aws/cloudfront/model/CacheBehavior.h>
#include <aws/cloudfront/model/CacheBehaviors.h>
#include <aws/cloudfront/model/CachePolicy.h>
#include <aws/cloudfront/model/CachePolicyConfig.h>
#include <aws/cloudfront/model/CachePolicyCookieBehavior.h>
#include <aws/cloudfront/model/CachePolicyCookiesConfig.h>
#include <aws/cloudfront/model/CachePolicyHeaderBehavior.h>
#include <aws/cloudfront/model/CachePolicyHeadersConfig.h>
#include <aws/cloudfront/model/CachePolicyList.h>
#include <aws/cloudfront/model/CachePolicyQueryStringBehavior.h>
#include <aws/cloudfront/model/CachePolicyQueryStringsConfig.h>
#include <aws/cloudfront/model/CachePolicySummary.h>
#include <aws/cloudfront/model/CachePolicyType.h>
#include <aws/cloudfront/model/CachedMethods.h>
#include <aws/cloudfront/model/Certificate.h>
#include <aws/cloudfront/model/CertificateTransparencyLoggingPreference.h>
#include <aws/cloudfront/model/CloudFrontOriginAccessIdentity.h>
#include <aws/cloudfront/model/CloudFrontOriginAccessIdentityConfig.h>
#include <aws/cloudfront/model/CloudFrontOriginAccessIdentityList.h>
#include <aws/cloudfront/model/CloudFrontOriginAccessIdentitySummary.h>
#include <aws/cloudfront/model/ConflictingAlias.h>
#include <aws/cloudfront/model/ConflictingAliasesList.h>
#include <aws/cloudfront/model/ConnectionGroup.h>
#include <aws/cloudfront/model/ConnectionGroupAssociationFilter.h>
#include <aws/cloudfront/model/ConnectionGroupSummary.h>
#include <aws/cloudfront/model/ConnectionMode.h>
#include <aws/cloudfront/model/ContentTypeProfile.h>
#include <aws/cloudfront/model/ContentTypeProfileConfig.h>
#include <aws/cloudfront/model/ContentTypeProfiles.h>
#include <aws/cloudfront/model/ContinuousDeploymentPolicy.h>
#include <aws/cloudfront/model/ContinuousDeploymentPolicyConfig.h>
#include <aws/cloudfront/model/ContinuousDeploymentPolicyList.h>
#include <aws/cloudfront/model/ContinuousDeploymentPolicySummary.h>
#include <aws/cloudfront/model/ContinuousDeploymentPolicyType.h>
#include <aws/cloudfront/model/ContinuousDeploymentSingleHeaderConfig.h>
#include <aws/cloudfront/model/ContinuousDeploymentSingleWeightConfig.h>
#include <aws/cloudfront/model/CookieNames.h>
#include <aws/cloudfront/model/CookiePreference.h>
#include <aws/cloudfront/model/CopyDistribution2020_05_31Request.h>
#include <aws/cloudfront/model/CopyDistribution2020_05_31Result.h>
#include <aws/cloudfront/model/CreateAnycastIpList2020_05_31Request.h>
#include <aws/cloudfront/model/CreateAnycastIpList2020_05_31Result.h>
#include <aws/cloudfront/model/CreateCachePolicy2020_05_31Request.h>
#include <aws/cloudfront/model/CreateCachePolicy2020_05_31Result.h>
#include <aws/cloudfront/model/CreateCloudFrontOriginAccessIdentity2020_05_31Request.h>
#include <aws/cloudfront/model/CreateCloudFrontOriginAccessIdentity2020_05_31Result.h>
#include <aws/cloudfront/model/CreateConnectionGroup2020_05_31Request.h>
#include <aws/cloudfront/model/CreateConnectionGroup2020_05_31Result.h>
#include <aws/cloudfront/model/CreateContinuousDeploymentPolicy2020_05_31Request.h>
#include <aws/cloudfront/model/CreateContinuousDeploymentPolicy2020_05_31Result.h>
#include <aws/cloudfront/model/CreateDistribution2020_05_31Request.h>
#include <aws/cloudfront/model/CreateDistribution2020_05_31Result.h>
#include <aws/cloudfront/model/CreateDistributionTenant2020_05_31Request.h>
#include <aws/cloudfront/model/CreateDistributionTenant2020_05_31Result.h>
#include <aws/cloudfront/model/CreateDistributionWithTags2020_05_31Request.h>
#include <aws/cloudfront/model/CreateDistributionWithTags2020_05_31Result.h>
#include <aws/cloudfront/model/CreateFieldLevelEncryptionConfig2020_05_31Request.h>
#include <aws/cloudfront/model/CreateFieldLevelEncryptionConfig2020_05_31Result.h>
#include <aws/cloudfront/model/CreateFieldLevelEncryptionProfile2020_05_31Request.h>
#include <aws/cloudfront/model/CreateFieldLevelEncryptionProfile2020_05_31Result.h>
#include <aws/cloudfront/model/CreateFunction2020_05_31Request.h>
#include <aws/cloudfront/model/CreateFunction2020_05_31Result.h>
#include <aws/cloudfront/model/CreateInvalidation2020_05_31Request.h>
#include <aws/cloudfront/model/CreateInvalidation2020_05_31Result.h>
#include <aws/cloudfront/model/CreateInvalidationForDistributionTenant2020_05_31Request.h>
#include <aws/cloudfront/model/CreateInvalidationForDistributionTenant2020_05_31Result.h>
#include <aws/cloudfront/model/CreateKeyGroup2020_05_31Request.h>
#include <aws/cloudfront/model/CreateKeyGroup2020_05_31Result.h>
#include <aws/cloudfront/model/CreateKeyValueStore2020_05_31Request.h>
#include <aws/cloudfront/model/CreateKeyValueStore2020_05_31Result.h>
#include <aws/cloudfront/model/CreateMonitoringSubscription2020_05_31Request.h>
#include <aws/cloudfront/model/CreateMonitoringSubscription2020_05_31Result.h>
#include <aws/cloudfront/model/CreateOriginAccessControl2020_05_31Request.h>
#include <aws/cloudfront/model/CreateOriginAccessControl2020_05_31Result.h>
#include <aws/cloudfront/model/CreateOriginRequestPolicy2020_05_31Request.h>
#include <aws/cloudfront/model/CreateOriginRequestPolicy2020_05_31Result.h>
#include <aws/cloudfront/model/CreatePublicKey2020_05_31Request.h>
#include <aws/cloudfront/model/CreatePublicKey2020_05_31Result.h>
#include <aws/cloudfront/model/CreateRealtimeLogConfig2020_05_31Request.h>
#include <aws/cloudfront/model/CreateRealtimeLogConfig2020_05_31Result.h>
#include <aws/cloudfront/model/CreateResponseHeadersPolicy2020_05_31Request.h>
#include <aws/cloudfront/model/CreateResponseHeadersPolicy2020_05_31Result.h>
#include <aws/cloudfront/model/CreateStreamingDistribution2020_05_31Request.h>
#include <aws/cloudfront/model/CreateStreamingDistribution2020_05_31Result.h>
#include <aws/cloudfront/model/CreateStreamingDistributionWithTags2020_05_31Request.h>
#include <aws/cloudfront/model/CreateStreamingDistributionWithTags2020_05_31Result.h>
#include <aws/cloudfront/model/CreateVpcOrigin2020_05_31Request.h>
#include <aws/cloudfront/model/CreateVpcOrigin2020_05_31Result.h>
#include <aws/cloudfront/model/CustomErrorResponse.h>
#include <aws/cloudfront/model/CustomErrorResponses.h>
#include <aws/cloudfront/model/CustomHeaders.h>
#include <aws/cloudfront/model/CustomOriginConfig.h>
#include <aws/cloudfront/model/CustomizationActionType.h>
#include <aws/cloudfront/model/Customizations.h>
#include <aws/cloudfront/model/DefaultCacheBehavior.h>
#include <aws/cloudfront/model/DeleteAnycastIpList2020_05_31Request.h>
#include <aws/cloudfront/model/DeleteCachePolicy2020_05_31Request.h>
#include <aws/cloudfront/model/DeleteCloudFrontOriginAccessIdentity2020_05_31Request.h>
#include <aws/cloudfront/model/DeleteConnectionGroup2020_05_31Request.h>
#include <aws/cloudfront/model/DeleteContinuousDeploymentPolicy2020_05_31Request.h>
#include <aws/cloudfront/model/DeleteDistribution2020_05_31Request.h>
#include <aws/cloudfront/model/DeleteDistributionTenant2020_05_31Request.h>
#include <aws/cloudfront/model/DeleteFieldLevelEncryptionConfig2020_05_31Request.h>
#include <aws/cloudfront/model/DeleteFieldLevelEncryptionProfile2020_05_31Request.h>
#include <aws/cloudfront/model/DeleteFunction2020_05_31Request.h>
#include <aws/cloudfront/model/DeleteKeyGroup2020_05_31Request.h>
#include <aws/cloudfront/model/DeleteKeyValueStore2020_05_31Request.h>
#include <aws/cloudfront/model/DeleteMonitoringSubscription2020_05_31Request.h>
#include <aws/cloudfront/model/DeleteMonitoringSubscription2020_05_31Result.h>
#include <aws/cloudfront/model/DeleteOriginAccessControl2020_05_31Request.h>
#include <aws/cloudfront/model/DeleteOriginRequestPolicy2020_05_31Request.h>
#include <aws/cloudfront/model/DeletePublicKey2020_05_31Request.h>
#include <aws/cloudfront/model/DeleteRealtimeLogConfig2020_05_31Request.h>
#include <aws/cloudfront/model/DeleteResponseHeadersPolicy2020_05_31Request.h>
#include <aws/cloudfront/model/DeleteStreamingDistribution2020_05_31Request.h>
#include <aws/cloudfront/model/DeleteVpcOrigin2020_05_31Request.h>
#include <aws/cloudfront/model/DeleteVpcOrigin2020_05_31Result.h>
#include <aws/cloudfront/model/DescribeFunction2020_05_31Request.h>
#include <aws/cloudfront/model/DescribeFunction2020_05_31Result.h>
#include <aws/cloudfront/model/DescribeKeyValueStore2020_05_31Request.h>
#include <aws/cloudfront/model/DescribeKeyValueStore2020_05_31Result.h>
#include <aws/cloudfront/model/DisassociateDistributionTenantWebACL2020_05_31Request.h>
#include <aws/cloudfront/model/DisassociateDistributionTenantWebACL2020_05_31Result.h>
#include <aws/cloudfront/model/DisassociateDistributionWebACL2020_05_31Request.h>
#include <aws/cloudfront/model/DisassociateDistributionWebACL2020_05_31Result.h>
#include <aws/cloudfront/model/Distribution.h>
#include <aws/cloudfront/model/DistributionConfig.h>
#include <aws/cloudfront/model/DistributionConfigWithTags.h>
#include <aws/cloudfront/model/DistributionIdList.h>
#include <aws/cloudfront/model/DistributionList.h>
#include <aws/cloudfront/model/DistributionResourceId.h>
#include <aws/cloudfront/model/DistributionResourceType.h>
#include <aws/cloudfront/model/DistributionSummary.h>
#include <aws/cloudfront/model/DistributionTenant.h>
#include <aws/cloudfront/model/DistributionTenantAssociationFilter.h>
#include <aws/cloudfront/model/DistributionTenantSummary.h>
#include <aws/cloudfront/model/DnsConfiguration.h>
#include <aws/cloudfront/model/DnsConfigurationStatus.h>
#include <aws/cloudfront/model/DomainConflict.h>
#include <aws/cloudfront/model/DomainItem.h>
#include <aws/cloudfront/model/DomainResult.h>
#include <aws/cloudfront/model/DomainStatus.h>
#include <aws/cloudfront/model/EncryptionEntities.h>
#include <aws/cloudfront/model/EncryptionEntity.h>
#include <aws/cloudfront/model/EndPoint.h>
#include <aws/cloudfront/model/EventType.h>
#include <aws/cloudfront/model/FieldLevelEncryption.h>
#include <aws/cloudfront/model/FieldLevelEncryptionConfig.h>
#include <aws/cloudfront/model/FieldLevelEncryptionList.h>
#include <aws/cloudfront/model/FieldLevelEncryptionProfile.h>
#include <aws/cloudfront/model/FieldLevelEncryptionProfileConfig.h>
#include <aws/cloudfront/model/FieldLevelEncryptionProfileList.h>
#include <aws/cloudfront/model/FieldLevelEncryptionProfileSummary.h>
#include <aws/cloudfront/model/FieldLevelEncryptionSummary.h>
#include <aws/cloudfront/model/FieldPatterns.h>
#include <aws/cloudfront/model/Format.h>
#include <aws/cloudfront/model/FrameOptionsList.h>
#include <aws/cloudfront/model/FunctionAssociation.h>
#include <aws/cloudfront/model/FunctionAssociations.h>
#include <aws/cloudfront/model/FunctionConfig.h>
#include <aws/cloudfront/model/FunctionList.h>
#include <aws/cloudfront/model/FunctionMetadata.h>
#include <aws/cloudfront/model/FunctionRuntime.h>
#include <aws/cloudfront/model/FunctionStage.h>
#include <aws/cloudfront/model/FunctionSummary.h>
#include <aws/cloudfront/model/GeoRestriction.h>
#include <aws/cloudfront/model/GeoRestrictionCustomization.h>
#include <aws/cloudfront/model/GeoRestrictionType.h>
#include <aws/cloudfront/model/GetAnycastIpList2020_05_31Request.h>
#include <aws/cloudfront/model/GetAnycastIpList2020_05_31Result.h>
#include <aws/cloudfront/model/GetCachePolicy2020_05_31Request.h>
#include <aws/cloudfront/model/GetCachePolicy2020_05_31Result.h>
#include <aws/cloudfront/model/GetCachePolicyConfig2020_05_31Request.h>
#include <aws/cloudfront/model/GetCachePolicyConfig2020_05_31Result.h>
#include <aws/cloudfront/model/GetCloudFrontOriginAccessIdentity2020_05_31Request.h>
#include <aws/cloudfront/model/GetCloudFrontOriginAccessIdentity2020_05_31Result.h>
#include <aws/cloudfront/model/GetCloudFrontOriginAccessIdentityConfig2020_05_31Request.h>
#include <aws/cloudfront/model/GetCloudFrontOriginAccessIdentityConfig2020_05_31Result.h>
#include <aws/cloudfront/model/GetConnectionGroup2020_05_31Request.h>
#include <aws/cloudfront/model/GetConnectionGroup2020_05_31Result.h>
#include <aws/cloudfront/model/GetConnectionGroupByRoutingEndpoint2020_05_31Request.h>
#include <aws/cloudfront/model/GetConnectionGroupByRoutingEndpoint2020_05_31Result.h>
#include <aws/cloudfront/model/GetContinuousDeploymentPolicy2020_05_31Request.h>
#include <aws/cloudfront/model/GetContinuousDeploymentPolicy2020_05_31Result.h>
#include <aws/cloudfront/model/GetContinuousDeploymentPolicyConfig2020_05_31Request.h>
#include <aws/cloudfront/model/GetContinuousDeploymentPolicyConfig2020_05_31Result.h>
#include <aws/cloudfront/model/GetDistribution2020_05_31Request.h>
#include <aws/cloudfront/model/GetDistribution2020_05_31Result.h>
#include <aws/cloudfront/model/GetDistributionConfig2020_05_31Request.h>
#include <aws/cloudfront/model/GetDistributionConfig2020_05_31Result.h>
#include <aws/cloudfront/model/GetDistributionTenant2020_05_31Request.h>
#include <aws/cloudfront/model/GetDistributionTenant2020_05_31Result.h>
#include <aws/cloudfront/model/GetDistributionTenantByDomain2020_05_31Request.h>
#include <aws/cloudfront/model/GetDistributionTenantByDomain2020_05_31Result.h>
#include <aws/cloudfront/model/GetFieldLevelEncryption2020_05_31Request.h>
#include <aws/cloudfront/model/GetFieldLevelEncryption2020_05_31Result.h>
#include <aws/cloudfront/model/GetFieldLevelEncryptionConfig2020_05_31Request.h>
#include <aws/cloudfront/model/GetFieldLevelEncryptionConfig2020_05_31Result.h>
#include <aws/cloudfront/model/GetFieldLevelEncryptionProfile2020_05_31Request.h>
#include <aws/cloudfront/model/GetFieldLevelEncryptionProfile2020_05_31Result.h>
#include <aws/cloudfront/model/GetFieldLevelEncryptionProfileConfig2020_05_31Request.h>
#include <aws/cloudfront/model/GetFieldLevelEncryptionProfileConfig2020_05_31Result.h>
#include <aws/cloudfront/model/GetFunction2020_05_31Request.h>
#include <aws/cloudfront/model/GetFunction2020_05_31Result.h>
#include <aws/cloudfront/model/GetInvalidation2020_05_31Request.h>
#include <aws/cloudfront/model/GetInvalidation2020_05_31Result.h>
#include <aws/cloudfront/model/GetInvalidationForDistributionTenant2020_05_31Request.h>
#include <aws/cloudfront/model/GetInvalidationForDistributionTenant2020_05_31Result.h>
#include <aws/cloudfront/model/GetKeyGroup2020_05_31Request.h>
#include <aws/cloudfront/model/GetKeyGroup2020_05_31Result.h>
#include <aws/cloudfront/model/GetKeyGroupConfig2020_05_31Request.h>
#include <aws/cloudfront/model/GetKeyGroupConfig2020_05_31Result.h>
#include <aws/cloudfront/model/GetManagedCertificateDetails2020_05_31Request.h>
#include <aws/cloudfront/model/GetManagedCertificateDetails2020_05_31Result.h>
#include <aws/cloudfront/model/GetMonitoringSubscription2020_05_31Request.h>
#include <aws/cloudfront/model/GetMonitoringSubscription2020_05_31Result.h>
#include <aws/cloudfront/model/GetOriginAccessControl2020_05_31Request.h>
#include <aws/cloudfront/model/GetOriginAccessControl2020_05_31Result.h>
#include <aws/cloudfront/model/GetOriginAccessControlConfig2020_05_31Request.h>
#include <aws/cloudfront/model/GetOriginAccessControlConfig2020_05_31Result.h>
#include <aws/cloudfront/model/GetOriginRequestPolicy2020_05_31Request.h>
#include <aws/cloudfront/model/GetOriginRequestPolicy2020_05_31Result.h>
#include <aws/cloudfront/model/GetOriginRequestPolicyConfig2020_05_31Request.h>
#include <aws/cloudfront/model/GetOriginRequestPolicyConfig2020_05_31Result.h>
#include <aws/cloudfront/model/GetPublicKey2020_05_31Request.h>
#include <aws/cloudfront/model/GetPublicKey2020_05_31Result.h>
#include <aws/cloudfront/model/GetPublicKeyConfig2020_05_31Request.h>
#include <aws/cloudfront/model/GetPublicKeyConfig2020_05_31Result.h>
#include <aws/cloudfront/model/GetRealtimeLogConfig2020_05_31Request.h>
#include <aws/cloudfront/model/GetRealtimeLogConfig2020_05_31Result.h>
#include <aws/cloudfront/model/GetResponseHeadersPolicy2020_05_31Request.h>
#include <aws/cloudfront/model/GetResponseHeadersPolicy2020_05_31Result.h>
#include <aws/cloudfront/model/GetResponseHeadersPolicyConfig2020_05_31Request.h>
#include <aws/cloudfront/model/GetResponseHeadersPolicyConfig2020_05_31Result.h>
#include <aws/cloudfront/model/GetStreamingDistribution2020_05_31Request.h>
#include <aws/cloudfront/model/GetStreamingDistribution2020_05_31Result.h>
#include <aws/cloudfront/model/GetStreamingDistributionConfig2020_05_31Request.h>
#include <aws/cloudfront/model/GetStreamingDistributionConfig2020_05_31Result.h>
#include <aws/cloudfront/model/GetVpcOrigin2020_05_31Request.h>
#include <aws/cloudfront/model/GetVpcOrigin2020_05_31Result.h>
#include <aws/cloudfront/model/GrpcConfig.h>
#include <aws/cloudfront/model/Headers.h>
#include <aws/cloudfront/model/HttpVersion.h>
#include <aws/cloudfront/model/ICPRecordalStatus.h>
#include <aws/cloudfront/model/ImportSource.h>
#include <aws/cloudfront/model/ImportSourceType.h>
#include <aws/cloudfront/model/Invalidation.h>
#include <aws/cloudfront/model/InvalidationBatch.h>
#include <aws/cloudfront/model/InvalidationList.h>
#include <aws/cloudfront/model/InvalidationSummary.h>
#include <aws/cloudfront/model/ItemSelection.h>
#include <aws/cloudfront/model/KGKeyPairIds.h>
#include <aws/cloudfront/model/KeyGroup.h>
#include <aws/cloudfront/model/KeyGroupConfig.h>
#include <aws/cloudfront/model/KeyGroupList.h>
#include <aws/cloudfront/model/KeyGroupSummary.h>
#include <aws/cloudfront/model/KeyPairIds.h>
#include <aws/cloudfront/model/KeyValueStore.h>
#include <aws/cloudfront/model/KeyValueStoreAssociation.h>
#include <aws/cloudfront/model/KeyValueStoreAssociations.h>
#include <aws/cloudfront/model/KeyValueStoreList.h>
#include <aws/cloudfront/model/KinesisStreamConfig.h>
#include <aws/cloudfront/model/LambdaFunctionAssociation.h>
#include <aws/cloudfront/model/LambdaFunctionAssociations.h>
#include <aws/cloudfront/model/ListAnycastIpLists2020_05_31Request.h>
#include <aws/cloudfront/model/ListAnycastIpLists2020_05_31Result.h>
#include <aws/cloudfront/model/ListCachePolicies2020_05_31Request.h>
#include <aws/cloudfront/model/ListCachePolicies2020_05_31Result.h>
#include <aws/cloudfront/model/ListCloudFrontOriginAccessIdentities2020_05_31Request.h>
#include <aws/cloudfront/model/ListCloudFrontOriginAccessIdentities2020_05_31Result.h>
#include <aws/cloudfront/model/ListConflictingAliases2020_05_31Request.h>
#include <aws/cloudfront/model/ListConflictingAliases2020_05_31Result.h>
#include <aws/cloudfront/model/ListConnectionGroups2020_05_31Request.h>
#include <aws/cloudfront/model/ListConnectionGroups2020_05_31Result.h>
#include <aws/cloudfront/model/ListContinuousDeploymentPolicies2020_05_31Request.h>
#include <aws/cloudfront/model/ListContinuousDeploymentPolicies2020_05_31Result.h>
#include <aws/cloudfront/model/ListDistributionTenants2020_05_31Request.h>
#include <aws/cloudfront/model/ListDistributionTenants2020_05_31Result.h>
#include <aws/cloudfront/model/ListDistributionTenantsByCustomization2020_05_31Request.h>
#include <aws/cloudfront/model/ListDistributionTenantsByCustomization2020_05_31Result.h>
#include <aws/cloudfront/model/ListDistributions2020_05_31Request.h>
#include <aws/cloudfront/model/ListDistributions2020_05_31Result.h>
#include <aws/cloudfront/model/ListDistributionsByAnycastIpListId2020_05_31Request.h>
#include <aws/cloudfront/model/ListDistributionsByAnycastIpListId2020_05_31Result.h>
#include <aws/cloudfront/model/ListDistributionsByCachePolicyId2020_05_31Request.h>
#include <aws/cloudfront/model/ListDistributionsByCachePolicyId2020_05_31Result.h>
#include <aws/cloudfront/model/ListDistributionsByConnectionMode2020_05_31Request.h>
#include <aws/cloudfront/model/ListDistributionsByConnectionMode2020_05_31Result.h>
#include <aws/cloudfront/model/ListDistributionsByKeyGroup2020_05_31Request.h>
#include <aws/cloudfront/model/ListDistributionsByKeyGroup2020_05_31Result.h>
#include <aws/cloudfront/model/ListDistributionsByOriginRequestPolicyId2020_05_31Request.h>
#include <aws/cloudfront/model/ListDistributionsByOriginRequestPolicyId2020_05_31Result.h>
#include <aws/cloudfront/model/ListDistributionsByRealtimeLogConfig2020_05_31Request.h>
#include <aws/cloudfront/model/ListDistributionsByRealtimeLogConfig2020_05_31Result.h>
#include <aws/cloudfront/model/ListDistributionsByResponseHeadersPolicyId2020_05_31Request.h>
#include <aws/cloudfront/model/ListDistributionsByResponseHeadersPolicyId2020_05_31Result.h>
#include <aws/cloudfront/model/ListDistributionsByVpcOriginId2020_05_31Request.h>
#include <aws/cloudfront/model/ListDistributionsByVpcOriginId2020_05_31Result.h>
#include <aws/cloudfront/model/ListDistributionsByWebACLId2020_05_31Request.h>
#include <aws/cloudfront/model/ListDistributionsByWebACLId2020_05_31Result.h>
#include <aws/cloudfront/model/ListDomainConflicts2020_05_31Request.h>
#include <aws/cloudfront/model/ListDomainConflicts2020_05_31Result.h>
#include <aws/cloudfront/model/ListFieldLevelEncryptionConfigs2020_05_31Request.h>
#include <aws/cloudfront/model/ListFieldLevelEncryptionConfigs2020_05_31Result.h>
#include <aws/cloudfront/model/ListFieldLevelEncryptionProfiles2020_05_31Request.h>
#include <aws/cloudfront/model/ListFieldLevelEncryptionProfiles2020_05_31Result.h>
#include <aws/cloudfront/model/ListFunctions2020_05_31Request.h>
#include <aws/cloudfront/model/ListFunctions2020_05_31Result.h>
#include <aws/cloudfront/model/ListInvalidations2020_05_31Request.h>
#include <aws/cloudfront/model/ListInvalidations2020_05_31Result.h>
#include <aws/cloudfront/model/ListInvalidationsForDistributionTenant2020_05_31Request.h>
#include <aws/cloudfront/model/ListInvalidationsForDistributionTenant2020_05_31Result.h>
#include <aws/cloudfront/model/ListKeyGroups2020_05_31Request.h>
#include <aws/cloudfront/model/ListKeyGroups2020_05_31Result.h>
#include <aws/cloudfront/model/ListKeyValueStores2020_05_31Request.h>
#include <aws/cloudfront/model/ListKeyValueStores2020_05_31Result.h>
#include <aws/cloudfront/model/ListOriginAccessControls2020_05_31Request.h>
#include <aws/cloudfront/model/ListOriginAccessControls2020_05_31Result.h>
#include <aws/cloudfront/model/ListOriginRequestPolicies2020_05_31Request.h>
#include <aws/cloudfront/model/ListOriginRequestPolicies2020_05_31Result.h>
#include <aws/cloudfront/model/ListPublicKeys2020_05_31Request.h>
#include <aws/cloudfront/model/ListPublicKeys2020_05_31Result.h>
#include <aws/cloudfront/model/ListRealtimeLogConfigs2020_05_31Request.h>
#include <aws/cloudfront/model/ListRealtimeLogConfigs2020_05_31Result.h>
#include <aws/cloudfront/model/ListResponseHeadersPolicies2020_05_31Request.h>
#include <aws/cloudfront/model/ListResponseHeadersPolicies2020_05_31Result.h>
#include <aws/cloudfront/model/ListStreamingDistributions2020_05_31Request.h>
#include <aws/cloudfront/model/ListStreamingDistributions2020_05_31Result.h>
#include <aws/cloudfront/model/ListTagsForResource2020_05_31Request.h>
#include <aws/cloudfront/model/ListTagsForResource2020_05_31Result.h>
#include <aws/cloudfront/model/ListVpcOrigins2020_05_31Request.h>
#include <aws/cloudfront/model/ListVpcOrigins2020_05_31Result.h>
#include <aws/cloudfront/model/LoggingConfig.h>
#include <aws/cloudfront/model/ManagedCertificateDetails.h>
#include <aws/cloudfront/model/ManagedCertificateRequest.h>
#include <aws/cloudfront/model/ManagedCertificateStatus.h>
#include <aws/cloudfront/model/Method.h>
#include <aws/cloudfront/model/MinimumProtocolVersion.h>
#include <aws/cloudfront/model/MonitoringSubscription.h>
#include <aws/cloudfront/model/Origin.h>
#include <aws/cloudfront/model/OriginAccessControl.h>
#include <aws/cloudfront/model/OriginAccessControlConfig.h>
#include <aws/cloudfront/model/OriginAccessControlList.h>
#include <aws/cloudfront/model/OriginAccessControlOriginTypes.h>
#include <aws/cloudfront/model/OriginAccessControlSigningBehaviors.h>
#include <aws/cloudfront/model/OriginAccessControlSigningProtocols.h>
#include <aws/cloudfront/model/OriginAccessControlSummary.h>
#include <aws/cloudfront/model/OriginCustomHeader.h>
#include <aws/cloudfront/model/OriginGroup.h>
#include <aws/cloudfront/model/OriginGroupFailoverCriteria.h>
#include <aws/cloudfront/model/OriginGroupMember.h>
#include <aws/cloudfront/model/OriginGroupMembers.h>
#include <aws/cloudfront/model/OriginGroupSelectionCriteria.h>
#include <aws/cloudfront/model/OriginGroups.h>
#include <aws/cloudfront/model/OriginProtocolPolicy.h>
#include <aws/cloudfront/model/OriginRequestPolicy.h>
#include <aws/cloudfront/model/OriginRequestPolicyConfig.h>
#include <aws/cloudfront/model/OriginRequestPolicyCookieBehavior.h>
#include <aws/cloudfront/model/OriginRequestPolicyCookiesConfig.h>
#include <aws/cloudfront/model/OriginRequestPolicyHeaderBehavior.h>
#include <aws/cloudfront/model/OriginRequestPolicyHeadersConfig.h>
#include <aws/cloudfront/model/OriginRequestPolicyList.h>
#include <aws/cloudfront/model/OriginRequestPolicyQueryStringBehavior.h>
#include <aws/cloudfront/model/OriginRequestPolicyQueryStringsConfig.h>
#include <aws/cloudfront/model/OriginRequestPolicySummary.h>
#include <aws/cloudfront/model/OriginRequestPolicyType.h>
#include <aws/cloudfront/model/OriginShield.h>
#include <aws/cloudfront/model/OriginSslProtocols.h>
#include <aws/cloudfront/model/Origins.h>
#include <aws/cloudfront/model/Parameter.h>
#include <aws/cloudfront/model/ParameterDefinition.h>
#include <aws/cloudfront/model/ParameterDefinitionSchema.h>
#include <aws/cloudfront/model/ParametersInCacheKeyAndForwardedToOrigin.h>
#include <aws/cloudfront/model/Paths.h>
#include <aws/cloudfront/model/PriceClass.h>
#include <aws/cloudfront/model/PublicKey.h>
#include <aws/cloudfront/model/PublicKeyConfig.h>
#include <aws/cloudfront/model/PublicKeyList.h>
#include <aws/cloudfront/model/PublicKeySummary.h>
#include <aws/cloudfront/model/PublishFunction2020_05_31Request.h>
#include <aws/cloudfront/model/PublishFunction2020_05_31Result.h>
#include <aws/cloudfront/model/QueryArgProfile.h>
#include <aws/cloudfront/model/QueryArgProfileConfig.h>
#include <aws/cloudfront/model/QueryArgProfiles.h>
#include <aws/cloudfront/model/QueryStringCacheKeys.h>
#include <aws/cloudfront/model/QueryStringNames.h>
#include <aws/cloudfront/model/RealtimeLogConfig.h>
#include <aws/cloudfront/model/RealtimeLogConfigs.h>
#include <aws/cloudfront/model/RealtimeMetricsSubscriptionConfig.h>
#include <aws/cloudfront/model/RealtimeMetricsSubscriptionStatus.h>
#include <aws/cloudfront/model/ReferrerPolicyList.h>
#include <aws/cloudfront/model/ResponseHeadersPolicy.h>
#include <aws/cloudfront/model/ResponseHeadersPolicyAccessControlAllowHeaders.h>
#include <aws/cloudfront/model/ResponseHeadersPolicyAccessControlAllowMethods.h>
#include <aws/cloudfront/model/ResponseHeadersPolicyAccessControlAllowMethodsValues.h>
#include <aws/cloudfront/model/ResponseHeadersPolicyAccessControlAllowOrigins.h>
#include <aws/cloudfront/model/ResponseHeadersPolicyAccessControlExposeHeaders.h>
#include <aws/cloudfront/model/ResponseHeadersPolicyConfig.h>
#include <aws/cloudfront/model/ResponseHeadersPolicyContentSecurityPolicy.h>
#include <aws/cloudfront/model/ResponseHeadersPolicyContentTypeOptions.h>
#include <aws/cloudfront/model/ResponseHeadersPolicyCorsConfig.h>
#include <aws/cloudfront/model/ResponseHeadersPolicyCustomHeader.h>
#include <aws/cloudfront/model/ResponseHeadersPolicyCustomHeadersConfig.h>
#include <aws/cloudfront/model/ResponseHeadersPolicyFrameOptions.h>
#include <aws/cloudfront/model/ResponseHeadersPolicyList.h>
#include <aws/cloudfront/model/ResponseHeadersPolicyReferrerPolicy.h>
#include <aws/cloudfront/model/ResponseHeadersPolicyRemoveHeader.h>
#include <aws/cloudfront/model/ResponseHeadersPolicyRemoveHeadersConfig.h>
#include <aws/cloudfront/model/ResponseHeadersPolicySecurityHeadersConfig.h>
#include <aws/cloudfront/model/ResponseHeadersPolicyServerTimingHeadersConfig.h>
#include <aws/cloudfront/model/ResponseHeadersPolicyStrictTransportSecurity.h>
#include <aws/cloudfront/model/ResponseHeadersPolicySummary.h>
#include <aws/cloudfront/model/ResponseHeadersPolicyType.h>
#include <aws/cloudfront/model/ResponseHeadersPolicyXSSProtection.h>
#include <aws/cloudfront/model/Restrictions.h>
#include <aws/cloudfront/model/S3Origin.h>
#include <aws/cloudfront/model/S3OriginConfig.h>
#include <aws/cloudfront/model/SSLSupportMethod.h>
#include <aws/cloudfront/model/SessionStickinessConfig.h>
#include <aws/cloudfront/model/Signer.h>
#include <aws/cloudfront/model/SslProtocol.h>
#include <aws/cloudfront/model/StagingDistributionDnsNames.h>
#include <aws/cloudfront/model/StatusCodes.h>
#include <aws/cloudfront/model/StreamingDistribution.h>
#include <aws/cloudfront/model/StreamingDistributionConfig.h>
#include <aws/cloudfront/model/StreamingDistributionConfigWithTags.h>
#include <aws/cloudfront/model/StreamingDistributionList.h>
#include <aws/cloudfront/model/StreamingDistributionSummary.h>
#include <aws/cloudfront/model/StreamingLoggingConfig.h>
#include <aws/cloudfront/model/StringSchemaConfig.h>
#include <aws/cloudfront/model/Tag.h>
#include <aws/cloudfront/model/TagKeys.h>
#include <aws/cloudfront/model/TagResource2020_05_31Request.h>
#include <aws/cloudfront/model/Tags.h>
#include <aws/cloudfront/model/TenantConfig.h>
#include <aws/cloudfront/model/TestFunction2020_05_31Request.h>
#include <aws/cloudfront/model/TestFunction2020_05_31Result.h>
#include <aws/cloudfront/model/TestResult.h>
#include <aws/cloudfront/model/TrafficConfig.h>
#include <aws/cloudfront/model/TrustedKeyGroups.h>
#include <aws/cloudfront/model/TrustedSigners.h>
#include <aws/cloudfront/model/UntagResource2020_05_31Request.h>
#include <aws/cloudfront/model/UpdateCachePolicy2020_05_31Request.h>
#include <aws/cloudfront/model/UpdateCachePolicy2020_05_31Result.h>
#include <aws/cloudfront/model/UpdateCloudFrontOriginAccessIdentity2020_05_31Request.h>
#include <aws/cloudfront/model/UpdateCloudFrontOriginAccessIdentity2020_05_31Result.h>
#include <aws/cloudfront/model/UpdateConnectionGroup2020_05_31Request.h>
#include <aws/cloudfront/model/UpdateConnectionGroup2020_05_31Result.h>
#include <aws/cloudfront/model/UpdateContinuousDeploymentPolicy2020_05_31Request.h>
#include <aws/cloudfront/model/UpdateContinuousDeploymentPolicy2020_05_31Result.h>
#include <aws/cloudfront/model/UpdateDistribution2020_05_31Request.h>
#include <aws/cloudfront/model/UpdateDistribution2020_05_31Result.h>
#include <aws/cloudfront/model/UpdateDistributionTenant2020_05_31Request.h>
#include <aws/cloudfront/model/UpdateDistributionTenant2020_05_31Result.h>
#include <aws/cloudfront/model/UpdateDistributionWithStagingConfig2020_05_31Request.h>
#include <aws/cloudfront/model/UpdateDistributionWithStagingConfig2020_05_31Result.h>
#include <aws/cloudfront/model/UpdateDomainAssociation2020_05_31Request.h>
#include <aws/cloudfront/model/UpdateDomainAssociation2020_05_31Result.h>
#include <aws/cloudfront/model/UpdateFieldLevelEncryptionConfig2020_05_31Request.h>
#include <aws/cloudfront/model/UpdateFieldLevelEncryptionConfig2020_05_31Result.h>
#include <aws/cloudfront/model/UpdateFieldLevelEncryptionProfile2020_05_31Request.h>
#include <aws/cloudfront/model/UpdateFieldLevelEncryptionProfile2020_05_31Result.h>
#include <aws/cloudfront/model/UpdateFunction2020_05_31Request.h>
#include <aws/cloudfront/model/UpdateFunction2020_05_31Result.h>
#include <aws/cloudfront/model/UpdateKeyGroup2020_05_31Request.h>
#include <aws/cloudfront/model/UpdateKeyGroup2020_05_31Result.h>
#include <aws/cloudfront/model/UpdateKeyValueStore2020_05_31Request.h>
#include <aws/cloudfront/model/UpdateKeyValueStore2020_05_31Result.h>
#include <aws/cloudfront/model/UpdateOriginAccessControl2020_05_31Request.h>
#include <aws/cloudfront/model/UpdateOriginAccessControl2020_05_31Result.h>
#include <aws/cloudfront/model/UpdateOriginRequestPolicy2020_05_31Request.h>
#include <aws/cloudfront/model/UpdateOriginRequestPolicy2020_05_31Result.h>
#include <aws/cloudfront/model/UpdatePublicKey2020_05_31Request.h>
#include <aws/cloudfront/model/UpdatePublicKey2020_05_31Result.h>
#include <aws/cloudfront/model/UpdateRealtimeLogConfig2020_05_31Request.h>
#include <aws/cloudfront/model/UpdateRealtimeLogConfig2020_05_31Result.h>
#include <aws/cloudfront/model/UpdateResponseHeadersPolicy2020_05_31Request.h>
#include <aws/cloudfront/model/UpdateResponseHeadersPolicy2020_05_31Result.h>
#include <aws/cloudfront/model/UpdateStreamingDistribution2020_05_31Request.h>
#include <aws/cloudfront/model/UpdateStreamingDistribution2020_05_31Result.h>
#include <aws/cloudfront/model/UpdateVpcOrigin2020_05_31Request.h>
#include <aws/cloudfront/model/UpdateVpcOrigin2020_05_31Result.h>
#include <aws/cloudfront/model/ValidationTokenDetail.h>
#include <aws/cloudfront/model/ValidationTokenHost.h>
#include <aws/cloudfront/model/VerifyDnsConfiguration2020_05_31Request.h>
#include <aws/cloudfront/model/VerifyDnsConfiguration2020_05_31Result.h>
#include <aws/cloudfront/model/ViewerCertificate.h>
#include <aws/cloudfront/model/ViewerProtocolPolicy.h>
#include <aws/cloudfront/model/VpcOrigin.h>
#include <aws/cloudfront/model/VpcOriginConfig.h>
#include <aws/cloudfront/model/VpcOriginEndpointConfig.h>
#include <aws/cloudfront/model/VpcOriginList.h>
#include <aws/cloudfront/model/VpcOriginSummary.h>
#include <aws/cloudfront/model/WebAclCustomization.h>

using CloudFrontIncludeTest = ::testing::Test;

TEST_F(CloudFrontIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::CloudFront::CloudFrontClient>("CloudFrontIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
