/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/cloudtrail/CloudTrailClient.h>
#include <aws/cloudtrail/CloudTrailEndpointProvider.h>
#include <aws/cloudtrail/CloudTrailEndpointRules.h>
#include <aws/cloudtrail/CloudTrailErrorMarshaller.h>
#include <aws/cloudtrail/CloudTrailErrors.h>
#include <aws/cloudtrail/CloudTrailRequest.h>
#include <aws/cloudtrail/CloudTrailServiceClientModel.h>
#include <aws/cloudtrail/CloudTrail_EXPORTS.h>
#include <aws/cloudtrail/model/AddTagsRequest.h>
#include <aws/cloudtrail/model/AddTagsResult.h>
#include <aws/cloudtrail/model/AdvancedEventSelector.h>
#include <aws/cloudtrail/model/AdvancedFieldSelector.h>
#include <aws/cloudtrail/model/BillingMode.h>
#include <aws/cloudtrail/model/CancelQueryRequest.h>
#include <aws/cloudtrail/model/CancelQueryResult.h>
#include <aws/cloudtrail/model/Channel.h>
#include <aws/cloudtrail/model/ContextKeySelector.h>
#include <aws/cloudtrail/model/CreateChannelRequest.h>
#include <aws/cloudtrail/model/CreateChannelResult.h>
#include <aws/cloudtrail/model/CreateDashboardRequest.h>
#include <aws/cloudtrail/model/CreateDashboardResult.h>
#include <aws/cloudtrail/model/CreateEventDataStoreRequest.h>
#include <aws/cloudtrail/model/CreateEventDataStoreResult.h>
#include <aws/cloudtrail/model/CreateTrailRequest.h>
#include <aws/cloudtrail/model/CreateTrailResult.h>
#include <aws/cloudtrail/model/DashboardDetail.h>
#include <aws/cloudtrail/model/DashboardStatus.h>
#include <aws/cloudtrail/model/DashboardType.h>
#include <aws/cloudtrail/model/DataResource.h>
#include <aws/cloudtrail/model/DeleteChannelRequest.h>
#include <aws/cloudtrail/model/DeleteChannelResult.h>
#include <aws/cloudtrail/model/DeleteDashboardRequest.h>
#include <aws/cloudtrail/model/DeleteDashboardResult.h>
#include <aws/cloudtrail/model/DeleteEventDataStoreRequest.h>
#include <aws/cloudtrail/model/DeleteEventDataStoreResult.h>
#include <aws/cloudtrail/model/DeleteResourcePolicyRequest.h>
#include <aws/cloudtrail/model/DeleteResourcePolicyResult.h>
#include <aws/cloudtrail/model/DeleteTrailRequest.h>
#include <aws/cloudtrail/model/DeleteTrailResult.h>
#include <aws/cloudtrail/model/DeliveryStatus.h>
#include <aws/cloudtrail/model/DeregisterOrganizationDelegatedAdminRequest.h>
#include <aws/cloudtrail/model/DeregisterOrganizationDelegatedAdminResult.h>
#include <aws/cloudtrail/model/DescribeQueryRequest.h>
#include <aws/cloudtrail/model/DescribeQueryResult.h>
#include <aws/cloudtrail/model/DescribeTrailsRequest.h>
#include <aws/cloudtrail/model/DescribeTrailsResult.h>
#include <aws/cloudtrail/model/Destination.h>
#include <aws/cloudtrail/model/DestinationType.h>
#include <aws/cloudtrail/model/DisableFederationRequest.h>
#include <aws/cloudtrail/model/DisableFederationResult.h>
#include <aws/cloudtrail/model/EnableFederationRequest.h>
#include <aws/cloudtrail/model/EnableFederationResult.h>
#include <aws/cloudtrail/model/Event.h>
#include <aws/cloudtrail/model/EventCategory.h>
#include <aws/cloudtrail/model/EventDataStore.h>
#include <aws/cloudtrail/model/EventDataStoreStatus.h>
#include <aws/cloudtrail/model/EventSelector.h>
#include <aws/cloudtrail/model/FederationStatus.h>
#include <aws/cloudtrail/model/GenerateQueryRequest.h>
#include <aws/cloudtrail/model/GenerateQueryResult.h>
#include <aws/cloudtrail/model/GetChannelRequest.h>
#include <aws/cloudtrail/model/GetChannelResult.h>
#include <aws/cloudtrail/model/GetDashboardRequest.h>
#include <aws/cloudtrail/model/GetDashboardResult.h>
#include <aws/cloudtrail/model/GetEventConfigurationRequest.h>
#include <aws/cloudtrail/model/GetEventConfigurationResult.h>
#include <aws/cloudtrail/model/GetEventDataStoreRequest.h>
#include <aws/cloudtrail/model/GetEventDataStoreResult.h>
#include <aws/cloudtrail/model/GetEventSelectorsRequest.h>
#include <aws/cloudtrail/model/GetEventSelectorsResult.h>
#include <aws/cloudtrail/model/GetImportRequest.h>
#include <aws/cloudtrail/model/GetImportResult.h>
#include <aws/cloudtrail/model/GetInsightSelectorsRequest.h>
#include <aws/cloudtrail/model/GetInsightSelectorsResult.h>
#include <aws/cloudtrail/model/GetQueryResultsRequest.h>
#include <aws/cloudtrail/model/GetQueryResultsResult.h>
#include <aws/cloudtrail/model/GetResourcePolicyRequest.h>
#include <aws/cloudtrail/model/GetResourcePolicyResult.h>
#include <aws/cloudtrail/model/GetTrailRequest.h>
#include <aws/cloudtrail/model/GetTrailResult.h>
#include <aws/cloudtrail/model/GetTrailStatusRequest.h>
#include <aws/cloudtrail/model/GetTrailStatusResult.h>
#include <aws/cloudtrail/model/ImportFailureListItem.h>
#include <aws/cloudtrail/model/ImportFailureStatus.h>
#include <aws/cloudtrail/model/ImportSource.h>
#include <aws/cloudtrail/model/ImportStatistics.h>
#include <aws/cloudtrail/model/ImportStatus.h>
#include <aws/cloudtrail/model/ImportsListItem.h>
#include <aws/cloudtrail/model/IngestionStatus.h>
#include <aws/cloudtrail/model/InsightSelector.h>
#include <aws/cloudtrail/model/InsightType.h>
#include <aws/cloudtrail/model/InsightsMetricDataType.h>
#include <aws/cloudtrail/model/ListChannelsRequest.h>
#include <aws/cloudtrail/model/ListChannelsResult.h>
#include <aws/cloudtrail/model/ListDashboardsRequest.h>
#include <aws/cloudtrail/model/ListDashboardsResult.h>
#include <aws/cloudtrail/model/ListEventDataStoresRequest.h>
#include <aws/cloudtrail/model/ListEventDataStoresResult.h>
#include <aws/cloudtrail/model/ListImportFailuresRequest.h>
#include <aws/cloudtrail/model/ListImportFailuresResult.h>
#include <aws/cloudtrail/model/ListImportsRequest.h>
#include <aws/cloudtrail/model/ListImportsResult.h>
#include <aws/cloudtrail/model/ListInsightsMetricDataRequest.h>
#include <aws/cloudtrail/model/ListInsightsMetricDataResult.h>
#include <aws/cloudtrail/model/ListPublicKeysRequest.h>
#include <aws/cloudtrail/model/ListPublicKeysResult.h>
#include <aws/cloudtrail/model/ListQueriesRequest.h>
#include <aws/cloudtrail/model/ListQueriesResult.h>
#include <aws/cloudtrail/model/ListTagsRequest.h>
#include <aws/cloudtrail/model/ListTagsResult.h>
#include <aws/cloudtrail/model/ListTrailsRequest.h>
#include <aws/cloudtrail/model/ListTrailsResult.h>
#include <aws/cloudtrail/model/LookupAttribute.h>
#include <aws/cloudtrail/model/LookupAttributeKey.h>
#include <aws/cloudtrail/model/LookupEventsRequest.h>
#include <aws/cloudtrail/model/LookupEventsResult.h>
#include <aws/cloudtrail/model/MaxEventSize.h>
#include <aws/cloudtrail/model/PartitionKey.h>
#include <aws/cloudtrail/model/PublicKey.h>
#include <aws/cloudtrail/model/PutEventConfigurationRequest.h>
#include <aws/cloudtrail/model/PutEventConfigurationResult.h>
#include <aws/cloudtrail/model/PutEventSelectorsRequest.h>
#include <aws/cloudtrail/model/PutEventSelectorsResult.h>
#include <aws/cloudtrail/model/PutInsightSelectorsRequest.h>
#include <aws/cloudtrail/model/PutInsightSelectorsResult.h>
#include <aws/cloudtrail/model/PutResourcePolicyRequest.h>
#include <aws/cloudtrail/model/PutResourcePolicyResult.h>
#include <aws/cloudtrail/model/Query.h>
#include <aws/cloudtrail/model/QueryStatistics.h>
#include <aws/cloudtrail/model/QueryStatisticsForDescribeQuery.h>
#include <aws/cloudtrail/model/QueryStatus.h>
#include <aws/cloudtrail/model/ReadWriteType.h>
#include <aws/cloudtrail/model/RefreshSchedule.h>
#include <aws/cloudtrail/model/RefreshScheduleFrequency.h>
#include <aws/cloudtrail/model/RefreshScheduleFrequencyUnit.h>
#include <aws/cloudtrail/model/RefreshScheduleStatus.h>
#include <aws/cloudtrail/model/RegisterOrganizationDelegatedAdminRequest.h>
#include <aws/cloudtrail/model/RegisterOrganizationDelegatedAdminResult.h>
#include <aws/cloudtrail/model/RemoveTagsRequest.h>
#include <aws/cloudtrail/model/RemoveTagsResult.h>
#include <aws/cloudtrail/model/RequestWidget.h>
#include <aws/cloudtrail/model/Resource.h>
#include <aws/cloudtrail/model/ResourceTag.h>
#include <aws/cloudtrail/model/RestoreEventDataStoreRequest.h>
#include <aws/cloudtrail/model/RestoreEventDataStoreResult.h>
#include <aws/cloudtrail/model/S3ImportSource.h>
#include <aws/cloudtrail/model/SearchSampleQueriesRequest.h>
#include <aws/cloudtrail/model/SearchSampleQueriesResult.h>
#include <aws/cloudtrail/model/SearchSampleQueriesSearchResult.h>
#include <aws/cloudtrail/model/SourceConfig.h>
#include <aws/cloudtrail/model/StartDashboardRefreshRequest.h>
#include <aws/cloudtrail/model/StartDashboardRefreshResult.h>
#include <aws/cloudtrail/model/StartEventDataStoreIngestionRequest.h>
#include <aws/cloudtrail/model/StartEventDataStoreIngestionResult.h>
#include <aws/cloudtrail/model/StartImportRequest.h>
#include <aws/cloudtrail/model/StartImportResult.h>
#include <aws/cloudtrail/model/StartLoggingRequest.h>
#include <aws/cloudtrail/model/StartLoggingResult.h>
#include <aws/cloudtrail/model/StartQueryRequest.h>
#include <aws/cloudtrail/model/StartQueryResult.h>
#include <aws/cloudtrail/model/StopEventDataStoreIngestionRequest.h>
#include <aws/cloudtrail/model/StopEventDataStoreIngestionResult.h>
#include <aws/cloudtrail/model/StopImportRequest.h>
#include <aws/cloudtrail/model/StopImportResult.h>
#include <aws/cloudtrail/model/StopLoggingRequest.h>
#include <aws/cloudtrail/model/StopLoggingResult.h>
#include <aws/cloudtrail/model/Tag.h>
#include <aws/cloudtrail/model/Trail.h>
#include <aws/cloudtrail/model/TrailInfo.h>
#include <aws/cloudtrail/model/Type.h>
#include <aws/cloudtrail/model/UpdateChannelRequest.h>
#include <aws/cloudtrail/model/UpdateChannelResult.h>
#include <aws/cloudtrail/model/UpdateDashboardRequest.h>
#include <aws/cloudtrail/model/UpdateDashboardResult.h>
#include <aws/cloudtrail/model/UpdateEventDataStoreRequest.h>
#include <aws/cloudtrail/model/UpdateEventDataStoreResult.h>
#include <aws/cloudtrail/model/UpdateTrailRequest.h>
#include <aws/cloudtrail/model/UpdateTrailResult.h>
#include <aws/cloudtrail/model/Widget.h>

using CloudTrailIncludeTest = ::testing::Test;

TEST_F(CloudTrailIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::CloudTrail::CloudTrailClient>("CloudTrailIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
