/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/codebuild/CodeBuildClient.h>
#include <aws/codebuild/CodeBuildEndpointProvider.h>
#include <aws/codebuild/CodeBuildEndpointRules.h>
#include <aws/codebuild/CodeBuildErrorMarshaller.h>
#include <aws/codebuild/CodeBuildErrors.h>
#include <aws/codebuild/CodeBuildRequest.h>
#include <aws/codebuild/CodeBuildServiceClientModel.h>
#include <aws/codebuild/CodeBuild_EXPORTS.h>
#include <aws/codebuild/model/ArtifactNamespace.h>
#include <aws/codebuild/model/ArtifactPackaging.h>
#include <aws/codebuild/model/ArtifactsType.h>
#include <aws/codebuild/model/AuthType.h>
#include <aws/codebuild/model/AutoRetryConfig.h>
#include <aws/codebuild/model/BatchDeleteBuildsRequest.h>
#include <aws/codebuild/model/BatchDeleteBuildsResult.h>
#include <aws/codebuild/model/BatchGetBuildBatchesRequest.h>
#include <aws/codebuild/model/BatchGetBuildBatchesResult.h>
#include <aws/codebuild/model/BatchGetBuildsRequest.h>
#include <aws/codebuild/model/BatchGetBuildsResult.h>
#include <aws/codebuild/model/BatchGetCommandExecutionsRequest.h>
#include <aws/codebuild/model/BatchGetCommandExecutionsResult.h>
#include <aws/codebuild/model/BatchGetFleetsRequest.h>
#include <aws/codebuild/model/BatchGetFleetsResult.h>
#include <aws/codebuild/model/BatchGetProjectsRequest.h>
#include <aws/codebuild/model/BatchGetProjectsResult.h>
#include <aws/codebuild/model/BatchGetReportGroupsRequest.h>
#include <aws/codebuild/model/BatchGetReportGroupsResult.h>
#include <aws/codebuild/model/BatchGetReportsRequest.h>
#include <aws/codebuild/model/BatchGetReportsResult.h>
#include <aws/codebuild/model/BatchGetSandboxesRequest.h>
#include <aws/codebuild/model/BatchGetSandboxesResult.h>
#include <aws/codebuild/model/BatchReportModeType.h>
#include <aws/codebuild/model/BatchRestrictions.h>
#include <aws/codebuild/model/BucketOwnerAccess.h>
#include <aws/codebuild/model/Build.h>
#include <aws/codebuild/model/BuildArtifacts.h>
#include <aws/codebuild/model/BuildBatch.h>
#include <aws/codebuild/model/BuildBatchFilter.h>
#include <aws/codebuild/model/BuildBatchPhase.h>
#include <aws/codebuild/model/BuildBatchPhaseType.h>
#include <aws/codebuild/model/BuildGroup.h>
#include <aws/codebuild/model/BuildNotDeleted.h>
#include <aws/codebuild/model/BuildPhase.h>
#include <aws/codebuild/model/BuildPhaseType.h>
#include <aws/codebuild/model/BuildStatusConfig.h>
#include <aws/codebuild/model/BuildSummary.h>
#include <aws/codebuild/model/CacheMode.h>
#include <aws/codebuild/model/CacheType.h>
#include <aws/codebuild/model/CloudWatchLogsConfig.h>
#include <aws/codebuild/model/CodeCoverage.h>
#include <aws/codebuild/model/CodeCoverageReportSummary.h>
#include <aws/codebuild/model/CommandExecution.h>
#include <aws/codebuild/model/CommandType.h>
#include <aws/codebuild/model/ComputeConfiguration.h>
#include <aws/codebuild/model/ComputeType.h>
#include <aws/codebuild/model/CreateFleetRequest.h>
#include <aws/codebuild/model/CreateFleetResult.h>
#include <aws/codebuild/model/CreateProjectRequest.h>
#include <aws/codebuild/model/CreateProjectResult.h>
#include <aws/codebuild/model/CreateReportGroupRequest.h>
#include <aws/codebuild/model/CreateReportGroupResult.h>
#include <aws/codebuild/model/CreateWebhookRequest.h>
#include <aws/codebuild/model/CreateWebhookResult.h>
#include <aws/codebuild/model/CredentialProviderType.h>
#include <aws/codebuild/model/DebugSession.h>
#include <aws/codebuild/model/DeleteBuildBatchRequest.h>
#include <aws/codebuild/model/DeleteBuildBatchResult.h>
#include <aws/codebuild/model/DeleteFleetRequest.h>
#include <aws/codebuild/model/DeleteFleetResult.h>
#include <aws/codebuild/model/DeleteProjectRequest.h>
#include <aws/codebuild/model/DeleteProjectResult.h>
#include <aws/codebuild/model/DeleteReportGroupRequest.h>
#include <aws/codebuild/model/DeleteReportGroupResult.h>
#include <aws/codebuild/model/DeleteReportRequest.h>
#include <aws/codebuild/model/DeleteReportResult.h>
#include <aws/codebuild/model/DeleteResourcePolicyRequest.h>
#include <aws/codebuild/model/DeleteResourcePolicyResult.h>
#include <aws/codebuild/model/DeleteSourceCredentialsRequest.h>
#include <aws/codebuild/model/DeleteSourceCredentialsResult.h>
#include <aws/codebuild/model/DeleteWebhookRequest.h>
#include <aws/codebuild/model/DeleteWebhookResult.h>
#include <aws/codebuild/model/DescribeCodeCoveragesRequest.h>
#include <aws/codebuild/model/DescribeCodeCoveragesResult.h>
#include <aws/codebuild/model/DescribeTestCasesRequest.h>
#include <aws/codebuild/model/DescribeTestCasesResult.h>
#include <aws/codebuild/model/DockerServer.h>
#include <aws/codebuild/model/DockerServerStatus.h>
#include <aws/codebuild/model/EnvironmentImage.h>
#include <aws/codebuild/model/EnvironmentLanguage.h>
#include <aws/codebuild/model/EnvironmentPlatform.h>
#include <aws/codebuild/model/EnvironmentType.h>
#include <aws/codebuild/model/EnvironmentVariable.h>
#include <aws/codebuild/model/EnvironmentVariableType.h>
#include <aws/codebuild/model/ExportedEnvironmentVariable.h>
#include <aws/codebuild/model/FileSystemType.h>
#include <aws/codebuild/model/Fleet.h>
#include <aws/codebuild/model/FleetContextCode.h>
#include <aws/codebuild/model/FleetOverflowBehavior.h>
#include <aws/codebuild/model/FleetProxyRule.h>
#include <aws/codebuild/model/FleetProxyRuleBehavior.h>
#include <aws/codebuild/model/FleetProxyRuleEffectType.h>
#include <aws/codebuild/model/FleetProxyRuleType.h>
#include <aws/codebuild/model/FleetScalingMetricType.h>
#include <aws/codebuild/model/FleetScalingType.h>
#include <aws/codebuild/model/FleetSortByType.h>
#include <aws/codebuild/model/FleetStatus.h>
#include <aws/codebuild/model/FleetStatusCode.h>
#include <aws/codebuild/model/GetReportGroupTrendRequest.h>
#include <aws/codebuild/model/GetReportGroupTrendResult.h>
#include <aws/codebuild/model/GetResourcePolicyRequest.h>
#include <aws/codebuild/model/GetResourcePolicyResult.h>
#include <aws/codebuild/model/GitSubmodulesConfig.h>
#include <aws/codebuild/model/ImagePullCredentialsType.h>
#include <aws/codebuild/model/ImportSourceCredentialsRequest.h>
#include <aws/codebuild/model/ImportSourceCredentialsResult.h>
#include <aws/codebuild/model/InvalidateProjectCacheRequest.h>
#include <aws/codebuild/model/InvalidateProjectCacheResult.h>
#include <aws/codebuild/model/LanguageType.h>
#include <aws/codebuild/model/ListBuildBatchesForProjectRequest.h>
#include <aws/codebuild/model/ListBuildBatchesForProjectResult.h>
#include <aws/codebuild/model/ListBuildBatchesRequest.h>
#include <aws/codebuild/model/ListBuildBatchesResult.h>
#include <aws/codebuild/model/ListBuildsForProjectRequest.h>
#include <aws/codebuild/model/ListBuildsForProjectResult.h>
#include <aws/codebuild/model/ListBuildsRequest.h>
#include <aws/codebuild/model/ListBuildsResult.h>
#include <aws/codebuild/model/ListCommandExecutionsForSandboxRequest.h>
#include <aws/codebuild/model/ListCommandExecutionsForSandboxResult.h>
#include <aws/codebuild/model/ListCuratedEnvironmentImagesRequest.h>
#include <aws/codebuild/model/ListCuratedEnvironmentImagesResult.h>
#include <aws/codebuild/model/ListFleetsRequest.h>
#include <aws/codebuild/model/ListFleetsResult.h>
#include <aws/codebuild/model/ListProjectsRequest.h>
#include <aws/codebuild/model/ListProjectsResult.h>
#include <aws/codebuild/model/ListReportGroupsRequest.h>
#include <aws/codebuild/model/ListReportGroupsResult.h>
#include <aws/codebuild/model/ListReportsForReportGroupRequest.h>
#include <aws/codebuild/model/ListReportsForReportGroupResult.h>
#include <aws/codebuild/model/ListReportsRequest.h>
#include <aws/codebuild/model/ListReportsResult.h>
#include <aws/codebuild/model/ListSandboxesForProjectRequest.h>
#include <aws/codebuild/model/ListSandboxesForProjectResult.h>
#include <aws/codebuild/model/ListSandboxesRequest.h>
#include <aws/codebuild/model/ListSandboxesResult.h>
#include <aws/codebuild/model/ListSharedProjectsRequest.h>
#include <aws/codebuild/model/ListSharedProjectsResult.h>
#include <aws/codebuild/model/ListSharedReportGroupsRequest.h>
#include <aws/codebuild/model/ListSharedReportGroupsResult.h>
#include <aws/codebuild/model/ListSourceCredentialsRequest.h>
#include <aws/codebuild/model/ListSourceCredentialsResult.h>
#include <aws/codebuild/model/LogsConfig.h>
#include <aws/codebuild/model/LogsConfigStatusType.h>
#include <aws/codebuild/model/LogsLocation.h>
#include <aws/codebuild/model/MachineType.h>
#include <aws/codebuild/model/NetworkInterface.h>
#include <aws/codebuild/model/PhaseContext.h>
#include <aws/codebuild/model/PlatformType.h>
#include <aws/codebuild/model/Project.h>
#include <aws/codebuild/model/ProjectArtifacts.h>
#include <aws/codebuild/model/ProjectBadge.h>
#include <aws/codebuild/model/ProjectBuildBatchConfig.h>
#include <aws/codebuild/model/ProjectCache.h>
#include <aws/codebuild/model/ProjectEnvironment.h>
#include <aws/codebuild/model/ProjectFileSystemLocation.h>
#include <aws/codebuild/model/ProjectFleet.h>
#include <aws/codebuild/model/ProjectSortByType.h>
#include <aws/codebuild/model/ProjectSource.h>
#include <aws/codebuild/model/ProjectSourceVersion.h>
#include <aws/codebuild/model/ProjectVisibilityType.h>
#include <aws/codebuild/model/ProxyConfiguration.h>
#include <aws/codebuild/model/PutResourcePolicyRequest.h>
#include <aws/codebuild/model/PutResourcePolicyResult.h>
#include <aws/codebuild/model/RegistryCredential.h>
#include <aws/codebuild/model/Report.h>
#include <aws/codebuild/model/ReportCodeCoverageSortByType.h>
#include <aws/codebuild/model/ReportExportConfig.h>
#include <aws/codebuild/model/ReportExportConfigType.h>
#include <aws/codebuild/model/ReportFilter.h>
#include <aws/codebuild/model/ReportGroup.h>
#include <aws/codebuild/model/ReportGroupSortByType.h>
#include <aws/codebuild/model/ReportGroupStatusType.h>
#include <aws/codebuild/model/ReportGroupTrendFieldType.h>
#include <aws/codebuild/model/ReportGroupTrendStats.h>
#include <aws/codebuild/model/ReportPackagingType.h>
#include <aws/codebuild/model/ReportStatusType.h>
#include <aws/codebuild/model/ReportType.h>
#include <aws/codebuild/model/ReportWithRawData.h>
#include <aws/codebuild/model/ResolvedArtifact.h>
#include <aws/codebuild/model/RetryBuildBatchRequest.h>
#include <aws/codebuild/model/RetryBuildBatchResult.h>
#include <aws/codebuild/model/RetryBuildBatchType.h>
#include <aws/codebuild/model/RetryBuildRequest.h>
#include <aws/codebuild/model/RetryBuildResult.h>
#include <aws/codebuild/model/S3LogsConfig.h>
#include <aws/codebuild/model/S3ReportExportConfig.h>
#include <aws/codebuild/model/SSMSession.h>
#include <aws/codebuild/model/Sandbox.h>
#include <aws/codebuild/model/SandboxSession.h>
#include <aws/codebuild/model/SandboxSessionPhase.h>
#include <aws/codebuild/model/ScalingConfigurationInput.h>
#include <aws/codebuild/model/ScalingConfigurationOutput.h>
#include <aws/codebuild/model/ScopeConfiguration.h>
#include <aws/codebuild/model/ServerType.h>
#include <aws/codebuild/model/SharedResourceSortByType.h>
#include <aws/codebuild/model/SortOrderType.h>
#include <aws/codebuild/model/SourceAuth.h>
#include <aws/codebuild/model/SourceAuthType.h>
#include <aws/codebuild/model/SourceCredentialsInfo.h>
#include <aws/codebuild/model/SourceType.h>
#include <aws/codebuild/model/StartBuildBatchRequest.h>
#include <aws/codebuild/model/StartBuildBatchResult.h>
#include <aws/codebuild/model/StartBuildRequest.h>
#include <aws/codebuild/model/StartBuildResult.h>
#include <aws/codebuild/model/StartCommandExecutionRequest.h>
#include <aws/codebuild/model/StartCommandExecutionResult.h>
#include <aws/codebuild/model/StartSandboxConnectionRequest.h>
#include <aws/codebuild/model/StartSandboxConnectionResult.h>
#include <aws/codebuild/model/StartSandboxRequest.h>
#include <aws/codebuild/model/StartSandboxResult.h>
#include <aws/codebuild/model/StatusType.h>
#include <aws/codebuild/model/StopBuildBatchRequest.h>
#include <aws/codebuild/model/StopBuildBatchResult.h>
#include <aws/codebuild/model/StopBuildRequest.h>
#include <aws/codebuild/model/StopBuildResult.h>
#include <aws/codebuild/model/StopSandboxRequest.h>
#include <aws/codebuild/model/StopSandboxResult.h>
#include <aws/codebuild/model/Tag.h>
#include <aws/codebuild/model/TargetTrackingScalingConfiguration.h>
#include <aws/codebuild/model/TestCase.h>
#include <aws/codebuild/model/TestCaseFilter.h>
#include <aws/codebuild/model/TestReportSummary.h>
#include <aws/codebuild/model/UpdateFleetRequest.h>
#include <aws/codebuild/model/UpdateFleetResult.h>
#include <aws/codebuild/model/UpdateProjectRequest.h>
#include <aws/codebuild/model/UpdateProjectResult.h>
#include <aws/codebuild/model/UpdateProjectVisibilityRequest.h>
#include <aws/codebuild/model/UpdateProjectVisibilityResult.h>
#include <aws/codebuild/model/UpdateReportGroupRequest.h>
#include <aws/codebuild/model/UpdateReportGroupResult.h>
#include <aws/codebuild/model/UpdateWebhookRequest.h>
#include <aws/codebuild/model/UpdateWebhookResult.h>
#include <aws/codebuild/model/VpcConfig.h>
#include <aws/codebuild/model/Webhook.h>
#include <aws/codebuild/model/WebhookBuildType.h>
#include <aws/codebuild/model/WebhookFilter.h>
#include <aws/codebuild/model/WebhookFilterType.h>
#include <aws/codebuild/model/WebhookScopeType.h>
#include <aws/codebuild/model/WebhookStatus.h>

using CodeBuildIncludeTest = ::testing::Test;

TEST_F(CodeBuildIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::CodeBuild::CodeBuildClient>("CodeBuildIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
