/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/codedeploy/CodeDeployClient.h>
#include <aws/codedeploy/CodeDeployEndpointProvider.h>
#include <aws/codedeploy/CodeDeployEndpointRules.h>
#include <aws/codedeploy/CodeDeployErrorMarshaller.h>
#include <aws/codedeploy/CodeDeployErrors.h>
#include <aws/codedeploy/CodeDeployRequest.h>
#include <aws/codedeploy/CodeDeployServiceClientModel.h>
#include <aws/codedeploy/CodeDeploy_EXPORTS.h>
#include <aws/codedeploy/model/AddTagsToOnPremisesInstancesRequest.h>
#include <aws/codedeploy/model/Alarm.h>
#include <aws/codedeploy/model/AlarmConfiguration.h>
#include <aws/codedeploy/model/AppSpecContent.h>
#include <aws/codedeploy/model/ApplicationInfo.h>
#include <aws/codedeploy/model/ApplicationRevisionSortBy.h>
#include <aws/codedeploy/model/AutoRollbackConfiguration.h>
#include <aws/codedeploy/model/AutoRollbackEvent.h>
#include <aws/codedeploy/model/AutoScalingGroup.h>
#include <aws/codedeploy/model/BatchGetApplicationRevisionsRequest.h>
#include <aws/codedeploy/model/BatchGetApplicationRevisionsResult.h>
#include <aws/codedeploy/model/BatchGetApplicationsRequest.h>
#include <aws/codedeploy/model/BatchGetApplicationsResult.h>
#include <aws/codedeploy/model/BatchGetDeploymentGroupsRequest.h>
#include <aws/codedeploy/model/BatchGetDeploymentGroupsResult.h>
#include <aws/codedeploy/model/BatchGetDeploymentTargetsRequest.h>
#include <aws/codedeploy/model/BatchGetDeploymentTargetsResult.h>
#include <aws/codedeploy/model/BatchGetDeploymentsRequest.h>
#include <aws/codedeploy/model/BatchGetDeploymentsResult.h>
#include <aws/codedeploy/model/BatchGetOnPremisesInstancesRequest.h>
#include <aws/codedeploy/model/BatchGetOnPremisesInstancesResult.h>
#include <aws/codedeploy/model/BlueGreenDeploymentConfiguration.h>
#include <aws/codedeploy/model/BlueInstanceTerminationOption.h>
#include <aws/codedeploy/model/BundleType.h>
#include <aws/codedeploy/model/CloudFormationTarget.h>
#include <aws/codedeploy/model/ComputePlatform.h>
#include <aws/codedeploy/model/ContinueDeploymentRequest.h>
#include <aws/codedeploy/model/CreateApplicationRequest.h>
#include <aws/codedeploy/model/CreateApplicationResult.h>
#include <aws/codedeploy/model/CreateDeploymentConfigRequest.h>
#include <aws/codedeploy/model/CreateDeploymentConfigResult.h>
#include <aws/codedeploy/model/CreateDeploymentGroupRequest.h>
#include <aws/codedeploy/model/CreateDeploymentGroupResult.h>
#include <aws/codedeploy/model/CreateDeploymentRequest.h>
#include <aws/codedeploy/model/CreateDeploymentResult.h>
#include <aws/codedeploy/model/DeleteApplicationRequest.h>
#include <aws/codedeploy/model/DeleteDeploymentConfigRequest.h>
#include <aws/codedeploy/model/DeleteDeploymentGroupRequest.h>
#include <aws/codedeploy/model/DeleteDeploymentGroupResult.h>
#include <aws/codedeploy/model/DeleteGitHubAccountTokenRequest.h>
#include <aws/codedeploy/model/DeleteGitHubAccountTokenResult.h>
#include <aws/codedeploy/model/DeleteResourcesByExternalIdRequest.h>
#include <aws/codedeploy/model/DeleteResourcesByExternalIdResult.h>
#include <aws/codedeploy/model/DeploymentConfigInfo.h>
#include <aws/codedeploy/model/DeploymentCreator.h>
#include <aws/codedeploy/model/DeploymentGroupInfo.h>
#include <aws/codedeploy/model/DeploymentInfo.h>
#include <aws/codedeploy/model/DeploymentOption.h>
#include <aws/codedeploy/model/DeploymentOverview.h>
#include <aws/codedeploy/model/DeploymentReadyAction.h>
#include <aws/codedeploy/model/DeploymentReadyOption.h>
#include <aws/codedeploy/model/DeploymentStatus.h>
#include <aws/codedeploy/model/DeploymentStyle.h>
#include <aws/codedeploy/model/DeploymentTarget.h>
#include <aws/codedeploy/model/DeploymentTargetType.h>
#include <aws/codedeploy/model/DeploymentType.h>
#include <aws/codedeploy/model/DeploymentWaitType.h>
#include <aws/codedeploy/model/DeregisterOnPremisesInstanceRequest.h>
#include <aws/codedeploy/model/Diagnostics.h>
#include <aws/codedeploy/model/EC2TagFilter.h>
#include <aws/codedeploy/model/EC2TagFilterType.h>
#include <aws/codedeploy/model/EC2TagSet.h>
#include <aws/codedeploy/model/ECSService.h>
#include <aws/codedeploy/model/ECSTarget.h>
#include <aws/codedeploy/model/ECSTaskSet.h>
#include <aws/codedeploy/model/ELBInfo.h>
#include <aws/codedeploy/model/ErrorCode.h>
#include <aws/codedeploy/model/ErrorInformation.h>
#include <aws/codedeploy/model/FileExistsBehavior.h>
#include <aws/codedeploy/model/GenericRevisionInfo.h>
#include <aws/codedeploy/model/GetApplicationRequest.h>
#include <aws/codedeploy/model/GetApplicationResult.h>
#include <aws/codedeploy/model/GetApplicationRevisionRequest.h>
#include <aws/codedeploy/model/GetApplicationRevisionResult.h>
#include <aws/codedeploy/model/GetDeploymentConfigRequest.h>
#include <aws/codedeploy/model/GetDeploymentConfigResult.h>
#include <aws/codedeploy/model/GetDeploymentGroupRequest.h>
#include <aws/codedeploy/model/GetDeploymentGroupResult.h>
#include <aws/codedeploy/model/GetDeploymentRequest.h>
#include <aws/codedeploy/model/GetDeploymentResult.h>
#include <aws/codedeploy/model/GetDeploymentTargetRequest.h>
#include <aws/codedeploy/model/GetDeploymentTargetResult.h>
#include <aws/codedeploy/model/GetOnPremisesInstanceRequest.h>
#include <aws/codedeploy/model/GetOnPremisesInstanceResult.h>
#include <aws/codedeploy/model/GitHubLocation.h>
#include <aws/codedeploy/model/GreenFleetProvisioningAction.h>
#include <aws/codedeploy/model/GreenFleetProvisioningOption.h>
#include <aws/codedeploy/model/InstanceAction.h>
#include <aws/codedeploy/model/InstanceInfo.h>
#include <aws/codedeploy/model/InstanceStatus.h>
#include <aws/codedeploy/model/InstanceSummary.h>
#include <aws/codedeploy/model/InstanceTarget.h>
#include <aws/codedeploy/model/InstanceType.h>
#include <aws/codedeploy/model/LambdaFunctionInfo.h>
#include <aws/codedeploy/model/LambdaTarget.h>
#include <aws/codedeploy/model/LastDeploymentInfo.h>
#include <aws/codedeploy/model/LifecycleErrorCode.h>
#include <aws/codedeploy/model/LifecycleEvent.h>
#include <aws/codedeploy/model/LifecycleEventStatus.h>
#include <aws/codedeploy/model/ListApplicationRevisionsRequest.h>
#include <aws/codedeploy/model/ListApplicationRevisionsResult.h>
#include <aws/codedeploy/model/ListApplicationsRequest.h>
#include <aws/codedeploy/model/ListApplicationsResult.h>
#include <aws/codedeploy/model/ListDeploymentConfigsRequest.h>
#include <aws/codedeploy/model/ListDeploymentConfigsResult.h>
#include <aws/codedeploy/model/ListDeploymentGroupsRequest.h>
#include <aws/codedeploy/model/ListDeploymentGroupsResult.h>
#include <aws/codedeploy/model/ListDeploymentTargetsRequest.h>
#include <aws/codedeploy/model/ListDeploymentTargetsResult.h>
#include <aws/codedeploy/model/ListDeploymentsRequest.h>
#include <aws/codedeploy/model/ListDeploymentsResult.h>
#include <aws/codedeploy/model/ListGitHubAccountTokenNamesRequest.h>
#include <aws/codedeploy/model/ListGitHubAccountTokenNamesResult.h>
#include <aws/codedeploy/model/ListOnPremisesInstancesRequest.h>
#include <aws/codedeploy/model/ListOnPremisesInstancesResult.h>
#include <aws/codedeploy/model/ListStateFilterAction.h>
#include <aws/codedeploy/model/ListTagsForResourceRequest.h>
#include <aws/codedeploy/model/ListTagsForResourceResult.h>
#include <aws/codedeploy/model/LoadBalancerInfo.h>
#include <aws/codedeploy/model/MinimumHealthyHosts.h>
#include <aws/codedeploy/model/MinimumHealthyHostsPerZone.h>
#include <aws/codedeploy/model/MinimumHealthyHostsPerZoneType.h>
#include <aws/codedeploy/model/MinimumHealthyHostsType.h>
#include <aws/codedeploy/model/OnPremisesTagSet.h>
#include <aws/codedeploy/model/OutdatedInstancesStrategy.h>
#include <aws/codedeploy/model/PutLifecycleEventHookExecutionStatusRequest.h>
#include <aws/codedeploy/model/PutLifecycleEventHookExecutionStatusResult.h>
#include <aws/codedeploy/model/RawString.h>
#include <aws/codedeploy/model/RegisterApplicationRevisionRequest.h>
#include <aws/codedeploy/model/RegisterOnPremisesInstanceRequest.h>
#include <aws/codedeploy/model/RegistrationStatus.h>
#include <aws/codedeploy/model/RelatedDeployments.h>
#include <aws/codedeploy/model/RemoveTagsFromOnPremisesInstancesRequest.h>
#include <aws/codedeploy/model/RevisionInfo.h>
#include <aws/codedeploy/model/RevisionLocation.h>
#include <aws/codedeploy/model/RevisionLocationType.h>
#include <aws/codedeploy/model/RollbackInfo.h>
#include <aws/codedeploy/model/S3Location.h>
#include <aws/codedeploy/model/SortOrder.h>
#include <aws/codedeploy/model/StopDeploymentRequest.h>
#include <aws/codedeploy/model/StopDeploymentResult.h>
#include <aws/codedeploy/model/StopStatus.h>
#include <aws/codedeploy/model/Tag.h>
#include <aws/codedeploy/model/TagFilter.h>
#include <aws/codedeploy/model/TagFilterType.h>
#include <aws/codedeploy/model/TagResourceRequest.h>
#include <aws/codedeploy/model/TagResourceResult.h>
#include <aws/codedeploy/model/TargetFilterName.h>
#include <aws/codedeploy/model/TargetGroupInfo.h>
#include <aws/codedeploy/model/TargetGroupPairInfo.h>
#include <aws/codedeploy/model/TargetInstances.h>
#include <aws/codedeploy/model/TargetLabel.h>
#include <aws/codedeploy/model/TargetStatus.h>
#include <aws/codedeploy/model/TimeBasedCanary.h>
#include <aws/codedeploy/model/TimeBasedLinear.h>
#include <aws/codedeploy/model/TimeRange.h>
#include <aws/codedeploy/model/TrafficRoute.h>
#include <aws/codedeploy/model/TrafficRoutingConfig.h>
#include <aws/codedeploy/model/TrafficRoutingType.h>
#include <aws/codedeploy/model/TriggerConfig.h>
#include <aws/codedeploy/model/TriggerEventType.h>
#include <aws/codedeploy/model/UntagResourceRequest.h>
#include <aws/codedeploy/model/UntagResourceResult.h>
#include <aws/codedeploy/model/UpdateApplicationRequest.h>
#include <aws/codedeploy/model/UpdateDeploymentGroupRequest.h>
#include <aws/codedeploy/model/UpdateDeploymentGroupResult.h>
#include <aws/codedeploy/model/ZonalConfig.h>

using CodeDeployIncludeTest = ::testing::Test;

TEST_F(CodeDeployIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::CodeDeploy::CodeDeployClient>("CodeDeployIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
