/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/codepipeline/CodePipelineClient.h>
#include <aws/codepipeline/CodePipelineEndpointProvider.h>
#include <aws/codepipeline/CodePipelineEndpointRules.h>
#include <aws/codepipeline/CodePipelineErrorMarshaller.h>
#include <aws/codepipeline/CodePipelineErrors.h>
#include <aws/codepipeline/CodePipelineRequest.h>
#include <aws/codepipeline/CodePipelineServiceClientModel.h>
#include <aws/codepipeline/CodePipeline_EXPORTS.h>
#include <aws/codepipeline/model/AWSSessionCredentials.h>
#include <aws/codepipeline/model/AcknowledgeJobRequest.h>
#include <aws/codepipeline/model/AcknowledgeJobResult.h>
#include <aws/codepipeline/model/AcknowledgeThirdPartyJobRequest.h>
#include <aws/codepipeline/model/AcknowledgeThirdPartyJobResult.h>
#include <aws/codepipeline/model/ActionCategory.h>
#include <aws/codepipeline/model/ActionConfiguration.h>
#include <aws/codepipeline/model/ActionConfigurationProperty.h>
#include <aws/codepipeline/model/ActionConfigurationPropertyType.h>
#include <aws/codepipeline/model/ActionContext.h>
#include <aws/codepipeline/model/ActionDeclaration.h>
#include <aws/codepipeline/model/ActionExecution.h>
#include <aws/codepipeline/model/ActionExecutionDetail.h>
#include <aws/codepipeline/model/ActionExecutionFilter.h>
#include <aws/codepipeline/model/ActionExecutionInput.h>
#include <aws/codepipeline/model/ActionExecutionOutput.h>
#include <aws/codepipeline/model/ActionExecutionResult.h>
#include <aws/codepipeline/model/ActionExecutionStatus.h>
#include <aws/codepipeline/model/ActionOwner.h>
#include <aws/codepipeline/model/ActionRevision.h>
#include <aws/codepipeline/model/ActionState.h>
#include <aws/codepipeline/model/ActionType.h>
#include <aws/codepipeline/model/ActionTypeArtifactDetails.h>
#include <aws/codepipeline/model/ActionTypeDeclaration.h>
#include <aws/codepipeline/model/ActionTypeExecutor.h>
#include <aws/codepipeline/model/ActionTypeId.h>
#include <aws/codepipeline/model/ActionTypeIdentifier.h>
#include <aws/codepipeline/model/ActionTypePermissions.h>
#include <aws/codepipeline/model/ActionTypeProperty.h>
#include <aws/codepipeline/model/ActionTypeSettings.h>
#include <aws/codepipeline/model/ActionTypeUrls.h>
#include <aws/codepipeline/model/ApprovalResult.h>
#include <aws/codepipeline/model/ApprovalStatus.h>
#include <aws/codepipeline/model/Artifact.h>
#include <aws/codepipeline/model/ArtifactDetail.h>
#include <aws/codepipeline/model/ArtifactDetails.h>
#include <aws/codepipeline/model/ArtifactLocation.h>
#include <aws/codepipeline/model/ArtifactLocationType.h>
#include <aws/codepipeline/model/ArtifactRevision.h>
#include <aws/codepipeline/model/ArtifactStore.h>
#include <aws/codepipeline/model/ArtifactStoreType.h>
#include <aws/codepipeline/model/BeforeEntryConditions.h>
#include <aws/codepipeline/model/BlockerDeclaration.h>
#include <aws/codepipeline/model/BlockerType.h>
#include <aws/codepipeline/model/Condition.h>
#include <aws/codepipeline/model/ConditionExecution.h>
#include <aws/codepipeline/model/ConditionExecutionStatus.h>
#include <aws/codepipeline/model/ConditionState.h>
#include <aws/codepipeline/model/ConditionType.h>
#include <aws/codepipeline/model/CreateCustomActionTypeRequest.h>
#include <aws/codepipeline/model/CreateCustomActionTypeResult.h>
#include <aws/codepipeline/model/CreatePipelineRequest.h>
#include <aws/codepipeline/model/CreatePipelineResult.h>
#include <aws/codepipeline/model/CurrentRevision.h>
#include <aws/codepipeline/model/DeleteCustomActionTypeRequest.h>
#include <aws/codepipeline/model/DeletePipelineRequest.h>
#include <aws/codepipeline/model/DeleteWebhookRequest.h>
#include <aws/codepipeline/model/DeleteWebhookResult.h>
#include <aws/codepipeline/model/DeployActionExecutionTarget.h>
#include <aws/codepipeline/model/DeployTargetEvent.h>
#include <aws/codepipeline/model/DeployTargetEventContext.h>
#include <aws/codepipeline/model/DeregisterWebhookWithThirdPartyRequest.h>
#include <aws/codepipeline/model/DeregisterWebhookWithThirdPartyResult.h>
#include <aws/codepipeline/model/DisableStageTransitionRequest.h>
#include <aws/codepipeline/model/EnableStageTransitionRequest.h>
#include <aws/codepipeline/model/EncryptionKey.h>
#include <aws/codepipeline/model/EncryptionKeyType.h>
#include <aws/codepipeline/model/EnvironmentVariable.h>
#include <aws/codepipeline/model/EnvironmentVariableType.h>
#include <aws/codepipeline/model/ErrorDetails.h>
#include <aws/codepipeline/model/ExecutionDetails.h>
#include <aws/codepipeline/model/ExecutionMode.h>
#include <aws/codepipeline/model/ExecutionTrigger.h>
#include <aws/codepipeline/model/ExecutionType.h>
#include <aws/codepipeline/model/ExecutorConfiguration.h>
#include <aws/codepipeline/model/ExecutorType.h>
#include <aws/codepipeline/model/FailureConditions.h>
#include <aws/codepipeline/model/FailureDetails.h>
#include <aws/codepipeline/model/FailureType.h>
#include <aws/codepipeline/model/GetActionTypeRequest.h>
#include <aws/codepipeline/model/GetActionTypeResult.h>
#include <aws/codepipeline/model/GetJobDetailsRequest.h>
#include <aws/codepipeline/model/GetJobDetailsResult.h>
#include <aws/codepipeline/model/GetPipelineExecutionRequest.h>
#include <aws/codepipeline/model/GetPipelineExecutionResult.h>
#include <aws/codepipeline/model/GetPipelineRequest.h>
#include <aws/codepipeline/model/GetPipelineResult.h>
#include <aws/codepipeline/model/GetPipelineStateRequest.h>
#include <aws/codepipeline/model/GetPipelineStateResult.h>
#include <aws/codepipeline/model/GetThirdPartyJobDetailsRequest.h>
#include <aws/codepipeline/model/GetThirdPartyJobDetailsResult.h>
#include <aws/codepipeline/model/GitBranchFilterCriteria.h>
#include <aws/codepipeline/model/GitConfiguration.h>
#include <aws/codepipeline/model/GitFilePathFilterCriteria.h>
#include <aws/codepipeline/model/GitPullRequestEventType.h>
#include <aws/codepipeline/model/GitPullRequestFilter.h>
#include <aws/codepipeline/model/GitPushFilter.h>
#include <aws/codepipeline/model/GitTagFilterCriteria.h>
#include <aws/codepipeline/model/InputArtifact.h>
#include <aws/codepipeline/model/Job.h>
#include <aws/codepipeline/model/JobData.h>
#include <aws/codepipeline/model/JobDetails.h>
#include <aws/codepipeline/model/JobStatus.h>
#include <aws/codepipeline/model/JobWorkerExecutorConfiguration.h>
#include <aws/codepipeline/model/LambdaExecutorConfiguration.h>
#include <aws/codepipeline/model/LatestInPipelineExecutionFilter.h>
#include <aws/codepipeline/model/ListActionExecutionsRequest.h>
#include <aws/codepipeline/model/ListActionExecutionsResult.h>
#include <aws/codepipeline/model/ListActionTypesRequest.h>
#include <aws/codepipeline/model/ListActionTypesResult.h>
#include <aws/codepipeline/model/ListDeployActionExecutionTargetsRequest.h>
#include <aws/codepipeline/model/ListDeployActionExecutionTargetsResult.h>
#include <aws/codepipeline/model/ListPipelineExecutionsRequest.h>
#include <aws/codepipeline/model/ListPipelineExecutionsResult.h>
#include <aws/codepipeline/model/ListPipelinesRequest.h>
#include <aws/codepipeline/model/ListPipelinesResult.h>
#include <aws/codepipeline/model/ListRuleExecutionsRequest.h>
#include <aws/codepipeline/model/ListRuleExecutionsResult.h>
#include <aws/codepipeline/model/ListRuleTypesRequest.h>
#include <aws/codepipeline/model/ListRuleTypesResult.h>
#include <aws/codepipeline/model/ListTagsForResourceRequest.h>
#include <aws/codepipeline/model/ListTagsForResourceResult.h>
#include <aws/codepipeline/model/ListWebhookItem.h>
#include <aws/codepipeline/model/ListWebhooksRequest.h>
#include <aws/codepipeline/model/ListWebhooksResult.h>
#include <aws/codepipeline/model/OutputArtifact.h>
#include <aws/codepipeline/model/OverrideStageConditionRequest.h>
#include <aws/codepipeline/model/PipelineContext.h>
#include <aws/codepipeline/model/PipelineDeclaration.h>
#include <aws/codepipeline/model/PipelineExecution.h>
#include <aws/codepipeline/model/PipelineExecutionFilter.h>
#include <aws/codepipeline/model/PipelineExecutionStatus.h>
#include <aws/codepipeline/model/PipelineExecutionSummary.h>
#include <aws/codepipeline/model/PipelineMetadata.h>
#include <aws/codepipeline/model/PipelineRollbackMetadata.h>
#include <aws/codepipeline/model/PipelineSummary.h>
#include <aws/codepipeline/model/PipelineTriggerDeclaration.h>
#include <aws/codepipeline/model/PipelineTriggerProviderType.h>
#include <aws/codepipeline/model/PipelineType.h>
#include <aws/codepipeline/model/PipelineVariable.h>
#include <aws/codepipeline/model/PipelineVariableDeclaration.h>
#include <aws/codepipeline/model/PollForJobsRequest.h>
#include <aws/codepipeline/model/PollForJobsResult.h>
#include <aws/codepipeline/model/PollForThirdPartyJobsRequest.h>
#include <aws/codepipeline/model/PollForThirdPartyJobsResult.h>
#include <aws/codepipeline/model/PutActionRevisionRequest.h>
#include <aws/codepipeline/model/PutActionRevisionResult.h>
#include <aws/codepipeline/model/PutApprovalResultRequest.h>
#include <aws/codepipeline/model/PutApprovalResultResult.h>
#include <aws/codepipeline/model/PutJobFailureResultRequest.h>
#include <aws/codepipeline/model/PutJobSuccessResultRequest.h>
#include <aws/codepipeline/model/PutThirdPartyJobFailureResultRequest.h>
#include <aws/codepipeline/model/PutThirdPartyJobSuccessResultRequest.h>
#include <aws/codepipeline/model/PutWebhookRequest.h>
#include <aws/codepipeline/model/PutWebhookResult.h>
#include <aws/codepipeline/model/RegisterWebhookWithThirdPartyRequest.h>
#include <aws/codepipeline/model/RegisterWebhookWithThirdPartyResult.h>
#include <aws/codepipeline/model/ResolvedPipelineVariable.h>
#include <aws/codepipeline/model/Result.h>
#include <aws/codepipeline/model/RetryConfiguration.h>
#include <aws/codepipeline/model/RetryStageExecutionRequest.h>
#include <aws/codepipeline/model/RetryStageExecutionResult.h>
#include <aws/codepipeline/model/RetryStageMetadata.h>
#include <aws/codepipeline/model/RetryTrigger.h>
#include <aws/codepipeline/model/RollbackStageRequest.h>
#include <aws/codepipeline/model/RollbackStageResult.h>
#include <aws/codepipeline/model/RuleCategory.h>
#include <aws/codepipeline/model/RuleConfigurationProperty.h>
#include <aws/codepipeline/model/RuleConfigurationPropertyType.h>
#include <aws/codepipeline/model/RuleDeclaration.h>
#include <aws/codepipeline/model/RuleExecution.h>
#include <aws/codepipeline/model/RuleExecutionDetail.h>
#include <aws/codepipeline/model/RuleExecutionFilter.h>
#include <aws/codepipeline/model/RuleExecutionInput.h>
#include <aws/codepipeline/model/RuleExecutionOutput.h>
#include <aws/codepipeline/model/RuleExecutionResult.h>
#include <aws/codepipeline/model/RuleExecutionStatus.h>
#include <aws/codepipeline/model/RuleOwner.h>
#include <aws/codepipeline/model/RuleRevision.h>
#include <aws/codepipeline/model/RuleState.h>
#include <aws/codepipeline/model/RuleType.h>
#include <aws/codepipeline/model/RuleTypeId.h>
#include <aws/codepipeline/model/RuleTypeSettings.h>
#include <aws/codepipeline/model/S3ArtifactLocation.h>
#include <aws/codepipeline/model/S3Location.h>
#include <aws/codepipeline/model/SourceRevision.h>
#include <aws/codepipeline/model/SourceRevisionOverride.h>
#include <aws/codepipeline/model/SourceRevisionType.h>
#include <aws/codepipeline/model/StageConditionState.h>
#include <aws/codepipeline/model/StageConditionsExecution.h>
#include <aws/codepipeline/model/StageContext.h>
#include <aws/codepipeline/model/StageDeclaration.h>
#include <aws/codepipeline/model/StageExecution.h>
#include <aws/codepipeline/model/StageExecutionStatus.h>
#include <aws/codepipeline/model/StageRetryMode.h>
#include <aws/codepipeline/model/StageState.h>
#include <aws/codepipeline/model/StageTransitionType.h>
#include <aws/codepipeline/model/StartPipelineExecutionRequest.h>
#include <aws/codepipeline/model/StartPipelineExecutionResult.h>
#include <aws/codepipeline/model/StartTimeRange.h>
#include <aws/codepipeline/model/StopExecutionTrigger.h>
#include <aws/codepipeline/model/StopPipelineExecutionRequest.h>
#include <aws/codepipeline/model/StopPipelineExecutionResult.h>
#include <aws/codepipeline/model/SucceededInStageFilter.h>
#include <aws/codepipeline/model/SuccessConditions.h>
#include <aws/codepipeline/model/Tag.h>
#include <aws/codepipeline/model/TagResourceRequest.h>
#include <aws/codepipeline/model/TagResourceResult.h>
#include <aws/codepipeline/model/TargetFilter.h>
#include <aws/codepipeline/model/TargetFilterName.h>
#include <aws/codepipeline/model/ThirdPartyJob.h>
#include <aws/codepipeline/model/ThirdPartyJobData.h>
#include <aws/codepipeline/model/ThirdPartyJobDetails.h>
#include <aws/codepipeline/model/TransitionState.h>
#include <aws/codepipeline/model/TriggerType.h>
#include <aws/codepipeline/model/UntagResourceRequest.h>
#include <aws/codepipeline/model/UntagResourceResult.h>
#include <aws/codepipeline/model/UpdateActionTypeRequest.h>
#include <aws/codepipeline/model/UpdatePipelineRequest.h>
#include <aws/codepipeline/model/UpdatePipelineResult.h>
#include <aws/codepipeline/model/WebhookAuthConfiguration.h>
#include <aws/codepipeline/model/WebhookAuthenticationType.h>
#include <aws/codepipeline/model/WebhookDefinition.h>
#include <aws/codepipeline/model/WebhookFilterRule.h>

using CodePipelineIncludeTest = ::testing::Test;

TEST_F(CodePipelineIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::CodePipeline::CodePipelineClient>("CodePipelineIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
