/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/comprehend/ComprehendClient.h>
#include <aws/comprehend/ComprehendEndpointProvider.h>
#include <aws/comprehend/ComprehendEndpointRules.h>
#include <aws/comprehend/ComprehendErrorMarshaller.h>
#include <aws/comprehend/ComprehendErrors.h>
#include <aws/comprehend/ComprehendRequest.h>
#include <aws/comprehend/ComprehendServiceClientModel.h>
#include <aws/comprehend/Comprehend_EXPORTS.h>
#include <aws/comprehend/model/AugmentedManifestsDocumentTypeFormat.h>
#include <aws/comprehend/model/AugmentedManifestsListItem.h>
#include <aws/comprehend/model/BatchDetectDominantLanguageItemResult.h>
#include <aws/comprehend/model/BatchDetectDominantLanguageRequest.h>
#include <aws/comprehend/model/BatchDetectDominantLanguageResult.h>
#include <aws/comprehend/model/BatchDetectEntitiesItemResult.h>
#include <aws/comprehend/model/BatchDetectEntitiesRequest.h>
#include <aws/comprehend/model/BatchDetectEntitiesResult.h>
#include <aws/comprehend/model/BatchDetectKeyPhrasesItemResult.h>
#include <aws/comprehend/model/BatchDetectKeyPhrasesRequest.h>
#include <aws/comprehend/model/BatchDetectKeyPhrasesResult.h>
#include <aws/comprehend/model/BatchDetectSentimentItemResult.h>
#include <aws/comprehend/model/BatchDetectSentimentRequest.h>
#include <aws/comprehend/model/BatchDetectSentimentResult.h>
#include <aws/comprehend/model/BatchDetectSyntaxItemResult.h>
#include <aws/comprehend/model/BatchDetectSyntaxRequest.h>
#include <aws/comprehend/model/BatchDetectSyntaxResult.h>
#include <aws/comprehend/model/BatchDetectTargetedSentimentItemResult.h>
#include <aws/comprehend/model/BatchDetectTargetedSentimentRequest.h>
#include <aws/comprehend/model/BatchDetectTargetedSentimentResult.h>
#include <aws/comprehend/model/BatchItemError.h>
#include <aws/comprehend/model/Block.h>
#include <aws/comprehend/model/BlockReference.h>
#include <aws/comprehend/model/BlockType.h>
#include <aws/comprehend/model/BoundingBox.h>
#include <aws/comprehend/model/ChildBlock.h>
#include <aws/comprehend/model/ClassifierEvaluationMetrics.h>
#include <aws/comprehend/model/ClassifierMetadata.h>
#include <aws/comprehend/model/ClassifyDocumentRequest.h>
#include <aws/comprehend/model/ClassifyDocumentResult.h>
#include <aws/comprehend/model/ContainsPiiEntitiesRequest.h>
#include <aws/comprehend/model/ContainsPiiEntitiesResult.h>
#include <aws/comprehend/model/CreateDatasetRequest.h>
#include <aws/comprehend/model/CreateDatasetResult.h>
#include <aws/comprehend/model/CreateDocumentClassifierRequest.h>
#include <aws/comprehend/model/CreateDocumentClassifierResult.h>
#include <aws/comprehend/model/CreateEndpointRequest.h>
#include <aws/comprehend/model/CreateEndpointResult.h>
#include <aws/comprehend/model/CreateEntityRecognizerRequest.h>
#include <aws/comprehend/model/CreateEntityRecognizerResult.h>
#include <aws/comprehend/model/CreateFlywheelRequest.h>
#include <aws/comprehend/model/CreateFlywheelResult.h>
#include <aws/comprehend/model/DataSecurityConfig.h>
#include <aws/comprehend/model/DatasetAugmentedManifestsListItem.h>
#include <aws/comprehend/model/DatasetDataFormat.h>
#include <aws/comprehend/model/DatasetDocumentClassifierInputDataConfig.h>
#include <aws/comprehend/model/DatasetEntityRecognizerAnnotations.h>
#include <aws/comprehend/model/DatasetEntityRecognizerDocuments.h>
#include <aws/comprehend/model/DatasetEntityRecognizerEntityList.h>
#include <aws/comprehend/model/DatasetEntityRecognizerInputDataConfig.h>
#include <aws/comprehend/model/DatasetFilter.h>
#include <aws/comprehend/model/DatasetInputDataConfig.h>
#include <aws/comprehend/model/DatasetProperties.h>
#include <aws/comprehend/model/DatasetStatus.h>
#include <aws/comprehend/model/DatasetType.h>
#include <aws/comprehend/model/DeleteDocumentClassifierRequest.h>
#include <aws/comprehend/model/DeleteDocumentClassifierResult.h>
#include <aws/comprehend/model/DeleteEndpointRequest.h>
#include <aws/comprehend/model/DeleteEndpointResult.h>
#include <aws/comprehend/model/DeleteEntityRecognizerRequest.h>
#include <aws/comprehend/model/DeleteEntityRecognizerResult.h>
#include <aws/comprehend/model/DeleteFlywheelRequest.h>
#include <aws/comprehend/model/DeleteFlywheelResult.h>
#include <aws/comprehend/model/DeleteResourcePolicyRequest.h>
#include <aws/comprehend/model/DeleteResourcePolicyResult.h>
#include <aws/comprehend/model/DescribeDatasetRequest.h>
#include <aws/comprehend/model/DescribeDatasetResult.h>
#include <aws/comprehend/model/DescribeDocumentClassificationJobRequest.h>
#include <aws/comprehend/model/DescribeDocumentClassificationJobResult.h>
#include <aws/comprehend/model/DescribeDocumentClassifierRequest.h>
#include <aws/comprehend/model/DescribeDocumentClassifierResult.h>
#include <aws/comprehend/model/DescribeDominantLanguageDetectionJobRequest.h>
#include <aws/comprehend/model/DescribeDominantLanguageDetectionJobResult.h>
#include <aws/comprehend/model/DescribeEndpointRequest.h>
#include <aws/comprehend/model/DescribeEndpointResult.h>
#include <aws/comprehend/model/DescribeEntitiesDetectionJobRequest.h>
#include <aws/comprehend/model/DescribeEntitiesDetectionJobResult.h>
#include <aws/comprehend/model/DescribeEntityRecognizerRequest.h>
#include <aws/comprehend/model/DescribeEntityRecognizerResult.h>
#include <aws/comprehend/model/DescribeEventsDetectionJobRequest.h>
#include <aws/comprehend/model/DescribeEventsDetectionJobResult.h>
#include <aws/comprehend/model/DescribeFlywheelIterationRequest.h>
#include <aws/comprehend/model/DescribeFlywheelIterationResult.h>
#include <aws/comprehend/model/DescribeFlywheelRequest.h>
#include <aws/comprehend/model/DescribeFlywheelResult.h>
#include <aws/comprehend/model/DescribeKeyPhrasesDetectionJobRequest.h>
#include <aws/comprehend/model/DescribeKeyPhrasesDetectionJobResult.h>
#include <aws/comprehend/model/DescribePiiEntitiesDetectionJobRequest.h>
#include <aws/comprehend/model/DescribePiiEntitiesDetectionJobResult.h>
#include <aws/comprehend/model/DescribeResourcePolicyRequest.h>
#include <aws/comprehend/model/DescribeResourcePolicyResult.h>
#include <aws/comprehend/model/DescribeSentimentDetectionJobRequest.h>
#include <aws/comprehend/model/DescribeSentimentDetectionJobResult.h>
#include <aws/comprehend/model/DescribeTargetedSentimentDetectionJobRequest.h>
#include <aws/comprehend/model/DescribeTargetedSentimentDetectionJobResult.h>
#include <aws/comprehend/model/DescribeTopicsDetectionJobRequest.h>
#include <aws/comprehend/model/DescribeTopicsDetectionJobResult.h>
#include <aws/comprehend/model/DetectDominantLanguageRequest.h>
#include <aws/comprehend/model/DetectDominantLanguageResult.h>
#include <aws/comprehend/model/DetectEntitiesRequest.h>
#include <aws/comprehend/model/DetectEntitiesResult.h>
#include <aws/comprehend/model/DetectKeyPhrasesRequest.h>
#include <aws/comprehend/model/DetectKeyPhrasesResult.h>
#include <aws/comprehend/model/DetectPiiEntitiesRequest.h>
#include <aws/comprehend/model/DetectPiiEntitiesResult.h>
#include <aws/comprehend/model/DetectSentimentRequest.h>
#include <aws/comprehend/model/DetectSentimentResult.h>
#include <aws/comprehend/model/DetectSyntaxRequest.h>
#include <aws/comprehend/model/DetectSyntaxResult.h>
#include <aws/comprehend/model/DetectTargetedSentimentRequest.h>
#include <aws/comprehend/model/DetectTargetedSentimentResult.h>
#include <aws/comprehend/model/DetectToxicContentRequest.h>
#include <aws/comprehend/model/DetectToxicContentResult.h>
#include <aws/comprehend/model/DocumentClass.h>
#include <aws/comprehend/model/DocumentClassificationConfig.h>
#include <aws/comprehend/model/DocumentClassificationJobFilter.h>
#include <aws/comprehend/model/DocumentClassificationJobProperties.h>
#include <aws/comprehend/model/DocumentClassifierDataFormat.h>
#include <aws/comprehend/model/DocumentClassifierDocumentTypeFormat.h>
#include <aws/comprehend/model/DocumentClassifierDocuments.h>
#include <aws/comprehend/model/DocumentClassifierFilter.h>
#include <aws/comprehend/model/DocumentClassifierInputDataConfig.h>
#include <aws/comprehend/model/DocumentClassifierMode.h>
#include <aws/comprehend/model/DocumentClassifierOutputDataConfig.h>
#include <aws/comprehend/model/DocumentClassifierProperties.h>
#include <aws/comprehend/model/DocumentClassifierSummary.h>
#include <aws/comprehend/model/DocumentLabel.h>
#include <aws/comprehend/model/DocumentMetadata.h>
#include <aws/comprehend/model/DocumentReadAction.h>
#include <aws/comprehend/model/DocumentReadFeatureTypes.h>
#include <aws/comprehend/model/DocumentReadMode.h>
#include <aws/comprehend/model/DocumentReaderConfig.h>
#include <aws/comprehend/model/DocumentType.h>
#include <aws/comprehend/model/DocumentTypeListItem.h>
#include <aws/comprehend/model/DominantLanguage.h>
#include <aws/comprehend/model/DominantLanguageDetectionJobFilter.h>
#include <aws/comprehend/model/DominantLanguageDetectionJobProperties.h>
#include <aws/comprehend/model/EndpointFilter.h>
#include <aws/comprehend/model/EndpointProperties.h>
#include <aws/comprehend/model/EndpointStatus.h>
#include <aws/comprehend/model/EntitiesDetectionJobFilter.h>
#include <aws/comprehend/model/EntitiesDetectionJobProperties.h>
#include <aws/comprehend/model/Entity.h>
#include <aws/comprehend/model/EntityLabel.h>
#include <aws/comprehend/model/EntityRecognitionConfig.h>
#include <aws/comprehend/model/EntityRecognizerAnnotations.h>
#include <aws/comprehend/model/EntityRecognizerDataFormat.h>
#include <aws/comprehend/model/EntityRecognizerDocuments.h>
#include <aws/comprehend/model/EntityRecognizerEntityList.h>
#include <aws/comprehend/model/EntityRecognizerEvaluationMetrics.h>
#include <aws/comprehend/model/EntityRecognizerFilter.h>
#include <aws/comprehend/model/EntityRecognizerInputDataConfig.h>
#include <aws/comprehend/model/EntityRecognizerMetadata.h>
#include <aws/comprehend/model/EntityRecognizerMetadataEntityTypesListItem.h>
#include <aws/comprehend/model/EntityRecognizerOutputDataConfig.h>
#include <aws/comprehend/model/EntityRecognizerProperties.h>
#include <aws/comprehend/model/EntityRecognizerSummary.h>
#include <aws/comprehend/model/EntityType.h>
#include <aws/comprehend/model/EntityTypesEvaluationMetrics.h>
#include <aws/comprehend/model/EntityTypesListItem.h>
#include <aws/comprehend/model/ErrorsListItem.h>
#include <aws/comprehend/model/EventsDetectionJobFilter.h>
#include <aws/comprehend/model/EventsDetectionJobProperties.h>
#include <aws/comprehend/model/ExtractedCharactersListItem.h>
#include <aws/comprehend/model/FlywheelFilter.h>
#include <aws/comprehend/model/FlywheelIterationFilter.h>
#include <aws/comprehend/model/FlywheelIterationProperties.h>
#include <aws/comprehend/model/FlywheelIterationStatus.h>
#include <aws/comprehend/model/FlywheelModelEvaluationMetrics.h>
#include <aws/comprehend/model/FlywheelProperties.h>
#include <aws/comprehend/model/FlywheelStatus.h>
#include <aws/comprehend/model/FlywheelSummary.h>
#include <aws/comprehend/model/Geometry.h>
#include <aws/comprehend/model/ImportModelRequest.h>
#include <aws/comprehend/model/ImportModelResult.h>
#include <aws/comprehend/model/InputDataConfig.h>
#include <aws/comprehend/model/InputFormat.h>
#include <aws/comprehend/model/InvalidRequestDetail.h>
#include <aws/comprehend/model/InvalidRequestDetailReason.h>
#include <aws/comprehend/model/InvalidRequestException.h>
#include <aws/comprehend/model/InvalidRequestReason.h>
#include <aws/comprehend/model/JobStatus.h>
#include <aws/comprehend/model/KeyPhrase.h>
#include <aws/comprehend/model/KeyPhrasesDetectionJobFilter.h>
#include <aws/comprehend/model/KeyPhrasesDetectionJobProperties.h>
#include <aws/comprehend/model/LanguageCode.h>
#include <aws/comprehend/model/ListDatasetsRequest.h>
#include <aws/comprehend/model/ListDatasetsResult.h>
#include <aws/comprehend/model/ListDocumentClassificationJobsRequest.h>
#include <aws/comprehend/model/ListDocumentClassificationJobsResult.h>
#include <aws/comprehend/model/ListDocumentClassifierSummariesRequest.h>
#include <aws/comprehend/model/ListDocumentClassifierSummariesResult.h>
#include <aws/comprehend/model/ListDocumentClassifiersRequest.h>
#include <aws/comprehend/model/ListDocumentClassifiersResult.h>
#include <aws/comprehend/model/ListDominantLanguageDetectionJobsRequest.h>
#include <aws/comprehend/model/ListDominantLanguageDetectionJobsResult.h>
#include <aws/comprehend/model/ListEndpointsRequest.h>
#include <aws/comprehend/model/ListEndpointsResult.h>
#include <aws/comprehend/model/ListEntitiesDetectionJobsRequest.h>
#include <aws/comprehend/model/ListEntitiesDetectionJobsResult.h>
#include <aws/comprehend/model/ListEntityRecognizerSummariesRequest.h>
#include <aws/comprehend/model/ListEntityRecognizerSummariesResult.h>
#include <aws/comprehend/model/ListEntityRecognizersRequest.h>
#include <aws/comprehend/model/ListEntityRecognizersResult.h>
#include <aws/comprehend/model/ListEventsDetectionJobsRequest.h>
#include <aws/comprehend/model/ListEventsDetectionJobsResult.h>
#include <aws/comprehend/model/ListFlywheelIterationHistoryRequest.h>
#include <aws/comprehend/model/ListFlywheelIterationHistoryResult.h>
#include <aws/comprehend/model/ListFlywheelsRequest.h>
#include <aws/comprehend/model/ListFlywheelsResult.h>
#include <aws/comprehend/model/ListKeyPhrasesDetectionJobsRequest.h>
#include <aws/comprehend/model/ListKeyPhrasesDetectionJobsResult.h>
#include <aws/comprehend/model/ListPiiEntitiesDetectionJobsRequest.h>
#include <aws/comprehend/model/ListPiiEntitiesDetectionJobsResult.h>
#include <aws/comprehend/model/ListSentimentDetectionJobsRequest.h>
#include <aws/comprehend/model/ListSentimentDetectionJobsResult.h>
#include <aws/comprehend/model/ListTagsForResourceRequest.h>
#include <aws/comprehend/model/ListTagsForResourceResult.h>
#include <aws/comprehend/model/ListTargetedSentimentDetectionJobsRequest.h>
#include <aws/comprehend/model/ListTargetedSentimentDetectionJobsResult.h>
#include <aws/comprehend/model/ListTopicsDetectionJobsRequest.h>
#include <aws/comprehend/model/ListTopicsDetectionJobsResult.h>
#include <aws/comprehend/model/MentionSentiment.h>
#include <aws/comprehend/model/ModelStatus.h>
#include <aws/comprehend/model/ModelType.h>
#include <aws/comprehend/model/OutputDataConfig.h>
#include <aws/comprehend/model/PageBasedErrorCode.h>
#include <aws/comprehend/model/PageBasedWarningCode.h>
#include <aws/comprehend/model/PartOfSpeechTag.h>
#include <aws/comprehend/model/PartOfSpeechTagType.h>
#include <aws/comprehend/model/PiiEntitiesDetectionJobFilter.h>
#include <aws/comprehend/model/PiiEntitiesDetectionJobProperties.h>
#include <aws/comprehend/model/PiiEntitiesDetectionMaskMode.h>
#include <aws/comprehend/model/PiiEntitiesDetectionMode.h>
#include <aws/comprehend/model/PiiEntity.h>
#include <aws/comprehend/model/PiiEntityType.h>
#include <aws/comprehend/model/PiiOutputDataConfig.h>
#include <aws/comprehend/model/Point.h>
#include <aws/comprehend/model/PutResourcePolicyRequest.h>
#include <aws/comprehend/model/PutResourcePolicyResult.h>
#include <aws/comprehend/model/RedactionConfig.h>
#include <aws/comprehend/model/RelationshipType.h>
#include <aws/comprehend/model/RelationshipsListItem.h>
#include <aws/comprehend/model/SentimentDetectionJobFilter.h>
#include <aws/comprehend/model/SentimentDetectionJobProperties.h>
#include <aws/comprehend/model/SentimentScore.h>
#include <aws/comprehend/model/SentimentType.h>
#include <aws/comprehend/model/Split.h>
#include <aws/comprehend/model/StartDocumentClassificationJobRequest.h>
#include <aws/comprehend/model/StartDocumentClassificationJobResult.h>
#include <aws/comprehend/model/StartDominantLanguageDetectionJobRequest.h>
#include <aws/comprehend/model/StartDominantLanguageDetectionJobResult.h>
#include <aws/comprehend/model/StartEntitiesDetectionJobRequest.h>
#include <aws/comprehend/model/StartEntitiesDetectionJobResult.h>
#include <aws/comprehend/model/StartEventsDetectionJobRequest.h>
#include <aws/comprehend/model/StartEventsDetectionJobResult.h>
#include <aws/comprehend/model/StartFlywheelIterationRequest.h>
#include <aws/comprehend/model/StartFlywheelIterationResult.h>
#include <aws/comprehend/model/StartKeyPhrasesDetectionJobRequest.h>
#include <aws/comprehend/model/StartKeyPhrasesDetectionJobResult.h>
#include <aws/comprehend/model/StartPiiEntitiesDetectionJobRequest.h>
#include <aws/comprehend/model/StartPiiEntitiesDetectionJobResult.h>
#include <aws/comprehend/model/StartSentimentDetectionJobRequest.h>
#include <aws/comprehend/model/StartSentimentDetectionJobResult.h>
#include <aws/comprehend/model/StartTargetedSentimentDetectionJobRequest.h>
#include <aws/comprehend/model/StartTargetedSentimentDetectionJobResult.h>
#include <aws/comprehend/model/StartTopicsDetectionJobRequest.h>
#include <aws/comprehend/model/StartTopicsDetectionJobResult.h>
#include <aws/comprehend/model/StopDominantLanguageDetectionJobRequest.h>
#include <aws/comprehend/model/StopDominantLanguageDetectionJobResult.h>
#include <aws/comprehend/model/StopEntitiesDetectionJobRequest.h>
#include <aws/comprehend/model/StopEntitiesDetectionJobResult.h>
#include <aws/comprehend/model/StopEventsDetectionJobRequest.h>
#include <aws/comprehend/model/StopEventsDetectionJobResult.h>
#include <aws/comprehend/model/StopKeyPhrasesDetectionJobRequest.h>
#include <aws/comprehend/model/StopKeyPhrasesDetectionJobResult.h>
#include <aws/comprehend/model/StopPiiEntitiesDetectionJobRequest.h>
#include <aws/comprehend/model/StopPiiEntitiesDetectionJobResult.h>
#include <aws/comprehend/model/StopSentimentDetectionJobRequest.h>
#include <aws/comprehend/model/StopSentimentDetectionJobResult.h>
#include <aws/comprehend/model/StopTargetedSentimentDetectionJobRequest.h>
#include <aws/comprehend/model/StopTargetedSentimentDetectionJobResult.h>
#include <aws/comprehend/model/StopTrainingDocumentClassifierRequest.h>
#include <aws/comprehend/model/StopTrainingDocumentClassifierResult.h>
#include <aws/comprehend/model/StopTrainingEntityRecognizerRequest.h>
#include <aws/comprehend/model/StopTrainingEntityRecognizerResult.h>
#include <aws/comprehend/model/SyntaxLanguageCode.h>
#include <aws/comprehend/model/SyntaxToken.h>
#include <aws/comprehend/model/Tag.h>
#include <aws/comprehend/model/TagResourceRequest.h>
#include <aws/comprehend/model/TagResourceResult.h>
#include <aws/comprehend/model/TargetedSentimentDetectionJobFilter.h>
#include <aws/comprehend/model/TargetedSentimentDetectionJobProperties.h>
#include <aws/comprehend/model/TargetedSentimentEntity.h>
#include <aws/comprehend/model/TargetedSentimentEntityType.h>
#include <aws/comprehend/model/TargetedSentimentMention.h>
#include <aws/comprehend/model/TaskConfig.h>
#include <aws/comprehend/model/TextSegment.h>
#include <aws/comprehend/model/TopicsDetectionJobFilter.h>
#include <aws/comprehend/model/TopicsDetectionJobProperties.h>
#include <aws/comprehend/model/ToxicContent.h>
#include <aws/comprehend/model/ToxicContentType.h>
#include <aws/comprehend/model/ToxicLabels.h>
#include <aws/comprehend/model/UntagResourceRequest.h>
#include <aws/comprehend/model/UntagResourceResult.h>
#include <aws/comprehend/model/UpdateDataSecurityConfig.h>
#include <aws/comprehend/model/UpdateEndpointRequest.h>
#include <aws/comprehend/model/UpdateEndpointResult.h>
#include <aws/comprehend/model/UpdateFlywheelRequest.h>
#include <aws/comprehend/model/UpdateFlywheelResult.h>
#include <aws/comprehend/model/VpcConfig.h>
#include <aws/comprehend/model/WarningsListItem.h>

using ComprehendIncludeTest = ::testing::Test;

TEST_F(ComprehendIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::Comprehend::ComprehendClient>("ComprehendIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
