/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/compute-optimizer/ComputeOptimizerClient.h>
#include <aws/compute-optimizer/ComputeOptimizerEndpointProvider.h>
#include <aws/compute-optimizer/ComputeOptimizerEndpointRules.h>
#include <aws/compute-optimizer/ComputeOptimizerErrorMarshaller.h>
#include <aws/compute-optimizer/ComputeOptimizerErrors.h>
#include <aws/compute-optimizer/ComputeOptimizerRequest.h>
#include <aws/compute-optimizer/ComputeOptimizerServiceClientModel.h>
#include <aws/compute-optimizer/ComputeOptimizer_EXPORTS.h>
#include <aws/compute-optimizer/model/AccountEnrollmentStatus.h>
#include <aws/compute-optimizer/model/AllocationStrategy.h>
#include <aws/compute-optimizer/model/AsgType.h>
#include <aws/compute-optimizer/model/AutoScalingConfiguration.h>
#include <aws/compute-optimizer/model/AutoScalingGroupConfiguration.h>
#include <aws/compute-optimizer/model/AutoScalingGroupEstimatedMonthlySavings.h>
#include <aws/compute-optimizer/model/AutoScalingGroupRecommendation.h>
#include <aws/compute-optimizer/model/AutoScalingGroupRecommendationOption.h>
#include <aws/compute-optimizer/model/AutoScalingGroupSavingsOpportunityAfterDiscounts.h>
#include <aws/compute-optimizer/model/ContainerConfiguration.h>
#include <aws/compute-optimizer/model/ContainerRecommendation.h>
#include <aws/compute-optimizer/model/CpuVendorArchitecture.h>
#include <aws/compute-optimizer/model/Currency.h>
#include <aws/compute-optimizer/model/CurrentPerformanceRisk.h>
#include <aws/compute-optimizer/model/CurrentPerformanceRiskRatings.h>
#include <aws/compute-optimizer/model/CustomizableMetricHeadroom.h>
#include <aws/compute-optimizer/model/CustomizableMetricName.h>
#include <aws/compute-optimizer/model/CustomizableMetricParameters.h>
#include <aws/compute-optimizer/model/CustomizableMetricThreshold.h>
#include <aws/compute-optimizer/model/DBStorageConfiguration.h>
#include <aws/compute-optimizer/model/DeleteRecommendationPreferencesRequest.h>
#include <aws/compute-optimizer/model/DeleteRecommendationPreferencesResult.h>
#include <aws/compute-optimizer/model/DescribeRecommendationExportJobsRequest.h>
#include <aws/compute-optimizer/model/DescribeRecommendationExportJobsResult.h>
#include <aws/compute-optimizer/model/Dimension.h>
#include <aws/compute-optimizer/model/EBSEffectiveRecommendationPreferences.h>
#include <aws/compute-optimizer/model/EBSEstimatedMonthlySavings.h>
#include <aws/compute-optimizer/model/EBSFilter.h>
#include <aws/compute-optimizer/model/EBSFilterName.h>
#include <aws/compute-optimizer/model/EBSFinding.h>
#include <aws/compute-optimizer/model/EBSMetricName.h>
#include <aws/compute-optimizer/model/EBSSavingsEstimationMode.h>
#include <aws/compute-optimizer/model/EBSSavingsEstimationModeSource.h>
#include <aws/compute-optimizer/model/EBSSavingsOpportunityAfterDiscounts.h>
#include <aws/compute-optimizer/model/EBSUtilizationMetric.h>
#include <aws/compute-optimizer/model/ECSEffectiveRecommendationPreferences.h>
#include <aws/compute-optimizer/model/ECSEstimatedMonthlySavings.h>
#include <aws/compute-optimizer/model/ECSSavingsEstimationMode.h>
#include <aws/compute-optimizer/model/ECSSavingsEstimationModeSource.h>
#include <aws/compute-optimizer/model/ECSSavingsOpportunityAfterDiscounts.h>
#include <aws/compute-optimizer/model/ECSServiceLaunchType.h>
#include <aws/compute-optimizer/model/ECSServiceMetricName.h>
#include <aws/compute-optimizer/model/ECSServiceMetricStatistic.h>
#include <aws/compute-optimizer/model/ECSServiceProjectedMetric.h>
#include <aws/compute-optimizer/model/ECSServiceProjectedUtilizationMetric.h>
#include <aws/compute-optimizer/model/ECSServiceRecommendation.h>
#include <aws/compute-optimizer/model/ECSServiceRecommendationFilter.h>
#include <aws/compute-optimizer/model/ECSServiceRecommendationFilterName.h>
#include <aws/compute-optimizer/model/ECSServiceRecommendationFinding.h>
#include <aws/compute-optimizer/model/ECSServiceRecommendationFindingReasonCode.h>
#include <aws/compute-optimizer/model/ECSServiceRecommendationOption.h>
#include <aws/compute-optimizer/model/ECSServiceRecommendedOptionProjectedMetric.h>
#include <aws/compute-optimizer/model/ECSServiceUtilizationMetric.h>
#include <aws/compute-optimizer/model/EffectivePreferredResource.h>
#include <aws/compute-optimizer/model/EffectiveRecommendationPreferences.h>
#include <aws/compute-optimizer/model/EnhancedInfrastructureMetrics.h>
#include <aws/compute-optimizer/model/EnrollmentFilter.h>
#include <aws/compute-optimizer/model/EnrollmentFilterName.h>
#include <aws/compute-optimizer/model/EstimatedMonthlySavings.h>
#include <aws/compute-optimizer/model/ExportAutoScalingGroupRecommendationsRequest.h>
#include <aws/compute-optimizer/model/ExportAutoScalingGroupRecommendationsResult.h>
#include <aws/compute-optimizer/model/ExportDestination.h>
#include <aws/compute-optimizer/model/ExportEBSVolumeRecommendationsRequest.h>
#include <aws/compute-optimizer/model/ExportEBSVolumeRecommendationsResult.h>
#include <aws/compute-optimizer/model/ExportEC2InstanceRecommendationsRequest.h>
#include <aws/compute-optimizer/model/ExportEC2InstanceRecommendationsResult.h>
#include <aws/compute-optimizer/model/ExportECSServiceRecommendationsRequest.h>
#include <aws/compute-optimizer/model/ExportECSServiceRecommendationsResult.h>
#include <aws/compute-optimizer/model/ExportIdleRecommendationsRequest.h>
#include <aws/compute-optimizer/model/ExportIdleRecommendationsResult.h>
#include <aws/compute-optimizer/model/ExportLambdaFunctionRecommendationsRequest.h>
#include <aws/compute-optimizer/model/ExportLambdaFunctionRecommendationsResult.h>
#include <aws/compute-optimizer/model/ExportLicenseRecommendationsRequest.h>
#include <aws/compute-optimizer/model/ExportLicenseRecommendationsResult.h>
#include <aws/compute-optimizer/model/ExportRDSDatabaseRecommendationsRequest.h>
#include <aws/compute-optimizer/model/ExportRDSDatabaseRecommendationsResult.h>
#include <aws/compute-optimizer/model/ExportableAutoScalingGroupField.h>
#include <aws/compute-optimizer/model/ExportableECSServiceField.h>
#include <aws/compute-optimizer/model/ExportableIdleField.h>
#include <aws/compute-optimizer/model/ExportableInstanceField.h>
#include <aws/compute-optimizer/model/ExportableLambdaFunctionField.h>
#include <aws/compute-optimizer/model/ExportableLicenseField.h>
#include <aws/compute-optimizer/model/ExportableRDSDBField.h>
#include <aws/compute-optimizer/model/ExportableVolumeField.h>
#include <aws/compute-optimizer/model/ExternalMetricStatus.h>
#include <aws/compute-optimizer/model/ExternalMetricStatusCode.h>
#include <aws/compute-optimizer/model/ExternalMetricsPreference.h>
#include <aws/compute-optimizer/model/ExternalMetricsSource.h>
#include <aws/compute-optimizer/model/FileFormat.h>
#include <aws/compute-optimizer/model/Filter.h>
#include <aws/compute-optimizer/model/FilterName.h>
#include <aws/compute-optimizer/model/Finding.h>
#include <aws/compute-optimizer/model/FindingReasonCode.h>
#include <aws/compute-optimizer/model/GetAutoScalingGroupRecommendationsRequest.h>
#include <aws/compute-optimizer/model/GetAutoScalingGroupRecommendationsResult.h>
#include <aws/compute-optimizer/model/GetEBSVolumeRecommendationsRequest.h>
#include <aws/compute-optimizer/model/GetEBSVolumeRecommendationsResult.h>
#include <aws/compute-optimizer/model/GetEC2InstanceRecommendationsRequest.h>
#include <aws/compute-optimizer/model/GetEC2InstanceRecommendationsResult.h>
#include <aws/compute-optimizer/model/GetEC2RecommendationProjectedMetricsRequest.h>
#include <aws/compute-optimizer/model/GetEC2RecommendationProjectedMetricsResult.h>
#include <aws/compute-optimizer/model/GetECSServiceRecommendationProjectedMetricsRequest.h>
#include <aws/compute-optimizer/model/GetECSServiceRecommendationProjectedMetricsResult.h>
#include <aws/compute-optimizer/model/GetECSServiceRecommendationsRequest.h>
#include <aws/compute-optimizer/model/GetECSServiceRecommendationsResult.h>
#include <aws/compute-optimizer/model/GetEffectiveRecommendationPreferencesRequest.h>
#include <aws/compute-optimizer/model/GetEffectiveRecommendationPreferencesResult.h>
#include <aws/compute-optimizer/model/GetEnrollmentStatusRequest.h>
#include <aws/compute-optimizer/model/GetEnrollmentStatusResult.h>
#include <aws/compute-optimizer/model/GetEnrollmentStatusesForOrganizationRequest.h>
#include <aws/compute-optimizer/model/GetEnrollmentStatusesForOrganizationResult.h>
#include <aws/compute-optimizer/model/GetIdleRecommendationsRequest.h>
#include <aws/compute-optimizer/model/GetIdleRecommendationsResult.h>
#include <aws/compute-optimizer/model/GetLambdaFunctionRecommendationsRequest.h>
#include <aws/compute-optimizer/model/GetLambdaFunctionRecommendationsResult.h>
#include <aws/compute-optimizer/model/GetLicenseRecommendationsRequest.h>
#include <aws/compute-optimizer/model/GetLicenseRecommendationsResult.h>
#include <aws/compute-optimizer/model/GetRDSDatabaseRecommendationProjectedMetricsRequest.h>
#include <aws/compute-optimizer/model/GetRDSDatabaseRecommendationProjectedMetricsResult.h>
#include <aws/compute-optimizer/model/GetRDSDatabaseRecommendationsRequest.h>
#include <aws/compute-optimizer/model/GetRDSDatabaseRecommendationsResult.h>
#include <aws/compute-optimizer/model/GetRecommendationError.h>
#include <aws/compute-optimizer/model/GetRecommendationPreferencesRequest.h>
#include <aws/compute-optimizer/model/GetRecommendationPreferencesResult.h>
#include <aws/compute-optimizer/model/GetRecommendationSummariesRequest.h>
#include <aws/compute-optimizer/model/GetRecommendationSummariesResult.h>
#include <aws/compute-optimizer/model/Gpu.h>
#include <aws/compute-optimizer/model/GpuInfo.h>
#include <aws/compute-optimizer/model/Idle.h>
#include <aws/compute-optimizer/model/IdleEstimatedMonthlySavings.h>
#include <aws/compute-optimizer/model/IdleFinding.h>
#include <aws/compute-optimizer/model/IdleMetricName.h>
#include <aws/compute-optimizer/model/IdleRecommendation.h>
#include <aws/compute-optimizer/model/IdleRecommendationError.h>
#include <aws/compute-optimizer/model/IdleRecommendationFilter.h>
#include <aws/compute-optimizer/model/IdleRecommendationFilterName.h>
#include <aws/compute-optimizer/model/IdleRecommendationResourceType.h>
#include <aws/compute-optimizer/model/IdleSavingsOpportunity.h>
#include <aws/compute-optimizer/model/IdleSavingsOpportunityAfterDiscounts.h>
#include <aws/compute-optimizer/model/IdleSummary.h>
#include <aws/compute-optimizer/model/IdleUtilizationMetric.h>
#include <aws/compute-optimizer/model/InferredWorkloadSaving.h>
#include <aws/compute-optimizer/model/InferredWorkloadType.h>
#include <aws/compute-optimizer/model/InferredWorkloadTypesPreference.h>
#include <aws/compute-optimizer/model/InstanceEstimatedMonthlySavings.h>
#include <aws/compute-optimizer/model/InstanceIdle.h>
#include <aws/compute-optimizer/model/InstanceRecommendation.h>
#include <aws/compute-optimizer/model/InstanceRecommendationFindingReasonCode.h>
#include <aws/compute-optimizer/model/InstanceRecommendationOption.h>
#include <aws/compute-optimizer/model/InstanceSavingsEstimationMode.h>
#include <aws/compute-optimizer/model/InstanceSavingsEstimationModeSource.h>
#include <aws/compute-optimizer/model/InstanceSavingsOpportunityAfterDiscounts.h>
#include <aws/compute-optimizer/model/InstanceState.h>
#include <aws/compute-optimizer/model/JobFilter.h>
#include <aws/compute-optimizer/model/JobFilterName.h>
#include <aws/compute-optimizer/model/JobStatus.h>
#include <aws/compute-optimizer/model/LambdaEffectiveRecommendationPreferences.h>
#include <aws/compute-optimizer/model/LambdaEstimatedMonthlySavings.h>
#include <aws/compute-optimizer/model/LambdaFunctionMemoryMetricName.h>
#include <aws/compute-optimizer/model/LambdaFunctionMemoryMetricStatistic.h>
#include <aws/compute-optimizer/model/LambdaFunctionMemoryProjectedMetric.h>
#include <aws/compute-optimizer/model/LambdaFunctionMemoryRecommendationOption.h>
#include <aws/compute-optimizer/model/LambdaFunctionMetricName.h>
#include <aws/compute-optimizer/model/LambdaFunctionMetricStatistic.h>
#include <aws/compute-optimizer/model/LambdaFunctionRecommendation.h>
#include <aws/compute-optimizer/model/LambdaFunctionRecommendationFilter.h>
#include <aws/compute-optimizer/model/LambdaFunctionRecommendationFilterName.h>
#include <aws/compute-optimizer/model/LambdaFunctionRecommendationFinding.h>
#include <aws/compute-optimizer/model/LambdaFunctionRecommendationFindingReasonCode.h>
#include <aws/compute-optimizer/model/LambdaFunctionUtilizationMetric.h>
#include <aws/compute-optimizer/model/LambdaSavingsEstimationMode.h>
#include <aws/compute-optimizer/model/LambdaSavingsEstimationModeSource.h>
#include <aws/compute-optimizer/model/LambdaSavingsOpportunityAfterDiscounts.h>
#include <aws/compute-optimizer/model/LicenseConfiguration.h>
#include <aws/compute-optimizer/model/LicenseEdition.h>
#include <aws/compute-optimizer/model/LicenseFinding.h>
#include <aws/compute-optimizer/model/LicenseFindingReasonCode.h>
#include <aws/compute-optimizer/model/LicenseModel.h>
#include <aws/compute-optimizer/model/LicenseName.h>
#include <aws/compute-optimizer/model/LicenseRecommendation.h>
#include <aws/compute-optimizer/model/LicenseRecommendationFilter.h>
#include <aws/compute-optimizer/model/LicenseRecommendationFilterName.h>
#include <aws/compute-optimizer/model/LicenseRecommendationOption.h>
#include <aws/compute-optimizer/model/LookBackPeriodPreference.h>
#include <aws/compute-optimizer/model/MemorySizeConfiguration.h>
#include <aws/compute-optimizer/model/MetricName.h>
#include <aws/compute-optimizer/model/MetricSource.h>
#include <aws/compute-optimizer/model/MetricSourceProvider.h>
#include <aws/compute-optimizer/model/MetricStatistic.h>
#include <aws/compute-optimizer/model/MigrationEffort.h>
#include <aws/compute-optimizer/model/Order.h>
#include <aws/compute-optimizer/model/OrderBy.h>
#include <aws/compute-optimizer/model/PlatformDifference.h>
#include <aws/compute-optimizer/model/PreferredResource.h>
#include <aws/compute-optimizer/model/PreferredResourceName.h>
#include <aws/compute-optimizer/model/ProjectedMetric.h>
#include <aws/compute-optimizer/model/PutRecommendationPreferencesRequest.h>
#include <aws/compute-optimizer/model/PutRecommendationPreferencesResult.h>
#include <aws/compute-optimizer/model/RDSCurrentInstancePerformanceRisk.h>
#include <aws/compute-optimizer/model/RDSDBInstanceRecommendationOption.h>
#include <aws/compute-optimizer/model/RDSDBMetricName.h>
#include <aws/compute-optimizer/model/RDSDBMetricStatistic.h>
#include <aws/compute-optimizer/model/RDSDBRecommendation.h>
#include <aws/compute-optimizer/model/RDSDBRecommendationFilter.h>
#include <aws/compute-optimizer/model/RDSDBRecommendationFilterName.h>
#include <aws/compute-optimizer/model/RDSDBStorageRecommendationOption.h>
#include <aws/compute-optimizer/model/RDSDBUtilizationMetric.h>
#include <aws/compute-optimizer/model/RDSDatabaseProjectedMetric.h>
#include <aws/compute-optimizer/model/RDSDatabaseRecommendedOptionProjectedMetric.h>
#include <aws/compute-optimizer/model/RDSEffectiveRecommendationPreferences.h>
#include <aws/compute-optimizer/model/RDSEstimatedMonthlyVolumeIOPsCostVariation.h>
#include <aws/compute-optimizer/model/RDSInstanceEstimatedMonthlySavings.h>
#include <aws/compute-optimizer/model/RDSInstanceFinding.h>
#include <aws/compute-optimizer/model/RDSInstanceFindingReasonCode.h>
#include <aws/compute-optimizer/model/RDSInstanceSavingsOpportunityAfterDiscounts.h>
#include <aws/compute-optimizer/model/RDSSavingsEstimationMode.h>
#include <aws/compute-optimizer/model/RDSSavingsEstimationModeSource.h>
#include <aws/compute-optimizer/model/RDSStorageEstimatedMonthlySavings.h>
#include <aws/compute-optimizer/model/RDSStorageFinding.h>
#include <aws/compute-optimizer/model/RDSStorageFindingReasonCode.h>
#include <aws/compute-optimizer/model/RDSStorageSavingsOpportunityAfterDiscounts.h>
#include <aws/compute-optimizer/model/ReasonCodeSummary.h>
#include <aws/compute-optimizer/model/RecommendationExportJob.h>
#include <aws/compute-optimizer/model/RecommendationPreferenceName.h>
#include <aws/compute-optimizer/model/RecommendationPreferences.h>
#include <aws/compute-optimizer/model/RecommendationPreferencesDetail.h>
#include <aws/compute-optimizer/model/RecommendationSource.h>
#include <aws/compute-optimizer/model/RecommendationSourceType.h>
#include <aws/compute-optimizer/model/RecommendationSummary.h>
#include <aws/compute-optimizer/model/RecommendedOptionProjectedMetric.h>
#include <aws/compute-optimizer/model/ResourceType.h>
#include <aws/compute-optimizer/model/S3Destination.h>
#include <aws/compute-optimizer/model/S3DestinationConfig.h>
#include <aws/compute-optimizer/model/SavingsEstimationMode.h>
#include <aws/compute-optimizer/model/SavingsOpportunity.h>
#include <aws/compute-optimizer/model/Scope.h>
#include <aws/compute-optimizer/model/ScopeName.h>
#include <aws/compute-optimizer/model/ServiceConfiguration.h>
#include <aws/compute-optimizer/model/Status.h>
#include <aws/compute-optimizer/model/Summary.h>
#include <aws/compute-optimizer/model/Tag.h>
#include <aws/compute-optimizer/model/UpdateEnrollmentStatusRequest.h>
#include <aws/compute-optimizer/model/UpdateEnrollmentStatusResult.h>
#include <aws/compute-optimizer/model/UtilizationMetric.h>
#include <aws/compute-optimizer/model/UtilizationPreference.h>
#include <aws/compute-optimizer/model/VolumeConfiguration.h>
#include <aws/compute-optimizer/model/VolumeRecommendation.h>
#include <aws/compute-optimizer/model/VolumeRecommendationOption.h>

using ComputeOptimizerIncludeTest = ::testing::Test;

TEST_F(ComputeOptimizerIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::ComputeOptimizer::ComputeOptimizerClient>("ComputeOptimizerIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
