/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/config/ConfigServiceClient.h>
#include <aws/config/ConfigServiceEndpointProvider.h>
#include <aws/config/ConfigServiceEndpointRules.h>
#include <aws/config/ConfigServiceErrorMarshaller.h>
#include <aws/config/ConfigServiceErrors.h>
#include <aws/config/ConfigServiceRequest.h>
#include <aws/config/ConfigServiceServiceClientModel.h>
#include <aws/config/ConfigService_EXPORTS.h>
#include <aws/config/model/AccountAggregationSource.h>
#include <aws/config/model/AggregateComplianceByConfigRule.h>
#include <aws/config/model/AggregateComplianceByConformancePack.h>
#include <aws/config/model/AggregateComplianceCount.h>
#include <aws/config/model/AggregateConformancePackCompliance.h>
#include <aws/config/model/AggregateConformancePackComplianceCount.h>
#include <aws/config/model/AggregateConformancePackComplianceFilters.h>
#include <aws/config/model/AggregateConformancePackComplianceSummary.h>
#include <aws/config/model/AggregateConformancePackComplianceSummaryFilters.h>
#include <aws/config/model/AggregateConformancePackComplianceSummaryGroupKey.h>
#include <aws/config/model/AggregateEvaluationResult.h>
#include <aws/config/model/AggregateResourceIdentifier.h>
#include <aws/config/model/AggregatedSourceStatus.h>
#include <aws/config/model/AggregatedSourceStatusType.h>
#include <aws/config/model/AggregatedSourceType.h>
#include <aws/config/model/AggregationAuthorization.h>
#include <aws/config/model/AggregatorFilterResourceType.h>
#include <aws/config/model/AggregatorFilterServicePrincipal.h>
#include <aws/config/model/AggregatorFilterType.h>
#include <aws/config/model/AggregatorFilters.h>
#include <aws/config/model/AssociateResourceTypesRequest.h>
#include <aws/config/model/AssociateResourceTypesResult.h>
#include <aws/config/model/BaseConfigurationItem.h>
#include <aws/config/model/BatchGetAggregateResourceConfigRequest.h>
#include <aws/config/model/BatchGetAggregateResourceConfigResult.h>
#include <aws/config/model/BatchGetResourceConfigRequest.h>
#include <aws/config/model/BatchGetResourceConfigResult.h>
#include <aws/config/model/ChronologicalOrder.h>
#include <aws/config/model/Compliance.h>
#include <aws/config/model/ComplianceByConfigRule.h>
#include <aws/config/model/ComplianceByResource.h>
#include <aws/config/model/ComplianceContributorCount.h>
#include <aws/config/model/ComplianceSummary.h>
#include <aws/config/model/ComplianceSummaryByResourceType.h>
#include <aws/config/model/ComplianceType.h>
#include <aws/config/model/ConfigExportDeliveryInfo.h>
#include <aws/config/model/ConfigRule.h>
#include <aws/config/model/ConfigRuleComplianceFilters.h>
#include <aws/config/model/ConfigRuleComplianceSummaryFilters.h>
#include <aws/config/model/ConfigRuleComplianceSummaryGroupKey.h>
#include <aws/config/model/ConfigRuleEvaluationStatus.h>
#include <aws/config/model/ConfigRuleState.h>
#include <aws/config/model/ConfigSnapshotDeliveryProperties.h>
#include <aws/config/model/ConfigStreamDeliveryInfo.h>
#include <aws/config/model/ConfigurationAggregator.h>
#include <aws/config/model/ConfigurationItem.h>
#include <aws/config/model/ConfigurationItemStatus.h>
#include <aws/config/model/ConfigurationRecorder.h>
#include <aws/config/model/ConfigurationRecorderFilter.h>
#include <aws/config/model/ConfigurationRecorderFilterName.h>
#include <aws/config/model/ConfigurationRecorderStatus.h>
#include <aws/config/model/ConfigurationRecorderSummary.h>
#include <aws/config/model/ConformancePackComplianceFilters.h>
#include <aws/config/model/ConformancePackComplianceScore.h>
#include <aws/config/model/ConformancePackComplianceScoresFilters.h>
#include <aws/config/model/ConformancePackComplianceSummary.h>
#include <aws/config/model/ConformancePackComplianceType.h>
#include <aws/config/model/ConformancePackDetail.h>
#include <aws/config/model/ConformancePackEvaluationFilters.h>
#include <aws/config/model/ConformancePackEvaluationResult.h>
#include <aws/config/model/ConformancePackInputParameter.h>
#include <aws/config/model/ConformancePackRuleCompliance.h>
#include <aws/config/model/ConformancePackState.h>
#include <aws/config/model/ConformancePackStatusDetail.h>
#include <aws/config/model/CustomPolicyDetails.h>
#include <aws/config/model/DeleteAggregationAuthorizationRequest.h>
#include <aws/config/model/DeleteConfigRuleRequest.h>
#include <aws/config/model/DeleteConfigurationAggregatorRequest.h>
#include <aws/config/model/DeleteConfigurationRecorderRequest.h>
#include <aws/config/model/DeleteConformancePackRequest.h>
#include <aws/config/model/DeleteDeliveryChannelRequest.h>
#include <aws/config/model/DeleteEvaluationResultsRequest.h>
#include <aws/config/model/DeleteEvaluationResultsResult.h>
#include <aws/config/model/DeleteOrganizationConfigRuleRequest.h>
#include <aws/config/model/DeleteOrganizationConformancePackRequest.h>
#include <aws/config/model/DeletePendingAggregationRequestRequest.h>
#include <aws/config/model/DeleteRemediationConfigurationRequest.h>
#include <aws/config/model/DeleteRemediationConfigurationResult.h>
#include <aws/config/model/DeleteRemediationExceptionsRequest.h>
#include <aws/config/model/DeleteRemediationExceptionsResult.h>
#include <aws/config/model/DeleteResourceConfigRequest.h>
#include <aws/config/model/DeleteRetentionConfigurationRequest.h>
#include <aws/config/model/DeleteServiceLinkedConfigurationRecorderRequest.h>
#include <aws/config/model/DeleteServiceLinkedConfigurationRecorderResult.h>
#include <aws/config/model/DeleteStoredQueryRequest.h>
#include <aws/config/model/DeleteStoredQueryResult.h>
#include <aws/config/model/DeliverConfigSnapshotRequest.h>
#include <aws/config/model/DeliverConfigSnapshotResult.h>
#include <aws/config/model/DeliveryChannel.h>
#include <aws/config/model/DeliveryChannelStatus.h>
#include <aws/config/model/DeliveryStatus.h>
#include <aws/config/model/DescribeAggregateComplianceByConfigRulesRequest.h>
#include <aws/config/model/DescribeAggregateComplianceByConfigRulesResult.h>
#include <aws/config/model/DescribeAggregateComplianceByConformancePacksRequest.h>
#include <aws/config/model/DescribeAggregateComplianceByConformancePacksResult.h>
#include <aws/config/model/DescribeAggregationAuthorizationsRequest.h>
#include <aws/config/model/DescribeAggregationAuthorizationsResult.h>
#include <aws/config/model/DescribeComplianceByConfigRuleRequest.h>
#include <aws/config/model/DescribeComplianceByConfigRuleResult.h>
#include <aws/config/model/DescribeComplianceByResourceRequest.h>
#include <aws/config/model/DescribeComplianceByResourceResult.h>
#include <aws/config/model/DescribeConfigRuleEvaluationStatusRequest.h>
#include <aws/config/model/DescribeConfigRuleEvaluationStatusResult.h>
#include <aws/config/model/DescribeConfigRulesFilters.h>
#include <aws/config/model/DescribeConfigRulesRequest.h>
#include <aws/config/model/DescribeConfigRulesResult.h>
#include <aws/config/model/DescribeConfigurationAggregatorSourcesStatusRequest.h>
#include <aws/config/model/DescribeConfigurationAggregatorSourcesStatusResult.h>
#include <aws/config/model/DescribeConfigurationAggregatorsRequest.h>
#include <aws/config/model/DescribeConfigurationAggregatorsResult.h>
#include <aws/config/model/DescribeConfigurationRecorderStatusRequest.h>
#include <aws/config/model/DescribeConfigurationRecorderStatusResult.h>
#include <aws/config/model/DescribeConfigurationRecordersRequest.h>
#include <aws/config/model/DescribeConfigurationRecordersResult.h>
#include <aws/config/model/DescribeConformancePackComplianceRequest.h>
#include <aws/config/model/DescribeConformancePackComplianceResult.h>
#include <aws/config/model/DescribeConformancePackStatusRequest.h>
#include <aws/config/model/DescribeConformancePackStatusResult.h>
#include <aws/config/model/DescribeConformancePacksRequest.h>
#include <aws/config/model/DescribeConformancePacksResult.h>
#include <aws/config/model/DescribeDeliveryChannelStatusRequest.h>
#include <aws/config/model/DescribeDeliveryChannelStatusResult.h>
#include <aws/config/model/DescribeDeliveryChannelsRequest.h>
#include <aws/config/model/DescribeDeliveryChannelsResult.h>
#include <aws/config/model/DescribeOrganizationConfigRuleStatusesRequest.h>
#include <aws/config/model/DescribeOrganizationConfigRuleStatusesResult.h>
#include <aws/config/model/DescribeOrganizationConfigRulesRequest.h>
#include <aws/config/model/DescribeOrganizationConfigRulesResult.h>
#include <aws/config/model/DescribeOrganizationConformancePackStatusesRequest.h>
#include <aws/config/model/DescribeOrganizationConformancePackStatusesResult.h>
#include <aws/config/model/DescribeOrganizationConformancePacksRequest.h>
#include <aws/config/model/DescribeOrganizationConformancePacksResult.h>
#include <aws/config/model/DescribePendingAggregationRequestsRequest.h>
#include <aws/config/model/DescribePendingAggregationRequestsResult.h>
#include <aws/config/model/DescribeRemediationConfigurationsRequest.h>
#include <aws/config/model/DescribeRemediationConfigurationsResult.h>
#include <aws/config/model/DescribeRemediationExceptionsRequest.h>
#include <aws/config/model/DescribeRemediationExceptionsResult.h>
#include <aws/config/model/DescribeRemediationExecutionStatusRequest.h>
#include <aws/config/model/DescribeRemediationExecutionStatusResult.h>
#include <aws/config/model/DescribeRetentionConfigurationsRequest.h>
#include <aws/config/model/DescribeRetentionConfigurationsResult.h>
#include <aws/config/model/DisassociateResourceTypesRequest.h>
#include <aws/config/model/DisassociateResourceTypesResult.h>
#include <aws/config/model/Evaluation.h>
#include <aws/config/model/EvaluationContext.h>
#include <aws/config/model/EvaluationMode.h>
#include <aws/config/model/EvaluationModeConfiguration.h>
#include <aws/config/model/EvaluationResult.h>
#include <aws/config/model/EvaluationResultIdentifier.h>
#include <aws/config/model/EvaluationResultQualifier.h>
#include <aws/config/model/EvaluationStatus.h>
#include <aws/config/model/EventSource.h>
#include <aws/config/model/ExclusionByResourceTypes.h>
#include <aws/config/model/ExecutionControls.h>
#include <aws/config/model/ExternalEvaluation.h>
#include <aws/config/model/FailedDeleteRemediationExceptionsBatch.h>
#include <aws/config/model/FailedRemediationBatch.h>
#include <aws/config/model/FailedRemediationExceptionBatch.h>
#include <aws/config/model/FieldInfo.h>
#include <aws/config/model/GetAggregateComplianceDetailsByConfigRuleRequest.h>
#include <aws/config/model/GetAggregateComplianceDetailsByConfigRuleResult.h>
#include <aws/config/model/GetAggregateConfigRuleComplianceSummaryRequest.h>
#include <aws/config/model/GetAggregateConfigRuleComplianceSummaryResult.h>
#include <aws/config/model/GetAggregateConformancePackComplianceSummaryRequest.h>
#include <aws/config/model/GetAggregateConformancePackComplianceSummaryResult.h>
#include <aws/config/model/GetAggregateDiscoveredResourceCountsRequest.h>
#include <aws/config/model/GetAggregateDiscoveredResourceCountsResult.h>
#include <aws/config/model/GetAggregateResourceConfigRequest.h>
#include <aws/config/model/GetAggregateResourceConfigResult.h>
#include <aws/config/model/GetComplianceDetailsByConfigRuleRequest.h>
#include <aws/config/model/GetComplianceDetailsByConfigRuleResult.h>
#include <aws/config/model/GetComplianceDetailsByResourceRequest.h>
#include <aws/config/model/GetComplianceDetailsByResourceResult.h>
#include <aws/config/model/GetComplianceSummaryByConfigRuleRequest.h>
#include <aws/config/model/GetComplianceSummaryByConfigRuleResult.h>
#include <aws/config/model/GetComplianceSummaryByResourceTypeRequest.h>
#include <aws/config/model/GetComplianceSummaryByResourceTypeResult.h>
#include <aws/config/model/GetConformancePackComplianceDetailsRequest.h>
#include <aws/config/model/GetConformancePackComplianceDetailsResult.h>
#include <aws/config/model/GetConformancePackComplianceSummaryRequest.h>
#include <aws/config/model/GetConformancePackComplianceSummaryResult.h>
#include <aws/config/model/GetCustomRulePolicyRequest.h>
#include <aws/config/model/GetCustomRulePolicyResult.h>
#include <aws/config/model/GetDiscoveredResourceCountsRequest.h>
#include <aws/config/model/GetDiscoveredResourceCountsResult.h>
#include <aws/config/model/GetOrganizationConfigRuleDetailedStatusRequest.h>
#include <aws/config/model/GetOrganizationConfigRuleDetailedStatusResult.h>
#include <aws/config/model/GetOrganizationConformancePackDetailedStatusRequest.h>
#include <aws/config/model/GetOrganizationConformancePackDetailedStatusResult.h>
#include <aws/config/model/GetOrganizationCustomRulePolicyRequest.h>
#include <aws/config/model/GetOrganizationCustomRulePolicyResult.h>
#include <aws/config/model/GetResourceConfigHistoryRequest.h>
#include <aws/config/model/GetResourceConfigHistoryResult.h>
#include <aws/config/model/GetResourceEvaluationSummaryRequest.h>
#include <aws/config/model/GetResourceEvaluationSummaryResult.h>
#include <aws/config/model/GetStoredQueryRequest.h>
#include <aws/config/model/GetStoredQueryResult.h>
#include <aws/config/model/GroupedResourceCount.h>
#include <aws/config/model/ListAggregateDiscoveredResourcesRequest.h>
#include <aws/config/model/ListAggregateDiscoveredResourcesResult.h>
#include <aws/config/model/ListConfigurationRecordersRequest.h>
#include <aws/config/model/ListConfigurationRecordersResult.h>
#include <aws/config/model/ListConformancePackComplianceScoresRequest.h>
#include <aws/config/model/ListConformancePackComplianceScoresResult.h>
#include <aws/config/model/ListDiscoveredResourcesRequest.h>
#include <aws/config/model/ListDiscoveredResourcesResult.h>
#include <aws/config/model/ListResourceEvaluationsRequest.h>
#include <aws/config/model/ListResourceEvaluationsResult.h>
#include <aws/config/model/ListStoredQueriesRequest.h>
#include <aws/config/model/ListStoredQueriesResult.h>
#include <aws/config/model/ListTagsForResourceRequest.h>
#include <aws/config/model/ListTagsForResourceResult.h>
#include <aws/config/model/MaximumExecutionFrequency.h>
#include <aws/config/model/MemberAccountRuleStatus.h>
#include <aws/config/model/MemberAccountStatus.h>
#include <aws/config/model/MessageType.h>
#include <aws/config/model/OrganizationAggregationSource.h>
#include <aws/config/model/OrganizationConfigRule.h>
#include <aws/config/model/OrganizationConfigRuleStatus.h>
#include <aws/config/model/OrganizationConfigRuleTriggerType.h>
#include <aws/config/model/OrganizationConfigRuleTriggerTypeNoSN.h>
#include <aws/config/model/OrganizationConformancePack.h>
#include <aws/config/model/OrganizationConformancePackDetailedStatus.h>
#include <aws/config/model/OrganizationConformancePackStatus.h>
#include <aws/config/model/OrganizationCustomPolicyRuleMetadata.h>
#include <aws/config/model/OrganizationCustomPolicyRuleMetadataNoPolicy.h>
#include <aws/config/model/OrganizationCustomRuleMetadata.h>
#include <aws/config/model/OrganizationManagedRuleMetadata.h>
#include <aws/config/model/OrganizationResourceDetailedStatus.h>
#include <aws/config/model/OrganizationResourceDetailedStatusFilters.h>
#include <aws/config/model/OrganizationResourceStatus.h>
#include <aws/config/model/OrganizationRuleStatus.h>
#include <aws/config/model/Owner.h>
#include <aws/config/model/PendingAggregationRequest.h>
#include <aws/config/model/PutAggregationAuthorizationRequest.h>
#include <aws/config/model/PutAggregationAuthorizationResult.h>
#include <aws/config/model/PutConfigRuleRequest.h>
#include <aws/config/model/PutConfigurationAggregatorRequest.h>
#include <aws/config/model/PutConfigurationAggregatorResult.h>
#include <aws/config/model/PutConfigurationRecorderRequest.h>
#include <aws/config/model/PutConformancePackRequest.h>
#include <aws/config/model/PutConformancePackResult.h>
#include <aws/config/model/PutDeliveryChannelRequest.h>
#include <aws/config/model/PutEvaluationsRequest.h>
#include <aws/config/model/PutEvaluationsResult.h>
#include <aws/config/model/PutExternalEvaluationRequest.h>
#include <aws/config/model/PutExternalEvaluationResult.h>
#include <aws/config/model/PutOrganizationConfigRuleRequest.h>
#include <aws/config/model/PutOrganizationConfigRuleResult.h>
#include <aws/config/model/PutOrganizationConformancePackRequest.h>
#include <aws/config/model/PutOrganizationConformancePackResult.h>
#include <aws/config/model/PutRemediationConfigurationsRequest.h>
#include <aws/config/model/PutRemediationConfigurationsResult.h>
#include <aws/config/model/PutRemediationExceptionsRequest.h>
#include <aws/config/model/PutRemediationExceptionsResult.h>
#include <aws/config/model/PutResourceConfigRequest.h>
#include <aws/config/model/PutRetentionConfigurationRequest.h>
#include <aws/config/model/PutRetentionConfigurationResult.h>
#include <aws/config/model/PutServiceLinkedConfigurationRecorderRequest.h>
#include <aws/config/model/PutServiceLinkedConfigurationRecorderResult.h>
#include <aws/config/model/PutStoredQueryRequest.h>
#include <aws/config/model/PutStoredQueryResult.h>
#include <aws/config/model/QueryInfo.h>
#include <aws/config/model/RecorderStatus.h>
#include <aws/config/model/RecordingFrequency.h>
#include <aws/config/model/RecordingGroup.h>
#include <aws/config/model/RecordingMode.h>
#include <aws/config/model/RecordingModeOverride.h>
#include <aws/config/model/RecordingScope.h>
#include <aws/config/model/RecordingStrategy.h>
#include <aws/config/model/RecordingStrategyType.h>
#include <aws/config/model/Relationship.h>
#include <aws/config/model/RemediationConfiguration.h>
#include <aws/config/model/RemediationException.h>
#include <aws/config/model/RemediationExceptionResourceKey.h>
#include <aws/config/model/RemediationExecutionState.h>
#include <aws/config/model/RemediationExecutionStatus.h>
#include <aws/config/model/RemediationExecutionStep.h>
#include <aws/config/model/RemediationExecutionStepState.h>
#include <aws/config/model/RemediationParameterValue.h>
#include <aws/config/model/RemediationTargetType.h>
#include <aws/config/model/ResourceConfigurationSchemaType.h>
#include <aws/config/model/ResourceCount.h>
#include <aws/config/model/ResourceCountFilters.h>
#include <aws/config/model/ResourceCountGroupKey.h>
#include <aws/config/model/ResourceDetails.h>
#include <aws/config/model/ResourceEvaluation.h>
#include <aws/config/model/ResourceEvaluationFilters.h>
#include <aws/config/model/ResourceEvaluationStatus.h>
#include <aws/config/model/ResourceFilters.h>
#include <aws/config/model/ResourceIdentifier.h>
#include <aws/config/model/ResourceKey.h>
#include <aws/config/model/ResourceType.h>
#include <aws/config/model/ResourceValue.h>
#include <aws/config/model/ResourceValueType.h>
#include <aws/config/model/RetentionConfiguration.h>
#include <aws/config/model/Scope.h>
#include <aws/config/model/SelectAggregateResourceConfigRequest.h>
#include <aws/config/model/SelectAggregateResourceConfigResult.h>
#include <aws/config/model/SelectResourceConfigRequest.h>
#include <aws/config/model/SelectResourceConfigResult.h>
#include <aws/config/model/SortBy.h>
#include <aws/config/model/SortOrder.h>
#include <aws/config/model/Source.h>
#include <aws/config/model/SourceDetail.h>
#include <aws/config/model/SsmControls.h>
#include <aws/config/model/StartConfigRulesEvaluationRequest.h>
#include <aws/config/model/StartConfigRulesEvaluationResult.h>
#include <aws/config/model/StartConfigurationRecorderRequest.h>
#include <aws/config/model/StartRemediationExecutionRequest.h>
#include <aws/config/model/StartRemediationExecutionResult.h>
#include <aws/config/model/StartResourceEvaluationRequest.h>
#include <aws/config/model/StartResourceEvaluationResult.h>
#include <aws/config/model/StaticValue.h>
#include <aws/config/model/StatusDetailFilters.h>
#include <aws/config/model/StopConfigurationRecorderRequest.h>
#include <aws/config/model/StoredQuery.h>
#include <aws/config/model/StoredQueryMetadata.h>
#include <aws/config/model/Tag.h>
#include <aws/config/model/TagResourceRequest.h>
#include <aws/config/model/TemplateSSMDocumentDetails.h>
#include <aws/config/model/TimeWindow.h>
#include <aws/config/model/UntagResourceRequest.h>

using ConfigServiceIncludeTest = ::testing::Test;

TEST_F(ConfigServiceIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::ConfigService::ConfigServiceClient>("ConfigServiceIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
