/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/connect/ConnectClient.h>
#include <aws/connect/ConnectEndpointProvider.h>
#include <aws/connect/ConnectEndpointRules.h>
#include <aws/connect/ConnectErrorMarshaller.h>
#include <aws/connect/ConnectErrors.h>
#include <aws/connect/ConnectRequest.h>
#include <aws/connect/ConnectServiceClientModel.h>
#include <aws/connect/Connect_EXPORTS.h>
#include <aws/connect/model/ActionSummary.h>
#include <aws/connect/model/ActionType.h>
#include <aws/connect/model/ActivateEvaluationFormRequest.h>
#include <aws/connect/model/ActivateEvaluationFormResult.h>
#include <aws/connect/model/AdditionalEmailRecipients.h>
#include <aws/connect/model/AgentAvailabilityTimer.h>
#include <aws/connect/model/AgentConfig.h>
#include <aws/connect/model/AgentContactReference.h>
#include <aws/connect/model/AgentHierarchyGroup.h>
#include <aws/connect/model/AgentHierarchyGroups.h>
#include <aws/connect/model/AgentInfo.h>
#include <aws/connect/model/AgentQualityMetrics.h>
#include <aws/connect/model/AgentStatus.h>
#include <aws/connect/model/AgentStatusReference.h>
#include <aws/connect/model/AgentStatusSearchCriteria.h>
#include <aws/connect/model/AgentStatusSearchFilter.h>
#include <aws/connect/model/AgentStatusState.h>
#include <aws/connect/model/AgentStatusSummary.h>
#include <aws/connect/model/AgentStatusType.h>
#include <aws/connect/model/AgentsCriteria.h>
#include <aws/connect/model/AllowedCapabilities.h>
#include <aws/connect/model/AnalyticsDataAssociationResult.h>
#include <aws/connect/model/AnalyticsDataSetsResult.h>
#include <aws/connect/model/AnswerMachineDetectionConfig.h>
#include <aws/connect/model/AnsweringMachineDetectionStatus.h>
#include <aws/connect/model/Application.h>
#include <aws/connect/model/ArtifactStatus.h>
#include <aws/connect/model/AssignContactCategoryActionDefinition.h>
#include <aws/connect/model/AssignSlaActionDefinition.h>
#include <aws/connect/model/AssociateAnalyticsDataSetRequest.h>
#include <aws/connect/model/AssociateAnalyticsDataSetResult.h>
#include <aws/connect/model/AssociateApprovedOriginRequest.h>
#include <aws/connect/model/AssociateBotRequest.h>
#include <aws/connect/model/AssociateDefaultVocabularyRequest.h>
#include <aws/connect/model/AssociateDefaultVocabularyResult.h>
#include <aws/connect/model/AssociateFlowRequest.h>
#include <aws/connect/model/AssociateFlowResult.h>
#include <aws/connect/model/AssociateInstanceStorageConfigRequest.h>
#include <aws/connect/model/AssociateInstanceStorageConfigResult.h>
#include <aws/connect/model/AssociateLambdaFunctionRequest.h>
#include <aws/connect/model/AssociateLexBotRequest.h>
#include <aws/connect/model/AssociatePhoneNumberContactFlowRequest.h>
#include <aws/connect/model/AssociateQueueQuickConnectsRequest.h>
#include <aws/connect/model/AssociateRoutingProfileQueuesRequest.h>
#include <aws/connect/model/AssociateSecurityKeyRequest.h>
#include <aws/connect/model/AssociateSecurityKeyResult.h>
#include <aws/connect/model/AssociateTrafficDistributionGroupUserRequest.h>
#include <aws/connect/model/AssociateTrafficDistributionGroupUserResult.h>
#include <aws/connect/model/AssociateUserProficienciesRequest.h>
#include <aws/connect/model/AssociatedContactSummary.h>
#include <aws/connect/model/AttachedFile.h>
#include <aws/connect/model/AttachedFileError.h>
#include <aws/connect/model/AttachedFileInvalidRequestExceptionReason.h>
#include <aws/connect/model/AttachedFileServiceQuotaExceededExceptionReason.h>
#include <aws/connect/model/AttachmentReference.h>
#include <aws/connect/model/Attendee.h>
#include <aws/connect/model/Attribute.h>
#include <aws/connect/model/AttributeAndCondition.h>
#include <aws/connect/model/AttributeCondition.h>
#include <aws/connect/model/AudioFeatures.h>
#include <aws/connect/model/AudioQualityMetricsInfo.h>
#include <aws/connect/model/AuthenticationProfile.h>
#include <aws/connect/model/AuthenticationProfileSummary.h>
#include <aws/connect/model/AvailableNumberSummary.h>
#include <aws/connect/model/BatchAssociateAnalyticsDataSetRequest.h>
#include <aws/connect/model/BatchAssociateAnalyticsDataSetResult.h>
#include <aws/connect/model/BatchDisassociateAnalyticsDataSetRequest.h>
#include <aws/connect/model/BatchDisassociateAnalyticsDataSetResult.h>
#include <aws/connect/model/BatchGetAttachedFileMetadataRequest.h>
#include <aws/connect/model/BatchGetAttachedFileMetadataResult.h>
#include <aws/connect/model/BatchGetFlowAssociationRequest.h>
#include <aws/connect/model/BatchGetFlowAssociationResult.h>
#include <aws/connect/model/BatchPutContactRequest.h>
#include <aws/connect/model/BatchPutContactResult.h>
#include <aws/connect/model/BehaviorType.h>
#include <aws/connect/model/Campaign.h>
#include <aws/connect/model/CaseSlaConfiguration.h>
#include <aws/connect/model/Channel.h>
#include <aws/connect/model/ChatEvent.h>
#include <aws/connect/model/ChatEventType.h>
#include <aws/connect/model/ChatMessage.h>
#include <aws/connect/model/ChatParticipantRoleConfig.h>
#include <aws/connect/model/ChatStreamingConfiguration.h>
#include <aws/connect/model/ClaimPhoneNumberRequest.h>
#include <aws/connect/model/ClaimPhoneNumberResult.h>
#include <aws/connect/model/ClaimedPhoneNumberSummary.h>
#include <aws/connect/model/CommonAttributeAndCondition.h>
#include <aws/connect/model/Comparison.h>
#include <aws/connect/model/CompleteAttachedFileUploadRequest.h>
#include <aws/connect/model/CompleteAttachedFileUploadResult.h>
#include <aws/connect/model/Condition.h>
#include <aws/connect/model/ConnectionData.h>
#include <aws/connect/model/Contact.h>
#include <aws/connect/model/ContactAnalysis.h>
#include <aws/connect/model/ContactConfiguration.h>
#include <aws/connect/model/ContactDataRequest.h>
#include <aws/connect/model/ContactDetails.h>
#include <aws/connect/model/ContactEvaluation.h>
#include <aws/connect/model/ContactFilter.h>
#include <aws/connect/model/ContactFlow.h>
#include <aws/connect/model/ContactFlowModule.h>
#include <aws/connect/model/ContactFlowModuleSearchCriteria.h>
#include <aws/connect/model/ContactFlowModuleSearchFilter.h>
#include <aws/connect/model/ContactFlowModuleState.h>
#include <aws/connect/model/ContactFlowModuleStatus.h>
#include <aws/connect/model/ContactFlowModuleSummary.h>
#include <aws/connect/model/ContactFlowSearchCriteria.h>
#include <aws/connect/model/ContactFlowSearchFilter.h>
#include <aws/connect/model/ContactFlowState.h>
#include <aws/connect/model/ContactFlowStatus.h>
#include <aws/connect/model/ContactFlowSummary.h>
#include <aws/connect/model/ContactFlowType.h>
#include <aws/connect/model/ContactFlowVersionSummary.h>
#include <aws/connect/model/ContactInitiationMethod.h>
#include <aws/connect/model/ContactRecordingType.h>
#include <aws/connect/model/ContactSearchSummary.h>
#include <aws/connect/model/ContactSearchSummaryAgentInfo.h>
#include <aws/connect/model/ContactSearchSummaryQueueInfo.h>
#include <aws/connect/model/ContactSearchSummarySegmentAttributeValue.h>
#include <aws/connect/model/ContactState.h>
#include <aws/connect/model/ControlPlaneAttributeFilter.h>
#include <aws/connect/model/ControlPlaneTagFilter.h>
#include <aws/connect/model/ControlPlaneUserAttributeFilter.h>
#include <aws/connect/model/CreateAgentStatusRequest.h>
#include <aws/connect/model/CreateAgentStatusResult.h>
#include <aws/connect/model/CreateCaseActionDefinition.h>
#include <aws/connect/model/CreateContactFlowModuleRequest.h>
#include <aws/connect/model/CreateContactFlowModuleResult.h>
#include <aws/connect/model/CreateContactFlowRequest.h>
#include <aws/connect/model/CreateContactFlowResult.h>
#include <aws/connect/model/CreateContactFlowVersionRequest.h>
#include <aws/connect/model/CreateContactFlowVersionResult.h>
#include <aws/connect/model/CreateContactRequest.h>
#include <aws/connect/model/CreateContactResult.h>
#include <aws/connect/model/CreateEmailAddressRequest.h>
#include <aws/connect/model/CreateEmailAddressResult.h>
#include <aws/connect/model/CreateEvaluationFormRequest.h>
#include <aws/connect/model/CreateEvaluationFormResult.h>
#include <aws/connect/model/CreateHoursOfOperationOverrideRequest.h>
#include <aws/connect/model/CreateHoursOfOperationOverrideResult.h>
#include <aws/connect/model/CreateHoursOfOperationRequest.h>
#include <aws/connect/model/CreateHoursOfOperationResult.h>
#include <aws/connect/model/CreateInstanceRequest.h>
#include <aws/connect/model/CreateInstanceResult.h>
#include <aws/connect/model/CreateIntegrationAssociationRequest.h>
#include <aws/connect/model/CreateIntegrationAssociationResult.h>
#include <aws/connect/model/CreateParticipantRequest.h>
#include <aws/connect/model/CreateParticipantResult.h>
#include <aws/connect/model/CreatePersistentContactAssociationRequest.h>
#include <aws/connect/model/CreatePersistentContactAssociationResult.h>
#include <aws/connect/model/CreatePredefinedAttributeRequest.h>
#include <aws/connect/model/CreatePromptRequest.h>
#include <aws/connect/model/CreatePromptResult.h>
#include <aws/connect/model/CreatePushNotificationRegistrationRequest.h>
#include <aws/connect/model/CreatePushNotificationRegistrationResult.h>
#include <aws/connect/model/CreateQueueRequest.h>
#include <aws/connect/model/CreateQueueResult.h>
#include <aws/connect/model/CreateQuickConnectRequest.h>
#include <aws/connect/model/CreateQuickConnectResult.h>
#include <aws/connect/model/CreateRoutingProfileRequest.h>
#include <aws/connect/model/CreateRoutingProfileResult.h>
#include <aws/connect/model/CreateRuleRequest.h>
#include <aws/connect/model/CreateRuleResult.h>
#include <aws/connect/model/CreateSecurityProfileRequest.h>
#include <aws/connect/model/CreateSecurityProfileResult.h>
#include <aws/connect/model/CreateTaskTemplateRequest.h>
#include <aws/connect/model/CreateTaskTemplateResult.h>
#include <aws/connect/model/CreateTrafficDistributionGroupRequest.h>
#include <aws/connect/model/CreateTrafficDistributionGroupResult.h>
#include <aws/connect/model/CreateUseCaseRequest.h>
#include <aws/connect/model/CreateUseCaseResult.h>
#include <aws/connect/model/CreateUserHierarchyGroupRequest.h>
#include <aws/connect/model/CreateUserHierarchyGroupResult.h>
#include <aws/connect/model/CreateUserRequest.h>
#include <aws/connect/model/CreateUserResult.h>
#include <aws/connect/model/CreateViewRequest.h>
#include <aws/connect/model/CreateViewResult.h>
#include <aws/connect/model/CreateViewVersionRequest.h>
#include <aws/connect/model/CreateViewVersionResult.h>
#include <aws/connect/model/CreateVocabularyRequest.h>
#include <aws/connect/model/CreateVocabularyResult.h>
#include <aws/connect/model/CreatedByInfo.h>
#include <aws/connect/model/Credentials.h>
#include <aws/connect/model/CrossChannelBehavior.h>
#include <aws/connect/model/CurrentMetric.h>
#include <aws/connect/model/CurrentMetricData.h>
#include <aws/connect/model/CurrentMetricName.h>
#include <aws/connect/model/CurrentMetricResult.h>
#include <aws/connect/model/CurrentMetricSortCriteria.h>
#include <aws/connect/model/Customer.h>
#include <aws/connect/model/CustomerQualityMetrics.h>
#include <aws/connect/model/CustomerVoiceActivity.h>
#include <aws/connect/model/DateComparisonType.h>
#include <aws/connect/model/DateCondition.h>
#include <aws/connect/model/DateReference.h>
#include <aws/connect/model/DeactivateEvaluationFormRequest.h>
#include <aws/connect/model/DeactivateEvaluationFormResult.h>
#include <aws/connect/model/DefaultVocabulary.h>
#include <aws/connect/model/DeleteAttachedFileRequest.h>
#include <aws/connect/model/DeleteAttachedFileResult.h>
#include <aws/connect/model/DeleteContactEvaluationRequest.h>
#include <aws/connect/model/DeleteContactFlowModuleRequest.h>
#include <aws/connect/model/DeleteContactFlowModuleResult.h>
#include <aws/connect/model/DeleteContactFlowRequest.h>
#include <aws/connect/model/DeleteContactFlowResult.h>
#include <aws/connect/model/DeleteContactFlowVersionRequest.h>
#include <aws/connect/model/DeleteContactFlowVersionResult.h>
#include <aws/connect/model/DeleteEmailAddressRequest.h>
#include <aws/connect/model/DeleteEmailAddressResult.h>
#include <aws/connect/model/DeleteEvaluationFormRequest.h>
#include <aws/connect/model/DeleteHoursOfOperationOverrideRequest.h>
#include <aws/connect/model/DeleteHoursOfOperationRequest.h>
#include <aws/connect/model/DeleteInstanceRequest.h>
#include <aws/connect/model/DeleteIntegrationAssociationRequest.h>
#include <aws/connect/model/DeletePredefinedAttributeRequest.h>
#include <aws/connect/model/DeletePromptRequest.h>
#include <aws/connect/model/DeletePushNotificationRegistrationRequest.h>
#include <aws/connect/model/DeletePushNotificationRegistrationResult.h>
#include <aws/connect/model/DeleteQueueRequest.h>
#include <aws/connect/model/DeleteQuickConnectRequest.h>
#include <aws/connect/model/DeleteRoutingProfileRequest.h>
#include <aws/connect/model/DeleteRuleRequest.h>
#include <aws/connect/model/DeleteSecurityProfileRequest.h>
#include <aws/connect/model/DeleteTaskTemplateRequest.h>
#include <aws/connect/model/DeleteTaskTemplateResult.h>
#include <aws/connect/model/DeleteTrafficDistributionGroupRequest.h>
#include <aws/connect/model/DeleteTrafficDistributionGroupResult.h>
#include <aws/connect/model/DeleteUseCaseRequest.h>
#include <aws/connect/model/DeleteUserHierarchyGroupRequest.h>
#include <aws/connect/model/DeleteUserRequest.h>
#include <aws/connect/model/DeleteViewRequest.h>
#include <aws/connect/model/DeleteViewResult.h>
#include <aws/connect/model/DeleteViewVersionRequest.h>
#include <aws/connect/model/DeleteViewVersionResult.h>
#include <aws/connect/model/DeleteVocabularyRequest.h>
#include <aws/connect/model/DeleteVocabularyResult.h>
#include <aws/connect/model/DescribeAgentStatusRequest.h>
#include <aws/connect/model/DescribeAgentStatusResult.h>
#include <aws/connect/model/DescribeAuthenticationProfileRequest.h>
#include <aws/connect/model/DescribeAuthenticationProfileResult.h>
#include <aws/connect/model/DescribeContactEvaluationRequest.h>
#include <aws/connect/model/DescribeContactEvaluationResult.h>
#include <aws/connect/model/DescribeContactFlowModuleRequest.h>
#include <aws/connect/model/DescribeContactFlowModuleResult.h>
#include <aws/connect/model/DescribeContactFlowRequest.h>
#include <aws/connect/model/DescribeContactFlowResult.h>
#include <aws/connect/model/DescribeContactRequest.h>
#include <aws/connect/model/DescribeContactResult.h>
#include <aws/connect/model/DescribeEmailAddressRequest.h>
#include <aws/connect/model/DescribeEmailAddressResult.h>
#include <aws/connect/model/DescribeEvaluationFormRequest.h>
#include <aws/connect/model/DescribeEvaluationFormResult.h>
#include <aws/connect/model/DescribeHoursOfOperationOverrideRequest.h>
#include <aws/connect/model/DescribeHoursOfOperationOverrideResult.h>
#include <aws/connect/model/DescribeHoursOfOperationRequest.h>
#include <aws/connect/model/DescribeHoursOfOperationResult.h>
#include <aws/connect/model/DescribeInstanceAttributeRequest.h>
#include <aws/connect/model/DescribeInstanceAttributeResult.h>
#include <aws/connect/model/DescribeInstanceRequest.h>
#include <aws/connect/model/DescribeInstanceResult.h>
#include <aws/connect/model/DescribeInstanceStorageConfigRequest.h>
#include <aws/connect/model/DescribeInstanceStorageConfigResult.h>
#include <aws/connect/model/DescribePhoneNumberRequest.h>
#include <aws/connect/model/DescribePhoneNumberResult.h>
#include <aws/connect/model/DescribePredefinedAttributeRequest.h>
#include <aws/connect/model/DescribePredefinedAttributeResult.h>
#include <aws/connect/model/DescribePromptRequest.h>
#include <aws/connect/model/DescribePromptResult.h>
#include <aws/connect/model/DescribeQueueRequest.h>
#include <aws/connect/model/DescribeQueueResult.h>
#include <aws/connect/model/DescribeQuickConnectRequest.h>
#include <aws/connect/model/DescribeQuickConnectResult.h>
#include <aws/connect/model/DescribeRoutingProfileRequest.h>
#include <aws/connect/model/DescribeRoutingProfileResult.h>
#include <aws/connect/model/DescribeRuleRequest.h>
#include <aws/connect/model/DescribeRuleResult.h>
#include <aws/connect/model/DescribeSecurityProfileRequest.h>
#include <aws/connect/model/DescribeSecurityProfileResult.h>
#include <aws/connect/model/DescribeTrafficDistributionGroupRequest.h>
#include <aws/connect/model/DescribeTrafficDistributionGroupResult.h>
#include <aws/connect/model/DescribeUserHierarchyGroupRequest.h>
#include <aws/connect/model/DescribeUserHierarchyGroupResult.h>
#include <aws/connect/model/DescribeUserHierarchyStructureRequest.h>
#include <aws/connect/model/DescribeUserHierarchyStructureResult.h>
#include <aws/connect/model/DescribeUserRequest.h>
#include <aws/connect/model/DescribeUserResult.h>
#include <aws/connect/model/DescribeViewRequest.h>
#include <aws/connect/model/DescribeViewResult.h>
#include <aws/connect/model/DescribeVocabularyRequest.h>
#include <aws/connect/model/DescribeVocabularyResult.h>
#include <aws/connect/model/DeviceInfo.h>
#include <aws/connect/model/DeviceType.h>
#include <aws/connect/model/Dimensions.h>
#include <aws/connect/model/DirectoryType.h>
#include <aws/connect/model/DisassociateAnalyticsDataSetRequest.h>
#include <aws/connect/model/DisassociateApprovedOriginRequest.h>
#include <aws/connect/model/DisassociateBotRequest.h>
#include <aws/connect/model/DisassociateFlowRequest.h>
#include <aws/connect/model/DisassociateFlowResult.h>
#include <aws/connect/model/DisassociateInstanceStorageConfigRequest.h>
#include <aws/connect/model/DisassociateLambdaFunctionRequest.h>
#include <aws/connect/model/DisassociateLexBotRequest.h>
#include <aws/connect/model/DisassociatePhoneNumberContactFlowRequest.h>
#include <aws/connect/model/DisassociateQueueQuickConnectsRequest.h>
#include <aws/connect/model/DisassociateRoutingProfileQueuesRequest.h>
#include <aws/connect/model/DisassociateSecurityKeyRequest.h>
#include <aws/connect/model/DisassociateTrafficDistributionGroupUserRequest.h>
#include <aws/connect/model/DisassociateTrafficDistributionGroupUserResult.h>
#include <aws/connect/model/DisassociateUserProficienciesRequest.h>
#include <aws/connect/model/DisconnectDetails.h>
#include <aws/connect/model/DisconnectReason.h>
#include <aws/connect/model/DismissUserContactRequest.h>
#include <aws/connect/model/DismissUserContactResult.h>
#include <aws/connect/model/Distribution.h>
#include <aws/connect/model/DownloadUrlMetadata.h>
#include <aws/connect/model/EffectiveHoursOfOperations.h>
#include <aws/connect/model/EmailAddressInfo.h>
#include <aws/connect/model/EmailAddressMetadata.h>
#include <aws/connect/model/EmailAddressSearchCriteria.h>
#include <aws/connect/model/EmailAddressSearchFilter.h>
#include <aws/connect/model/EmailAttachment.h>
#include <aws/connect/model/EmailHeaderType.h>
#include <aws/connect/model/EmailMessageReference.h>
#include <aws/connect/model/EmailRecipient.h>
#include <aws/connect/model/EmailReference.h>
#include <aws/connect/model/EmptyFieldValue.h>
#include <aws/connect/model/EncryptionConfig.h>
#include <aws/connect/model/EncryptionType.h>
#include <aws/connect/model/EndAssociatedTasksActionDefinition.h>
#include <aws/connect/model/Endpoint.h>
#include <aws/connect/model/EndpointInfo.h>
#include <aws/connect/model/EndpointType.h>
#include <aws/connect/model/ErrorResult.h>
#include <aws/connect/model/Evaluation.h>
#include <aws/connect/model/EvaluationAnswerData.h>
#include <aws/connect/model/EvaluationAnswerInput.h>
#include <aws/connect/model/EvaluationAnswerOutput.h>
#include <aws/connect/model/EvaluationForm.h>
#include <aws/connect/model/EvaluationFormContent.h>
#include <aws/connect/model/EvaluationFormItem.h>
#include <aws/connect/model/EvaluationFormNumericQuestionAutomation.h>
#include <aws/connect/model/EvaluationFormNumericQuestionOption.h>
#include <aws/connect/model/EvaluationFormNumericQuestionProperties.h>
#include <aws/connect/model/EvaluationFormQuestion.h>
#include <aws/connect/model/EvaluationFormQuestionType.h>
#include <aws/connect/model/EvaluationFormQuestionTypeProperties.h>
#include <aws/connect/model/EvaluationFormScoringMode.h>
#include <aws/connect/model/EvaluationFormScoringStatus.h>
#include <aws/connect/model/EvaluationFormScoringStrategy.h>
#include <aws/connect/model/EvaluationFormSection.h>
#include <aws/connect/model/EvaluationFormSingleSelectQuestionAutomation.h>
#include <aws/connect/model/EvaluationFormSingleSelectQuestionAutomationOption.h>
#include <aws/connect/model/EvaluationFormSingleSelectQuestionDisplayMode.h>
#include <aws/connect/model/EvaluationFormSingleSelectQuestionOption.h>
#include <aws/connect/model/EvaluationFormSingleSelectQuestionProperties.h>
#include <aws/connect/model/EvaluationFormSummary.h>
#include <aws/connect/model/EvaluationFormVersionStatus.h>
#include <aws/connect/model/EvaluationFormVersionSummary.h>
#include <aws/connect/model/EvaluationMetadata.h>
#include <aws/connect/model/EvaluationNote.h>
#include <aws/connect/model/EvaluationScore.h>
#include <aws/connect/model/EvaluationStatus.h>
#include <aws/connect/model/EvaluationSummary.h>
#include <aws/connect/model/EventBridgeActionDefinition.h>
#include <aws/connect/model/EventSourceName.h>
#include <aws/connect/model/Expiry.h>
#include <aws/connect/model/Expression.h>
#include <aws/connect/model/FailedRequest.h>
#include <aws/connect/model/FailureReasonCode.h>
#include <aws/connect/model/FieldValue.h>
#include <aws/connect/model/FieldValueUnion.h>
#include <aws/connect/model/FileStatusType.h>
#include <aws/connect/model/FileUseCaseType.h>
#include <aws/connect/model/FilterV2.h>
#include <aws/connect/model/Filters.h>
#include <aws/connect/model/FlowAssociationResourceType.h>
#include <aws/connect/model/FlowAssociationSummary.h>
#include <aws/connect/model/GetAttachedFileRequest.h>
#include <aws/connect/model/GetAttachedFileResult.h>
#include <aws/connect/model/GetContactAttributesRequest.h>
#include <aws/connect/model/GetContactAttributesResult.h>
#include <aws/connect/model/GetCurrentMetricDataRequest.h>
#include <aws/connect/model/GetCurrentMetricDataResult.h>
#include <aws/connect/model/GetCurrentUserDataRequest.h>
#include <aws/connect/model/GetCurrentUserDataResult.h>
#include <aws/connect/model/GetEffectiveHoursOfOperationsRequest.h>
#include <aws/connect/model/GetEffectiveHoursOfOperationsResult.h>
#include <aws/connect/model/GetFederationTokenRequest.h>
#include <aws/connect/model/GetFederationTokenResult.h>
#include <aws/connect/model/GetFlowAssociationRequest.h>
#include <aws/connect/model/GetFlowAssociationResult.h>
#include <aws/connect/model/GetMetricDataRequest.h>
#include <aws/connect/model/GetMetricDataResult.h>
#include <aws/connect/model/GetMetricDataV2Request.h>
#include <aws/connect/model/GetMetricDataV2Result.h>
#include <aws/connect/model/GetPromptFileRequest.h>
#include <aws/connect/model/GetPromptFileResult.h>
#include <aws/connect/model/GetTaskTemplateRequest.h>
#include <aws/connect/model/GetTaskTemplateResult.h>
#include <aws/connect/model/GetTrafficDistributionRequest.h>
#include <aws/connect/model/GetTrafficDistributionResult.h>
#include <aws/connect/model/Grouping.h>
#include <aws/connect/model/HierarchyGroup.h>
#include <aws/connect/model/HierarchyGroupCondition.h>
#include <aws/connect/model/HierarchyGroupMatchType.h>
#include <aws/connect/model/HierarchyGroupSummary.h>
#include <aws/connect/model/HierarchyGroupSummaryReference.h>
#include <aws/connect/model/HierarchyGroups.h>
#include <aws/connect/model/HierarchyLevel.h>
#include <aws/connect/model/HierarchyLevelUpdate.h>
#include <aws/connect/model/HierarchyPath.h>
#include <aws/connect/model/HierarchyPathReference.h>
#include <aws/connect/model/HierarchyStructure.h>
#include <aws/connect/model/HierarchyStructureUpdate.h>
#include <aws/connect/model/HistoricalMetric.h>
#include <aws/connect/model/HistoricalMetricData.h>
#include <aws/connect/model/HistoricalMetricName.h>
#include <aws/connect/model/HistoricalMetricResult.h>
#include <aws/connect/model/HoursOfOperation.h>
#include <aws/connect/model/HoursOfOperationConfig.h>
#include <aws/connect/model/HoursOfOperationDays.h>
#include <aws/connect/model/HoursOfOperationOverride.h>
#include <aws/connect/model/HoursOfOperationOverrideConfig.h>
#include <aws/connect/model/HoursOfOperationOverrideSearchCriteria.h>
#include <aws/connect/model/HoursOfOperationSearchCriteria.h>
#include <aws/connect/model/HoursOfOperationSearchFilter.h>
#include <aws/connect/model/HoursOfOperationSummary.h>
#include <aws/connect/model/HoursOfOperationTimeSlice.h>
#include <aws/connect/model/ImportPhoneNumberRequest.h>
#include <aws/connect/model/ImportPhoneNumberResult.h>
#include <aws/connect/model/InboundAdditionalRecipients.h>
#include <aws/connect/model/InboundEmailContent.h>
#include <aws/connect/model/InboundMessageSourceType.h>
#include <aws/connect/model/InboundRawMessage.h>
#include <aws/connect/model/InitiateAs.h>
#include <aws/connect/model/Instance.h>
#include <aws/connect/model/InstanceAttributeType.h>
#include <aws/connect/model/InstanceReplicationStatus.h>
#include <aws/connect/model/InstanceStatus.h>
#include <aws/connect/model/InstanceStatusReason.h>
#include <aws/connect/model/InstanceStorageConfig.h>
#include <aws/connect/model/InstanceStorageResourceType.h>
#include <aws/connect/model/InstanceSummary.h>
#include <aws/connect/model/IntegrationAssociationSummary.h>
#include <aws/connect/model/IntegrationType.h>
#include <aws/connect/model/IntervalDetails.h>
#include <aws/connect/model/IntervalPeriod.h>
#include <aws/connect/model/InvalidContactFlowException.h>
#include <aws/connect/model/InvalidContactFlowModuleException.h>
#include <aws/connect/model/InvalidRequestException.h>
#include <aws/connect/model/InvalidRequestExceptionReason.h>
#include <aws/connect/model/InvisibleFieldInfo.h>
#include <aws/connect/model/IvrRecordingTrack.h>
#include <aws/connect/model/KinesisFirehoseConfig.h>
#include <aws/connect/model/KinesisStreamConfig.h>
#include <aws/connect/model/KinesisVideoStreamConfig.h>
#include <aws/connect/model/LexBot.h>
#include <aws/connect/model/LexBotConfig.h>
#include <aws/connect/model/LexV2Bot.h>
#include <aws/connect/model/LexVersion.h>
#include <aws/connect/model/ListAgentStatusesRequest.h>
#include <aws/connect/model/ListAgentStatusesResult.h>
#include <aws/connect/model/ListAnalyticsDataAssociationsRequest.h>
#include <aws/connect/model/ListAnalyticsDataAssociationsResult.h>
#include <aws/connect/model/ListAnalyticsDataLakeDataSetsRequest.h>
#include <aws/connect/model/ListAnalyticsDataLakeDataSetsResult.h>
#include <aws/connect/model/ListApprovedOriginsRequest.h>
#include <aws/connect/model/ListApprovedOriginsResult.h>
#include <aws/connect/model/ListAssociatedContactsRequest.h>
#include <aws/connect/model/ListAssociatedContactsResult.h>
#include <aws/connect/model/ListAuthenticationProfilesRequest.h>
#include <aws/connect/model/ListAuthenticationProfilesResult.h>
#include <aws/connect/model/ListBotsRequest.h>
#include <aws/connect/model/ListBotsResult.h>
#include <aws/connect/model/ListCondition.h>
#include <aws/connect/model/ListContactEvaluationsRequest.h>
#include <aws/connect/model/ListContactEvaluationsResult.h>
#include <aws/connect/model/ListContactFlowModulesRequest.h>
#include <aws/connect/model/ListContactFlowModulesResult.h>
#include <aws/connect/model/ListContactFlowVersionsRequest.h>
#include <aws/connect/model/ListContactFlowVersionsResult.h>
#include <aws/connect/model/ListContactFlowsRequest.h>
#include <aws/connect/model/ListContactFlowsResult.h>
#include <aws/connect/model/ListContactReferencesRequest.h>
#include <aws/connect/model/ListContactReferencesResult.h>
#include <aws/connect/model/ListDefaultVocabulariesRequest.h>
#include <aws/connect/model/ListDefaultVocabulariesResult.h>
#include <aws/connect/model/ListEvaluationFormVersionsRequest.h>
#include <aws/connect/model/ListEvaluationFormVersionsResult.h>
#include <aws/connect/model/ListEvaluationFormsRequest.h>
#include <aws/connect/model/ListEvaluationFormsResult.h>
#include <aws/connect/model/ListFlowAssociationResourceType.h>
#include <aws/connect/model/ListFlowAssociationsRequest.h>
#include <aws/connect/model/ListFlowAssociationsResult.h>
#include <aws/connect/model/ListHoursOfOperationOverridesRequest.h>
#include <aws/connect/model/ListHoursOfOperationOverridesResult.h>
#include <aws/connect/model/ListHoursOfOperationsRequest.h>
#include <aws/connect/model/ListHoursOfOperationsResult.h>
#include <aws/connect/model/ListInstanceAttributesRequest.h>
#include <aws/connect/model/ListInstanceAttributesResult.h>
#include <aws/connect/model/ListInstanceStorageConfigsRequest.h>
#include <aws/connect/model/ListInstanceStorageConfigsResult.h>
#include <aws/connect/model/ListInstancesRequest.h>
#include <aws/connect/model/ListInstancesResult.h>
#include <aws/connect/model/ListIntegrationAssociationsRequest.h>
#include <aws/connect/model/ListIntegrationAssociationsResult.h>
#include <aws/connect/model/ListLambdaFunctionsRequest.h>
#include <aws/connect/model/ListLambdaFunctionsResult.h>
#include <aws/connect/model/ListLexBotsRequest.h>
#include <aws/connect/model/ListLexBotsResult.h>
#include <aws/connect/model/ListPhoneNumbersRequest.h>
#include <aws/connect/model/ListPhoneNumbersResult.h>
#include <aws/connect/model/ListPhoneNumbersSummary.h>
#include <aws/connect/model/ListPhoneNumbersV2Request.h>
#include <aws/connect/model/ListPhoneNumbersV2Result.h>
#include <aws/connect/model/ListPredefinedAttributesRequest.h>
#include <aws/connect/model/ListPredefinedAttributesResult.h>
#include <aws/connect/model/ListPromptsRequest.h>
#include <aws/connect/model/ListPromptsResult.h>
#include <aws/connect/model/ListQueueQuickConnectsRequest.h>
#include <aws/connect/model/ListQueueQuickConnectsResult.h>
#include <aws/connect/model/ListQueuesRequest.h>
#include <aws/connect/model/ListQueuesResult.h>
#include <aws/connect/model/ListQuickConnectsRequest.h>
#include <aws/connect/model/ListQuickConnectsResult.h>
#include <aws/connect/model/ListRealtimeContactAnalysisSegmentsV2Request.h>
#include <aws/connect/model/ListRealtimeContactAnalysisSegmentsV2Result.h>
#include <aws/connect/model/ListRoutingProfileQueuesRequest.h>
#include <aws/connect/model/ListRoutingProfileQueuesResult.h>
#include <aws/connect/model/ListRoutingProfilesRequest.h>
#include <aws/connect/model/ListRoutingProfilesResult.h>
#include <aws/connect/model/ListRulesRequest.h>
#include <aws/connect/model/ListRulesResult.h>
#include <aws/connect/model/ListSecurityKeysRequest.h>
#include <aws/connect/model/ListSecurityKeysResult.h>
#include <aws/connect/model/ListSecurityProfileApplicationsRequest.h>
#include <aws/connect/model/ListSecurityProfileApplicationsResult.h>
#include <aws/connect/model/ListSecurityProfilePermissionsRequest.h>
#include <aws/connect/model/ListSecurityProfilePermissionsResult.h>
#include <aws/connect/model/ListSecurityProfilesRequest.h>
#include <aws/connect/model/ListSecurityProfilesResult.h>
#include <aws/connect/model/ListTagsForResourceRequest.h>
#include <aws/connect/model/ListTagsForResourceResult.h>
#include <aws/connect/model/ListTaskTemplatesRequest.h>
#include <aws/connect/model/ListTaskTemplatesResult.h>
#include <aws/connect/model/ListTrafficDistributionGroupUsersRequest.h>
#include <aws/connect/model/ListTrafficDistributionGroupUsersResult.h>
#include <aws/connect/model/ListTrafficDistributionGroupsRequest.h>
#include <aws/connect/model/ListTrafficDistributionGroupsResult.h>
#include <aws/connect/model/ListUseCasesRequest.h>
#include <aws/connect/model/ListUseCasesResult.h>
#include <aws/connect/model/ListUserHierarchyGroupsRequest.h>
#include <aws/connect/model/ListUserHierarchyGroupsResult.h>
#include <aws/connect/model/ListUserProficienciesRequest.h>
#include <aws/connect/model/ListUserProficienciesResult.h>
#include <aws/connect/model/ListUsersRequest.h>
#include <aws/connect/model/ListUsersResult.h>
#include <aws/connect/model/ListViewVersionsRequest.h>
#include <aws/connect/model/ListViewVersionsResult.h>
#include <aws/connect/model/ListViewsRequest.h>
#include <aws/connect/model/ListViewsResult.h>
#include <aws/connect/model/MatchCriteria.h>
#include <aws/connect/model/MediaConcurrency.h>
#include <aws/connect/model/MediaPlacement.h>
#include <aws/connect/model/MediaStreamType.h>
#include <aws/connect/model/Meeting.h>
#include <aws/connect/model/MeetingFeatureStatus.h>
#include <aws/connect/model/MeetingFeaturesConfiguration.h>
#include <aws/connect/model/MetricDataV2.h>
#include <aws/connect/model/MetricFilterV2.h>
#include <aws/connect/model/MetricInterval.h>
#include <aws/connect/model/MetricResultV2.h>
#include <aws/connect/model/MetricV2.h>
#include <aws/connect/model/MonitorCapability.h>
#include <aws/connect/model/MonitorContactRequest.h>
#include <aws/connect/model/MonitorContactResult.h>
#include <aws/connect/model/NewSessionDetails.h>
#include <aws/connect/model/NotificationContentType.h>
#include <aws/connect/model/NotificationDeliveryType.h>
#include <aws/connect/model/NotificationRecipientType.h>
#include <aws/connect/model/NumberComparisonType.h>
#include <aws/connect/model/NumberCondition.h>
#include <aws/connect/model/NumberReference.h>
#include <aws/connect/model/NumericQuestionPropertyAutomationLabel.h>
#include <aws/connect/model/NumericQuestionPropertyValueAutomation.h>
#include <aws/connect/model/OperationalHour.h>
#include <aws/connect/model/OutboundAdditionalRecipients.h>
#include <aws/connect/model/OutboundCallerConfig.h>
#include <aws/connect/model/OutboundEmailConfig.h>
#include <aws/connect/model/OutboundEmailContent.h>
#include <aws/connect/model/OutboundMessageSourceType.h>
#include <aws/connect/model/OutboundRawMessage.h>
#include <aws/connect/model/OverrideDays.h>
#include <aws/connect/model/OverrideTimeSlice.h>
#include <aws/connect/model/ParticipantCapabilities.h>
#include <aws/connect/model/ParticipantDetails.h>
#include <aws/connect/model/ParticipantDetailsToAdd.h>
#include <aws/connect/model/ParticipantRole.h>
#include <aws/connect/model/ParticipantState.h>
#include <aws/connect/model/ParticipantTimerAction.h>
#include <aws/connect/model/ParticipantTimerConfiguration.h>
#include <aws/connect/model/ParticipantTimerType.h>
#include <aws/connect/model/ParticipantTimerValue.h>
#include <aws/connect/model/ParticipantTokenCredentials.h>
#include <aws/connect/model/ParticipantType.h>
#include <aws/connect/model/PauseContactRequest.h>
#include <aws/connect/model/PauseContactResult.h>
#include <aws/connect/model/PersistentChat.h>
#include <aws/connect/model/PhoneNumberCountryCode.h>
#include <aws/connect/model/PhoneNumberQuickConnectConfig.h>
#include <aws/connect/model/PhoneNumberStatus.h>
#include <aws/connect/model/PhoneNumberSummary.h>
#include <aws/connect/model/PhoneNumberType.h>
#include <aws/connect/model/PhoneNumberWorkflowStatus.h>
#include <aws/connect/model/PhoneType.h>
#include <aws/connect/model/PredefinedAttribute.h>
#include <aws/connect/model/PredefinedAttributeSearchCriteria.h>
#include <aws/connect/model/PredefinedAttributeSummary.h>
#include <aws/connect/model/PredefinedAttributeValues.h>
#include <aws/connect/model/ProblemDetail.h>
#include <aws/connect/model/Prompt.h>
#include <aws/connect/model/PromptSearchCriteria.h>
#include <aws/connect/model/PromptSearchFilter.h>
#include <aws/connect/model/PromptSummary.h>
#include <aws/connect/model/PropertyValidationException.h>
#include <aws/connect/model/PropertyValidationExceptionProperty.h>
#include <aws/connect/model/PropertyValidationExceptionReason.h>
#include <aws/connect/model/PutUserStatusRequest.h>
#include <aws/connect/model/PutUserStatusResult.h>
#include <aws/connect/model/QualityMetrics.h>
#include <aws/connect/model/Queue.h>
#include <aws/connect/model/QueueInfo.h>
#include <aws/connect/model/QueueInfoInput.h>
#include <aws/connect/model/QueueQuickConnectConfig.h>
#include <aws/connect/model/QueueReference.h>
#include <aws/connect/model/QueueSearchCriteria.h>
#include <aws/connect/model/QueueSearchFilter.h>
#include <aws/connect/model/QueueStatus.h>
#include <aws/connect/model/QueueSummary.h>
#include <aws/connect/model/QueueType.h>
#include <aws/connect/model/QuickConnect.h>
#include <aws/connect/model/QuickConnectConfig.h>
#include <aws/connect/model/QuickConnectSearchCriteria.h>
#include <aws/connect/model/QuickConnectSearchFilter.h>
#include <aws/connect/model/QuickConnectSummary.h>
#include <aws/connect/model/QuickConnectType.h>
#include <aws/connect/model/Range.h>
#include <aws/connect/model/ReadOnlyFieldInfo.h>
#include <aws/connect/model/RealTimeContactAnalysisAttachment.h>
#include <aws/connect/model/RealTimeContactAnalysisCategoryDetails.h>
#include <aws/connect/model/RealTimeContactAnalysisCharacterInterval.h>
#include <aws/connect/model/RealTimeContactAnalysisIssueDetected.h>
#include <aws/connect/model/RealTimeContactAnalysisOutputType.h>
#include <aws/connect/model/RealTimeContactAnalysisPointOfInterest.h>
#include <aws/connect/model/RealTimeContactAnalysisPostContactSummaryFailureCode.h>
#include <aws/connect/model/RealTimeContactAnalysisPostContactSummaryStatus.h>
#include <aws/connect/model/RealTimeContactAnalysisSegmentAttachments.h>
#include <aws/connect/model/RealTimeContactAnalysisSegmentCategories.h>
#include <aws/connect/model/RealTimeContactAnalysisSegmentEvent.h>
#include <aws/connect/model/RealTimeContactAnalysisSegmentIssues.h>
#include <aws/connect/model/RealTimeContactAnalysisSegmentPostContactSummary.h>
#include <aws/connect/model/RealTimeContactAnalysisSegmentTranscript.h>
#include <aws/connect/model/RealTimeContactAnalysisSegmentType.h>
#include <aws/connect/model/RealTimeContactAnalysisSentimentLabel.h>
#include <aws/connect/model/RealTimeContactAnalysisStatus.h>
#include <aws/connect/model/RealTimeContactAnalysisSupportedChannel.h>
#include <aws/connect/model/RealTimeContactAnalysisTimeData.h>
#include <aws/connect/model/RealTimeContactAnalysisTranscriptItemRedaction.h>
#include <aws/connect/model/RealTimeContactAnalysisTranscriptItemWithCharacterOffsets.h>
#include <aws/connect/model/RealTimeContactAnalysisTranscriptItemWithContent.h>
#include <aws/connect/model/RealtimeContactAnalysisSegment.h>
#include <aws/connect/model/RecordingInfo.h>
#include <aws/connect/model/RecordingStatus.h>
#include <aws/connect/model/Reference.h>
#include <aws/connect/model/ReferenceStatus.h>
#include <aws/connect/model/ReferenceSummary.h>
#include <aws/connect/model/ReferenceType.h>
#include <aws/connect/model/RehydrationType.h>
#include <aws/connect/model/ReleasePhoneNumberRequest.h>
#include <aws/connect/model/ReplicateInstanceRequest.h>
#include <aws/connect/model/ReplicateInstanceResult.h>
#include <aws/connect/model/ReplicationConfiguration.h>
#include <aws/connect/model/ReplicationStatusSummary.h>
#include <aws/connect/model/RequiredFieldInfo.h>
#include <aws/connect/model/ResourceInUseException.h>
#include <aws/connect/model/ResourceTagsSearchCriteria.h>
#include <aws/connect/model/ResourceType.h>
#include <aws/connect/model/ResumeContactRecordingRequest.h>
#include <aws/connect/model/ResumeContactRecordingResult.h>
#include <aws/connect/model/ResumeContactRequest.h>
#include <aws/connect/model/ResumeContactResult.h>
#include <aws/connect/model/RoutingCriteria.h>
#include <aws/connect/model/RoutingCriteriaInput.h>
#include <aws/connect/model/RoutingCriteriaInputStep.h>
#include <aws/connect/model/RoutingCriteriaInputStepExpiry.h>
#include <aws/connect/model/RoutingCriteriaStepStatus.h>
#include <aws/connect/model/RoutingProfile.h>
#include <aws/connect/model/RoutingProfileQueueConfig.h>
#include <aws/connect/model/RoutingProfileQueueConfigSummary.h>
#include <aws/connect/model/RoutingProfileQueueReference.h>
#include <aws/connect/model/RoutingProfileReference.h>
#include <aws/connect/model/RoutingProfileSearchCriteria.h>
#include <aws/connect/model/RoutingProfileSearchFilter.h>
#include <aws/connect/model/RoutingProfileSummary.h>
#include <aws/connect/model/Rule.h>
#include <aws/connect/model/RuleAction.h>
#include <aws/connect/model/RulePublishStatus.h>
#include <aws/connect/model/RuleSummary.h>
#include <aws/connect/model/RuleTriggerEventSource.h>
#include <aws/connect/model/S3Config.h>
#include <aws/connect/model/ScreenShareCapability.h>
#include <aws/connect/model/SearchAgentStatusesRequest.h>
#include <aws/connect/model/SearchAgentStatusesResult.h>
#include <aws/connect/model/SearchAvailablePhoneNumbersRequest.h>
#include <aws/connect/model/SearchAvailablePhoneNumbersResult.h>
#include <aws/connect/model/SearchContactFlowModulesRequest.h>
#include <aws/connect/model/SearchContactFlowModulesResult.h>
#include <aws/connect/model/SearchContactFlowsRequest.h>
#include <aws/connect/model/SearchContactFlowsResult.h>
#include <aws/connect/model/SearchContactsMatchType.h>
#include <aws/connect/model/SearchContactsRequest.h>
#include <aws/connect/model/SearchContactsResult.h>
#include <aws/connect/model/SearchContactsTimeRange.h>
#include <aws/connect/model/SearchContactsTimeRangeType.h>
#include <aws/connect/model/SearchCriteria.h>
#include <aws/connect/model/SearchEmailAddressesRequest.h>
#include <aws/connect/model/SearchEmailAddressesResult.h>
#include <aws/connect/model/SearchHoursOfOperationOverridesRequest.h>
#include <aws/connect/model/SearchHoursOfOperationOverridesResult.h>
#include <aws/connect/model/SearchHoursOfOperationsRequest.h>
#include <aws/connect/model/SearchHoursOfOperationsResult.h>
#include <aws/connect/model/SearchPredefinedAttributesRequest.h>
#include <aws/connect/model/SearchPredefinedAttributesResult.h>
#include <aws/connect/model/SearchPromptsRequest.h>
#include <aws/connect/model/SearchPromptsResult.h>
#include <aws/connect/model/SearchQueuesRequest.h>
#include <aws/connect/model/SearchQueuesResult.h>
#include <aws/connect/model/SearchQuickConnectsRequest.h>
#include <aws/connect/model/SearchQuickConnectsResult.h>
#include <aws/connect/model/SearchResourceTagsRequest.h>
#include <aws/connect/model/SearchResourceTagsResult.h>
#include <aws/connect/model/SearchRoutingProfilesRequest.h>
#include <aws/connect/model/SearchRoutingProfilesResult.h>
#include <aws/connect/model/SearchSecurityProfilesRequest.h>
#include <aws/connect/model/SearchSecurityProfilesResult.h>
#include <aws/connect/model/SearchUserHierarchyGroupsRequest.h>
#include <aws/connect/model/SearchUserHierarchyGroupsResult.h>
#include <aws/connect/model/SearchUsersRequest.h>
#include <aws/connect/model/SearchUsersResult.h>
#include <aws/connect/model/SearchVocabulariesRequest.h>
#include <aws/connect/model/SearchVocabulariesResult.h>
#include <aws/connect/model/SearchableContactAttributes.h>
#include <aws/connect/model/SearchableContactAttributesCriteria.h>
#include <aws/connect/model/SearchableQueueType.h>
#include <aws/connect/model/SearchableSegmentAttributes.h>
#include <aws/connect/model/SearchableSegmentAttributesCriteria.h>
#include <aws/connect/model/SecurityKey.h>
#include <aws/connect/model/SecurityProfile.h>
#include <aws/connect/model/SecurityProfileSearchCriteria.h>
#include <aws/connect/model/SecurityProfileSearchSummary.h>
#include <aws/connect/model/SecurityProfileSummary.h>
#include <aws/connect/model/SecurityProfilesSearchFilter.h>
#include <aws/connect/model/SegmentAttributeValue.h>
#include <aws/connect/model/SendChatIntegrationEventRequest.h>
#include <aws/connect/model/SendChatIntegrationEventResult.h>
#include <aws/connect/model/SendNotificationActionDefinition.h>
#include <aws/connect/model/SendOutboundEmailRequest.h>
#include <aws/connect/model/SendOutboundEmailResult.h>
#include <aws/connect/model/ServiceQuotaExceededException.h>
#include <aws/connect/model/ServiceQuotaExceededExceptionReason.h>
#include <aws/connect/model/SignInConfig.h>
#include <aws/connect/model/SignInDistribution.h>
#include <aws/connect/model/SingleSelectQuestionRuleCategoryAutomation.h>
#include <aws/connect/model/SingleSelectQuestionRuleCategoryAutomationCondition.h>
#include <aws/connect/model/SlaAssignmentType.h>
#include <aws/connect/model/SlaType.h>
#include <aws/connect/model/Sort.h>
#include <aws/connect/model/SortOrder.h>
#include <aws/connect/model/SortableFieldName.h>
#include <aws/connect/model/SourceCampaign.h>
#include <aws/connect/model/SourceType.h>
#include <aws/connect/model/StartAttachedFileUploadRequest.h>
#include <aws/connect/model/StartAttachedFileUploadResult.h>
#include <aws/connect/model/StartChatContactRequest.h>
#include <aws/connect/model/StartChatContactResult.h>
#include <aws/connect/model/StartContactEvaluationRequest.h>
#include <aws/connect/model/StartContactEvaluationResult.h>
#include <aws/connect/model/StartContactRecordingRequest.h>
#include <aws/connect/model/StartContactRecordingResult.h>
#include <aws/connect/model/StartContactStreamingRequest.h>
#include <aws/connect/model/StartContactStreamingResult.h>
#include <aws/connect/model/StartEmailContactRequest.h>
#include <aws/connect/model/StartEmailContactResult.h>
#include <aws/connect/model/StartOutboundChatContactRequest.h>
#include <aws/connect/model/StartOutboundChatContactResult.h>
#include <aws/connect/model/StartOutboundEmailContactRequest.h>
#include <aws/connect/model/StartOutboundEmailContactResult.h>
#include <aws/connect/model/StartOutboundVoiceContactRequest.h>
#include <aws/connect/model/StartOutboundVoiceContactResult.h>
#include <aws/connect/model/StartScreenSharingRequest.h>
#include <aws/connect/model/StartScreenSharingResult.h>
#include <aws/connect/model/StartTaskContactRequest.h>
#include <aws/connect/model/StartTaskContactResult.h>
#include <aws/connect/model/StartWebRTCContactRequest.h>
#include <aws/connect/model/StartWebRTCContactResult.h>
#include <aws/connect/model/StateTransition.h>
#include <aws/connect/model/Statistic.h>
#include <aws/connect/model/Status.h>
#include <aws/connect/model/Step.h>
#include <aws/connect/model/StopContactRecordingRequest.h>
#include <aws/connect/model/StopContactRecordingResult.h>
#include <aws/connect/model/StopContactRequest.h>
#include <aws/connect/model/StopContactResult.h>
#include <aws/connect/model/StopContactStreamingRequest.h>
#include <aws/connect/model/StopContactStreamingResult.h>
#include <aws/connect/model/StorageType.h>
#include <aws/connect/model/StringComparisonType.h>
#include <aws/connect/model/StringCondition.h>
#include <aws/connect/model/StringReference.h>
#include <aws/connect/model/SubmitAutoEvaluationActionDefinition.h>
#include <aws/connect/model/SubmitContactEvaluationRequest.h>
#include <aws/connect/model/SubmitContactEvaluationResult.h>
#include <aws/connect/model/SuccessfulRequest.h>
#include <aws/connect/model/SuspendContactRecordingRequest.h>
#include <aws/connect/model/SuspendContactRecordingResult.h>
#include <aws/connect/model/TagCondition.h>
#include <aws/connect/model/TagContactRequest.h>
#include <aws/connect/model/TagContactResult.h>
#include <aws/connect/model/TagResourceRequest.h>
#include <aws/connect/model/TagSearchCondition.h>
#include <aws/connect/model/TagSet.h>
#include <aws/connect/model/TargetListType.h>
#include <aws/connect/model/TaskActionDefinition.h>
#include <aws/connect/model/TaskTemplateConstraints.h>
#include <aws/connect/model/TaskTemplateDefaultFieldValue.h>
#include <aws/connect/model/TaskTemplateDefaults.h>
#include <aws/connect/model/TaskTemplateField.h>
#include <aws/connect/model/TaskTemplateFieldIdentifier.h>
#include <aws/connect/model/TaskTemplateFieldType.h>
#include <aws/connect/model/TaskTemplateMetadata.h>
#include <aws/connect/model/TaskTemplateStatus.h>
#include <aws/connect/model/TelephonyConfig.h>
#include <aws/connect/model/TemplateAttributes.h>
#include <aws/connect/model/TemplatedMessageConfig.h>
#include <aws/connect/model/Threshold.h>
#include <aws/connect/model/ThresholdV2.h>
#include <aws/connect/model/TimerEligibleParticipantRoles.h>
#include <aws/connect/model/TrafficDistributionGroup.h>
#include <aws/connect/model/TrafficDistributionGroupStatus.h>
#include <aws/connect/model/TrafficDistributionGroupSummary.h>
#include <aws/connect/model/TrafficDistributionGroupUserSummary.h>
#include <aws/connect/model/TrafficType.h>
#include <aws/connect/model/Transcript.h>
#include <aws/connect/model/TranscriptCriteria.h>
#include <aws/connect/model/TransferContactRequest.h>
#include <aws/connect/model/TransferContactResult.h>
#include <aws/connect/model/Unit.h>
#include <aws/connect/model/UntagContactRequest.h>
#include <aws/connect/model/UntagContactResult.h>
#include <aws/connect/model/UntagResourceRequest.h>
#include <aws/connect/model/UpdateAgentStatusRequest.h>
#include <aws/connect/model/UpdateAuthenticationProfileRequest.h>
#include <aws/connect/model/UpdateCaseActionDefinition.h>
#include <aws/connect/model/UpdateContactAttributesRequest.h>
#include <aws/connect/model/UpdateContactAttributesResult.h>
#include <aws/connect/model/UpdateContactEvaluationRequest.h>
#include <aws/connect/model/UpdateContactEvaluationResult.h>
#include <aws/connect/model/UpdateContactFlowContentRequest.h>
#include <aws/connect/model/UpdateContactFlowContentResult.h>
#include <aws/connect/model/UpdateContactFlowMetadataRequest.h>
#include <aws/connect/model/UpdateContactFlowMetadataResult.h>
#include <aws/connect/model/UpdateContactFlowModuleContentRequest.h>
#include <aws/connect/model/UpdateContactFlowModuleContentResult.h>
#include <aws/connect/model/UpdateContactFlowModuleMetadataRequest.h>
#include <aws/connect/model/UpdateContactFlowModuleMetadataResult.h>
#include <aws/connect/model/UpdateContactFlowNameRequest.h>
#include <aws/connect/model/UpdateContactFlowNameResult.h>
#include <aws/connect/model/UpdateContactRequest.h>
#include <aws/connect/model/UpdateContactResult.h>
#include <aws/connect/model/UpdateContactRoutingDataRequest.h>
#include <aws/connect/model/UpdateContactRoutingDataResult.h>
#include <aws/connect/model/UpdateContactScheduleRequest.h>
#include <aws/connect/model/UpdateContactScheduleResult.h>
#include <aws/connect/model/UpdateEmailAddressMetadataRequest.h>
#include <aws/connect/model/UpdateEmailAddressMetadataResult.h>
#include <aws/connect/model/UpdateEvaluationFormRequest.h>
#include <aws/connect/model/UpdateEvaluationFormResult.h>
#include <aws/connect/model/UpdateHoursOfOperationOverrideRequest.h>
#include <aws/connect/model/UpdateHoursOfOperationRequest.h>
#include <aws/connect/model/UpdateInstanceAttributeRequest.h>
#include <aws/connect/model/UpdateInstanceStorageConfigRequest.h>
#include <aws/connect/model/UpdateParticipantAuthenticationRequest.h>
#include <aws/connect/model/UpdateParticipantAuthenticationResult.h>
#include <aws/connect/model/UpdateParticipantRoleConfigChannelInfo.h>
#include <aws/connect/model/UpdateParticipantRoleConfigRequest.h>
#include <aws/connect/model/UpdateParticipantRoleConfigResult.h>
#include <aws/connect/model/UpdatePhoneNumberMetadataRequest.h>
#include <aws/connect/model/UpdatePhoneNumberRequest.h>
#include <aws/connect/model/UpdatePhoneNumberResult.h>
#include <aws/connect/model/UpdatePredefinedAttributeRequest.h>
#include <aws/connect/model/UpdatePromptRequest.h>
#include <aws/connect/model/UpdatePromptResult.h>
#include <aws/connect/model/UpdateQueueHoursOfOperationRequest.h>
#include <aws/connect/model/UpdateQueueMaxContactsRequest.h>
#include <aws/connect/model/UpdateQueueNameRequest.h>
#include <aws/connect/model/UpdateQueueOutboundCallerConfigRequest.h>
#include <aws/connect/model/UpdateQueueOutboundEmailConfigRequest.h>
#include <aws/connect/model/UpdateQueueStatusRequest.h>
#include <aws/connect/model/UpdateQuickConnectConfigRequest.h>
#include <aws/connect/model/UpdateQuickConnectNameRequest.h>
#include <aws/connect/model/UpdateRoutingProfileAgentAvailabilityTimerRequest.h>
#include <aws/connect/model/UpdateRoutingProfileConcurrencyRequest.h>
#include <aws/connect/model/UpdateRoutingProfileDefaultOutboundQueueRequest.h>
#include <aws/connect/model/UpdateRoutingProfileNameRequest.h>
#include <aws/connect/model/UpdateRoutingProfileQueuesRequest.h>
#include <aws/connect/model/UpdateRuleRequest.h>
#include <aws/connect/model/UpdateSecurityProfileRequest.h>
#include <aws/connect/model/UpdateTaskTemplateRequest.h>
#include <aws/connect/model/UpdateTaskTemplateResult.h>
#include <aws/connect/model/UpdateTrafficDistributionRequest.h>
#include <aws/connect/model/UpdateTrafficDistributionResult.h>
#include <aws/connect/model/UpdateUserHierarchyGroupNameRequest.h>
#include <aws/connect/model/UpdateUserHierarchyRequest.h>
#include <aws/connect/model/UpdateUserHierarchyStructureRequest.h>
#include <aws/connect/model/UpdateUserIdentityInfoRequest.h>
#include <aws/connect/model/UpdateUserPhoneConfigRequest.h>
#include <aws/connect/model/UpdateUserProficienciesRequest.h>
#include <aws/connect/model/UpdateUserRoutingProfileRequest.h>
#include <aws/connect/model/UpdateUserSecurityProfilesRequest.h>
#include <aws/connect/model/UpdateViewContentRequest.h>
#include <aws/connect/model/UpdateViewContentResult.h>
#include <aws/connect/model/UpdateViewMetadataRequest.h>
#include <aws/connect/model/UpdateViewMetadataResult.h>
#include <aws/connect/model/UploadUrlMetadata.h>
#include <aws/connect/model/UrlReference.h>
#include <aws/connect/model/UseCase.h>
#include <aws/connect/model/UseCaseType.h>
#include <aws/connect/model/User.h>
#include <aws/connect/model/UserData.h>
#include <aws/connect/model/UserDataFilters.h>
#include <aws/connect/model/UserHierarchyGroupSearchCriteria.h>
#include <aws/connect/model/UserHierarchyGroupSearchFilter.h>
#include <aws/connect/model/UserIdentityInfo.h>
#include <aws/connect/model/UserIdentityInfoLite.h>
#include <aws/connect/model/UserInfo.h>
#include <aws/connect/model/UserPhoneConfig.h>
#include <aws/connect/model/UserProficiency.h>
#include <aws/connect/model/UserProficiencyDisassociate.h>
#include <aws/connect/model/UserQuickConnectConfig.h>
#include <aws/connect/model/UserReference.h>
#include <aws/connect/model/UserSearchCriteria.h>
#include <aws/connect/model/UserSearchFilter.h>
#include <aws/connect/model/UserSearchSummary.h>
#include <aws/connect/model/UserSummary.h>
#include <aws/connect/model/VideoCapability.h>
#include <aws/connect/model/View.h>
#include <aws/connect/model/ViewContent.h>
#include <aws/connect/model/ViewInputContent.h>
#include <aws/connect/model/ViewStatus.h>
#include <aws/connect/model/ViewSummary.h>
#include <aws/connect/model/ViewType.h>
#include <aws/connect/model/ViewVersionSummary.h>
#include <aws/connect/model/Vocabulary.h>
#include <aws/connect/model/VocabularyLanguageCode.h>
#include <aws/connect/model/VocabularyState.h>
#include <aws/connect/model/VocabularySummary.h>
#include <aws/connect/model/VoiceRecordingConfiguration.h>
#include <aws/connect/model/VoiceRecordingTrack.h>
#include <aws/connect/model/WisdomInfo.h>

using ConnectIncludeTest = ::testing::Test;

TEST_F(ConnectIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::Connect::ConnectClient>("ConnectIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
