/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/connectcases/ConnectCasesClient.h>
#include <aws/connectcases/ConnectCasesEndpointProvider.h>
#include <aws/connectcases/ConnectCasesEndpointRules.h>
#include <aws/connectcases/ConnectCasesErrorMarshaller.h>
#include <aws/connectcases/ConnectCasesErrors.h>
#include <aws/connectcases/ConnectCasesRequest.h>
#include <aws/connectcases/ConnectCasesServiceClientModel.h>
#include <aws/connectcases/ConnectCases_EXPORTS.h>
#include <aws/connectcases/model/AuditEvent.h>
#include <aws/connectcases/model/AuditEventField.h>
#include <aws/connectcases/model/AuditEventFieldValueUnion.h>
#include <aws/connectcases/model/AuditEventPerformedBy.h>
#include <aws/connectcases/model/AuditEventType.h>
#include <aws/connectcases/model/BasicLayout.h>
#include <aws/connectcases/model/BatchGetCaseRuleRequest.h>
#include <aws/connectcases/model/BatchGetCaseRuleResult.h>
#include <aws/connectcases/model/BatchGetFieldRequest.h>
#include <aws/connectcases/model/BatchGetFieldResult.h>
#include <aws/connectcases/model/BatchPutFieldOptionsRequest.h>
#include <aws/connectcases/model/BatchPutFieldOptionsResult.h>
#include <aws/connectcases/model/BooleanCondition.h>
#include <aws/connectcases/model/BooleanOperands.h>
#include <aws/connectcases/model/CaseEventIncludedData.h>
#include <aws/connectcases/model/CaseFilter.h>
#include <aws/connectcases/model/CaseRuleDetails.h>
#include <aws/connectcases/model/CaseRuleError.h>
#include <aws/connectcases/model/CaseRuleIdentifier.h>
#include <aws/connectcases/model/CaseRuleSummary.h>
#include <aws/connectcases/model/CaseSummary.h>
#include <aws/connectcases/model/CommentBodyTextType.h>
#include <aws/connectcases/model/CommentContent.h>
#include <aws/connectcases/model/CommentFilter.h>
#include <aws/connectcases/model/Contact.h>
#include <aws/connectcases/model/ContactContent.h>
#include <aws/connectcases/model/ContactFilter.h>
#include <aws/connectcases/model/CreateCaseRequest.h>
#include <aws/connectcases/model/CreateCaseResult.h>
#include <aws/connectcases/model/CreateCaseRuleRequest.h>
#include <aws/connectcases/model/CreateCaseRuleResult.h>
#include <aws/connectcases/model/CreateDomainRequest.h>
#include <aws/connectcases/model/CreateDomainResult.h>
#include <aws/connectcases/model/CreateFieldRequest.h>
#include <aws/connectcases/model/CreateFieldResult.h>
#include <aws/connectcases/model/CreateLayoutRequest.h>
#include <aws/connectcases/model/CreateLayoutResult.h>
#include <aws/connectcases/model/CreateRelatedItemRequest.h>
#include <aws/connectcases/model/CreateRelatedItemResult.h>
#include <aws/connectcases/model/CreateTemplateRequest.h>
#include <aws/connectcases/model/CreateTemplateResult.h>
#include <aws/connectcases/model/DeleteCaseRuleRequest.h>
#include <aws/connectcases/model/DeleteCaseRuleResult.h>
#include <aws/connectcases/model/DeleteDomainRequest.h>
#include <aws/connectcases/model/DeleteDomainResult.h>
#include <aws/connectcases/model/DeleteFieldRequest.h>
#include <aws/connectcases/model/DeleteFieldResult.h>
#include <aws/connectcases/model/DeleteLayoutRequest.h>
#include <aws/connectcases/model/DeleteLayoutResult.h>
#include <aws/connectcases/model/DeleteTemplateRequest.h>
#include <aws/connectcases/model/DeleteTemplateResult.h>
#include <aws/connectcases/model/DomainStatus.h>
#include <aws/connectcases/model/DomainSummary.h>
#include <aws/connectcases/model/EmptyFieldValue.h>
#include <aws/connectcases/model/EmptyOperandValue.h>
#include <aws/connectcases/model/EventBridgeConfiguration.h>
#include <aws/connectcases/model/EventIncludedData.h>
#include <aws/connectcases/model/FieldError.h>
#include <aws/connectcases/model/FieldFilter.h>
#include <aws/connectcases/model/FieldGroup.h>
#include <aws/connectcases/model/FieldIdentifier.h>
#include <aws/connectcases/model/FieldItem.h>
#include <aws/connectcases/model/FieldNamespace.h>
#include <aws/connectcases/model/FieldOption.h>
#include <aws/connectcases/model/FieldOptionError.h>
#include <aws/connectcases/model/FieldSummary.h>
#include <aws/connectcases/model/FieldType.h>
#include <aws/connectcases/model/FieldValue.h>
#include <aws/connectcases/model/FieldValueUnion.h>
#include <aws/connectcases/model/FileContent.h>
#include <aws/connectcases/model/FileFilter.h>
#include <aws/connectcases/model/GetCaseAuditEventsRequest.h>
#include <aws/connectcases/model/GetCaseAuditEventsResult.h>
#include <aws/connectcases/model/GetCaseEventConfigurationRequest.h>
#include <aws/connectcases/model/GetCaseEventConfigurationResult.h>
#include <aws/connectcases/model/GetCaseRequest.h>
#include <aws/connectcases/model/GetCaseResult.h>
#include <aws/connectcases/model/GetCaseRuleResponse.h>
#include <aws/connectcases/model/GetDomainRequest.h>
#include <aws/connectcases/model/GetDomainResult.h>
#include <aws/connectcases/model/GetFieldResponse.h>
#include <aws/connectcases/model/GetLayoutRequest.h>
#include <aws/connectcases/model/GetLayoutResult.h>
#include <aws/connectcases/model/GetTemplateRequest.h>
#include <aws/connectcases/model/GetTemplateResult.h>
#include <aws/connectcases/model/InternalServerException.h>
#include <aws/connectcases/model/LayoutConfiguration.h>
#include <aws/connectcases/model/LayoutContent.h>
#include <aws/connectcases/model/LayoutSections.h>
#include <aws/connectcases/model/LayoutSummary.h>
#include <aws/connectcases/model/ListCaseRulesRequest.h>
#include <aws/connectcases/model/ListCaseRulesResult.h>
#include <aws/connectcases/model/ListCasesForContactRequest.h>
#include <aws/connectcases/model/ListCasesForContactResult.h>
#include <aws/connectcases/model/ListDomainsRequest.h>
#include <aws/connectcases/model/ListDomainsResult.h>
#include <aws/connectcases/model/ListFieldOptionsRequest.h>
#include <aws/connectcases/model/ListFieldOptionsResult.h>
#include <aws/connectcases/model/ListFieldsRequest.h>
#include <aws/connectcases/model/ListFieldsResult.h>
#include <aws/connectcases/model/ListLayoutsRequest.h>
#include <aws/connectcases/model/ListLayoutsResult.h>
#include <aws/connectcases/model/ListTagsForResourceRequest.h>
#include <aws/connectcases/model/ListTagsForResourceResult.h>
#include <aws/connectcases/model/ListTemplatesRequest.h>
#include <aws/connectcases/model/ListTemplatesResult.h>
#include <aws/connectcases/model/OperandOne.h>
#include <aws/connectcases/model/OperandTwo.h>
#include <aws/connectcases/model/Order.h>
#include <aws/connectcases/model/PutCaseEventConfigurationRequest.h>
#include <aws/connectcases/model/PutCaseEventConfigurationResult.h>
#include <aws/connectcases/model/RelatedItemContent.h>
#include <aws/connectcases/model/RelatedItemEventIncludedData.h>
#include <aws/connectcases/model/RelatedItemInputContent.h>
#include <aws/connectcases/model/RelatedItemType.h>
#include <aws/connectcases/model/RelatedItemTypeFilter.h>
#include <aws/connectcases/model/RequiredCaseRule.h>
#include <aws/connectcases/model/RequiredField.h>
#include <aws/connectcases/model/ResourceNotFoundException.h>
#include <aws/connectcases/model/RuleType.h>
#include <aws/connectcases/model/SearchCasesRequest.h>
#include <aws/connectcases/model/SearchCasesResponseItem.h>
#include <aws/connectcases/model/SearchCasesResult.h>
#include <aws/connectcases/model/SearchRelatedItemsRequest.h>
#include <aws/connectcases/model/SearchRelatedItemsResponseItem.h>
#include <aws/connectcases/model/SearchRelatedItemsResult.h>
#include <aws/connectcases/model/Section.h>
#include <aws/connectcases/model/SlaConfiguration.h>
#include <aws/connectcases/model/SlaContent.h>
#include <aws/connectcases/model/SlaFilter.h>
#include <aws/connectcases/model/SlaInputConfiguration.h>
#include <aws/connectcases/model/SlaInputContent.h>
#include <aws/connectcases/model/SlaStatus.h>
#include <aws/connectcases/model/SlaType.h>
#include <aws/connectcases/model/Sort.h>
#include <aws/connectcases/model/TagResourceRequest.h>
#include <aws/connectcases/model/TemplateRule.h>
#include <aws/connectcases/model/TemplateStatus.h>
#include <aws/connectcases/model/TemplateSummary.h>
#include <aws/connectcases/model/UntagResourceRequest.h>
#include <aws/connectcases/model/UpdateCaseRequest.h>
#include <aws/connectcases/model/UpdateCaseResult.h>
#include <aws/connectcases/model/UpdateCaseRuleRequest.h>
#include <aws/connectcases/model/UpdateCaseRuleResult.h>
#include <aws/connectcases/model/UpdateFieldRequest.h>
#include <aws/connectcases/model/UpdateFieldResult.h>
#include <aws/connectcases/model/UpdateLayoutRequest.h>
#include <aws/connectcases/model/UpdateLayoutResult.h>
#include <aws/connectcases/model/UpdateTemplateRequest.h>
#include <aws/connectcases/model/UpdateTemplateResult.h>
#include <aws/connectcases/model/UserUnion.h>

using ConnectCasesIncludeTest = ::testing::Test;

TEST_F(ConnectCasesIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::ConnectCases::ConnectCasesClient>("ConnectCasesIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
