/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/customer-profiles/CustomerProfilesClient.h>
#include <aws/customer-profiles/CustomerProfilesEndpointProvider.h>
#include <aws/customer-profiles/CustomerProfilesEndpointRules.h>
#include <aws/customer-profiles/CustomerProfilesErrorMarshaller.h>
#include <aws/customer-profiles/CustomerProfilesErrors.h>
#include <aws/customer-profiles/CustomerProfilesRequest.h>
#include <aws/customer-profiles/CustomerProfilesServiceClientModel.h>
#include <aws/customer-profiles/CustomerProfiles_EXPORTS.h>
#include <aws/customer-profiles/model/AddProfileKeyRequest.h>
#include <aws/customer-profiles/model/AddProfileKeyResult.h>
#include <aws/customer-profiles/model/AdditionalSearchKey.h>
#include <aws/customer-profiles/model/Address.h>
#include <aws/customer-profiles/model/AddressDimension.h>
#include <aws/customer-profiles/model/AppflowIntegration.h>
#include <aws/customer-profiles/model/AppflowIntegrationWorkflowAttributes.h>
#include <aws/customer-profiles/model/AppflowIntegrationWorkflowMetrics.h>
#include <aws/customer-profiles/model/AppflowIntegrationWorkflowStep.h>
#include <aws/customer-profiles/model/AttributeDetails.h>
#include <aws/customer-profiles/model/AttributeDimension.h>
#include <aws/customer-profiles/model/AttributeDimensionType.h>
#include <aws/customer-profiles/model/AttributeItem.h>
#include <aws/customer-profiles/model/AttributeMatchingModel.h>
#include <aws/customer-profiles/model/AttributeTypesSelector.h>
#include <aws/customer-profiles/model/AttributeValueItem.h>
#include <aws/customer-profiles/model/AutoMerging.h>
#include <aws/customer-profiles/model/Batch.h>
#include <aws/customer-profiles/model/BatchGetCalculatedAttributeForProfileError.h>
#include <aws/customer-profiles/model/BatchGetCalculatedAttributeForProfileRequest.h>
#include <aws/customer-profiles/model/BatchGetCalculatedAttributeForProfileResult.h>
#include <aws/customer-profiles/model/BatchGetProfileError.h>
#include <aws/customer-profiles/model/BatchGetProfileRequest.h>
#include <aws/customer-profiles/model/BatchGetProfileResult.h>
#include <aws/customer-profiles/model/CalculatedAttributeDimension.h>
#include <aws/customer-profiles/model/CalculatedAttributeValue.h>
#include <aws/customer-profiles/model/ComparisonOperator.h>
#include <aws/customer-profiles/model/ConditionOverrides.h>
#include <aws/customer-profiles/model/Conditions.h>
#include <aws/customer-profiles/model/ConflictResolution.h>
#include <aws/customer-profiles/model/ConflictResolvingModel.h>
#include <aws/customer-profiles/model/ConnectorOperator.h>
#include <aws/customer-profiles/model/Consolidation.h>
#include <aws/customer-profiles/model/CreateCalculatedAttributeDefinitionRequest.h>
#include <aws/customer-profiles/model/CreateCalculatedAttributeDefinitionResult.h>
#include <aws/customer-profiles/model/CreateDomainLayoutRequest.h>
#include <aws/customer-profiles/model/CreateDomainLayoutResult.h>
#include <aws/customer-profiles/model/CreateDomainRequest.h>
#include <aws/customer-profiles/model/CreateDomainResult.h>
#include <aws/customer-profiles/model/CreateEventStreamRequest.h>
#include <aws/customer-profiles/model/CreateEventStreamResult.h>
#include <aws/customer-profiles/model/CreateEventTriggerRequest.h>
#include <aws/customer-profiles/model/CreateEventTriggerResult.h>
#include <aws/customer-profiles/model/CreateIntegrationWorkflowRequest.h>
#include <aws/customer-profiles/model/CreateIntegrationWorkflowResult.h>
#include <aws/customer-profiles/model/CreateProfileRequest.h>
#include <aws/customer-profiles/model/CreateProfileResult.h>
#include <aws/customer-profiles/model/CreateSegmentDefinitionRequest.h>
#include <aws/customer-profiles/model/CreateSegmentDefinitionResult.h>
#include <aws/customer-profiles/model/CreateSegmentEstimateRequest.h>
#include <aws/customer-profiles/model/CreateSegmentEstimateResult.h>
#include <aws/customer-profiles/model/CreateSegmentSnapshotRequest.h>
#include <aws/customer-profiles/model/CreateSegmentSnapshotResult.h>
#include <aws/customer-profiles/model/DataFormat.h>
#include <aws/customer-profiles/model/DataPullMode.h>
#include <aws/customer-profiles/model/DateDimension.h>
#include <aws/customer-profiles/model/DateDimensionType.h>
#include <aws/customer-profiles/model/DeleteCalculatedAttributeDefinitionRequest.h>
#include <aws/customer-profiles/model/DeleteCalculatedAttributeDefinitionResult.h>
#include <aws/customer-profiles/model/DeleteDomainLayoutRequest.h>
#include <aws/customer-profiles/model/DeleteDomainLayoutResult.h>
#include <aws/customer-profiles/model/DeleteDomainRequest.h>
#include <aws/customer-profiles/model/DeleteDomainResult.h>
#include <aws/customer-profiles/model/DeleteEventStreamRequest.h>
#include <aws/customer-profiles/model/DeleteEventStreamResult.h>
#include <aws/customer-profiles/model/DeleteEventTriggerRequest.h>
#include <aws/customer-profiles/model/DeleteEventTriggerResult.h>
#include <aws/customer-profiles/model/DeleteIntegrationRequest.h>
#include <aws/customer-profiles/model/DeleteIntegrationResult.h>
#include <aws/customer-profiles/model/DeleteProfileKeyRequest.h>
#include <aws/customer-profiles/model/DeleteProfileKeyResult.h>
#include <aws/customer-profiles/model/DeleteProfileObjectRequest.h>
#include <aws/customer-profiles/model/DeleteProfileObjectResult.h>
#include <aws/customer-profiles/model/DeleteProfileObjectTypeRequest.h>
#include <aws/customer-profiles/model/DeleteProfileObjectTypeResult.h>
#include <aws/customer-profiles/model/DeleteProfileRequest.h>
#include <aws/customer-profiles/model/DeleteProfileResult.h>
#include <aws/customer-profiles/model/DeleteSegmentDefinitionRequest.h>
#include <aws/customer-profiles/model/DeleteSegmentDefinitionResult.h>
#include <aws/customer-profiles/model/DeleteWorkflowRequest.h>
#include <aws/customer-profiles/model/DeleteWorkflowResult.h>
#include <aws/customer-profiles/model/DestinationSummary.h>
#include <aws/customer-profiles/model/DetectProfileObjectTypeRequest.h>
#include <aws/customer-profiles/model/DetectProfileObjectTypeResult.h>
#include <aws/customer-profiles/model/DetectedProfileObjectType.h>
#include <aws/customer-profiles/model/Dimension.h>
#include <aws/customer-profiles/model/DomainStats.h>
#include <aws/customer-profiles/model/EstimateStatus.h>
#include <aws/customer-profiles/model/EventStreamDestinationDetails.h>
#include <aws/customer-profiles/model/EventStreamDestinationStatus.h>
#include <aws/customer-profiles/model/EventStreamState.h>
#include <aws/customer-profiles/model/EventStreamSummary.h>
#include <aws/customer-profiles/model/EventTriggerCondition.h>
#include <aws/customer-profiles/model/EventTriggerDimension.h>
#include <aws/customer-profiles/model/EventTriggerLimits.h>
#include <aws/customer-profiles/model/EventTriggerLogicalOperator.h>
#include <aws/customer-profiles/model/EventTriggerSummaryItem.h>
#include <aws/customer-profiles/model/ExportingConfig.h>
#include <aws/customer-profiles/model/ExportingLocation.h>
#include <aws/customer-profiles/model/ExtraLengthValueProfileDimension.h>
#include <aws/customer-profiles/model/FieldContentType.h>
#include <aws/customer-profiles/model/FieldSourceProfileIds.h>
#include <aws/customer-profiles/model/Filter.h>
#include <aws/customer-profiles/model/FilterAttributeDimension.h>
#include <aws/customer-profiles/model/FilterDimension.h>
#include <aws/customer-profiles/model/FilterDimensionType.h>
#include <aws/customer-profiles/model/FilterGroup.h>
#include <aws/customer-profiles/model/FlowDefinition.h>
#include <aws/customer-profiles/model/FoundByKeyValue.h>
#include <aws/customer-profiles/model/Gender.h>
#include <aws/customer-profiles/model/GetAutoMergingPreviewRequest.h>
#include <aws/customer-profiles/model/GetAutoMergingPreviewResult.h>
#include <aws/customer-profiles/model/GetCalculatedAttributeDefinitionRequest.h>
#include <aws/customer-profiles/model/GetCalculatedAttributeDefinitionResult.h>
#include <aws/customer-profiles/model/GetCalculatedAttributeForProfileRequest.h>
#include <aws/customer-profiles/model/GetCalculatedAttributeForProfileResult.h>
#include <aws/customer-profiles/model/GetDomainLayoutRequest.h>
#include <aws/customer-profiles/model/GetDomainLayoutResult.h>
#include <aws/customer-profiles/model/GetDomainRequest.h>
#include <aws/customer-profiles/model/GetDomainResult.h>
#include <aws/customer-profiles/model/GetEventStreamRequest.h>
#include <aws/customer-profiles/model/GetEventStreamResult.h>
#include <aws/customer-profiles/model/GetEventTriggerRequest.h>
#include <aws/customer-profiles/model/GetEventTriggerResult.h>
#include <aws/customer-profiles/model/GetIdentityResolutionJobRequest.h>
#include <aws/customer-profiles/model/GetIdentityResolutionJobResult.h>
#include <aws/customer-profiles/model/GetIntegrationRequest.h>
#include <aws/customer-profiles/model/GetIntegrationResult.h>
#include <aws/customer-profiles/model/GetMatchesRequest.h>
#include <aws/customer-profiles/model/GetMatchesResult.h>
#include <aws/customer-profiles/model/GetProfileObjectTypeRequest.h>
#include <aws/customer-profiles/model/GetProfileObjectTypeResult.h>
#include <aws/customer-profiles/model/GetProfileObjectTypeTemplateRequest.h>
#include <aws/customer-profiles/model/GetProfileObjectTypeTemplateResult.h>
#include <aws/customer-profiles/model/GetSegmentDefinitionRequest.h>
#include <aws/customer-profiles/model/GetSegmentDefinitionResult.h>
#include <aws/customer-profiles/model/GetSegmentEstimateRequest.h>
#include <aws/customer-profiles/model/GetSegmentEstimateResult.h>
#include <aws/customer-profiles/model/GetSegmentMembershipRequest.h>
#include <aws/customer-profiles/model/GetSegmentMembershipResult.h>
#include <aws/customer-profiles/model/GetSegmentSnapshotRequest.h>
#include <aws/customer-profiles/model/GetSegmentSnapshotResult.h>
#include <aws/customer-profiles/model/GetSimilarProfilesRequest.h>
#include <aws/customer-profiles/model/GetSimilarProfilesResult.h>
#include <aws/customer-profiles/model/GetWorkflowRequest.h>
#include <aws/customer-profiles/model/GetWorkflowResult.h>
#include <aws/customer-profiles/model/GetWorkflowStepsRequest.h>
#include <aws/customer-profiles/model/GetWorkflowStepsResult.h>
#include <aws/customer-profiles/model/Group.h>
#include <aws/customer-profiles/model/IdentityResolutionJob.h>
#include <aws/customer-profiles/model/IdentityResolutionJobStatus.h>
#include <aws/customer-profiles/model/Include.h>
#include <aws/customer-profiles/model/IncludeOptions.h>
#include <aws/customer-profiles/model/IncrementalPullConfig.h>
#include <aws/customer-profiles/model/IntegrationConfig.h>
#include <aws/customer-profiles/model/JobSchedule.h>
#include <aws/customer-profiles/model/JobScheduleDayOfTheWeek.h>
#include <aws/customer-profiles/model/JobStats.h>
#include <aws/customer-profiles/model/LayoutItem.h>
#include <aws/customer-profiles/model/LayoutType.h>
#include <aws/customer-profiles/model/ListAccountIntegrationsRequest.h>
#include <aws/customer-profiles/model/ListAccountIntegrationsResult.h>
#include <aws/customer-profiles/model/ListCalculatedAttributeDefinitionItem.h>
#include <aws/customer-profiles/model/ListCalculatedAttributeDefinitionsRequest.h>
#include <aws/customer-profiles/model/ListCalculatedAttributeDefinitionsResult.h>
#include <aws/customer-profiles/model/ListCalculatedAttributeForProfileItem.h>
#include <aws/customer-profiles/model/ListCalculatedAttributesForProfileRequest.h>
#include <aws/customer-profiles/model/ListCalculatedAttributesForProfileResult.h>
#include <aws/customer-profiles/model/ListDomainItem.h>
#include <aws/customer-profiles/model/ListDomainLayoutsRequest.h>
#include <aws/customer-profiles/model/ListDomainLayoutsResult.h>
#include <aws/customer-profiles/model/ListDomainsRequest.h>
#include <aws/customer-profiles/model/ListDomainsResult.h>
#include <aws/customer-profiles/model/ListEventStreamsRequest.h>
#include <aws/customer-profiles/model/ListEventStreamsResult.h>
#include <aws/customer-profiles/model/ListEventTriggersRequest.h>
#include <aws/customer-profiles/model/ListEventTriggersResult.h>
#include <aws/customer-profiles/model/ListIdentityResolutionJobsRequest.h>
#include <aws/customer-profiles/model/ListIdentityResolutionJobsResult.h>
#include <aws/customer-profiles/model/ListIntegrationItem.h>
#include <aws/customer-profiles/model/ListIntegrationsRequest.h>
#include <aws/customer-profiles/model/ListIntegrationsResult.h>
#include <aws/customer-profiles/model/ListObjectTypeAttributeItem.h>
#include <aws/customer-profiles/model/ListObjectTypeAttributesRequest.h>
#include <aws/customer-profiles/model/ListObjectTypeAttributesResult.h>
#include <aws/customer-profiles/model/ListProfileAttributeValuesRequest.h>
#include <aws/customer-profiles/model/ListProfileAttributeValuesResult.h>
#include <aws/customer-profiles/model/ListProfileObjectTypeItem.h>
#include <aws/customer-profiles/model/ListProfileObjectTypeTemplateItem.h>
#include <aws/customer-profiles/model/ListProfileObjectTypeTemplatesRequest.h>
#include <aws/customer-profiles/model/ListProfileObjectTypeTemplatesResult.h>
#include <aws/customer-profiles/model/ListProfileObjectTypesRequest.h>
#include <aws/customer-profiles/model/ListProfileObjectTypesResult.h>
#include <aws/customer-profiles/model/ListProfileObjectsItem.h>
#include <aws/customer-profiles/model/ListProfileObjectsRequest.h>
#include <aws/customer-profiles/model/ListProfileObjectsResult.h>
#include <aws/customer-profiles/model/ListRuleBasedMatchesRequest.h>
#include <aws/customer-profiles/model/ListRuleBasedMatchesResult.h>
#include <aws/customer-profiles/model/ListSegmentDefinitionsRequest.h>
#include <aws/customer-profiles/model/ListSegmentDefinitionsResult.h>
#include <aws/customer-profiles/model/ListTagsForResourceRequest.h>
#include <aws/customer-profiles/model/ListTagsForResourceResult.h>
#include <aws/customer-profiles/model/ListWorkflowsItem.h>
#include <aws/customer-profiles/model/ListWorkflowsRequest.h>
#include <aws/customer-profiles/model/ListWorkflowsResult.h>
#include <aws/customer-profiles/model/LogicalOperator.h>
#include <aws/customer-profiles/model/MarketoConnectorOperator.h>
#include <aws/customer-profiles/model/MarketoSourceProperties.h>
#include <aws/customer-profiles/model/MatchItem.h>
#include <aws/customer-profiles/model/MatchType.h>
#include <aws/customer-profiles/model/MatchingRequest.h>
#include <aws/customer-profiles/model/MatchingResponse.h>
#include <aws/customer-profiles/model/MatchingRule.h>
#include <aws/customer-profiles/model/MergeProfilesRequest.h>
#include <aws/customer-profiles/model/MergeProfilesResult.h>
#include <aws/customer-profiles/model/ObjectAttribute.h>
#include <aws/customer-profiles/model/ObjectFilter.h>
#include <aws/customer-profiles/model/ObjectTypeField.h>
#include <aws/customer-profiles/model/ObjectTypeKey.h>
#include <aws/customer-profiles/model/Operator.h>
#include <aws/customer-profiles/model/OperatorPropertiesKeys.h>
#include <aws/customer-profiles/model/PartyType.h>
#include <aws/customer-profiles/model/Period.h>
#include <aws/customer-profiles/model/PeriodUnit.h>
#include <aws/customer-profiles/model/Profile.h>
#include <aws/customer-profiles/model/ProfileAttributes.h>
#include <aws/customer-profiles/model/ProfileDimension.h>
#include <aws/customer-profiles/model/ProfileQueryFailures.h>
#include <aws/customer-profiles/model/ProfileQueryResult.h>
#include <aws/customer-profiles/model/PutIntegrationRequest.h>
#include <aws/customer-profiles/model/PutIntegrationResult.h>
#include <aws/customer-profiles/model/PutProfileObjectRequest.h>
#include <aws/customer-profiles/model/PutProfileObjectResult.h>
#include <aws/customer-profiles/model/PutProfileObjectTypeRequest.h>
#include <aws/customer-profiles/model/PutProfileObjectTypeResult.h>
#include <aws/customer-profiles/model/QueryResult.h>
#include <aws/customer-profiles/model/Range.h>
#include <aws/customer-profiles/model/RangeOverride.h>
#include <aws/customer-profiles/model/RangeUnit.h>
#include <aws/customer-profiles/model/Readiness.h>
#include <aws/customer-profiles/model/ReadinessStatus.h>
#include <aws/customer-profiles/model/RuleBasedMatchingRequest.h>
#include <aws/customer-profiles/model/RuleBasedMatchingResponse.h>
#include <aws/customer-profiles/model/RuleBasedMatchingStatus.h>
#include <aws/customer-profiles/model/S3ConnectorOperator.h>
#include <aws/customer-profiles/model/S3ExportingConfig.h>
#include <aws/customer-profiles/model/S3ExportingLocation.h>
#include <aws/customer-profiles/model/S3SourceProperties.h>
#include <aws/customer-profiles/model/SalesforceConnectorOperator.h>
#include <aws/customer-profiles/model/SalesforceSourceProperties.h>
#include <aws/customer-profiles/model/ScheduledTriggerProperties.h>
#include <aws/customer-profiles/model/SearchProfilesRequest.h>
#include <aws/customer-profiles/model/SearchProfilesResult.h>
#include <aws/customer-profiles/model/SegmentDefinitionItem.h>
#include <aws/customer-profiles/model/SegmentGroup.h>
#include <aws/customer-profiles/model/SegmentGroupStructure.h>
#include <aws/customer-profiles/model/SegmentSnapshotStatus.h>
#include <aws/customer-profiles/model/ServiceNowConnectorOperator.h>
#include <aws/customer-profiles/model/ServiceNowSourceProperties.h>
#include <aws/customer-profiles/model/SourceConnectorProperties.h>
#include <aws/customer-profiles/model/SourceConnectorType.h>
#include <aws/customer-profiles/model/SourceFlowConfig.h>
#include <aws/customer-profiles/model/SourceSegment.h>
#include <aws/customer-profiles/model/StandardIdentifier.h>
#include <aws/customer-profiles/model/Statistic.h>
#include <aws/customer-profiles/model/Status.h>
#include <aws/customer-profiles/model/StringDimensionType.h>
#include <aws/customer-profiles/model/TagResourceRequest.h>
#include <aws/customer-profiles/model/TagResourceResult.h>
#include <aws/customer-profiles/model/Task.h>
#include <aws/customer-profiles/model/TaskType.h>
#include <aws/customer-profiles/model/Threshold.h>
#include <aws/customer-profiles/model/TriggerConfig.h>
#include <aws/customer-profiles/model/TriggerProperties.h>
#include <aws/customer-profiles/model/TriggerType.h>
#include <aws/customer-profiles/model/Type.h>
#include <aws/customer-profiles/model/Unit.h>
#include <aws/customer-profiles/model/UntagResourceRequest.h>
#include <aws/customer-profiles/model/UntagResourceResult.h>
#include <aws/customer-profiles/model/UpdateAddress.h>
#include <aws/customer-profiles/model/UpdateCalculatedAttributeDefinitionRequest.h>
#include <aws/customer-profiles/model/UpdateCalculatedAttributeDefinitionResult.h>
#include <aws/customer-profiles/model/UpdateDomainLayoutRequest.h>
#include <aws/customer-profiles/model/UpdateDomainLayoutResult.h>
#include <aws/customer-profiles/model/UpdateDomainRequest.h>
#include <aws/customer-profiles/model/UpdateDomainResult.h>
#include <aws/customer-profiles/model/UpdateEventTriggerRequest.h>
#include <aws/customer-profiles/model/UpdateEventTriggerResult.h>
#include <aws/customer-profiles/model/UpdateProfileRequest.h>
#include <aws/customer-profiles/model/UpdateProfileResult.h>
#include <aws/customer-profiles/model/ValueRange.h>
#include <aws/customer-profiles/model/WorkflowAttributes.h>
#include <aws/customer-profiles/model/WorkflowMetrics.h>
#include <aws/customer-profiles/model/WorkflowStepItem.h>
#include <aws/customer-profiles/model/WorkflowType.h>
#include <aws/customer-profiles/model/ZendeskConnectorOperator.h>
#include <aws/customer-profiles/model/ZendeskSourceProperties.h>

using CustomerProfilesIncludeTest = ::testing::Test;

TEST_F(CustomerProfilesIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::CustomerProfiles::CustomerProfilesClient>("CustomerProfilesIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
