/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/databrew/GlueDataBrewClient.h>
#include <aws/databrew/GlueDataBrewEndpointProvider.h>
#include <aws/databrew/GlueDataBrewEndpointRules.h>
#include <aws/databrew/GlueDataBrewErrorMarshaller.h>
#include <aws/databrew/GlueDataBrewErrors.h>
#include <aws/databrew/GlueDataBrewRequest.h>
#include <aws/databrew/GlueDataBrewServiceClientModel.h>
#include <aws/databrew/GlueDataBrew_EXPORTS.h>
#include <aws/databrew/model/AllowedStatistics.h>
#include <aws/databrew/model/AnalyticsMode.h>
#include <aws/databrew/model/BatchDeleteRecipeVersionRequest.h>
#include <aws/databrew/model/BatchDeleteRecipeVersionResult.h>
#include <aws/databrew/model/ColumnSelector.h>
#include <aws/databrew/model/ColumnStatisticsConfiguration.h>
#include <aws/databrew/model/CompressionFormat.h>
#include <aws/databrew/model/ConditionExpression.h>
#include <aws/databrew/model/CreateDatasetRequest.h>
#include <aws/databrew/model/CreateDatasetResult.h>
#include <aws/databrew/model/CreateProfileJobRequest.h>
#include <aws/databrew/model/CreateProfileJobResult.h>
#include <aws/databrew/model/CreateProjectRequest.h>
#include <aws/databrew/model/CreateProjectResult.h>
#include <aws/databrew/model/CreateRecipeJobRequest.h>
#include <aws/databrew/model/CreateRecipeJobResult.h>
#include <aws/databrew/model/CreateRecipeRequest.h>
#include <aws/databrew/model/CreateRecipeResult.h>
#include <aws/databrew/model/CreateRulesetRequest.h>
#include <aws/databrew/model/CreateRulesetResult.h>
#include <aws/databrew/model/CreateScheduleRequest.h>
#include <aws/databrew/model/CreateScheduleResult.h>
#include <aws/databrew/model/CsvOptions.h>
#include <aws/databrew/model/CsvOutputOptions.h>
#include <aws/databrew/model/DataCatalogInputDefinition.h>
#include <aws/databrew/model/DataCatalogOutput.h>
#include <aws/databrew/model/DatabaseInputDefinition.h>
#include <aws/databrew/model/DatabaseOutput.h>
#include <aws/databrew/model/DatabaseOutputMode.h>
#include <aws/databrew/model/DatabaseTableOutputOptions.h>
#include <aws/databrew/model/Dataset.h>
#include <aws/databrew/model/DatasetParameter.h>
#include <aws/databrew/model/DatetimeOptions.h>
#include <aws/databrew/model/DeleteDatasetRequest.h>
#include <aws/databrew/model/DeleteDatasetResult.h>
#include <aws/databrew/model/DeleteJobRequest.h>
#include <aws/databrew/model/DeleteJobResult.h>
#include <aws/databrew/model/DeleteProjectRequest.h>
#include <aws/databrew/model/DeleteProjectResult.h>
#include <aws/databrew/model/DeleteRecipeVersionRequest.h>
#include <aws/databrew/model/DeleteRecipeVersionResult.h>
#include <aws/databrew/model/DeleteRulesetRequest.h>
#include <aws/databrew/model/DeleteRulesetResult.h>
#include <aws/databrew/model/DeleteScheduleRequest.h>
#include <aws/databrew/model/DeleteScheduleResult.h>
#include <aws/databrew/model/DescribeDatasetRequest.h>
#include <aws/databrew/model/DescribeDatasetResult.h>
#include <aws/databrew/model/DescribeJobRequest.h>
#include <aws/databrew/model/DescribeJobResult.h>
#include <aws/databrew/model/DescribeJobRunRequest.h>
#include <aws/databrew/model/DescribeJobRunResult.h>
#include <aws/databrew/model/DescribeProjectRequest.h>
#include <aws/databrew/model/DescribeProjectResult.h>
#include <aws/databrew/model/DescribeRecipeRequest.h>
#include <aws/databrew/model/DescribeRecipeResult.h>
#include <aws/databrew/model/DescribeRulesetRequest.h>
#include <aws/databrew/model/DescribeRulesetResult.h>
#include <aws/databrew/model/DescribeScheduleRequest.h>
#include <aws/databrew/model/DescribeScheduleResult.h>
#include <aws/databrew/model/EncryptionMode.h>
#include <aws/databrew/model/EntityDetectorConfiguration.h>
#include <aws/databrew/model/ExcelOptions.h>
#include <aws/databrew/model/FilesLimit.h>
#include <aws/databrew/model/FilterExpression.h>
#include <aws/databrew/model/FormatOptions.h>
#include <aws/databrew/model/Input.h>
#include <aws/databrew/model/InputFormat.h>
#include <aws/databrew/model/Job.h>
#include <aws/databrew/model/JobRun.h>
#include <aws/databrew/model/JobRunState.h>
#include <aws/databrew/model/JobSample.h>
#include <aws/databrew/model/JobType.h>
#include <aws/databrew/model/JsonOptions.h>
#include <aws/databrew/model/ListDatasetsRequest.h>
#include <aws/databrew/model/ListDatasetsResult.h>
#include <aws/databrew/model/ListJobRunsRequest.h>
#include <aws/databrew/model/ListJobRunsResult.h>
#include <aws/databrew/model/ListJobsRequest.h>
#include <aws/databrew/model/ListJobsResult.h>
#include <aws/databrew/model/ListProjectsRequest.h>
#include <aws/databrew/model/ListProjectsResult.h>
#include <aws/databrew/model/ListRecipeVersionsRequest.h>
#include <aws/databrew/model/ListRecipeVersionsResult.h>
#include <aws/databrew/model/ListRecipesRequest.h>
#include <aws/databrew/model/ListRecipesResult.h>
#include <aws/databrew/model/ListRulesetsRequest.h>
#include <aws/databrew/model/ListRulesetsResult.h>
#include <aws/databrew/model/ListSchedulesRequest.h>
#include <aws/databrew/model/ListSchedulesResult.h>
#include <aws/databrew/model/ListTagsForResourceRequest.h>
#include <aws/databrew/model/ListTagsForResourceResult.h>
#include <aws/databrew/model/LogSubscription.h>
#include <aws/databrew/model/Metadata.h>
#include <aws/databrew/model/Order.h>
#include <aws/databrew/model/OrderedBy.h>
#include <aws/databrew/model/Output.h>
#include <aws/databrew/model/OutputFormat.h>
#include <aws/databrew/model/OutputFormatOptions.h>
#include <aws/databrew/model/ParameterType.h>
#include <aws/databrew/model/PathOptions.h>
#include <aws/databrew/model/ProfileConfiguration.h>
#include <aws/databrew/model/Project.h>
#include <aws/databrew/model/PublishRecipeRequest.h>
#include <aws/databrew/model/PublishRecipeResult.h>
#include <aws/databrew/model/Recipe.h>
#include <aws/databrew/model/RecipeAction.h>
#include <aws/databrew/model/RecipeReference.h>
#include <aws/databrew/model/RecipeStep.h>
#include <aws/databrew/model/RecipeVersionErrorDetail.h>
#include <aws/databrew/model/Rule.h>
#include <aws/databrew/model/RulesetItem.h>
#include <aws/databrew/model/S3Location.h>
#include <aws/databrew/model/S3TableOutputOptions.h>
#include <aws/databrew/model/Sample.h>
#include <aws/databrew/model/SampleMode.h>
#include <aws/databrew/model/SampleType.h>
#include <aws/databrew/model/Schedule.h>
#include <aws/databrew/model/SendProjectSessionActionRequest.h>
#include <aws/databrew/model/SendProjectSessionActionResult.h>
#include <aws/databrew/model/SessionStatus.h>
#include <aws/databrew/model/Source.h>
#include <aws/databrew/model/StartJobRunRequest.h>
#include <aws/databrew/model/StartJobRunResult.h>
#include <aws/databrew/model/StartProjectSessionRequest.h>
#include <aws/databrew/model/StartProjectSessionResult.h>
#include <aws/databrew/model/StatisticOverride.h>
#include <aws/databrew/model/StatisticsConfiguration.h>
#include <aws/databrew/model/StopJobRunRequest.h>
#include <aws/databrew/model/StopJobRunResult.h>
#include <aws/databrew/model/TagResourceRequest.h>
#include <aws/databrew/model/TagResourceResult.h>
#include <aws/databrew/model/Threshold.h>
#include <aws/databrew/model/ThresholdType.h>
#include <aws/databrew/model/ThresholdUnit.h>
#include <aws/databrew/model/UntagResourceRequest.h>
#include <aws/databrew/model/UntagResourceResult.h>
#include <aws/databrew/model/UpdateDatasetRequest.h>
#include <aws/databrew/model/UpdateDatasetResult.h>
#include <aws/databrew/model/UpdateProfileJobRequest.h>
#include <aws/databrew/model/UpdateProfileJobResult.h>
#include <aws/databrew/model/UpdateProjectRequest.h>
#include <aws/databrew/model/UpdateProjectResult.h>
#include <aws/databrew/model/UpdateRecipeJobRequest.h>
#include <aws/databrew/model/UpdateRecipeJobResult.h>
#include <aws/databrew/model/UpdateRecipeRequest.h>
#include <aws/databrew/model/UpdateRecipeResult.h>
#include <aws/databrew/model/UpdateRulesetRequest.h>
#include <aws/databrew/model/UpdateRulesetResult.h>
#include <aws/databrew/model/UpdateScheduleRequest.h>
#include <aws/databrew/model/UpdateScheduleResult.h>
#include <aws/databrew/model/ValidationConfiguration.h>
#include <aws/databrew/model/ValidationMode.h>
#include <aws/databrew/model/ViewFrame.h>

using GlueDataBrewIncludeTest = ::testing::Test;

TEST_F(GlueDataBrewIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::GlueDataBrew::GlueDataBrewClient>("GlueDataBrewIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
