/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/dataexchange/DataExchangeClient.h>
#include <aws/dataexchange/DataExchangeEndpointProvider.h>
#include <aws/dataexchange/DataExchangeEndpointRules.h>
#include <aws/dataexchange/DataExchangeErrorMarshaller.h>
#include <aws/dataexchange/DataExchangeErrors.h>
#include <aws/dataexchange/DataExchangeRequest.h>
#include <aws/dataexchange/DataExchangeServiceClientModel.h>
#include <aws/dataexchange/DataExchange_EXPORTS.h>
#include <aws/dataexchange/model/AcceptDataGrantRequest.h>
#include <aws/dataexchange/model/AcceptDataGrantResult.h>
#include <aws/dataexchange/model/AcceptanceStateFilterValue.h>
#include <aws/dataexchange/model/Action.h>
#include <aws/dataexchange/model/ApiGatewayApiAsset.h>
#include <aws/dataexchange/model/AssetDestinationEntry.h>
#include <aws/dataexchange/model/AssetDetails.h>
#include <aws/dataexchange/model/AssetEntry.h>
#include <aws/dataexchange/model/AssetSourceEntry.h>
#include <aws/dataexchange/model/AssetType.h>
#include <aws/dataexchange/model/AutoExportRevisionDestinationEntry.h>
#include <aws/dataexchange/model/AutoExportRevisionToS3RequestDetails.h>
#include <aws/dataexchange/model/CancelJobRequest.h>
#include <aws/dataexchange/model/Code.h>
#include <aws/dataexchange/model/ConflictException.h>
#include <aws/dataexchange/model/CreateDataGrantRequest.h>
#include <aws/dataexchange/model/CreateDataGrantResult.h>
#include <aws/dataexchange/model/CreateDataSetRequest.h>
#include <aws/dataexchange/model/CreateDataSetResult.h>
#include <aws/dataexchange/model/CreateEventActionRequest.h>
#include <aws/dataexchange/model/CreateEventActionResult.h>
#include <aws/dataexchange/model/CreateJobRequest.h>
#include <aws/dataexchange/model/CreateJobResult.h>
#include <aws/dataexchange/model/CreateRevisionRequest.h>
#include <aws/dataexchange/model/CreateRevisionResult.h>
#include <aws/dataexchange/model/CreateS3DataAccessFromS3BucketRequestDetails.h>
#include <aws/dataexchange/model/CreateS3DataAccessFromS3BucketResponseDetails.h>
#include <aws/dataexchange/model/DataGrantAcceptanceState.h>
#include <aws/dataexchange/model/DataGrantSummaryEntry.h>
#include <aws/dataexchange/model/DataSetEntry.h>
#include <aws/dataexchange/model/DataUpdateRequestDetails.h>
#include <aws/dataexchange/model/DatabaseLFTagPolicy.h>
#include <aws/dataexchange/model/DatabaseLFTagPolicyAndPermissions.h>
#include <aws/dataexchange/model/DatabaseLFTagPolicyPermission.h>
#include <aws/dataexchange/model/DeleteAssetRequest.h>
#include <aws/dataexchange/model/DeleteDataGrantRequest.h>
#include <aws/dataexchange/model/DeleteDataSetRequest.h>
#include <aws/dataexchange/model/DeleteEventActionRequest.h>
#include <aws/dataexchange/model/DeleteRevisionRequest.h>
#include <aws/dataexchange/model/DeprecationRequestDetails.h>
#include <aws/dataexchange/model/Details.h>
#include <aws/dataexchange/model/Event.h>
#include <aws/dataexchange/model/EventActionEntry.h>
#include <aws/dataexchange/model/ExceptionCause.h>
#include <aws/dataexchange/model/ExportAssetToSignedUrlRequestDetails.h>
#include <aws/dataexchange/model/ExportAssetToSignedUrlResponseDetails.h>
#include <aws/dataexchange/model/ExportAssetsToS3RequestDetails.h>
#include <aws/dataexchange/model/ExportAssetsToS3ResponseDetails.h>
#include <aws/dataexchange/model/ExportRevisionsToS3RequestDetails.h>
#include <aws/dataexchange/model/ExportRevisionsToS3ResponseDetails.h>
#include <aws/dataexchange/model/ExportServerSideEncryption.h>
#include <aws/dataexchange/model/GetAssetRequest.h>
#include <aws/dataexchange/model/GetAssetResult.h>
#include <aws/dataexchange/model/GetDataGrantRequest.h>
#include <aws/dataexchange/model/GetDataGrantResult.h>
#include <aws/dataexchange/model/GetDataSetRequest.h>
#include <aws/dataexchange/model/GetDataSetResult.h>
#include <aws/dataexchange/model/GetEventActionRequest.h>
#include <aws/dataexchange/model/GetEventActionResult.h>
#include <aws/dataexchange/model/GetJobRequest.h>
#include <aws/dataexchange/model/GetJobResult.h>
#include <aws/dataexchange/model/GetReceivedDataGrantRequest.h>
#include <aws/dataexchange/model/GetReceivedDataGrantResult.h>
#include <aws/dataexchange/model/GetRevisionRequest.h>
#include <aws/dataexchange/model/GetRevisionResult.h>
#include <aws/dataexchange/model/GrantDistributionScope.h>
#include <aws/dataexchange/model/ImportAssetFromApiGatewayApiRequestDetails.h>
#include <aws/dataexchange/model/ImportAssetFromApiGatewayApiResponseDetails.h>
#include <aws/dataexchange/model/ImportAssetFromSignedUrlJobErrorDetails.h>
#include <aws/dataexchange/model/ImportAssetFromSignedUrlRequestDetails.h>
#include <aws/dataexchange/model/ImportAssetFromSignedUrlResponseDetails.h>
#include <aws/dataexchange/model/ImportAssetsFromLakeFormationTagPolicyRequestDetails.h>
#include <aws/dataexchange/model/ImportAssetsFromLakeFormationTagPolicyResponseDetails.h>
#include <aws/dataexchange/model/ImportAssetsFromRedshiftDataSharesRequestDetails.h>
#include <aws/dataexchange/model/ImportAssetsFromRedshiftDataSharesResponseDetails.h>
#include <aws/dataexchange/model/ImportAssetsFromS3RequestDetails.h>
#include <aws/dataexchange/model/ImportAssetsFromS3ResponseDetails.h>
#include <aws/dataexchange/model/JobEntry.h>
#include <aws/dataexchange/model/JobError.h>
#include <aws/dataexchange/model/JobErrorLimitName.h>
#include <aws/dataexchange/model/JobErrorResourceTypes.h>
#include <aws/dataexchange/model/KmsKeyToGrant.h>
#include <aws/dataexchange/model/LFPermission.h>
#include <aws/dataexchange/model/LFResourceDetails.h>
#include <aws/dataexchange/model/LFResourceType.h>
#include <aws/dataexchange/model/LFTag.h>
#include <aws/dataexchange/model/LFTagPolicyDetails.h>
#include <aws/dataexchange/model/LakeFormationDataPermissionAsset.h>
#include <aws/dataexchange/model/LakeFormationDataPermissionDetails.h>
#include <aws/dataexchange/model/LakeFormationDataPermissionType.h>
#include <aws/dataexchange/model/LakeFormationTagPolicyDetails.h>
#include <aws/dataexchange/model/LimitName.h>
#include <aws/dataexchange/model/ListDataGrantsRequest.h>
#include <aws/dataexchange/model/ListDataGrantsResult.h>
#include <aws/dataexchange/model/ListDataSetRevisionsRequest.h>
#include <aws/dataexchange/model/ListDataSetRevisionsResult.h>
#include <aws/dataexchange/model/ListDataSetsRequest.h>
#include <aws/dataexchange/model/ListDataSetsResult.h>
#include <aws/dataexchange/model/ListEventActionsRequest.h>
#include <aws/dataexchange/model/ListEventActionsResult.h>
#include <aws/dataexchange/model/ListJobsRequest.h>
#include <aws/dataexchange/model/ListJobsResult.h>
#include <aws/dataexchange/model/ListReceivedDataGrantsRequest.h>
#include <aws/dataexchange/model/ListReceivedDataGrantsResult.h>
#include <aws/dataexchange/model/ListRevisionAssetsRequest.h>
#include <aws/dataexchange/model/ListRevisionAssetsResult.h>
#include <aws/dataexchange/model/ListTagsForResourceRequest.h>
#include <aws/dataexchange/model/ListTagsForResourceResult.h>
#include <aws/dataexchange/model/NotificationDetails.h>
#include <aws/dataexchange/model/NotificationType.h>
#include <aws/dataexchange/model/Origin.h>
#include <aws/dataexchange/model/OriginDetails.h>
#include <aws/dataexchange/model/ProtocolType.h>
#include <aws/dataexchange/model/ReceivedDataGrantSummariesEntry.h>
#include <aws/dataexchange/model/RedshiftDataShareAsset.h>
#include <aws/dataexchange/model/RedshiftDataShareAssetSourceEntry.h>
#include <aws/dataexchange/model/RedshiftDataShareDetails.h>
#include <aws/dataexchange/model/RequestDetails.h>
#include <aws/dataexchange/model/ResourceNotFoundException.h>
#include <aws/dataexchange/model/ResourceType.h>
#include <aws/dataexchange/model/ResponseDetails.h>
#include <aws/dataexchange/model/RevisionDestinationEntry.h>
#include <aws/dataexchange/model/RevisionEntry.h>
#include <aws/dataexchange/model/RevisionPublished.h>
#include <aws/dataexchange/model/RevokeRevisionRequest.h>
#include <aws/dataexchange/model/RevokeRevisionResult.h>
#include <aws/dataexchange/model/S3DataAccessAsset.h>
#include <aws/dataexchange/model/S3DataAccessAssetSourceEntry.h>
#include <aws/dataexchange/model/S3DataAccessDetails.h>
#include <aws/dataexchange/model/S3SnapshotAsset.h>
#include <aws/dataexchange/model/SchemaChangeDetails.h>
#include <aws/dataexchange/model/SchemaChangeRequestDetails.h>
#include <aws/dataexchange/model/SchemaChangeType.h>
#include <aws/dataexchange/model/ScopeDetails.h>
#include <aws/dataexchange/model/SendApiAssetRequest.h>
#include <aws/dataexchange/model/SendApiAssetResult.h>
#include <aws/dataexchange/model/SendDataSetNotificationRequest.h>
#include <aws/dataexchange/model/SendDataSetNotificationResult.h>
#include <aws/dataexchange/model/ServerSideEncryptionTypes.h>
#include <aws/dataexchange/model/ServiceLimitExceededException.h>
#include <aws/dataexchange/model/StartJobRequest.h>
#include <aws/dataexchange/model/StartJobResult.h>
#include <aws/dataexchange/model/State.h>
#include <aws/dataexchange/model/TableLFTagPolicy.h>
#include <aws/dataexchange/model/TableLFTagPolicyAndPermissions.h>
#include <aws/dataexchange/model/TableTagPolicyLFPermission.h>
#include <aws/dataexchange/model/TagResourceRequest.h>
#include <aws/dataexchange/model/Type.h>
#include <aws/dataexchange/model/UntagResourceRequest.h>
#include <aws/dataexchange/model/UpdateAssetRequest.h>
#include <aws/dataexchange/model/UpdateAssetResult.h>
#include <aws/dataexchange/model/UpdateDataSetRequest.h>
#include <aws/dataexchange/model/UpdateDataSetResult.h>
#include <aws/dataexchange/model/UpdateEventActionRequest.h>
#include <aws/dataexchange/model/UpdateEventActionResult.h>
#include <aws/dataexchange/model/UpdateRevisionRequest.h>
#include <aws/dataexchange/model/UpdateRevisionResult.h>
#include <aws/dataexchange/model/ValidationException.h>

using DataExchangeIncludeTest = ::testing::Test;

TEST_F(DataExchangeIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::DataExchange::DataExchangeClient>("DataExchangeIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
