/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/datasync/DataSyncClient.h>
#include <aws/datasync/DataSyncEndpointProvider.h>
#include <aws/datasync/DataSyncEndpointRules.h>
#include <aws/datasync/DataSyncErrorMarshaller.h>
#include <aws/datasync/DataSyncErrors.h>
#include <aws/datasync/DataSyncRequest.h>
#include <aws/datasync/DataSyncServiceClientModel.h>
#include <aws/datasync/DataSync_EXPORTS.h>
#include <aws/datasync/model/AgentListEntry.h>
#include <aws/datasync/model/AgentStatus.h>
#include <aws/datasync/model/Atime.h>
#include <aws/datasync/model/AzureAccessTier.h>
#include <aws/datasync/model/AzureBlobAuthenticationType.h>
#include <aws/datasync/model/AzureBlobSasConfiguration.h>
#include <aws/datasync/model/AzureBlobType.h>
#include <aws/datasync/model/CancelTaskExecutionRequest.h>
#include <aws/datasync/model/CancelTaskExecutionResult.h>
#include <aws/datasync/model/CmkSecretConfig.h>
#include <aws/datasync/model/CreateAgentRequest.h>
#include <aws/datasync/model/CreateAgentResult.h>
#include <aws/datasync/model/CreateLocationAzureBlobRequest.h>
#include <aws/datasync/model/CreateLocationAzureBlobResult.h>
#include <aws/datasync/model/CreateLocationEfsRequest.h>
#include <aws/datasync/model/CreateLocationEfsResult.h>
#include <aws/datasync/model/CreateLocationFsxLustreRequest.h>
#include <aws/datasync/model/CreateLocationFsxLustreResult.h>
#include <aws/datasync/model/CreateLocationFsxOntapRequest.h>
#include <aws/datasync/model/CreateLocationFsxOntapResult.h>
#include <aws/datasync/model/CreateLocationFsxOpenZfsRequest.h>
#include <aws/datasync/model/CreateLocationFsxOpenZfsResult.h>
#include <aws/datasync/model/CreateLocationFsxWindowsRequest.h>
#include <aws/datasync/model/CreateLocationFsxWindowsResult.h>
#include <aws/datasync/model/CreateLocationHdfsRequest.h>
#include <aws/datasync/model/CreateLocationHdfsResult.h>
#include <aws/datasync/model/CreateLocationNfsRequest.h>
#include <aws/datasync/model/CreateLocationNfsResult.h>
#include <aws/datasync/model/CreateLocationObjectStorageRequest.h>
#include <aws/datasync/model/CreateLocationObjectStorageResult.h>
#include <aws/datasync/model/CreateLocationS3Request.h>
#include <aws/datasync/model/CreateLocationS3Result.h>
#include <aws/datasync/model/CreateLocationSmbRequest.h>
#include <aws/datasync/model/CreateLocationSmbResult.h>
#include <aws/datasync/model/CreateTaskRequest.h>
#include <aws/datasync/model/CreateTaskResult.h>
#include <aws/datasync/model/CustomSecretConfig.h>
#include <aws/datasync/model/DeleteAgentRequest.h>
#include <aws/datasync/model/DeleteAgentResult.h>
#include <aws/datasync/model/DeleteLocationRequest.h>
#include <aws/datasync/model/DeleteLocationResult.h>
#include <aws/datasync/model/DeleteTaskRequest.h>
#include <aws/datasync/model/DeleteTaskResult.h>
#include <aws/datasync/model/DescribeAgentRequest.h>
#include <aws/datasync/model/DescribeAgentResult.h>
#include <aws/datasync/model/DescribeLocationAzureBlobRequest.h>
#include <aws/datasync/model/DescribeLocationAzureBlobResult.h>
#include <aws/datasync/model/DescribeLocationEfsRequest.h>
#include <aws/datasync/model/DescribeLocationEfsResult.h>
#include <aws/datasync/model/DescribeLocationFsxLustreRequest.h>
#include <aws/datasync/model/DescribeLocationFsxLustreResult.h>
#include <aws/datasync/model/DescribeLocationFsxOntapRequest.h>
#include <aws/datasync/model/DescribeLocationFsxOntapResult.h>
#include <aws/datasync/model/DescribeLocationFsxOpenZfsRequest.h>
#include <aws/datasync/model/DescribeLocationFsxOpenZfsResult.h>
#include <aws/datasync/model/DescribeLocationFsxWindowsRequest.h>
#include <aws/datasync/model/DescribeLocationFsxWindowsResult.h>
#include <aws/datasync/model/DescribeLocationHdfsRequest.h>
#include <aws/datasync/model/DescribeLocationHdfsResult.h>
#include <aws/datasync/model/DescribeLocationNfsRequest.h>
#include <aws/datasync/model/DescribeLocationNfsResult.h>
#include <aws/datasync/model/DescribeLocationObjectStorageRequest.h>
#include <aws/datasync/model/DescribeLocationObjectStorageResult.h>
#include <aws/datasync/model/DescribeLocationS3Request.h>
#include <aws/datasync/model/DescribeLocationS3Result.h>
#include <aws/datasync/model/DescribeLocationSmbRequest.h>
#include <aws/datasync/model/DescribeLocationSmbResult.h>
#include <aws/datasync/model/DescribeTaskExecutionRequest.h>
#include <aws/datasync/model/DescribeTaskExecutionResult.h>
#include <aws/datasync/model/DescribeTaskRequest.h>
#include <aws/datasync/model/DescribeTaskResult.h>
#include <aws/datasync/model/Ec2Config.h>
#include <aws/datasync/model/EfsInTransitEncryption.h>
#include <aws/datasync/model/EndpointType.h>
#include <aws/datasync/model/FilterRule.h>
#include <aws/datasync/model/FilterType.h>
#include <aws/datasync/model/FsxProtocol.h>
#include <aws/datasync/model/FsxProtocolNfs.h>
#include <aws/datasync/model/FsxProtocolSmb.h>
#include <aws/datasync/model/FsxUpdateProtocol.h>
#include <aws/datasync/model/FsxUpdateProtocolSmb.h>
#include <aws/datasync/model/Gid.h>
#include <aws/datasync/model/HdfsAuthenticationType.h>
#include <aws/datasync/model/HdfsDataTransferProtection.h>
#include <aws/datasync/model/HdfsNameNode.h>
#include <aws/datasync/model/HdfsRpcProtection.h>
#include <aws/datasync/model/InternalException.h>
#include <aws/datasync/model/InvalidRequestException.h>
#include <aws/datasync/model/ListAgentsRequest.h>
#include <aws/datasync/model/ListAgentsResult.h>
#include <aws/datasync/model/ListLocationsRequest.h>
#include <aws/datasync/model/ListLocationsResult.h>
#include <aws/datasync/model/ListTagsForResourceRequest.h>
#include <aws/datasync/model/ListTagsForResourceResult.h>
#include <aws/datasync/model/ListTaskExecutionsRequest.h>
#include <aws/datasync/model/ListTaskExecutionsResult.h>
#include <aws/datasync/model/ListTasksRequest.h>
#include <aws/datasync/model/ListTasksResult.h>
#include <aws/datasync/model/LocationFilter.h>
#include <aws/datasync/model/LocationFilterName.h>
#include <aws/datasync/model/LocationListEntry.h>
#include <aws/datasync/model/LogLevel.h>
#include <aws/datasync/model/ManagedSecretConfig.h>
#include <aws/datasync/model/ManifestAction.h>
#include <aws/datasync/model/ManifestConfig.h>
#include <aws/datasync/model/ManifestFormat.h>
#include <aws/datasync/model/Mtime.h>
#include <aws/datasync/model/NfsMountOptions.h>
#include <aws/datasync/model/NfsVersion.h>
#include <aws/datasync/model/ObjectStorageServerProtocol.h>
#include <aws/datasync/model/ObjectTags.h>
#include <aws/datasync/model/ObjectVersionIds.h>
#include <aws/datasync/model/OnPremConfig.h>
#include <aws/datasync/model/Operator.h>
#include <aws/datasync/model/Options.h>
#include <aws/datasync/model/OverwriteMode.h>
#include <aws/datasync/model/PhaseStatus.h>
#include <aws/datasync/model/Platform.h>
#include <aws/datasync/model/PosixPermissions.h>
#include <aws/datasync/model/PreserveDeletedFiles.h>
#include <aws/datasync/model/PreserveDevices.h>
#include <aws/datasync/model/PrivateLinkConfig.h>
#include <aws/datasync/model/QopConfiguration.h>
#include <aws/datasync/model/ReportDestination.h>
#include <aws/datasync/model/ReportDestinationS3.h>
#include <aws/datasync/model/ReportLevel.h>
#include <aws/datasync/model/ReportOutputType.h>
#include <aws/datasync/model/ReportOverride.h>
#include <aws/datasync/model/ReportOverrides.h>
#include <aws/datasync/model/ReportResult.h>
#include <aws/datasync/model/S3Config.h>
#include <aws/datasync/model/S3ManifestConfig.h>
#include <aws/datasync/model/S3StorageClass.h>
#include <aws/datasync/model/ScheduleDisabledBy.h>
#include <aws/datasync/model/ScheduleStatus.h>
#include <aws/datasync/model/SmbAuthenticationType.h>
#include <aws/datasync/model/SmbMountOptions.h>
#include <aws/datasync/model/SmbSecurityDescriptorCopyFlags.h>
#include <aws/datasync/model/SmbVersion.h>
#include <aws/datasync/model/SourceManifestConfig.h>
#include <aws/datasync/model/StartTaskExecutionRequest.h>
#include <aws/datasync/model/StartTaskExecutionResult.h>
#include <aws/datasync/model/TagListEntry.h>
#include <aws/datasync/model/TagResourceRequest.h>
#include <aws/datasync/model/TagResourceResult.h>
#include <aws/datasync/model/TaskExecutionFilesFailedDetail.h>
#include <aws/datasync/model/TaskExecutionFilesListedDetail.h>
#include <aws/datasync/model/TaskExecutionListEntry.h>
#include <aws/datasync/model/TaskExecutionResultDetail.h>
#include <aws/datasync/model/TaskExecutionStatus.h>
#include <aws/datasync/model/TaskFilter.h>
#include <aws/datasync/model/TaskFilterName.h>
#include <aws/datasync/model/TaskListEntry.h>
#include <aws/datasync/model/TaskMode.h>
#include <aws/datasync/model/TaskQueueing.h>
#include <aws/datasync/model/TaskReportConfig.h>
#include <aws/datasync/model/TaskSchedule.h>
#include <aws/datasync/model/TaskScheduleDetails.h>
#include <aws/datasync/model/TaskStatus.h>
#include <aws/datasync/model/TransferMode.h>
#include <aws/datasync/model/Uid.h>
#include <aws/datasync/model/UntagResourceRequest.h>
#include <aws/datasync/model/UntagResourceResult.h>
#include <aws/datasync/model/UpdateAgentRequest.h>
#include <aws/datasync/model/UpdateAgentResult.h>
#include <aws/datasync/model/UpdateLocationAzureBlobRequest.h>
#include <aws/datasync/model/UpdateLocationAzureBlobResult.h>
#include <aws/datasync/model/UpdateLocationEfsRequest.h>
#include <aws/datasync/model/UpdateLocationEfsResult.h>
#include <aws/datasync/model/UpdateLocationFsxLustreRequest.h>
#include <aws/datasync/model/UpdateLocationFsxLustreResult.h>
#include <aws/datasync/model/UpdateLocationFsxOntapRequest.h>
#include <aws/datasync/model/UpdateLocationFsxOntapResult.h>
#include <aws/datasync/model/UpdateLocationFsxOpenZfsRequest.h>
#include <aws/datasync/model/UpdateLocationFsxOpenZfsResult.h>
#include <aws/datasync/model/UpdateLocationFsxWindowsRequest.h>
#include <aws/datasync/model/UpdateLocationFsxWindowsResult.h>
#include <aws/datasync/model/UpdateLocationHdfsRequest.h>
#include <aws/datasync/model/UpdateLocationHdfsResult.h>
#include <aws/datasync/model/UpdateLocationNfsRequest.h>
#include <aws/datasync/model/UpdateLocationNfsResult.h>
#include <aws/datasync/model/UpdateLocationObjectStorageRequest.h>
#include <aws/datasync/model/UpdateLocationObjectStorageResult.h>
#include <aws/datasync/model/UpdateLocationS3Request.h>
#include <aws/datasync/model/UpdateLocationS3Result.h>
#include <aws/datasync/model/UpdateLocationSmbRequest.h>
#include <aws/datasync/model/UpdateLocationSmbResult.h>
#include <aws/datasync/model/UpdateTaskExecutionRequest.h>
#include <aws/datasync/model/UpdateTaskExecutionResult.h>
#include <aws/datasync/model/UpdateTaskRequest.h>
#include <aws/datasync/model/UpdateTaskResult.h>
#include <aws/datasync/model/VerifyMode.h>

using DataSyncIncludeTest = ::testing::Test;

TEST_F(DataSyncIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::DataSync::DataSyncClient>("DataSyncIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
