/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/datazone/DataZoneClient.h>
#include <aws/datazone/DataZoneEndpointProvider.h>
#include <aws/datazone/DataZoneEndpointRules.h>
#include <aws/datazone/DataZoneErrorMarshaller.h>
#include <aws/datazone/DataZoneErrors.h>
#include <aws/datazone/DataZoneRequest.h>
#include <aws/datazone/DataZoneServiceClientModel.h>
#include <aws/datazone/DataZone_EXPORTS.h>
#include <aws/datazone/model/AcceptChoice.h>
#include <aws/datazone/model/AcceptPredictionsRequest.h>
#include <aws/datazone/model/AcceptPredictionsResult.h>
#include <aws/datazone/model/AcceptRule.h>
#include <aws/datazone/model/AcceptRuleBehavior.h>
#include <aws/datazone/model/AcceptSubscriptionRequestRequest.h>
#include <aws/datazone/model/AcceptSubscriptionRequestResult.h>
#include <aws/datazone/model/AcceptedAssetScope.h>
#include <aws/datazone/model/ActionParameters.h>
#include <aws/datazone/model/AddEntityOwnerRequest.h>
#include <aws/datazone/model/AddEntityOwnerResult.h>
#include <aws/datazone/model/AddPolicyGrantRequest.h>
#include <aws/datazone/model/AddPolicyGrantResult.h>
#include <aws/datazone/model/AddToProjectMemberPoolPolicyGrantDetail.h>
#include <aws/datazone/model/AllDomainUnitsGrantFilter.h>
#include <aws/datazone/model/AllUsersGrantFilter.h>
#include <aws/datazone/model/AssetFilterConfiguration.h>
#include <aws/datazone/model/AssetFilterSummary.h>
#include <aws/datazone/model/AssetInDataProductListingItem.h>
#include <aws/datazone/model/AssetItem.h>
#include <aws/datazone/model/AssetItemAdditionalAttributes.h>
#include <aws/datazone/model/AssetListing.h>
#include <aws/datazone/model/AssetListingDetails.h>
#include <aws/datazone/model/AssetListingItem.h>
#include <aws/datazone/model/AssetListingItemAdditionalAttributes.h>
#include <aws/datazone/model/AssetRevision.h>
#include <aws/datazone/model/AssetScope.h>
#include <aws/datazone/model/AssetTargetNameMap.h>
#include <aws/datazone/model/AssetTypeItem.h>
#include <aws/datazone/model/AssetTypesForRule.h>
#include <aws/datazone/model/AssociateEnvironmentRoleRequest.h>
#include <aws/datazone/model/AssociateEnvironmentRoleResult.h>
#include <aws/datazone/model/AthenaPropertiesInput.h>
#include <aws/datazone/model/AthenaPropertiesOutput.h>
#include <aws/datazone/model/AthenaPropertiesPatch.h>
#include <aws/datazone/model/AuthType.h>
#include <aws/datazone/model/AuthenticationConfiguration.h>
#include <aws/datazone/model/AuthenticationConfigurationInput.h>
#include <aws/datazone/model/AuthenticationConfigurationPatch.h>
#include <aws/datazone/model/AuthenticationType.h>
#include <aws/datazone/model/AuthorizationCodeProperties.h>
#include <aws/datazone/model/AwsAccount.h>
#include <aws/datazone/model/AwsConsoleLinkParameters.h>
#include <aws/datazone/model/AwsLocation.h>
#include <aws/datazone/model/BasicAuthenticationCredentials.h>
#include <aws/datazone/model/BusinessNameGenerationConfiguration.h>
#include <aws/datazone/model/CancelMetadataGenerationRunRequest.h>
#include <aws/datazone/model/CancelMetadataGenerationRunResult.h>
#include <aws/datazone/model/CancelSubscriptionRequest.h>
#include <aws/datazone/model/CancelSubscriptionResult.h>
#include <aws/datazone/model/ChangeAction.h>
#include <aws/datazone/model/CloudFormationProperties.h>
#include <aws/datazone/model/ColumnFilterConfiguration.h>
#include <aws/datazone/model/ComputeEnvironments.h>
#include <aws/datazone/model/ConfigurableActionParameter.h>
#include <aws/datazone/model/ConfigurableActionTypeAuthorization.h>
#include <aws/datazone/model/ConfigurableEnvironmentAction.h>
#include <aws/datazone/model/ConnectionCredentials.h>
#include <aws/datazone/model/ConnectionPropertiesInput.h>
#include <aws/datazone/model/ConnectionPropertiesOutput.h>
#include <aws/datazone/model/ConnectionPropertiesPatch.h>
#include <aws/datazone/model/ConnectionStatus.h>
#include <aws/datazone/model/ConnectionSummary.h>
#include <aws/datazone/model/ConnectionType.h>
#include <aws/datazone/model/CreateAssetFilterRequest.h>
#include <aws/datazone/model/CreateAssetFilterResult.h>
#include <aws/datazone/model/CreateAssetRequest.h>
#include <aws/datazone/model/CreateAssetResult.h>
#include <aws/datazone/model/CreateAssetRevisionRequest.h>
#include <aws/datazone/model/CreateAssetRevisionResult.h>
#include <aws/datazone/model/CreateAssetTypePolicyGrantDetail.h>
#include <aws/datazone/model/CreateAssetTypeRequest.h>
#include <aws/datazone/model/CreateAssetTypeResult.h>
#include <aws/datazone/model/CreateConnectionRequest.h>
#include <aws/datazone/model/CreateConnectionResult.h>
#include <aws/datazone/model/CreateDataProductRequest.h>
#include <aws/datazone/model/CreateDataProductResult.h>
#include <aws/datazone/model/CreateDataProductRevisionRequest.h>
#include <aws/datazone/model/CreateDataProductRevisionResult.h>
#include <aws/datazone/model/CreateDataSourceRequest.h>
#include <aws/datazone/model/CreateDataSourceResult.h>
#include <aws/datazone/model/CreateDomainRequest.h>
#include <aws/datazone/model/CreateDomainResult.h>
#include <aws/datazone/model/CreateDomainUnitPolicyGrantDetail.h>
#include <aws/datazone/model/CreateDomainUnitRequest.h>
#include <aws/datazone/model/CreateDomainUnitResult.h>
#include <aws/datazone/model/CreateEnvironmentActionRequest.h>
#include <aws/datazone/model/CreateEnvironmentActionResult.h>
#include <aws/datazone/model/CreateEnvironmentProfilePolicyGrantDetail.h>
#include <aws/datazone/model/CreateEnvironmentProfileRequest.h>
#include <aws/datazone/model/CreateEnvironmentProfileResult.h>
#include <aws/datazone/model/CreateEnvironmentRequest.h>
#include <aws/datazone/model/CreateEnvironmentResult.h>
#include <aws/datazone/model/CreateFormTypePolicyGrantDetail.h>
#include <aws/datazone/model/CreateFormTypeRequest.h>
#include <aws/datazone/model/CreateFormTypeResult.h>
#include <aws/datazone/model/CreateGlossaryPolicyGrantDetail.h>
#include <aws/datazone/model/CreateGlossaryRequest.h>
#include <aws/datazone/model/CreateGlossaryResult.h>
#include <aws/datazone/model/CreateGlossaryTermRequest.h>
#include <aws/datazone/model/CreateGlossaryTermResult.h>
#include <aws/datazone/model/CreateGroupProfileRequest.h>
#include <aws/datazone/model/CreateGroupProfileResult.h>
#include <aws/datazone/model/CreateListingChangeSetRequest.h>
#include <aws/datazone/model/CreateListingChangeSetResult.h>
#include <aws/datazone/model/CreateProjectFromProjectProfilePolicyGrantDetail.h>
#include <aws/datazone/model/CreateProjectMembershipRequest.h>
#include <aws/datazone/model/CreateProjectMembershipResult.h>
#include <aws/datazone/model/CreateProjectPolicyGrantDetail.h>
#include <aws/datazone/model/CreateProjectProfileRequest.h>
#include <aws/datazone/model/CreateProjectProfileResult.h>
#include <aws/datazone/model/CreateProjectRequest.h>
#include <aws/datazone/model/CreateProjectResult.h>
#include <aws/datazone/model/CreateRuleRequest.h>
#include <aws/datazone/model/CreateRuleResult.h>
#include <aws/datazone/model/CreateSubscriptionGrantRequest.h>
#include <aws/datazone/model/CreateSubscriptionGrantResult.h>
#include <aws/datazone/model/CreateSubscriptionRequestRequest.h>
#include <aws/datazone/model/CreateSubscriptionRequestResult.h>
#include <aws/datazone/model/CreateSubscriptionTargetRequest.h>
#include <aws/datazone/model/CreateSubscriptionTargetResult.h>
#include <aws/datazone/model/CreateUserProfileRequest.h>
#include <aws/datazone/model/CreateUserProfileResult.h>
#include <aws/datazone/model/CustomParameter.h>
#include <aws/datazone/model/DataAssetActivityStatus.h>
#include <aws/datazone/model/DataProductItem.h>
#include <aws/datazone/model/DataProductItemType.h>
#include <aws/datazone/model/DataProductListing.h>
#include <aws/datazone/model/DataProductListingItem.h>
#include <aws/datazone/model/DataProductListingItemAdditionalAttributes.h>
#include <aws/datazone/model/DataProductResultItem.h>
#include <aws/datazone/model/DataProductRevision.h>
#include <aws/datazone/model/DataProductStatus.h>
#include <aws/datazone/model/DataSourceConfigurationInput.h>
#include <aws/datazone/model/DataSourceConfigurationOutput.h>
#include <aws/datazone/model/DataSourceErrorMessage.h>
#include <aws/datazone/model/DataSourceErrorType.h>
#include <aws/datazone/model/DataSourceRunActivity.h>
#include <aws/datazone/model/DataSourceRunLineageSummary.h>
#include <aws/datazone/model/DataSourceRunStatus.h>
#include <aws/datazone/model/DataSourceRunSummary.h>
#include <aws/datazone/model/DataSourceRunType.h>
#include <aws/datazone/model/DataSourceStatus.h>
#include <aws/datazone/model/DataSourceSummary.h>
#include <aws/datazone/model/DataZoneEntityType.h>
#include <aws/datazone/model/DeleteAssetFilterRequest.h>
#include <aws/datazone/model/DeleteAssetRequest.h>
#include <aws/datazone/model/DeleteAssetResult.h>
#include <aws/datazone/model/DeleteAssetTypeRequest.h>
#include <aws/datazone/model/DeleteAssetTypeResult.h>
#include <aws/datazone/model/DeleteConnectionRequest.h>
#include <aws/datazone/model/DeleteConnectionResult.h>
#include <aws/datazone/model/DeleteDataProductRequest.h>
#include <aws/datazone/model/DeleteDataProductResult.h>
#include <aws/datazone/model/DeleteDataSourceRequest.h>
#include <aws/datazone/model/DeleteDataSourceResult.h>
#include <aws/datazone/model/DeleteDomainRequest.h>
#include <aws/datazone/model/DeleteDomainResult.h>
#include <aws/datazone/model/DeleteDomainUnitRequest.h>
#include <aws/datazone/model/DeleteDomainUnitResult.h>
#include <aws/datazone/model/DeleteEnvironmentActionRequest.h>
#include <aws/datazone/model/DeleteEnvironmentBlueprintConfigurationRequest.h>
#include <aws/datazone/model/DeleteEnvironmentBlueprintConfigurationResult.h>
#include <aws/datazone/model/DeleteEnvironmentProfileRequest.h>
#include <aws/datazone/model/DeleteEnvironmentRequest.h>
#include <aws/datazone/model/DeleteFormTypeRequest.h>
#include <aws/datazone/model/DeleteFormTypeResult.h>
#include <aws/datazone/model/DeleteGlossaryRequest.h>
#include <aws/datazone/model/DeleteGlossaryResult.h>
#include <aws/datazone/model/DeleteGlossaryTermRequest.h>
#include <aws/datazone/model/DeleteGlossaryTermResult.h>
#include <aws/datazone/model/DeleteListingRequest.h>
#include <aws/datazone/model/DeleteListingResult.h>
#include <aws/datazone/model/DeleteProjectMembershipRequest.h>
#include <aws/datazone/model/DeleteProjectMembershipResult.h>
#include <aws/datazone/model/DeleteProjectProfileRequest.h>
#include <aws/datazone/model/DeleteProjectProfileResult.h>
#include <aws/datazone/model/DeleteProjectRequest.h>
#include <aws/datazone/model/DeleteProjectResult.h>
#include <aws/datazone/model/DeleteRuleRequest.h>
#include <aws/datazone/model/DeleteRuleResult.h>
#include <aws/datazone/model/DeleteSubscriptionGrantRequest.h>
#include <aws/datazone/model/DeleteSubscriptionGrantResult.h>
#include <aws/datazone/model/DeleteSubscriptionRequestRequest.h>
#include <aws/datazone/model/DeleteSubscriptionTargetRequest.h>
#include <aws/datazone/model/DeleteTimeSeriesDataPointsRequest.h>
#include <aws/datazone/model/DeleteTimeSeriesDataPointsResult.h>
#include <aws/datazone/model/Deployment.h>
#include <aws/datazone/model/DeploymentMode.h>
#include <aws/datazone/model/DeploymentProperties.h>
#include <aws/datazone/model/DeploymentStatus.h>
#include <aws/datazone/model/DeploymentType.h>
#include <aws/datazone/model/DetailedGlossaryTerm.h>
#include <aws/datazone/model/DisassociateEnvironmentRoleRequest.h>
#include <aws/datazone/model/DisassociateEnvironmentRoleResult.h>
#include <aws/datazone/model/DomainStatus.h>
#include <aws/datazone/model/DomainSummary.h>
#include <aws/datazone/model/DomainUnitDesignation.h>
#include <aws/datazone/model/DomainUnitFilterForProject.h>
#include <aws/datazone/model/DomainUnitGrantFilter.h>
#include <aws/datazone/model/DomainUnitGroupProperties.h>
#include <aws/datazone/model/DomainUnitOwnerProperties.h>
#include <aws/datazone/model/DomainUnitPolicyGrantPrincipal.h>
#include <aws/datazone/model/DomainUnitSummary.h>
#include <aws/datazone/model/DomainUnitTarget.h>
#include <aws/datazone/model/DomainUnitUserProperties.h>
#include <aws/datazone/model/DomainVersion.h>
#include <aws/datazone/model/EdgeDirection.h>
#include <aws/datazone/model/EnableSetting.h>
#include <aws/datazone/model/EntityType.h>
#include <aws/datazone/model/EnvironmentActionSummary.h>
#include <aws/datazone/model/EnvironmentBlueprintConfigurationItem.h>
#include <aws/datazone/model/EnvironmentBlueprintSummary.h>
#include <aws/datazone/model/EnvironmentConfiguration.h>
#include <aws/datazone/model/EnvironmentConfigurationParameter.h>
#include <aws/datazone/model/EnvironmentConfigurationParametersDetails.h>
#include <aws/datazone/model/EnvironmentConfigurationUserParameter.h>
#include <aws/datazone/model/EnvironmentDeploymentDetails.h>
#include <aws/datazone/model/EnvironmentError.h>
#include <aws/datazone/model/EnvironmentParameter.h>
#include <aws/datazone/model/EnvironmentProfileSummary.h>
#include <aws/datazone/model/EnvironmentStatus.h>
#include <aws/datazone/model/EnvironmentSummary.h>
#include <aws/datazone/model/EqualToExpression.h>
#include <aws/datazone/model/EventSummary.h>
#include <aws/datazone/model/FailureCause.h>
#include <aws/datazone/model/Filter.h>
#include <aws/datazone/model/FilterClause.h>
#include <aws/datazone/model/FilterExpression.h>
#include <aws/datazone/model/FilterExpressionType.h>
#include <aws/datazone/model/FilterStatus.h>
#include <aws/datazone/model/FormEntryInput.h>
#include <aws/datazone/model/FormEntryOutput.h>
#include <aws/datazone/model/FormInput.h>
#include <aws/datazone/model/FormOutput.h>
#include <aws/datazone/model/FormTypeData.h>
#include <aws/datazone/model/FormTypeStatus.h>
#include <aws/datazone/model/GetAssetFilterRequest.h>
#include <aws/datazone/model/GetAssetFilterResult.h>
#include <aws/datazone/model/GetAssetRequest.h>
#include <aws/datazone/model/GetAssetResult.h>
#include <aws/datazone/model/GetAssetTypeRequest.h>
#include <aws/datazone/model/GetAssetTypeResult.h>
#include <aws/datazone/model/GetConnectionRequest.h>
#include <aws/datazone/model/GetConnectionResult.h>
#include <aws/datazone/model/GetDataProductRequest.h>
#include <aws/datazone/model/GetDataProductResult.h>
#include <aws/datazone/model/GetDataSourceRequest.h>
#include <aws/datazone/model/GetDataSourceResult.h>
#include <aws/datazone/model/GetDataSourceRunRequest.h>
#include <aws/datazone/model/GetDataSourceRunResult.h>
#include <aws/datazone/model/GetDomainRequest.h>
#include <aws/datazone/model/GetDomainResult.h>
#include <aws/datazone/model/GetDomainUnitRequest.h>
#include <aws/datazone/model/GetDomainUnitResult.h>
#include <aws/datazone/model/GetEnvironmentActionRequest.h>
#include <aws/datazone/model/GetEnvironmentActionResult.h>
#include <aws/datazone/model/GetEnvironmentBlueprintConfigurationRequest.h>
#include <aws/datazone/model/GetEnvironmentBlueprintConfigurationResult.h>
#include <aws/datazone/model/GetEnvironmentBlueprintRequest.h>
#include <aws/datazone/model/GetEnvironmentBlueprintResult.h>
#include <aws/datazone/model/GetEnvironmentCredentialsRequest.h>
#include <aws/datazone/model/GetEnvironmentCredentialsResult.h>
#include <aws/datazone/model/GetEnvironmentProfileRequest.h>
#include <aws/datazone/model/GetEnvironmentProfileResult.h>
#include <aws/datazone/model/GetEnvironmentRequest.h>
#include <aws/datazone/model/GetEnvironmentResult.h>
#include <aws/datazone/model/GetFormTypeRequest.h>
#include <aws/datazone/model/GetFormTypeResult.h>
#include <aws/datazone/model/GetGlossaryRequest.h>
#include <aws/datazone/model/GetGlossaryResult.h>
#include <aws/datazone/model/GetGlossaryTermRequest.h>
#include <aws/datazone/model/GetGlossaryTermResult.h>
#include <aws/datazone/model/GetGroupProfileRequest.h>
#include <aws/datazone/model/GetGroupProfileResult.h>
#include <aws/datazone/model/GetIamPortalLoginUrlRequest.h>
#include <aws/datazone/model/GetIamPortalLoginUrlResult.h>
#include <aws/datazone/model/GetJobRunRequest.h>
#include <aws/datazone/model/GetJobRunResult.h>
#include <aws/datazone/model/GetLineageEventRequest.h>
#include <aws/datazone/model/GetLineageEventResult.h>
#include <aws/datazone/model/GetLineageNodeRequest.h>
#include <aws/datazone/model/GetLineageNodeResult.h>
#include <aws/datazone/model/GetListingRequest.h>
#include <aws/datazone/model/GetListingResult.h>
#include <aws/datazone/model/GetMetadataGenerationRunRequest.h>
#include <aws/datazone/model/GetMetadataGenerationRunResult.h>
#include <aws/datazone/model/GetProjectProfileRequest.h>
#include <aws/datazone/model/GetProjectProfileResult.h>
#include <aws/datazone/model/GetProjectRequest.h>
#include <aws/datazone/model/GetProjectResult.h>
#include <aws/datazone/model/GetRuleRequest.h>
#include <aws/datazone/model/GetRuleResult.h>
#include <aws/datazone/model/GetSubscriptionGrantRequest.h>
#include <aws/datazone/model/GetSubscriptionGrantResult.h>
#include <aws/datazone/model/GetSubscriptionRequest.h>
#include <aws/datazone/model/GetSubscriptionRequestDetailsRequest.h>
#include <aws/datazone/model/GetSubscriptionRequestDetailsResult.h>
#include <aws/datazone/model/GetSubscriptionResult.h>
#include <aws/datazone/model/GetSubscriptionTargetRequest.h>
#include <aws/datazone/model/GetSubscriptionTargetResult.h>
#include <aws/datazone/model/GetTimeSeriesDataPointRequest.h>
#include <aws/datazone/model/GetTimeSeriesDataPointResult.h>
#include <aws/datazone/model/GetUserProfileRequest.h>
#include <aws/datazone/model/GetUserProfileResult.h>
#include <aws/datazone/model/GlossaryItem.h>
#include <aws/datazone/model/GlossaryStatus.h>
#include <aws/datazone/model/GlossaryTermItem.h>
#include <aws/datazone/model/GlossaryTermStatus.h>
#include <aws/datazone/model/GlueConnection.h>
#include <aws/datazone/model/GlueConnectionInput.h>
#include <aws/datazone/model/GlueConnectionPatch.h>
#include <aws/datazone/model/GlueConnectionType.h>
#include <aws/datazone/model/GlueOAuth2Credentials.h>
#include <aws/datazone/model/GluePropertiesInput.h>
#include <aws/datazone/model/GluePropertiesOutput.h>
#include <aws/datazone/model/GluePropertiesPatch.h>
#include <aws/datazone/model/GlueRunConfigurationInput.h>
#include <aws/datazone/model/GlueRunConfigurationOutput.h>
#include <aws/datazone/model/GlueSelfGrantStatusOutput.h>
#include <aws/datazone/model/GovernanceType.h>
#include <aws/datazone/model/GrantedEntity.h>
#include <aws/datazone/model/GrantedEntityInput.h>
#include <aws/datazone/model/GreaterThanExpression.h>
#include <aws/datazone/model/GreaterThanOrEqualToExpression.h>
#include <aws/datazone/model/GroupDetails.h>
#include <aws/datazone/model/GroupPolicyGrantPrincipal.h>
#include <aws/datazone/model/GroupProfileStatus.h>
#include <aws/datazone/model/GroupProfileSummary.h>
#include <aws/datazone/model/GroupSearchType.h>
#include <aws/datazone/model/HyperPodOrchestrator.h>
#include <aws/datazone/model/HyperPodPropertiesInput.h>
#include <aws/datazone/model/HyperPodPropertiesOutput.h>
#include <aws/datazone/model/IamPropertiesInput.h>
#include <aws/datazone/model/IamPropertiesOutput.h>
#include <aws/datazone/model/IamPropertiesPatch.h>
#include <aws/datazone/model/IamUserProfileDetails.h>
#include <aws/datazone/model/Import.h>
#include <aws/datazone/model/InExpression.h>
#include <aws/datazone/model/InventorySearchScope.h>
#include <aws/datazone/model/IsNotNullExpression.h>
#include <aws/datazone/model/IsNullExpression.h>
#include <aws/datazone/model/JobRunDetails.h>
#include <aws/datazone/model/JobRunError.h>
#include <aws/datazone/model/JobRunMode.h>
#include <aws/datazone/model/JobRunStatus.h>
#include <aws/datazone/model/JobRunSummary.h>
#include <aws/datazone/model/JobType.h>
#include <aws/datazone/model/LakeFormationConfiguration.h>
#include <aws/datazone/model/LessThanExpression.h>
#include <aws/datazone/model/LessThanOrEqualToExpression.h>
#include <aws/datazone/model/LikeExpression.h>
#include <aws/datazone/model/LineageEventProcessingStatus.h>
#include <aws/datazone/model/LineageEventSummary.h>
#include <aws/datazone/model/LineageImportStatus.h>
#include <aws/datazone/model/LineageInfo.h>
#include <aws/datazone/model/LineageNodeReference.h>
#include <aws/datazone/model/LineageNodeSummary.h>
#include <aws/datazone/model/LineageNodeTypeItem.h>
#include <aws/datazone/model/LineageRunDetails.h>
#include <aws/datazone/model/LineageSqlQueryRunDetails.h>
#include <aws/datazone/model/LineageSyncSchedule.h>
#include <aws/datazone/model/ListAssetFiltersRequest.h>
#include <aws/datazone/model/ListAssetFiltersResult.h>
#include <aws/datazone/model/ListAssetRevisionsRequest.h>
#include <aws/datazone/model/ListAssetRevisionsResult.h>
#include <aws/datazone/model/ListConnectionsRequest.h>
#include <aws/datazone/model/ListConnectionsResult.h>
#include <aws/datazone/model/ListDataProductRevisionsRequest.h>
#include <aws/datazone/model/ListDataProductRevisionsResult.h>
#include <aws/datazone/model/ListDataSourceRunActivitiesRequest.h>
#include <aws/datazone/model/ListDataSourceRunActivitiesResult.h>
#include <aws/datazone/model/ListDataSourceRunsRequest.h>
#include <aws/datazone/model/ListDataSourceRunsResult.h>
#include <aws/datazone/model/ListDataSourcesRequest.h>
#include <aws/datazone/model/ListDataSourcesResult.h>
#include <aws/datazone/model/ListDomainUnitsForParentRequest.h>
#include <aws/datazone/model/ListDomainUnitsForParentResult.h>
#include <aws/datazone/model/ListDomainsRequest.h>
#include <aws/datazone/model/ListDomainsResult.h>
#include <aws/datazone/model/ListEntityOwnersRequest.h>
#include <aws/datazone/model/ListEntityOwnersResult.h>
#include <aws/datazone/model/ListEnvironmentActionsRequest.h>
#include <aws/datazone/model/ListEnvironmentActionsResult.h>
#include <aws/datazone/model/ListEnvironmentBlueprintConfigurationsRequest.h>
#include <aws/datazone/model/ListEnvironmentBlueprintConfigurationsResult.h>
#include <aws/datazone/model/ListEnvironmentBlueprintsRequest.h>
#include <aws/datazone/model/ListEnvironmentBlueprintsResult.h>
#include <aws/datazone/model/ListEnvironmentProfilesRequest.h>
#include <aws/datazone/model/ListEnvironmentProfilesResult.h>
#include <aws/datazone/model/ListEnvironmentsRequest.h>
#include <aws/datazone/model/ListEnvironmentsResult.h>
#include <aws/datazone/model/ListJobRunsRequest.h>
#include <aws/datazone/model/ListJobRunsResult.h>
#include <aws/datazone/model/ListLineageEventsRequest.h>
#include <aws/datazone/model/ListLineageEventsResult.h>
#include <aws/datazone/model/ListLineageNodeHistoryRequest.h>
#include <aws/datazone/model/ListLineageNodeHistoryResult.h>
#include <aws/datazone/model/ListMetadataGenerationRunsRequest.h>
#include <aws/datazone/model/ListMetadataGenerationRunsResult.h>
#include <aws/datazone/model/ListNotificationsRequest.h>
#include <aws/datazone/model/ListNotificationsResult.h>
#include <aws/datazone/model/ListPolicyGrantsRequest.h>
#include <aws/datazone/model/ListPolicyGrantsResult.h>
#include <aws/datazone/model/ListProjectMembershipsRequest.h>
#include <aws/datazone/model/ListProjectMembershipsResult.h>
#include <aws/datazone/model/ListProjectProfilesRequest.h>
#include <aws/datazone/model/ListProjectProfilesResult.h>
#include <aws/datazone/model/ListProjectsRequest.h>
#include <aws/datazone/model/ListProjectsResult.h>
#include <aws/datazone/model/ListRulesRequest.h>
#include <aws/datazone/model/ListRulesResult.h>
#include <aws/datazone/model/ListSubscriptionGrantsRequest.h>
#include <aws/datazone/model/ListSubscriptionGrantsResult.h>
#include <aws/datazone/model/ListSubscriptionRequestsRequest.h>
#include <aws/datazone/model/ListSubscriptionRequestsResult.h>
#include <aws/datazone/model/ListSubscriptionTargetsRequest.h>
#include <aws/datazone/model/ListSubscriptionTargetsResult.h>
#include <aws/datazone/model/ListSubscriptionsRequest.h>
#include <aws/datazone/model/ListSubscriptionsResult.h>
#include <aws/datazone/model/ListTagsForResourceRequest.h>
#include <aws/datazone/model/ListTagsForResourceResult.h>
#include <aws/datazone/model/ListTimeSeriesDataPointsRequest.h>
#include <aws/datazone/model/ListTimeSeriesDataPointsResult.h>
#include <aws/datazone/model/ListingItem.h>
#include <aws/datazone/model/ListingRevision.h>
#include <aws/datazone/model/ListingRevisionInput.h>
#include <aws/datazone/model/ListingStatus.h>
#include <aws/datazone/model/ListingSummary.h>
#include <aws/datazone/model/ListingSummaryItem.h>
#include <aws/datazone/model/ManagedPolicyType.h>
#include <aws/datazone/model/Member.h>
#include <aws/datazone/model/MemberDetails.h>
#include <aws/datazone/model/MetadataFormEnforcementDetail.h>
#include <aws/datazone/model/MetadataFormReference.h>
#include <aws/datazone/model/MetadataFormSummary.h>
#include <aws/datazone/model/MetadataGenerationRunItem.h>
#include <aws/datazone/model/MetadataGenerationRunStatus.h>
#include <aws/datazone/model/MetadataGenerationRunTarget.h>
#include <aws/datazone/model/MetadataGenerationRunType.h>
#include <aws/datazone/model/MetadataGenerationTargetType.h>
#include <aws/datazone/model/Model.h>
#include <aws/datazone/model/NameIdentifier.h>
#include <aws/datazone/model/NotEqualToExpression.h>
#include <aws/datazone/model/NotInExpression.h>
#include <aws/datazone/model/NotLikeExpression.h>
#include <aws/datazone/model/NotificationOutput.h>
#include <aws/datazone/model/NotificationResource.h>
#include <aws/datazone/model/NotificationResourceType.h>
#include <aws/datazone/model/NotificationRole.h>
#include <aws/datazone/model/NotificationType.h>
#include <aws/datazone/model/OAuth2ClientApplication.h>
#include <aws/datazone/model/OAuth2GrantType.h>
#include <aws/datazone/model/OAuth2Properties.h>
#include <aws/datazone/model/OpenLineageRunEventSummary.h>
#include <aws/datazone/model/OpenLineageRunState.h>
#include <aws/datazone/model/OverallDeploymentStatus.h>
#include <aws/datazone/model/OverrideDomainUnitOwnersPolicyGrantDetail.h>
#include <aws/datazone/model/OverrideProjectOwnersPolicyGrantDetail.h>
#include <aws/datazone/model/OwnerGroupProperties.h>
#include <aws/datazone/model/OwnerGroupPropertiesOutput.h>
#include <aws/datazone/model/OwnerProperties.h>
#include <aws/datazone/model/OwnerPropertiesOutput.h>
#include <aws/datazone/model/OwnerUserProperties.h>
#include <aws/datazone/model/OwnerUserPropertiesOutput.h>
#include <aws/datazone/model/PhysicalConnectionRequirements.h>
#include <aws/datazone/model/PhysicalEndpoint.h>
#include <aws/datazone/model/PolicyGrantDetail.h>
#include <aws/datazone/model/PolicyGrantMember.h>
#include <aws/datazone/model/PolicyGrantPrincipal.h>
#include <aws/datazone/model/PostLineageEventRequest.h>
#include <aws/datazone/model/PostLineageEventResult.h>
#include <aws/datazone/model/PostTimeSeriesDataPointsRequest.h>
#include <aws/datazone/model/PostTimeSeriesDataPointsResult.h>
#include <aws/datazone/model/PredictionConfiguration.h>
#include <aws/datazone/model/ProjectDeletionError.h>
#include <aws/datazone/model/ProjectDesignation.h>
#include <aws/datazone/model/ProjectGrantFilter.h>
#include <aws/datazone/model/ProjectMember.h>
#include <aws/datazone/model/ProjectPolicyGrantPrincipal.h>
#include <aws/datazone/model/ProjectProfileSummary.h>
#include <aws/datazone/model/ProjectStatus.h>
#include <aws/datazone/model/ProjectSummary.h>
#include <aws/datazone/model/ProjectsForRule.h>
#include <aws/datazone/model/Protocol.h>
#include <aws/datazone/model/ProvisioningConfiguration.h>
#include <aws/datazone/model/ProvisioningProperties.h>
#include <aws/datazone/model/PutEnvironmentBlueprintConfigurationRequest.h>
#include <aws/datazone/model/PutEnvironmentBlueprintConfigurationResult.h>
#include <aws/datazone/model/RecommendationConfiguration.h>
#include <aws/datazone/model/RedshiftClusterStorage.h>
#include <aws/datazone/model/RedshiftCredentialConfiguration.h>
#include <aws/datazone/model/RedshiftCredentials.h>
#include <aws/datazone/model/RedshiftLineageSyncConfigurationInput.h>
#include <aws/datazone/model/RedshiftLineageSyncConfigurationOutput.h>
#include <aws/datazone/model/RedshiftPropertiesInput.h>
#include <aws/datazone/model/RedshiftPropertiesOutput.h>
#include <aws/datazone/model/RedshiftPropertiesPatch.h>
#include <aws/datazone/model/RedshiftRunConfigurationInput.h>
#include <aws/datazone/model/RedshiftRunConfigurationOutput.h>
#include <aws/datazone/model/RedshiftSelfGrantStatusOutput.h>
#include <aws/datazone/model/RedshiftServerlessStorage.h>
#include <aws/datazone/model/RedshiftStorage.h>
#include <aws/datazone/model/RedshiftStorageProperties.h>
#include <aws/datazone/model/Region.h>
#include <aws/datazone/model/RejectChoice.h>
#include <aws/datazone/model/RejectPredictionsRequest.h>
#include <aws/datazone/model/RejectPredictionsResult.h>
#include <aws/datazone/model/RejectRule.h>
#include <aws/datazone/model/RejectRuleBehavior.h>
#include <aws/datazone/model/RejectSubscriptionRequestRequest.h>
#include <aws/datazone/model/RejectSubscriptionRequestResult.h>
#include <aws/datazone/model/RelationalFilterConfiguration.h>
#include <aws/datazone/model/RemoveEntityOwnerRequest.h>
#include <aws/datazone/model/RemoveEntityOwnerResult.h>
#include <aws/datazone/model/RemovePolicyGrantRequest.h>
#include <aws/datazone/model/RemovePolicyGrantResult.h>
#include <aws/datazone/model/Resource.h>
#include <aws/datazone/model/RevokeSubscriptionRequest.h>
#include <aws/datazone/model/RevokeSubscriptionResult.h>
#include <aws/datazone/model/RowFilter.h>
#include <aws/datazone/model/RowFilterConfiguration.h>
#include <aws/datazone/model/RowFilterExpression.h>
#include <aws/datazone/model/RuleAction.h>
#include <aws/datazone/model/RuleDetail.h>
#include <aws/datazone/model/RuleScope.h>
#include <aws/datazone/model/RuleScopeSelectionMode.h>
#include <aws/datazone/model/RuleSummary.h>
#include <aws/datazone/model/RuleTarget.h>
#include <aws/datazone/model/RuleTargetType.h>
#include <aws/datazone/model/RuleType.h>
#include <aws/datazone/model/RunStatisticsForAssets.h>
#include <aws/datazone/model/SageMakerRunConfigurationInput.h>
#include <aws/datazone/model/SageMakerRunConfigurationOutput.h>
#include <aws/datazone/model/ScheduleConfiguration.h>
#include <aws/datazone/model/SearchGroupProfilesRequest.h>
#include <aws/datazone/model/SearchGroupProfilesResult.h>
#include <aws/datazone/model/SearchInItem.h>
#include <aws/datazone/model/SearchInventoryResultItem.h>
#include <aws/datazone/model/SearchListingsRequest.h>
#include <aws/datazone/model/SearchListingsResult.h>
#include <aws/datazone/model/SearchOutputAdditionalAttribute.h>
#include <aws/datazone/model/SearchRequest.h>
#include <aws/datazone/model/SearchResult.h>
#include <aws/datazone/model/SearchResultItem.h>
#include <aws/datazone/model/SearchSort.h>
#include <aws/datazone/model/SearchTypesRequest.h>
#include <aws/datazone/model/SearchTypesResult.h>
#include <aws/datazone/model/SearchTypesResultItem.h>
#include <aws/datazone/model/SearchUserProfilesRequest.h>
#include <aws/datazone/model/SearchUserProfilesResult.h>
#include <aws/datazone/model/SelfGrantStatus.h>
#include <aws/datazone/model/SelfGrantStatusDetail.h>
#include <aws/datazone/model/SelfGrantStatusOutput.h>
#include <aws/datazone/model/SingleSignOn.h>
#include <aws/datazone/model/SortFieldConnection.h>
#include <aws/datazone/model/SortFieldProject.h>
#include <aws/datazone/model/SortKey.h>
#include <aws/datazone/model/SortOrder.h>
#include <aws/datazone/model/SparkEmrPropertiesInput.h>
#include <aws/datazone/model/SparkEmrPropertiesOutput.h>
#include <aws/datazone/model/SparkEmrPropertiesPatch.h>
#include <aws/datazone/model/SparkGlueArgs.h>
#include <aws/datazone/model/SparkGluePropertiesInput.h>
#include <aws/datazone/model/SparkGluePropertiesOutput.h>
#include <aws/datazone/model/SsoUserProfileDetails.h>
#include <aws/datazone/model/StartDataSourceRunRequest.h>
#include <aws/datazone/model/StartDataSourceRunResult.h>
#include <aws/datazone/model/StartMetadataGenerationRunRequest.h>
#include <aws/datazone/model/StartMetadataGenerationRunResult.h>
#include <aws/datazone/model/Status.h>
#include <aws/datazone/model/SubscribedAsset.h>
#include <aws/datazone/model/SubscribedAssetListing.h>
#include <aws/datazone/model/SubscribedListing.h>
#include <aws/datazone/model/SubscribedListingInput.h>
#include <aws/datazone/model/SubscribedListingItem.h>
#include <aws/datazone/model/SubscribedPrincipal.h>
#include <aws/datazone/model/SubscribedPrincipalInput.h>
#include <aws/datazone/model/SubscribedProductListing.h>
#include <aws/datazone/model/SubscribedProject.h>
#include <aws/datazone/model/SubscribedProjectInput.h>
#include <aws/datazone/model/SubscriptionGrantOverallStatus.h>
#include <aws/datazone/model/SubscriptionGrantStatus.h>
#include <aws/datazone/model/SubscriptionGrantSummary.h>
#include <aws/datazone/model/SubscriptionRequestStatus.h>
#include <aws/datazone/model/SubscriptionRequestSummary.h>
#include <aws/datazone/model/SubscriptionStatus.h>
#include <aws/datazone/model/SubscriptionSummary.h>
#include <aws/datazone/model/SubscriptionTargetForm.h>
#include <aws/datazone/model/SubscriptionTargetSummary.h>
#include <aws/datazone/model/TagResourceRequest.h>
#include <aws/datazone/model/TagResourceResult.h>
#include <aws/datazone/model/TargetEntityType.h>
#include <aws/datazone/model/TaskStatus.h>
#include <aws/datazone/model/TermRelations.h>
#include <aws/datazone/model/TimeSeriesDataPointFormInput.h>
#include <aws/datazone/model/TimeSeriesDataPointFormOutput.h>
#include <aws/datazone/model/TimeSeriesDataPointSummaryFormOutput.h>
#include <aws/datazone/model/TimeSeriesEntityType.h>
#include <aws/datazone/model/Timezone.h>
#include <aws/datazone/model/Topic.h>
#include <aws/datazone/model/TypesSearchScope.h>
#include <aws/datazone/model/Unit.h>
#include <aws/datazone/model/UntagResourceRequest.h>
#include <aws/datazone/model/UntagResourceResult.h>
#include <aws/datazone/model/UpdateAssetFilterRequest.h>
#include <aws/datazone/model/UpdateAssetFilterResult.h>
#include <aws/datazone/model/UpdateConnectionRequest.h>
#include <aws/datazone/model/UpdateConnectionResult.h>
#include <aws/datazone/model/UpdateDataSourceRequest.h>
#include <aws/datazone/model/UpdateDataSourceResult.h>
#include <aws/datazone/model/UpdateDomainRequest.h>
#include <aws/datazone/model/UpdateDomainResult.h>
#include <aws/datazone/model/UpdateDomainUnitRequest.h>
#include <aws/datazone/model/UpdateDomainUnitResult.h>
#include <aws/datazone/model/UpdateEnvironmentActionRequest.h>
#include <aws/datazone/model/UpdateEnvironmentActionResult.h>
#include <aws/datazone/model/UpdateEnvironmentProfileRequest.h>
#include <aws/datazone/model/UpdateEnvironmentProfileResult.h>
#include <aws/datazone/model/UpdateEnvironmentRequest.h>
#include <aws/datazone/model/UpdateEnvironmentResult.h>
#include <aws/datazone/model/UpdateGlossaryRequest.h>
#include <aws/datazone/model/UpdateGlossaryResult.h>
#include <aws/datazone/model/UpdateGlossaryTermRequest.h>
#include <aws/datazone/model/UpdateGlossaryTermResult.h>
#include <aws/datazone/model/UpdateGroupProfileRequest.h>
#include <aws/datazone/model/UpdateGroupProfileResult.h>
#include <aws/datazone/model/UpdateProjectProfileRequest.h>
#include <aws/datazone/model/UpdateProjectProfileResult.h>
#include <aws/datazone/model/UpdateProjectRequest.h>
#include <aws/datazone/model/UpdateProjectResult.h>
#include <aws/datazone/model/UpdateRuleRequest.h>
#include <aws/datazone/model/UpdateRuleResult.h>
#include <aws/datazone/model/UpdateSubscriptionGrantStatusRequest.h>
#include <aws/datazone/model/UpdateSubscriptionGrantStatusResult.h>
#include <aws/datazone/model/UpdateSubscriptionRequestRequest.h>
#include <aws/datazone/model/UpdateSubscriptionRequestResult.h>
#include <aws/datazone/model/UpdateSubscriptionTargetRequest.h>
#include <aws/datazone/model/UpdateSubscriptionTargetResult.h>
#include <aws/datazone/model/UpdateUserProfileRequest.h>
#include <aws/datazone/model/UpdateUserProfileResult.h>
#include <aws/datazone/model/UseAssetTypePolicyGrantDetail.h>
#include <aws/datazone/model/UserAssignment.h>
#include <aws/datazone/model/UserDesignation.h>
#include <aws/datazone/model/UserDetails.h>
#include <aws/datazone/model/UserPolicyGrantPrincipal.h>
#include <aws/datazone/model/UserProfileDetails.h>
#include <aws/datazone/model/UserProfileStatus.h>
#include <aws/datazone/model/UserProfileSummary.h>
#include <aws/datazone/model/UserProfileType.h>
#include <aws/datazone/model/UserSearchType.h>
#include <aws/datazone/model/UserType.h>
#include <aws/datazone/model/UsernamePassword.h>

using DataZoneIncludeTest = ::testing::Test;

TEST_F(DataZoneIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::DataZone::DataZoneClient>("DataZoneIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
