/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/devicefarm/DeviceFarmClient.h>
#include <aws/devicefarm/DeviceFarmEndpointProvider.h>
#include <aws/devicefarm/DeviceFarmEndpointRules.h>
#include <aws/devicefarm/DeviceFarmErrorMarshaller.h>
#include <aws/devicefarm/DeviceFarmErrors.h>
#include <aws/devicefarm/DeviceFarmRequest.h>
#include <aws/devicefarm/DeviceFarmServiceClientModel.h>
#include <aws/devicefarm/DeviceFarm_EXPORTS.h>
#include <aws/devicefarm/model/AccountSettings.h>
#include <aws/devicefarm/model/Artifact.h>
#include <aws/devicefarm/model/ArtifactCategory.h>
#include <aws/devicefarm/model/ArtifactType.h>
#include <aws/devicefarm/model/BillingMethod.h>
#include <aws/devicefarm/model/CPU.h>
#include <aws/devicefarm/model/Counters.h>
#include <aws/devicefarm/model/CreateDevicePoolRequest.h>
#include <aws/devicefarm/model/CreateDevicePoolResult.h>
#include <aws/devicefarm/model/CreateInstanceProfileRequest.h>
#include <aws/devicefarm/model/CreateInstanceProfileResult.h>
#include <aws/devicefarm/model/CreateNetworkProfileRequest.h>
#include <aws/devicefarm/model/CreateNetworkProfileResult.h>
#include <aws/devicefarm/model/CreateProjectRequest.h>
#include <aws/devicefarm/model/CreateProjectResult.h>
#include <aws/devicefarm/model/CreateRemoteAccessSessionConfiguration.h>
#include <aws/devicefarm/model/CreateRemoteAccessSessionRequest.h>
#include <aws/devicefarm/model/CreateRemoteAccessSessionResult.h>
#include <aws/devicefarm/model/CreateTestGridProjectRequest.h>
#include <aws/devicefarm/model/CreateTestGridProjectResult.h>
#include <aws/devicefarm/model/CreateTestGridUrlRequest.h>
#include <aws/devicefarm/model/CreateTestGridUrlResult.h>
#include <aws/devicefarm/model/CreateUploadRequest.h>
#include <aws/devicefarm/model/CreateUploadResult.h>
#include <aws/devicefarm/model/CreateVPCEConfigurationRequest.h>
#include <aws/devicefarm/model/CreateVPCEConfigurationResult.h>
#include <aws/devicefarm/model/CurrencyCode.h>
#include <aws/devicefarm/model/CustomerArtifactPaths.h>
#include <aws/devicefarm/model/DeleteDevicePoolRequest.h>
#include <aws/devicefarm/model/DeleteDevicePoolResult.h>
#include <aws/devicefarm/model/DeleteInstanceProfileRequest.h>
#include <aws/devicefarm/model/DeleteInstanceProfileResult.h>
#include <aws/devicefarm/model/DeleteNetworkProfileRequest.h>
#include <aws/devicefarm/model/DeleteNetworkProfileResult.h>
#include <aws/devicefarm/model/DeleteProjectRequest.h>
#include <aws/devicefarm/model/DeleteProjectResult.h>
#include <aws/devicefarm/model/DeleteRemoteAccessSessionRequest.h>
#include <aws/devicefarm/model/DeleteRemoteAccessSessionResult.h>
#include <aws/devicefarm/model/DeleteRunRequest.h>
#include <aws/devicefarm/model/DeleteRunResult.h>
#include <aws/devicefarm/model/DeleteTestGridProjectRequest.h>
#include <aws/devicefarm/model/DeleteTestGridProjectResult.h>
#include <aws/devicefarm/model/DeleteUploadRequest.h>
#include <aws/devicefarm/model/DeleteUploadResult.h>
#include <aws/devicefarm/model/DeleteVPCEConfigurationRequest.h>
#include <aws/devicefarm/model/DeleteVPCEConfigurationResult.h>
#include <aws/devicefarm/model/Device.h>
#include <aws/devicefarm/model/DeviceAttribute.h>
#include <aws/devicefarm/model/DeviceAvailability.h>
#include <aws/devicefarm/model/DeviceFilter.h>
#include <aws/devicefarm/model/DeviceFilterAttribute.h>
#include <aws/devicefarm/model/DeviceFormFactor.h>
#include <aws/devicefarm/model/DeviceInstance.h>
#include <aws/devicefarm/model/DeviceMinutes.h>
#include <aws/devicefarm/model/DevicePlatform.h>
#include <aws/devicefarm/model/DevicePool.h>
#include <aws/devicefarm/model/DevicePoolCompatibilityResult.h>
#include <aws/devicefarm/model/DevicePoolType.h>
#include <aws/devicefarm/model/DeviceProxy.h>
#include <aws/devicefarm/model/DeviceSelectionConfiguration.h>
#include <aws/devicefarm/model/DeviceSelectionResult.h>
#include <aws/devicefarm/model/ExecutionConfiguration.h>
#include <aws/devicefarm/model/ExecutionResult.h>
#include <aws/devicefarm/model/ExecutionResultCode.h>
#include <aws/devicefarm/model/ExecutionStatus.h>
#include <aws/devicefarm/model/GetAccountSettingsRequest.h>
#include <aws/devicefarm/model/GetAccountSettingsResult.h>
#include <aws/devicefarm/model/GetDeviceInstanceRequest.h>
#include <aws/devicefarm/model/GetDeviceInstanceResult.h>
#include <aws/devicefarm/model/GetDevicePoolCompatibilityRequest.h>
#include <aws/devicefarm/model/GetDevicePoolCompatibilityResult.h>
#include <aws/devicefarm/model/GetDevicePoolRequest.h>
#include <aws/devicefarm/model/GetDevicePoolResult.h>
#include <aws/devicefarm/model/GetDeviceRequest.h>
#include <aws/devicefarm/model/GetDeviceResult.h>
#include <aws/devicefarm/model/GetInstanceProfileRequest.h>
#include <aws/devicefarm/model/GetInstanceProfileResult.h>
#include <aws/devicefarm/model/GetJobRequest.h>
#include <aws/devicefarm/model/GetJobResult.h>
#include <aws/devicefarm/model/GetNetworkProfileRequest.h>
#include <aws/devicefarm/model/GetNetworkProfileResult.h>
#include <aws/devicefarm/model/GetOfferingStatusRequest.h>
#include <aws/devicefarm/model/GetOfferingStatusResult.h>
#include <aws/devicefarm/model/GetProjectRequest.h>
#include <aws/devicefarm/model/GetProjectResult.h>
#include <aws/devicefarm/model/GetRemoteAccessSessionRequest.h>
#include <aws/devicefarm/model/GetRemoteAccessSessionResult.h>
#include <aws/devicefarm/model/GetRunRequest.h>
#include <aws/devicefarm/model/GetRunResult.h>
#include <aws/devicefarm/model/GetSuiteRequest.h>
#include <aws/devicefarm/model/GetSuiteResult.h>
#include <aws/devicefarm/model/GetTestGridProjectRequest.h>
#include <aws/devicefarm/model/GetTestGridProjectResult.h>
#include <aws/devicefarm/model/GetTestGridSessionRequest.h>
#include <aws/devicefarm/model/GetTestGridSessionResult.h>
#include <aws/devicefarm/model/GetTestRequest.h>
#include <aws/devicefarm/model/GetTestResult.h>
#include <aws/devicefarm/model/GetUploadRequest.h>
#include <aws/devicefarm/model/GetUploadResult.h>
#include <aws/devicefarm/model/GetVPCEConfigurationRequest.h>
#include <aws/devicefarm/model/GetVPCEConfigurationResult.h>
#include <aws/devicefarm/model/IncompatibilityMessage.h>
#include <aws/devicefarm/model/InstallToRemoteAccessSessionRequest.h>
#include <aws/devicefarm/model/InstallToRemoteAccessSessionResult.h>
#include <aws/devicefarm/model/InstanceProfile.h>
#include <aws/devicefarm/model/InstanceStatus.h>
#include <aws/devicefarm/model/InteractionMode.h>
#include <aws/devicefarm/model/Job.h>
#include <aws/devicefarm/model/ListArtifactsRequest.h>
#include <aws/devicefarm/model/ListArtifactsResult.h>
#include <aws/devicefarm/model/ListDeviceInstancesRequest.h>
#include <aws/devicefarm/model/ListDeviceInstancesResult.h>
#include <aws/devicefarm/model/ListDevicePoolsRequest.h>
#include <aws/devicefarm/model/ListDevicePoolsResult.h>
#include <aws/devicefarm/model/ListDevicesRequest.h>
#include <aws/devicefarm/model/ListDevicesResult.h>
#include <aws/devicefarm/model/ListInstanceProfilesRequest.h>
#include <aws/devicefarm/model/ListInstanceProfilesResult.h>
#include <aws/devicefarm/model/ListJobsRequest.h>
#include <aws/devicefarm/model/ListJobsResult.h>
#include <aws/devicefarm/model/ListNetworkProfilesRequest.h>
#include <aws/devicefarm/model/ListNetworkProfilesResult.h>
#include <aws/devicefarm/model/ListOfferingPromotionsRequest.h>
#include <aws/devicefarm/model/ListOfferingPromotionsResult.h>
#include <aws/devicefarm/model/ListOfferingTransactionsRequest.h>
#include <aws/devicefarm/model/ListOfferingTransactionsResult.h>
#include <aws/devicefarm/model/ListOfferingsRequest.h>
#include <aws/devicefarm/model/ListOfferingsResult.h>
#include <aws/devicefarm/model/ListProjectsRequest.h>
#include <aws/devicefarm/model/ListProjectsResult.h>
#include <aws/devicefarm/model/ListRemoteAccessSessionsRequest.h>
#include <aws/devicefarm/model/ListRemoteAccessSessionsResult.h>
#include <aws/devicefarm/model/ListRunsRequest.h>
#include <aws/devicefarm/model/ListRunsResult.h>
#include <aws/devicefarm/model/ListSamplesRequest.h>
#include <aws/devicefarm/model/ListSamplesResult.h>
#include <aws/devicefarm/model/ListSuitesRequest.h>
#include <aws/devicefarm/model/ListSuitesResult.h>
#include <aws/devicefarm/model/ListTagsForResourceRequest.h>
#include <aws/devicefarm/model/ListTagsForResourceResult.h>
#include <aws/devicefarm/model/ListTestGridProjectsRequest.h>
#include <aws/devicefarm/model/ListTestGridProjectsResult.h>
#include <aws/devicefarm/model/ListTestGridSessionActionsRequest.h>
#include <aws/devicefarm/model/ListTestGridSessionActionsResult.h>
#include <aws/devicefarm/model/ListTestGridSessionArtifactsRequest.h>
#include <aws/devicefarm/model/ListTestGridSessionArtifactsResult.h>
#include <aws/devicefarm/model/ListTestGridSessionsRequest.h>
#include <aws/devicefarm/model/ListTestGridSessionsResult.h>
#include <aws/devicefarm/model/ListTestsRequest.h>
#include <aws/devicefarm/model/ListTestsResult.h>
#include <aws/devicefarm/model/ListUniqueProblemsRequest.h>
#include <aws/devicefarm/model/ListUniqueProblemsResult.h>
#include <aws/devicefarm/model/ListUploadsRequest.h>
#include <aws/devicefarm/model/ListUploadsResult.h>
#include <aws/devicefarm/model/ListVPCEConfigurationsRequest.h>
#include <aws/devicefarm/model/ListVPCEConfigurationsResult.h>
#include <aws/devicefarm/model/Location.h>
#include <aws/devicefarm/model/MonetaryAmount.h>
#include <aws/devicefarm/model/NetworkProfile.h>
#include <aws/devicefarm/model/NetworkProfileType.h>
#include <aws/devicefarm/model/Offering.h>
#include <aws/devicefarm/model/OfferingPromotion.h>
#include <aws/devicefarm/model/OfferingStatus.h>
#include <aws/devicefarm/model/OfferingTransaction.h>
#include <aws/devicefarm/model/OfferingTransactionType.h>
#include <aws/devicefarm/model/OfferingType.h>
#include <aws/devicefarm/model/Problem.h>
#include <aws/devicefarm/model/ProblemDetail.h>
#include <aws/devicefarm/model/Project.h>
#include <aws/devicefarm/model/PurchaseOfferingRequest.h>
#include <aws/devicefarm/model/PurchaseOfferingResult.h>
#include <aws/devicefarm/model/Radios.h>
#include <aws/devicefarm/model/RecurringCharge.h>
#include <aws/devicefarm/model/RecurringChargeFrequency.h>
#include <aws/devicefarm/model/RemoteAccessSession.h>
#include <aws/devicefarm/model/RenewOfferingRequest.h>
#include <aws/devicefarm/model/RenewOfferingResult.h>
#include <aws/devicefarm/model/Resolution.h>
#include <aws/devicefarm/model/Rule.h>
#include <aws/devicefarm/model/RuleOperator.h>
#include <aws/devicefarm/model/Run.h>
#include <aws/devicefarm/model/Sample.h>
#include <aws/devicefarm/model/SampleType.h>
#include <aws/devicefarm/model/ScheduleRunConfiguration.h>
#include <aws/devicefarm/model/ScheduleRunRequest.h>
#include <aws/devicefarm/model/ScheduleRunResult.h>
#include <aws/devicefarm/model/ScheduleRunTest.h>
#include <aws/devicefarm/model/StopJobRequest.h>
#include <aws/devicefarm/model/StopJobResult.h>
#include <aws/devicefarm/model/StopRemoteAccessSessionRequest.h>
#include <aws/devicefarm/model/StopRemoteAccessSessionResult.h>
#include <aws/devicefarm/model/StopRunRequest.h>
#include <aws/devicefarm/model/StopRunResult.h>
#include <aws/devicefarm/model/Suite.h>
#include <aws/devicefarm/model/Tag.h>
#include <aws/devicefarm/model/TagOperationException.h>
#include <aws/devicefarm/model/TagPolicyException.h>
#include <aws/devicefarm/model/TagResourceRequest.h>
#include <aws/devicefarm/model/TagResourceResult.h>
#include <aws/devicefarm/model/Test.h>
#include <aws/devicefarm/model/TestGridProject.h>
#include <aws/devicefarm/model/TestGridSession.h>
#include <aws/devicefarm/model/TestGridSessionAction.h>
#include <aws/devicefarm/model/TestGridSessionArtifact.h>
#include <aws/devicefarm/model/TestGridSessionArtifactCategory.h>
#include <aws/devicefarm/model/TestGridSessionArtifactType.h>
#include <aws/devicefarm/model/TestGridSessionStatus.h>
#include <aws/devicefarm/model/TestGridVpcConfig.h>
#include <aws/devicefarm/model/TestType.h>
#include <aws/devicefarm/model/TooManyTagsException.h>
#include <aws/devicefarm/model/TrialMinutes.h>
#include <aws/devicefarm/model/UniqueProblem.h>
#include <aws/devicefarm/model/UntagResourceRequest.h>
#include <aws/devicefarm/model/UntagResourceResult.h>
#include <aws/devicefarm/model/UpdateDeviceInstanceRequest.h>
#include <aws/devicefarm/model/UpdateDeviceInstanceResult.h>
#include <aws/devicefarm/model/UpdateDevicePoolRequest.h>
#include <aws/devicefarm/model/UpdateDevicePoolResult.h>
#include <aws/devicefarm/model/UpdateInstanceProfileRequest.h>
#include <aws/devicefarm/model/UpdateInstanceProfileResult.h>
#include <aws/devicefarm/model/UpdateNetworkProfileRequest.h>
#include <aws/devicefarm/model/UpdateNetworkProfileResult.h>
#include <aws/devicefarm/model/UpdateProjectRequest.h>
#include <aws/devicefarm/model/UpdateProjectResult.h>
#include <aws/devicefarm/model/UpdateTestGridProjectRequest.h>
#include <aws/devicefarm/model/UpdateTestGridProjectResult.h>
#include <aws/devicefarm/model/UpdateUploadRequest.h>
#include <aws/devicefarm/model/UpdateUploadResult.h>
#include <aws/devicefarm/model/UpdateVPCEConfigurationRequest.h>
#include <aws/devicefarm/model/UpdateVPCEConfigurationResult.h>
#include <aws/devicefarm/model/Upload.h>
#include <aws/devicefarm/model/UploadCategory.h>
#include <aws/devicefarm/model/UploadStatus.h>
#include <aws/devicefarm/model/UploadType.h>
#include <aws/devicefarm/model/VPCEConfiguration.h>
#include <aws/devicefarm/model/VpcConfig.h>

using DeviceFarmIncludeTest = ::testing::Test;

TEST_F(DeviceFarmIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::DeviceFarm::DeviceFarmClient>("DeviceFarmIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
