/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/devops-guru/DevOpsGuruClient.h>
#include <aws/devops-guru/DevOpsGuruEndpointProvider.h>
#include <aws/devops-guru/DevOpsGuruEndpointRules.h>
#include <aws/devops-guru/DevOpsGuruErrorMarshaller.h>
#include <aws/devops-guru/DevOpsGuruErrors.h>
#include <aws/devops-guru/DevOpsGuruRequest.h>
#include <aws/devops-guru/DevOpsGuruServiceClientModel.h>
#include <aws/devops-guru/DevOpsGuru_EXPORTS.h>
#include <aws/devops-guru/model/AccountHealth.h>
#include <aws/devops-guru/model/AccountInsightHealth.h>
#include <aws/devops-guru/model/AddNotificationChannelRequest.h>
#include <aws/devops-guru/model/AddNotificationChannelResult.h>
#include <aws/devops-guru/model/AmazonCodeGuruProfilerIntegration.h>
#include <aws/devops-guru/model/AnomalousLogGroup.h>
#include <aws/devops-guru/model/AnomalyReportedTimeRange.h>
#include <aws/devops-guru/model/AnomalyResource.h>
#include <aws/devops-guru/model/AnomalySeverity.h>
#include <aws/devops-guru/model/AnomalySourceDetails.h>
#include <aws/devops-guru/model/AnomalySourceMetadata.h>
#include <aws/devops-guru/model/AnomalyStatus.h>
#include <aws/devops-guru/model/AnomalyTimeRange.h>
#include <aws/devops-guru/model/AnomalyType.h>
#include <aws/devops-guru/model/CloudFormationCollection.h>
#include <aws/devops-guru/model/CloudFormationCollectionFilter.h>
#include <aws/devops-guru/model/CloudFormationCostEstimationResourceCollectionFilter.h>
#include <aws/devops-guru/model/CloudFormationHealth.h>
#include <aws/devops-guru/model/CloudWatchMetricDataStatusCode.h>
#include <aws/devops-guru/model/CloudWatchMetricsDataSummary.h>
#include <aws/devops-guru/model/CloudWatchMetricsDetail.h>
#include <aws/devops-guru/model/CloudWatchMetricsDimension.h>
#include <aws/devops-guru/model/CloudWatchMetricsStat.h>
#include <aws/devops-guru/model/ConflictException.h>
#include <aws/devops-guru/model/CostEstimationResourceCollectionFilter.h>
#include <aws/devops-guru/model/CostEstimationServiceResourceState.h>
#include <aws/devops-guru/model/CostEstimationStatus.h>
#include <aws/devops-guru/model/CostEstimationTimeRange.h>
#include <aws/devops-guru/model/DeleteInsightRequest.h>
#include <aws/devops-guru/model/DeleteInsightResult.h>
#include <aws/devops-guru/model/DescribeAccountHealthRequest.h>
#include <aws/devops-guru/model/DescribeAccountHealthResult.h>
#include <aws/devops-guru/model/DescribeAccountOverviewRequest.h>
#include <aws/devops-guru/model/DescribeAccountOverviewResult.h>
#include <aws/devops-guru/model/DescribeAnomalyRequest.h>
#include <aws/devops-guru/model/DescribeAnomalyResult.h>
#include <aws/devops-guru/model/DescribeEventSourcesConfigRequest.h>
#include <aws/devops-guru/model/DescribeEventSourcesConfigResult.h>
#include <aws/devops-guru/model/DescribeFeedbackRequest.h>
#include <aws/devops-guru/model/DescribeFeedbackResult.h>
#include <aws/devops-guru/model/DescribeInsightRequest.h>
#include <aws/devops-guru/model/DescribeInsightResult.h>
#include <aws/devops-guru/model/DescribeOrganizationHealthRequest.h>
#include <aws/devops-guru/model/DescribeOrganizationHealthResult.h>
#include <aws/devops-guru/model/DescribeOrganizationOverviewRequest.h>
#include <aws/devops-guru/model/DescribeOrganizationOverviewResult.h>
#include <aws/devops-guru/model/DescribeOrganizationResourceCollectionHealthRequest.h>
#include <aws/devops-guru/model/DescribeOrganizationResourceCollectionHealthResult.h>
#include <aws/devops-guru/model/DescribeResourceCollectionHealthRequest.h>
#include <aws/devops-guru/model/DescribeResourceCollectionHealthResult.h>
#include <aws/devops-guru/model/DescribeServiceIntegrationRequest.h>
#include <aws/devops-guru/model/DescribeServiceIntegrationResult.h>
#include <aws/devops-guru/model/EndTimeRange.h>
#include <aws/devops-guru/model/Event.h>
#include <aws/devops-guru/model/EventClass.h>
#include <aws/devops-guru/model/EventDataSource.h>
#include <aws/devops-guru/model/EventResource.h>
#include <aws/devops-guru/model/EventSourceOptInStatus.h>
#include <aws/devops-guru/model/EventSourcesConfig.h>
#include <aws/devops-guru/model/EventTimeRange.h>
#include <aws/devops-guru/model/GetCostEstimationRequest.h>
#include <aws/devops-guru/model/GetCostEstimationResult.h>
#include <aws/devops-guru/model/GetResourceCollectionRequest.h>
#include <aws/devops-guru/model/GetResourceCollectionResult.h>
#include <aws/devops-guru/model/InsightFeedback.h>
#include <aws/devops-guru/model/InsightFeedbackOption.h>
#include <aws/devops-guru/model/InsightHealth.h>
#include <aws/devops-guru/model/InsightSeverity.h>
#include <aws/devops-guru/model/InsightStatus.h>
#include <aws/devops-guru/model/InsightTimeRange.h>
#include <aws/devops-guru/model/InsightType.h>
#include <aws/devops-guru/model/InternalServerException.h>
#include <aws/devops-guru/model/KMSServerSideEncryptionIntegration.h>
#include <aws/devops-guru/model/KMSServerSideEncryptionIntegrationConfig.h>
#include <aws/devops-guru/model/ListAnomaliesForInsightFilters.h>
#include <aws/devops-guru/model/ListAnomaliesForInsightRequest.h>
#include <aws/devops-guru/model/ListAnomaliesForInsightResult.h>
#include <aws/devops-guru/model/ListAnomalousLogGroupsRequest.h>
#include <aws/devops-guru/model/ListAnomalousLogGroupsResult.h>
#include <aws/devops-guru/model/ListEventsFilters.h>
#include <aws/devops-guru/model/ListEventsRequest.h>
#include <aws/devops-guru/model/ListEventsResult.h>
#include <aws/devops-guru/model/ListInsightsAnyStatusFilter.h>
#include <aws/devops-guru/model/ListInsightsClosedStatusFilter.h>
#include <aws/devops-guru/model/ListInsightsOngoingStatusFilter.h>
#include <aws/devops-guru/model/ListInsightsRequest.h>
#include <aws/devops-guru/model/ListInsightsResult.h>
#include <aws/devops-guru/model/ListInsightsStatusFilter.h>
#include <aws/devops-guru/model/ListMonitoredResourcesFilters.h>
#include <aws/devops-guru/model/ListMonitoredResourcesRequest.h>
#include <aws/devops-guru/model/ListMonitoredResourcesResult.h>
#include <aws/devops-guru/model/ListNotificationChannelsRequest.h>
#include <aws/devops-guru/model/ListNotificationChannelsResult.h>
#include <aws/devops-guru/model/ListOrganizationInsightsRequest.h>
#include <aws/devops-guru/model/ListOrganizationInsightsResult.h>
#include <aws/devops-guru/model/ListRecommendationsRequest.h>
#include <aws/devops-guru/model/ListRecommendationsResult.h>
#include <aws/devops-guru/model/Locale.h>
#include <aws/devops-guru/model/LogAnomalyClass.h>
#include <aws/devops-guru/model/LogAnomalyShowcase.h>
#include <aws/devops-guru/model/LogAnomalyType.h>
#include <aws/devops-guru/model/LogsAnomalyDetectionIntegration.h>
#include <aws/devops-guru/model/LogsAnomalyDetectionIntegrationConfig.h>
#include <aws/devops-guru/model/MonitoredResourceIdentifier.h>
#include <aws/devops-guru/model/NotificationChannel.h>
#include <aws/devops-guru/model/NotificationChannelConfig.h>
#include <aws/devops-guru/model/NotificationFilterConfig.h>
#include <aws/devops-guru/model/NotificationMessageType.h>
#include <aws/devops-guru/model/OpsCenterIntegration.h>
#include <aws/devops-guru/model/OpsCenterIntegrationConfig.h>
#include <aws/devops-guru/model/OptInStatus.h>
#include <aws/devops-guru/model/OrganizationResourceCollectionType.h>
#include <aws/devops-guru/model/PerformanceInsightsMetricDimensionGroup.h>
#include <aws/devops-guru/model/PerformanceInsightsMetricQuery.h>
#include <aws/devops-guru/model/PerformanceInsightsMetricsDetail.h>
#include <aws/devops-guru/model/PerformanceInsightsReferenceComparisonValues.h>
#include <aws/devops-guru/model/PerformanceInsightsReferenceData.h>
#include <aws/devops-guru/model/PerformanceInsightsReferenceMetric.h>
#include <aws/devops-guru/model/PerformanceInsightsReferenceScalar.h>
#include <aws/devops-guru/model/PerformanceInsightsStat.h>
#include <aws/devops-guru/model/PredictionTimeRange.h>
#include <aws/devops-guru/model/ProactiveAnomaly.h>
#include <aws/devops-guru/model/ProactiveAnomalySummary.h>
#include <aws/devops-guru/model/ProactiveInsight.h>
#include <aws/devops-guru/model/ProactiveInsightSummary.h>
#include <aws/devops-guru/model/ProactiveOrganizationInsightSummary.h>
#include <aws/devops-guru/model/PutFeedbackRequest.h>
#include <aws/devops-guru/model/PutFeedbackResult.h>
#include <aws/devops-guru/model/ReactiveAnomaly.h>
#include <aws/devops-guru/model/ReactiveAnomalySummary.h>
#include <aws/devops-guru/model/ReactiveInsight.h>
#include <aws/devops-guru/model/ReactiveInsightSummary.h>
#include <aws/devops-guru/model/ReactiveOrganizationInsightSummary.h>
#include <aws/devops-guru/model/Recommendation.h>
#include <aws/devops-guru/model/RecommendationRelatedAnomaly.h>
#include <aws/devops-guru/model/RecommendationRelatedAnomalyResource.h>
#include <aws/devops-guru/model/RecommendationRelatedAnomalySourceDetail.h>
#include <aws/devops-guru/model/RecommendationRelatedCloudWatchMetricsSourceDetail.h>
#include <aws/devops-guru/model/RecommendationRelatedEvent.h>
#include <aws/devops-guru/model/RecommendationRelatedEventResource.h>
#include <aws/devops-guru/model/RemoveNotificationChannelRequest.h>
#include <aws/devops-guru/model/RemoveNotificationChannelResult.h>
#include <aws/devops-guru/model/ResourceCollection.h>
#include <aws/devops-guru/model/ResourceCollectionFilter.h>
#include <aws/devops-guru/model/ResourceCollectionType.h>
#include <aws/devops-guru/model/ResourceNotFoundException.h>
#include <aws/devops-guru/model/ResourcePermission.h>
#include <aws/devops-guru/model/ResourceTypeFilter.h>
#include <aws/devops-guru/model/SearchInsightsFilters.h>
#include <aws/devops-guru/model/SearchInsightsRequest.h>
#include <aws/devops-guru/model/SearchInsightsResult.h>
#include <aws/devops-guru/model/SearchOrganizationInsightsFilters.h>
#include <aws/devops-guru/model/SearchOrganizationInsightsRequest.h>
#include <aws/devops-guru/model/SearchOrganizationInsightsResult.h>
#include <aws/devops-guru/model/ServerSideEncryptionType.h>
#include <aws/devops-guru/model/ServiceCollection.h>
#include <aws/devops-guru/model/ServiceHealth.h>
#include <aws/devops-guru/model/ServiceInsightHealth.h>
#include <aws/devops-guru/model/ServiceIntegrationConfig.h>
#include <aws/devops-guru/model/ServiceName.h>
#include <aws/devops-guru/model/ServiceResourceCost.h>
#include <aws/devops-guru/model/SnsChannelConfig.h>
#include <aws/devops-guru/model/StartCostEstimationRequest.h>
#include <aws/devops-guru/model/StartCostEstimationResult.h>
#include <aws/devops-guru/model/StartTimeRange.h>
#include <aws/devops-guru/model/TagCollection.h>
#include <aws/devops-guru/model/TagCollectionFilter.h>
#include <aws/devops-guru/model/TagCostEstimationResourceCollectionFilter.h>
#include <aws/devops-guru/model/TagHealth.h>
#include <aws/devops-guru/model/ThrottlingException.h>
#include <aws/devops-guru/model/TimestampMetricValuePair.h>
#include <aws/devops-guru/model/UpdateCloudFormationCollectionFilter.h>
#include <aws/devops-guru/model/UpdateEventSourcesConfigRequest.h>
#include <aws/devops-guru/model/UpdateEventSourcesConfigResult.h>
#include <aws/devops-guru/model/UpdateResourceCollectionAction.h>
#include <aws/devops-guru/model/UpdateResourceCollectionFilter.h>
#include <aws/devops-guru/model/UpdateResourceCollectionRequest.h>
#include <aws/devops-guru/model/UpdateResourceCollectionResult.h>
#include <aws/devops-guru/model/UpdateServiceIntegrationConfig.h>
#include <aws/devops-guru/model/UpdateServiceIntegrationRequest.h>
#include <aws/devops-guru/model/UpdateServiceIntegrationResult.h>
#include <aws/devops-guru/model/UpdateTagCollectionFilter.h>
#include <aws/devops-guru/model/ValidationException.h>
#include <aws/devops-guru/model/ValidationExceptionField.h>
#include <aws/devops-guru/model/ValidationExceptionReason.h>

using DevOpsGuruIncludeTest = ::testing::Test;

TEST_F(DevOpsGuruIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::DevOpsGuru::DevOpsGuruClient>("DevOpsGuruIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
