/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/directconnect/DirectConnectClient.h>
#include <aws/directconnect/DirectConnectEndpointProvider.h>
#include <aws/directconnect/DirectConnectEndpointRules.h>
#include <aws/directconnect/DirectConnectErrorMarshaller.h>
#include <aws/directconnect/DirectConnectErrors.h>
#include <aws/directconnect/DirectConnectRequest.h>
#include <aws/directconnect/DirectConnectServiceClientModel.h>
#include <aws/directconnect/DirectConnect_EXPORTS.h>
#include <aws/directconnect/model/AcceptDirectConnectGatewayAssociationProposalRequest.h>
#include <aws/directconnect/model/AcceptDirectConnectGatewayAssociationProposalResult.h>
#include <aws/directconnect/model/AddressFamily.h>
#include <aws/directconnect/model/AllocateHostedConnectionRequest.h>
#include <aws/directconnect/model/AllocateHostedConnectionResult.h>
#include <aws/directconnect/model/AllocatePrivateVirtualInterfaceRequest.h>
#include <aws/directconnect/model/AllocatePrivateVirtualInterfaceResult.h>
#include <aws/directconnect/model/AllocatePublicVirtualInterfaceRequest.h>
#include <aws/directconnect/model/AllocatePublicVirtualInterfaceResult.h>
#include <aws/directconnect/model/AllocateTransitVirtualInterfaceRequest.h>
#include <aws/directconnect/model/AllocateTransitVirtualInterfaceResult.h>
#include <aws/directconnect/model/AssociateConnectionWithLagRequest.h>
#include <aws/directconnect/model/AssociateConnectionWithLagResult.h>
#include <aws/directconnect/model/AssociateHostedConnectionRequest.h>
#include <aws/directconnect/model/AssociateHostedConnectionResult.h>
#include <aws/directconnect/model/AssociateMacSecKeyRequest.h>
#include <aws/directconnect/model/AssociateMacSecKeyResult.h>
#include <aws/directconnect/model/AssociateVirtualInterfaceRequest.h>
#include <aws/directconnect/model/AssociateVirtualInterfaceResult.h>
#include <aws/directconnect/model/AssociatedCoreNetwork.h>
#include <aws/directconnect/model/AssociatedGateway.h>
#include <aws/directconnect/model/BGPPeer.h>
#include <aws/directconnect/model/BGPPeerState.h>
#include <aws/directconnect/model/BGPStatus.h>
#include <aws/directconnect/model/ConfirmConnectionRequest.h>
#include <aws/directconnect/model/ConfirmConnectionResult.h>
#include <aws/directconnect/model/ConfirmCustomerAgreementRequest.h>
#include <aws/directconnect/model/ConfirmCustomerAgreementResult.h>
#include <aws/directconnect/model/ConfirmPrivateVirtualInterfaceRequest.h>
#include <aws/directconnect/model/ConfirmPrivateVirtualInterfaceResult.h>
#include <aws/directconnect/model/ConfirmPublicVirtualInterfaceRequest.h>
#include <aws/directconnect/model/ConfirmPublicVirtualInterfaceResult.h>
#include <aws/directconnect/model/ConfirmTransitVirtualInterfaceRequest.h>
#include <aws/directconnect/model/ConfirmTransitVirtualInterfaceResult.h>
#include <aws/directconnect/model/Connection.h>
#include <aws/directconnect/model/ConnectionState.h>
#include <aws/directconnect/model/CreateBGPPeerRequest.h>
#include <aws/directconnect/model/CreateBGPPeerResult.h>
#include <aws/directconnect/model/CreateConnectionRequest.h>
#include <aws/directconnect/model/CreateConnectionResult.h>
#include <aws/directconnect/model/CreateDirectConnectGatewayAssociationProposalRequest.h>
#include <aws/directconnect/model/CreateDirectConnectGatewayAssociationProposalResult.h>
#include <aws/directconnect/model/CreateDirectConnectGatewayAssociationRequest.h>
#include <aws/directconnect/model/CreateDirectConnectGatewayAssociationResult.h>
#include <aws/directconnect/model/CreateDirectConnectGatewayRequest.h>
#include <aws/directconnect/model/CreateDirectConnectGatewayResult.h>
#include <aws/directconnect/model/CreateInterconnectRequest.h>
#include <aws/directconnect/model/CreateInterconnectResult.h>
#include <aws/directconnect/model/CreateLagRequest.h>
#include <aws/directconnect/model/CreateLagResult.h>
#include <aws/directconnect/model/CreatePrivateVirtualInterfaceRequest.h>
#include <aws/directconnect/model/CreatePrivateVirtualInterfaceResult.h>
#include <aws/directconnect/model/CreatePublicVirtualInterfaceRequest.h>
#include <aws/directconnect/model/CreatePublicVirtualInterfaceResult.h>
#include <aws/directconnect/model/CreateTransitVirtualInterfaceRequest.h>
#include <aws/directconnect/model/CreateTransitVirtualInterfaceResult.h>
#include <aws/directconnect/model/CustomerAgreement.h>
#include <aws/directconnect/model/DeleteBGPPeerRequest.h>
#include <aws/directconnect/model/DeleteBGPPeerResult.h>
#include <aws/directconnect/model/DeleteConnectionRequest.h>
#include <aws/directconnect/model/DeleteConnectionResult.h>
#include <aws/directconnect/model/DeleteDirectConnectGatewayAssociationProposalRequest.h>
#include <aws/directconnect/model/DeleteDirectConnectGatewayAssociationProposalResult.h>
#include <aws/directconnect/model/DeleteDirectConnectGatewayAssociationRequest.h>
#include <aws/directconnect/model/DeleteDirectConnectGatewayAssociationResult.h>
#include <aws/directconnect/model/DeleteDirectConnectGatewayRequest.h>
#include <aws/directconnect/model/DeleteDirectConnectGatewayResult.h>
#include <aws/directconnect/model/DeleteInterconnectRequest.h>
#include <aws/directconnect/model/DeleteInterconnectResult.h>
#include <aws/directconnect/model/DeleteLagRequest.h>
#include <aws/directconnect/model/DeleteLagResult.h>
#include <aws/directconnect/model/DeleteVirtualInterfaceRequest.h>
#include <aws/directconnect/model/DeleteVirtualInterfaceResult.h>
#include <aws/directconnect/model/DescribeConnectionsRequest.h>
#include <aws/directconnect/model/DescribeConnectionsResult.h>
#include <aws/directconnect/model/DescribeCustomerMetadataRequest.h>
#include <aws/directconnect/model/DescribeCustomerMetadataResult.h>
#include <aws/directconnect/model/DescribeDirectConnectGatewayAssociationProposalsRequest.h>
#include <aws/directconnect/model/DescribeDirectConnectGatewayAssociationProposalsResult.h>
#include <aws/directconnect/model/DescribeDirectConnectGatewayAssociationsRequest.h>
#include <aws/directconnect/model/DescribeDirectConnectGatewayAssociationsResult.h>
#include <aws/directconnect/model/DescribeDirectConnectGatewayAttachmentsRequest.h>
#include <aws/directconnect/model/DescribeDirectConnectGatewayAttachmentsResult.h>
#include <aws/directconnect/model/DescribeDirectConnectGatewaysRequest.h>
#include <aws/directconnect/model/DescribeDirectConnectGatewaysResult.h>
#include <aws/directconnect/model/DescribeHostedConnectionsRequest.h>
#include <aws/directconnect/model/DescribeHostedConnectionsResult.h>
#include <aws/directconnect/model/DescribeInterconnectsRequest.h>
#include <aws/directconnect/model/DescribeInterconnectsResult.h>
#include <aws/directconnect/model/DescribeLagsRequest.h>
#include <aws/directconnect/model/DescribeLagsResult.h>
#include <aws/directconnect/model/DescribeLoaRequest.h>
#include <aws/directconnect/model/DescribeLoaResult.h>
#include <aws/directconnect/model/DescribeLocationsRequest.h>
#include <aws/directconnect/model/DescribeLocationsResult.h>
#include <aws/directconnect/model/DescribeRouterConfigurationRequest.h>
#include <aws/directconnect/model/DescribeRouterConfigurationResult.h>
#include <aws/directconnect/model/DescribeTagsRequest.h>
#include <aws/directconnect/model/DescribeTagsResult.h>
#include <aws/directconnect/model/DescribeVirtualGatewaysRequest.h>
#include <aws/directconnect/model/DescribeVirtualGatewaysResult.h>
#include <aws/directconnect/model/DescribeVirtualInterfacesRequest.h>
#include <aws/directconnect/model/DescribeVirtualInterfacesResult.h>
#include <aws/directconnect/model/DirectConnectGateway.h>
#include <aws/directconnect/model/DirectConnectGatewayAssociation.h>
#include <aws/directconnect/model/DirectConnectGatewayAssociationProposal.h>
#include <aws/directconnect/model/DirectConnectGatewayAssociationProposalState.h>
#include <aws/directconnect/model/DirectConnectGatewayAssociationState.h>
#include <aws/directconnect/model/DirectConnectGatewayAttachment.h>
#include <aws/directconnect/model/DirectConnectGatewayAttachmentState.h>
#include <aws/directconnect/model/DirectConnectGatewayAttachmentType.h>
#include <aws/directconnect/model/DirectConnectGatewayState.h>
#include <aws/directconnect/model/DisassociateConnectionFromLagRequest.h>
#include <aws/directconnect/model/DisassociateConnectionFromLagResult.h>
#include <aws/directconnect/model/DisassociateMacSecKeyRequest.h>
#include <aws/directconnect/model/DisassociateMacSecKeyResult.h>
#include <aws/directconnect/model/GatewayType.h>
#include <aws/directconnect/model/HasLogicalRedundancy.h>
#include <aws/directconnect/model/Interconnect.h>
#include <aws/directconnect/model/InterconnectState.h>
#include <aws/directconnect/model/Lag.h>
#include <aws/directconnect/model/LagState.h>
#include <aws/directconnect/model/ListVirtualInterfaceTestHistoryRequest.h>
#include <aws/directconnect/model/ListVirtualInterfaceTestHistoryResult.h>
#include <aws/directconnect/model/Loa.h>
#include <aws/directconnect/model/LoaContentType.h>
#include <aws/directconnect/model/Location.h>
#include <aws/directconnect/model/MacSecKey.h>
#include <aws/directconnect/model/NewBGPPeer.h>
#include <aws/directconnect/model/NewPrivateVirtualInterface.h>
#include <aws/directconnect/model/NewPrivateVirtualInterfaceAllocation.h>
#include <aws/directconnect/model/NewPublicVirtualInterface.h>
#include <aws/directconnect/model/NewPublicVirtualInterfaceAllocation.h>
#include <aws/directconnect/model/NewTransitVirtualInterface.h>
#include <aws/directconnect/model/NewTransitVirtualInterfaceAllocation.h>
#include <aws/directconnect/model/NniPartnerType.h>
#include <aws/directconnect/model/ResourceTag.h>
#include <aws/directconnect/model/RouteFilterPrefix.h>
#include <aws/directconnect/model/RouterType.h>
#include <aws/directconnect/model/StartBgpFailoverTestRequest.h>
#include <aws/directconnect/model/StartBgpFailoverTestResult.h>
#include <aws/directconnect/model/StopBgpFailoverTestRequest.h>
#include <aws/directconnect/model/StopBgpFailoverTestResult.h>
#include <aws/directconnect/model/Tag.h>
#include <aws/directconnect/model/TagResourceRequest.h>
#include <aws/directconnect/model/TagResourceResult.h>
#include <aws/directconnect/model/UntagResourceRequest.h>
#include <aws/directconnect/model/UntagResourceResult.h>
#include <aws/directconnect/model/UpdateConnectionRequest.h>
#include <aws/directconnect/model/UpdateConnectionResult.h>
#include <aws/directconnect/model/UpdateDirectConnectGatewayAssociationRequest.h>
#include <aws/directconnect/model/UpdateDirectConnectGatewayAssociationResult.h>
#include <aws/directconnect/model/UpdateDirectConnectGatewayRequest.h>
#include <aws/directconnect/model/UpdateDirectConnectGatewayResult.h>
#include <aws/directconnect/model/UpdateLagRequest.h>
#include <aws/directconnect/model/UpdateLagResult.h>
#include <aws/directconnect/model/UpdateVirtualInterfaceAttributesRequest.h>
#include <aws/directconnect/model/UpdateVirtualInterfaceAttributesResult.h>
#include <aws/directconnect/model/VirtualGateway.h>
#include <aws/directconnect/model/VirtualInterface.h>
#include <aws/directconnect/model/VirtualInterfaceState.h>
#include <aws/directconnect/model/VirtualInterfaceTestHistory.h>

using DirectConnectIncludeTest = ::testing::Test;

TEST_F(DirectConnectIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::DirectConnect::DirectConnectClient>("DirectConnectIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
