/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/dms/DatabaseMigrationServiceClient.h>
#include <aws/dms/DatabaseMigrationServiceEndpointProvider.h>
#include <aws/dms/DatabaseMigrationServiceEndpointRules.h>
#include <aws/dms/DatabaseMigrationServiceErrorMarshaller.h>
#include <aws/dms/DatabaseMigrationServiceErrors.h>
#include <aws/dms/DatabaseMigrationServiceRequest.h>
#include <aws/dms/DatabaseMigrationServiceServiceClientModel.h>
#include <aws/dms/DatabaseMigrationService_EXPORTS.h>
#include <aws/dms/model/AccountQuota.h>
#include <aws/dms/model/AddTagsToResourceRequest.h>
#include <aws/dms/model/AddTagsToResourceResult.h>
#include <aws/dms/model/ApplyPendingMaintenanceActionRequest.h>
#include <aws/dms/model/ApplyPendingMaintenanceActionResult.h>
#include <aws/dms/model/AssessmentReportType.h>
#include <aws/dms/model/AuthMechanismValue.h>
#include <aws/dms/model/AuthTypeValue.h>
#include <aws/dms/model/AvailabilityZone.h>
#include <aws/dms/model/BatchStartRecommendationsErrorEntry.h>
#include <aws/dms/model/BatchStartRecommendationsRequest.h>
#include <aws/dms/model/BatchStartRecommendationsResult.h>
#include <aws/dms/model/CancelReplicationTaskAssessmentRunRequest.h>
#include <aws/dms/model/CancelReplicationTaskAssessmentRunResult.h>
#include <aws/dms/model/CannedAclForObjectsValue.h>
#include <aws/dms/model/Certificate.h>
#include <aws/dms/model/CharLengthSemantics.h>
#include <aws/dms/model/CollectorHealthCheck.h>
#include <aws/dms/model/CollectorResponse.h>
#include <aws/dms/model/CollectorShortInfoResponse.h>
#include <aws/dms/model/CollectorStatus.h>
#include <aws/dms/model/CompressionTypeValue.h>
#include <aws/dms/model/ComputeConfig.h>
#include <aws/dms/model/Connection.h>
#include <aws/dms/model/CreateDataMigrationRequest.h>
#include <aws/dms/model/CreateDataMigrationResult.h>
#include <aws/dms/model/CreateDataProviderRequest.h>
#include <aws/dms/model/CreateDataProviderResult.h>
#include <aws/dms/model/CreateEndpointRequest.h>
#include <aws/dms/model/CreateEndpointResult.h>
#include <aws/dms/model/CreateEventSubscriptionRequest.h>
#include <aws/dms/model/CreateEventSubscriptionResult.h>
#include <aws/dms/model/CreateFleetAdvisorCollectorRequest.h>
#include <aws/dms/model/CreateFleetAdvisorCollectorResult.h>
#include <aws/dms/model/CreateInstanceProfileRequest.h>
#include <aws/dms/model/CreateInstanceProfileResult.h>
#include <aws/dms/model/CreateMigrationProjectRequest.h>
#include <aws/dms/model/CreateMigrationProjectResult.h>
#include <aws/dms/model/CreateReplicationConfigRequest.h>
#include <aws/dms/model/CreateReplicationConfigResult.h>
#include <aws/dms/model/CreateReplicationInstanceRequest.h>
#include <aws/dms/model/CreateReplicationInstanceResult.h>
#include <aws/dms/model/CreateReplicationSubnetGroupRequest.h>
#include <aws/dms/model/CreateReplicationSubnetGroupResult.h>
#include <aws/dms/model/CreateReplicationTaskRequest.h>
#include <aws/dms/model/CreateReplicationTaskResult.h>
#include <aws/dms/model/DataFormatValue.h>
#include <aws/dms/model/DataMigration.h>
#include <aws/dms/model/DataMigrationSettings.h>
#include <aws/dms/model/DataMigrationStatistics.h>
#include <aws/dms/model/DataProvider.h>
#include <aws/dms/model/DataProviderDescriptor.h>
#include <aws/dms/model/DataProviderDescriptorDefinition.h>
#include <aws/dms/model/DataProviderSettings.h>
#include <aws/dms/model/DatabaseInstanceSoftwareDetailsResponse.h>
#include <aws/dms/model/DatabaseMode.h>
#include <aws/dms/model/DatabaseResponse.h>
#include <aws/dms/model/DatabaseShortInfoResponse.h>
#include <aws/dms/model/DatePartitionDelimiterValue.h>
#include <aws/dms/model/DatePartitionSequenceValue.h>
#include <aws/dms/model/DefaultErrorDetails.h>
#include <aws/dms/model/DeleteCertificateRequest.h>
#include <aws/dms/model/DeleteCertificateResult.h>
#include <aws/dms/model/DeleteConnectionRequest.h>
#include <aws/dms/model/DeleteConnectionResult.h>
#include <aws/dms/model/DeleteDataMigrationRequest.h>
#include <aws/dms/model/DeleteDataMigrationResult.h>
#include <aws/dms/model/DeleteDataProviderRequest.h>
#include <aws/dms/model/DeleteDataProviderResult.h>
#include <aws/dms/model/DeleteEndpointRequest.h>
#include <aws/dms/model/DeleteEndpointResult.h>
#include <aws/dms/model/DeleteEventSubscriptionRequest.h>
#include <aws/dms/model/DeleteEventSubscriptionResult.h>
#include <aws/dms/model/DeleteFleetAdvisorCollectorRequest.h>
#include <aws/dms/model/DeleteFleetAdvisorDatabasesRequest.h>
#include <aws/dms/model/DeleteFleetAdvisorDatabasesResult.h>
#include <aws/dms/model/DeleteInstanceProfileRequest.h>
#include <aws/dms/model/DeleteInstanceProfileResult.h>
#include <aws/dms/model/DeleteMigrationProjectRequest.h>
#include <aws/dms/model/DeleteMigrationProjectResult.h>
#include <aws/dms/model/DeleteReplicationConfigRequest.h>
#include <aws/dms/model/DeleteReplicationConfigResult.h>
#include <aws/dms/model/DeleteReplicationInstanceRequest.h>
#include <aws/dms/model/DeleteReplicationInstanceResult.h>
#include <aws/dms/model/DeleteReplicationSubnetGroupRequest.h>
#include <aws/dms/model/DeleteReplicationSubnetGroupResult.h>
#include <aws/dms/model/DeleteReplicationTaskAssessmentRunRequest.h>
#include <aws/dms/model/DeleteReplicationTaskAssessmentRunResult.h>
#include <aws/dms/model/DeleteReplicationTaskRequest.h>
#include <aws/dms/model/DeleteReplicationTaskResult.h>
#include <aws/dms/model/DescribeAccountAttributesRequest.h>
#include <aws/dms/model/DescribeAccountAttributesResult.h>
#include <aws/dms/model/DescribeApplicableIndividualAssessmentsRequest.h>
#include <aws/dms/model/DescribeApplicableIndividualAssessmentsResult.h>
#include <aws/dms/model/DescribeCertificatesRequest.h>
#include <aws/dms/model/DescribeCertificatesResult.h>
#include <aws/dms/model/DescribeConnectionsRequest.h>
#include <aws/dms/model/DescribeConnectionsResult.h>
#include <aws/dms/model/DescribeConversionConfigurationRequest.h>
#include <aws/dms/model/DescribeConversionConfigurationResult.h>
#include <aws/dms/model/DescribeDataMigrationsRequest.h>
#include <aws/dms/model/DescribeDataMigrationsResult.h>
#include <aws/dms/model/DescribeDataProvidersRequest.h>
#include <aws/dms/model/DescribeDataProvidersResult.h>
#include <aws/dms/model/DescribeEndpointSettingsRequest.h>
#include <aws/dms/model/DescribeEndpointSettingsResult.h>
#include <aws/dms/model/DescribeEndpointTypesRequest.h>
#include <aws/dms/model/DescribeEndpointTypesResult.h>
#include <aws/dms/model/DescribeEndpointsRequest.h>
#include <aws/dms/model/DescribeEndpointsResult.h>
#include <aws/dms/model/DescribeEngineVersionsRequest.h>
#include <aws/dms/model/DescribeEngineVersionsResult.h>
#include <aws/dms/model/DescribeEventCategoriesRequest.h>
#include <aws/dms/model/DescribeEventCategoriesResult.h>
#include <aws/dms/model/DescribeEventSubscriptionsRequest.h>
#include <aws/dms/model/DescribeEventSubscriptionsResult.h>
#include <aws/dms/model/DescribeEventsRequest.h>
#include <aws/dms/model/DescribeEventsResult.h>
#include <aws/dms/model/DescribeExtensionPackAssociationsRequest.h>
#include <aws/dms/model/DescribeExtensionPackAssociationsResult.h>
#include <aws/dms/model/DescribeFleetAdvisorCollectorsRequest.h>
#include <aws/dms/model/DescribeFleetAdvisorCollectorsResult.h>
#include <aws/dms/model/DescribeFleetAdvisorDatabasesRequest.h>
#include <aws/dms/model/DescribeFleetAdvisorDatabasesResult.h>
#include <aws/dms/model/DescribeFleetAdvisorLsaAnalysisRequest.h>
#include <aws/dms/model/DescribeFleetAdvisorLsaAnalysisResult.h>
#include <aws/dms/model/DescribeFleetAdvisorSchemaObjectSummaryRequest.h>
#include <aws/dms/model/DescribeFleetAdvisorSchemaObjectSummaryResult.h>
#include <aws/dms/model/DescribeFleetAdvisorSchemasRequest.h>
#include <aws/dms/model/DescribeFleetAdvisorSchemasResult.h>
#include <aws/dms/model/DescribeInstanceProfilesRequest.h>
#include <aws/dms/model/DescribeInstanceProfilesResult.h>
#include <aws/dms/model/DescribeMetadataModelAssessmentsRequest.h>
#include <aws/dms/model/DescribeMetadataModelAssessmentsResult.h>
#include <aws/dms/model/DescribeMetadataModelConversionsRequest.h>
#include <aws/dms/model/DescribeMetadataModelConversionsResult.h>
#include <aws/dms/model/DescribeMetadataModelExportsAsScriptRequest.h>
#include <aws/dms/model/DescribeMetadataModelExportsAsScriptResult.h>
#include <aws/dms/model/DescribeMetadataModelExportsToTargetRequest.h>
#include <aws/dms/model/DescribeMetadataModelExportsToTargetResult.h>
#include <aws/dms/model/DescribeMetadataModelImportsRequest.h>
#include <aws/dms/model/DescribeMetadataModelImportsResult.h>
#include <aws/dms/model/DescribeMigrationProjectsRequest.h>
#include <aws/dms/model/DescribeMigrationProjectsResult.h>
#include <aws/dms/model/DescribeOrderableReplicationInstancesRequest.h>
#include <aws/dms/model/DescribeOrderableReplicationInstancesResult.h>
#include <aws/dms/model/DescribePendingMaintenanceActionsRequest.h>
#include <aws/dms/model/DescribePendingMaintenanceActionsResult.h>
#include <aws/dms/model/DescribeRecommendationLimitationsRequest.h>
#include <aws/dms/model/DescribeRecommendationLimitationsResult.h>
#include <aws/dms/model/DescribeRecommendationsRequest.h>
#include <aws/dms/model/DescribeRecommendationsResult.h>
#include <aws/dms/model/DescribeRefreshSchemasStatusRequest.h>
#include <aws/dms/model/DescribeRefreshSchemasStatusResult.h>
#include <aws/dms/model/DescribeReplicationConfigsRequest.h>
#include <aws/dms/model/DescribeReplicationConfigsResult.h>
#include <aws/dms/model/DescribeReplicationInstanceTaskLogsRequest.h>
#include <aws/dms/model/DescribeReplicationInstanceTaskLogsResult.h>
#include <aws/dms/model/DescribeReplicationInstancesRequest.h>
#include <aws/dms/model/DescribeReplicationInstancesResult.h>
#include <aws/dms/model/DescribeReplicationSubnetGroupsRequest.h>
#include <aws/dms/model/DescribeReplicationSubnetGroupsResult.h>
#include <aws/dms/model/DescribeReplicationTableStatisticsRequest.h>
#include <aws/dms/model/DescribeReplicationTableStatisticsResult.h>
#include <aws/dms/model/DescribeReplicationTaskAssessmentResultsRequest.h>
#include <aws/dms/model/DescribeReplicationTaskAssessmentResultsResult.h>
#include <aws/dms/model/DescribeReplicationTaskAssessmentRunsRequest.h>
#include <aws/dms/model/DescribeReplicationTaskAssessmentRunsResult.h>
#include <aws/dms/model/DescribeReplicationTaskIndividualAssessmentsRequest.h>
#include <aws/dms/model/DescribeReplicationTaskIndividualAssessmentsResult.h>
#include <aws/dms/model/DescribeReplicationTasksRequest.h>
#include <aws/dms/model/DescribeReplicationTasksResult.h>
#include <aws/dms/model/DescribeReplicationsRequest.h>
#include <aws/dms/model/DescribeReplicationsResult.h>
#include <aws/dms/model/DescribeSchemasRequest.h>
#include <aws/dms/model/DescribeSchemasResult.h>
#include <aws/dms/model/DescribeTableStatisticsRequest.h>
#include <aws/dms/model/DescribeTableStatisticsResult.h>
#include <aws/dms/model/DmsSslModeValue.h>
#include <aws/dms/model/DmsTransferSettings.h>
#include <aws/dms/model/DocDbDataProviderSettings.h>
#include <aws/dms/model/DocDbSettings.h>
#include <aws/dms/model/DynamoDbSettings.h>
#include <aws/dms/model/ElasticsearchSettings.h>
#include <aws/dms/model/EncodingTypeValue.h>
#include <aws/dms/model/EncryptionModeValue.h>
#include <aws/dms/model/Endpoint.h>
#include <aws/dms/model/EndpointSetting.h>
#include <aws/dms/model/EndpointSettingTypeValue.h>
#include <aws/dms/model/EngineVersion.h>
#include <aws/dms/model/ErrorDetails.h>
#include <aws/dms/model/Event.h>
#include <aws/dms/model/EventCategoryGroup.h>
#include <aws/dms/model/EventSubscription.h>
#include <aws/dms/model/ExportMetadataModelAssessmentRequest.h>
#include <aws/dms/model/ExportMetadataModelAssessmentResult.h>
#include <aws/dms/model/ExportMetadataModelAssessmentResultEntry.h>
#include <aws/dms/model/ExportSqlDetails.h>
#include <aws/dms/model/Filter.h>
#include <aws/dms/model/FleetAdvisorLsaAnalysisResponse.h>
#include <aws/dms/model/FleetAdvisorSchemaObjectResponse.h>
#include <aws/dms/model/GcpMySQLSettings.h>
#include <aws/dms/model/IBMDb2Settings.h>
#include <aws/dms/model/IbmDb2LuwDataProviderSettings.h>
#include <aws/dms/model/IbmDb2zOsDataProviderSettings.h>
#include <aws/dms/model/ImportCertificateRequest.h>
#include <aws/dms/model/ImportCertificateResult.h>
#include <aws/dms/model/InstanceProfile.h>
#include <aws/dms/model/InventoryData.h>
#include <aws/dms/model/KafkaSaslMechanism.h>
#include <aws/dms/model/KafkaSecurityProtocol.h>
#include <aws/dms/model/KafkaSettings.h>
#include <aws/dms/model/KafkaSslEndpointIdentificationAlgorithm.h>
#include <aws/dms/model/KerberosAuthenticationSettings.h>
#include <aws/dms/model/KinesisSettings.h>
#include <aws/dms/model/Limitation.h>
#include <aws/dms/model/ListTagsForResourceRequest.h>
#include <aws/dms/model/ListTagsForResourceResult.h>
#include <aws/dms/model/LongVarcharMappingType.h>
#include <aws/dms/model/MariaDbDataProviderSettings.h>
#include <aws/dms/model/MessageFormatValue.h>
#include <aws/dms/model/MicrosoftSQLServerSettings.h>
#include <aws/dms/model/MicrosoftSqlServerDataProviderSettings.h>
#include <aws/dms/model/MigrationProject.h>
#include <aws/dms/model/MigrationTypeValue.h>
#include <aws/dms/model/ModifyConversionConfigurationRequest.h>
#include <aws/dms/model/ModifyConversionConfigurationResult.h>
#include <aws/dms/model/ModifyDataMigrationRequest.h>
#include <aws/dms/model/ModifyDataMigrationResult.h>
#include <aws/dms/model/ModifyDataProviderRequest.h>
#include <aws/dms/model/ModifyDataProviderResult.h>
#include <aws/dms/model/ModifyEndpointRequest.h>
#include <aws/dms/model/ModifyEndpointResult.h>
#include <aws/dms/model/ModifyEventSubscriptionRequest.h>
#include <aws/dms/model/ModifyEventSubscriptionResult.h>
#include <aws/dms/model/ModifyInstanceProfileRequest.h>
#include <aws/dms/model/ModifyInstanceProfileResult.h>
#include <aws/dms/model/ModifyMigrationProjectRequest.h>
#include <aws/dms/model/ModifyMigrationProjectResult.h>
#include <aws/dms/model/ModifyReplicationConfigRequest.h>
#include <aws/dms/model/ModifyReplicationConfigResult.h>
#include <aws/dms/model/ModifyReplicationInstanceRequest.h>
#include <aws/dms/model/ModifyReplicationInstanceResult.h>
#include <aws/dms/model/ModifyReplicationSubnetGroupRequest.h>
#include <aws/dms/model/ModifyReplicationSubnetGroupResult.h>
#include <aws/dms/model/ModifyReplicationTaskRequest.h>
#include <aws/dms/model/ModifyReplicationTaskResult.h>
#include <aws/dms/model/MongoDbDataProviderSettings.h>
#include <aws/dms/model/MongoDbSettings.h>
#include <aws/dms/model/MoveReplicationTaskRequest.h>
#include <aws/dms/model/MoveReplicationTaskResult.h>
#include <aws/dms/model/MySQLAuthenticationMethod.h>
#include <aws/dms/model/MySQLSettings.h>
#include <aws/dms/model/MySqlDataProviderSettings.h>
#include <aws/dms/model/NeptuneSettings.h>
#include <aws/dms/model/NestingLevelValue.h>
#include <aws/dms/model/OracleAuthenticationMethod.h>
#include <aws/dms/model/OracleDataProviderSettings.h>
#include <aws/dms/model/OracleSettings.h>
#include <aws/dms/model/OrderableReplicationInstance.h>
#include <aws/dms/model/OriginTypeValue.h>
#include <aws/dms/model/ParquetVersionValue.h>
#include <aws/dms/model/PendingMaintenanceAction.h>
#include <aws/dms/model/PluginNameValue.h>
#include <aws/dms/model/PostgreSQLAuthenticationMethod.h>
#include <aws/dms/model/PostgreSQLSettings.h>
#include <aws/dms/model/PostgreSqlDataProviderSettings.h>
#include <aws/dms/model/PremigrationAssessmentStatus.h>
#include <aws/dms/model/ProvisionData.h>
#include <aws/dms/model/RdsConfiguration.h>
#include <aws/dms/model/RdsRecommendation.h>
#include <aws/dms/model/RdsRequirements.h>
#include <aws/dms/model/RebootReplicationInstanceRequest.h>
#include <aws/dms/model/RebootReplicationInstanceResult.h>
#include <aws/dms/model/Recommendation.h>
#include <aws/dms/model/RecommendationData.h>
#include <aws/dms/model/RecommendationSettings.h>
#include <aws/dms/model/RedisAuthTypeValue.h>
#include <aws/dms/model/RedisSettings.h>
#include <aws/dms/model/RedshiftDataProviderSettings.h>
#include <aws/dms/model/RedshiftSettings.h>
#include <aws/dms/model/RefreshSchemasRequest.h>
#include <aws/dms/model/RefreshSchemasResult.h>
#include <aws/dms/model/RefreshSchemasStatus.h>
#include <aws/dms/model/RefreshSchemasStatusTypeValue.h>
#include <aws/dms/model/ReleaseStatusValues.h>
#include <aws/dms/model/ReloadOptionValue.h>
#include <aws/dms/model/ReloadReplicationTablesRequest.h>
#include <aws/dms/model/ReloadReplicationTablesResult.h>
#include <aws/dms/model/ReloadTablesRequest.h>
#include <aws/dms/model/ReloadTablesResult.h>
#include <aws/dms/model/RemoveTagsFromResourceRequest.h>
#include <aws/dms/model/RemoveTagsFromResourceResult.h>
#include <aws/dms/model/Replication.h>
#include <aws/dms/model/ReplicationConfig.h>
#include <aws/dms/model/ReplicationEndpointTypeValue.h>
#include <aws/dms/model/ReplicationInstance.h>
#include <aws/dms/model/ReplicationInstanceTaskLog.h>
#include <aws/dms/model/ReplicationPendingModifiedValues.h>
#include <aws/dms/model/ReplicationStats.h>
#include <aws/dms/model/ReplicationSubnetGroup.h>
#include <aws/dms/model/ReplicationTask.h>
#include <aws/dms/model/ReplicationTaskAssessmentResult.h>
#include <aws/dms/model/ReplicationTaskAssessmentRun.h>
#include <aws/dms/model/ReplicationTaskAssessmentRunProgress.h>
#include <aws/dms/model/ReplicationTaskAssessmentRunResultStatistic.h>
#include <aws/dms/model/ReplicationTaskIndividualAssessment.h>
#include <aws/dms/model/ReplicationTaskStats.h>
#include <aws/dms/model/ResourceAlreadyExistsFault.h>
#include <aws/dms/model/ResourcePendingMaintenanceActions.h>
#include <aws/dms/model/RunFleetAdvisorLsaAnalysisRequest.h>
#include <aws/dms/model/RunFleetAdvisorLsaAnalysisResult.h>
#include <aws/dms/model/S3Settings.h>
#include <aws/dms/model/SCApplicationAttributes.h>
#include <aws/dms/model/SafeguardPolicy.h>
#include <aws/dms/model/SchemaConversionRequest.h>
#include <aws/dms/model/SchemaResponse.h>
#include <aws/dms/model/SchemaShortInfoResponse.h>
#include <aws/dms/model/ServerShortInfoResponse.h>
#include <aws/dms/model/SourceDataSetting.h>
#include <aws/dms/model/SourceType.h>
#include <aws/dms/model/SqlServerAuthenticationMethod.h>
#include <aws/dms/model/SslSecurityProtocolValue.h>
#include <aws/dms/model/StartDataMigrationRequest.h>
#include <aws/dms/model/StartDataMigrationResult.h>
#include <aws/dms/model/StartExtensionPackAssociationRequest.h>
#include <aws/dms/model/StartExtensionPackAssociationResult.h>
#include <aws/dms/model/StartMetadataModelAssessmentRequest.h>
#include <aws/dms/model/StartMetadataModelAssessmentResult.h>
#include <aws/dms/model/StartMetadataModelConversionRequest.h>
#include <aws/dms/model/StartMetadataModelConversionResult.h>
#include <aws/dms/model/StartMetadataModelExportAsScriptRequest.h>
#include <aws/dms/model/StartMetadataModelExportAsScriptResult.h>
#include <aws/dms/model/StartMetadataModelExportToTargetRequest.h>
#include <aws/dms/model/StartMetadataModelExportToTargetResult.h>
#include <aws/dms/model/StartMetadataModelImportRequest.h>
#include <aws/dms/model/StartMetadataModelImportResult.h>
#include <aws/dms/model/StartRecommendationsRequest.h>
#include <aws/dms/model/StartRecommendationsRequestEntry.h>
#include <aws/dms/model/StartReplicationMigrationTypeValue.h>
#include <aws/dms/model/StartReplicationRequest.h>
#include <aws/dms/model/StartReplicationResult.h>
#include <aws/dms/model/StartReplicationTaskAssessmentRequest.h>
#include <aws/dms/model/StartReplicationTaskAssessmentResult.h>
#include <aws/dms/model/StartReplicationTaskAssessmentRunRequest.h>
#include <aws/dms/model/StartReplicationTaskAssessmentRunResult.h>
#include <aws/dms/model/StartReplicationTaskRequest.h>
#include <aws/dms/model/StartReplicationTaskResult.h>
#include <aws/dms/model/StartReplicationTaskTypeValue.h>
#include <aws/dms/model/StopDataMigrationRequest.h>
#include <aws/dms/model/StopDataMigrationResult.h>
#include <aws/dms/model/StopReplicationRequest.h>
#include <aws/dms/model/StopReplicationResult.h>
#include <aws/dms/model/StopReplicationTaskRequest.h>
#include <aws/dms/model/StopReplicationTaskResult.h>
#include <aws/dms/model/Subnet.h>
#include <aws/dms/model/SupportedEndpointType.h>
#include <aws/dms/model/SybaseSettings.h>
#include <aws/dms/model/TablePreparationMode.h>
#include <aws/dms/model/TableStatistics.h>
#include <aws/dms/model/TableToReload.h>
#include <aws/dms/model/Tag.h>
#include <aws/dms/model/TargetDataSetting.h>
#include <aws/dms/model/TargetDbType.h>
#include <aws/dms/model/TestConnectionRequest.h>
#include <aws/dms/model/TestConnectionResult.h>
#include <aws/dms/model/TimestreamSettings.h>
#include <aws/dms/model/TlogAccessMode.h>
#include <aws/dms/model/UpdateSubscriptionsToEventBridgeRequest.h>
#include <aws/dms/model/UpdateSubscriptionsToEventBridgeResult.h>
#include <aws/dms/model/VersionStatus.h>
#include <aws/dms/model/VpcSecurityGroupMembership.h>

using DatabaseMigrationServiceIncludeTest = ::testing::Test;

TEST_F(DatabaseMigrationServiceIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::DatabaseMigrationService::DatabaseMigrationServiceClient>("DatabaseMigrationServiceIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
