/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/docdb/DocDBClient.h>
#include <aws/docdb/DocDBEndpointProvider.h>
#include <aws/docdb/DocDBEndpointRules.h>
#include <aws/docdb/DocDBErrorMarshaller.h>
#include <aws/docdb/DocDBErrors.h>
#include <aws/docdb/DocDBRequest.h>
#include <aws/docdb/DocDBServiceClientModel.h>
#include <aws/docdb/DocDB_EXPORTS.h>
#include <aws/docdb/model/AddSourceIdentifierToSubscriptionRequest.h>
#include <aws/docdb/model/AddSourceIdentifierToSubscriptionResult.h>
#include <aws/docdb/model/AddTagsToResourceRequest.h>
#include <aws/docdb/model/ApplyMethod.h>
#include <aws/docdb/model/ApplyPendingMaintenanceActionRequest.h>
#include <aws/docdb/model/ApplyPendingMaintenanceActionResult.h>
#include <aws/docdb/model/AvailabilityZone.h>
#include <aws/docdb/model/Certificate.h>
#include <aws/docdb/model/CertificateDetails.h>
#include <aws/docdb/model/CloudwatchLogsExportConfiguration.h>
#include <aws/docdb/model/ClusterMasterUserSecret.h>
#include <aws/docdb/model/CopyDBClusterParameterGroupRequest.h>
#include <aws/docdb/model/CopyDBClusterParameterGroupResult.h>
#include <aws/docdb/model/CopyDBClusterSnapshotRequest.h>
#include <aws/docdb/model/CopyDBClusterSnapshotResult.h>
#include <aws/docdb/model/CreateDBClusterParameterGroupRequest.h>
#include <aws/docdb/model/CreateDBClusterParameterGroupResult.h>
#include <aws/docdb/model/CreateDBClusterRequest.h>
#include <aws/docdb/model/CreateDBClusterResult.h>
#include <aws/docdb/model/CreateDBClusterSnapshotRequest.h>
#include <aws/docdb/model/CreateDBClusterSnapshotResult.h>
#include <aws/docdb/model/CreateDBInstanceRequest.h>
#include <aws/docdb/model/CreateDBInstanceResult.h>
#include <aws/docdb/model/CreateDBSubnetGroupRequest.h>
#include <aws/docdb/model/CreateDBSubnetGroupResult.h>
#include <aws/docdb/model/CreateEventSubscriptionRequest.h>
#include <aws/docdb/model/CreateEventSubscriptionResult.h>
#include <aws/docdb/model/CreateGlobalClusterRequest.h>
#include <aws/docdb/model/CreateGlobalClusterResult.h>
#include <aws/docdb/model/DBCluster.h>
#include <aws/docdb/model/DBClusterMember.h>
#include <aws/docdb/model/DBClusterParameterGroup.h>
#include <aws/docdb/model/DBClusterRole.h>
#include <aws/docdb/model/DBClusterSnapshot.h>
#include <aws/docdb/model/DBClusterSnapshotAttribute.h>
#include <aws/docdb/model/DBClusterSnapshotAttributesResult.h>
#include <aws/docdb/model/DBEngineVersion.h>
#include <aws/docdb/model/DBInstance.h>
#include <aws/docdb/model/DBInstanceStatusInfo.h>
#include <aws/docdb/model/DBSubnetGroup.h>
#include <aws/docdb/model/DeleteDBClusterParameterGroupRequest.h>
#include <aws/docdb/model/DeleteDBClusterRequest.h>
#include <aws/docdb/model/DeleteDBClusterResult.h>
#include <aws/docdb/model/DeleteDBClusterSnapshotRequest.h>
#include <aws/docdb/model/DeleteDBClusterSnapshotResult.h>
#include <aws/docdb/model/DeleteDBInstanceRequest.h>
#include <aws/docdb/model/DeleteDBInstanceResult.h>
#include <aws/docdb/model/DeleteDBSubnetGroupRequest.h>
#include <aws/docdb/model/DeleteEventSubscriptionRequest.h>
#include <aws/docdb/model/DeleteEventSubscriptionResult.h>
#include <aws/docdb/model/DeleteGlobalClusterRequest.h>
#include <aws/docdb/model/DeleteGlobalClusterResult.h>
#include <aws/docdb/model/DescribeCertificatesRequest.h>
#include <aws/docdb/model/DescribeCertificatesResult.h>
#include <aws/docdb/model/DescribeDBClusterParameterGroupsRequest.h>
#include <aws/docdb/model/DescribeDBClusterParameterGroupsResult.h>
#include <aws/docdb/model/DescribeDBClusterParametersRequest.h>
#include <aws/docdb/model/DescribeDBClusterParametersResult.h>
#include <aws/docdb/model/DescribeDBClusterSnapshotAttributesRequest.h>
#include <aws/docdb/model/DescribeDBClusterSnapshotAttributesResult.h>
#include <aws/docdb/model/DescribeDBClusterSnapshotsRequest.h>
#include <aws/docdb/model/DescribeDBClusterSnapshotsResult.h>
#include <aws/docdb/model/DescribeDBClustersRequest.h>
#include <aws/docdb/model/DescribeDBClustersResult.h>
#include <aws/docdb/model/DescribeDBEngineVersionsRequest.h>
#include <aws/docdb/model/DescribeDBEngineVersionsResult.h>
#include <aws/docdb/model/DescribeDBInstancesRequest.h>
#include <aws/docdb/model/DescribeDBInstancesResult.h>
#include <aws/docdb/model/DescribeDBSubnetGroupsRequest.h>
#include <aws/docdb/model/DescribeDBSubnetGroupsResult.h>
#include <aws/docdb/model/DescribeEngineDefaultClusterParametersRequest.h>
#include <aws/docdb/model/DescribeEngineDefaultClusterParametersResult.h>
#include <aws/docdb/model/DescribeEventCategoriesRequest.h>
#include <aws/docdb/model/DescribeEventCategoriesResult.h>
#include <aws/docdb/model/DescribeEventSubscriptionsRequest.h>
#include <aws/docdb/model/DescribeEventSubscriptionsResult.h>
#include <aws/docdb/model/DescribeEventsRequest.h>
#include <aws/docdb/model/DescribeEventsResult.h>
#include <aws/docdb/model/DescribeGlobalClustersRequest.h>
#include <aws/docdb/model/DescribeGlobalClustersResult.h>
#include <aws/docdb/model/DescribeOrderableDBInstanceOptionsRequest.h>
#include <aws/docdb/model/DescribeOrderableDBInstanceOptionsResult.h>
#include <aws/docdb/model/DescribePendingMaintenanceActionsRequest.h>
#include <aws/docdb/model/DescribePendingMaintenanceActionsResult.h>
#include <aws/docdb/model/Endpoint.h>
#include <aws/docdb/model/EngineDefaults.h>
#include <aws/docdb/model/Event.h>
#include <aws/docdb/model/EventCategoriesMap.h>
#include <aws/docdb/model/EventSubscription.h>
#include <aws/docdb/model/FailoverDBClusterRequest.h>
#include <aws/docdb/model/FailoverDBClusterResult.h>
#include <aws/docdb/model/FailoverGlobalClusterRequest.h>
#include <aws/docdb/model/FailoverGlobalClusterResult.h>
#include <aws/docdb/model/Filter.h>
#include <aws/docdb/model/GlobalCluster.h>
#include <aws/docdb/model/GlobalClusterMember.h>
#include <aws/docdb/model/ListTagsForResourceRequest.h>
#include <aws/docdb/model/ListTagsForResourceResult.h>
#include <aws/docdb/model/ModifyDBClusterParameterGroupRequest.h>
#include <aws/docdb/model/ModifyDBClusterParameterGroupResult.h>
#include <aws/docdb/model/ModifyDBClusterRequest.h>
#include <aws/docdb/model/ModifyDBClusterResult.h>
#include <aws/docdb/model/ModifyDBClusterSnapshotAttributeRequest.h>
#include <aws/docdb/model/ModifyDBClusterSnapshotAttributeResult.h>
#include <aws/docdb/model/ModifyDBInstanceRequest.h>
#include <aws/docdb/model/ModifyDBInstanceResult.h>
#include <aws/docdb/model/ModifyDBSubnetGroupRequest.h>
#include <aws/docdb/model/ModifyDBSubnetGroupResult.h>
#include <aws/docdb/model/ModifyEventSubscriptionRequest.h>
#include <aws/docdb/model/ModifyEventSubscriptionResult.h>
#include <aws/docdb/model/ModifyGlobalClusterRequest.h>
#include <aws/docdb/model/ModifyGlobalClusterResult.h>
#include <aws/docdb/model/OrderableDBInstanceOption.h>
#include <aws/docdb/model/Parameter.h>
#include <aws/docdb/model/PendingCloudwatchLogsExports.h>
#include <aws/docdb/model/PendingMaintenanceAction.h>
#include <aws/docdb/model/PendingModifiedValues.h>
#include <aws/docdb/model/RebootDBInstanceRequest.h>
#include <aws/docdb/model/RebootDBInstanceResult.h>
#include <aws/docdb/model/RemoveFromGlobalClusterRequest.h>
#include <aws/docdb/model/RemoveFromGlobalClusterResult.h>
#include <aws/docdb/model/RemoveSourceIdentifierFromSubscriptionRequest.h>
#include <aws/docdb/model/RemoveSourceIdentifierFromSubscriptionResult.h>
#include <aws/docdb/model/RemoveTagsFromResourceRequest.h>
#include <aws/docdb/model/ResetDBClusterParameterGroupRequest.h>
#include <aws/docdb/model/ResetDBClusterParameterGroupResult.h>
#include <aws/docdb/model/ResourcePendingMaintenanceActions.h>
#include <aws/docdb/model/ResponseMetadata.h>
#include <aws/docdb/model/RestoreDBClusterFromSnapshotRequest.h>
#include <aws/docdb/model/RestoreDBClusterFromSnapshotResult.h>
#include <aws/docdb/model/RestoreDBClusterToPointInTimeRequest.h>
#include <aws/docdb/model/RestoreDBClusterToPointInTimeResult.h>
#include <aws/docdb/model/SourceType.h>
#include <aws/docdb/model/StartDBClusterRequest.h>
#include <aws/docdb/model/StartDBClusterResult.h>
#include <aws/docdb/model/StopDBClusterRequest.h>
#include <aws/docdb/model/StopDBClusterResult.h>
#include <aws/docdb/model/Subnet.h>
#include <aws/docdb/model/SwitchoverGlobalClusterRequest.h>
#include <aws/docdb/model/SwitchoverGlobalClusterResult.h>
#include <aws/docdb/model/Tag.h>
#include <aws/docdb/model/UpgradeTarget.h>
#include <aws/docdb/model/VpcSecurityGroupMembership.h>

using DocDBIncludeTest = ::testing::Test;

TEST_F(DocDBIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::DocDB::DocDBClient>("DocDBIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
