/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/drs/DrsClient.h>
#include <aws/drs/DrsEndpointProvider.h>
#include <aws/drs/DrsEndpointRules.h>
#include <aws/drs/DrsErrorMarshaller.h>
#include <aws/drs/DrsErrors.h>
#include <aws/drs/DrsRequest.h>
#include <aws/drs/DrsServiceClientModel.h>
#include <aws/drs/Drs_EXPORTS.h>
#include <aws/drs/model/AccessDeniedException.h>
#include <aws/drs/model/Account.h>
#include <aws/drs/model/AssociateSourceNetworkStackRequest.h>
#include <aws/drs/model/AssociateSourceNetworkStackResult.h>
#include <aws/drs/model/CPU.h>
#include <aws/drs/model/ConflictException.h>
#include <aws/drs/model/ConversionProperties.h>
#include <aws/drs/model/CreateExtendedSourceServerRequest.h>
#include <aws/drs/model/CreateExtendedSourceServerResult.h>
#include <aws/drs/model/CreateLaunchConfigurationTemplateRequest.h>
#include <aws/drs/model/CreateLaunchConfigurationTemplateResult.h>
#include <aws/drs/model/CreateReplicationConfigurationTemplateRequest.h>
#include <aws/drs/model/CreateReplicationConfigurationTemplateResult.h>
#include <aws/drs/model/CreateSourceNetworkRequest.h>
#include <aws/drs/model/CreateSourceNetworkResult.h>
#include <aws/drs/model/DataReplicationError.h>
#include <aws/drs/model/DataReplicationErrorString.h>
#include <aws/drs/model/DataReplicationInfo.h>
#include <aws/drs/model/DataReplicationInfoReplicatedDisk.h>
#include <aws/drs/model/DataReplicationInitiation.h>
#include <aws/drs/model/DataReplicationInitiationStep.h>
#include <aws/drs/model/DataReplicationInitiationStepName.h>
#include <aws/drs/model/DataReplicationInitiationStepStatus.h>
#include <aws/drs/model/DataReplicationState.h>
#include <aws/drs/model/DeleteJobRequest.h>
#include <aws/drs/model/DeleteJobResult.h>
#include <aws/drs/model/DeleteLaunchActionRequest.h>
#include <aws/drs/model/DeleteLaunchActionResult.h>
#include <aws/drs/model/DeleteLaunchConfigurationTemplateRequest.h>
#include <aws/drs/model/DeleteLaunchConfigurationTemplateResult.h>
#include <aws/drs/model/DeleteRecoveryInstanceRequest.h>
#include <aws/drs/model/DeleteReplicationConfigurationTemplateRequest.h>
#include <aws/drs/model/DeleteReplicationConfigurationTemplateResult.h>
#include <aws/drs/model/DeleteSourceNetworkRequest.h>
#include <aws/drs/model/DeleteSourceNetworkResult.h>
#include <aws/drs/model/DeleteSourceServerRequest.h>
#include <aws/drs/model/DeleteSourceServerResult.h>
#include <aws/drs/model/DescribeJobLogItemsRequest.h>
#include <aws/drs/model/DescribeJobLogItemsResult.h>
#include <aws/drs/model/DescribeJobsRequest.h>
#include <aws/drs/model/DescribeJobsRequestFilters.h>
#include <aws/drs/model/DescribeJobsResult.h>
#include <aws/drs/model/DescribeLaunchConfigurationTemplatesRequest.h>
#include <aws/drs/model/DescribeLaunchConfigurationTemplatesResult.h>
#include <aws/drs/model/DescribeRecoveryInstancesRequest.h>
#include <aws/drs/model/DescribeRecoveryInstancesRequestFilters.h>
#include <aws/drs/model/DescribeRecoveryInstancesResult.h>
#include <aws/drs/model/DescribeRecoverySnapshotsRequest.h>
#include <aws/drs/model/DescribeRecoverySnapshotsRequestFilters.h>
#include <aws/drs/model/DescribeRecoverySnapshotsResult.h>
#include <aws/drs/model/DescribeReplicationConfigurationTemplatesRequest.h>
#include <aws/drs/model/DescribeReplicationConfigurationTemplatesResult.h>
#include <aws/drs/model/DescribeSourceNetworksRequest.h>
#include <aws/drs/model/DescribeSourceNetworksRequestFilters.h>
#include <aws/drs/model/DescribeSourceNetworksResult.h>
#include <aws/drs/model/DescribeSourceServersRequest.h>
#include <aws/drs/model/DescribeSourceServersRequestFilters.h>
#include <aws/drs/model/DescribeSourceServersResult.h>
#include <aws/drs/model/DisconnectRecoveryInstanceRequest.h>
#include <aws/drs/model/DisconnectSourceServerRequest.h>
#include <aws/drs/model/DisconnectSourceServerResult.h>
#include <aws/drs/model/Disk.h>
#include <aws/drs/model/EC2InstanceState.h>
#include <aws/drs/model/EventResourceData.h>
#include <aws/drs/model/ExportSourceNetworkCfnTemplateRequest.h>
#include <aws/drs/model/ExportSourceNetworkCfnTemplateResult.h>
#include <aws/drs/model/ExtensionStatus.h>
#include <aws/drs/model/FailbackLaunchType.h>
#include <aws/drs/model/FailbackReplicationError.h>
#include <aws/drs/model/FailbackState.h>
#include <aws/drs/model/GetFailbackReplicationConfigurationRequest.h>
#include <aws/drs/model/GetFailbackReplicationConfigurationResult.h>
#include <aws/drs/model/GetLaunchConfigurationRequest.h>
#include <aws/drs/model/GetLaunchConfigurationResult.h>
#include <aws/drs/model/GetReplicationConfigurationRequest.h>
#include <aws/drs/model/GetReplicationConfigurationResult.h>
#include <aws/drs/model/IdentificationHints.h>
#include <aws/drs/model/InitializeServiceRequest.h>
#include <aws/drs/model/InitializeServiceResult.h>
#include <aws/drs/model/InitiatedBy.h>
#include <aws/drs/model/InternalServerException.h>
#include <aws/drs/model/Job.h>
#include <aws/drs/model/JobLog.h>
#include <aws/drs/model/JobLogEvent.h>
#include <aws/drs/model/JobLogEventData.h>
#include <aws/drs/model/JobStatus.h>
#include <aws/drs/model/JobType.h>
#include <aws/drs/model/LastLaunchResult.h>
#include <aws/drs/model/LastLaunchType.h>
#include <aws/drs/model/LaunchAction.h>
#include <aws/drs/model/LaunchActionCategory.h>
#include <aws/drs/model/LaunchActionParameter.h>
#include <aws/drs/model/LaunchActionParameterType.h>
#include <aws/drs/model/LaunchActionRun.h>
#include <aws/drs/model/LaunchActionRunStatus.h>
#include <aws/drs/model/LaunchActionType.h>
#include <aws/drs/model/LaunchActionsRequestFilters.h>
#include <aws/drs/model/LaunchActionsStatus.h>
#include <aws/drs/model/LaunchConfigurationTemplate.h>
#include <aws/drs/model/LaunchDisposition.h>
#include <aws/drs/model/LaunchIntoInstanceProperties.h>
#include <aws/drs/model/LaunchStatus.h>
#include <aws/drs/model/Licensing.h>
#include <aws/drs/model/LifeCycle.h>
#include <aws/drs/model/LifeCycleLastLaunch.h>
#include <aws/drs/model/LifeCycleLastLaunchInitiated.h>
#include <aws/drs/model/ListExtensibleSourceServersRequest.h>
#include <aws/drs/model/ListExtensibleSourceServersResult.h>
#include <aws/drs/model/ListLaunchActionsRequest.h>
#include <aws/drs/model/ListLaunchActionsResult.h>
#include <aws/drs/model/ListStagingAccountsRequest.h>
#include <aws/drs/model/ListStagingAccountsResult.h>
#include <aws/drs/model/ListTagsForResourceRequest.h>
#include <aws/drs/model/ListTagsForResourceResult.h>
#include <aws/drs/model/NetworkInterface.h>
#include <aws/drs/model/OS.h>
#include <aws/drs/model/OriginEnvironment.h>
#include <aws/drs/model/PITPolicyRule.h>
#include <aws/drs/model/PITPolicyRuleUnits.h>
#include <aws/drs/model/ParticipatingResource.h>
#include <aws/drs/model/ParticipatingResourceID.h>
#include <aws/drs/model/ParticipatingServer.h>
#include <aws/drs/model/ProductCode.h>
#include <aws/drs/model/ProductCodeMode.h>
#include <aws/drs/model/PutLaunchActionRequest.h>
#include <aws/drs/model/PutLaunchActionResult.h>
#include <aws/drs/model/RecoveryInstance.h>
#include <aws/drs/model/RecoveryInstanceDataReplicationError.h>
#include <aws/drs/model/RecoveryInstanceDataReplicationInfo.h>
#include <aws/drs/model/RecoveryInstanceDataReplicationInfoReplicatedDisk.h>
#include <aws/drs/model/RecoveryInstanceDataReplicationInitiation.h>
#include <aws/drs/model/RecoveryInstanceDataReplicationInitiationStep.h>
#include <aws/drs/model/RecoveryInstanceDataReplicationInitiationStepName.h>
#include <aws/drs/model/RecoveryInstanceDataReplicationInitiationStepStatus.h>
#include <aws/drs/model/RecoveryInstanceDataReplicationState.h>
#include <aws/drs/model/RecoveryInstanceDisk.h>
#include <aws/drs/model/RecoveryInstanceFailback.h>
#include <aws/drs/model/RecoveryInstanceProperties.h>
#include <aws/drs/model/RecoveryLifeCycle.h>
#include <aws/drs/model/RecoveryResult.h>
#include <aws/drs/model/RecoverySnapshot.h>
#include <aws/drs/model/RecoverySnapshotsOrder.h>
#include <aws/drs/model/ReplicationConfigurationDataPlaneRouting.h>
#include <aws/drs/model/ReplicationConfigurationDefaultLargeStagingDiskType.h>
#include <aws/drs/model/ReplicationConfigurationEbsEncryption.h>
#include <aws/drs/model/ReplicationConfigurationReplicatedDisk.h>
#include <aws/drs/model/ReplicationConfigurationReplicatedDiskStagingDiskType.h>
#include <aws/drs/model/ReplicationConfigurationTemplate.h>
#include <aws/drs/model/ReplicationDirection.h>
#include <aws/drs/model/ReplicationStatus.h>
#include <aws/drs/model/ResourceNotFoundException.h>
#include <aws/drs/model/ReverseReplicationRequest.h>
#include <aws/drs/model/ReverseReplicationResult.h>
#include <aws/drs/model/ServiceQuotaExceededException.h>
#include <aws/drs/model/SourceCloudProperties.h>
#include <aws/drs/model/SourceNetwork.h>
#include <aws/drs/model/SourceNetworkData.h>
#include <aws/drs/model/SourceProperties.h>
#include <aws/drs/model/SourceServer.h>
#include <aws/drs/model/StagingArea.h>
#include <aws/drs/model/StagingSourceServer.h>
#include <aws/drs/model/StartFailbackLaunchRequest.h>
#include <aws/drs/model/StartFailbackLaunchResult.h>
#include <aws/drs/model/StartRecoveryRequest.h>
#include <aws/drs/model/StartRecoveryRequestSourceServer.h>
#include <aws/drs/model/StartRecoveryResult.h>
#include <aws/drs/model/StartReplicationRequest.h>
#include <aws/drs/model/StartReplicationResult.h>
#include <aws/drs/model/StartSourceNetworkRecoveryRequest.h>
#include <aws/drs/model/StartSourceNetworkRecoveryRequestNetworkEntry.h>
#include <aws/drs/model/StartSourceNetworkRecoveryResult.h>
#include <aws/drs/model/StartSourceNetworkReplicationRequest.h>
#include <aws/drs/model/StartSourceNetworkReplicationResult.h>
#include <aws/drs/model/StopFailbackRequest.h>
#include <aws/drs/model/StopReplicationRequest.h>
#include <aws/drs/model/StopReplicationResult.h>
#include <aws/drs/model/StopSourceNetworkReplicationRequest.h>
#include <aws/drs/model/StopSourceNetworkReplicationResult.h>
#include <aws/drs/model/TagResourceRequest.h>
#include <aws/drs/model/TargetInstanceTypeRightSizingMethod.h>
#include <aws/drs/model/TerminateRecoveryInstancesRequest.h>
#include <aws/drs/model/TerminateRecoveryInstancesResult.h>
#include <aws/drs/model/ThrottlingException.h>
#include <aws/drs/model/UninitializedAccountException.h>
#include <aws/drs/model/UntagResourceRequest.h>
#include <aws/drs/model/UpdateFailbackReplicationConfigurationRequest.h>
#include <aws/drs/model/UpdateLaunchConfigurationRequest.h>
#include <aws/drs/model/UpdateLaunchConfigurationResult.h>
#include <aws/drs/model/UpdateLaunchConfigurationTemplateRequest.h>
#include <aws/drs/model/UpdateLaunchConfigurationTemplateResult.h>
#include <aws/drs/model/UpdateReplicationConfigurationRequest.h>
#include <aws/drs/model/UpdateReplicationConfigurationResult.h>
#include <aws/drs/model/UpdateReplicationConfigurationTemplateRequest.h>
#include <aws/drs/model/UpdateReplicationConfigurationTemplateResult.h>
#include <aws/drs/model/ValidationException.h>
#include <aws/drs/model/ValidationExceptionField.h>
#include <aws/drs/model/ValidationExceptionReason.h>
#include <aws/drs/model/VolumeStatus.h>

using DrsIncludeTest = ::testing::Test;

TEST_F(DrsIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::drs::DrsClient>("DrsIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
