/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/ds/DirectoryServiceClient.h>
#include <aws/ds/DirectoryServiceEndpointProvider.h>
#include <aws/ds/DirectoryServiceEndpointRules.h>
#include <aws/ds/DirectoryServiceErrorMarshaller.h>
#include <aws/ds/DirectoryServiceErrors.h>
#include <aws/ds/DirectoryServiceRequest.h>
#include <aws/ds/DirectoryServiceServiceClientModel.h>
#include <aws/ds/DirectoryService_EXPORTS.h>
#include <aws/ds/model/AcceptSharedDirectoryRequest.h>
#include <aws/ds/model/AcceptSharedDirectoryResult.h>
#include <aws/ds/model/AccessDeniedException.h>
#include <aws/ds/model/AddIpRoutesRequest.h>
#include <aws/ds/model/AddIpRoutesResult.h>
#include <aws/ds/model/AddRegionRequest.h>
#include <aws/ds/model/AddRegionResult.h>
#include <aws/ds/model/AddTagsToResourceRequest.h>
#include <aws/ds/model/AddTagsToResourceResult.h>
#include <aws/ds/model/Attribute.h>
#include <aws/ds/model/AuthenticationFailedException.h>
#include <aws/ds/model/CancelSchemaExtensionRequest.h>
#include <aws/ds/model/CancelSchemaExtensionResult.h>
#include <aws/ds/model/Certificate.h>
#include <aws/ds/model/CertificateAlreadyExistsException.h>
#include <aws/ds/model/CertificateDoesNotExistException.h>
#include <aws/ds/model/CertificateInUseException.h>
#include <aws/ds/model/CertificateInfo.h>
#include <aws/ds/model/CertificateLimitExceededException.h>
#include <aws/ds/model/CertificateState.h>
#include <aws/ds/model/CertificateType.h>
#include <aws/ds/model/ClientAuthenticationSettingInfo.h>
#include <aws/ds/model/ClientAuthenticationStatus.h>
#include <aws/ds/model/ClientAuthenticationType.h>
#include <aws/ds/model/ClientCertAuthSettings.h>
#include <aws/ds/model/ClientException.h>
#include <aws/ds/model/Computer.h>
#include <aws/ds/model/ConditionalForwarder.h>
#include <aws/ds/model/ConnectDirectoryRequest.h>
#include <aws/ds/model/ConnectDirectoryResult.h>
#include <aws/ds/model/CreateAliasRequest.h>
#include <aws/ds/model/CreateAliasResult.h>
#include <aws/ds/model/CreateComputerRequest.h>
#include <aws/ds/model/CreateComputerResult.h>
#include <aws/ds/model/CreateConditionalForwarderRequest.h>
#include <aws/ds/model/CreateConditionalForwarderResult.h>
#include <aws/ds/model/CreateDirectoryRequest.h>
#include <aws/ds/model/CreateDirectoryResult.h>
#include <aws/ds/model/CreateLogSubscriptionRequest.h>
#include <aws/ds/model/CreateLogSubscriptionResult.h>
#include <aws/ds/model/CreateMicrosoftADRequest.h>
#include <aws/ds/model/CreateMicrosoftADResult.h>
#include <aws/ds/model/CreateSnapshotRequest.h>
#include <aws/ds/model/CreateSnapshotResult.h>
#include <aws/ds/model/CreateTrustRequest.h>
#include <aws/ds/model/CreateTrustResult.h>
#include <aws/ds/model/DataAccessStatus.h>
#include <aws/ds/model/DeleteConditionalForwarderRequest.h>
#include <aws/ds/model/DeleteConditionalForwarderResult.h>
#include <aws/ds/model/DeleteDirectoryRequest.h>
#include <aws/ds/model/DeleteDirectoryResult.h>
#include <aws/ds/model/DeleteLogSubscriptionRequest.h>
#include <aws/ds/model/DeleteLogSubscriptionResult.h>
#include <aws/ds/model/DeleteSnapshotRequest.h>
#include <aws/ds/model/DeleteSnapshotResult.h>
#include <aws/ds/model/DeleteTrustRequest.h>
#include <aws/ds/model/DeleteTrustResult.h>
#include <aws/ds/model/DeregisterCertificateRequest.h>
#include <aws/ds/model/DeregisterCertificateResult.h>
#include <aws/ds/model/DeregisterEventTopicRequest.h>
#include <aws/ds/model/DeregisterEventTopicResult.h>
#include <aws/ds/model/DescribeCertificateRequest.h>
#include <aws/ds/model/DescribeCertificateResult.h>
#include <aws/ds/model/DescribeClientAuthenticationSettingsRequest.h>
#include <aws/ds/model/DescribeClientAuthenticationSettingsResult.h>
#include <aws/ds/model/DescribeConditionalForwardersRequest.h>
#include <aws/ds/model/DescribeConditionalForwardersResult.h>
#include <aws/ds/model/DescribeDirectoriesRequest.h>
#include <aws/ds/model/DescribeDirectoriesResult.h>
#include <aws/ds/model/DescribeDirectoryDataAccessRequest.h>
#include <aws/ds/model/DescribeDirectoryDataAccessResult.h>
#include <aws/ds/model/DescribeDomainControllersRequest.h>
#include <aws/ds/model/DescribeDomainControllersResult.h>
#include <aws/ds/model/DescribeEventTopicsRequest.h>
#include <aws/ds/model/DescribeEventTopicsResult.h>
#include <aws/ds/model/DescribeLDAPSSettingsRequest.h>
#include <aws/ds/model/DescribeLDAPSSettingsResult.h>
#include <aws/ds/model/DescribeRegionsRequest.h>
#include <aws/ds/model/DescribeRegionsResult.h>
#include <aws/ds/model/DescribeSettingsRequest.h>
#include <aws/ds/model/DescribeSettingsResult.h>
#include <aws/ds/model/DescribeSharedDirectoriesRequest.h>
#include <aws/ds/model/DescribeSharedDirectoriesResult.h>
#include <aws/ds/model/DescribeSnapshotsRequest.h>
#include <aws/ds/model/DescribeSnapshotsResult.h>
#include <aws/ds/model/DescribeTrustsRequest.h>
#include <aws/ds/model/DescribeTrustsResult.h>
#include <aws/ds/model/DescribeUpdateDirectoryRequest.h>
#include <aws/ds/model/DescribeUpdateDirectoryResult.h>
#include <aws/ds/model/DirectoryAlreadyInRegionException.h>
#include <aws/ds/model/DirectoryAlreadySharedException.h>
#include <aws/ds/model/DirectoryConfigurationStatus.h>
#include <aws/ds/model/DirectoryConnectSettings.h>
#include <aws/ds/model/DirectoryConnectSettingsDescription.h>
#include <aws/ds/model/DirectoryDescription.h>
#include <aws/ds/model/DirectoryDoesNotExistException.h>
#include <aws/ds/model/DirectoryEdition.h>
#include <aws/ds/model/DirectoryInDesiredStateException.h>
#include <aws/ds/model/DirectoryLimitExceededException.h>
#include <aws/ds/model/DirectoryLimits.h>
#include <aws/ds/model/DirectoryNotSharedException.h>
#include <aws/ds/model/DirectorySize.h>
#include <aws/ds/model/DirectoryStage.h>
#include <aws/ds/model/DirectoryType.h>
#include <aws/ds/model/DirectoryUnavailableException.h>
#include <aws/ds/model/DirectoryVpcSettings.h>
#include <aws/ds/model/DirectoryVpcSettingsDescription.h>
#include <aws/ds/model/DisableClientAuthenticationRequest.h>
#include <aws/ds/model/DisableClientAuthenticationResult.h>
#include <aws/ds/model/DisableDirectoryDataAccessRequest.h>
#include <aws/ds/model/DisableDirectoryDataAccessResult.h>
#include <aws/ds/model/DisableLDAPSRequest.h>
#include <aws/ds/model/DisableLDAPSResult.h>
#include <aws/ds/model/DisableRadiusRequest.h>
#include <aws/ds/model/DisableRadiusResult.h>
#include <aws/ds/model/DisableSsoRequest.h>
#include <aws/ds/model/DisableSsoResult.h>
#include <aws/ds/model/DomainController.h>
#include <aws/ds/model/DomainControllerLimitExceededException.h>
#include <aws/ds/model/DomainControllerStatus.h>
#include <aws/ds/model/EnableClientAuthenticationRequest.h>
#include <aws/ds/model/EnableClientAuthenticationResult.h>
#include <aws/ds/model/EnableDirectoryDataAccessRequest.h>
#include <aws/ds/model/EnableDirectoryDataAccessResult.h>
#include <aws/ds/model/EnableLDAPSRequest.h>
#include <aws/ds/model/EnableLDAPSResult.h>
#include <aws/ds/model/EnableRadiusRequest.h>
#include <aws/ds/model/EnableRadiusResult.h>
#include <aws/ds/model/EnableSsoRequest.h>
#include <aws/ds/model/EnableSsoResult.h>
#include <aws/ds/model/EntityAlreadyExistsException.h>
#include <aws/ds/model/EntityDoesNotExistException.h>
#include <aws/ds/model/EventTopic.h>
#include <aws/ds/model/GetDirectoryLimitsRequest.h>
#include <aws/ds/model/GetDirectoryLimitsResult.h>
#include <aws/ds/model/GetSnapshotLimitsRequest.h>
#include <aws/ds/model/GetSnapshotLimitsResult.h>
#include <aws/ds/model/IncompatibleSettingsException.h>
#include <aws/ds/model/InsufficientPermissionsException.h>
#include <aws/ds/model/InvalidCertificateException.h>
#include <aws/ds/model/InvalidClientAuthStatusException.h>
#include <aws/ds/model/InvalidLDAPSStatusException.h>
#include <aws/ds/model/InvalidNextTokenException.h>
#include <aws/ds/model/InvalidParameterException.h>
#include <aws/ds/model/InvalidPasswordException.h>
#include <aws/ds/model/InvalidTargetException.h>
#include <aws/ds/model/IpRoute.h>
#include <aws/ds/model/IpRouteInfo.h>
#include <aws/ds/model/IpRouteLimitExceededException.h>
#include <aws/ds/model/IpRouteStatusMsg.h>
#include <aws/ds/model/LDAPSSettingInfo.h>
#include <aws/ds/model/LDAPSStatus.h>
#include <aws/ds/model/LDAPSType.h>
#include <aws/ds/model/ListCertificatesRequest.h>
#include <aws/ds/model/ListCertificatesResult.h>
#include <aws/ds/model/ListIpRoutesRequest.h>
#include <aws/ds/model/ListIpRoutesResult.h>
#include <aws/ds/model/ListLogSubscriptionsRequest.h>
#include <aws/ds/model/ListLogSubscriptionsResult.h>
#include <aws/ds/model/ListSchemaExtensionsRequest.h>
#include <aws/ds/model/ListSchemaExtensionsResult.h>
#include <aws/ds/model/ListTagsForResourceRequest.h>
#include <aws/ds/model/ListTagsForResourceResult.h>
#include <aws/ds/model/LogSubscription.h>
#include <aws/ds/model/NoAvailableCertificateException.h>
#include <aws/ds/model/OSUpdateSettings.h>
#include <aws/ds/model/OSVersion.h>
#include <aws/ds/model/OrganizationsException.h>
#include <aws/ds/model/OwnerDirectoryDescription.h>
#include <aws/ds/model/RadiusAuthenticationProtocol.h>
#include <aws/ds/model/RadiusSettings.h>
#include <aws/ds/model/RadiusStatus.h>
#include <aws/ds/model/RegionDescription.h>
#include <aws/ds/model/RegionLimitExceededException.h>
#include <aws/ds/model/RegionType.h>
#include <aws/ds/model/RegionsInfo.h>
#include <aws/ds/model/RegisterCertificateRequest.h>
#include <aws/ds/model/RegisterCertificateResult.h>
#include <aws/ds/model/RegisterEventTopicRequest.h>
#include <aws/ds/model/RegisterEventTopicResult.h>
#include <aws/ds/model/RejectSharedDirectoryRequest.h>
#include <aws/ds/model/RejectSharedDirectoryResult.h>
#include <aws/ds/model/RemoveIpRoutesRequest.h>
#include <aws/ds/model/RemoveIpRoutesResult.h>
#include <aws/ds/model/RemoveRegionRequest.h>
#include <aws/ds/model/RemoveRegionResult.h>
#include <aws/ds/model/RemoveTagsFromResourceRequest.h>
#include <aws/ds/model/RemoveTagsFromResourceResult.h>
#include <aws/ds/model/ReplicationScope.h>
#include <aws/ds/model/ResetUserPasswordRequest.h>
#include <aws/ds/model/ResetUserPasswordResult.h>
#include <aws/ds/model/RestoreFromSnapshotRequest.h>
#include <aws/ds/model/RestoreFromSnapshotResult.h>
#include <aws/ds/model/SchemaExtensionInfo.h>
#include <aws/ds/model/SchemaExtensionStatus.h>
#include <aws/ds/model/SelectiveAuth.h>
#include <aws/ds/model/ServiceException.h>
#include <aws/ds/model/Setting.h>
#include <aws/ds/model/SettingEntry.h>
#include <aws/ds/model/ShareDirectoryRequest.h>
#include <aws/ds/model/ShareDirectoryResult.h>
#include <aws/ds/model/ShareLimitExceededException.h>
#include <aws/ds/model/ShareMethod.h>
#include <aws/ds/model/ShareStatus.h>
#include <aws/ds/model/ShareTarget.h>
#include <aws/ds/model/SharedDirectory.h>
#include <aws/ds/model/Snapshot.h>
#include <aws/ds/model/SnapshotLimitExceededException.h>
#include <aws/ds/model/SnapshotLimits.h>
#include <aws/ds/model/SnapshotStatus.h>
#include <aws/ds/model/SnapshotType.h>
#include <aws/ds/model/StartSchemaExtensionRequest.h>
#include <aws/ds/model/StartSchemaExtensionResult.h>
#include <aws/ds/model/Tag.h>
#include <aws/ds/model/TagLimitExceededException.h>
#include <aws/ds/model/TargetType.h>
#include <aws/ds/model/TopicStatus.h>
#include <aws/ds/model/Trust.h>
#include <aws/ds/model/TrustDirection.h>
#include <aws/ds/model/TrustState.h>
#include <aws/ds/model/TrustType.h>
#include <aws/ds/model/UnshareDirectoryRequest.h>
#include <aws/ds/model/UnshareDirectoryResult.h>
#include <aws/ds/model/UnshareTarget.h>
#include <aws/ds/model/UnsupportedOperationException.h>
#include <aws/ds/model/UnsupportedSettingsException.h>
#include <aws/ds/model/UpdateConditionalForwarderRequest.h>
#include <aws/ds/model/UpdateConditionalForwarderResult.h>
#include <aws/ds/model/UpdateDirectorySetupRequest.h>
#include <aws/ds/model/UpdateDirectorySetupResult.h>
#include <aws/ds/model/UpdateInfoEntry.h>
#include <aws/ds/model/UpdateNumberOfDomainControllersRequest.h>
#include <aws/ds/model/UpdateNumberOfDomainControllersResult.h>
#include <aws/ds/model/UpdateRadiusRequest.h>
#include <aws/ds/model/UpdateRadiusResult.h>
#include <aws/ds/model/UpdateSettingsRequest.h>
#include <aws/ds/model/UpdateSettingsResult.h>
#include <aws/ds/model/UpdateStatus.h>
#include <aws/ds/model/UpdateTrustRequest.h>
#include <aws/ds/model/UpdateTrustResult.h>
#include <aws/ds/model/UpdateType.h>
#include <aws/ds/model/UpdateValue.h>
#include <aws/ds/model/UserDoesNotExistException.h>
#include <aws/ds/model/VerifyTrustRequest.h>
#include <aws/ds/model/VerifyTrustResult.h>

using DirectoryServiceIncludeTest = ::testing::Test;

TEST_F(DirectoryServiceIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::DirectoryService::DirectoryServiceClient>("DirectoryServiceIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
