/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/dynamodb/DynamoDBClient.h>
#include <aws/dynamodb/DynamoDBClientConfiguration.h>
#include <aws/dynamodb/DynamoDBEndpointProvider.h>
#include <aws/dynamodb/DynamoDBEndpointRules.h>
#include <aws/dynamodb/DynamoDBErrorMarshaller.h>
#include <aws/dynamodb/DynamoDBErrors.h>
#include <aws/dynamodb/DynamoDBRequest.h>
#include <aws/dynamodb/DynamoDBServiceClientModel.h>
#include <aws/dynamodb/DynamoDB_EXPORTS.h>
#include <aws/dynamodb/model/ApproximateCreationDateTimePrecision.h>
#include <aws/dynamodb/model/ArchivalSummary.h>
#include <aws/dynamodb/model/AttributeAction.h>
#include <aws/dynamodb/model/AttributeDefinition.h>
#include <aws/dynamodb/model/AttributeValue.h>
#include <aws/dynamodb/model/AttributeValueUpdate.h>
#include <aws/dynamodb/model/AttributeValueValue.h>
#include <aws/dynamodb/model/AutoScalingPolicyDescription.h>
#include <aws/dynamodb/model/AutoScalingPolicyUpdate.h>
#include <aws/dynamodb/model/AutoScalingSettingsDescription.h>
#include <aws/dynamodb/model/AutoScalingSettingsUpdate.h>
#include <aws/dynamodb/model/AutoScalingTargetTrackingScalingPolicyConfigurationDescription.h>
#include <aws/dynamodb/model/AutoScalingTargetTrackingScalingPolicyConfigurationUpdate.h>
#include <aws/dynamodb/model/BackupDescription.h>
#include <aws/dynamodb/model/BackupDetails.h>
#include <aws/dynamodb/model/BackupStatus.h>
#include <aws/dynamodb/model/BackupSummary.h>
#include <aws/dynamodb/model/BackupType.h>
#include <aws/dynamodb/model/BackupTypeFilter.h>
#include <aws/dynamodb/model/BatchExecuteStatementRequest.h>
#include <aws/dynamodb/model/BatchExecuteStatementResult.h>
#include <aws/dynamodb/model/BatchGetItemRequest.h>
#include <aws/dynamodb/model/BatchGetItemResult.h>
#include <aws/dynamodb/model/BatchStatementError.h>
#include <aws/dynamodb/model/BatchStatementErrorCodeEnum.h>
#include <aws/dynamodb/model/BatchStatementRequest.h>
#include <aws/dynamodb/model/BatchStatementResponse.h>
#include <aws/dynamodb/model/BatchWriteItemRequest.h>
#include <aws/dynamodb/model/BatchWriteItemResult.h>
#include <aws/dynamodb/model/BillingMode.h>
#include <aws/dynamodb/model/BillingModeSummary.h>
#include <aws/dynamodb/model/CancellationReason.h>
#include <aws/dynamodb/model/Capacity.h>
#include <aws/dynamodb/model/ComparisonOperator.h>
#include <aws/dynamodb/model/Condition.h>
#include <aws/dynamodb/model/ConditionCheck.h>
#include <aws/dynamodb/model/ConditionalCheckFailedException.h>
#include <aws/dynamodb/model/ConditionalOperator.h>
#include <aws/dynamodb/model/ConsumedCapacity.h>
#include <aws/dynamodb/model/ContinuousBackupsDescription.h>
#include <aws/dynamodb/model/ContinuousBackupsStatus.h>
#include <aws/dynamodb/model/ContributorInsightsAction.h>
#include <aws/dynamodb/model/ContributorInsightsStatus.h>
#include <aws/dynamodb/model/ContributorInsightsSummary.h>
#include <aws/dynamodb/model/CreateBackupRequest.h>
#include <aws/dynamodb/model/CreateBackupResult.h>
#include <aws/dynamodb/model/CreateGlobalSecondaryIndexAction.h>
#include <aws/dynamodb/model/CreateGlobalTableRequest.h>
#include <aws/dynamodb/model/CreateGlobalTableResult.h>
#include <aws/dynamodb/model/CreateReplicaAction.h>
#include <aws/dynamodb/model/CreateReplicationGroupMemberAction.h>
#include <aws/dynamodb/model/CreateTableRequest.h>
#include <aws/dynamodb/model/CreateTableResult.h>
#include <aws/dynamodb/model/CsvOptions.h>
#include <aws/dynamodb/model/Delete.h>
#include <aws/dynamodb/model/DeleteBackupRequest.h>
#include <aws/dynamodb/model/DeleteBackupResult.h>
#include <aws/dynamodb/model/DeleteGlobalSecondaryIndexAction.h>
#include <aws/dynamodb/model/DeleteItemRequest.h>
#include <aws/dynamodb/model/DeleteItemResult.h>
#include <aws/dynamodb/model/DeleteReplicaAction.h>
#include <aws/dynamodb/model/DeleteReplicationGroupMemberAction.h>
#include <aws/dynamodb/model/DeleteRequest.h>
#include <aws/dynamodb/model/DeleteResourcePolicyRequest.h>
#include <aws/dynamodb/model/DeleteResourcePolicyResult.h>
#include <aws/dynamodb/model/DeleteTableRequest.h>
#include <aws/dynamodb/model/DeleteTableResult.h>
#include <aws/dynamodb/model/DescribeBackupRequest.h>
#include <aws/dynamodb/model/DescribeBackupResult.h>
#include <aws/dynamodb/model/DescribeContinuousBackupsRequest.h>
#include <aws/dynamodb/model/DescribeContinuousBackupsResult.h>
#include <aws/dynamodb/model/DescribeContributorInsightsRequest.h>
#include <aws/dynamodb/model/DescribeContributorInsightsResult.h>
#include <aws/dynamodb/model/DescribeEndpointsRequest.h>
#include <aws/dynamodb/model/DescribeEndpointsResult.h>
#include <aws/dynamodb/model/DescribeExportRequest.h>
#include <aws/dynamodb/model/DescribeExportResult.h>
#include <aws/dynamodb/model/DescribeGlobalTableRequest.h>
#include <aws/dynamodb/model/DescribeGlobalTableResult.h>
#include <aws/dynamodb/model/DescribeGlobalTableSettingsRequest.h>
#include <aws/dynamodb/model/DescribeGlobalTableSettingsResult.h>
#include <aws/dynamodb/model/DescribeImportRequest.h>
#include <aws/dynamodb/model/DescribeImportResult.h>
#include <aws/dynamodb/model/DescribeKinesisStreamingDestinationRequest.h>
#include <aws/dynamodb/model/DescribeKinesisStreamingDestinationResult.h>
#include <aws/dynamodb/model/DescribeLimitsRequest.h>
#include <aws/dynamodb/model/DescribeLimitsResult.h>
#include <aws/dynamodb/model/DescribeTableReplicaAutoScalingRequest.h>
#include <aws/dynamodb/model/DescribeTableReplicaAutoScalingResult.h>
#include <aws/dynamodb/model/DescribeTableRequest.h>
#include <aws/dynamodb/model/DescribeTableResult.h>
#include <aws/dynamodb/model/DescribeTimeToLiveRequest.h>
#include <aws/dynamodb/model/DescribeTimeToLiveResult.h>
#include <aws/dynamodb/model/DestinationStatus.h>
#include <aws/dynamodb/model/DisableKinesisStreamingDestinationRequest.h>
#include <aws/dynamodb/model/DisableKinesisStreamingDestinationResult.h>
#include <aws/dynamodb/model/EnableKinesisStreamingConfiguration.h>
#include <aws/dynamodb/model/EnableKinesisStreamingDestinationRequest.h>
#include <aws/dynamodb/model/EnableKinesisStreamingDestinationResult.h>
#include <aws/dynamodb/model/Endpoint.h>
#include <aws/dynamodb/model/ExecuteStatementRequest.h>
#include <aws/dynamodb/model/ExecuteStatementResult.h>
#include <aws/dynamodb/model/ExecuteTransactionRequest.h>
#include <aws/dynamodb/model/ExecuteTransactionResult.h>
#include <aws/dynamodb/model/ExpectedAttributeValue.h>
#include <aws/dynamodb/model/ExportDescription.h>
#include <aws/dynamodb/model/ExportFormat.h>
#include <aws/dynamodb/model/ExportStatus.h>
#include <aws/dynamodb/model/ExportSummary.h>
#include <aws/dynamodb/model/ExportTableToPointInTimeRequest.h>
#include <aws/dynamodb/model/ExportTableToPointInTimeResult.h>
#include <aws/dynamodb/model/ExportType.h>
#include <aws/dynamodb/model/ExportViewType.h>
#include <aws/dynamodb/model/FailureException.h>
#include <aws/dynamodb/model/Get.h>
#include <aws/dynamodb/model/GetItemRequest.h>
#include <aws/dynamodb/model/GetItemResult.h>
#include <aws/dynamodb/model/GetResourcePolicyRequest.h>
#include <aws/dynamodb/model/GetResourcePolicyResult.h>
#include <aws/dynamodb/model/GlobalSecondaryIndex.h>
#include <aws/dynamodb/model/GlobalSecondaryIndexAutoScalingUpdate.h>
#include <aws/dynamodb/model/GlobalSecondaryIndexDescription.h>
#include <aws/dynamodb/model/GlobalSecondaryIndexInfo.h>
#include <aws/dynamodb/model/GlobalSecondaryIndexUpdate.h>
#include <aws/dynamodb/model/GlobalSecondaryIndexWarmThroughputDescription.h>
#include <aws/dynamodb/model/GlobalTable.h>
#include <aws/dynamodb/model/GlobalTableDescription.h>
#include <aws/dynamodb/model/GlobalTableGlobalSecondaryIndexSettingsUpdate.h>
#include <aws/dynamodb/model/GlobalTableStatus.h>
#include <aws/dynamodb/model/ImportStatus.h>
#include <aws/dynamodb/model/ImportSummary.h>
#include <aws/dynamodb/model/ImportTableDescription.h>
#include <aws/dynamodb/model/ImportTableRequest.h>
#include <aws/dynamodb/model/ImportTableResult.h>
#include <aws/dynamodb/model/IncrementalExportSpecification.h>
#include <aws/dynamodb/model/IndexStatus.h>
#include <aws/dynamodb/model/InputCompressionType.h>
#include <aws/dynamodb/model/InputFormat.h>
#include <aws/dynamodb/model/InputFormatOptions.h>
#include <aws/dynamodb/model/ItemCollectionMetrics.h>
#include <aws/dynamodb/model/ItemResponse.h>
#include <aws/dynamodb/model/KeySchemaElement.h>
#include <aws/dynamodb/model/KeyType.h>
#include <aws/dynamodb/model/KeysAndAttributes.h>
#include <aws/dynamodb/model/KinesisDataStreamDestination.h>
#include <aws/dynamodb/model/ListBackupsRequest.h>
#include <aws/dynamodb/model/ListBackupsResult.h>
#include <aws/dynamodb/model/ListContributorInsightsRequest.h>
#include <aws/dynamodb/model/ListContributorInsightsResult.h>
#include <aws/dynamodb/model/ListExportsRequest.h>
#include <aws/dynamodb/model/ListExportsResult.h>
#include <aws/dynamodb/model/ListGlobalTablesRequest.h>
#include <aws/dynamodb/model/ListGlobalTablesResult.h>
#include <aws/dynamodb/model/ListImportsRequest.h>
#include <aws/dynamodb/model/ListImportsResult.h>
#include <aws/dynamodb/model/ListTablesRequest.h>
#include <aws/dynamodb/model/ListTablesResult.h>
#include <aws/dynamodb/model/ListTagsOfResourceRequest.h>
#include <aws/dynamodb/model/ListTagsOfResourceResult.h>
#include <aws/dynamodb/model/LocalSecondaryIndex.h>
#include <aws/dynamodb/model/LocalSecondaryIndexDescription.h>
#include <aws/dynamodb/model/LocalSecondaryIndexInfo.h>
#include <aws/dynamodb/model/MultiRegionConsistency.h>
#include <aws/dynamodb/model/OnDemandThroughput.h>
#include <aws/dynamodb/model/OnDemandThroughputOverride.h>
#include <aws/dynamodb/model/ParameterizedStatement.h>
#include <aws/dynamodb/model/PointInTimeRecoveryDescription.h>
#include <aws/dynamodb/model/PointInTimeRecoverySpecification.h>
#include <aws/dynamodb/model/PointInTimeRecoveryStatus.h>
#include <aws/dynamodb/model/Projection.h>
#include <aws/dynamodb/model/ProjectionType.h>
#include <aws/dynamodb/model/ProvisionedThroughput.h>
#include <aws/dynamodb/model/ProvisionedThroughputDescription.h>
#include <aws/dynamodb/model/ProvisionedThroughputOverride.h>
#include <aws/dynamodb/model/Put.h>
#include <aws/dynamodb/model/PutItemRequest.h>
#include <aws/dynamodb/model/PutItemResult.h>
#include <aws/dynamodb/model/PutRequest.h>
#include <aws/dynamodb/model/PutResourcePolicyRequest.h>
#include <aws/dynamodb/model/PutResourcePolicyResult.h>
#include <aws/dynamodb/model/QueryRequest.h>
#include <aws/dynamodb/model/QueryResult.h>
#include <aws/dynamodb/model/Replica.h>
#include <aws/dynamodb/model/ReplicaAutoScalingDescription.h>
#include <aws/dynamodb/model/ReplicaAutoScalingUpdate.h>
#include <aws/dynamodb/model/ReplicaDescription.h>
#include <aws/dynamodb/model/ReplicaGlobalSecondaryIndex.h>
#include <aws/dynamodb/model/ReplicaGlobalSecondaryIndexAutoScalingDescription.h>
#include <aws/dynamodb/model/ReplicaGlobalSecondaryIndexAutoScalingUpdate.h>
#include <aws/dynamodb/model/ReplicaGlobalSecondaryIndexDescription.h>
#include <aws/dynamodb/model/ReplicaGlobalSecondaryIndexSettingsDescription.h>
#include <aws/dynamodb/model/ReplicaGlobalSecondaryIndexSettingsUpdate.h>
#include <aws/dynamodb/model/ReplicaSettingsDescription.h>
#include <aws/dynamodb/model/ReplicaSettingsUpdate.h>
#include <aws/dynamodb/model/ReplicaStatus.h>
#include <aws/dynamodb/model/ReplicaUpdate.h>
#include <aws/dynamodb/model/ReplicationGroupUpdate.h>
#include <aws/dynamodb/model/RestoreSummary.h>
#include <aws/dynamodb/model/RestoreTableFromBackupRequest.h>
#include <aws/dynamodb/model/RestoreTableFromBackupResult.h>
#include <aws/dynamodb/model/RestoreTableToPointInTimeRequest.h>
#include <aws/dynamodb/model/RestoreTableToPointInTimeResult.h>
#include <aws/dynamodb/model/ReturnConsumedCapacity.h>
#include <aws/dynamodb/model/ReturnItemCollectionMetrics.h>
#include <aws/dynamodb/model/ReturnValue.h>
#include <aws/dynamodb/model/ReturnValuesOnConditionCheckFailure.h>
#include <aws/dynamodb/model/S3BucketSource.h>
#include <aws/dynamodb/model/S3SseAlgorithm.h>
#include <aws/dynamodb/model/SSEDescription.h>
#include <aws/dynamodb/model/SSESpecification.h>
#include <aws/dynamodb/model/SSEStatus.h>
#include <aws/dynamodb/model/SSEType.h>
#include <aws/dynamodb/model/ScalarAttributeType.h>
#include <aws/dynamodb/model/ScanRequest.h>
#include <aws/dynamodb/model/ScanResult.h>
#include <aws/dynamodb/model/Select.h>
#include <aws/dynamodb/model/SourceTableDetails.h>
#include <aws/dynamodb/model/SourceTableFeatureDetails.h>
#include <aws/dynamodb/model/StreamSpecification.h>
#include <aws/dynamodb/model/StreamViewType.h>
#include <aws/dynamodb/model/TableAutoScalingDescription.h>
#include <aws/dynamodb/model/TableClass.h>
#include <aws/dynamodb/model/TableClassSummary.h>
#include <aws/dynamodb/model/TableCreationParameters.h>
#include <aws/dynamodb/model/TableDescription.h>
#include <aws/dynamodb/model/TableStatus.h>
#include <aws/dynamodb/model/TableWarmThroughputDescription.h>
#include <aws/dynamodb/model/Tag.h>
#include <aws/dynamodb/model/TagResourceRequest.h>
#include <aws/dynamodb/model/TimeToLiveDescription.h>
#include <aws/dynamodb/model/TimeToLiveSpecification.h>
#include <aws/dynamodb/model/TimeToLiveStatus.h>
#include <aws/dynamodb/model/TransactGetItem.h>
#include <aws/dynamodb/model/TransactGetItemsRequest.h>
#include <aws/dynamodb/model/TransactGetItemsResult.h>
#include <aws/dynamodb/model/TransactWriteItem.h>
#include <aws/dynamodb/model/TransactWriteItemsRequest.h>
#include <aws/dynamodb/model/TransactWriteItemsResult.h>
#include <aws/dynamodb/model/TransactionCanceledException.h>
#include <aws/dynamodb/model/UntagResourceRequest.h>
#include <aws/dynamodb/model/Update.h>
#include <aws/dynamodb/model/UpdateContinuousBackupsRequest.h>
#include <aws/dynamodb/model/UpdateContinuousBackupsResult.h>
#include <aws/dynamodb/model/UpdateContributorInsightsRequest.h>
#include <aws/dynamodb/model/UpdateContributorInsightsResult.h>
#include <aws/dynamodb/model/UpdateGlobalSecondaryIndexAction.h>
#include <aws/dynamodb/model/UpdateGlobalTableRequest.h>
#include <aws/dynamodb/model/UpdateGlobalTableResult.h>
#include <aws/dynamodb/model/UpdateGlobalTableSettingsRequest.h>
#include <aws/dynamodb/model/UpdateGlobalTableSettingsResult.h>
#include <aws/dynamodb/model/UpdateItemRequest.h>
#include <aws/dynamodb/model/UpdateItemResult.h>
#include <aws/dynamodb/model/UpdateKinesisStreamingConfiguration.h>
#include <aws/dynamodb/model/UpdateKinesisStreamingDestinationRequest.h>
#include <aws/dynamodb/model/UpdateKinesisStreamingDestinationResult.h>
#include <aws/dynamodb/model/UpdateReplicationGroupMemberAction.h>
#include <aws/dynamodb/model/UpdateTableReplicaAutoScalingRequest.h>
#include <aws/dynamodb/model/UpdateTableReplicaAutoScalingResult.h>
#include <aws/dynamodb/model/UpdateTableRequest.h>
#include <aws/dynamodb/model/UpdateTableResult.h>
#include <aws/dynamodb/model/UpdateTimeToLiveRequest.h>
#include <aws/dynamodb/model/UpdateTimeToLiveResult.h>
#include <aws/dynamodb/model/WarmThroughput.h>
#include <aws/dynamodb/model/WriteRequest.h>

using DynamoDBIncludeTest = ::testing::Test;

TEST_F(DynamoDBIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::DynamoDB::DynamoDBClient>("DynamoDBIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
