/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/ec2/EC2Client.h>
#include <aws/ec2/EC2EndpointProvider.h>
#include <aws/ec2/EC2EndpointRules.h>
#include <aws/ec2/EC2ErrorMarshaller.h>
#include <aws/ec2/EC2Errors.h>
#include <aws/ec2/EC2Request.h>
#include <aws/ec2/EC2ServiceClientModel.h>
#include <aws/ec2/EC2_EXPORTS.h>
#include <aws/ec2/model/AcceleratorCount.h>
#include <aws/ec2/model/AcceleratorCountRequest.h>
#include <aws/ec2/model/AcceleratorManufacturer.h>
#include <aws/ec2/model/AcceleratorName.h>
#include <aws/ec2/model/AcceleratorTotalMemoryMiB.h>
#include <aws/ec2/model/AcceleratorTotalMemoryMiBRequest.h>
#include <aws/ec2/model/AcceleratorType.h>
#include <aws/ec2/model/AcceptAddressTransferRequest.h>
#include <aws/ec2/model/AcceptAddressTransferResponse.h>
#include <aws/ec2/model/AcceptCapacityReservationBillingOwnershipRequest.h>
#include <aws/ec2/model/AcceptCapacityReservationBillingOwnershipResponse.h>
#include <aws/ec2/model/AcceptReservedInstancesExchangeQuoteRequest.h>
#include <aws/ec2/model/AcceptReservedInstancesExchangeQuoteResponse.h>
#include <aws/ec2/model/AcceptTransitGatewayMulticastDomainAssociationsRequest.h>
#include <aws/ec2/model/AcceptTransitGatewayMulticastDomainAssociationsResponse.h>
#include <aws/ec2/model/AcceptTransitGatewayPeeringAttachmentRequest.h>
#include <aws/ec2/model/AcceptTransitGatewayPeeringAttachmentResponse.h>
#include <aws/ec2/model/AcceptTransitGatewayVpcAttachmentRequest.h>
#include <aws/ec2/model/AcceptTransitGatewayVpcAttachmentResponse.h>
#include <aws/ec2/model/AcceptVpcEndpointConnectionsRequest.h>
#include <aws/ec2/model/AcceptVpcEndpointConnectionsResponse.h>
#include <aws/ec2/model/AcceptVpcPeeringConnectionRequest.h>
#include <aws/ec2/model/AcceptVpcPeeringConnectionResponse.h>
#include <aws/ec2/model/AccessScopeAnalysisFinding.h>
#include <aws/ec2/model/AccessScopePath.h>
#include <aws/ec2/model/AccessScopePathRequest.h>
#include <aws/ec2/model/AccountAttribute.h>
#include <aws/ec2/model/AccountAttributeName.h>
#include <aws/ec2/model/AccountAttributeValue.h>
#include <aws/ec2/model/ActiveInstance.h>
#include <aws/ec2/model/ActiveVpnTunnelStatus.h>
#include <aws/ec2/model/ActivityStatus.h>
#include <aws/ec2/model/AddIpamOperatingRegion.h>
#include <aws/ec2/model/AddIpamOrganizationalUnitExclusion.h>
#include <aws/ec2/model/AddPrefixListEntry.h>
#include <aws/ec2/model/AddedPrincipal.h>
#include <aws/ec2/model/AdditionalDetail.h>
#include <aws/ec2/model/Address.h>
#include <aws/ec2/model/AddressAttribute.h>
#include <aws/ec2/model/AddressAttributeName.h>
#include <aws/ec2/model/AddressFamily.h>
#include <aws/ec2/model/AddressTransfer.h>
#include <aws/ec2/model/AddressTransferStatus.h>
#include <aws/ec2/model/AdvertiseByoipCidrRequest.h>
#include <aws/ec2/model/AdvertiseByoipCidrResponse.h>
#include <aws/ec2/model/Affinity.h>
#include <aws/ec2/model/AllocateAddressRequest.h>
#include <aws/ec2/model/AllocateAddressResponse.h>
#include <aws/ec2/model/AllocateHostsRequest.h>
#include <aws/ec2/model/AllocateHostsResponse.h>
#include <aws/ec2/model/AllocateIpamPoolCidrRequest.h>
#include <aws/ec2/model/AllocateIpamPoolCidrResponse.h>
#include <aws/ec2/model/AllocationState.h>
#include <aws/ec2/model/AllocationStrategy.h>
#include <aws/ec2/model/AllocationType.h>
#include <aws/ec2/model/AllowedImagesSettingsDisabledState.h>
#include <aws/ec2/model/AllowedImagesSettingsEnabledState.h>
#include <aws/ec2/model/AllowedPrincipal.h>
#include <aws/ec2/model/AllowsMultipleInstanceTypes.h>
#include <aws/ec2/model/AlternatePathHint.h>
#include <aws/ec2/model/AmdSevSnpSpecification.h>
#include <aws/ec2/model/AnalysisAclRule.h>
#include <aws/ec2/model/AnalysisComponent.h>
#include <aws/ec2/model/AnalysisLoadBalancerListener.h>
#include <aws/ec2/model/AnalysisLoadBalancerTarget.h>
#include <aws/ec2/model/AnalysisPacketHeader.h>
#include <aws/ec2/model/AnalysisRouteTableRoute.h>
#include <aws/ec2/model/AnalysisSecurityGroupRule.h>
#include <aws/ec2/model/AnalysisStatus.h>
#include <aws/ec2/model/ApplianceModeSupportValue.h>
#include <aws/ec2/model/ApplySecurityGroupsToClientVpnTargetNetworkRequest.h>
#include <aws/ec2/model/ApplySecurityGroupsToClientVpnTargetNetworkResponse.h>
#include <aws/ec2/model/ArchitectureType.h>
#include <aws/ec2/model/ArchitectureValues.h>
#include <aws/ec2/model/AsnAssociation.h>
#include <aws/ec2/model/AsnAssociationState.h>
#include <aws/ec2/model/AsnAuthorizationContext.h>
#include <aws/ec2/model/AsnState.h>
#include <aws/ec2/model/AssignIpv6AddressesRequest.h>
#include <aws/ec2/model/AssignIpv6AddressesResponse.h>
#include <aws/ec2/model/AssignPrivateIpAddressesRequest.h>
#include <aws/ec2/model/AssignPrivateIpAddressesResponse.h>
#include <aws/ec2/model/AssignPrivateNatGatewayAddressRequest.h>
#include <aws/ec2/model/AssignPrivateNatGatewayAddressResponse.h>
#include <aws/ec2/model/AssignedPrivateIpAddress.h>
#include <aws/ec2/model/AssociateAddressRequest.h>
#include <aws/ec2/model/AssociateAddressResponse.h>
#include <aws/ec2/model/AssociateCapacityReservationBillingOwnerRequest.h>
#include <aws/ec2/model/AssociateCapacityReservationBillingOwnerResponse.h>
#include <aws/ec2/model/AssociateClientVpnTargetNetworkRequest.h>
#include <aws/ec2/model/AssociateClientVpnTargetNetworkResponse.h>
#include <aws/ec2/model/AssociateDhcpOptionsRequest.h>
#include <aws/ec2/model/AssociateEnclaveCertificateIamRoleRequest.h>
#include <aws/ec2/model/AssociateEnclaveCertificateIamRoleResponse.h>
#include <aws/ec2/model/AssociateIamInstanceProfileRequest.h>
#include <aws/ec2/model/AssociateIamInstanceProfileResponse.h>
#include <aws/ec2/model/AssociateInstanceEventWindowRequest.h>
#include <aws/ec2/model/AssociateInstanceEventWindowResponse.h>
#include <aws/ec2/model/AssociateIpamByoasnRequest.h>
#include <aws/ec2/model/AssociateIpamByoasnResponse.h>
#include <aws/ec2/model/AssociateIpamResourceDiscoveryRequest.h>
#include <aws/ec2/model/AssociateIpamResourceDiscoveryResponse.h>
#include <aws/ec2/model/AssociateNatGatewayAddressRequest.h>
#include <aws/ec2/model/AssociateNatGatewayAddressResponse.h>
#include <aws/ec2/model/AssociateRouteServerRequest.h>
#include <aws/ec2/model/AssociateRouteServerResponse.h>
#include <aws/ec2/model/AssociateRouteTableRequest.h>
#include <aws/ec2/model/AssociateRouteTableResponse.h>
#include <aws/ec2/model/AssociateSecurityGroupVpcRequest.h>
#include <aws/ec2/model/AssociateSecurityGroupVpcResponse.h>
#include <aws/ec2/model/AssociateSubnetCidrBlockRequest.h>
#include <aws/ec2/model/AssociateSubnetCidrBlockResponse.h>
#include <aws/ec2/model/AssociateTransitGatewayMulticastDomainRequest.h>
#include <aws/ec2/model/AssociateTransitGatewayMulticastDomainResponse.h>
#include <aws/ec2/model/AssociateTransitGatewayPolicyTableRequest.h>
#include <aws/ec2/model/AssociateTransitGatewayPolicyTableResponse.h>
#include <aws/ec2/model/AssociateTransitGatewayRouteTableRequest.h>
#include <aws/ec2/model/AssociateTransitGatewayRouteTableResponse.h>
#include <aws/ec2/model/AssociateTrunkInterfaceRequest.h>
#include <aws/ec2/model/AssociateTrunkInterfaceResponse.h>
#include <aws/ec2/model/AssociateVpcCidrBlockRequest.h>
#include <aws/ec2/model/AssociateVpcCidrBlockResponse.h>
#include <aws/ec2/model/AssociatedNetworkType.h>
#include <aws/ec2/model/AssociatedRole.h>
#include <aws/ec2/model/AssociatedTargetNetwork.h>
#include <aws/ec2/model/AssociationStatus.h>
#include <aws/ec2/model/AssociationStatusCode.h>
#include <aws/ec2/model/AthenaIntegration.h>
#include <aws/ec2/model/AttachClassicLinkVpcRequest.h>
#include <aws/ec2/model/AttachClassicLinkVpcResponse.h>
#include <aws/ec2/model/AttachInternetGatewayRequest.h>
#include <aws/ec2/model/AttachNetworkInterfaceRequest.h>
#include <aws/ec2/model/AttachNetworkInterfaceResponse.h>
#include <aws/ec2/model/AttachVerifiedAccessTrustProviderRequest.h>
#include <aws/ec2/model/AttachVerifiedAccessTrustProviderResponse.h>
#include <aws/ec2/model/AttachVolumeRequest.h>
#include <aws/ec2/model/AttachVolumeResponse.h>
#include <aws/ec2/model/AttachVpnGatewayRequest.h>
#include <aws/ec2/model/AttachVpnGatewayResponse.h>
#include <aws/ec2/model/AttachmentEnaSrdSpecification.h>
#include <aws/ec2/model/AttachmentEnaSrdUdpSpecification.h>
#include <aws/ec2/model/AttachmentStatus.h>
#include <aws/ec2/model/AttributeBooleanValue.h>
#include <aws/ec2/model/AttributeSummary.h>
#include <aws/ec2/model/AttributeValue.h>
#include <aws/ec2/model/AuthorizationRule.h>
#include <aws/ec2/model/AuthorizeClientVpnIngressRequest.h>
#include <aws/ec2/model/AuthorizeClientVpnIngressResponse.h>
#include <aws/ec2/model/AuthorizeSecurityGroupEgressRequest.h>
#include <aws/ec2/model/AuthorizeSecurityGroupEgressResponse.h>
#include <aws/ec2/model/AuthorizeSecurityGroupIngressRequest.h>
#include <aws/ec2/model/AuthorizeSecurityGroupIngressResponse.h>
#include <aws/ec2/model/AutoAcceptSharedAssociationsValue.h>
#include <aws/ec2/model/AutoAcceptSharedAttachmentsValue.h>
#include <aws/ec2/model/AutoPlacement.h>
#include <aws/ec2/model/AvailabilityZone.h>
#include <aws/ec2/model/AvailabilityZoneMessage.h>
#include <aws/ec2/model/AvailabilityZoneOptInStatus.h>
#include <aws/ec2/model/AvailabilityZoneState.h>
#include <aws/ec2/model/AvailableCapacity.h>
#include <aws/ec2/model/BandwidthWeightingType.h>
#include <aws/ec2/model/BareMetal.h>
#include <aws/ec2/model/BaselineEbsBandwidthMbps.h>
#include <aws/ec2/model/BaselineEbsBandwidthMbpsRequest.h>
#include <aws/ec2/model/BaselinePerformanceFactors.h>
#include <aws/ec2/model/BaselinePerformanceFactorsRequest.h>
#include <aws/ec2/model/BatchState.h>
#include <aws/ec2/model/BgpStatus.h>
#include <aws/ec2/model/BlobAttributeValue.h>
#include <aws/ec2/model/BlockDeviceMapping.h>
#include <aws/ec2/model/BlockDeviceMappingResponse.h>
#include <aws/ec2/model/BlockPublicAccessMode.h>
#include <aws/ec2/model/BlockPublicAccessStates.h>
#include <aws/ec2/model/BootModeType.h>
#include <aws/ec2/model/BootModeValues.h>
#include <aws/ec2/model/BundleInstanceRequest.h>
#include <aws/ec2/model/BundleInstanceResponse.h>
#include <aws/ec2/model/BundleTask.h>
#include <aws/ec2/model/BundleTaskError.h>
#include <aws/ec2/model/BundleTaskState.h>
#include <aws/ec2/model/BurstablePerformance.h>
#include <aws/ec2/model/Byoasn.h>
#include <aws/ec2/model/ByoipCidr.h>
#include <aws/ec2/model/ByoipCidrState.h>
#include <aws/ec2/model/CallerRole.h>
#include <aws/ec2/model/CancelBatchErrorCode.h>
#include <aws/ec2/model/CancelBundleTaskRequest.h>
#include <aws/ec2/model/CancelBundleTaskResponse.h>
#include <aws/ec2/model/CancelCapacityReservationFleetError.h>
#include <aws/ec2/model/CancelCapacityReservationFleetsRequest.h>
#include <aws/ec2/model/CancelCapacityReservationFleetsResponse.h>
#include <aws/ec2/model/CancelCapacityReservationRequest.h>
#include <aws/ec2/model/CancelCapacityReservationResponse.h>
#include <aws/ec2/model/CancelConversionTaskRequest.h>
#include <aws/ec2/model/CancelDeclarativePoliciesReportRequest.h>
#include <aws/ec2/model/CancelDeclarativePoliciesReportResponse.h>
#include <aws/ec2/model/CancelExportTaskRequest.h>
#include <aws/ec2/model/CancelImageLaunchPermissionRequest.h>
#include <aws/ec2/model/CancelImageLaunchPermissionResponse.h>
#include <aws/ec2/model/CancelImportTaskRequest.h>
#include <aws/ec2/model/CancelImportTaskResponse.h>
#include <aws/ec2/model/CancelReservedInstancesListingRequest.h>
#include <aws/ec2/model/CancelReservedInstancesListingResponse.h>
#include <aws/ec2/model/CancelSpotFleetRequestsError.h>
#include <aws/ec2/model/CancelSpotFleetRequestsErrorItem.h>
#include <aws/ec2/model/CancelSpotFleetRequestsRequest.h>
#include <aws/ec2/model/CancelSpotFleetRequestsResponse.h>
#include <aws/ec2/model/CancelSpotFleetRequestsSuccessItem.h>
#include <aws/ec2/model/CancelSpotInstanceRequestState.h>
#include <aws/ec2/model/CancelSpotInstanceRequestsRequest.h>
#include <aws/ec2/model/CancelSpotInstanceRequestsResponse.h>
#include <aws/ec2/model/CancelledSpotInstanceRequest.h>
#include <aws/ec2/model/CapacityAllocation.h>
#include <aws/ec2/model/CapacityBlockExtension.h>
#include <aws/ec2/model/CapacityBlockExtensionOffering.h>
#include <aws/ec2/model/CapacityBlockExtensionStatus.h>
#include <aws/ec2/model/CapacityBlockOffering.h>
#include <aws/ec2/model/CapacityReservation.h>
#include <aws/ec2/model/CapacityReservationBillingRequest.h>
#include <aws/ec2/model/CapacityReservationBillingRequestStatus.h>
#include <aws/ec2/model/CapacityReservationCommitmentInfo.h>
#include <aws/ec2/model/CapacityReservationDeliveryPreference.h>
#include <aws/ec2/model/CapacityReservationFleet.h>
#include <aws/ec2/model/CapacityReservationFleetCancellationState.h>
#include <aws/ec2/model/CapacityReservationFleetState.h>
#include <aws/ec2/model/CapacityReservationGroup.h>
#include <aws/ec2/model/CapacityReservationInfo.h>
#include <aws/ec2/model/CapacityReservationInstancePlatform.h>
#include <aws/ec2/model/CapacityReservationOptions.h>
#include <aws/ec2/model/CapacityReservationOptionsRequest.h>
#include <aws/ec2/model/CapacityReservationPreference.h>
#include <aws/ec2/model/CapacityReservationSpecification.h>
#include <aws/ec2/model/CapacityReservationSpecificationResponse.h>
#include <aws/ec2/model/CapacityReservationState.h>
#include <aws/ec2/model/CapacityReservationTarget.h>
#include <aws/ec2/model/CapacityReservationTargetResponse.h>
#include <aws/ec2/model/CapacityReservationTenancy.h>
#include <aws/ec2/model/CapacityReservationType.h>
#include <aws/ec2/model/CarrierGateway.h>
#include <aws/ec2/model/CarrierGatewayState.h>
#include <aws/ec2/model/CertificateAuthentication.h>
#include <aws/ec2/model/CertificateAuthenticationRequest.h>
#include <aws/ec2/model/CidrAuthorizationContext.h>
#include <aws/ec2/model/CidrBlock.h>
#include <aws/ec2/model/ClassicLinkDnsSupport.h>
#include <aws/ec2/model/ClassicLinkInstance.h>
#include <aws/ec2/model/ClassicLoadBalancer.h>
#include <aws/ec2/model/ClassicLoadBalancersConfig.h>
#include <aws/ec2/model/ClientCertificateRevocationListStatus.h>
#include <aws/ec2/model/ClientCertificateRevocationListStatusCode.h>
#include <aws/ec2/model/ClientConnectOptions.h>
#include <aws/ec2/model/ClientConnectResponseOptions.h>
#include <aws/ec2/model/ClientData.h>
#include <aws/ec2/model/ClientLoginBannerOptions.h>
#include <aws/ec2/model/ClientLoginBannerResponseOptions.h>
#include <aws/ec2/model/ClientRouteEnforcementOptions.h>
#include <aws/ec2/model/ClientRouteEnforcementResponseOptions.h>
#include <aws/ec2/model/ClientVpnAuthentication.h>
#include <aws/ec2/model/ClientVpnAuthenticationRequest.h>
#include <aws/ec2/model/ClientVpnAuthenticationType.h>
#include <aws/ec2/model/ClientVpnAuthorizationRuleStatus.h>
#include <aws/ec2/model/ClientVpnAuthorizationRuleStatusCode.h>
#include <aws/ec2/model/ClientVpnConnection.h>
#include <aws/ec2/model/ClientVpnConnectionStatus.h>
#include <aws/ec2/model/ClientVpnConnectionStatusCode.h>
#include <aws/ec2/model/ClientVpnEndpoint.h>
#include <aws/ec2/model/ClientVpnEndpointAttributeStatus.h>
#include <aws/ec2/model/ClientVpnEndpointAttributeStatusCode.h>
#include <aws/ec2/model/ClientVpnEndpointStatus.h>
#include <aws/ec2/model/ClientVpnEndpointStatusCode.h>
#include <aws/ec2/model/ClientVpnRoute.h>
#include <aws/ec2/model/ClientVpnRouteStatus.h>
#include <aws/ec2/model/ClientVpnRouteStatusCode.h>
#include <aws/ec2/model/CloudWatchLogOptions.h>
#include <aws/ec2/model/CloudWatchLogOptionsSpecification.h>
#include <aws/ec2/model/CoipAddressUsage.h>
#include <aws/ec2/model/CoipCidr.h>
#include <aws/ec2/model/CoipPool.h>
#include <aws/ec2/model/ConfirmProductInstanceRequest.h>
#include <aws/ec2/model/ConfirmProductInstanceResponse.h>
#include <aws/ec2/model/ConnectionLogOptions.h>
#include <aws/ec2/model/ConnectionLogResponseOptions.h>
#include <aws/ec2/model/ConnectionNotification.h>
#include <aws/ec2/model/ConnectionNotificationState.h>
#include <aws/ec2/model/ConnectionNotificationType.h>
#include <aws/ec2/model/ConnectionTrackingConfiguration.h>
#include <aws/ec2/model/ConnectionTrackingSpecification.h>
#include <aws/ec2/model/ConnectionTrackingSpecificationRequest.h>
#include <aws/ec2/model/ConnectionTrackingSpecificationResponse.h>
#include <aws/ec2/model/ConnectivityType.h>
#include <aws/ec2/model/ContainerFormat.h>
#include <aws/ec2/model/ConversionTask.h>
#include <aws/ec2/model/ConversionTaskState.h>
#include <aws/ec2/model/CopyFpgaImageRequest.h>
#include <aws/ec2/model/CopyFpgaImageResponse.h>
#include <aws/ec2/model/CopyImageRequest.h>
#include <aws/ec2/model/CopyImageResponse.h>
#include <aws/ec2/model/CopySnapshotRequest.h>
#include <aws/ec2/model/CopySnapshotResponse.h>
#include <aws/ec2/model/CopyTagsFromSource.h>
#include <aws/ec2/model/CpuManufacturer.h>
#include <aws/ec2/model/CpuOptions.h>
#include <aws/ec2/model/CpuOptionsRequest.h>
#include <aws/ec2/model/CpuPerformanceFactor.h>
#include <aws/ec2/model/CpuPerformanceFactorRequest.h>
#include <aws/ec2/model/CreateCapacityReservationBySplittingRequest.h>
#include <aws/ec2/model/CreateCapacityReservationBySplittingResponse.h>
#include <aws/ec2/model/CreateCapacityReservationFleetRequest.h>
#include <aws/ec2/model/CreateCapacityReservationFleetResponse.h>
#include <aws/ec2/model/CreateCapacityReservationRequest.h>
#include <aws/ec2/model/CreateCapacityReservationResponse.h>
#include <aws/ec2/model/CreateCarrierGatewayRequest.h>
#include <aws/ec2/model/CreateCarrierGatewayResponse.h>
#include <aws/ec2/model/CreateClientVpnEndpointRequest.h>
#include <aws/ec2/model/CreateClientVpnEndpointResponse.h>
#include <aws/ec2/model/CreateClientVpnRouteRequest.h>
#include <aws/ec2/model/CreateClientVpnRouteResponse.h>
#include <aws/ec2/model/CreateCoipCidrRequest.h>
#include <aws/ec2/model/CreateCoipCidrResponse.h>
#include <aws/ec2/model/CreateCoipPoolRequest.h>
#include <aws/ec2/model/CreateCoipPoolResponse.h>
#include <aws/ec2/model/CreateCustomerGatewayRequest.h>
#include <aws/ec2/model/CreateCustomerGatewayResponse.h>
#include <aws/ec2/model/CreateDefaultSubnetRequest.h>
#include <aws/ec2/model/CreateDefaultSubnetResponse.h>
#include <aws/ec2/model/CreateDefaultVpcRequest.h>
#include <aws/ec2/model/CreateDefaultVpcResponse.h>
#include <aws/ec2/model/CreateDelegateMacVolumeOwnershipTaskRequest.h>
#include <aws/ec2/model/CreateDelegateMacVolumeOwnershipTaskResponse.h>
#include <aws/ec2/model/CreateDhcpOptionsRequest.h>
#include <aws/ec2/model/CreateDhcpOptionsResponse.h>
#include <aws/ec2/model/CreateEgressOnlyInternetGatewayRequest.h>
#include <aws/ec2/model/CreateEgressOnlyInternetGatewayResponse.h>
#include <aws/ec2/model/CreateFleetError.h>
#include <aws/ec2/model/CreateFleetInstance.h>
#include <aws/ec2/model/CreateFleetRequest.h>
#include <aws/ec2/model/CreateFleetResponse.h>
#include <aws/ec2/model/CreateFlowLogsRequest.h>
#include <aws/ec2/model/CreateFlowLogsResponse.h>
#include <aws/ec2/model/CreateFpgaImageRequest.h>
#include <aws/ec2/model/CreateFpgaImageResponse.h>
#include <aws/ec2/model/CreateImageRequest.h>
#include <aws/ec2/model/CreateImageResponse.h>
#include <aws/ec2/model/CreateInstanceConnectEndpointRequest.h>
#include <aws/ec2/model/CreateInstanceConnectEndpointResponse.h>
#include <aws/ec2/model/CreateInstanceEventWindowRequest.h>
#include <aws/ec2/model/CreateInstanceEventWindowResponse.h>
#include <aws/ec2/model/CreateInstanceExportTaskRequest.h>
#include <aws/ec2/model/CreateInstanceExportTaskResponse.h>
#include <aws/ec2/model/CreateInternetGatewayRequest.h>
#include <aws/ec2/model/CreateInternetGatewayResponse.h>
#include <aws/ec2/model/CreateIpamExternalResourceVerificationTokenRequest.h>
#include <aws/ec2/model/CreateIpamExternalResourceVerificationTokenResponse.h>
#include <aws/ec2/model/CreateIpamPoolRequest.h>
#include <aws/ec2/model/CreateIpamPoolResponse.h>
#include <aws/ec2/model/CreateIpamRequest.h>
#include <aws/ec2/model/CreateIpamResourceDiscoveryRequest.h>
#include <aws/ec2/model/CreateIpamResourceDiscoveryResponse.h>
#include <aws/ec2/model/CreateIpamResponse.h>
#include <aws/ec2/model/CreateIpamScopeRequest.h>
#include <aws/ec2/model/CreateIpamScopeResponse.h>
#include <aws/ec2/model/CreateKeyPairRequest.h>
#include <aws/ec2/model/CreateKeyPairResponse.h>
#include <aws/ec2/model/CreateLaunchTemplateRequest.h>
#include <aws/ec2/model/CreateLaunchTemplateResponse.h>
#include <aws/ec2/model/CreateLaunchTemplateVersionRequest.h>
#include <aws/ec2/model/CreateLaunchTemplateVersionResponse.h>
#include <aws/ec2/model/CreateLocalGatewayRouteRequest.h>
#include <aws/ec2/model/CreateLocalGatewayRouteResponse.h>
#include <aws/ec2/model/CreateLocalGatewayRouteTableRequest.h>
#include <aws/ec2/model/CreateLocalGatewayRouteTableResponse.h>
#include <aws/ec2/model/CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest.h>
#include <aws/ec2/model/CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse.h>
#include <aws/ec2/model/CreateLocalGatewayRouteTableVpcAssociationRequest.h>
#include <aws/ec2/model/CreateLocalGatewayRouteTableVpcAssociationResponse.h>
#include <aws/ec2/model/CreateLocalGatewayVirtualInterfaceGroupRequest.h>
#include <aws/ec2/model/CreateLocalGatewayVirtualInterfaceGroupResponse.h>
#include <aws/ec2/model/CreateLocalGatewayVirtualInterfaceRequest.h>
#include <aws/ec2/model/CreateLocalGatewayVirtualInterfaceResponse.h>
#include <aws/ec2/model/CreateMacSystemIntegrityProtectionModificationTaskRequest.h>
#include <aws/ec2/model/CreateMacSystemIntegrityProtectionModificationTaskResponse.h>
#include <aws/ec2/model/CreateManagedPrefixListRequest.h>
#include <aws/ec2/model/CreateManagedPrefixListResponse.h>
#include <aws/ec2/model/CreateNatGatewayRequest.h>
#include <aws/ec2/model/CreateNatGatewayResponse.h>
#include <aws/ec2/model/CreateNetworkAclEntryRequest.h>
#include <aws/ec2/model/CreateNetworkAclRequest.h>
#include <aws/ec2/model/CreateNetworkAclResponse.h>
#include <aws/ec2/model/CreateNetworkInsightsAccessScopeRequest.h>
#include <aws/ec2/model/CreateNetworkInsightsAccessScopeResponse.h>
#include <aws/ec2/model/CreateNetworkInsightsPathRequest.h>
#include <aws/ec2/model/CreateNetworkInsightsPathResponse.h>
#include <aws/ec2/model/CreateNetworkInterfacePermissionRequest.h>
#include <aws/ec2/model/CreateNetworkInterfacePermissionResponse.h>
#include <aws/ec2/model/CreateNetworkInterfaceRequest.h>
#include <aws/ec2/model/CreateNetworkInterfaceResponse.h>
#include <aws/ec2/model/CreatePlacementGroupRequest.h>
#include <aws/ec2/model/CreatePlacementGroupResponse.h>
#include <aws/ec2/model/CreatePublicIpv4PoolRequest.h>
#include <aws/ec2/model/CreatePublicIpv4PoolResponse.h>
#include <aws/ec2/model/CreateReplaceRootVolumeTaskRequest.h>
#include <aws/ec2/model/CreateReplaceRootVolumeTaskResponse.h>
#include <aws/ec2/model/CreateReservedInstancesListingRequest.h>
#include <aws/ec2/model/CreateReservedInstancesListingResponse.h>
#include <aws/ec2/model/CreateRestoreImageTaskRequest.h>
#include <aws/ec2/model/CreateRestoreImageTaskResponse.h>
#include <aws/ec2/model/CreateRouteRequest.h>
#include <aws/ec2/model/CreateRouteResponse.h>
#include <aws/ec2/model/CreateRouteServerEndpointRequest.h>
#include <aws/ec2/model/CreateRouteServerEndpointResponse.h>
#include <aws/ec2/model/CreateRouteServerPeerRequest.h>
#include <aws/ec2/model/CreateRouteServerPeerResponse.h>
#include <aws/ec2/model/CreateRouteServerRequest.h>
#include <aws/ec2/model/CreateRouteServerResponse.h>
#include <aws/ec2/model/CreateRouteTableRequest.h>
#include <aws/ec2/model/CreateRouteTableResponse.h>
#include <aws/ec2/model/CreateSecurityGroupRequest.h>
#include <aws/ec2/model/CreateSecurityGroupResponse.h>
#include <aws/ec2/model/CreateSnapshotRequest.h>
#include <aws/ec2/model/CreateSnapshotResponse.h>
#include <aws/ec2/model/CreateSnapshotsRequest.h>
#include <aws/ec2/model/CreateSnapshotsResponse.h>
#include <aws/ec2/model/CreateSpotDatafeedSubscriptionRequest.h>
#include <aws/ec2/model/CreateSpotDatafeedSubscriptionResponse.h>
#include <aws/ec2/model/CreateStoreImageTaskRequest.h>
#include <aws/ec2/model/CreateStoreImageTaskResponse.h>
#include <aws/ec2/model/CreateSubnetCidrReservationRequest.h>
#include <aws/ec2/model/CreateSubnetCidrReservationResponse.h>
#include <aws/ec2/model/CreateSubnetRequest.h>
#include <aws/ec2/model/CreateSubnetResponse.h>
#include <aws/ec2/model/CreateTagsRequest.h>
#include <aws/ec2/model/CreateTrafficMirrorFilterRequest.h>
#include <aws/ec2/model/CreateTrafficMirrorFilterResponse.h>
#include <aws/ec2/model/CreateTrafficMirrorFilterRuleRequest.h>
#include <aws/ec2/model/CreateTrafficMirrorFilterRuleResponse.h>
#include <aws/ec2/model/CreateTrafficMirrorSessionRequest.h>
#include <aws/ec2/model/CreateTrafficMirrorSessionResponse.h>
#include <aws/ec2/model/CreateTrafficMirrorTargetRequest.h>
#include <aws/ec2/model/CreateTrafficMirrorTargetResponse.h>
#include <aws/ec2/model/CreateTransitGatewayConnectPeerRequest.h>
#include <aws/ec2/model/CreateTransitGatewayConnectPeerResponse.h>
#include <aws/ec2/model/CreateTransitGatewayConnectRequest.h>
#include <aws/ec2/model/CreateTransitGatewayConnectRequestOptions.h>
#include <aws/ec2/model/CreateTransitGatewayConnectResponse.h>
#include <aws/ec2/model/CreateTransitGatewayMulticastDomainRequest.h>
#include <aws/ec2/model/CreateTransitGatewayMulticastDomainRequestOptions.h>
#include <aws/ec2/model/CreateTransitGatewayMulticastDomainResponse.h>
#include <aws/ec2/model/CreateTransitGatewayPeeringAttachmentRequest.h>
#include <aws/ec2/model/CreateTransitGatewayPeeringAttachmentRequestOptions.h>
#include <aws/ec2/model/CreateTransitGatewayPeeringAttachmentResponse.h>
#include <aws/ec2/model/CreateTransitGatewayPolicyTableRequest.h>
#include <aws/ec2/model/CreateTransitGatewayPolicyTableResponse.h>
#include <aws/ec2/model/CreateTransitGatewayPrefixListReferenceRequest.h>
#include <aws/ec2/model/CreateTransitGatewayPrefixListReferenceResponse.h>
#include <aws/ec2/model/CreateTransitGatewayRequest.h>
#include <aws/ec2/model/CreateTransitGatewayResponse.h>
#include <aws/ec2/model/CreateTransitGatewayRouteRequest.h>
#include <aws/ec2/model/CreateTransitGatewayRouteResponse.h>
#include <aws/ec2/model/CreateTransitGatewayRouteTableAnnouncementRequest.h>
#include <aws/ec2/model/CreateTransitGatewayRouteTableAnnouncementResponse.h>
#include <aws/ec2/model/CreateTransitGatewayRouteTableRequest.h>
#include <aws/ec2/model/CreateTransitGatewayRouteTableResponse.h>
#include <aws/ec2/model/CreateTransitGatewayVpcAttachmentRequest.h>
#include <aws/ec2/model/CreateTransitGatewayVpcAttachmentRequestOptions.h>
#include <aws/ec2/model/CreateTransitGatewayVpcAttachmentResponse.h>
#include <aws/ec2/model/CreateVerifiedAccessEndpointCidrOptions.h>
#include <aws/ec2/model/CreateVerifiedAccessEndpointEniOptions.h>
#include <aws/ec2/model/CreateVerifiedAccessEndpointLoadBalancerOptions.h>
#include <aws/ec2/model/CreateVerifiedAccessEndpointPortRange.h>
#include <aws/ec2/model/CreateVerifiedAccessEndpointRdsOptions.h>
#include <aws/ec2/model/CreateVerifiedAccessEndpointRequest.h>
#include <aws/ec2/model/CreateVerifiedAccessEndpointResponse.h>
#include <aws/ec2/model/CreateVerifiedAccessGroupRequest.h>
#include <aws/ec2/model/CreateVerifiedAccessGroupResponse.h>
#include <aws/ec2/model/CreateVerifiedAccessInstanceRequest.h>
#include <aws/ec2/model/CreateVerifiedAccessInstanceResponse.h>
#include <aws/ec2/model/CreateVerifiedAccessNativeApplicationOidcOptions.h>
#include <aws/ec2/model/CreateVerifiedAccessTrustProviderDeviceOptions.h>
#include <aws/ec2/model/CreateVerifiedAccessTrustProviderOidcOptions.h>
#include <aws/ec2/model/CreateVerifiedAccessTrustProviderRequest.h>
#include <aws/ec2/model/CreateVerifiedAccessTrustProviderResponse.h>
#include <aws/ec2/model/CreateVolumePermission.h>
#include <aws/ec2/model/CreateVolumePermissionModifications.h>
#include <aws/ec2/model/CreateVolumeRequest.h>
#include <aws/ec2/model/CreateVolumeResponse.h>
#include <aws/ec2/model/CreateVpcBlockPublicAccessExclusionRequest.h>
#include <aws/ec2/model/CreateVpcBlockPublicAccessExclusionResponse.h>
#include <aws/ec2/model/CreateVpcEndpointConnectionNotificationRequest.h>
#include <aws/ec2/model/CreateVpcEndpointConnectionNotificationResponse.h>
#include <aws/ec2/model/CreateVpcEndpointRequest.h>
#include <aws/ec2/model/CreateVpcEndpointResponse.h>
#include <aws/ec2/model/CreateVpcEndpointServiceConfigurationRequest.h>
#include <aws/ec2/model/CreateVpcEndpointServiceConfigurationResponse.h>
#include <aws/ec2/model/CreateVpcPeeringConnectionRequest.h>
#include <aws/ec2/model/CreateVpcPeeringConnectionResponse.h>
#include <aws/ec2/model/CreateVpcRequest.h>
#include <aws/ec2/model/CreateVpcResponse.h>
#include <aws/ec2/model/CreateVpnConnectionRequest.h>
#include <aws/ec2/model/CreateVpnConnectionResponse.h>
#include <aws/ec2/model/CreateVpnConnectionRouteRequest.h>
#include <aws/ec2/model/CreateVpnGatewayRequest.h>
#include <aws/ec2/model/CreateVpnGatewayResponse.h>
#include <aws/ec2/model/CreditSpecification.h>
#include <aws/ec2/model/CreditSpecificationRequest.h>
#include <aws/ec2/model/CurrencyCodeValues.h>
#include <aws/ec2/model/CustomerGateway.h>
#include <aws/ec2/model/DataQuery.h>
#include <aws/ec2/model/DataResponse.h>
#include <aws/ec2/model/DatafeedSubscriptionState.h>
#include <aws/ec2/model/DeclarativePoliciesReport.h>
#include <aws/ec2/model/DefaultInstanceMetadataEndpointState.h>
#include <aws/ec2/model/DefaultInstanceMetadataTagsState.h>
#include <aws/ec2/model/DefaultRouteTableAssociationValue.h>
#include <aws/ec2/model/DefaultRouteTablePropagationValue.h>
#include <aws/ec2/model/DefaultTargetCapacityType.h>
#include <aws/ec2/model/DeleteCarrierGatewayRequest.h>
#include <aws/ec2/model/DeleteCarrierGatewayResponse.h>
#include <aws/ec2/model/DeleteClientVpnEndpointRequest.h>
#include <aws/ec2/model/DeleteClientVpnEndpointResponse.h>
#include <aws/ec2/model/DeleteClientVpnRouteRequest.h>
#include <aws/ec2/model/DeleteClientVpnRouteResponse.h>
#include <aws/ec2/model/DeleteCoipCidrRequest.h>
#include <aws/ec2/model/DeleteCoipCidrResponse.h>
#include <aws/ec2/model/DeleteCoipPoolRequest.h>
#include <aws/ec2/model/DeleteCoipPoolResponse.h>
#include <aws/ec2/model/DeleteCustomerGatewayRequest.h>
#include <aws/ec2/model/DeleteDhcpOptionsRequest.h>
#include <aws/ec2/model/DeleteEgressOnlyInternetGatewayRequest.h>
#include <aws/ec2/model/DeleteEgressOnlyInternetGatewayResponse.h>
#include <aws/ec2/model/DeleteFleetError.h>
#include <aws/ec2/model/DeleteFleetErrorCode.h>
#include <aws/ec2/model/DeleteFleetErrorItem.h>
#include <aws/ec2/model/DeleteFleetSuccessItem.h>
#include <aws/ec2/model/DeleteFleetsRequest.h>
#include <aws/ec2/model/DeleteFleetsResponse.h>
#include <aws/ec2/model/DeleteFlowLogsRequest.h>
#include <aws/ec2/model/DeleteFlowLogsResponse.h>
#include <aws/ec2/model/DeleteFpgaImageRequest.h>
#include <aws/ec2/model/DeleteFpgaImageResponse.h>
#include <aws/ec2/model/DeleteInstanceConnectEndpointRequest.h>
#include <aws/ec2/model/DeleteInstanceConnectEndpointResponse.h>
#include <aws/ec2/model/DeleteInstanceEventWindowRequest.h>
#include <aws/ec2/model/DeleteInstanceEventWindowResponse.h>
#include <aws/ec2/model/DeleteInternetGatewayRequest.h>
#include <aws/ec2/model/DeleteIpamExternalResourceVerificationTokenRequest.h>
#include <aws/ec2/model/DeleteIpamExternalResourceVerificationTokenResponse.h>
#include <aws/ec2/model/DeleteIpamPoolRequest.h>
#include <aws/ec2/model/DeleteIpamPoolResponse.h>
#include <aws/ec2/model/DeleteIpamRequest.h>
#include <aws/ec2/model/DeleteIpamResourceDiscoveryRequest.h>
#include <aws/ec2/model/DeleteIpamResourceDiscoveryResponse.h>
#include <aws/ec2/model/DeleteIpamResponse.h>
#include <aws/ec2/model/DeleteIpamScopeRequest.h>
#include <aws/ec2/model/DeleteIpamScopeResponse.h>
#include <aws/ec2/model/DeleteKeyPairRequest.h>
#include <aws/ec2/model/DeleteKeyPairResponse.h>
#include <aws/ec2/model/DeleteLaunchTemplateRequest.h>
#include <aws/ec2/model/DeleteLaunchTemplateResponse.h>
#include <aws/ec2/model/DeleteLaunchTemplateVersionsRequest.h>
#include <aws/ec2/model/DeleteLaunchTemplateVersionsResponse.h>
#include <aws/ec2/model/DeleteLaunchTemplateVersionsResponseErrorItem.h>
#include <aws/ec2/model/DeleteLaunchTemplateVersionsResponseSuccessItem.h>
#include <aws/ec2/model/DeleteLocalGatewayRouteRequest.h>
#include <aws/ec2/model/DeleteLocalGatewayRouteResponse.h>
#include <aws/ec2/model/DeleteLocalGatewayRouteTableRequest.h>
#include <aws/ec2/model/DeleteLocalGatewayRouteTableResponse.h>
#include <aws/ec2/model/DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest.h>
#include <aws/ec2/model/DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse.h>
#include <aws/ec2/model/DeleteLocalGatewayRouteTableVpcAssociationRequest.h>
#include <aws/ec2/model/DeleteLocalGatewayRouteTableVpcAssociationResponse.h>
#include <aws/ec2/model/DeleteLocalGatewayVirtualInterfaceGroupRequest.h>
#include <aws/ec2/model/DeleteLocalGatewayVirtualInterfaceGroupResponse.h>
#include <aws/ec2/model/DeleteLocalGatewayVirtualInterfaceRequest.h>
#include <aws/ec2/model/DeleteLocalGatewayVirtualInterfaceResponse.h>
#include <aws/ec2/model/DeleteManagedPrefixListRequest.h>
#include <aws/ec2/model/DeleteManagedPrefixListResponse.h>
#include <aws/ec2/model/DeleteNatGatewayRequest.h>
#include <aws/ec2/model/DeleteNatGatewayResponse.h>
#include <aws/ec2/model/DeleteNetworkAclEntryRequest.h>
#include <aws/ec2/model/DeleteNetworkAclRequest.h>
#include <aws/ec2/model/DeleteNetworkInsightsAccessScopeAnalysisRequest.h>
#include <aws/ec2/model/DeleteNetworkInsightsAccessScopeAnalysisResponse.h>
#include <aws/ec2/model/DeleteNetworkInsightsAccessScopeRequest.h>
#include <aws/ec2/model/DeleteNetworkInsightsAccessScopeResponse.h>
#include <aws/ec2/model/DeleteNetworkInsightsAnalysisRequest.h>
#include <aws/ec2/model/DeleteNetworkInsightsAnalysisResponse.h>
#include <aws/ec2/model/DeleteNetworkInsightsPathRequest.h>
#include <aws/ec2/model/DeleteNetworkInsightsPathResponse.h>
#include <aws/ec2/model/DeleteNetworkInterfacePermissionRequest.h>
#include <aws/ec2/model/DeleteNetworkInterfacePermissionResponse.h>
#include <aws/ec2/model/DeleteNetworkInterfaceRequest.h>
#include <aws/ec2/model/DeletePlacementGroupRequest.h>
#include <aws/ec2/model/DeletePublicIpv4PoolRequest.h>
#include <aws/ec2/model/DeletePublicIpv4PoolResponse.h>
#include <aws/ec2/model/DeleteQueuedReservedInstancesError.h>
#include <aws/ec2/model/DeleteQueuedReservedInstancesErrorCode.h>
#include <aws/ec2/model/DeleteQueuedReservedInstancesRequest.h>
#include <aws/ec2/model/DeleteQueuedReservedInstancesResponse.h>
#include <aws/ec2/model/DeleteRouteRequest.h>
#include <aws/ec2/model/DeleteRouteServerEndpointRequest.h>
#include <aws/ec2/model/DeleteRouteServerEndpointResponse.h>
#include <aws/ec2/model/DeleteRouteServerPeerRequest.h>
#include <aws/ec2/model/DeleteRouteServerPeerResponse.h>
#include <aws/ec2/model/DeleteRouteServerRequest.h>
#include <aws/ec2/model/DeleteRouteServerResponse.h>
#include <aws/ec2/model/DeleteRouteTableRequest.h>
#include <aws/ec2/model/DeleteSecurityGroupRequest.h>
#include <aws/ec2/model/DeleteSecurityGroupResponse.h>
#include <aws/ec2/model/DeleteSnapshotRequest.h>
#include <aws/ec2/model/DeleteSnapshotReturnCode.h>
#include <aws/ec2/model/DeleteSpotDatafeedSubscriptionRequest.h>
#include <aws/ec2/model/DeleteSubnetCidrReservationRequest.h>
#include <aws/ec2/model/DeleteSubnetCidrReservationResponse.h>
#include <aws/ec2/model/DeleteSubnetRequest.h>
#include <aws/ec2/model/DeleteTagsRequest.h>
#include <aws/ec2/model/DeleteTrafficMirrorFilterRequest.h>
#include <aws/ec2/model/DeleteTrafficMirrorFilterResponse.h>
#include <aws/ec2/model/DeleteTrafficMirrorFilterRuleRequest.h>
#include <aws/ec2/model/DeleteTrafficMirrorFilterRuleResponse.h>
#include <aws/ec2/model/DeleteTrafficMirrorSessionRequest.h>
#include <aws/ec2/model/DeleteTrafficMirrorSessionResponse.h>
#include <aws/ec2/model/DeleteTrafficMirrorTargetRequest.h>
#include <aws/ec2/model/DeleteTrafficMirrorTargetResponse.h>
#include <aws/ec2/model/DeleteTransitGatewayConnectPeerRequest.h>
#include <aws/ec2/model/DeleteTransitGatewayConnectPeerResponse.h>
#include <aws/ec2/model/DeleteTransitGatewayConnectRequest.h>
#include <aws/ec2/model/DeleteTransitGatewayConnectResponse.h>
#include <aws/ec2/model/DeleteTransitGatewayMulticastDomainRequest.h>
#include <aws/ec2/model/DeleteTransitGatewayMulticastDomainResponse.h>
#include <aws/ec2/model/DeleteTransitGatewayPeeringAttachmentRequest.h>
#include <aws/ec2/model/DeleteTransitGatewayPeeringAttachmentResponse.h>
#include <aws/ec2/model/DeleteTransitGatewayPolicyTableRequest.h>
#include <aws/ec2/model/DeleteTransitGatewayPolicyTableResponse.h>
#include <aws/ec2/model/DeleteTransitGatewayPrefixListReferenceRequest.h>
#include <aws/ec2/model/DeleteTransitGatewayPrefixListReferenceResponse.h>
#include <aws/ec2/model/DeleteTransitGatewayRequest.h>
#include <aws/ec2/model/DeleteTransitGatewayResponse.h>
#include <aws/ec2/model/DeleteTransitGatewayRouteRequest.h>
#include <aws/ec2/model/DeleteTransitGatewayRouteResponse.h>
#include <aws/ec2/model/DeleteTransitGatewayRouteTableAnnouncementRequest.h>
#include <aws/ec2/model/DeleteTransitGatewayRouteTableAnnouncementResponse.h>
#include <aws/ec2/model/DeleteTransitGatewayRouteTableRequest.h>
#include <aws/ec2/model/DeleteTransitGatewayRouteTableResponse.h>
#include <aws/ec2/model/DeleteTransitGatewayVpcAttachmentRequest.h>
#include <aws/ec2/model/DeleteTransitGatewayVpcAttachmentResponse.h>
#include <aws/ec2/model/DeleteVerifiedAccessEndpointRequest.h>
#include <aws/ec2/model/DeleteVerifiedAccessEndpointResponse.h>
#include <aws/ec2/model/DeleteVerifiedAccessGroupRequest.h>
#include <aws/ec2/model/DeleteVerifiedAccessGroupResponse.h>
#include <aws/ec2/model/DeleteVerifiedAccessInstanceRequest.h>
#include <aws/ec2/model/DeleteVerifiedAccessInstanceResponse.h>
#include <aws/ec2/model/DeleteVerifiedAccessTrustProviderRequest.h>
#include <aws/ec2/model/DeleteVerifiedAccessTrustProviderResponse.h>
#include <aws/ec2/model/DeleteVolumeRequest.h>
#include <aws/ec2/model/DeleteVpcBlockPublicAccessExclusionRequest.h>
#include <aws/ec2/model/DeleteVpcBlockPublicAccessExclusionResponse.h>
#include <aws/ec2/model/DeleteVpcEndpointConnectionNotificationsRequest.h>
#include <aws/ec2/model/DeleteVpcEndpointConnectionNotificationsResponse.h>
#include <aws/ec2/model/DeleteVpcEndpointServiceConfigurationsRequest.h>
#include <aws/ec2/model/DeleteVpcEndpointServiceConfigurationsResponse.h>
#include <aws/ec2/model/DeleteVpcEndpointsRequest.h>
#include <aws/ec2/model/DeleteVpcEndpointsResponse.h>
#include <aws/ec2/model/DeleteVpcPeeringConnectionRequest.h>
#include <aws/ec2/model/DeleteVpcPeeringConnectionResponse.h>
#include <aws/ec2/model/DeleteVpcRequest.h>
#include <aws/ec2/model/DeleteVpnConnectionRequest.h>
#include <aws/ec2/model/DeleteVpnConnectionRouteRequest.h>
#include <aws/ec2/model/DeleteVpnGatewayRequest.h>
#include <aws/ec2/model/DeprovisionByoipCidrRequest.h>
#include <aws/ec2/model/DeprovisionByoipCidrResponse.h>
#include <aws/ec2/model/DeprovisionIpamByoasnRequest.h>
#include <aws/ec2/model/DeprovisionIpamByoasnResponse.h>
#include <aws/ec2/model/DeprovisionIpamPoolCidrRequest.h>
#include <aws/ec2/model/DeprovisionIpamPoolCidrResponse.h>
#include <aws/ec2/model/DeprovisionPublicIpv4PoolCidrRequest.h>
#include <aws/ec2/model/DeprovisionPublicIpv4PoolCidrResponse.h>
#include <aws/ec2/model/DeregisterImageRequest.h>
#include <aws/ec2/model/DeregisterImageResponse.h>
#include <aws/ec2/model/DeregisterInstanceEventNotificationAttributesRequest.h>
#include <aws/ec2/model/DeregisterInstanceEventNotificationAttributesResponse.h>
#include <aws/ec2/model/DeregisterInstanceTagAttributeRequest.h>
#include <aws/ec2/model/DeregisterTransitGatewayMulticastGroupMembersRequest.h>
#include <aws/ec2/model/DeregisterTransitGatewayMulticastGroupMembersResponse.h>
#include <aws/ec2/model/DeregisterTransitGatewayMulticastGroupSourcesRequest.h>
#include <aws/ec2/model/DeregisterTransitGatewayMulticastGroupSourcesResponse.h>
#include <aws/ec2/model/DescribeAccountAttributesRequest.h>
#include <aws/ec2/model/DescribeAccountAttributesResponse.h>
#include <aws/ec2/model/DescribeAddressTransfersRequest.h>
#include <aws/ec2/model/DescribeAddressTransfersResponse.h>
#include <aws/ec2/model/DescribeAddressesAttributeRequest.h>
#include <aws/ec2/model/DescribeAddressesAttributeResponse.h>
#include <aws/ec2/model/DescribeAddressesRequest.h>
#include <aws/ec2/model/DescribeAddressesResponse.h>
#include <aws/ec2/model/DescribeAggregateIdFormatRequest.h>
#include <aws/ec2/model/DescribeAggregateIdFormatResponse.h>
#include <aws/ec2/model/DescribeAvailabilityZonesRequest.h>
#include <aws/ec2/model/DescribeAvailabilityZonesResponse.h>
#include <aws/ec2/model/DescribeAwsNetworkPerformanceMetricSubscriptionsRequest.h>
#include <aws/ec2/model/DescribeAwsNetworkPerformanceMetricSubscriptionsResponse.h>
#include <aws/ec2/model/DescribeBundleTasksRequest.h>
#include <aws/ec2/model/DescribeBundleTasksResponse.h>
#include <aws/ec2/model/DescribeByoipCidrsRequest.h>
#include <aws/ec2/model/DescribeByoipCidrsResponse.h>
#include <aws/ec2/model/DescribeCapacityBlockExtensionHistoryRequest.h>
#include <aws/ec2/model/DescribeCapacityBlockExtensionHistoryResponse.h>
#include <aws/ec2/model/DescribeCapacityBlockExtensionOfferingsRequest.h>
#include <aws/ec2/model/DescribeCapacityBlockExtensionOfferingsResponse.h>
#include <aws/ec2/model/DescribeCapacityBlockOfferingsRequest.h>
#include <aws/ec2/model/DescribeCapacityBlockOfferingsResponse.h>
#include <aws/ec2/model/DescribeCapacityReservationBillingRequestsRequest.h>
#include <aws/ec2/model/DescribeCapacityReservationBillingRequestsResponse.h>
#include <aws/ec2/model/DescribeCapacityReservationFleetsRequest.h>
#include <aws/ec2/model/DescribeCapacityReservationFleetsResponse.h>
#include <aws/ec2/model/DescribeCapacityReservationsRequest.h>
#include <aws/ec2/model/DescribeCapacityReservationsResponse.h>
#include <aws/ec2/model/DescribeCarrierGatewaysRequest.h>
#include <aws/ec2/model/DescribeCarrierGatewaysResponse.h>
#include <aws/ec2/model/DescribeClassicLinkInstancesRequest.h>
#include <aws/ec2/model/DescribeClassicLinkInstancesResponse.h>
#include <aws/ec2/model/DescribeClientVpnAuthorizationRulesRequest.h>
#include <aws/ec2/model/DescribeClientVpnAuthorizationRulesResponse.h>
#include <aws/ec2/model/DescribeClientVpnConnectionsRequest.h>
#include <aws/ec2/model/DescribeClientVpnConnectionsResponse.h>
#include <aws/ec2/model/DescribeClientVpnEndpointsRequest.h>
#include <aws/ec2/model/DescribeClientVpnEndpointsResponse.h>
#include <aws/ec2/model/DescribeClientVpnRoutesRequest.h>
#include <aws/ec2/model/DescribeClientVpnRoutesResponse.h>
#include <aws/ec2/model/DescribeClientVpnTargetNetworksRequest.h>
#include <aws/ec2/model/DescribeClientVpnTargetNetworksResponse.h>
#include <aws/ec2/model/DescribeCoipPoolsRequest.h>
#include <aws/ec2/model/DescribeCoipPoolsResponse.h>
#include <aws/ec2/model/DescribeConversionTasksRequest.h>
#include <aws/ec2/model/DescribeConversionTasksResponse.h>
#include <aws/ec2/model/DescribeCustomerGatewaysRequest.h>
#include <aws/ec2/model/DescribeCustomerGatewaysResponse.h>
#include <aws/ec2/model/DescribeDeclarativePoliciesReportsRequest.h>
#include <aws/ec2/model/DescribeDeclarativePoliciesReportsResponse.h>
#include <aws/ec2/model/DescribeDhcpOptionsRequest.h>
#include <aws/ec2/model/DescribeDhcpOptionsResponse.h>
#include <aws/ec2/model/DescribeEgressOnlyInternetGatewaysRequest.h>
#include <aws/ec2/model/DescribeEgressOnlyInternetGatewaysResponse.h>
#include <aws/ec2/model/DescribeElasticGpusRequest.h>
#include <aws/ec2/model/DescribeElasticGpusResponse.h>
#include <aws/ec2/model/DescribeExportImageTasksRequest.h>
#include <aws/ec2/model/DescribeExportImageTasksResponse.h>
#include <aws/ec2/model/DescribeExportTasksRequest.h>
#include <aws/ec2/model/DescribeExportTasksResponse.h>
#include <aws/ec2/model/DescribeFastLaunchImagesRequest.h>
#include <aws/ec2/model/DescribeFastLaunchImagesResponse.h>
#include <aws/ec2/model/DescribeFastLaunchImagesSuccessItem.h>
#include <aws/ec2/model/DescribeFastSnapshotRestoreSuccessItem.h>
#include <aws/ec2/model/DescribeFastSnapshotRestoresRequest.h>
#include <aws/ec2/model/DescribeFastSnapshotRestoresResponse.h>
#include <aws/ec2/model/DescribeFleetError.h>
#include <aws/ec2/model/DescribeFleetHistoryRequest.h>
#include <aws/ec2/model/DescribeFleetHistoryResponse.h>
#include <aws/ec2/model/DescribeFleetInstancesRequest.h>
#include <aws/ec2/model/DescribeFleetInstancesResponse.h>
#include <aws/ec2/model/DescribeFleetsInstances.h>
#include <aws/ec2/model/DescribeFleetsRequest.h>
#include <aws/ec2/model/DescribeFleetsResponse.h>
#include <aws/ec2/model/DescribeFlowLogsRequest.h>
#include <aws/ec2/model/DescribeFlowLogsResponse.h>
#include <aws/ec2/model/DescribeFpgaImageAttributeRequest.h>
#include <aws/ec2/model/DescribeFpgaImageAttributeResponse.h>
#include <aws/ec2/model/DescribeFpgaImagesRequest.h>
#include <aws/ec2/model/DescribeFpgaImagesResponse.h>
#include <aws/ec2/model/DescribeHostReservationOfferingsRequest.h>
#include <aws/ec2/model/DescribeHostReservationOfferingsResponse.h>
#include <aws/ec2/model/DescribeHostReservationsRequest.h>
#include <aws/ec2/model/DescribeHostReservationsResponse.h>
#include <aws/ec2/model/DescribeHostsRequest.h>
#include <aws/ec2/model/DescribeHostsResponse.h>
#include <aws/ec2/model/DescribeIamInstanceProfileAssociationsRequest.h>
#include <aws/ec2/model/DescribeIamInstanceProfileAssociationsResponse.h>
#include <aws/ec2/model/DescribeIdFormatRequest.h>
#include <aws/ec2/model/DescribeIdFormatResponse.h>
#include <aws/ec2/model/DescribeIdentityIdFormatRequest.h>
#include <aws/ec2/model/DescribeIdentityIdFormatResponse.h>
#include <aws/ec2/model/DescribeImageAttributeRequest.h>
#include <aws/ec2/model/DescribeImageAttributeResponse.h>
#include <aws/ec2/model/DescribeImagesRequest.h>
#include <aws/ec2/model/DescribeImagesResponse.h>
#include <aws/ec2/model/DescribeImportImageTasksRequest.h>
#include <aws/ec2/model/DescribeImportImageTasksResponse.h>
#include <aws/ec2/model/DescribeImportSnapshotTasksRequest.h>
#include <aws/ec2/model/DescribeImportSnapshotTasksResponse.h>
#include <aws/ec2/model/DescribeInstanceAttributeRequest.h>
#include <aws/ec2/model/DescribeInstanceAttributeResponse.h>
#include <aws/ec2/model/DescribeInstanceConnectEndpointsRequest.h>
#include <aws/ec2/model/DescribeInstanceConnectEndpointsResponse.h>
#include <aws/ec2/model/DescribeInstanceCreditSpecificationsRequest.h>
#include <aws/ec2/model/DescribeInstanceCreditSpecificationsResponse.h>
#include <aws/ec2/model/DescribeInstanceEventNotificationAttributesRequest.h>
#include <aws/ec2/model/DescribeInstanceEventNotificationAttributesResponse.h>
#include <aws/ec2/model/DescribeInstanceEventWindowsRequest.h>
#include <aws/ec2/model/DescribeInstanceEventWindowsResponse.h>
#include <aws/ec2/model/DescribeInstanceImageMetadataRequest.h>
#include <aws/ec2/model/DescribeInstanceImageMetadataResponse.h>
#include <aws/ec2/model/DescribeInstanceStatusRequest.h>
#include <aws/ec2/model/DescribeInstanceStatusResponse.h>
#include <aws/ec2/model/DescribeInstanceTopologyRequest.h>
#include <aws/ec2/model/DescribeInstanceTopologyResponse.h>
#include <aws/ec2/model/DescribeInstanceTypeOfferingsRequest.h>
#include <aws/ec2/model/DescribeInstanceTypeOfferingsResponse.h>
#include <aws/ec2/model/DescribeInstanceTypesRequest.h>
#include <aws/ec2/model/DescribeInstanceTypesResponse.h>
#include <aws/ec2/model/DescribeInstancesRequest.h>
#include <aws/ec2/model/DescribeInstancesResponse.h>
#include <aws/ec2/model/DescribeInternetGatewaysRequest.h>
#include <aws/ec2/model/DescribeInternetGatewaysResponse.h>
#include <aws/ec2/model/DescribeIpamByoasnRequest.h>
#include <aws/ec2/model/DescribeIpamByoasnResponse.h>
#include <aws/ec2/model/DescribeIpamExternalResourceVerificationTokensRequest.h>
#include <aws/ec2/model/DescribeIpamExternalResourceVerificationTokensResponse.h>
#include <aws/ec2/model/DescribeIpamPoolsRequest.h>
#include <aws/ec2/model/DescribeIpamPoolsResponse.h>
#include <aws/ec2/model/DescribeIpamResourceDiscoveriesRequest.h>
#include <aws/ec2/model/DescribeIpamResourceDiscoveriesResponse.h>
#include <aws/ec2/model/DescribeIpamResourceDiscoveryAssociationsRequest.h>
#include <aws/ec2/model/DescribeIpamResourceDiscoveryAssociationsResponse.h>
#include <aws/ec2/model/DescribeIpamScopesRequest.h>
#include <aws/ec2/model/DescribeIpamScopesResponse.h>
#include <aws/ec2/model/DescribeIpamsRequest.h>
#include <aws/ec2/model/DescribeIpamsResponse.h>
#include <aws/ec2/model/DescribeIpv6PoolsRequest.h>
#include <aws/ec2/model/DescribeIpv6PoolsResponse.h>
#include <aws/ec2/model/DescribeKeyPairsRequest.h>
#include <aws/ec2/model/DescribeKeyPairsResponse.h>
#include <aws/ec2/model/DescribeLaunchTemplateVersionsRequest.h>
#include <aws/ec2/model/DescribeLaunchTemplateVersionsResponse.h>
#include <aws/ec2/model/DescribeLaunchTemplatesRequest.h>
#include <aws/ec2/model/DescribeLaunchTemplatesResponse.h>
#include <aws/ec2/model/DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest.h>
#include <aws/ec2/model/DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse.h>
#include <aws/ec2/model/DescribeLocalGatewayRouteTableVpcAssociationsRequest.h>
#include <aws/ec2/model/DescribeLocalGatewayRouteTableVpcAssociationsResponse.h>
#include <aws/ec2/model/DescribeLocalGatewayRouteTablesRequest.h>
#include <aws/ec2/model/DescribeLocalGatewayRouteTablesResponse.h>
#include <aws/ec2/model/DescribeLocalGatewayVirtualInterfaceGroupsRequest.h>
#include <aws/ec2/model/DescribeLocalGatewayVirtualInterfaceGroupsResponse.h>
#include <aws/ec2/model/DescribeLocalGatewayVirtualInterfacesRequest.h>
#include <aws/ec2/model/DescribeLocalGatewayVirtualInterfacesResponse.h>
#include <aws/ec2/model/DescribeLocalGatewaysRequest.h>
#include <aws/ec2/model/DescribeLocalGatewaysResponse.h>
#include <aws/ec2/model/DescribeLockedSnapshotsRequest.h>
#include <aws/ec2/model/DescribeLockedSnapshotsResponse.h>
#include <aws/ec2/model/DescribeMacHostsRequest.h>
#include <aws/ec2/model/DescribeMacHostsResponse.h>
#include <aws/ec2/model/DescribeMacModificationTasksRequest.h>
#include <aws/ec2/model/DescribeMacModificationTasksResponse.h>
#include <aws/ec2/model/DescribeManagedPrefixListsRequest.h>
#include <aws/ec2/model/DescribeManagedPrefixListsResponse.h>
#include <aws/ec2/model/DescribeMovingAddressesRequest.h>
#include <aws/ec2/model/DescribeMovingAddressesResponse.h>
#include <aws/ec2/model/DescribeNatGatewaysRequest.h>
#include <aws/ec2/model/DescribeNatGatewaysResponse.h>
#include <aws/ec2/model/DescribeNetworkAclsRequest.h>
#include <aws/ec2/model/DescribeNetworkAclsResponse.h>
#include <aws/ec2/model/DescribeNetworkInsightsAccessScopeAnalysesRequest.h>
#include <aws/ec2/model/DescribeNetworkInsightsAccessScopeAnalysesResponse.h>
#include <aws/ec2/model/DescribeNetworkInsightsAccessScopesRequest.h>
#include <aws/ec2/model/DescribeNetworkInsightsAccessScopesResponse.h>
#include <aws/ec2/model/DescribeNetworkInsightsAnalysesRequest.h>
#include <aws/ec2/model/DescribeNetworkInsightsAnalysesResponse.h>
#include <aws/ec2/model/DescribeNetworkInsightsPathsRequest.h>
#include <aws/ec2/model/DescribeNetworkInsightsPathsResponse.h>
#include <aws/ec2/model/DescribeNetworkInterfaceAttributeRequest.h>
#include <aws/ec2/model/DescribeNetworkInterfaceAttributeResponse.h>
#include <aws/ec2/model/DescribeNetworkInterfacePermissionsRequest.h>
#include <aws/ec2/model/DescribeNetworkInterfacePermissionsResponse.h>
#include <aws/ec2/model/DescribeNetworkInterfacesRequest.h>
#include <aws/ec2/model/DescribeNetworkInterfacesResponse.h>
#include <aws/ec2/model/DescribeOutpostLagsRequest.h>
#include <aws/ec2/model/DescribeOutpostLagsResponse.h>
#include <aws/ec2/model/DescribePlacementGroupsRequest.h>
#include <aws/ec2/model/DescribePlacementGroupsResponse.h>
#include <aws/ec2/model/DescribePrefixListsRequest.h>
#include <aws/ec2/model/DescribePrefixListsResponse.h>
#include <aws/ec2/model/DescribePrincipalIdFormatRequest.h>
#include <aws/ec2/model/DescribePrincipalIdFormatResponse.h>
#include <aws/ec2/model/DescribePublicIpv4PoolsRequest.h>
#include <aws/ec2/model/DescribePublicIpv4PoolsResponse.h>
#include <aws/ec2/model/DescribeRegionsRequest.h>
#include <aws/ec2/model/DescribeRegionsResponse.h>
#include <aws/ec2/model/DescribeReplaceRootVolumeTasksRequest.h>
#include <aws/ec2/model/DescribeReplaceRootVolumeTasksResponse.h>
#include <aws/ec2/model/DescribeReservedInstancesListingsRequest.h>
#include <aws/ec2/model/DescribeReservedInstancesListingsResponse.h>
#include <aws/ec2/model/DescribeReservedInstancesModificationsRequest.h>
#include <aws/ec2/model/DescribeReservedInstancesModificationsResponse.h>
#include <aws/ec2/model/DescribeReservedInstancesOfferingsRequest.h>
#include <aws/ec2/model/DescribeReservedInstancesOfferingsResponse.h>
#include <aws/ec2/model/DescribeReservedInstancesRequest.h>
#include <aws/ec2/model/DescribeReservedInstancesResponse.h>
#include <aws/ec2/model/DescribeRouteServerEndpointsRequest.h>
#include <aws/ec2/model/DescribeRouteServerEndpointsResponse.h>
#include <aws/ec2/model/DescribeRouteServerPeersRequest.h>
#include <aws/ec2/model/DescribeRouteServerPeersResponse.h>
#include <aws/ec2/model/DescribeRouteServersRequest.h>
#include <aws/ec2/model/DescribeRouteServersResponse.h>
#include <aws/ec2/model/DescribeRouteTablesRequest.h>
#include <aws/ec2/model/DescribeRouteTablesResponse.h>
#include <aws/ec2/model/DescribeScheduledInstanceAvailabilityRequest.h>
#include <aws/ec2/model/DescribeScheduledInstanceAvailabilityResponse.h>
#include <aws/ec2/model/DescribeScheduledInstancesRequest.h>
#include <aws/ec2/model/DescribeScheduledInstancesResponse.h>
#include <aws/ec2/model/DescribeSecurityGroupReferencesRequest.h>
#include <aws/ec2/model/DescribeSecurityGroupReferencesResponse.h>
#include <aws/ec2/model/DescribeSecurityGroupRulesRequest.h>
#include <aws/ec2/model/DescribeSecurityGroupRulesResponse.h>
#include <aws/ec2/model/DescribeSecurityGroupVpcAssociationsRequest.h>
#include <aws/ec2/model/DescribeSecurityGroupVpcAssociationsResponse.h>
#include <aws/ec2/model/DescribeSecurityGroupsRequest.h>
#include <aws/ec2/model/DescribeSecurityGroupsResponse.h>
#include <aws/ec2/model/DescribeServiceLinkVirtualInterfacesRequest.h>
#include <aws/ec2/model/DescribeServiceLinkVirtualInterfacesResponse.h>
#include <aws/ec2/model/DescribeSnapshotAttributeRequest.h>
#include <aws/ec2/model/DescribeSnapshotAttributeResponse.h>
#include <aws/ec2/model/DescribeSnapshotTierStatusRequest.h>
#include <aws/ec2/model/DescribeSnapshotTierStatusResponse.h>
#include <aws/ec2/model/DescribeSnapshotsRequest.h>
#include <aws/ec2/model/DescribeSnapshotsResponse.h>
#include <aws/ec2/model/DescribeSpotDatafeedSubscriptionRequest.h>
#include <aws/ec2/model/DescribeSpotDatafeedSubscriptionResponse.h>
#include <aws/ec2/model/DescribeSpotFleetInstancesRequest.h>
#include <aws/ec2/model/DescribeSpotFleetInstancesResponse.h>
#include <aws/ec2/model/DescribeSpotFleetRequestHistoryRequest.h>
#include <aws/ec2/model/DescribeSpotFleetRequestHistoryResponse.h>
#include <aws/ec2/model/DescribeSpotFleetRequestsRequest.h>
#include <aws/ec2/model/DescribeSpotFleetRequestsResponse.h>
#include <aws/ec2/model/DescribeSpotInstanceRequestsRequest.h>
#include <aws/ec2/model/DescribeSpotInstanceRequestsResponse.h>
#include <aws/ec2/model/DescribeSpotPriceHistoryRequest.h>
#include <aws/ec2/model/DescribeSpotPriceHistoryResponse.h>
#include <aws/ec2/model/DescribeStaleSecurityGroupsRequest.h>
#include <aws/ec2/model/DescribeStaleSecurityGroupsResponse.h>
#include <aws/ec2/model/DescribeStoreImageTasksRequest.h>
#include <aws/ec2/model/DescribeStoreImageTasksResponse.h>
#include <aws/ec2/model/DescribeSubnetsRequest.h>
#include <aws/ec2/model/DescribeSubnetsResponse.h>
#include <aws/ec2/model/DescribeTagsRequest.h>
#include <aws/ec2/model/DescribeTagsResponse.h>
#include <aws/ec2/model/DescribeTrafficMirrorFilterRulesRequest.h>
#include <aws/ec2/model/DescribeTrafficMirrorFilterRulesResponse.h>
#include <aws/ec2/model/DescribeTrafficMirrorFiltersRequest.h>
#include <aws/ec2/model/DescribeTrafficMirrorFiltersResponse.h>
#include <aws/ec2/model/DescribeTrafficMirrorSessionsRequest.h>
#include <aws/ec2/model/DescribeTrafficMirrorSessionsResponse.h>
#include <aws/ec2/model/DescribeTrafficMirrorTargetsRequest.h>
#include <aws/ec2/model/DescribeTrafficMirrorTargetsResponse.h>
#include <aws/ec2/model/DescribeTransitGatewayAttachmentsRequest.h>
#include <aws/ec2/model/DescribeTransitGatewayAttachmentsResponse.h>
#include <aws/ec2/model/DescribeTransitGatewayConnectPeersRequest.h>
#include <aws/ec2/model/DescribeTransitGatewayConnectPeersResponse.h>
#include <aws/ec2/model/DescribeTransitGatewayConnectsRequest.h>
#include <aws/ec2/model/DescribeTransitGatewayConnectsResponse.h>
#include <aws/ec2/model/DescribeTransitGatewayMulticastDomainsRequest.h>
#include <aws/ec2/model/DescribeTransitGatewayMulticastDomainsResponse.h>
#include <aws/ec2/model/DescribeTransitGatewayPeeringAttachmentsRequest.h>
#include <aws/ec2/model/DescribeTransitGatewayPeeringAttachmentsResponse.h>
#include <aws/ec2/model/DescribeTransitGatewayPolicyTablesRequest.h>
#include <aws/ec2/model/DescribeTransitGatewayPolicyTablesResponse.h>
#include <aws/ec2/model/DescribeTransitGatewayRouteTableAnnouncementsRequest.h>
#include <aws/ec2/model/DescribeTransitGatewayRouteTableAnnouncementsResponse.h>
#include <aws/ec2/model/DescribeTransitGatewayRouteTablesRequest.h>
#include <aws/ec2/model/DescribeTransitGatewayRouteTablesResponse.h>
#include <aws/ec2/model/DescribeTransitGatewayVpcAttachmentsRequest.h>
#include <aws/ec2/model/DescribeTransitGatewayVpcAttachmentsResponse.h>
#include <aws/ec2/model/DescribeTransitGatewaysRequest.h>
#include <aws/ec2/model/DescribeTransitGatewaysResponse.h>
#include <aws/ec2/model/DescribeTrunkInterfaceAssociationsRequest.h>
#include <aws/ec2/model/DescribeTrunkInterfaceAssociationsResponse.h>
#include <aws/ec2/model/DescribeVerifiedAccessEndpointsRequest.h>
#include <aws/ec2/model/DescribeVerifiedAccessEndpointsResponse.h>
#include <aws/ec2/model/DescribeVerifiedAccessGroupsRequest.h>
#include <aws/ec2/model/DescribeVerifiedAccessGroupsResponse.h>
#include <aws/ec2/model/DescribeVerifiedAccessInstanceLoggingConfigurationsRequest.h>
#include <aws/ec2/model/DescribeVerifiedAccessInstanceLoggingConfigurationsResponse.h>
#include <aws/ec2/model/DescribeVerifiedAccessInstancesRequest.h>
#include <aws/ec2/model/DescribeVerifiedAccessInstancesResponse.h>
#include <aws/ec2/model/DescribeVerifiedAccessTrustProvidersRequest.h>
#include <aws/ec2/model/DescribeVerifiedAccessTrustProvidersResponse.h>
#include <aws/ec2/model/DescribeVolumeAttributeRequest.h>
#include <aws/ec2/model/DescribeVolumeAttributeResponse.h>
#include <aws/ec2/model/DescribeVolumeStatusRequest.h>
#include <aws/ec2/model/DescribeVolumeStatusResponse.h>
#include <aws/ec2/model/DescribeVolumesModificationsRequest.h>
#include <aws/ec2/model/DescribeVolumesModificationsResponse.h>
#include <aws/ec2/model/DescribeVolumesRequest.h>
#include <aws/ec2/model/DescribeVolumesResponse.h>
#include <aws/ec2/model/DescribeVpcAttributeRequest.h>
#include <aws/ec2/model/DescribeVpcAttributeResponse.h>
#include <aws/ec2/model/DescribeVpcBlockPublicAccessExclusionsRequest.h>
#include <aws/ec2/model/DescribeVpcBlockPublicAccessExclusionsResponse.h>
#include <aws/ec2/model/DescribeVpcBlockPublicAccessOptionsRequest.h>
#include <aws/ec2/model/DescribeVpcBlockPublicAccessOptionsResponse.h>
#include <aws/ec2/model/DescribeVpcClassicLinkDnsSupportRequest.h>
#include <aws/ec2/model/DescribeVpcClassicLinkDnsSupportResponse.h>
#include <aws/ec2/model/DescribeVpcClassicLinkRequest.h>
#include <aws/ec2/model/DescribeVpcClassicLinkResponse.h>
#include <aws/ec2/model/DescribeVpcEndpointAssociationsRequest.h>
#include <aws/ec2/model/DescribeVpcEndpointAssociationsResponse.h>
#include <aws/ec2/model/DescribeVpcEndpointConnectionNotificationsRequest.h>
#include <aws/ec2/model/DescribeVpcEndpointConnectionNotificationsResponse.h>
#include <aws/ec2/model/DescribeVpcEndpointConnectionsRequest.h>
#include <aws/ec2/model/DescribeVpcEndpointConnectionsResponse.h>
#include <aws/ec2/model/DescribeVpcEndpointServiceConfigurationsRequest.h>
#include <aws/ec2/model/DescribeVpcEndpointServiceConfigurationsResponse.h>
#include <aws/ec2/model/DescribeVpcEndpointServicePermissionsRequest.h>
#include <aws/ec2/model/DescribeVpcEndpointServicePermissionsResponse.h>
#include <aws/ec2/model/DescribeVpcEndpointServicesRequest.h>
#include <aws/ec2/model/DescribeVpcEndpointServicesResponse.h>
#include <aws/ec2/model/DescribeVpcEndpointsRequest.h>
#include <aws/ec2/model/DescribeVpcEndpointsResponse.h>
#include <aws/ec2/model/DescribeVpcPeeringConnectionsRequest.h>
#include <aws/ec2/model/DescribeVpcPeeringConnectionsResponse.h>
#include <aws/ec2/model/DescribeVpcsRequest.h>
#include <aws/ec2/model/DescribeVpcsResponse.h>
#include <aws/ec2/model/DescribeVpnConnectionsRequest.h>
#include <aws/ec2/model/DescribeVpnConnectionsResponse.h>
#include <aws/ec2/model/DescribeVpnGatewaysRequest.h>
#include <aws/ec2/model/DescribeVpnGatewaysResponse.h>
#include <aws/ec2/model/DestinationFileFormat.h>
#include <aws/ec2/model/DestinationOptionsRequest.h>
#include <aws/ec2/model/DestinationOptionsResponse.h>
#include <aws/ec2/model/DetachClassicLinkVpcRequest.h>
#include <aws/ec2/model/DetachClassicLinkVpcResponse.h>
#include <aws/ec2/model/DetachInternetGatewayRequest.h>
#include <aws/ec2/model/DetachNetworkInterfaceRequest.h>
#include <aws/ec2/model/DetachVerifiedAccessTrustProviderRequest.h>
#include <aws/ec2/model/DetachVerifiedAccessTrustProviderResponse.h>
#include <aws/ec2/model/DetachVolumeRequest.h>
#include <aws/ec2/model/DetachVolumeResponse.h>
#include <aws/ec2/model/DetachVpnGatewayRequest.h>
#include <aws/ec2/model/DeviceOptions.h>
#include <aws/ec2/model/DeviceTrustProviderType.h>
#include <aws/ec2/model/DeviceType.h>
#include <aws/ec2/model/DhcpConfiguration.h>
#include <aws/ec2/model/DhcpOptions.h>
#include <aws/ec2/model/DirectoryServiceAuthentication.h>
#include <aws/ec2/model/DirectoryServiceAuthenticationRequest.h>
#include <aws/ec2/model/DisableAddressTransferRequest.h>
#include <aws/ec2/model/DisableAddressTransferResponse.h>
#include <aws/ec2/model/DisableAllowedImagesSettingsRequest.h>
#include <aws/ec2/model/DisableAllowedImagesSettingsResponse.h>
#include <aws/ec2/model/DisableAwsNetworkPerformanceMetricSubscriptionRequest.h>
#include <aws/ec2/model/DisableAwsNetworkPerformanceMetricSubscriptionResponse.h>
#include <aws/ec2/model/DisableEbsEncryptionByDefaultRequest.h>
#include <aws/ec2/model/DisableEbsEncryptionByDefaultResponse.h>
#include <aws/ec2/model/DisableFastLaunchRequest.h>
#include <aws/ec2/model/DisableFastLaunchResponse.h>
#include <aws/ec2/model/DisableFastSnapshotRestoreErrorItem.h>
#include <aws/ec2/model/DisableFastSnapshotRestoreStateError.h>
#include <aws/ec2/model/DisableFastSnapshotRestoreStateErrorItem.h>
#include <aws/ec2/model/DisableFastSnapshotRestoreSuccessItem.h>
#include <aws/ec2/model/DisableFastSnapshotRestoresRequest.h>
#include <aws/ec2/model/DisableFastSnapshotRestoresResponse.h>
#include <aws/ec2/model/DisableImageBlockPublicAccessRequest.h>
#include <aws/ec2/model/DisableImageBlockPublicAccessResponse.h>
#include <aws/ec2/model/DisableImageDeprecationRequest.h>
#include <aws/ec2/model/DisableImageDeprecationResponse.h>
#include <aws/ec2/model/DisableImageDeregistrationProtectionRequest.h>
#include <aws/ec2/model/DisableImageDeregistrationProtectionResponse.h>
#include <aws/ec2/model/DisableImageRequest.h>
#include <aws/ec2/model/DisableImageResponse.h>
#include <aws/ec2/model/DisableIpamOrganizationAdminAccountRequest.h>
#include <aws/ec2/model/DisableIpamOrganizationAdminAccountResponse.h>
#include <aws/ec2/model/DisableRouteServerPropagationRequest.h>
#include <aws/ec2/model/DisableRouteServerPropagationResponse.h>
#include <aws/ec2/model/DisableSerialConsoleAccessRequest.h>
#include <aws/ec2/model/DisableSerialConsoleAccessResponse.h>
#include <aws/ec2/model/DisableSnapshotBlockPublicAccessRequest.h>
#include <aws/ec2/model/DisableSnapshotBlockPublicAccessResponse.h>
#include <aws/ec2/model/DisableTransitGatewayRouteTablePropagationRequest.h>
#include <aws/ec2/model/DisableTransitGatewayRouteTablePropagationResponse.h>
#include <aws/ec2/model/DisableVgwRoutePropagationRequest.h>
#include <aws/ec2/model/DisableVpcClassicLinkDnsSupportRequest.h>
#include <aws/ec2/model/DisableVpcClassicLinkDnsSupportResponse.h>
#include <aws/ec2/model/DisableVpcClassicLinkRequest.h>
#include <aws/ec2/model/DisableVpcClassicLinkResponse.h>
#include <aws/ec2/model/DisassociateAddressRequest.h>
#include <aws/ec2/model/DisassociateCapacityReservationBillingOwnerRequest.h>
#include <aws/ec2/model/DisassociateCapacityReservationBillingOwnerResponse.h>
#include <aws/ec2/model/DisassociateClientVpnTargetNetworkRequest.h>
#include <aws/ec2/model/DisassociateClientVpnTargetNetworkResponse.h>
#include <aws/ec2/model/DisassociateEnclaveCertificateIamRoleRequest.h>
#include <aws/ec2/model/DisassociateEnclaveCertificateIamRoleResponse.h>
#include <aws/ec2/model/DisassociateIamInstanceProfileRequest.h>
#include <aws/ec2/model/DisassociateIamInstanceProfileResponse.h>
#include <aws/ec2/model/DisassociateInstanceEventWindowRequest.h>
#include <aws/ec2/model/DisassociateInstanceEventWindowResponse.h>
#include <aws/ec2/model/DisassociateIpamByoasnRequest.h>
#include <aws/ec2/model/DisassociateIpamByoasnResponse.h>
#include <aws/ec2/model/DisassociateIpamResourceDiscoveryRequest.h>
#include <aws/ec2/model/DisassociateIpamResourceDiscoveryResponse.h>
#include <aws/ec2/model/DisassociateNatGatewayAddressRequest.h>
#include <aws/ec2/model/DisassociateNatGatewayAddressResponse.h>
#include <aws/ec2/model/DisassociateRouteServerRequest.h>
#include <aws/ec2/model/DisassociateRouteServerResponse.h>
#include <aws/ec2/model/DisassociateRouteTableRequest.h>
#include <aws/ec2/model/DisassociateSecurityGroupVpcRequest.h>
#include <aws/ec2/model/DisassociateSecurityGroupVpcResponse.h>
#include <aws/ec2/model/DisassociateSubnetCidrBlockRequest.h>
#include <aws/ec2/model/DisassociateSubnetCidrBlockResponse.h>
#include <aws/ec2/model/DisassociateTransitGatewayMulticastDomainRequest.h>
#include <aws/ec2/model/DisassociateTransitGatewayMulticastDomainResponse.h>
#include <aws/ec2/model/DisassociateTransitGatewayPolicyTableRequest.h>
#include <aws/ec2/model/DisassociateTransitGatewayPolicyTableResponse.h>
#include <aws/ec2/model/DisassociateTransitGatewayRouteTableRequest.h>
#include <aws/ec2/model/DisassociateTransitGatewayRouteTableResponse.h>
#include <aws/ec2/model/DisassociateTrunkInterfaceRequest.h>
#include <aws/ec2/model/DisassociateTrunkInterfaceResponse.h>
#include <aws/ec2/model/DisassociateVpcCidrBlockRequest.h>
#include <aws/ec2/model/DisassociateVpcCidrBlockResponse.h>
#include <aws/ec2/model/DiskImage.h>
#include <aws/ec2/model/DiskImageDescription.h>
#include <aws/ec2/model/DiskImageDetail.h>
#include <aws/ec2/model/DiskImageFormat.h>
#include <aws/ec2/model/DiskImageVolumeDescription.h>
#include <aws/ec2/model/DiskInfo.h>
#include <aws/ec2/model/DiskType.h>
#include <aws/ec2/model/DnsEntry.h>
#include <aws/ec2/model/DnsNameState.h>
#include <aws/ec2/model/DnsOptions.h>
#include <aws/ec2/model/DnsOptionsSpecification.h>
#include <aws/ec2/model/DnsRecordIpType.h>
#include <aws/ec2/model/DnsServersOptionsModifyStructure.h>
#include <aws/ec2/model/DnsSupportValue.h>
#include <aws/ec2/model/DomainType.h>
#include <aws/ec2/model/DynamicRoutingValue.h>
#include <aws/ec2/model/EbsBlockDevice.h>
#include <aws/ec2/model/EbsBlockDeviceResponse.h>
#include <aws/ec2/model/EbsEncryptionSupport.h>
#include <aws/ec2/model/EbsInfo.h>
#include <aws/ec2/model/EbsInstanceBlockDevice.h>
#include <aws/ec2/model/EbsInstanceBlockDeviceSpecification.h>
#include <aws/ec2/model/EbsNvmeSupport.h>
#include <aws/ec2/model/EbsOptimizedInfo.h>
#include <aws/ec2/model/EbsOptimizedSupport.h>
#include <aws/ec2/model/EbsStatusDetails.h>
#include <aws/ec2/model/EbsStatusSummary.h>
#include <aws/ec2/model/Ec2InstanceConnectEndpoint.h>
#include <aws/ec2/model/Ec2InstanceConnectEndpointState.h>
#include <aws/ec2/model/EfaInfo.h>
#include <aws/ec2/model/EgressOnlyInternetGateway.h>
#include <aws/ec2/model/EkPubKeyFormat.h>
#include <aws/ec2/model/EkPubKeyType.h>
#include <aws/ec2/model/ElasticGpuAssociation.h>
#include <aws/ec2/model/ElasticGpuHealth.h>
#include <aws/ec2/model/ElasticGpuSpecification.h>
#include <aws/ec2/model/ElasticGpuSpecificationResponse.h>
#include <aws/ec2/model/ElasticGpuState.h>
#include <aws/ec2/model/ElasticGpuStatus.h>
#include <aws/ec2/model/ElasticGpus.h>
#include <aws/ec2/model/ElasticInferenceAccelerator.h>
#include <aws/ec2/model/ElasticInferenceAcceleratorAssociation.h>
#include <aws/ec2/model/EnaSrdSpecification.h>
#include <aws/ec2/model/EnaSrdSpecificationRequest.h>
#include <aws/ec2/model/EnaSrdUdpSpecification.h>
#include <aws/ec2/model/EnaSrdUdpSpecificationRequest.h>
#include <aws/ec2/model/EnaSupport.h>
#include <aws/ec2/model/EnableAddressTransferRequest.h>
#include <aws/ec2/model/EnableAddressTransferResponse.h>
#include <aws/ec2/model/EnableAllowedImagesSettingsRequest.h>
#include <aws/ec2/model/EnableAllowedImagesSettingsResponse.h>
#include <aws/ec2/model/EnableAwsNetworkPerformanceMetricSubscriptionRequest.h>
#include <aws/ec2/model/EnableAwsNetworkPerformanceMetricSubscriptionResponse.h>
#include <aws/ec2/model/EnableEbsEncryptionByDefaultRequest.h>
#include <aws/ec2/model/EnableEbsEncryptionByDefaultResponse.h>
#include <aws/ec2/model/EnableFastLaunchRequest.h>
#include <aws/ec2/model/EnableFastLaunchResponse.h>
#include <aws/ec2/model/EnableFastSnapshotRestoreErrorItem.h>
#include <aws/ec2/model/EnableFastSnapshotRestoreStateError.h>
#include <aws/ec2/model/EnableFastSnapshotRestoreStateErrorItem.h>
#include <aws/ec2/model/EnableFastSnapshotRestoreSuccessItem.h>
#include <aws/ec2/model/EnableFastSnapshotRestoresRequest.h>
#include <aws/ec2/model/EnableFastSnapshotRestoresResponse.h>
#include <aws/ec2/model/EnableImageBlockPublicAccessRequest.h>
#include <aws/ec2/model/EnableImageBlockPublicAccessResponse.h>
#include <aws/ec2/model/EnableImageDeprecationRequest.h>
#include <aws/ec2/model/EnableImageDeprecationResponse.h>
#include <aws/ec2/model/EnableImageDeregistrationProtectionRequest.h>
#include <aws/ec2/model/EnableImageDeregistrationProtectionResponse.h>
#include <aws/ec2/model/EnableImageRequest.h>
#include <aws/ec2/model/EnableImageResponse.h>
#include <aws/ec2/model/EnableIpamOrganizationAdminAccountRequest.h>
#include <aws/ec2/model/EnableIpamOrganizationAdminAccountResponse.h>
#include <aws/ec2/model/EnableReachabilityAnalyzerOrganizationSharingRequest.h>
#include <aws/ec2/model/EnableReachabilityAnalyzerOrganizationSharingResponse.h>
#include <aws/ec2/model/EnableRouteServerPropagationRequest.h>
#include <aws/ec2/model/EnableRouteServerPropagationResponse.h>
#include <aws/ec2/model/EnableSerialConsoleAccessRequest.h>
#include <aws/ec2/model/EnableSerialConsoleAccessResponse.h>
#include <aws/ec2/model/EnableSnapshotBlockPublicAccessRequest.h>
#include <aws/ec2/model/EnableSnapshotBlockPublicAccessResponse.h>
#include <aws/ec2/model/EnableTransitGatewayRouteTablePropagationRequest.h>
#include <aws/ec2/model/EnableTransitGatewayRouteTablePropagationResponse.h>
#include <aws/ec2/model/EnableVgwRoutePropagationRequest.h>
#include <aws/ec2/model/EnableVolumeIORequest.h>
#include <aws/ec2/model/EnableVpcClassicLinkDnsSupportRequest.h>
#include <aws/ec2/model/EnableVpcClassicLinkDnsSupportResponse.h>
#include <aws/ec2/model/EnableVpcClassicLinkRequest.h>
#include <aws/ec2/model/EnableVpcClassicLinkResponse.h>
#include <aws/ec2/model/EnclaveOptions.h>
#include <aws/ec2/model/EnclaveOptionsRequest.h>
#include <aws/ec2/model/EndDateType.h>
#include <aws/ec2/model/EphemeralNvmeSupport.h>
#include <aws/ec2/model/EventCode.h>
#include <aws/ec2/model/EventInformation.h>
#include <aws/ec2/model/EventType.h>
#include <aws/ec2/model/ExcessCapacityTerminationPolicy.h>
#include <aws/ec2/model/Explanation.h>
#include <aws/ec2/model/ExportClientVpnClientCertificateRevocationListRequest.h>
#include <aws/ec2/model/ExportClientVpnClientCertificateRevocationListResponse.h>
#include <aws/ec2/model/ExportClientVpnClientConfigurationRequest.h>
#include <aws/ec2/model/ExportClientVpnClientConfigurationResponse.h>
#include <aws/ec2/model/ExportEnvironment.h>
#include <aws/ec2/model/ExportImageRequest.h>
#include <aws/ec2/model/ExportImageResponse.h>
#include <aws/ec2/model/ExportImageTask.h>
#include <aws/ec2/model/ExportTask.h>
#include <aws/ec2/model/ExportTaskS3Location.h>
#include <aws/ec2/model/ExportTaskS3LocationRequest.h>
#include <aws/ec2/model/ExportTaskState.h>
#include <aws/ec2/model/ExportToS3Task.h>
#include <aws/ec2/model/ExportToS3TaskSpecification.h>
#include <aws/ec2/model/ExportTransitGatewayRoutesRequest.h>
#include <aws/ec2/model/ExportTransitGatewayRoutesResponse.h>
#include <aws/ec2/model/ExportVerifiedAccessInstanceClientConfigurationRequest.h>
#include <aws/ec2/model/ExportVerifiedAccessInstanceClientConfigurationResponse.h>
#include <aws/ec2/model/FailedCapacityReservationFleetCancellationResponse.h>
#include <aws/ec2/model/FailedQueuedPurchaseDeletion.h>
#include <aws/ec2/model/FastLaunchLaunchTemplateSpecificationRequest.h>
#include <aws/ec2/model/FastLaunchLaunchTemplateSpecificationResponse.h>
#include <aws/ec2/model/FastLaunchResourceType.h>
#include <aws/ec2/model/FastLaunchSnapshotConfigurationRequest.h>
#include <aws/ec2/model/FastLaunchSnapshotConfigurationResponse.h>
#include <aws/ec2/model/FastLaunchStateCode.h>
#include <aws/ec2/model/FastSnapshotRestoreStateCode.h>
#include <aws/ec2/model/FederatedAuthentication.h>
#include <aws/ec2/model/FederatedAuthenticationRequest.h>
#include <aws/ec2/model/Filter.h>
#include <aws/ec2/model/FilterPortRange.h>
#include <aws/ec2/model/FindingsFound.h>
#include <aws/ec2/model/FirewallStatefulRule.h>
#include <aws/ec2/model/FirewallStatelessRule.h>
#include <aws/ec2/model/FleetActivityStatus.h>
#include <aws/ec2/model/FleetBlockDeviceMappingRequest.h>
#include <aws/ec2/model/FleetCapacityReservation.h>
#include <aws/ec2/model/FleetCapacityReservationTenancy.h>
#include <aws/ec2/model/FleetCapacityReservationUsageStrategy.h>
#include <aws/ec2/model/FleetData.h>
#include <aws/ec2/model/FleetEbsBlockDeviceRequest.h>
#include <aws/ec2/model/FleetEventType.h>
#include <aws/ec2/model/FleetExcessCapacityTerminationPolicy.h>
#include <aws/ec2/model/FleetInstanceMatchCriteria.h>
#include <aws/ec2/model/FleetLaunchTemplateConfig.h>
#include <aws/ec2/model/FleetLaunchTemplateConfigRequest.h>
#include <aws/ec2/model/FleetLaunchTemplateOverrides.h>
#include <aws/ec2/model/FleetLaunchTemplateOverridesRequest.h>
#include <aws/ec2/model/FleetLaunchTemplateSpecification.h>
#include <aws/ec2/model/FleetLaunchTemplateSpecificationRequest.h>
#include <aws/ec2/model/FleetOnDemandAllocationStrategy.h>
#include <aws/ec2/model/FleetReplacementStrategy.h>
#include <aws/ec2/model/FleetSpotCapacityRebalance.h>
#include <aws/ec2/model/FleetSpotCapacityRebalanceRequest.h>
#include <aws/ec2/model/FleetSpotMaintenanceStrategies.h>
#include <aws/ec2/model/FleetSpotMaintenanceStrategiesRequest.h>
#include <aws/ec2/model/FleetStateCode.h>
#include <aws/ec2/model/FleetType.h>
#include <aws/ec2/model/FlexibleEnaQueuesSupport.h>
#include <aws/ec2/model/FlowLog.h>
#include <aws/ec2/model/FlowLogsResourceType.h>
#include <aws/ec2/model/FpgaDeviceInfo.h>
#include <aws/ec2/model/FpgaDeviceMemoryInfo.h>
#include <aws/ec2/model/FpgaImage.h>
#include <aws/ec2/model/FpgaImageAttribute.h>
#include <aws/ec2/model/FpgaImageAttributeName.h>
#include <aws/ec2/model/FpgaImageState.h>
#include <aws/ec2/model/FpgaImageStateCode.h>
#include <aws/ec2/model/FpgaInfo.h>
#include <aws/ec2/model/GatewayAssociationState.h>
#include <aws/ec2/model/GatewayType.h>
#include <aws/ec2/model/GetActiveVpnTunnelStatusRequest.h>
#include <aws/ec2/model/GetActiveVpnTunnelStatusResponse.h>
#include <aws/ec2/model/GetAllowedImagesSettingsRequest.h>
#include <aws/ec2/model/GetAllowedImagesSettingsResponse.h>
#include <aws/ec2/model/GetAssociatedEnclaveCertificateIamRolesRequest.h>
#include <aws/ec2/model/GetAssociatedEnclaveCertificateIamRolesResponse.h>
#include <aws/ec2/model/GetAssociatedIpv6PoolCidrsRequest.h>
#include <aws/ec2/model/GetAssociatedIpv6PoolCidrsResponse.h>
#include <aws/ec2/model/GetAwsNetworkPerformanceDataRequest.h>
#include <aws/ec2/model/GetAwsNetworkPerformanceDataResponse.h>
#include <aws/ec2/model/GetCapacityReservationUsageRequest.h>
#include <aws/ec2/model/GetCapacityReservationUsageResponse.h>
#include <aws/ec2/model/GetCoipPoolUsageRequest.h>
#include <aws/ec2/model/GetCoipPoolUsageResponse.h>
#include <aws/ec2/model/GetConsoleOutputRequest.h>
#include <aws/ec2/model/GetConsoleOutputResponse.h>
#include <aws/ec2/model/GetConsoleScreenshotRequest.h>
#include <aws/ec2/model/GetConsoleScreenshotResponse.h>
#include <aws/ec2/model/GetDeclarativePoliciesReportSummaryRequest.h>
#include <aws/ec2/model/GetDeclarativePoliciesReportSummaryResponse.h>
#include <aws/ec2/model/GetDefaultCreditSpecificationRequest.h>
#include <aws/ec2/model/GetDefaultCreditSpecificationResponse.h>
#include <aws/ec2/model/GetEbsDefaultKmsKeyIdRequest.h>
#include <aws/ec2/model/GetEbsDefaultKmsKeyIdResponse.h>
#include <aws/ec2/model/GetEbsEncryptionByDefaultRequest.h>
#include <aws/ec2/model/GetEbsEncryptionByDefaultResponse.h>
#include <aws/ec2/model/GetFlowLogsIntegrationTemplateRequest.h>
#include <aws/ec2/model/GetFlowLogsIntegrationTemplateResponse.h>
#include <aws/ec2/model/GetGroupsForCapacityReservationRequest.h>
#include <aws/ec2/model/GetGroupsForCapacityReservationResponse.h>
#include <aws/ec2/model/GetHostReservationPurchasePreviewRequest.h>
#include <aws/ec2/model/GetHostReservationPurchasePreviewResponse.h>
#include <aws/ec2/model/GetImageBlockPublicAccessStateRequest.h>
#include <aws/ec2/model/GetImageBlockPublicAccessStateResponse.h>
#include <aws/ec2/model/GetInstanceMetadataDefaultsRequest.h>
#include <aws/ec2/model/GetInstanceMetadataDefaultsResponse.h>
#include <aws/ec2/model/GetInstanceTpmEkPubRequest.h>
#include <aws/ec2/model/GetInstanceTpmEkPubResponse.h>
#include <aws/ec2/model/GetInstanceTypesFromInstanceRequirementsRequest.h>
#include <aws/ec2/model/GetInstanceTypesFromInstanceRequirementsResponse.h>
#include <aws/ec2/model/GetInstanceUefiDataRequest.h>
#include <aws/ec2/model/GetInstanceUefiDataResponse.h>
#include <aws/ec2/model/GetIpamAddressHistoryRequest.h>
#include <aws/ec2/model/GetIpamAddressHistoryResponse.h>
#include <aws/ec2/model/GetIpamDiscoveredAccountsRequest.h>
#include <aws/ec2/model/GetIpamDiscoveredAccountsResponse.h>
#include <aws/ec2/model/GetIpamDiscoveredPublicAddressesRequest.h>
#include <aws/ec2/model/GetIpamDiscoveredPublicAddressesResponse.h>
#include <aws/ec2/model/GetIpamDiscoveredResourceCidrsRequest.h>
#include <aws/ec2/model/GetIpamDiscoveredResourceCidrsResponse.h>
#include <aws/ec2/model/GetIpamPoolAllocationsRequest.h>
#include <aws/ec2/model/GetIpamPoolAllocationsResponse.h>
#include <aws/ec2/model/GetIpamPoolCidrsRequest.h>
#include <aws/ec2/model/GetIpamPoolCidrsResponse.h>
#include <aws/ec2/model/GetIpamResourceCidrsRequest.h>
#include <aws/ec2/model/GetIpamResourceCidrsResponse.h>
#include <aws/ec2/model/GetLaunchTemplateDataRequest.h>
#include <aws/ec2/model/GetLaunchTemplateDataResponse.h>
#include <aws/ec2/model/GetManagedPrefixListAssociationsRequest.h>
#include <aws/ec2/model/GetManagedPrefixListAssociationsResponse.h>
#include <aws/ec2/model/GetManagedPrefixListEntriesRequest.h>
#include <aws/ec2/model/GetManagedPrefixListEntriesResponse.h>
#include <aws/ec2/model/GetNetworkInsightsAccessScopeAnalysisFindingsRequest.h>
#include <aws/ec2/model/GetNetworkInsightsAccessScopeAnalysisFindingsResponse.h>
#include <aws/ec2/model/GetNetworkInsightsAccessScopeContentRequest.h>
#include <aws/ec2/model/GetNetworkInsightsAccessScopeContentResponse.h>
#include <aws/ec2/model/GetPasswordDataRequest.h>
#include <aws/ec2/model/GetPasswordDataResponse.h>
#include <aws/ec2/model/GetReservedInstancesExchangeQuoteRequest.h>
#include <aws/ec2/model/GetReservedInstancesExchangeQuoteResponse.h>
#include <aws/ec2/model/GetRouteServerAssociationsRequest.h>
#include <aws/ec2/model/GetRouteServerAssociationsResponse.h>
#include <aws/ec2/model/GetRouteServerPropagationsRequest.h>
#include <aws/ec2/model/GetRouteServerPropagationsResponse.h>
#include <aws/ec2/model/GetRouteServerRoutingDatabaseRequest.h>
#include <aws/ec2/model/GetRouteServerRoutingDatabaseResponse.h>
#include <aws/ec2/model/GetSecurityGroupsForVpcRequest.h>
#include <aws/ec2/model/GetSecurityGroupsForVpcResponse.h>
#include <aws/ec2/model/GetSerialConsoleAccessStatusRequest.h>
#include <aws/ec2/model/GetSerialConsoleAccessStatusResponse.h>
#include <aws/ec2/model/GetSnapshotBlockPublicAccessStateRequest.h>
#include <aws/ec2/model/GetSnapshotBlockPublicAccessStateResponse.h>
#include <aws/ec2/model/GetSpotPlacementScoresRequest.h>
#include <aws/ec2/model/GetSpotPlacementScoresResponse.h>
#include <aws/ec2/model/GetSubnetCidrReservationsRequest.h>
#include <aws/ec2/model/GetSubnetCidrReservationsResponse.h>
#include <aws/ec2/model/GetTransitGatewayAttachmentPropagationsRequest.h>
#include <aws/ec2/model/GetTransitGatewayAttachmentPropagationsResponse.h>
#include <aws/ec2/model/GetTransitGatewayMulticastDomainAssociationsRequest.h>
#include <aws/ec2/model/GetTransitGatewayMulticastDomainAssociationsResponse.h>
#include <aws/ec2/model/GetTransitGatewayPolicyTableAssociationsRequest.h>
#include <aws/ec2/model/GetTransitGatewayPolicyTableAssociationsResponse.h>
#include <aws/ec2/model/GetTransitGatewayPolicyTableEntriesRequest.h>
#include <aws/ec2/model/GetTransitGatewayPolicyTableEntriesResponse.h>
#include <aws/ec2/model/GetTransitGatewayPrefixListReferencesRequest.h>
#include <aws/ec2/model/GetTransitGatewayPrefixListReferencesResponse.h>
#include <aws/ec2/model/GetTransitGatewayRouteTableAssociationsRequest.h>
#include <aws/ec2/model/GetTransitGatewayRouteTableAssociationsResponse.h>
#include <aws/ec2/model/GetTransitGatewayRouteTablePropagationsRequest.h>
#include <aws/ec2/model/GetTransitGatewayRouteTablePropagationsResponse.h>
#include <aws/ec2/model/GetVerifiedAccessEndpointPolicyRequest.h>
#include <aws/ec2/model/GetVerifiedAccessEndpointPolicyResponse.h>
#include <aws/ec2/model/GetVerifiedAccessEndpointTargetsRequest.h>
#include <aws/ec2/model/GetVerifiedAccessEndpointTargetsResponse.h>
#include <aws/ec2/model/GetVerifiedAccessGroupPolicyRequest.h>
#include <aws/ec2/model/GetVerifiedAccessGroupPolicyResponse.h>
#include <aws/ec2/model/GetVpnConnectionDeviceSampleConfigurationRequest.h>
#include <aws/ec2/model/GetVpnConnectionDeviceSampleConfigurationResponse.h>
#include <aws/ec2/model/GetVpnConnectionDeviceTypesRequest.h>
#include <aws/ec2/model/GetVpnConnectionDeviceTypesResponse.h>
#include <aws/ec2/model/GetVpnTunnelReplacementStatusRequest.h>
#include <aws/ec2/model/GetVpnTunnelReplacementStatusResponse.h>
#include <aws/ec2/model/GpuDeviceInfo.h>
#include <aws/ec2/model/GpuDeviceMemoryInfo.h>
#include <aws/ec2/model/GpuInfo.h>
#include <aws/ec2/model/GroupIdentifier.h>
#include <aws/ec2/model/HibernationOptions.h>
#include <aws/ec2/model/HibernationOptionsRequest.h>
#include <aws/ec2/model/HistoryRecord.h>
#include <aws/ec2/model/HistoryRecordEntry.h>
#include <aws/ec2/model/Host.h>
#include <aws/ec2/model/HostInstance.h>
#include <aws/ec2/model/HostMaintenance.h>
#include <aws/ec2/model/HostOffering.h>
#include <aws/ec2/model/HostProperties.h>
#include <aws/ec2/model/HostRecovery.h>
#include <aws/ec2/model/HostReservation.h>
#include <aws/ec2/model/HostTenancy.h>
#include <aws/ec2/model/HostnameType.h>
#include <aws/ec2/model/HttpTokensState.h>
#include <aws/ec2/model/HypervisorType.h>
#include <aws/ec2/model/IKEVersionsListValue.h>
#include <aws/ec2/model/IKEVersionsRequestListValue.h>
#include <aws/ec2/model/IamInstanceProfile.h>
#include <aws/ec2/model/IamInstanceProfileAssociation.h>
#include <aws/ec2/model/IamInstanceProfileAssociationState.h>
#include <aws/ec2/model/IamInstanceProfileSpecification.h>
#include <aws/ec2/model/IcmpTypeCode.h>
#include <aws/ec2/model/IdFormat.h>
#include <aws/ec2/model/Igmpv2SupportValue.h>
#include <aws/ec2/model/Image.h>
#include <aws/ec2/model/ImageAttributeName.h>
#include <aws/ec2/model/ImageBlockPublicAccessDisabledState.h>
#include <aws/ec2/model/ImageBlockPublicAccessEnabledState.h>
#include <aws/ec2/model/ImageCriterion.h>
#include <aws/ec2/model/ImageCriterionRequest.h>
#include <aws/ec2/model/ImageDiskContainer.h>
#include <aws/ec2/model/ImageMetadata.h>
#include <aws/ec2/model/ImageRecycleBinInfo.h>
#include <aws/ec2/model/ImageState.h>
#include <aws/ec2/model/ImageTypeValues.h>
#include <aws/ec2/model/ImdsSupportValues.h>
#include <aws/ec2/model/ImportClientVpnClientCertificateRevocationListRequest.h>
#include <aws/ec2/model/ImportClientVpnClientCertificateRevocationListResponse.h>
#include <aws/ec2/model/ImportImageLicenseConfigurationRequest.h>
#include <aws/ec2/model/ImportImageLicenseConfigurationResponse.h>
#include <aws/ec2/model/ImportImageRequest.h>
#include <aws/ec2/model/ImportImageResponse.h>
#include <aws/ec2/model/ImportImageTask.h>
#include <aws/ec2/model/ImportInstanceLaunchSpecification.h>
#include <aws/ec2/model/ImportInstanceRequest.h>
#include <aws/ec2/model/ImportInstanceResponse.h>
#include <aws/ec2/model/ImportInstanceTaskDetails.h>
#include <aws/ec2/model/ImportInstanceVolumeDetailItem.h>
#include <aws/ec2/model/ImportKeyPairRequest.h>
#include <aws/ec2/model/ImportKeyPairResponse.h>
#include <aws/ec2/model/ImportSnapshotRequest.h>
#include <aws/ec2/model/ImportSnapshotResponse.h>
#include <aws/ec2/model/ImportSnapshotTask.h>
#include <aws/ec2/model/ImportVolumeRequest.h>
#include <aws/ec2/model/ImportVolumeResponse.h>
#include <aws/ec2/model/ImportVolumeTaskDetails.h>
#include <aws/ec2/model/InferenceAcceleratorInfo.h>
#include <aws/ec2/model/InferenceDeviceInfo.h>
#include <aws/ec2/model/InferenceDeviceMemoryInfo.h>
#include <aws/ec2/model/Instance.h>
#include <aws/ec2/model/InstanceAttachmentEnaSrdSpecification.h>
#include <aws/ec2/model/InstanceAttachmentEnaSrdUdpSpecification.h>
#include <aws/ec2/model/InstanceAttributeName.h>
#include <aws/ec2/model/InstanceAutoRecoveryState.h>
#include <aws/ec2/model/InstanceBandwidthWeighting.h>
#include <aws/ec2/model/InstanceBlockDeviceMapping.h>
#include <aws/ec2/model/InstanceBlockDeviceMappingSpecification.h>
#include <aws/ec2/model/InstanceBootModeValues.h>
#include <aws/ec2/model/InstanceCapacity.h>
#include <aws/ec2/model/InstanceCount.h>
#include <aws/ec2/model/InstanceCreditSpecification.h>
#include <aws/ec2/model/InstanceCreditSpecificationRequest.h>
#include <aws/ec2/model/InstanceEventWindow.h>
#include <aws/ec2/model/InstanceEventWindowAssociationRequest.h>
#include <aws/ec2/model/InstanceEventWindowAssociationTarget.h>
#include <aws/ec2/model/InstanceEventWindowDisassociationRequest.h>
#include <aws/ec2/model/InstanceEventWindowState.h>
#include <aws/ec2/model/InstanceEventWindowStateChange.h>
#include <aws/ec2/model/InstanceEventWindowTimeRange.h>
#include <aws/ec2/model/InstanceEventWindowTimeRangeRequest.h>
#include <aws/ec2/model/InstanceExportDetails.h>
#include <aws/ec2/model/InstanceFamilyCreditSpecification.h>
#include <aws/ec2/model/InstanceGeneration.h>
#include <aws/ec2/model/InstanceHealthStatus.h>
#include <aws/ec2/model/InstanceImageMetadata.h>
#include <aws/ec2/model/InstanceInterruptionBehavior.h>
#include <aws/ec2/model/InstanceIpv4Prefix.h>
#include <aws/ec2/model/InstanceIpv6Address.h>
#include <aws/ec2/model/InstanceIpv6AddressRequest.h>
#include <aws/ec2/model/InstanceIpv6Prefix.h>
#include <aws/ec2/model/InstanceLifecycle.h>
#include <aws/ec2/model/InstanceLifecycleType.h>
#include <aws/ec2/model/InstanceMaintenanceOptions.h>
#include <aws/ec2/model/InstanceMaintenanceOptionsRequest.h>
#include <aws/ec2/model/InstanceMarketOptionsRequest.h>
#include <aws/ec2/model/InstanceMatchCriteria.h>
#include <aws/ec2/model/InstanceMetadataDefaultsResponse.h>
#include <aws/ec2/model/InstanceMetadataEndpointState.h>
#include <aws/ec2/model/InstanceMetadataOptionsRequest.h>
#include <aws/ec2/model/InstanceMetadataOptionsResponse.h>
#include <aws/ec2/model/InstanceMetadataOptionsState.h>
#include <aws/ec2/model/InstanceMetadataProtocolState.h>
#include <aws/ec2/model/InstanceMetadataTagsState.h>
#include <aws/ec2/model/InstanceMonitoring.h>
#include <aws/ec2/model/InstanceNetworkInterface.h>
#include <aws/ec2/model/InstanceNetworkInterfaceAssociation.h>
#include <aws/ec2/model/InstanceNetworkInterfaceAttachment.h>
#include <aws/ec2/model/InstanceNetworkInterfaceSpecification.h>
#include <aws/ec2/model/InstanceNetworkPerformanceOptions.h>
#include <aws/ec2/model/InstanceNetworkPerformanceOptionsRequest.h>
#include <aws/ec2/model/InstancePrivateIpAddress.h>
#include <aws/ec2/model/InstanceRebootMigrationState.h>
#include <aws/ec2/model/InstanceRequirements.h>
#include <aws/ec2/model/InstanceRequirementsRequest.h>
#include <aws/ec2/model/InstanceRequirementsWithMetadataRequest.h>
#include <aws/ec2/model/InstanceSpecification.h>
#include <aws/ec2/model/InstanceState.h>
#include <aws/ec2/model/InstanceStateChange.h>
#include <aws/ec2/model/InstanceStateName.h>
#include <aws/ec2/model/InstanceStatus.h>
#include <aws/ec2/model/InstanceStatusDetails.h>
#include <aws/ec2/model/InstanceStatusEvent.h>
#include <aws/ec2/model/InstanceStatusSummary.h>
#include <aws/ec2/model/InstanceStorageEncryptionSupport.h>
#include <aws/ec2/model/InstanceStorageInfo.h>
#include <aws/ec2/model/InstanceTagNotificationAttribute.h>
#include <aws/ec2/model/InstanceTopology.h>
#include <aws/ec2/model/InstanceType.h>
#include <aws/ec2/model/InstanceTypeHypervisor.h>
#include <aws/ec2/model/InstanceTypeInfo.h>
#include <aws/ec2/model/InstanceTypeInfoFromInstanceRequirements.h>
#include <aws/ec2/model/InstanceTypeOffering.h>
#include <aws/ec2/model/InstanceUsage.h>
#include <aws/ec2/model/IntegrateServices.h>
#include <aws/ec2/model/InterfacePermissionType.h>
#include <aws/ec2/model/InterfaceProtocolType.h>
#include <aws/ec2/model/InternetGateway.h>
#include <aws/ec2/model/InternetGatewayAttachment.h>
#include <aws/ec2/model/InternetGatewayBlockMode.h>
#include <aws/ec2/model/InternetGatewayExclusionMode.h>
#include <aws/ec2/model/IpAddressType.h>
#include <aws/ec2/model/IpPermission.h>
#include <aws/ec2/model/IpRange.h>
#include <aws/ec2/model/IpSource.h>
#include <aws/ec2/model/Ipam.h>
#include <aws/ec2/model/IpamAddressHistoryRecord.h>
#include <aws/ec2/model/IpamAddressHistoryResourceType.h>
#include <aws/ec2/model/IpamAssociatedResourceDiscoveryStatus.h>
#include <aws/ec2/model/IpamCidrAuthorizationContext.h>
#include <aws/ec2/model/IpamComplianceStatus.h>
#include <aws/ec2/model/IpamDiscoveredAccount.h>
#include <aws/ec2/model/IpamDiscoveredPublicAddress.h>
#include <aws/ec2/model/IpamDiscoveredResourceCidr.h>
#include <aws/ec2/model/IpamDiscoveryFailureCode.h>
#include <aws/ec2/model/IpamDiscoveryFailureReason.h>
#include <aws/ec2/model/IpamExternalResourceVerificationToken.h>
#include <aws/ec2/model/IpamExternalResourceVerificationTokenState.h>
#include <aws/ec2/model/IpamManagementState.h>
#include <aws/ec2/model/IpamMeteredAccount.h>
#include <aws/ec2/model/IpamNetworkInterfaceAttachmentStatus.h>
#include <aws/ec2/model/IpamOperatingRegion.h>
#include <aws/ec2/model/IpamOrganizationalUnitExclusion.h>
#include <aws/ec2/model/IpamOverlapStatus.h>
#include <aws/ec2/model/IpamPool.h>
#include <aws/ec2/model/IpamPoolAllocation.h>
#include <aws/ec2/model/IpamPoolAllocationResourceType.h>
#include <aws/ec2/model/IpamPoolAwsService.h>
#include <aws/ec2/model/IpamPoolCidr.h>
#include <aws/ec2/model/IpamPoolCidrFailureCode.h>
#include <aws/ec2/model/IpamPoolCidrFailureReason.h>
#include <aws/ec2/model/IpamPoolCidrState.h>
#include <aws/ec2/model/IpamPoolPublicIpSource.h>
#include <aws/ec2/model/IpamPoolSourceResource.h>
#include <aws/ec2/model/IpamPoolSourceResourceRequest.h>
#include <aws/ec2/model/IpamPoolSourceResourceType.h>
#include <aws/ec2/model/IpamPoolState.h>
#include <aws/ec2/model/IpamPublicAddressAssociationStatus.h>
#include <aws/ec2/model/IpamPublicAddressAwsService.h>
#include <aws/ec2/model/IpamPublicAddressSecurityGroup.h>
#include <aws/ec2/model/IpamPublicAddressTag.h>
#include <aws/ec2/model/IpamPublicAddressTags.h>
#include <aws/ec2/model/IpamPublicAddressType.h>
#include <aws/ec2/model/IpamResourceCidr.h>
#include <aws/ec2/model/IpamResourceCidrIpSource.h>
#include <aws/ec2/model/IpamResourceDiscovery.h>
#include <aws/ec2/model/IpamResourceDiscoveryAssociation.h>
#include <aws/ec2/model/IpamResourceDiscoveryAssociationState.h>
#include <aws/ec2/model/IpamResourceDiscoveryState.h>
#include <aws/ec2/model/IpamResourceTag.h>
#include <aws/ec2/model/IpamResourceType.h>
#include <aws/ec2/model/IpamScope.h>
#include <aws/ec2/model/IpamScopeState.h>
#include <aws/ec2/model/IpamScopeType.h>
#include <aws/ec2/model/IpamState.h>
#include <aws/ec2/model/IpamTier.h>
#include <aws/ec2/model/Ipv4PrefixSpecification.h>
#include <aws/ec2/model/Ipv4PrefixSpecificationRequest.h>
#include <aws/ec2/model/Ipv4PrefixSpecificationResponse.h>
#include <aws/ec2/model/Ipv6AddressAttribute.h>
#include <aws/ec2/model/Ipv6CidrAssociation.h>
#include <aws/ec2/model/Ipv6CidrBlock.h>
#include <aws/ec2/model/Ipv6Pool.h>
#include <aws/ec2/model/Ipv6PrefixSpecification.h>
#include <aws/ec2/model/Ipv6PrefixSpecificationRequest.h>
#include <aws/ec2/model/Ipv6PrefixSpecificationResponse.h>
#include <aws/ec2/model/Ipv6Range.h>
#include <aws/ec2/model/Ipv6SupportValue.h>
#include <aws/ec2/model/KeyFormat.h>
#include <aws/ec2/model/KeyPairInfo.h>
#include <aws/ec2/model/KeyType.h>
#include <aws/ec2/model/LastError.h>
#include <aws/ec2/model/LaunchPermission.h>
#include <aws/ec2/model/LaunchPermissionModifications.h>
#include <aws/ec2/model/LaunchSpecification.h>
#include <aws/ec2/model/LaunchTemplate.h>
#include <aws/ec2/model/LaunchTemplateAndOverridesResponse.h>
#include <aws/ec2/model/LaunchTemplateAutoRecoveryState.h>
#include <aws/ec2/model/LaunchTemplateBlockDeviceMapping.h>
#include <aws/ec2/model/LaunchTemplateBlockDeviceMappingRequest.h>
#include <aws/ec2/model/LaunchTemplateCapacityReservationSpecificationRequest.h>
#include <aws/ec2/model/LaunchTemplateCapacityReservationSpecificationResponse.h>
#include <aws/ec2/model/LaunchTemplateConfig.h>
#include <aws/ec2/model/LaunchTemplateCpuOptions.h>
#include <aws/ec2/model/LaunchTemplateCpuOptionsRequest.h>
#include <aws/ec2/model/LaunchTemplateEbsBlockDevice.h>
#include <aws/ec2/model/LaunchTemplateEbsBlockDeviceRequest.h>
#include <aws/ec2/model/LaunchTemplateElasticInferenceAccelerator.h>
#include <aws/ec2/model/LaunchTemplateElasticInferenceAcceleratorResponse.h>
#include <aws/ec2/model/LaunchTemplateEnaSrdSpecification.h>
#include <aws/ec2/model/LaunchTemplateEnaSrdUdpSpecification.h>
#include <aws/ec2/model/LaunchTemplateEnclaveOptions.h>
#include <aws/ec2/model/LaunchTemplateEnclaveOptionsRequest.h>
#include <aws/ec2/model/LaunchTemplateErrorCode.h>
#include <aws/ec2/model/LaunchTemplateHibernationOptions.h>
#include <aws/ec2/model/LaunchTemplateHibernationOptionsRequest.h>
#include <aws/ec2/model/LaunchTemplateHttpTokensState.h>
#include <aws/ec2/model/LaunchTemplateIamInstanceProfileSpecification.h>
#include <aws/ec2/model/LaunchTemplateIamInstanceProfileSpecificationRequest.h>
#include <aws/ec2/model/LaunchTemplateInstanceMaintenanceOptions.h>
#include <aws/ec2/model/LaunchTemplateInstanceMaintenanceOptionsRequest.h>
#include <aws/ec2/model/LaunchTemplateInstanceMarketOptions.h>
#include <aws/ec2/model/LaunchTemplateInstanceMarketOptionsRequest.h>
#include <aws/ec2/model/LaunchTemplateInstanceMetadataEndpointState.h>
#include <aws/ec2/model/LaunchTemplateInstanceMetadataOptions.h>
#include <aws/ec2/model/LaunchTemplateInstanceMetadataOptionsRequest.h>
#include <aws/ec2/model/LaunchTemplateInstanceMetadataOptionsState.h>
#include <aws/ec2/model/LaunchTemplateInstanceMetadataProtocolIpv6.h>
#include <aws/ec2/model/LaunchTemplateInstanceMetadataTagsState.h>
#include <aws/ec2/model/LaunchTemplateInstanceNetworkInterfaceSpecification.h>
#include <aws/ec2/model/LaunchTemplateInstanceNetworkInterfaceSpecificationRequest.h>
#include <aws/ec2/model/LaunchTemplateLicenseConfiguration.h>
#include <aws/ec2/model/LaunchTemplateLicenseConfigurationRequest.h>
#include <aws/ec2/model/LaunchTemplateNetworkPerformanceOptions.h>
#include <aws/ec2/model/LaunchTemplateNetworkPerformanceOptionsRequest.h>
#include <aws/ec2/model/LaunchTemplateOverrides.h>
#include <aws/ec2/model/LaunchTemplatePlacement.h>
#include <aws/ec2/model/LaunchTemplatePlacementRequest.h>
#include <aws/ec2/model/LaunchTemplatePrivateDnsNameOptions.h>
#include <aws/ec2/model/LaunchTemplatePrivateDnsNameOptionsRequest.h>
#include <aws/ec2/model/LaunchTemplateSpecification.h>
#include <aws/ec2/model/LaunchTemplateSpotMarketOptions.h>
#include <aws/ec2/model/LaunchTemplateSpotMarketOptionsRequest.h>
#include <aws/ec2/model/LaunchTemplateTagSpecification.h>
#include <aws/ec2/model/LaunchTemplateTagSpecificationRequest.h>
#include <aws/ec2/model/LaunchTemplateVersion.h>
#include <aws/ec2/model/LaunchTemplatesMonitoring.h>
#include <aws/ec2/model/LaunchTemplatesMonitoringRequest.h>
#include <aws/ec2/model/LicenseConfiguration.h>
#include <aws/ec2/model/LicenseConfigurationRequest.h>
#include <aws/ec2/model/ListImagesInRecycleBinRequest.h>
#include <aws/ec2/model/ListImagesInRecycleBinResponse.h>
#include <aws/ec2/model/ListSnapshotsInRecycleBinRequest.h>
#include <aws/ec2/model/ListSnapshotsInRecycleBinResponse.h>
#include <aws/ec2/model/ListingState.h>
#include <aws/ec2/model/ListingStatus.h>
#include <aws/ec2/model/LoadBalancersConfig.h>
#include <aws/ec2/model/LoadPermission.h>
#include <aws/ec2/model/LoadPermissionModifications.h>
#include <aws/ec2/model/LoadPermissionRequest.h>
#include <aws/ec2/model/LocalGateway.h>
#include <aws/ec2/model/LocalGatewayRoute.h>
#include <aws/ec2/model/LocalGatewayRouteState.h>
#include <aws/ec2/model/LocalGatewayRouteTable.h>
#include <aws/ec2/model/LocalGatewayRouteTableMode.h>
#include <aws/ec2/model/LocalGatewayRouteTableVirtualInterfaceGroupAssociation.h>
#include <aws/ec2/model/LocalGatewayRouteTableVpcAssociation.h>
#include <aws/ec2/model/LocalGatewayRouteType.h>
#include <aws/ec2/model/LocalGatewayVirtualInterface.h>
#include <aws/ec2/model/LocalGatewayVirtualInterfaceConfigurationState.h>
#include <aws/ec2/model/LocalGatewayVirtualInterfaceGroup.h>
#include <aws/ec2/model/LocalGatewayVirtualInterfaceGroupConfigurationState.h>
#include <aws/ec2/model/LocalStorage.h>
#include <aws/ec2/model/LocalStorageType.h>
#include <aws/ec2/model/LocationType.h>
#include <aws/ec2/model/LockMode.h>
#include <aws/ec2/model/LockSnapshotRequest.h>
#include <aws/ec2/model/LockSnapshotResponse.h>
#include <aws/ec2/model/LockState.h>
#include <aws/ec2/model/LockedSnapshotsInfo.h>
#include <aws/ec2/model/LogDestinationType.h>
#include <aws/ec2/model/MacHost.h>
#include <aws/ec2/model/MacModificationTask.h>
#include <aws/ec2/model/MacModificationTaskState.h>
#include <aws/ec2/model/MacModificationTaskType.h>
#include <aws/ec2/model/MacSystemIntegrityProtectionConfiguration.h>
#include <aws/ec2/model/MacSystemIntegrityProtectionConfigurationRequest.h>
#include <aws/ec2/model/MacSystemIntegrityProtectionSettingStatus.h>
#include <aws/ec2/model/MaintenanceDetails.h>
#include <aws/ec2/model/ManagedBy.h>
#include <aws/ec2/model/ManagedPrefixList.h>
#include <aws/ec2/model/MarketType.h>
#include <aws/ec2/model/MediaAcceleratorInfo.h>
#include <aws/ec2/model/MediaDeviceInfo.h>
#include <aws/ec2/model/MediaDeviceMemoryInfo.h>
#include <aws/ec2/model/MembershipType.h>
#include <aws/ec2/model/MemoryGiBPerVCpu.h>
#include <aws/ec2/model/MemoryGiBPerVCpuRequest.h>
#include <aws/ec2/model/MemoryInfo.h>
#include <aws/ec2/model/MemoryMiB.h>
#include <aws/ec2/model/MemoryMiBRequest.h>
#include <aws/ec2/model/MetadataDefaultHttpTokensState.h>
#include <aws/ec2/model/MetricPoint.h>
#include <aws/ec2/model/MetricType.h>
#include <aws/ec2/model/ModifyAddressAttributeRequest.h>
#include <aws/ec2/model/ModifyAddressAttributeResponse.h>
#include <aws/ec2/model/ModifyAvailabilityZoneGroupRequest.h>
#include <aws/ec2/model/ModifyAvailabilityZoneGroupResponse.h>
#include <aws/ec2/model/ModifyAvailabilityZoneOptInStatus.h>
#include <aws/ec2/model/ModifyCapacityReservationFleetRequest.h>
#include <aws/ec2/model/ModifyCapacityReservationFleetResponse.h>
#include <aws/ec2/model/ModifyCapacityReservationRequest.h>
#include <aws/ec2/model/ModifyCapacityReservationResponse.h>
#include <aws/ec2/model/ModifyClientVpnEndpointRequest.h>
#include <aws/ec2/model/ModifyClientVpnEndpointResponse.h>
#include <aws/ec2/model/ModifyDefaultCreditSpecificationRequest.h>
#include <aws/ec2/model/ModifyDefaultCreditSpecificationResponse.h>
#include <aws/ec2/model/ModifyEbsDefaultKmsKeyIdRequest.h>
#include <aws/ec2/model/ModifyEbsDefaultKmsKeyIdResponse.h>
#include <aws/ec2/model/ModifyFleetRequest.h>
#include <aws/ec2/model/ModifyFleetResponse.h>
#include <aws/ec2/model/ModifyFpgaImageAttributeRequest.h>
#include <aws/ec2/model/ModifyFpgaImageAttributeResponse.h>
#include <aws/ec2/model/ModifyHostsRequest.h>
#include <aws/ec2/model/ModifyHostsResponse.h>
#include <aws/ec2/model/ModifyIdFormatRequest.h>
#include <aws/ec2/model/ModifyIdentityIdFormatRequest.h>
#include <aws/ec2/model/ModifyImageAttributeRequest.h>
#include <aws/ec2/model/ModifyInstanceAttributeRequest.h>
#include <aws/ec2/model/ModifyInstanceCapacityReservationAttributesRequest.h>
#include <aws/ec2/model/ModifyInstanceCapacityReservationAttributesResponse.h>
#include <aws/ec2/model/ModifyInstanceCpuOptionsRequest.h>
#include <aws/ec2/model/ModifyInstanceCpuOptionsResponse.h>
#include <aws/ec2/model/ModifyInstanceCreditSpecificationRequest.h>
#include <aws/ec2/model/ModifyInstanceCreditSpecificationResponse.h>
#include <aws/ec2/model/ModifyInstanceEventStartTimeRequest.h>
#include <aws/ec2/model/ModifyInstanceEventStartTimeResponse.h>
#include <aws/ec2/model/ModifyInstanceEventWindowRequest.h>
#include <aws/ec2/model/ModifyInstanceEventWindowResponse.h>
#include <aws/ec2/model/ModifyInstanceMaintenanceOptionsRequest.h>
#include <aws/ec2/model/ModifyInstanceMaintenanceOptionsResponse.h>
#include <aws/ec2/model/ModifyInstanceMetadataDefaultsRequest.h>
#include <aws/ec2/model/ModifyInstanceMetadataDefaultsResponse.h>
#include <aws/ec2/model/ModifyInstanceMetadataOptionsRequest.h>
#include <aws/ec2/model/ModifyInstanceMetadataOptionsResponse.h>
#include <aws/ec2/model/ModifyInstanceNetworkPerformanceOptionsRequest.h>
#include <aws/ec2/model/ModifyInstanceNetworkPerformanceOptionsResponse.h>
#include <aws/ec2/model/ModifyInstancePlacementRequest.h>
#include <aws/ec2/model/ModifyInstancePlacementResponse.h>
#include <aws/ec2/model/ModifyIpamPoolRequest.h>
#include <aws/ec2/model/ModifyIpamPoolResponse.h>
#include <aws/ec2/model/ModifyIpamRequest.h>
#include <aws/ec2/model/ModifyIpamResourceCidrRequest.h>
#include <aws/ec2/model/ModifyIpamResourceCidrResponse.h>
#include <aws/ec2/model/ModifyIpamResourceDiscoveryRequest.h>
#include <aws/ec2/model/ModifyIpamResourceDiscoveryResponse.h>
#include <aws/ec2/model/ModifyIpamResponse.h>
#include <aws/ec2/model/ModifyIpamScopeRequest.h>
#include <aws/ec2/model/ModifyIpamScopeResponse.h>
#include <aws/ec2/model/ModifyLaunchTemplateRequest.h>
#include <aws/ec2/model/ModifyLaunchTemplateResponse.h>
#include <aws/ec2/model/ModifyLocalGatewayRouteRequest.h>
#include <aws/ec2/model/ModifyLocalGatewayRouteResponse.h>
#include <aws/ec2/model/ModifyManagedPrefixListRequest.h>
#include <aws/ec2/model/ModifyManagedPrefixListResponse.h>
#include <aws/ec2/model/ModifyNetworkInterfaceAttributeRequest.h>
#include <aws/ec2/model/ModifyPrivateDnsNameOptionsRequest.h>
#include <aws/ec2/model/ModifyPrivateDnsNameOptionsResponse.h>
#include <aws/ec2/model/ModifyPublicIpDnsNameOptionsRequest.h>
#include <aws/ec2/model/ModifyPublicIpDnsNameOptionsResponse.h>
#include <aws/ec2/model/ModifyReservedInstancesRequest.h>
#include <aws/ec2/model/ModifyReservedInstancesResponse.h>
#include <aws/ec2/model/ModifyRouteServerRequest.h>
#include <aws/ec2/model/ModifyRouteServerResponse.h>
#include <aws/ec2/model/ModifySecurityGroupRulesRequest.h>
#include <aws/ec2/model/ModifySecurityGroupRulesResponse.h>
#include <aws/ec2/model/ModifySnapshotAttributeRequest.h>
#include <aws/ec2/model/ModifySnapshotTierRequest.h>
#include <aws/ec2/model/ModifySnapshotTierResponse.h>
#include <aws/ec2/model/ModifySpotFleetRequestRequest.h>
#include <aws/ec2/model/ModifySpotFleetRequestResponse.h>
#include <aws/ec2/model/ModifySubnetAttributeRequest.h>
#include <aws/ec2/model/ModifyTrafficMirrorFilterNetworkServicesRequest.h>
#include <aws/ec2/model/ModifyTrafficMirrorFilterNetworkServicesResponse.h>
#include <aws/ec2/model/ModifyTrafficMirrorFilterRuleRequest.h>
#include <aws/ec2/model/ModifyTrafficMirrorFilterRuleResponse.h>
#include <aws/ec2/model/ModifyTrafficMirrorSessionRequest.h>
#include <aws/ec2/model/ModifyTrafficMirrorSessionResponse.h>
#include <aws/ec2/model/ModifyTransitGatewayOptions.h>
#include <aws/ec2/model/ModifyTransitGatewayPrefixListReferenceRequest.h>
#include <aws/ec2/model/ModifyTransitGatewayPrefixListReferenceResponse.h>
#include <aws/ec2/model/ModifyTransitGatewayRequest.h>
#include <aws/ec2/model/ModifyTransitGatewayResponse.h>
#include <aws/ec2/model/ModifyTransitGatewayVpcAttachmentRequest.h>
#include <aws/ec2/model/ModifyTransitGatewayVpcAttachmentRequestOptions.h>
#include <aws/ec2/model/ModifyTransitGatewayVpcAttachmentResponse.h>
#include <aws/ec2/model/ModifyVerifiedAccessEndpointCidrOptions.h>
#include <aws/ec2/model/ModifyVerifiedAccessEndpointEniOptions.h>
#include <aws/ec2/model/ModifyVerifiedAccessEndpointLoadBalancerOptions.h>
#include <aws/ec2/model/ModifyVerifiedAccessEndpointPolicyRequest.h>
#include <aws/ec2/model/ModifyVerifiedAccessEndpointPolicyResponse.h>
#include <aws/ec2/model/ModifyVerifiedAccessEndpointPortRange.h>
#include <aws/ec2/model/ModifyVerifiedAccessEndpointRdsOptions.h>
#include <aws/ec2/model/ModifyVerifiedAccessEndpointRequest.h>
#include <aws/ec2/model/ModifyVerifiedAccessEndpointResponse.h>
#include <aws/ec2/model/ModifyVerifiedAccessGroupPolicyRequest.h>
#include <aws/ec2/model/ModifyVerifiedAccessGroupPolicyResponse.h>
#include <aws/ec2/model/ModifyVerifiedAccessGroupRequest.h>
#include <aws/ec2/model/ModifyVerifiedAccessGroupResponse.h>
#include <aws/ec2/model/ModifyVerifiedAccessInstanceLoggingConfigurationRequest.h>
#include <aws/ec2/model/ModifyVerifiedAccessInstanceLoggingConfigurationResponse.h>
#include <aws/ec2/model/ModifyVerifiedAccessInstanceRequest.h>
#include <aws/ec2/model/ModifyVerifiedAccessInstanceResponse.h>
#include <aws/ec2/model/ModifyVerifiedAccessNativeApplicationOidcOptions.h>
#include <aws/ec2/model/ModifyVerifiedAccessTrustProviderDeviceOptions.h>
#include <aws/ec2/model/ModifyVerifiedAccessTrustProviderOidcOptions.h>
#include <aws/ec2/model/ModifyVerifiedAccessTrustProviderRequest.h>
#include <aws/ec2/model/ModifyVerifiedAccessTrustProviderResponse.h>
#include <aws/ec2/model/ModifyVolumeAttributeRequest.h>
#include <aws/ec2/model/ModifyVolumeRequest.h>
#include <aws/ec2/model/ModifyVolumeResponse.h>
#include <aws/ec2/model/ModifyVpcAttributeRequest.h>
#include <aws/ec2/model/ModifyVpcBlockPublicAccessExclusionRequest.h>
#include <aws/ec2/model/ModifyVpcBlockPublicAccessExclusionResponse.h>
#include <aws/ec2/model/ModifyVpcBlockPublicAccessOptionsRequest.h>
#include <aws/ec2/model/ModifyVpcBlockPublicAccessOptionsResponse.h>
#include <aws/ec2/model/ModifyVpcEndpointConnectionNotificationRequest.h>
#include <aws/ec2/model/ModifyVpcEndpointConnectionNotificationResponse.h>
#include <aws/ec2/model/ModifyVpcEndpointRequest.h>
#include <aws/ec2/model/ModifyVpcEndpointResponse.h>
#include <aws/ec2/model/ModifyVpcEndpointServiceConfigurationRequest.h>
#include <aws/ec2/model/ModifyVpcEndpointServiceConfigurationResponse.h>
#include <aws/ec2/model/ModifyVpcEndpointServicePayerResponsibilityRequest.h>
#include <aws/ec2/model/ModifyVpcEndpointServicePayerResponsibilityResponse.h>
#include <aws/ec2/model/ModifyVpcEndpointServicePermissionsRequest.h>
#include <aws/ec2/model/ModifyVpcEndpointServicePermissionsResponse.h>
#include <aws/ec2/model/ModifyVpcPeeringConnectionOptionsRequest.h>
#include <aws/ec2/model/ModifyVpcPeeringConnectionOptionsResponse.h>
#include <aws/ec2/model/ModifyVpcTenancyRequest.h>
#include <aws/ec2/model/ModifyVpcTenancyResponse.h>
#include <aws/ec2/model/ModifyVpnConnectionOptionsRequest.h>
#include <aws/ec2/model/ModifyVpnConnectionOptionsResponse.h>
#include <aws/ec2/model/ModifyVpnConnectionRequest.h>
#include <aws/ec2/model/ModifyVpnConnectionResponse.h>
#include <aws/ec2/model/ModifyVpnTunnelCertificateRequest.h>
#include <aws/ec2/model/ModifyVpnTunnelCertificateResponse.h>
#include <aws/ec2/model/ModifyVpnTunnelOptionsRequest.h>
#include <aws/ec2/model/ModifyVpnTunnelOptionsResponse.h>
#include <aws/ec2/model/ModifyVpnTunnelOptionsSpecification.h>
#include <aws/ec2/model/MonitorInstancesRequest.h>
#include <aws/ec2/model/MonitorInstancesResponse.h>
#include <aws/ec2/model/Monitoring.h>
#include <aws/ec2/model/MonitoringState.h>
#include <aws/ec2/model/MoveAddressToVpcRequest.h>
#include <aws/ec2/model/MoveAddressToVpcResponse.h>
#include <aws/ec2/model/MoveByoipCidrToIpamRequest.h>
#include <aws/ec2/model/MoveByoipCidrToIpamResponse.h>
#include <aws/ec2/model/MoveCapacityReservationInstancesRequest.h>
#include <aws/ec2/model/MoveCapacityReservationInstancesResponse.h>
#include <aws/ec2/model/MoveStatus.h>
#include <aws/ec2/model/MovingAddressStatus.h>
#include <aws/ec2/model/MulticastSupportValue.h>
#include <aws/ec2/model/NatGateway.h>
#include <aws/ec2/model/NatGatewayAddress.h>
#include <aws/ec2/model/NatGatewayAddressStatus.h>
#include <aws/ec2/model/NatGatewayState.h>
#include <aws/ec2/model/NativeApplicationOidcOptions.h>
#include <aws/ec2/model/NetworkAcl.h>
#include <aws/ec2/model/NetworkAclAssociation.h>
#include <aws/ec2/model/NetworkAclEntry.h>
#include <aws/ec2/model/NetworkBandwidthGbps.h>
#include <aws/ec2/model/NetworkBandwidthGbpsRequest.h>
#include <aws/ec2/model/NetworkCardInfo.h>
#include <aws/ec2/model/NetworkInfo.h>
#include <aws/ec2/model/NetworkInsightsAccessScope.h>
#include <aws/ec2/model/NetworkInsightsAccessScopeAnalysis.h>
#include <aws/ec2/model/NetworkInsightsAccessScopeContent.h>
#include <aws/ec2/model/NetworkInsightsAnalysis.h>
#include <aws/ec2/model/NetworkInsightsPath.h>
#include <aws/ec2/model/NetworkInterface.h>
#include <aws/ec2/model/NetworkInterfaceAssociation.h>
#include <aws/ec2/model/NetworkInterfaceAttachment.h>
#include <aws/ec2/model/NetworkInterfaceAttachmentChanges.h>
#include <aws/ec2/model/NetworkInterfaceAttribute.h>
#include <aws/ec2/model/NetworkInterfaceCount.h>
#include <aws/ec2/model/NetworkInterfaceCountRequest.h>
#include <aws/ec2/model/NetworkInterfaceCreationType.h>
#include <aws/ec2/model/NetworkInterfaceIpv6Address.h>
#include <aws/ec2/model/NetworkInterfacePermission.h>
#include <aws/ec2/model/NetworkInterfacePermissionState.h>
#include <aws/ec2/model/NetworkInterfacePermissionStateCode.h>
#include <aws/ec2/model/NetworkInterfacePrivateIpAddress.h>
#include <aws/ec2/model/NetworkInterfaceStatus.h>
#include <aws/ec2/model/NetworkInterfaceType.h>
#include <aws/ec2/model/NeuronDeviceCoreInfo.h>
#include <aws/ec2/model/NeuronDeviceInfo.h>
#include <aws/ec2/model/NeuronDeviceMemoryInfo.h>
#include <aws/ec2/model/NeuronInfo.h>
#include <aws/ec2/model/NewDhcpConfiguration.h>
#include <aws/ec2/model/NitroEnclavesSupport.h>
#include <aws/ec2/model/NitroTpmInfo.h>
#include <aws/ec2/model/NitroTpmSupport.h>
#include <aws/ec2/model/OfferingClassType.h>
#include <aws/ec2/model/OfferingTypeValues.h>
#include <aws/ec2/model/OidcOptions.h>
#include <aws/ec2/model/OnDemandAllocationStrategy.h>
#include <aws/ec2/model/OnDemandOptions.h>
#include <aws/ec2/model/OnDemandOptionsRequest.h>
#include <aws/ec2/model/OperationType.h>
#include <aws/ec2/model/OperatorRequest.h>
#include <aws/ec2/model/OperatorResponse.h>
#include <aws/ec2/model/OutpostLag.h>
#include <aws/ec2/model/PacketHeaderStatement.h>
#include <aws/ec2/model/PacketHeaderStatementRequest.h>
#include <aws/ec2/model/PartitionLoadFrequency.h>
#include <aws/ec2/model/PathComponent.h>
#include <aws/ec2/model/PathFilter.h>
#include <aws/ec2/model/PathRequestFilter.h>
#include <aws/ec2/model/PathStatement.h>
#include <aws/ec2/model/PathStatementRequest.h>
#include <aws/ec2/model/PayerResponsibility.h>
#include <aws/ec2/model/PaymentOption.h>
#include <aws/ec2/model/PciId.h>
#include <aws/ec2/model/PeeringAttachmentStatus.h>
#include <aws/ec2/model/PeeringConnectionOptions.h>
#include <aws/ec2/model/PeeringConnectionOptionsRequest.h>
#include <aws/ec2/model/PeeringTgwInfo.h>
#include <aws/ec2/model/PerformanceFactorReference.h>
#include <aws/ec2/model/PerformanceFactorReferenceRequest.h>
#include <aws/ec2/model/PeriodType.h>
#include <aws/ec2/model/PermissionGroup.h>
#include <aws/ec2/model/Phase1DHGroupNumbersListValue.h>
#include <aws/ec2/model/Phase1DHGroupNumbersRequestListValue.h>
#include <aws/ec2/model/Phase1EncryptionAlgorithmsListValue.h>
#include <aws/ec2/model/Phase1EncryptionAlgorithmsRequestListValue.h>
#include <aws/ec2/model/Phase1IntegrityAlgorithmsListValue.h>
#include <aws/ec2/model/Phase1IntegrityAlgorithmsRequestListValue.h>
#include <aws/ec2/model/Phase2DHGroupNumbersListValue.h>
#include <aws/ec2/model/Phase2DHGroupNumbersRequestListValue.h>
#include <aws/ec2/model/Phase2EncryptionAlgorithmsListValue.h>
#include <aws/ec2/model/Phase2EncryptionAlgorithmsRequestListValue.h>
#include <aws/ec2/model/Phase2IntegrityAlgorithmsListValue.h>
#include <aws/ec2/model/Phase2IntegrityAlgorithmsRequestListValue.h>
#include <aws/ec2/model/PhcSupport.h>
#include <aws/ec2/model/Placement.h>
#include <aws/ec2/model/PlacementGroup.h>
#include <aws/ec2/model/PlacementGroupInfo.h>
#include <aws/ec2/model/PlacementGroupState.h>
#include <aws/ec2/model/PlacementGroupStrategy.h>
#include <aws/ec2/model/PlacementResponse.h>
#include <aws/ec2/model/PlacementStrategy.h>
#include <aws/ec2/model/PlatformValues.h>
#include <aws/ec2/model/PoolCidrBlock.h>
#include <aws/ec2/model/PortRange.h>
#include <aws/ec2/model/PrefixList.h>
#include <aws/ec2/model/PrefixListAssociation.h>
#include <aws/ec2/model/PrefixListEntry.h>
#include <aws/ec2/model/PrefixListId.h>
#include <aws/ec2/model/PrefixListState.h>
#include <aws/ec2/model/PriceSchedule.h>
#include <aws/ec2/model/PriceScheduleSpecification.h>
#include <aws/ec2/model/PricingDetail.h>
#include <aws/ec2/model/PrincipalIdFormat.h>
#include <aws/ec2/model/PrincipalType.h>
#include <aws/ec2/model/PrivateDnsDetails.h>
#include <aws/ec2/model/PrivateDnsNameConfiguration.h>
#include <aws/ec2/model/PrivateDnsNameOptionsOnLaunch.h>
#include <aws/ec2/model/PrivateDnsNameOptionsRequest.h>
#include <aws/ec2/model/PrivateDnsNameOptionsResponse.h>
#include <aws/ec2/model/PrivateIpAddressSpecification.h>
#include <aws/ec2/model/ProcessorInfo.h>
#include <aws/ec2/model/ProductCode.h>
#include <aws/ec2/model/ProductCodeValues.h>
#include <aws/ec2/model/PropagatingVgw.h>
#include <aws/ec2/model/Protocol.h>
#include <aws/ec2/model/ProtocolValue.h>
#include <aws/ec2/model/ProvisionByoipCidrRequest.h>
#include <aws/ec2/model/ProvisionByoipCidrResponse.h>
#include <aws/ec2/model/ProvisionIpamByoasnRequest.h>
#include <aws/ec2/model/ProvisionIpamByoasnResponse.h>
#include <aws/ec2/model/ProvisionIpamPoolCidrRequest.h>
#include <aws/ec2/model/ProvisionIpamPoolCidrResponse.h>
#include <aws/ec2/model/ProvisionPublicIpv4PoolCidrRequest.h>
#include <aws/ec2/model/ProvisionPublicIpv4PoolCidrResponse.h>
#include <aws/ec2/model/ProvisionedBandwidth.h>
#include <aws/ec2/model/PtrUpdateStatus.h>
#include <aws/ec2/model/PublicIpDnsNameOptions.h>
#include <aws/ec2/model/PublicIpDnsOption.h>
#include <aws/ec2/model/PublicIpv4Pool.h>
#include <aws/ec2/model/PublicIpv4PoolRange.h>
#include <aws/ec2/model/Purchase.h>
#include <aws/ec2/model/PurchaseCapacityBlockExtensionRequest.h>
#include <aws/ec2/model/PurchaseCapacityBlockExtensionResponse.h>
#include <aws/ec2/model/PurchaseCapacityBlockRequest.h>
#include <aws/ec2/model/PurchaseCapacityBlockResponse.h>
#include <aws/ec2/model/PurchaseHostReservationRequest.h>
#include <aws/ec2/model/PurchaseHostReservationResponse.h>
#include <aws/ec2/model/PurchaseRequest.h>
#include <aws/ec2/model/PurchaseReservedInstancesOfferingRequest.h>
#include <aws/ec2/model/PurchaseReservedInstancesOfferingResponse.h>
#include <aws/ec2/model/PurchaseScheduledInstancesRequest.h>
#include <aws/ec2/model/PurchaseScheduledInstancesResponse.h>
#include <aws/ec2/model/RIProductDescription.h>
#include <aws/ec2/model/RebootInstancesRequest.h>
#include <aws/ec2/model/RebootMigrationSupport.h>
#include <aws/ec2/model/RecurringCharge.h>
#include <aws/ec2/model/RecurringChargeFrequency.h>
#include <aws/ec2/model/ReferencedSecurityGroup.h>
#include <aws/ec2/model/Region.h>
#include <aws/ec2/model/RegionalSummary.h>
#include <aws/ec2/model/RegisterImageRequest.h>
#include <aws/ec2/model/RegisterImageResponse.h>
#include <aws/ec2/model/RegisterInstanceEventNotificationAttributesRequest.h>
#include <aws/ec2/model/RegisterInstanceEventNotificationAttributesResponse.h>
#include <aws/ec2/model/RegisterInstanceTagAttributeRequest.h>
#include <aws/ec2/model/RegisterTransitGatewayMulticastGroupMembersRequest.h>
#include <aws/ec2/model/RegisterTransitGatewayMulticastGroupMembersResponse.h>
#include <aws/ec2/model/RegisterTransitGatewayMulticastGroupSourcesRequest.h>
#include <aws/ec2/model/RegisterTransitGatewayMulticastGroupSourcesResponse.h>
#include <aws/ec2/model/RejectCapacityReservationBillingOwnershipRequest.h>
#include <aws/ec2/model/RejectCapacityReservationBillingOwnershipResponse.h>
#include <aws/ec2/model/RejectTransitGatewayMulticastDomainAssociationsRequest.h>
#include <aws/ec2/model/RejectTransitGatewayMulticastDomainAssociationsResponse.h>
#include <aws/ec2/model/RejectTransitGatewayPeeringAttachmentRequest.h>
#include <aws/ec2/model/RejectTransitGatewayPeeringAttachmentResponse.h>
#include <aws/ec2/model/RejectTransitGatewayVpcAttachmentRequest.h>
#include <aws/ec2/model/RejectTransitGatewayVpcAttachmentResponse.h>
#include <aws/ec2/model/RejectVpcEndpointConnectionsRequest.h>
#include <aws/ec2/model/RejectVpcEndpointConnectionsResponse.h>
#include <aws/ec2/model/RejectVpcPeeringConnectionRequest.h>
#include <aws/ec2/model/RejectVpcPeeringConnectionResponse.h>
#include <aws/ec2/model/ReleaseAddressRequest.h>
#include <aws/ec2/model/ReleaseHostsRequest.h>
#include <aws/ec2/model/ReleaseHostsResponse.h>
#include <aws/ec2/model/ReleaseIpamPoolAllocationRequest.h>
#include <aws/ec2/model/ReleaseIpamPoolAllocationResponse.h>
#include <aws/ec2/model/RemoveIpamOperatingRegion.h>
#include <aws/ec2/model/RemoveIpamOrganizationalUnitExclusion.h>
#include <aws/ec2/model/RemovePrefixListEntry.h>
#include <aws/ec2/model/ReplaceIamInstanceProfileAssociationRequest.h>
#include <aws/ec2/model/ReplaceIamInstanceProfileAssociationResponse.h>
#include <aws/ec2/model/ReplaceImageCriteriaInAllowedImagesSettingsRequest.h>
#include <aws/ec2/model/ReplaceImageCriteriaInAllowedImagesSettingsResponse.h>
#include <aws/ec2/model/ReplaceNetworkAclAssociationRequest.h>
#include <aws/ec2/model/ReplaceNetworkAclAssociationResponse.h>
#include <aws/ec2/model/ReplaceNetworkAclEntryRequest.h>
#include <aws/ec2/model/ReplaceRootVolumeTask.h>
#include <aws/ec2/model/ReplaceRootVolumeTaskState.h>
#include <aws/ec2/model/ReplaceRouteRequest.h>
#include <aws/ec2/model/ReplaceRouteTableAssociationRequest.h>
#include <aws/ec2/model/ReplaceRouteTableAssociationResponse.h>
#include <aws/ec2/model/ReplaceTransitGatewayRouteRequest.h>
#include <aws/ec2/model/ReplaceTransitGatewayRouteResponse.h>
#include <aws/ec2/model/ReplaceVpnTunnelRequest.h>
#include <aws/ec2/model/ReplaceVpnTunnelResponse.h>
#include <aws/ec2/model/ReplacementStrategy.h>
#include <aws/ec2/model/ReportInstanceReasonCodes.h>
#include <aws/ec2/model/ReportInstanceStatusRequest.h>
#include <aws/ec2/model/ReportState.h>
#include <aws/ec2/model/ReportStatusType.h>
#include <aws/ec2/model/RequestFilterPortRange.h>
#include <aws/ec2/model/RequestIpamResourceTag.h>
#include <aws/ec2/model/RequestLaunchTemplateData.h>
#include <aws/ec2/model/RequestSpotFleetRequest.h>
#include <aws/ec2/model/RequestSpotFleetResponse.h>
#include <aws/ec2/model/RequestSpotInstancesRequest.h>
#include <aws/ec2/model/RequestSpotInstancesResponse.h>
#include <aws/ec2/model/RequestSpotLaunchSpecification.h>
#include <aws/ec2/model/Reservation.h>
#include <aws/ec2/model/ReservationFleetInstanceSpecification.h>
#include <aws/ec2/model/ReservationState.h>
#include <aws/ec2/model/ReservationValue.h>
#include <aws/ec2/model/ReservedInstanceLimitPrice.h>
#include <aws/ec2/model/ReservedInstanceReservationValue.h>
#include <aws/ec2/model/ReservedInstanceState.h>
#include <aws/ec2/model/ReservedInstances.h>
#include <aws/ec2/model/ReservedInstancesConfiguration.h>
#include <aws/ec2/model/ReservedInstancesId.h>
#include <aws/ec2/model/ReservedInstancesListing.h>
#include <aws/ec2/model/ReservedInstancesModification.h>
#include <aws/ec2/model/ReservedInstancesModificationResponse.h>
#include <aws/ec2/model/ReservedInstancesOffering.h>
#include <aws/ec2/model/ResetAddressAttributeRequest.h>
#include <aws/ec2/model/ResetAddressAttributeResponse.h>
#include <aws/ec2/model/ResetEbsDefaultKmsKeyIdRequest.h>
#include <aws/ec2/model/ResetEbsDefaultKmsKeyIdResponse.h>
#include <aws/ec2/model/ResetFpgaImageAttributeName.h>
#include <aws/ec2/model/ResetFpgaImageAttributeRequest.h>
#include <aws/ec2/model/ResetFpgaImageAttributeResponse.h>
#include <aws/ec2/model/ResetImageAttributeName.h>
#include <aws/ec2/model/ResetImageAttributeRequest.h>
#include <aws/ec2/model/ResetInstanceAttributeRequest.h>
#include <aws/ec2/model/ResetNetworkInterfaceAttributeRequest.h>
#include <aws/ec2/model/ResetSnapshotAttributeRequest.h>
#include <aws/ec2/model/ResourceStatement.h>
#include <aws/ec2/model/ResourceStatementRequest.h>
#include <aws/ec2/model/ResourceType.h>
#include <aws/ec2/model/ResponseError.h>
#include <aws/ec2/model/ResponseLaunchTemplateData.h>
#include <aws/ec2/model/ResponseMetadata.h>
#include <aws/ec2/model/RestoreAddressToClassicRequest.h>
#include <aws/ec2/model/RestoreAddressToClassicResponse.h>
#include <aws/ec2/model/RestoreImageFromRecycleBinRequest.h>
#include <aws/ec2/model/RestoreImageFromRecycleBinResponse.h>
#include <aws/ec2/model/RestoreManagedPrefixListVersionRequest.h>
#include <aws/ec2/model/RestoreManagedPrefixListVersionResponse.h>
#include <aws/ec2/model/RestoreSnapshotFromRecycleBinRequest.h>
#include <aws/ec2/model/RestoreSnapshotFromRecycleBinResponse.h>
#include <aws/ec2/model/RestoreSnapshotTierRequest.h>
#include <aws/ec2/model/RestoreSnapshotTierResponse.h>
#include <aws/ec2/model/RevokeClientVpnIngressRequest.h>
#include <aws/ec2/model/RevokeClientVpnIngressResponse.h>
#include <aws/ec2/model/RevokeSecurityGroupEgressRequest.h>
#include <aws/ec2/model/RevokeSecurityGroupEgressResponse.h>
#include <aws/ec2/model/RevokeSecurityGroupIngressRequest.h>
#include <aws/ec2/model/RevokeSecurityGroupIngressResponse.h>
#include <aws/ec2/model/RevokedSecurityGroupRule.h>
#include <aws/ec2/model/RootDeviceType.h>
#include <aws/ec2/model/Route.h>
#include <aws/ec2/model/RouteOrigin.h>
#include <aws/ec2/model/RouteServer.h>
#include <aws/ec2/model/RouteServerAssociation.h>
#include <aws/ec2/model/RouteServerAssociationState.h>
#include <aws/ec2/model/RouteServerBfdState.h>
#include <aws/ec2/model/RouteServerBfdStatus.h>
#include <aws/ec2/model/RouteServerBgpOptions.h>
#include <aws/ec2/model/RouteServerBgpOptionsRequest.h>
#include <aws/ec2/model/RouteServerBgpState.h>
#include <aws/ec2/model/RouteServerBgpStatus.h>
#include <aws/ec2/model/RouteServerEndpoint.h>
#include <aws/ec2/model/RouteServerEndpointState.h>
#include <aws/ec2/model/RouteServerPeer.h>
#include <aws/ec2/model/RouteServerPeerLivenessMode.h>
#include <aws/ec2/model/RouteServerPeerState.h>
#include <aws/ec2/model/RouteServerPersistRoutesAction.h>
#include <aws/ec2/model/RouteServerPersistRoutesState.h>
#include <aws/ec2/model/RouteServerPropagation.h>
#include <aws/ec2/model/RouteServerPropagationState.h>
#include <aws/ec2/model/RouteServerRoute.h>
#include <aws/ec2/model/RouteServerRouteInstallationDetail.h>
#include <aws/ec2/model/RouteServerRouteInstallationStatus.h>
#include <aws/ec2/model/RouteServerRouteStatus.h>
#include <aws/ec2/model/RouteServerState.h>
#include <aws/ec2/model/RouteState.h>
#include <aws/ec2/model/RouteTable.h>
#include <aws/ec2/model/RouteTableAssociation.h>
#include <aws/ec2/model/RouteTableAssociationState.h>
#include <aws/ec2/model/RouteTableAssociationStateCode.h>
#include <aws/ec2/model/RuleAction.h>
#include <aws/ec2/model/RuleGroupRuleOptionsPair.h>
#include <aws/ec2/model/RuleGroupTypePair.h>
#include <aws/ec2/model/RuleOption.h>
#include <aws/ec2/model/RunInstancesMonitoringEnabled.h>
#include <aws/ec2/model/RunInstancesRequest.h>
#include <aws/ec2/model/RunInstancesResponse.h>
#include <aws/ec2/model/RunScheduledInstancesRequest.h>
#include <aws/ec2/model/RunScheduledInstancesResponse.h>
#include <aws/ec2/model/S3ObjectTag.h>
#include <aws/ec2/model/S3Storage.h>
#include <aws/ec2/model/SSEType.h>
#include <aws/ec2/model/ScheduledInstance.h>
#include <aws/ec2/model/ScheduledInstanceAvailability.h>
#include <aws/ec2/model/ScheduledInstanceRecurrence.h>
#include <aws/ec2/model/ScheduledInstanceRecurrenceRequest.h>
#include <aws/ec2/model/ScheduledInstancesBlockDeviceMapping.h>
#include <aws/ec2/model/ScheduledInstancesEbs.h>
#include <aws/ec2/model/ScheduledInstancesIamInstanceProfile.h>
#include <aws/ec2/model/ScheduledInstancesIpv6Address.h>
#include <aws/ec2/model/ScheduledInstancesLaunchSpecification.h>
#include <aws/ec2/model/ScheduledInstancesMonitoring.h>
#include <aws/ec2/model/ScheduledInstancesNetworkInterface.h>
#include <aws/ec2/model/ScheduledInstancesPlacement.h>
#include <aws/ec2/model/ScheduledInstancesPrivateIpAddressConfig.h>
#include <aws/ec2/model/Scope.h>
#include <aws/ec2/model/SearchLocalGatewayRoutesRequest.h>
#include <aws/ec2/model/SearchLocalGatewayRoutesResponse.h>
#include <aws/ec2/model/SearchTransitGatewayMulticastGroupsRequest.h>
#include <aws/ec2/model/SearchTransitGatewayMulticastGroupsResponse.h>
#include <aws/ec2/model/SearchTransitGatewayRoutesRequest.h>
#include <aws/ec2/model/SearchTransitGatewayRoutesResponse.h>
#include <aws/ec2/model/SecurityGroup.h>
#include <aws/ec2/model/SecurityGroupForVpc.h>
#include <aws/ec2/model/SecurityGroupIdentifier.h>
#include <aws/ec2/model/SecurityGroupReference.h>
#include <aws/ec2/model/SecurityGroupReferencingSupportValue.h>
#include <aws/ec2/model/SecurityGroupRule.h>
#include <aws/ec2/model/SecurityGroupRuleDescription.h>
#include <aws/ec2/model/SecurityGroupRuleRequest.h>
#include <aws/ec2/model/SecurityGroupRuleUpdate.h>
#include <aws/ec2/model/SecurityGroupVpcAssociation.h>
#include <aws/ec2/model/SecurityGroupVpcAssociationState.h>
#include <aws/ec2/model/SelfServicePortal.h>
#include <aws/ec2/model/SendDiagnosticInterruptRequest.h>
#include <aws/ec2/model/ServiceConfiguration.h>
#include <aws/ec2/model/ServiceConnectivityType.h>
#include <aws/ec2/model/ServiceDetail.h>
#include <aws/ec2/model/ServiceLinkVirtualInterface.h>
#include <aws/ec2/model/ServiceLinkVirtualInterfaceConfigurationState.h>
#include <aws/ec2/model/ServiceManaged.h>
#include <aws/ec2/model/ServiceState.h>
#include <aws/ec2/model/ServiceType.h>
#include <aws/ec2/model/ServiceTypeDetail.h>
#include <aws/ec2/model/ShutdownBehavior.h>
#include <aws/ec2/model/SlotDateTimeRangeRequest.h>
#include <aws/ec2/model/SlotStartTimeRangeRequest.h>
#include <aws/ec2/model/Snapshot.h>
#include <aws/ec2/model/SnapshotAttributeName.h>
#include <aws/ec2/model/SnapshotBlockPublicAccessState.h>
#include <aws/ec2/model/SnapshotDetail.h>
#include <aws/ec2/model/SnapshotDiskContainer.h>
#include <aws/ec2/model/SnapshotInfo.h>
#include <aws/ec2/model/SnapshotLocationEnum.h>
#include <aws/ec2/model/SnapshotRecycleBinInfo.h>
#include <aws/ec2/model/SnapshotReturnCodes.h>
#include <aws/ec2/model/SnapshotState.h>
#include <aws/ec2/model/SnapshotTaskDetail.h>
#include <aws/ec2/model/SnapshotTierStatus.h>
#include <aws/ec2/model/SpotAllocationStrategy.h>
#include <aws/ec2/model/SpotCapacityRebalance.h>
#include <aws/ec2/model/SpotDatafeedSubscription.h>
#include <aws/ec2/model/SpotFleetLaunchSpecification.h>
#include <aws/ec2/model/SpotFleetMonitoring.h>
#include <aws/ec2/model/SpotFleetRequestConfig.h>
#include <aws/ec2/model/SpotFleetRequestConfigData.h>
#include <aws/ec2/model/SpotFleetTagSpecification.h>
#include <aws/ec2/model/SpotInstanceInterruptionBehavior.h>
#include <aws/ec2/model/SpotInstanceRequest.h>
#include <aws/ec2/model/SpotInstanceState.h>
#include <aws/ec2/model/SpotInstanceStateFault.h>
#include <aws/ec2/model/SpotInstanceStatus.h>
#include <aws/ec2/model/SpotInstanceType.h>
#include <aws/ec2/model/SpotMaintenanceStrategies.h>
#include <aws/ec2/model/SpotMarketOptions.h>
#include <aws/ec2/model/SpotOptions.h>
#include <aws/ec2/model/SpotOptionsRequest.h>
#include <aws/ec2/model/SpotPlacement.h>
#include <aws/ec2/model/SpotPlacementScore.h>
#include <aws/ec2/model/SpotPrice.h>
#include <aws/ec2/model/SpreadLevel.h>
#include <aws/ec2/model/StaleIpPermission.h>
#include <aws/ec2/model/StaleSecurityGroup.h>
#include <aws/ec2/model/StartDeclarativePoliciesReportRequest.h>
#include <aws/ec2/model/StartDeclarativePoliciesReportResponse.h>
#include <aws/ec2/model/StartInstancesRequest.h>
#include <aws/ec2/model/StartInstancesResponse.h>
#include <aws/ec2/model/StartNetworkInsightsAccessScopeAnalysisRequest.h>
#include <aws/ec2/model/StartNetworkInsightsAccessScopeAnalysisResponse.h>
#include <aws/ec2/model/StartNetworkInsightsAnalysisRequest.h>
#include <aws/ec2/model/StartNetworkInsightsAnalysisResponse.h>
#include <aws/ec2/model/StartVpcEndpointServicePrivateDnsVerificationRequest.h>
#include <aws/ec2/model/StartVpcEndpointServicePrivateDnsVerificationResponse.h>
#include <aws/ec2/model/State.h>
#include <aws/ec2/model/StateReason.h>
#include <aws/ec2/model/StaticSourcesSupportValue.h>
#include <aws/ec2/model/StatisticType.h>
#include <aws/ec2/model/Status.h>
#include <aws/ec2/model/StatusName.h>
#include <aws/ec2/model/StatusType.h>
#include <aws/ec2/model/StopInstancesRequest.h>
#include <aws/ec2/model/StopInstancesResponse.h>
#include <aws/ec2/model/Storage.h>
#include <aws/ec2/model/StorageLocation.h>
#include <aws/ec2/model/StorageTier.h>
#include <aws/ec2/model/StoreImageTaskResponse.h>
#include <aws/ec2/model/Subnet.h>
#include <aws/ec2/model/SubnetAssociation.h>
#include <aws/ec2/model/SubnetCidrBlockState.h>
#include <aws/ec2/model/SubnetCidrBlockStateCode.h>
#include <aws/ec2/model/SubnetCidrReservation.h>
#include <aws/ec2/model/SubnetCidrReservationType.h>
#include <aws/ec2/model/SubnetConfiguration.h>
#include <aws/ec2/model/SubnetIpPrefixes.h>
#include <aws/ec2/model/SubnetIpv6CidrBlockAssociation.h>
#include <aws/ec2/model/SubnetState.h>
#include <aws/ec2/model/Subscription.h>
#include <aws/ec2/model/SuccessfulInstanceCreditSpecificationItem.h>
#include <aws/ec2/model/SuccessfulQueuedPurchaseDeletion.h>
#include <aws/ec2/model/SummaryStatus.h>
#include <aws/ec2/model/SupportedAdditionalProcessorFeature.h>
#include <aws/ec2/model/SupportedRegionDetail.h>
#include <aws/ec2/model/Tag.h>
#include <aws/ec2/model/TagDescription.h>
#include <aws/ec2/model/TagSpecification.h>
#include <aws/ec2/model/TargetCapacitySpecification.h>
#include <aws/ec2/model/TargetCapacitySpecificationRequest.h>
#include <aws/ec2/model/TargetCapacityUnitType.h>
#include <aws/ec2/model/TargetConfiguration.h>
#include <aws/ec2/model/TargetConfigurationRequest.h>
#include <aws/ec2/model/TargetGroup.h>
#include <aws/ec2/model/TargetGroupsConfig.h>
#include <aws/ec2/model/TargetNetwork.h>
#include <aws/ec2/model/TargetReservationValue.h>
#include <aws/ec2/model/TargetStorageTier.h>
#include <aws/ec2/model/TelemetryStatus.h>
#include <aws/ec2/model/Tenancy.h>
#include <aws/ec2/model/TerminateClientVpnConnectionsRequest.h>
#include <aws/ec2/model/TerminateClientVpnConnectionsResponse.h>
#include <aws/ec2/model/TerminateConnectionStatus.h>
#include <aws/ec2/model/TerminateInstancesRequest.h>
#include <aws/ec2/model/TerminateInstancesResponse.h>
#include <aws/ec2/model/ThroughResourcesStatement.h>
#include <aws/ec2/model/ThroughResourcesStatementRequest.h>
#include <aws/ec2/model/TieringOperationStatus.h>
#include <aws/ec2/model/TokenState.h>
#include <aws/ec2/model/TotalLocalStorageGB.h>
#include <aws/ec2/model/TotalLocalStorageGBRequest.h>
#include <aws/ec2/model/TpmSupportValues.h>
#include <aws/ec2/model/TrafficDirection.h>
#include <aws/ec2/model/TrafficMirrorFilter.h>
#include <aws/ec2/model/TrafficMirrorFilterRule.h>
#include <aws/ec2/model/TrafficMirrorFilterRuleField.h>
#include <aws/ec2/model/TrafficMirrorNetworkService.h>
#include <aws/ec2/model/TrafficMirrorPortRange.h>
#include <aws/ec2/model/TrafficMirrorPortRangeRequest.h>
#include <aws/ec2/model/TrafficMirrorRuleAction.h>
#include <aws/ec2/model/TrafficMirrorSession.h>
#include <aws/ec2/model/TrafficMirrorSessionField.h>
#include <aws/ec2/model/TrafficMirrorTarget.h>
#include <aws/ec2/model/TrafficMirrorTargetType.h>
#include <aws/ec2/model/TrafficType.h>
#include <aws/ec2/model/TransferType.h>
#include <aws/ec2/model/TransitGateway.h>
#include <aws/ec2/model/TransitGatewayAssociation.h>
#include <aws/ec2/model/TransitGatewayAssociationState.h>
#include <aws/ec2/model/TransitGatewayAttachment.h>
#include <aws/ec2/model/TransitGatewayAttachmentAssociation.h>
#include <aws/ec2/model/TransitGatewayAttachmentBgpConfiguration.h>
#include <aws/ec2/model/TransitGatewayAttachmentPropagation.h>
#include <aws/ec2/model/TransitGatewayAttachmentResourceType.h>
#include <aws/ec2/model/TransitGatewayAttachmentState.h>
#include <aws/ec2/model/TransitGatewayConnect.h>
#include <aws/ec2/model/TransitGatewayConnectOptions.h>
#include <aws/ec2/model/TransitGatewayConnectPeer.h>
#include <aws/ec2/model/TransitGatewayConnectPeerConfiguration.h>
#include <aws/ec2/model/TransitGatewayConnectPeerState.h>
#include <aws/ec2/model/TransitGatewayConnectRequestBgpOptions.h>
#include <aws/ec2/model/TransitGatewayMulitcastDomainAssociationState.h>
#include <aws/ec2/model/TransitGatewayMulticastDeregisteredGroupMembers.h>
#include <aws/ec2/model/TransitGatewayMulticastDeregisteredGroupSources.h>
#include <aws/ec2/model/TransitGatewayMulticastDomain.h>
#include <aws/ec2/model/TransitGatewayMulticastDomainAssociation.h>
#include <aws/ec2/model/TransitGatewayMulticastDomainAssociations.h>
#include <aws/ec2/model/TransitGatewayMulticastDomainOptions.h>
#include <aws/ec2/model/TransitGatewayMulticastDomainState.h>
#include <aws/ec2/model/TransitGatewayMulticastGroup.h>
#include <aws/ec2/model/TransitGatewayMulticastRegisteredGroupMembers.h>
#include <aws/ec2/model/TransitGatewayMulticastRegisteredGroupSources.h>
#include <aws/ec2/model/TransitGatewayOptions.h>
#include <aws/ec2/model/TransitGatewayPeeringAttachment.h>
#include <aws/ec2/model/TransitGatewayPeeringAttachmentOptions.h>
#include <aws/ec2/model/TransitGatewayPolicyRule.h>
#include <aws/ec2/model/TransitGatewayPolicyRuleMetaData.h>
#include <aws/ec2/model/TransitGatewayPolicyTable.h>
#include <aws/ec2/model/TransitGatewayPolicyTableAssociation.h>
#include <aws/ec2/model/TransitGatewayPolicyTableEntry.h>
#include <aws/ec2/model/TransitGatewayPolicyTableState.h>
#include <aws/ec2/model/TransitGatewayPrefixListAttachment.h>
#include <aws/ec2/model/TransitGatewayPrefixListReference.h>
#include <aws/ec2/model/TransitGatewayPrefixListReferenceState.h>
#include <aws/ec2/model/TransitGatewayPropagation.h>
#include <aws/ec2/model/TransitGatewayPropagationState.h>
#include <aws/ec2/model/TransitGatewayRequestOptions.h>
#include <aws/ec2/model/TransitGatewayRoute.h>
#include <aws/ec2/model/TransitGatewayRouteAttachment.h>
#include <aws/ec2/model/TransitGatewayRouteState.h>
#include <aws/ec2/model/TransitGatewayRouteTable.h>
#include <aws/ec2/model/TransitGatewayRouteTableAnnouncement.h>
#include <aws/ec2/model/TransitGatewayRouteTableAnnouncementDirection.h>
#include <aws/ec2/model/TransitGatewayRouteTableAnnouncementState.h>
#include <aws/ec2/model/TransitGatewayRouteTableAssociation.h>
#include <aws/ec2/model/TransitGatewayRouteTablePropagation.h>
#include <aws/ec2/model/TransitGatewayRouteTableRoute.h>
#include <aws/ec2/model/TransitGatewayRouteTableState.h>
#include <aws/ec2/model/TransitGatewayRouteType.h>
#include <aws/ec2/model/TransitGatewayState.h>
#include <aws/ec2/model/TransitGatewayVpcAttachment.h>
#include <aws/ec2/model/TransitGatewayVpcAttachmentOptions.h>
#include <aws/ec2/model/TransportProtocol.h>
#include <aws/ec2/model/TrunkInterfaceAssociation.h>
#include <aws/ec2/model/TrustProviderType.h>
#include <aws/ec2/model/TunnelInsideIpVersion.h>
#include <aws/ec2/model/TunnelOption.h>
#include <aws/ec2/model/UnassignIpv6AddressesRequest.h>
#include <aws/ec2/model/UnassignIpv6AddressesResponse.h>
#include <aws/ec2/model/UnassignPrivateIpAddressesRequest.h>
#include <aws/ec2/model/UnassignPrivateNatGatewayAddressRequest.h>
#include <aws/ec2/model/UnassignPrivateNatGatewayAddressResponse.h>
#include <aws/ec2/model/UnlimitedSupportedInstanceFamily.h>
#include <aws/ec2/model/UnlockSnapshotRequest.h>
#include <aws/ec2/model/UnlockSnapshotResponse.h>
#include <aws/ec2/model/UnmonitorInstancesRequest.h>
#include <aws/ec2/model/UnmonitorInstancesResponse.h>
#include <aws/ec2/model/UnsuccessfulInstanceCreditSpecificationErrorCode.h>
#include <aws/ec2/model/UnsuccessfulInstanceCreditSpecificationItem.h>
#include <aws/ec2/model/UnsuccessfulInstanceCreditSpecificationItemError.h>
#include <aws/ec2/model/UnsuccessfulItem.h>
#include <aws/ec2/model/UnsuccessfulItemError.h>
#include <aws/ec2/model/UpdateSecurityGroupRuleDescriptionsEgressRequest.h>
#include <aws/ec2/model/UpdateSecurityGroupRuleDescriptionsEgressResponse.h>
#include <aws/ec2/model/UpdateSecurityGroupRuleDescriptionsIngressRequest.h>
#include <aws/ec2/model/UpdateSecurityGroupRuleDescriptionsIngressResponse.h>
#include <aws/ec2/model/UsageClassType.h>
#include <aws/ec2/model/UserBucket.h>
#include <aws/ec2/model/UserBucketDetails.h>
#include <aws/ec2/model/UserData.h>
#include <aws/ec2/model/UserIdGroupPair.h>
#include <aws/ec2/model/UserTrustProviderType.h>
#include <aws/ec2/model/VCpuCountRange.h>
#include <aws/ec2/model/VCpuCountRangeRequest.h>
#include <aws/ec2/model/VCpuInfo.h>
#include <aws/ec2/model/ValidationError.h>
#include <aws/ec2/model/ValidationWarning.h>
#include <aws/ec2/model/VerificationMethod.h>
#include <aws/ec2/model/VerifiedAccessEndpoint.h>
#include <aws/ec2/model/VerifiedAccessEndpointAttachmentType.h>
#include <aws/ec2/model/VerifiedAccessEndpointCidrOptions.h>
#include <aws/ec2/model/VerifiedAccessEndpointEniOptions.h>
#include <aws/ec2/model/VerifiedAccessEndpointLoadBalancerOptions.h>
#include <aws/ec2/model/VerifiedAccessEndpointPortRange.h>
#include <aws/ec2/model/VerifiedAccessEndpointProtocol.h>
#include <aws/ec2/model/VerifiedAccessEndpointRdsOptions.h>
#include <aws/ec2/model/VerifiedAccessEndpointStatus.h>
#include <aws/ec2/model/VerifiedAccessEndpointStatusCode.h>
#include <aws/ec2/model/VerifiedAccessEndpointTarget.h>
#include <aws/ec2/model/VerifiedAccessEndpointType.h>
#include <aws/ec2/model/VerifiedAccessGroup.h>
#include <aws/ec2/model/VerifiedAccessInstance.h>
#include <aws/ec2/model/VerifiedAccessInstanceCustomSubDomain.h>
#include <aws/ec2/model/VerifiedAccessInstanceLoggingConfiguration.h>
#include <aws/ec2/model/VerifiedAccessInstanceOpenVpnClientConfiguration.h>
#include <aws/ec2/model/VerifiedAccessInstanceOpenVpnClientConfigurationRoute.h>
#include <aws/ec2/model/VerifiedAccessInstanceUserTrustProviderClientConfiguration.h>
#include <aws/ec2/model/VerifiedAccessLogCloudWatchLogsDestination.h>
#include <aws/ec2/model/VerifiedAccessLogCloudWatchLogsDestinationOptions.h>
#include <aws/ec2/model/VerifiedAccessLogDeliveryStatus.h>
#include <aws/ec2/model/VerifiedAccessLogDeliveryStatusCode.h>
#include <aws/ec2/model/VerifiedAccessLogKinesisDataFirehoseDestination.h>
#include <aws/ec2/model/VerifiedAccessLogKinesisDataFirehoseDestinationOptions.h>
#include <aws/ec2/model/VerifiedAccessLogOptions.h>
#include <aws/ec2/model/VerifiedAccessLogS3Destination.h>
#include <aws/ec2/model/VerifiedAccessLogS3DestinationOptions.h>
#include <aws/ec2/model/VerifiedAccessLogs.h>
#include <aws/ec2/model/VerifiedAccessSseSpecificationRequest.h>
#include <aws/ec2/model/VerifiedAccessSseSpecificationResponse.h>
#include <aws/ec2/model/VerifiedAccessTrustProvider.h>
#include <aws/ec2/model/VerifiedAccessTrustProviderCondensed.h>
#include <aws/ec2/model/VgwTelemetry.h>
#include <aws/ec2/model/VirtualizationType.h>
#include <aws/ec2/model/Volume.h>
#include <aws/ec2/model/VolumeAttachment.h>
#include <aws/ec2/model/VolumeAttachmentState.h>
#include <aws/ec2/model/VolumeAttributeName.h>
#include <aws/ec2/model/VolumeDetail.h>
#include <aws/ec2/model/VolumeModification.h>
#include <aws/ec2/model/VolumeModificationState.h>
#include <aws/ec2/model/VolumeState.h>
#include <aws/ec2/model/VolumeStatusAction.h>
#include <aws/ec2/model/VolumeStatusAttachmentStatus.h>
#include <aws/ec2/model/VolumeStatusDetails.h>
#include <aws/ec2/model/VolumeStatusEvent.h>
#include <aws/ec2/model/VolumeStatusInfo.h>
#include <aws/ec2/model/VolumeStatusInfoStatus.h>
#include <aws/ec2/model/VolumeStatusItem.h>
#include <aws/ec2/model/VolumeStatusName.h>
#include <aws/ec2/model/VolumeType.h>
#include <aws/ec2/model/Vpc.h>
#include <aws/ec2/model/VpcAttachment.h>
#include <aws/ec2/model/VpcAttributeName.h>
#include <aws/ec2/model/VpcBlockPublicAccessExclusion.h>
#include <aws/ec2/model/VpcBlockPublicAccessExclusionState.h>
#include <aws/ec2/model/VpcBlockPublicAccessExclusionsAllowed.h>
#include <aws/ec2/model/VpcBlockPublicAccessOptions.h>
#include <aws/ec2/model/VpcBlockPublicAccessState.h>
#include <aws/ec2/model/VpcCidrBlockAssociation.h>
#include <aws/ec2/model/VpcCidrBlockState.h>
#include <aws/ec2/model/VpcCidrBlockStateCode.h>
#include <aws/ec2/model/VpcClassicLink.h>
#include <aws/ec2/model/VpcEncryptionControl.h>
#include <aws/ec2/model/VpcEncryptionControlExclusion.h>
#include <aws/ec2/model/VpcEncryptionControlExclusionState.h>
#include <aws/ec2/model/VpcEncryptionControlExclusions.h>
#include <aws/ec2/model/VpcEncryptionControlMode.h>
#include <aws/ec2/model/VpcEncryptionControlState.h>
#include <aws/ec2/model/VpcEndpoint.h>
#include <aws/ec2/model/VpcEndpointAssociation.h>
#include <aws/ec2/model/VpcEndpointConnection.h>
#include <aws/ec2/model/VpcEndpointType.h>
#include <aws/ec2/model/VpcIpv6CidrBlockAssociation.h>
#include <aws/ec2/model/VpcPeeringConnection.h>
#include <aws/ec2/model/VpcPeeringConnectionOptionsDescription.h>
#include <aws/ec2/model/VpcPeeringConnectionStateReason.h>
#include <aws/ec2/model/VpcPeeringConnectionStateReasonCode.h>
#include <aws/ec2/model/VpcPeeringConnectionVpcInfo.h>
#include <aws/ec2/model/VpcState.h>
#include <aws/ec2/model/VpcTenancy.h>
#include <aws/ec2/model/VpnConnection.h>
#include <aws/ec2/model/VpnConnectionDeviceType.h>
#include <aws/ec2/model/VpnConnectionOptions.h>
#include <aws/ec2/model/VpnConnectionOptionsSpecification.h>
#include <aws/ec2/model/VpnEcmpSupportValue.h>
#include <aws/ec2/model/VpnGateway.h>
#include <aws/ec2/model/VpnProtocol.h>
#include <aws/ec2/model/VpnState.h>
#include <aws/ec2/model/VpnStaticRoute.h>
#include <aws/ec2/model/VpnStaticRouteSource.h>
#include <aws/ec2/model/VpnTunnelLogOptions.h>
#include <aws/ec2/model/VpnTunnelLogOptionsSpecification.h>
#include <aws/ec2/model/VpnTunnelOptionsSpecification.h>
#include <aws/ec2/model/VpnTunnelProvisioningStatus.h>
#include <aws/ec2/model/WeekDay.h>
#include <aws/ec2/model/WithdrawByoipCidrRequest.h>
#include <aws/ec2/model/WithdrawByoipCidrResponse.h>

using EC2IncludeTest = ::testing::Test;

TEST_F(EC2IncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::EC2::EC2Client>("EC2IncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
