/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/ecr/ECRClient.h>
#include <aws/ecr/ECREndpointProvider.h>
#include <aws/ecr/ECREndpointRules.h>
#include <aws/ecr/ECRErrorMarshaller.h>
#include <aws/ecr/ECRErrors.h>
#include <aws/ecr/ECRRequest.h>
#include <aws/ecr/ECRServiceClientModel.h>
#include <aws/ecr/ECR_EXPORTS.h>
#include <aws/ecr/model/Attribute.h>
#include <aws/ecr/model/AuthorizationData.h>
#include <aws/ecr/model/AwsEcrContainerImageDetails.h>
#include <aws/ecr/model/BatchCheckLayerAvailabilityRequest.h>
#include <aws/ecr/model/BatchCheckLayerAvailabilityResult.h>
#include <aws/ecr/model/BatchDeleteImageRequest.h>
#include <aws/ecr/model/BatchDeleteImageResult.h>
#include <aws/ecr/model/BatchGetImageRequest.h>
#include <aws/ecr/model/BatchGetImageResult.h>
#include <aws/ecr/model/BatchGetRepositoryScanningConfigurationRequest.h>
#include <aws/ecr/model/BatchGetRepositoryScanningConfigurationResult.h>
#include <aws/ecr/model/CompleteLayerUploadRequest.h>
#include <aws/ecr/model/CompleteLayerUploadResult.h>
#include <aws/ecr/model/CreatePullThroughCacheRuleRequest.h>
#include <aws/ecr/model/CreatePullThroughCacheRuleResult.h>
#include <aws/ecr/model/CreateRepositoryCreationTemplateRequest.h>
#include <aws/ecr/model/CreateRepositoryCreationTemplateResult.h>
#include <aws/ecr/model/CreateRepositoryRequest.h>
#include <aws/ecr/model/CreateRepositoryResult.h>
#include <aws/ecr/model/CvssScore.h>
#include <aws/ecr/model/CvssScoreAdjustment.h>
#include <aws/ecr/model/CvssScoreDetails.h>
#include <aws/ecr/model/DeleteLifecyclePolicyRequest.h>
#include <aws/ecr/model/DeleteLifecyclePolicyResult.h>
#include <aws/ecr/model/DeletePullThroughCacheRuleRequest.h>
#include <aws/ecr/model/DeletePullThroughCacheRuleResult.h>
#include <aws/ecr/model/DeleteRegistryPolicyRequest.h>
#include <aws/ecr/model/DeleteRegistryPolicyResult.h>
#include <aws/ecr/model/DeleteRepositoryCreationTemplateRequest.h>
#include <aws/ecr/model/DeleteRepositoryCreationTemplateResult.h>
#include <aws/ecr/model/DeleteRepositoryPolicyRequest.h>
#include <aws/ecr/model/DeleteRepositoryPolicyResult.h>
#include <aws/ecr/model/DeleteRepositoryRequest.h>
#include <aws/ecr/model/DeleteRepositoryResult.h>
#include <aws/ecr/model/DescribeImageReplicationStatusRequest.h>
#include <aws/ecr/model/DescribeImageReplicationStatusResult.h>
#include <aws/ecr/model/DescribeImageScanFindingsRequest.h>
#include <aws/ecr/model/DescribeImageScanFindingsResult.h>
#include <aws/ecr/model/DescribeImagesFilter.h>
#include <aws/ecr/model/DescribeImagesRequest.h>
#include <aws/ecr/model/DescribeImagesResult.h>
#include <aws/ecr/model/DescribePullThroughCacheRulesRequest.h>
#include <aws/ecr/model/DescribePullThroughCacheRulesResult.h>
#include <aws/ecr/model/DescribeRegistryRequest.h>
#include <aws/ecr/model/DescribeRegistryResult.h>
#include <aws/ecr/model/DescribeRepositoriesRequest.h>
#include <aws/ecr/model/DescribeRepositoriesResult.h>
#include <aws/ecr/model/DescribeRepositoryCreationTemplatesRequest.h>
#include <aws/ecr/model/DescribeRepositoryCreationTemplatesResult.h>
#include <aws/ecr/model/EncryptionConfiguration.h>
#include <aws/ecr/model/EncryptionConfigurationForRepositoryCreationTemplate.h>
#include <aws/ecr/model/EncryptionType.h>
#include <aws/ecr/model/EnhancedImageScanFinding.h>
#include <aws/ecr/model/FindingSeverity.h>
#include <aws/ecr/model/GetAccountSettingRequest.h>
#include <aws/ecr/model/GetAccountSettingResult.h>
#include <aws/ecr/model/GetAuthorizationTokenRequest.h>
#include <aws/ecr/model/GetAuthorizationTokenResult.h>
#include <aws/ecr/model/GetDownloadUrlForLayerRequest.h>
#include <aws/ecr/model/GetDownloadUrlForLayerResult.h>
#include <aws/ecr/model/GetLifecyclePolicyPreviewRequest.h>
#include <aws/ecr/model/GetLifecyclePolicyPreviewResult.h>
#include <aws/ecr/model/GetLifecyclePolicyRequest.h>
#include <aws/ecr/model/GetLifecyclePolicyResult.h>
#include <aws/ecr/model/GetRegistryPolicyRequest.h>
#include <aws/ecr/model/GetRegistryPolicyResult.h>
#include <aws/ecr/model/GetRegistryScanningConfigurationRequest.h>
#include <aws/ecr/model/GetRegistryScanningConfigurationResult.h>
#include <aws/ecr/model/GetRepositoryPolicyRequest.h>
#include <aws/ecr/model/GetRepositoryPolicyResult.h>
#include <aws/ecr/model/Image.h>
#include <aws/ecr/model/ImageActionType.h>
#include <aws/ecr/model/ImageDetail.h>
#include <aws/ecr/model/ImageFailure.h>
#include <aws/ecr/model/ImageFailureCode.h>
#include <aws/ecr/model/ImageIdentifier.h>
#include <aws/ecr/model/ImageReplicationStatus.h>
#include <aws/ecr/model/ImageScanFinding.h>
#include <aws/ecr/model/ImageScanFindings.h>
#include <aws/ecr/model/ImageScanFindingsSummary.h>
#include <aws/ecr/model/ImageScanStatus.h>
#include <aws/ecr/model/ImageScanningConfiguration.h>
#include <aws/ecr/model/ImageTagMutability.h>
#include <aws/ecr/model/InitiateLayerUploadRequest.h>
#include <aws/ecr/model/InitiateLayerUploadResult.h>
#include <aws/ecr/model/InvalidLayerPartException.h>
#include <aws/ecr/model/KmsException.h>
#include <aws/ecr/model/Layer.h>
#include <aws/ecr/model/LayerAvailability.h>
#include <aws/ecr/model/LayerFailure.h>
#include <aws/ecr/model/LayerFailureCode.h>
#include <aws/ecr/model/LifecyclePolicyPreviewFilter.h>
#include <aws/ecr/model/LifecyclePolicyPreviewResult.h>
#include <aws/ecr/model/LifecyclePolicyPreviewStatus.h>
#include <aws/ecr/model/LifecyclePolicyPreviewSummary.h>
#include <aws/ecr/model/LifecyclePolicyRuleAction.h>
#include <aws/ecr/model/ListImagesFilter.h>
#include <aws/ecr/model/ListImagesRequest.h>
#include <aws/ecr/model/ListImagesResult.h>
#include <aws/ecr/model/ListTagsForResourceRequest.h>
#include <aws/ecr/model/ListTagsForResourceResult.h>
#include <aws/ecr/model/PackageVulnerabilityDetails.h>
#include <aws/ecr/model/PullThroughCacheRule.h>
#include <aws/ecr/model/PutAccountSettingRequest.h>
#include <aws/ecr/model/PutAccountSettingResult.h>
#include <aws/ecr/model/PutImageRequest.h>
#include <aws/ecr/model/PutImageResult.h>
#include <aws/ecr/model/PutImageScanningConfigurationRequest.h>
#include <aws/ecr/model/PutImageScanningConfigurationResult.h>
#include <aws/ecr/model/PutImageTagMutabilityRequest.h>
#include <aws/ecr/model/PutImageTagMutabilityResult.h>
#include <aws/ecr/model/PutLifecyclePolicyRequest.h>
#include <aws/ecr/model/PutLifecyclePolicyResult.h>
#include <aws/ecr/model/PutRegistryPolicyRequest.h>
#include <aws/ecr/model/PutRegistryPolicyResult.h>
#include <aws/ecr/model/PutRegistryScanningConfigurationRequest.h>
#include <aws/ecr/model/PutRegistryScanningConfigurationResult.h>
#include <aws/ecr/model/PutReplicationConfigurationRequest.h>
#include <aws/ecr/model/PutReplicationConfigurationResult.h>
#include <aws/ecr/model/RCTAppliedFor.h>
#include <aws/ecr/model/Recommendation.h>
#include <aws/ecr/model/RegistryScanningConfiguration.h>
#include <aws/ecr/model/RegistryScanningRule.h>
#include <aws/ecr/model/Remediation.h>
#include <aws/ecr/model/ReplicationConfiguration.h>
#include <aws/ecr/model/ReplicationDestination.h>
#include <aws/ecr/model/ReplicationRule.h>
#include <aws/ecr/model/ReplicationStatus.h>
#include <aws/ecr/model/Repository.h>
#include <aws/ecr/model/RepositoryCreationTemplate.h>
#include <aws/ecr/model/RepositoryFilter.h>
#include <aws/ecr/model/RepositoryFilterType.h>
#include <aws/ecr/model/RepositoryScanningConfiguration.h>
#include <aws/ecr/model/RepositoryScanningConfigurationFailure.h>
#include <aws/ecr/model/Resource.h>
#include <aws/ecr/model/ResourceDetails.h>
#include <aws/ecr/model/ScanFrequency.h>
#include <aws/ecr/model/ScanStatus.h>
#include <aws/ecr/model/ScanType.h>
#include <aws/ecr/model/ScanningConfigurationFailureCode.h>
#include <aws/ecr/model/ScanningRepositoryFilter.h>
#include <aws/ecr/model/ScanningRepositoryFilterType.h>
#include <aws/ecr/model/ScoreDetails.h>
#include <aws/ecr/model/SetRepositoryPolicyRequest.h>
#include <aws/ecr/model/SetRepositoryPolicyResult.h>
#include <aws/ecr/model/StartImageScanRequest.h>
#include <aws/ecr/model/StartImageScanResult.h>
#include <aws/ecr/model/StartLifecyclePolicyPreviewRequest.h>
#include <aws/ecr/model/StartLifecyclePolicyPreviewResult.h>
#include <aws/ecr/model/Tag.h>
#include <aws/ecr/model/TagResourceRequest.h>
#include <aws/ecr/model/TagResourceResult.h>
#include <aws/ecr/model/TagStatus.h>
#include <aws/ecr/model/UntagResourceRequest.h>
#include <aws/ecr/model/UntagResourceResult.h>
#include <aws/ecr/model/UpdatePullThroughCacheRuleRequest.h>
#include <aws/ecr/model/UpdatePullThroughCacheRuleResult.h>
#include <aws/ecr/model/UpdateRepositoryCreationTemplateRequest.h>
#include <aws/ecr/model/UpdateRepositoryCreationTemplateResult.h>
#include <aws/ecr/model/UploadLayerPartRequest.h>
#include <aws/ecr/model/UploadLayerPartResult.h>
#include <aws/ecr/model/UpstreamRegistry.h>
#include <aws/ecr/model/ValidatePullThroughCacheRuleRequest.h>
#include <aws/ecr/model/ValidatePullThroughCacheRuleResult.h>
#include <aws/ecr/model/VulnerablePackage.h>

using ECRIncludeTest = ::testing::Test;

TEST_F(ECRIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::ECR::ECRClient>("ECRIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
