/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/eks/EKSClient.h>
#include <aws/eks/EKSEndpointProvider.h>
#include <aws/eks/EKSEndpointRules.h>
#include <aws/eks/EKSErrorMarshaller.h>
#include <aws/eks/EKSErrors.h>
#include <aws/eks/EKSRequest.h>
#include <aws/eks/EKSServiceClientModel.h>
#include <aws/eks/EKS_EXPORTS.h>
#include <aws/eks/model/AMITypes.h>
#include <aws/eks/model/AccessConfigResponse.h>
#include <aws/eks/model/AccessEntry.h>
#include <aws/eks/model/AccessPolicy.h>
#include <aws/eks/model/AccessScope.h>
#include <aws/eks/model/AccessScopeType.h>
#include <aws/eks/model/Addon.h>
#include <aws/eks/model/AddonCompatibilityDetail.h>
#include <aws/eks/model/AddonHealth.h>
#include <aws/eks/model/AddonInfo.h>
#include <aws/eks/model/AddonIssue.h>
#include <aws/eks/model/AddonIssueCode.h>
#include <aws/eks/model/AddonPodIdentityAssociations.h>
#include <aws/eks/model/AddonPodIdentityConfiguration.h>
#include <aws/eks/model/AddonStatus.h>
#include <aws/eks/model/AddonVersionInfo.h>
#include <aws/eks/model/AssociateAccessPolicyRequest.h>
#include <aws/eks/model/AssociateAccessPolicyResult.h>
#include <aws/eks/model/AssociateEncryptionConfigRequest.h>
#include <aws/eks/model/AssociateEncryptionConfigResult.h>
#include <aws/eks/model/AssociateIdentityProviderConfigRequest.h>
#include <aws/eks/model/AssociateIdentityProviderConfigResult.h>
#include <aws/eks/model/AssociatedAccessPolicy.h>
#include <aws/eks/model/AuthenticationMode.h>
#include <aws/eks/model/AutoScalingGroup.h>
#include <aws/eks/model/BlockStorage.h>
#include <aws/eks/model/CapacityTypes.h>
#include <aws/eks/model/Category.h>
#include <aws/eks/model/Certificate.h>
#include <aws/eks/model/ClientException.h>
#include <aws/eks/model/ClientStat.h>
#include <aws/eks/model/Cluster.h>
#include <aws/eks/model/ClusterHealth.h>
#include <aws/eks/model/ClusterIssue.h>
#include <aws/eks/model/ClusterIssueCode.h>
#include <aws/eks/model/ClusterStatus.h>
#include <aws/eks/model/ClusterVersionInformation.h>
#include <aws/eks/model/ClusterVersionStatus.h>
#include <aws/eks/model/Compatibility.h>
#include <aws/eks/model/ComputeConfigRequest.h>
#include <aws/eks/model/ComputeConfigResponse.h>
#include <aws/eks/model/ConfigStatus.h>
#include <aws/eks/model/ConnectorConfigProvider.h>
#include <aws/eks/model/ConnectorConfigRequest.h>
#include <aws/eks/model/ConnectorConfigResponse.h>
#include <aws/eks/model/ControlPlanePlacementRequest.h>
#include <aws/eks/model/ControlPlanePlacementResponse.h>
#include <aws/eks/model/CreateAccessConfigRequest.h>
#include <aws/eks/model/CreateAccessEntryRequest.h>
#include <aws/eks/model/CreateAccessEntryResult.h>
#include <aws/eks/model/CreateAddonRequest.h>
#include <aws/eks/model/CreateAddonResult.h>
#include <aws/eks/model/CreateClusterRequest.h>
#include <aws/eks/model/CreateClusterResult.h>
#include <aws/eks/model/CreateEksAnywhereSubscriptionRequest.h>
#include <aws/eks/model/CreateEksAnywhereSubscriptionResult.h>
#include <aws/eks/model/CreateFargateProfileRequest.h>
#include <aws/eks/model/CreateFargateProfileResult.h>
#include <aws/eks/model/CreateNodegroupRequest.h>
#include <aws/eks/model/CreateNodegroupResult.h>
#include <aws/eks/model/CreatePodIdentityAssociationRequest.h>
#include <aws/eks/model/CreatePodIdentityAssociationResult.h>
#include <aws/eks/model/DeleteAccessEntryRequest.h>
#include <aws/eks/model/DeleteAccessEntryResult.h>
#include <aws/eks/model/DeleteAddonRequest.h>
#include <aws/eks/model/DeleteAddonResult.h>
#include <aws/eks/model/DeleteClusterRequest.h>
#include <aws/eks/model/DeleteClusterResult.h>
#include <aws/eks/model/DeleteEksAnywhereSubscriptionRequest.h>
#include <aws/eks/model/DeleteEksAnywhereSubscriptionResult.h>
#include <aws/eks/model/DeleteFargateProfileRequest.h>
#include <aws/eks/model/DeleteFargateProfileResult.h>
#include <aws/eks/model/DeleteNodegroupRequest.h>
#include <aws/eks/model/DeleteNodegroupResult.h>
#include <aws/eks/model/DeletePodIdentityAssociationRequest.h>
#include <aws/eks/model/DeletePodIdentityAssociationResult.h>
#include <aws/eks/model/DeprecationDetail.h>
#include <aws/eks/model/DeregisterClusterRequest.h>
#include <aws/eks/model/DeregisterClusterResult.h>
#include <aws/eks/model/DescribeAccessEntryRequest.h>
#include <aws/eks/model/DescribeAccessEntryResult.h>
#include <aws/eks/model/DescribeAddonConfigurationRequest.h>
#include <aws/eks/model/DescribeAddonConfigurationResult.h>
#include <aws/eks/model/DescribeAddonRequest.h>
#include <aws/eks/model/DescribeAddonResult.h>
#include <aws/eks/model/DescribeAddonVersionsRequest.h>
#include <aws/eks/model/DescribeAddonVersionsResult.h>
#include <aws/eks/model/DescribeClusterRequest.h>
#include <aws/eks/model/DescribeClusterResult.h>
#include <aws/eks/model/DescribeClusterVersionsRequest.h>
#include <aws/eks/model/DescribeClusterVersionsResult.h>
#include <aws/eks/model/DescribeEksAnywhereSubscriptionRequest.h>
#include <aws/eks/model/DescribeEksAnywhereSubscriptionResult.h>
#include <aws/eks/model/DescribeFargateProfileRequest.h>
#include <aws/eks/model/DescribeFargateProfileResult.h>
#include <aws/eks/model/DescribeIdentityProviderConfigRequest.h>
#include <aws/eks/model/DescribeIdentityProviderConfigResult.h>
#include <aws/eks/model/DescribeInsightRequest.h>
#include <aws/eks/model/DescribeInsightResult.h>
#include <aws/eks/model/DescribeNodegroupRequest.h>
#include <aws/eks/model/DescribeNodegroupResult.h>
#include <aws/eks/model/DescribePodIdentityAssociationRequest.h>
#include <aws/eks/model/DescribePodIdentityAssociationResult.h>
#include <aws/eks/model/DescribeUpdateRequest.h>
#include <aws/eks/model/DescribeUpdateResult.h>
#include <aws/eks/model/DisassociateAccessPolicyRequest.h>
#include <aws/eks/model/DisassociateAccessPolicyResult.h>
#include <aws/eks/model/DisassociateIdentityProviderConfigRequest.h>
#include <aws/eks/model/DisassociateIdentityProviderConfigResult.h>
#include <aws/eks/model/EksAnywhereSubscription.h>
#include <aws/eks/model/EksAnywhereSubscriptionLicenseType.h>
#include <aws/eks/model/EksAnywhereSubscriptionStatus.h>
#include <aws/eks/model/EksAnywhereSubscriptionTerm.h>
#include <aws/eks/model/EksAnywhereSubscriptionTermUnit.h>
#include <aws/eks/model/ElasticLoadBalancing.h>
#include <aws/eks/model/EncryptionConfig.h>
#include <aws/eks/model/ErrorCode.h>
#include <aws/eks/model/ErrorDetail.h>
#include <aws/eks/model/FargateProfile.h>
#include <aws/eks/model/FargateProfileHealth.h>
#include <aws/eks/model/FargateProfileIssue.h>
#include <aws/eks/model/FargateProfileIssueCode.h>
#include <aws/eks/model/FargateProfileSelector.h>
#include <aws/eks/model/FargateProfileStatus.h>
#include <aws/eks/model/Identity.h>
#include <aws/eks/model/IdentityProviderConfig.h>
#include <aws/eks/model/IdentityProviderConfigResponse.h>
#include <aws/eks/model/Insight.h>
#include <aws/eks/model/InsightCategorySpecificSummary.h>
#include <aws/eks/model/InsightResourceDetail.h>
#include <aws/eks/model/InsightStatus.h>
#include <aws/eks/model/InsightStatusValue.h>
#include <aws/eks/model/InsightSummary.h>
#include <aws/eks/model/InsightsFilter.h>
#include <aws/eks/model/InvalidParameterException.h>
#include <aws/eks/model/InvalidRequestException.h>
#include <aws/eks/model/InvalidStateException.h>
#include <aws/eks/model/IpFamily.h>
#include <aws/eks/model/Issue.h>
#include <aws/eks/model/KubernetesNetworkConfigRequest.h>
#include <aws/eks/model/KubernetesNetworkConfigResponse.h>
#include <aws/eks/model/LaunchTemplateSpecification.h>
#include <aws/eks/model/License.h>
#include <aws/eks/model/ListAccessEntriesRequest.h>
#include <aws/eks/model/ListAccessEntriesResult.h>
#include <aws/eks/model/ListAccessPoliciesRequest.h>
#include <aws/eks/model/ListAccessPoliciesResult.h>
#include <aws/eks/model/ListAddonsRequest.h>
#include <aws/eks/model/ListAddonsResult.h>
#include <aws/eks/model/ListAssociatedAccessPoliciesRequest.h>
#include <aws/eks/model/ListAssociatedAccessPoliciesResult.h>
#include <aws/eks/model/ListClustersRequest.h>
#include <aws/eks/model/ListClustersResult.h>
#include <aws/eks/model/ListEksAnywhereSubscriptionsRequest.h>
#include <aws/eks/model/ListEksAnywhereSubscriptionsResult.h>
#include <aws/eks/model/ListFargateProfilesRequest.h>
#include <aws/eks/model/ListFargateProfilesResult.h>
#include <aws/eks/model/ListIdentityProviderConfigsRequest.h>
#include <aws/eks/model/ListIdentityProviderConfigsResult.h>
#include <aws/eks/model/ListInsightsRequest.h>
#include <aws/eks/model/ListInsightsResult.h>
#include <aws/eks/model/ListNodegroupsRequest.h>
#include <aws/eks/model/ListNodegroupsResult.h>
#include <aws/eks/model/ListPodIdentityAssociationsRequest.h>
#include <aws/eks/model/ListPodIdentityAssociationsResult.h>
#include <aws/eks/model/ListTagsForResourceRequest.h>
#include <aws/eks/model/ListTagsForResourceResult.h>
#include <aws/eks/model/ListUpdatesRequest.h>
#include <aws/eks/model/ListUpdatesResult.h>
#include <aws/eks/model/LogSetup.h>
#include <aws/eks/model/LogType.h>
#include <aws/eks/model/Logging.h>
#include <aws/eks/model/MarketplaceInformation.h>
#include <aws/eks/model/NodeRepairConfig.h>
#include <aws/eks/model/Nodegroup.h>
#include <aws/eks/model/NodegroupHealth.h>
#include <aws/eks/model/NodegroupIssueCode.h>
#include <aws/eks/model/NodegroupResources.h>
#include <aws/eks/model/NodegroupScalingConfig.h>
#include <aws/eks/model/NodegroupStatus.h>
#include <aws/eks/model/NodegroupUpdateConfig.h>
#include <aws/eks/model/NodegroupUpdateStrategies.h>
#include <aws/eks/model/OIDC.h>
#include <aws/eks/model/OidcIdentityProviderConfig.h>
#include <aws/eks/model/OidcIdentityProviderConfigRequest.h>
#include <aws/eks/model/OutpostConfigRequest.h>
#include <aws/eks/model/OutpostConfigResponse.h>
#include <aws/eks/model/PodIdentityAssociation.h>
#include <aws/eks/model/PodIdentityAssociationSummary.h>
#include <aws/eks/model/Provider.h>
#include <aws/eks/model/RegisterClusterRequest.h>
#include <aws/eks/model/RegisterClusterResult.h>
#include <aws/eks/model/RemoteAccessConfig.h>
#include <aws/eks/model/RemoteNetworkConfigRequest.h>
#include <aws/eks/model/RemoteNetworkConfigResponse.h>
#include <aws/eks/model/RemoteNodeNetwork.h>
#include <aws/eks/model/RemotePodNetwork.h>
#include <aws/eks/model/ResolveConflicts.h>
#include <aws/eks/model/ResourceInUseException.h>
#include <aws/eks/model/ResourceLimitExceededException.h>
#include <aws/eks/model/ResourceNotFoundException.h>
#include <aws/eks/model/ServerException.h>
#include <aws/eks/model/StorageConfigRequest.h>
#include <aws/eks/model/StorageConfigResponse.h>
#include <aws/eks/model/SupportType.h>
#include <aws/eks/model/TagResourceRequest.h>
#include <aws/eks/model/TagResourceResult.h>
#include <aws/eks/model/Taint.h>
#include <aws/eks/model/TaintEffect.h>
#include <aws/eks/model/ThrottlingException.h>
#include <aws/eks/model/UnsupportedAvailabilityZoneException.h>
#include <aws/eks/model/UntagResourceRequest.h>
#include <aws/eks/model/UntagResourceResult.h>
#include <aws/eks/model/Update.h>
#include <aws/eks/model/UpdateAccessConfigRequest.h>
#include <aws/eks/model/UpdateAccessEntryRequest.h>
#include <aws/eks/model/UpdateAccessEntryResult.h>
#include <aws/eks/model/UpdateAddonRequest.h>
#include <aws/eks/model/UpdateAddonResult.h>
#include <aws/eks/model/UpdateClusterConfigRequest.h>
#include <aws/eks/model/UpdateClusterConfigResult.h>
#include <aws/eks/model/UpdateClusterVersionRequest.h>
#include <aws/eks/model/UpdateClusterVersionResult.h>
#include <aws/eks/model/UpdateEksAnywhereSubscriptionRequest.h>
#include <aws/eks/model/UpdateEksAnywhereSubscriptionResult.h>
#include <aws/eks/model/UpdateLabelsPayload.h>
#include <aws/eks/model/UpdateNodegroupConfigRequest.h>
#include <aws/eks/model/UpdateNodegroupConfigResult.h>
#include <aws/eks/model/UpdateNodegroupVersionRequest.h>
#include <aws/eks/model/UpdateNodegroupVersionResult.h>
#include <aws/eks/model/UpdateParam.h>
#include <aws/eks/model/UpdateParamType.h>
#include <aws/eks/model/UpdatePodIdentityAssociationRequest.h>
#include <aws/eks/model/UpdatePodIdentityAssociationResult.h>
#include <aws/eks/model/UpdateStatus.h>
#include <aws/eks/model/UpdateTaintsPayload.h>
#include <aws/eks/model/UpdateType.h>
#include <aws/eks/model/UpgradePolicyRequest.h>
#include <aws/eks/model/UpgradePolicyResponse.h>
#include <aws/eks/model/VersionStatus.h>
#include <aws/eks/model/VpcConfigRequest.h>
#include <aws/eks/model/VpcConfigResponse.h>
#include <aws/eks/model/ZonalShiftConfigRequest.h>
#include <aws/eks/model/ZonalShiftConfigResponse.h>

using EKSIncludeTest = ::testing::Test;

TEST_F(EKSIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::EKS::EKSClient>("EKSIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
