/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/elasticache/ElastiCacheClient.h>
#include <aws/elasticache/ElastiCacheEndpointProvider.h>
#include <aws/elasticache/ElastiCacheEndpointRules.h>
#include <aws/elasticache/ElastiCacheErrorMarshaller.h>
#include <aws/elasticache/ElastiCacheErrors.h>
#include <aws/elasticache/ElastiCacheRequest.h>
#include <aws/elasticache/ElastiCacheServiceClientModel.h>
#include <aws/elasticache/ElastiCache_EXPORTS.h>
#include <aws/elasticache/model/AZMode.h>
#include <aws/elasticache/model/AddTagsToResourceRequest.h>
#include <aws/elasticache/model/AddTagsToResourceResult.h>
#include <aws/elasticache/model/AuthTokenUpdateStatus.h>
#include <aws/elasticache/model/AuthTokenUpdateStrategyType.h>
#include <aws/elasticache/model/Authentication.h>
#include <aws/elasticache/model/AuthenticationMode.h>
#include <aws/elasticache/model/AuthenticationType.h>
#include <aws/elasticache/model/AuthorizeCacheSecurityGroupIngressRequest.h>
#include <aws/elasticache/model/AuthorizeCacheSecurityGroupIngressResult.h>
#include <aws/elasticache/model/AutomaticFailoverStatus.h>
#include <aws/elasticache/model/AvailabilityZone.h>
#include <aws/elasticache/model/BatchApplyUpdateActionRequest.h>
#include <aws/elasticache/model/BatchApplyUpdateActionResult.h>
#include <aws/elasticache/model/BatchStopUpdateActionRequest.h>
#include <aws/elasticache/model/BatchStopUpdateActionResult.h>
#include <aws/elasticache/model/CacheCluster.h>
#include <aws/elasticache/model/CacheEngineVersion.h>
#include <aws/elasticache/model/CacheNode.h>
#include <aws/elasticache/model/CacheNodeTypeSpecificParameter.h>
#include <aws/elasticache/model/CacheNodeTypeSpecificValue.h>
#include <aws/elasticache/model/CacheNodeUpdateStatus.h>
#include <aws/elasticache/model/CacheParameterGroup.h>
#include <aws/elasticache/model/CacheParameterGroupStatus.h>
#include <aws/elasticache/model/CacheSecurityGroup.h>
#include <aws/elasticache/model/CacheSecurityGroupMembership.h>
#include <aws/elasticache/model/CacheSubnetGroup.h>
#include <aws/elasticache/model/CacheUsageLimits.h>
#include <aws/elasticache/model/ChangeType.h>
#include <aws/elasticache/model/CloudWatchLogsDestinationDetails.h>
#include <aws/elasticache/model/ClusterMode.h>
#include <aws/elasticache/model/CompleteMigrationRequest.h>
#include <aws/elasticache/model/CompleteMigrationResult.h>
#include <aws/elasticache/model/ConfigureShard.h>
#include <aws/elasticache/model/CopyServerlessCacheSnapshotRequest.h>
#include <aws/elasticache/model/CopyServerlessCacheSnapshotResult.h>
#include <aws/elasticache/model/CopySnapshotRequest.h>
#include <aws/elasticache/model/CopySnapshotResult.h>
#include <aws/elasticache/model/CreateCacheClusterRequest.h>
#include <aws/elasticache/model/CreateCacheClusterResult.h>
#include <aws/elasticache/model/CreateCacheParameterGroupRequest.h>
#include <aws/elasticache/model/CreateCacheParameterGroupResult.h>
#include <aws/elasticache/model/CreateCacheSecurityGroupRequest.h>
#include <aws/elasticache/model/CreateCacheSecurityGroupResult.h>
#include <aws/elasticache/model/CreateCacheSubnetGroupRequest.h>
#include <aws/elasticache/model/CreateCacheSubnetGroupResult.h>
#include <aws/elasticache/model/CreateGlobalReplicationGroupRequest.h>
#include <aws/elasticache/model/CreateGlobalReplicationGroupResult.h>
#include <aws/elasticache/model/CreateReplicationGroupRequest.h>
#include <aws/elasticache/model/CreateReplicationGroupResult.h>
#include <aws/elasticache/model/CreateServerlessCacheRequest.h>
#include <aws/elasticache/model/CreateServerlessCacheResult.h>
#include <aws/elasticache/model/CreateServerlessCacheSnapshotRequest.h>
#include <aws/elasticache/model/CreateServerlessCacheSnapshotResult.h>
#include <aws/elasticache/model/CreateSnapshotRequest.h>
#include <aws/elasticache/model/CreateSnapshotResult.h>
#include <aws/elasticache/model/CreateUserGroupRequest.h>
#include <aws/elasticache/model/CreateUserGroupResult.h>
#include <aws/elasticache/model/CreateUserRequest.h>
#include <aws/elasticache/model/CreateUserResult.h>
#include <aws/elasticache/model/CustomerNodeEndpoint.h>
#include <aws/elasticache/model/DataStorage.h>
#include <aws/elasticache/model/DataStorageUnit.h>
#include <aws/elasticache/model/DataTieringStatus.h>
#include <aws/elasticache/model/DecreaseNodeGroupsInGlobalReplicationGroupRequest.h>
#include <aws/elasticache/model/DecreaseNodeGroupsInGlobalReplicationGroupResult.h>
#include <aws/elasticache/model/DecreaseReplicaCountRequest.h>
#include <aws/elasticache/model/DecreaseReplicaCountResult.h>
#include <aws/elasticache/model/DeleteCacheClusterRequest.h>
#include <aws/elasticache/model/DeleteCacheClusterResult.h>
#include <aws/elasticache/model/DeleteCacheParameterGroupRequest.h>
#include <aws/elasticache/model/DeleteCacheSecurityGroupRequest.h>
#include <aws/elasticache/model/DeleteCacheSubnetGroupRequest.h>
#include <aws/elasticache/model/DeleteGlobalReplicationGroupRequest.h>
#include <aws/elasticache/model/DeleteGlobalReplicationGroupResult.h>
#include <aws/elasticache/model/DeleteReplicationGroupRequest.h>
#include <aws/elasticache/model/DeleteReplicationGroupResult.h>
#include <aws/elasticache/model/DeleteServerlessCacheRequest.h>
#include <aws/elasticache/model/DeleteServerlessCacheResult.h>
#include <aws/elasticache/model/DeleteServerlessCacheSnapshotRequest.h>
#include <aws/elasticache/model/DeleteServerlessCacheSnapshotResult.h>
#include <aws/elasticache/model/DeleteSnapshotRequest.h>
#include <aws/elasticache/model/DeleteSnapshotResult.h>
#include <aws/elasticache/model/DeleteUserGroupRequest.h>
#include <aws/elasticache/model/DeleteUserGroupResult.h>
#include <aws/elasticache/model/DeleteUserRequest.h>
#include <aws/elasticache/model/DeleteUserResult.h>
#include <aws/elasticache/model/DescribeCacheClustersRequest.h>
#include <aws/elasticache/model/DescribeCacheClustersResult.h>
#include <aws/elasticache/model/DescribeCacheEngineVersionsRequest.h>
#include <aws/elasticache/model/DescribeCacheEngineVersionsResult.h>
#include <aws/elasticache/model/DescribeCacheParameterGroupsRequest.h>
#include <aws/elasticache/model/DescribeCacheParameterGroupsResult.h>
#include <aws/elasticache/model/DescribeCacheParametersRequest.h>
#include <aws/elasticache/model/DescribeCacheParametersResult.h>
#include <aws/elasticache/model/DescribeCacheSecurityGroupsRequest.h>
#include <aws/elasticache/model/DescribeCacheSecurityGroupsResult.h>
#include <aws/elasticache/model/DescribeCacheSubnetGroupsRequest.h>
#include <aws/elasticache/model/DescribeCacheSubnetGroupsResult.h>
#include <aws/elasticache/model/DescribeEngineDefaultParametersRequest.h>
#include <aws/elasticache/model/DescribeEngineDefaultParametersResult.h>
#include <aws/elasticache/model/DescribeEventsRequest.h>
#include <aws/elasticache/model/DescribeEventsResult.h>
#include <aws/elasticache/model/DescribeGlobalReplicationGroupsRequest.h>
#include <aws/elasticache/model/DescribeGlobalReplicationGroupsResult.h>
#include <aws/elasticache/model/DescribeReplicationGroupsRequest.h>
#include <aws/elasticache/model/DescribeReplicationGroupsResult.h>
#include <aws/elasticache/model/DescribeReservedCacheNodesOfferingsRequest.h>
#include <aws/elasticache/model/DescribeReservedCacheNodesOfferingsResult.h>
#include <aws/elasticache/model/DescribeReservedCacheNodesRequest.h>
#include <aws/elasticache/model/DescribeReservedCacheNodesResult.h>
#include <aws/elasticache/model/DescribeServerlessCacheSnapshotsRequest.h>
#include <aws/elasticache/model/DescribeServerlessCacheSnapshotsResult.h>
#include <aws/elasticache/model/DescribeServerlessCachesRequest.h>
#include <aws/elasticache/model/DescribeServerlessCachesResult.h>
#include <aws/elasticache/model/DescribeServiceUpdatesRequest.h>
#include <aws/elasticache/model/DescribeServiceUpdatesResult.h>
#include <aws/elasticache/model/DescribeSnapshotsRequest.h>
#include <aws/elasticache/model/DescribeSnapshotsResult.h>
#include <aws/elasticache/model/DescribeUpdateActionsRequest.h>
#include <aws/elasticache/model/DescribeUpdateActionsResult.h>
#include <aws/elasticache/model/DescribeUserGroupsRequest.h>
#include <aws/elasticache/model/DescribeUserGroupsResult.h>
#include <aws/elasticache/model/DescribeUsersRequest.h>
#include <aws/elasticache/model/DescribeUsersResult.h>
#include <aws/elasticache/model/DestinationDetails.h>
#include <aws/elasticache/model/DestinationType.h>
#include <aws/elasticache/model/DisassociateGlobalReplicationGroupRequest.h>
#include <aws/elasticache/model/DisassociateGlobalReplicationGroupResult.h>
#include <aws/elasticache/model/EC2SecurityGroup.h>
#include <aws/elasticache/model/ECPUPerSecond.h>
#include <aws/elasticache/model/Endpoint.h>
#include <aws/elasticache/model/EngineDefaults.h>
#include <aws/elasticache/model/Event.h>
#include <aws/elasticache/model/ExportServerlessCacheSnapshotRequest.h>
#include <aws/elasticache/model/ExportServerlessCacheSnapshotResult.h>
#include <aws/elasticache/model/FailoverGlobalReplicationGroupRequest.h>
#include <aws/elasticache/model/FailoverGlobalReplicationGroupResult.h>
#include <aws/elasticache/model/Filter.h>
#include <aws/elasticache/model/GlobalNodeGroup.h>
#include <aws/elasticache/model/GlobalReplicationGroup.h>
#include <aws/elasticache/model/GlobalReplicationGroupInfo.h>
#include <aws/elasticache/model/GlobalReplicationGroupMember.h>
#include <aws/elasticache/model/IncreaseNodeGroupsInGlobalReplicationGroupRequest.h>
#include <aws/elasticache/model/IncreaseNodeGroupsInGlobalReplicationGroupResult.h>
#include <aws/elasticache/model/IncreaseReplicaCountRequest.h>
#include <aws/elasticache/model/IncreaseReplicaCountResult.h>
#include <aws/elasticache/model/InputAuthenticationType.h>
#include <aws/elasticache/model/IpDiscovery.h>
#include <aws/elasticache/model/KinesisFirehoseDestinationDetails.h>
#include <aws/elasticache/model/ListAllowedNodeTypeModificationsRequest.h>
#include <aws/elasticache/model/ListAllowedNodeTypeModificationsResult.h>
#include <aws/elasticache/model/ListTagsForResourceRequest.h>
#include <aws/elasticache/model/ListTagsForResourceResult.h>
#include <aws/elasticache/model/LogDeliveryConfiguration.h>
#include <aws/elasticache/model/LogDeliveryConfigurationRequest.h>
#include <aws/elasticache/model/LogDeliveryConfigurationStatus.h>
#include <aws/elasticache/model/LogFormat.h>
#include <aws/elasticache/model/LogType.h>
#include <aws/elasticache/model/ModifyCacheClusterRequest.h>
#include <aws/elasticache/model/ModifyCacheClusterResult.h>
#include <aws/elasticache/model/ModifyCacheParameterGroupRequest.h>
#include <aws/elasticache/model/ModifyCacheParameterGroupResult.h>
#include <aws/elasticache/model/ModifyCacheSubnetGroupRequest.h>
#include <aws/elasticache/model/ModifyCacheSubnetGroupResult.h>
#include <aws/elasticache/model/ModifyGlobalReplicationGroupRequest.h>
#include <aws/elasticache/model/ModifyGlobalReplicationGroupResult.h>
#include <aws/elasticache/model/ModifyReplicationGroupRequest.h>
#include <aws/elasticache/model/ModifyReplicationGroupResult.h>
#include <aws/elasticache/model/ModifyReplicationGroupShardConfigurationRequest.h>
#include <aws/elasticache/model/ModifyReplicationGroupShardConfigurationResult.h>
#include <aws/elasticache/model/ModifyServerlessCacheRequest.h>
#include <aws/elasticache/model/ModifyServerlessCacheResult.h>
#include <aws/elasticache/model/ModifyUserGroupRequest.h>
#include <aws/elasticache/model/ModifyUserGroupResult.h>
#include <aws/elasticache/model/ModifyUserRequest.h>
#include <aws/elasticache/model/ModifyUserResult.h>
#include <aws/elasticache/model/MultiAZStatus.h>
#include <aws/elasticache/model/NetworkType.h>
#include <aws/elasticache/model/NodeGroup.h>
#include <aws/elasticache/model/NodeGroupConfiguration.h>
#include <aws/elasticache/model/NodeGroupMember.h>
#include <aws/elasticache/model/NodeGroupMemberUpdateStatus.h>
#include <aws/elasticache/model/NodeGroupUpdateStatus.h>
#include <aws/elasticache/model/NodeSnapshot.h>
#include <aws/elasticache/model/NodeUpdateInitiatedBy.h>
#include <aws/elasticache/model/NodeUpdateStatus.h>
#include <aws/elasticache/model/NotificationConfiguration.h>
#include <aws/elasticache/model/OutpostMode.h>
#include <aws/elasticache/model/Parameter.h>
#include <aws/elasticache/model/ParameterNameValue.h>
#include <aws/elasticache/model/PendingAutomaticFailoverStatus.h>
#include <aws/elasticache/model/PendingLogDeliveryConfiguration.h>
#include <aws/elasticache/model/PendingModifiedValues.h>
#include <aws/elasticache/model/ProcessedUpdateAction.h>
#include <aws/elasticache/model/PurchaseReservedCacheNodesOfferingRequest.h>
#include <aws/elasticache/model/PurchaseReservedCacheNodesOfferingResult.h>
#include <aws/elasticache/model/RebalanceSlotsInGlobalReplicationGroupRequest.h>
#include <aws/elasticache/model/RebalanceSlotsInGlobalReplicationGroupResult.h>
#include <aws/elasticache/model/RebootCacheClusterRequest.h>
#include <aws/elasticache/model/RebootCacheClusterResult.h>
#include <aws/elasticache/model/RecurringCharge.h>
#include <aws/elasticache/model/RegionalConfiguration.h>
#include <aws/elasticache/model/RemoveTagsFromResourceRequest.h>
#include <aws/elasticache/model/RemoveTagsFromResourceResult.h>
#include <aws/elasticache/model/ReplicationGroup.h>
#include <aws/elasticache/model/ReplicationGroupPendingModifiedValues.h>
#include <aws/elasticache/model/ReservedCacheNode.h>
#include <aws/elasticache/model/ReservedCacheNodesOffering.h>
#include <aws/elasticache/model/ResetCacheParameterGroupRequest.h>
#include <aws/elasticache/model/ResetCacheParameterGroupResult.h>
#include <aws/elasticache/model/ReshardingConfiguration.h>
#include <aws/elasticache/model/ReshardingStatus.h>
#include <aws/elasticache/model/ResponseMetadata.h>
#include <aws/elasticache/model/RevokeCacheSecurityGroupIngressRequest.h>
#include <aws/elasticache/model/RevokeCacheSecurityGroupIngressResult.h>
#include <aws/elasticache/model/ScaleConfig.h>
#include <aws/elasticache/model/SecurityGroupMembership.h>
#include <aws/elasticache/model/ServerlessCache.h>
#include <aws/elasticache/model/ServerlessCacheConfiguration.h>
#include <aws/elasticache/model/ServerlessCacheSnapshot.h>
#include <aws/elasticache/model/ServiceUpdate.h>
#include <aws/elasticache/model/ServiceUpdateSeverity.h>
#include <aws/elasticache/model/ServiceUpdateStatus.h>
#include <aws/elasticache/model/ServiceUpdateType.h>
#include <aws/elasticache/model/SlaMet.h>
#include <aws/elasticache/model/SlotMigration.h>
#include <aws/elasticache/model/Snapshot.h>
#include <aws/elasticache/model/SourceType.h>
#include <aws/elasticache/model/StartMigrationRequest.h>
#include <aws/elasticache/model/StartMigrationResult.h>
#include <aws/elasticache/model/Subnet.h>
#include <aws/elasticache/model/SubnetOutpost.h>
#include <aws/elasticache/model/Tag.h>
#include <aws/elasticache/model/TestFailoverRequest.h>
#include <aws/elasticache/model/TestFailoverResult.h>
#include <aws/elasticache/model/TestMigrationRequest.h>
#include <aws/elasticache/model/TestMigrationResult.h>
#include <aws/elasticache/model/TimeRangeFilter.h>
#include <aws/elasticache/model/TransitEncryptionMode.h>
#include <aws/elasticache/model/UnprocessedUpdateAction.h>
#include <aws/elasticache/model/UpdateAction.h>
#include <aws/elasticache/model/UpdateActionStatus.h>
#include <aws/elasticache/model/User.h>
#include <aws/elasticache/model/UserGroup.h>
#include <aws/elasticache/model/UserGroupPendingChanges.h>
#include <aws/elasticache/model/UserGroupsUpdateStatus.h>

using ElastiCacheIncludeTest = ::testing::Test;

TEST_F(ElastiCacheIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::ElastiCache::ElastiCacheClient>("ElastiCacheIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
