/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/elasticloadbalancingv2/ElasticLoadBalancingv2Client.h>
#include <aws/elasticloadbalancingv2/ElasticLoadBalancingv2EndpointProvider.h>
#include <aws/elasticloadbalancingv2/ElasticLoadBalancingv2EndpointRules.h>
#include <aws/elasticloadbalancingv2/ElasticLoadBalancingv2ErrorMarshaller.h>
#include <aws/elasticloadbalancingv2/ElasticLoadBalancingv2Errors.h>
#include <aws/elasticloadbalancingv2/ElasticLoadBalancingv2Request.h>
#include <aws/elasticloadbalancingv2/ElasticLoadBalancingv2ServiceClientModel.h>
#include <aws/elasticloadbalancingv2/ElasticLoadBalancingv2_EXPORTS.h>
#include <aws/elasticloadbalancingv2/model/Action.h>
#include <aws/elasticloadbalancingv2/model/ActionTypeEnum.h>
#include <aws/elasticloadbalancingv2/model/AddListenerCertificatesRequest.h>
#include <aws/elasticloadbalancingv2/model/AddListenerCertificatesResult.h>
#include <aws/elasticloadbalancingv2/model/AddTagsRequest.h>
#include <aws/elasticloadbalancingv2/model/AddTagsResult.h>
#include <aws/elasticloadbalancingv2/model/AddTrustStoreRevocationsRequest.h>
#include <aws/elasticloadbalancingv2/model/AddTrustStoreRevocationsResult.h>
#include <aws/elasticloadbalancingv2/model/AdministrativeOverride.h>
#include <aws/elasticloadbalancingv2/model/AdvertiseTrustStoreCaNamesEnum.h>
#include <aws/elasticloadbalancingv2/model/AnomalyDetection.h>
#include <aws/elasticloadbalancingv2/model/AnomalyResultEnum.h>
#include <aws/elasticloadbalancingv2/model/AuthenticateCognitoActionConditionalBehaviorEnum.h>
#include <aws/elasticloadbalancingv2/model/AuthenticateCognitoActionConfig.h>
#include <aws/elasticloadbalancingv2/model/AuthenticateOidcActionConditionalBehaviorEnum.h>
#include <aws/elasticloadbalancingv2/model/AuthenticateOidcActionConfig.h>
#include <aws/elasticloadbalancingv2/model/AvailabilityZone.h>
#include <aws/elasticloadbalancingv2/model/CapacityReservationStateEnum.h>
#include <aws/elasticloadbalancingv2/model/CapacityReservationStatus.h>
#include <aws/elasticloadbalancingv2/model/Certificate.h>
#include <aws/elasticloadbalancingv2/model/Cipher.h>
#include <aws/elasticloadbalancingv2/model/CreateListenerRequest.h>
#include <aws/elasticloadbalancingv2/model/CreateListenerResult.h>
#include <aws/elasticloadbalancingv2/model/CreateLoadBalancerRequest.h>
#include <aws/elasticloadbalancingv2/model/CreateLoadBalancerResult.h>
#include <aws/elasticloadbalancingv2/model/CreateRuleRequest.h>
#include <aws/elasticloadbalancingv2/model/CreateRuleResult.h>
#include <aws/elasticloadbalancingv2/model/CreateTargetGroupRequest.h>
#include <aws/elasticloadbalancingv2/model/CreateTargetGroupResult.h>
#include <aws/elasticloadbalancingv2/model/CreateTrustStoreRequest.h>
#include <aws/elasticloadbalancingv2/model/CreateTrustStoreResult.h>
#include <aws/elasticloadbalancingv2/model/DeleteListenerRequest.h>
#include <aws/elasticloadbalancingv2/model/DeleteListenerResult.h>
#include <aws/elasticloadbalancingv2/model/DeleteLoadBalancerRequest.h>
#include <aws/elasticloadbalancingv2/model/DeleteLoadBalancerResult.h>
#include <aws/elasticloadbalancingv2/model/DeleteRuleRequest.h>
#include <aws/elasticloadbalancingv2/model/DeleteRuleResult.h>
#include <aws/elasticloadbalancingv2/model/DeleteSharedTrustStoreAssociationRequest.h>
#include <aws/elasticloadbalancingv2/model/DeleteSharedTrustStoreAssociationResult.h>
#include <aws/elasticloadbalancingv2/model/DeleteTargetGroupRequest.h>
#include <aws/elasticloadbalancingv2/model/DeleteTargetGroupResult.h>
#include <aws/elasticloadbalancingv2/model/DeleteTrustStoreRequest.h>
#include <aws/elasticloadbalancingv2/model/DeleteTrustStoreResult.h>
#include <aws/elasticloadbalancingv2/model/DeregisterTargetsRequest.h>
#include <aws/elasticloadbalancingv2/model/DeregisterTargetsResult.h>
#include <aws/elasticloadbalancingv2/model/DescribeAccountLimitsRequest.h>
#include <aws/elasticloadbalancingv2/model/DescribeAccountLimitsResult.h>
#include <aws/elasticloadbalancingv2/model/DescribeCapacityReservationRequest.h>
#include <aws/elasticloadbalancingv2/model/DescribeCapacityReservationResult.h>
#include <aws/elasticloadbalancingv2/model/DescribeListenerAttributesRequest.h>
#include <aws/elasticloadbalancingv2/model/DescribeListenerAttributesResult.h>
#include <aws/elasticloadbalancingv2/model/DescribeListenerCertificatesRequest.h>
#include <aws/elasticloadbalancingv2/model/DescribeListenerCertificatesResult.h>
#include <aws/elasticloadbalancingv2/model/DescribeListenersRequest.h>
#include <aws/elasticloadbalancingv2/model/DescribeListenersResult.h>
#include <aws/elasticloadbalancingv2/model/DescribeLoadBalancerAttributesRequest.h>
#include <aws/elasticloadbalancingv2/model/DescribeLoadBalancerAttributesResult.h>
#include <aws/elasticloadbalancingv2/model/DescribeLoadBalancersRequest.h>
#include <aws/elasticloadbalancingv2/model/DescribeLoadBalancersResult.h>
#include <aws/elasticloadbalancingv2/model/DescribeRulesRequest.h>
#include <aws/elasticloadbalancingv2/model/DescribeRulesResult.h>
#include <aws/elasticloadbalancingv2/model/DescribeSSLPoliciesRequest.h>
#include <aws/elasticloadbalancingv2/model/DescribeSSLPoliciesResult.h>
#include <aws/elasticloadbalancingv2/model/DescribeTagsRequest.h>
#include <aws/elasticloadbalancingv2/model/DescribeTagsResult.h>
#include <aws/elasticloadbalancingv2/model/DescribeTargetGroupAttributesRequest.h>
#include <aws/elasticloadbalancingv2/model/DescribeTargetGroupAttributesResult.h>
#include <aws/elasticloadbalancingv2/model/DescribeTargetGroupsRequest.h>
#include <aws/elasticloadbalancingv2/model/DescribeTargetGroupsResult.h>
#include <aws/elasticloadbalancingv2/model/DescribeTargetHealthInputIncludeEnum.h>
#include <aws/elasticloadbalancingv2/model/DescribeTargetHealthRequest.h>
#include <aws/elasticloadbalancingv2/model/DescribeTargetHealthResult.h>
#include <aws/elasticloadbalancingv2/model/DescribeTrustStoreAssociationsRequest.h>
#include <aws/elasticloadbalancingv2/model/DescribeTrustStoreAssociationsResult.h>
#include <aws/elasticloadbalancingv2/model/DescribeTrustStoreRevocation.h>
#include <aws/elasticloadbalancingv2/model/DescribeTrustStoreRevocationsRequest.h>
#include <aws/elasticloadbalancingv2/model/DescribeTrustStoreRevocationsResult.h>
#include <aws/elasticloadbalancingv2/model/DescribeTrustStoresRequest.h>
#include <aws/elasticloadbalancingv2/model/DescribeTrustStoresResult.h>
#include <aws/elasticloadbalancingv2/model/EnablePrefixForIpv6SourceNatEnum.h>
#include <aws/elasticloadbalancingv2/model/EnforceSecurityGroupInboundRulesOnPrivateLinkTrafficEnum.h>
#include <aws/elasticloadbalancingv2/model/FixedResponseActionConfig.h>
#include <aws/elasticloadbalancingv2/model/ForwardActionConfig.h>
#include <aws/elasticloadbalancingv2/model/GetResourcePolicyRequest.h>
#include <aws/elasticloadbalancingv2/model/GetResourcePolicyResult.h>
#include <aws/elasticloadbalancingv2/model/GetTrustStoreCaCertificatesBundleRequest.h>
#include <aws/elasticloadbalancingv2/model/GetTrustStoreCaCertificatesBundleResult.h>
#include <aws/elasticloadbalancingv2/model/GetTrustStoreRevocationContentRequest.h>
#include <aws/elasticloadbalancingv2/model/GetTrustStoreRevocationContentResult.h>
#include <aws/elasticloadbalancingv2/model/HostHeaderConditionConfig.h>
#include <aws/elasticloadbalancingv2/model/HttpHeaderConditionConfig.h>
#include <aws/elasticloadbalancingv2/model/HttpRequestMethodConditionConfig.h>
#include <aws/elasticloadbalancingv2/model/IpAddressType.h>
#include <aws/elasticloadbalancingv2/model/IpamPools.h>
#include <aws/elasticloadbalancingv2/model/Limit.h>
#include <aws/elasticloadbalancingv2/model/Listener.h>
#include <aws/elasticloadbalancingv2/model/ListenerAttribute.h>
#include <aws/elasticloadbalancingv2/model/LoadBalancer.h>
#include <aws/elasticloadbalancingv2/model/LoadBalancerAddress.h>
#include <aws/elasticloadbalancingv2/model/LoadBalancerAttribute.h>
#include <aws/elasticloadbalancingv2/model/LoadBalancerSchemeEnum.h>
#include <aws/elasticloadbalancingv2/model/LoadBalancerState.h>
#include <aws/elasticloadbalancingv2/model/LoadBalancerStateEnum.h>
#include <aws/elasticloadbalancingv2/model/LoadBalancerTypeEnum.h>
#include <aws/elasticloadbalancingv2/model/Matcher.h>
#include <aws/elasticloadbalancingv2/model/MinimumLoadBalancerCapacity.h>
#include <aws/elasticloadbalancingv2/model/MitigationInEffectEnum.h>
#include <aws/elasticloadbalancingv2/model/ModifyCapacityReservationRequest.h>
#include <aws/elasticloadbalancingv2/model/ModifyCapacityReservationResult.h>
#include <aws/elasticloadbalancingv2/model/ModifyIpPoolsRequest.h>
#include <aws/elasticloadbalancingv2/model/ModifyIpPoolsResult.h>
#include <aws/elasticloadbalancingv2/model/ModifyListenerAttributesRequest.h>
#include <aws/elasticloadbalancingv2/model/ModifyListenerAttributesResult.h>
#include <aws/elasticloadbalancingv2/model/ModifyListenerRequest.h>
#include <aws/elasticloadbalancingv2/model/ModifyListenerResult.h>
#include <aws/elasticloadbalancingv2/model/ModifyLoadBalancerAttributesRequest.h>
#include <aws/elasticloadbalancingv2/model/ModifyLoadBalancerAttributesResult.h>
#include <aws/elasticloadbalancingv2/model/ModifyRuleRequest.h>
#include <aws/elasticloadbalancingv2/model/ModifyRuleResult.h>
#include <aws/elasticloadbalancingv2/model/ModifyTargetGroupAttributesRequest.h>
#include <aws/elasticloadbalancingv2/model/ModifyTargetGroupAttributesResult.h>
#include <aws/elasticloadbalancingv2/model/ModifyTargetGroupRequest.h>
#include <aws/elasticloadbalancingv2/model/ModifyTargetGroupResult.h>
#include <aws/elasticloadbalancingv2/model/ModifyTrustStoreRequest.h>
#include <aws/elasticloadbalancingv2/model/ModifyTrustStoreResult.h>
#include <aws/elasticloadbalancingv2/model/MutualAuthenticationAttributes.h>
#include <aws/elasticloadbalancingv2/model/PathPatternConditionConfig.h>
#include <aws/elasticloadbalancingv2/model/ProtocolEnum.h>
#include <aws/elasticloadbalancingv2/model/QueryStringConditionConfig.h>
#include <aws/elasticloadbalancingv2/model/QueryStringKeyValuePair.h>
#include <aws/elasticloadbalancingv2/model/RedirectActionConfig.h>
#include <aws/elasticloadbalancingv2/model/RedirectActionStatusCodeEnum.h>
#include <aws/elasticloadbalancingv2/model/RegisterTargetsRequest.h>
#include <aws/elasticloadbalancingv2/model/RegisterTargetsResult.h>
#include <aws/elasticloadbalancingv2/model/RemoveIpamPoolEnum.h>
#include <aws/elasticloadbalancingv2/model/RemoveListenerCertificatesRequest.h>
#include <aws/elasticloadbalancingv2/model/RemoveListenerCertificatesResult.h>
#include <aws/elasticloadbalancingv2/model/RemoveTagsRequest.h>
#include <aws/elasticloadbalancingv2/model/RemoveTagsResult.h>
#include <aws/elasticloadbalancingv2/model/RemoveTrustStoreRevocationsRequest.h>
#include <aws/elasticloadbalancingv2/model/RemoveTrustStoreRevocationsResult.h>
#include <aws/elasticloadbalancingv2/model/ResponseMetadata.h>
#include <aws/elasticloadbalancingv2/model/RevocationContent.h>
#include <aws/elasticloadbalancingv2/model/RevocationType.h>
#include <aws/elasticloadbalancingv2/model/Rule.h>
#include <aws/elasticloadbalancingv2/model/RuleCondition.h>
#include <aws/elasticloadbalancingv2/model/RulePriorityPair.h>
#include <aws/elasticloadbalancingv2/model/SetIpAddressTypeRequest.h>
#include <aws/elasticloadbalancingv2/model/SetIpAddressTypeResult.h>
#include <aws/elasticloadbalancingv2/model/SetRulePrioritiesRequest.h>
#include <aws/elasticloadbalancingv2/model/SetRulePrioritiesResult.h>
#include <aws/elasticloadbalancingv2/model/SetSecurityGroupsRequest.h>
#include <aws/elasticloadbalancingv2/model/SetSecurityGroupsResult.h>
#include <aws/elasticloadbalancingv2/model/SetSubnetsRequest.h>
#include <aws/elasticloadbalancingv2/model/SetSubnetsResult.h>
#include <aws/elasticloadbalancingv2/model/SourceIpConditionConfig.h>
#include <aws/elasticloadbalancingv2/model/SslPolicy.h>
#include <aws/elasticloadbalancingv2/model/SubnetMapping.h>
#include <aws/elasticloadbalancingv2/model/Tag.h>
#include <aws/elasticloadbalancingv2/model/TagDescription.h>
#include <aws/elasticloadbalancingv2/model/TargetAdministrativeOverrideReasonEnum.h>
#include <aws/elasticloadbalancingv2/model/TargetAdministrativeOverrideStateEnum.h>
#include <aws/elasticloadbalancingv2/model/TargetDescription.h>
#include <aws/elasticloadbalancingv2/model/TargetGroup.h>
#include <aws/elasticloadbalancingv2/model/TargetGroupAttribute.h>
#include <aws/elasticloadbalancingv2/model/TargetGroupIpAddressTypeEnum.h>
#include <aws/elasticloadbalancingv2/model/TargetGroupStickinessConfig.h>
#include <aws/elasticloadbalancingv2/model/TargetGroupTuple.h>
#include <aws/elasticloadbalancingv2/model/TargetHealth.h>
#include <aws/elasticloadbalancingv2/model/TargetHealthDescription.h>
#include <aws/elasticloadbalancingv2/model/TargetHealthReasonEnum.h>
#include <aws/elasticloadbalancingv2/model/TargetHealthStateEnum.h>
#include <aws/elasticloadbalancingv2/model/TargetTypeEnum.h>
#include <aws/elasticloadbalancingv2/model/TrustStore.h>
#include <aws/elasticloadbalancingv2/model/TrustStoreAssociation.h>
#include <aws/elasticloadbalancingv2/model/TrustStoreAssociationStatusEnum.h>
#include <aws/elasticloadbalancingv2/model/TrustStoreRevocation.h>
#include <aws/elasticloadbalancingv2/model/TrustStoreStatus.h>
#include <aws/elasticloadbalancingv2/model/ZonalCapacityReservationState.h>

using ElasticLoadBalancingv2IncludeTest = ::testing::Test;

TEST_F(ElasticLoadBalancingv2IncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::ElasticLoadBalancingv2::ElasticLoadBalancingv2Client>("ElasticLoadBalancingv2IncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
