/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/elasticmapreduce/EMRClient.h>
#include <aws/elasticmapreduce/EMREndpointProvider.h>
#include <aws/elasticmapreduce/EMREndpointRules.h>
#include <aws/elasticmapreduce/EMRErrorMarshaller.h>
#include <aws/elasticmapreduce/EMRErrors.h>
#include <aws/elasticmapreduce/EMRRequest.h>
#include <aws/elasticmapreduce/EMRServiceClientModel.h>
#include <aws/elasticmapreduce/EMR_EXPORTS.h>
#include <aws/elasticmapreduce/model/ActionOnFailure.h>
#include <aws/elasticmapreduce/model/AddInstanceFleetRequest.h>
#include <aws/elasticmapreduce/model/AddInstanceFleetResult.h>
#include <aws/elasticmapreduce/model/AddInstanceGroupsRequest.h>
#include <aws/elasticmapreduce/model/AddInstanceGroupsResult.h>
#include <aws/elasticmapreduce/model/AddJobFlowStepsRequest.h>
#include <aws/elasticmapreduce/model/AddJobFlowStepsResult.h>
#include <aws/elasticmapreduce/model/AddTagsRequest.h>
#include <aws/elasticmapreduce/model/AddTagsResult.h>
#include <aws/elasticmapreduce/model/AdjustmentType.h>
#include <aws/elasticmapreduce/model/Application.h>
#include <aws/elasticmapreduce/model/AuthMode.h>
#include <aws/elasticmapreduce/model/AutoScalingPolicy.h>
#include <aws/elasticmapreduce/model/AutoScalingPolicyDescription.h>
#include <aws/elasticmapreduce/model/AutoScalingPolicyState.h>
#include <aws/elasticmapreduce/model/AutoScalingPolicyStateChangeReason.h>
#include <aws/elasticmapreduce/model/AutoScalingPolicyStateChangeReasonCode.h>
#include <aws/elasticmapreduce/model/AutoScalingPolicyStatus.h>
#include <aws/elasticmapreduce/model/AutoTerminationPolicy.h>
#include <aws/elasticmapreduce/model/BlockPublicAccessConfiguration.h>
#include <aws/elasticmapreduce/model/BlockPublicAccessConfigurationMetadata.h>
#include <aws/elasticmapreduce/model/BootstrapActionConfig.h>
#include <aws/elasticmapreduce/model/BootstrapActionDetail.h>
#include <aws/elasticmapreduce/model/CancelStepsInfo.h>
#include <aws/elasticmapreduce/model/CancelStepsRequest.h>
#include <aws/elasticmapreduce/model/CancelStepsRequestStatus.h>
#include <aws/elasticmapreduce/model/CancelStepsResult.h>
#include <aws/elasticmapreduce/model/CloudWatchAlarmDefinition.h>
#include <aws/elasticmapreduce/model/Cluster.h>
#include <aws/elasticmapreduce/model/ClusterState.h>
#include <aws/elasticmapreduce/model/ClusterStateChangeReason.h>
#include <aws/elasticmapreduce/model/ClusterStateChangeReasonCode.h>
#include <aws/elasticmapreduce/model/ClusterStatus.h>
#include <aws/elasticmapreduce/model/ClusterSummary.h>
#include <aws/elasticmapreduce/model/ClusterTimeline.h>
#include <aws/elasticmapreduce/model/Command.h>
#include <aws/elasticmapreduce/model/ComparisonOperator.h>
#include <aws/elasticmapreduce/model/ComputeLimits.h>
#include <aws/elasticmapreduce/model/ComputeLimitsUnitType.h>
#include <aws/elasticmapreduce/model/Configuration.h>
#include <aws/elasticmapreduce/model/CreatePersistentAppUIRequest.h>
#include <aws/elasticmapreduce/model/CreatePersistentAppUIResult.h>
#include <aws/elasticmapreduce/model/CreateSecurityConfigurationRequest.h>
#include <aws/elasticmapreduce/model/CreateSecurityConfigurationResult.h>
#include <aws/elasticmapreduce/model/CreateStudioRequest.h>
#include <aws/elasticmapreduce/model/CreateStudioResult.h>
#include <aws/elasticmapreduce/model/CreateStudioSessionMappingRequest.h>
#include <aws/elasticmapreduce/model/Credentials.h>
#include <aws/elasticmapreduce/model/DeleteSecurityConfigurationRequest.h>
#include <aws/elasticmapreduce/model/DeleteSecurityConfigurationResult.h>
#include <aws/elasticmapreduce/model/DeleteStudioRequest.h>
#include <aws/elasticmapreduce/model/DeleteStudioSessionMappingRequest.h>
#include <aws/elasticmapreduce/model/DescribeClusterRequest.h>
#include <aws/elasticmapreduce/model/DescribeClusterResult.h>
#include <aws/elasticmapreduce/model/DescribeNotebookExecutionRequest.h>
#include <aws/elasticmapreduce/model/DescribeNotebookExecutionResult.h>
#include <aws/elasticmapreduce/model/DescribePersistentAppUIRequest.h>
#include <aws/elasticmapreduce/model/DescribePersistentAppUIResult.h>
#include <aws/elasticmapreduce/model/DescribeReleaseLabelRequest.h>
#include <aws/elasticmapreduce/model/DescribeReleaseLabelResult.h>
#include <aws/elasticmapreduce/model/DescribeSecurityConfigurationRequest.h>
#include <aws/elasticmapreduce/model/DescribeSecurityConfigurationResult.h>
#include <aws/elasticmapreduce/model/DescribeStepRequest.h>
#include <aws/elasticmapreduce/model/DescribeStepResult.h>
#include <aws/elasticmapreduce/model/DescribeStudioRequest.h>
#include <aws/elasticmapreduce/model/DescribeStudioResult.h>
#include <aws/elasticmapreduce/model/EMRContainersConfig.h>
#include <aws/elasticmapreduce/model/EbsBlockDevice.h>
#include <aws/elasticmapreduce/model/EbsBlockDeviceConfig.h>
#include <aws/elasticmapreduce/model/EbsConfiguration.h>
#include <aws/elasticmapreduce/model/EbsVolume.h>
#include <aws/elasticmapreduce/model/Ec2InstanceAttributes.h>
#include <aws/elasticmapreduce/model/ErrorDetail.h>
#include <aws/elasticmapreduce/model/ExecutionEngineConfig.h>
#include <aws/elasticmapreduce/model/ExecutionEngineType.h>
#include <aws/elasticmapreduce/model/FailureDetails.h>
#include <aws/elasticmapreduce/model/GetAutoTerminationPolicyRequest.h>
#include <aws/elasticmapreduce/model/GetAutoTerminationPolicyResult.h>
#include <aws/elasticmapreduce/model/GetBlockPublicAccessConfigurationRequest.h>
#include <aws/elasticmapreduce/model/GetBlockPublicAccessConfigurationResult.h>
#include <aws/elasticmapreduce/model/GetClusterSessionCredentialsRequest.h>
#include <aws/elasticmapreduce/model/GetClusterSessionCredentialsResult.h>
#include <aws/elasticmapreduce/model/GetManagedScalingPolicyRequest.h>
#include <aws/elasticmapreduce/model/GetManagedScalingPolicyResult.h>
#include <aws/elasticmapreduce/model/GetOnClusterAppUIPresignedURLRequest.h>
#include <aws/elasticmapreduce/model/GetOnClusterAppUIPresignedURLResult.h>
#include <aws/elasticmapreduce/model/GetPersistentAppUIPresignedURLRequest.h>
#include <aws/elasticmapreduce/model/GetPersistentAppUIPresignedURLResult.h>
#include <aws/elasticmapreduce/model/GetStudioSessionMappingRequest.h>
#include <aws/elasticmapreduce/model/GetStudioSessionMappingResult.h>
#include <aws/elasticmapreduce/model/HadoopJarStepConfig.h>
#include <aws/elasticmapreduce/model/HadoopStepConfig.h>
#include <aws/elasticmapreduce/model/IdcUserAssignment.h>
#include <aws/elasticmapreduce/model/IdentityType.h>
#include <aws/elasticmapreduce/model/Instance.h>
#include <aws/elasticmapreduce/model/InstanceCollectionType.h>
#include <aws/elasticmapreduce/model/InstanceFleet.h>
#include <aws/elasticmapreduce/model/InstanceFleetConfig.h>
#include <aws/elasticmapreduce/model/InstanceFleetModifyConfig.h>
#include <aws/elasticmapreduce/model/InstanceFleetProvisioningSpecifications.h>
#include <aws/elasticmapreduce/model/InstanceFleetResizingSpecifications.h>
#include <aws/elasticmapreduce/model/InstanceFleetState.h>
#include <aws/elasticmapreduce/model/InstanceFleetStateChangeReason.h>
#include <aws/elasticmapreduce/model/InstanceFleetStateChangeReasonCode.h>
#include <aws/elasticmapreduce/model/InstanceFleetStatus.h>
#include <aws/elasticmapreduce/model/InstanceFleetTimeline.h>
#include <aws/elasticmapreduce/model/InstanceFleetType.h>
#include <aws/elasticmapreduce/model/InstanceGroup.h>
#include <aws/elasticmapreduce/model/InstanceGroupConfig.h>
#include <aws/elasticmapreduce/model/InstanceGroupDetail.h>
#include <aws/elasticmapreduce/model/InstanceGroupModifyConfig.h>
#include <aws/elasticmapreduce/model/InstanceGroupState.h>
#include <aws/elasticmapreduce/model/InstanceGroupStateChangeReason.h>
#include <aws/elasticmapreduce/model/InstanceGroupStateChangeReasonCode.h>
#include <aws/elasticmapreduce/model/InstanceGroupStatus.h>
#include <aws/elasticmapreduce/model/InstanceGroupTimeline.h>
#include <aws/elasticmapreduce/model/InstanceGroupType.h>
#include <aws/elasticmapreduce/model/InstanceResizePolicy.h>
#include <aws/elasticmapreduce/model/InstanceRoleType.h>
#include <aws/elasticmapreduce/model/InstanceState.h>
#include <aws/elasticmapreduce/model/InstanceStateChangeReason.h>
#include <aws/elasticmapreduce/model/InstanceStateChangeReasonCode.h>
#include <aws/elasticmapreduce/model/InstanceStatus.h>
#include <aws/elasticmapreduce/model/InstanceTimeline.h>
#include <aws/elasticmapreduce/model/InstanceTypeConfig.h>
#include <aws/elasticmapreduce/model/InstanceTypeSpecification.h>
#include <aws/elasticmapreduce/model/InvalidRequestException.h>
#include <aws/elasticmapreduce/model/JobFlowDetail.h>
#include <aws/elasticmapreduce/model/JobFlowExecutionState.h>
#include <aws/elasticmapreduce/model/JobFlowExecutionStatusDetail.h>
#include <aws/elasticmapreduce/model/JobFlowInstancesConfig.h>
#include <aws/elasticmapreduce/model/JobFlowInstancesDetail.h>
#include <aws/elasticmapreduce/model/KerberosAttributes.h>
#include <aws/elasticmapreduce/model/KeyValue.h>
#include <aws/elasticmapreduce/model/ListBootstrapActionsRequest.h>
#include <aws/elasticmapreduce/model/ListBootstrapActionsResult.h>
#include <aws/elasticmapreduce/model/ListClustersRequest.h>
#include <aws/elasticmapreduce/model/ListClustersResult.h>
#include <aws/elasticmapreduce/model/ListInstanceFleetsRequest.h>
#include <aws/elasticmapreduce/model/ListInstanceFleetsResult.h>
#include <aws/elasticmapreduce/model/ListInstanceGroupsRequest.h>
#include <aws/elasticmapreduce/model/ListInstanceGroupsResult.h>
#include <aws/elasticmapreduce/model/ListInstancesRequest.h>
#include <aws/elasticmapreduce/model/ListInstancesResult.h>
#include <aws/elasticmapreduce/model/ListNotebookExecutionsRequest.h>
#include <aws/elasticmapreduce/model/ListNotebookExecutionsResult.h>
#include <aws/elasticmapreduce/model/ListReleaseLabelsRequest.h>
#include <aws/elasticmapreduce/model/ListReleaseLabelsResult.h>
#include <aws/elasticmapreduce/model/ListSecurityConfigurationsRequest.h>
#include <aws/elasticmapreduce/model/ListSecurityConfigurationsResult.h>
#include <aws/elasticmapreduce/model/ListStepsRequest.h>
#include <aws/elasticmapreduce/model/ListStepsResult.h>
#include <aws/elasticmapreduce/model/ListStudioSessionMappingsRequest.h>
#include <aws/elasticmapreduce/model/ListStudioSessionMappingsResult.h>
#include <aws/elasticmapreduce/model/ListStudiosRequest.h>
#include <aws/elasticmapreduce/model/ListStudiosResult.h>
#include <aws/elasticmapreduce/model/ListSupportedInstanceTypesRequest.h>
#include <aws/elasticmapreduce/model/ListSupportedInstanceTypesResult.h>
#include <aws/elasticmapreduce/model/ManagedScalingPolicy.h>
#include <aws/elasticmapreduce/model/MarketType.h>
#include <aws/elasticmapreduce/model/MetricDimension.h>
#include <aws/elasticmapreduce/model/ModifyClusterRequest.h>
#include <aws/elasticmapreduce/model/ModifyClusterResult.h>
#include <aws/elasticmapreduce/model/ModifyInstanceFleetRequest.h>
#include <aws/elasticmapreduce/model/ModifyInstanceGroupsRequest.h>
#include <aws/elasticmapreduce/model/NotebookExecution.h>
#include <aws/elasticmapreduce/model/NotebookExecutionStatus.h>
#include <aws/elasticmapreduce/model/NotebookExecutionSummary.h>
#include <aws/elasticmapreduce/model/NotebookS3LocationForOutput.h>
#include <aws/elasticmapreduce/model/NotebookS3LocationFromInput.h>
#include <aws/elasticmapreduce/model/OSRelease.h>
#include <aws/elasticmapreduce/model/OnClusterAppUIType.h>
#include <aws/elasticmapreduce/model/OnDemandCapacityReservationOptions.h>
#include <aws/elasticmapreduce/model/OnDemandCapacityReservationPreference.h>
#include <aws/elasticmapreduce/model/OnDemandCapacityReservationUsageStrategy.h>
#include <aws/elasticmapreduce/model/OnDemandProvisioningAllocationStrategy.h>
#include <aws/elasticmapreduce/model/OnDemandProvisioningSpecification.h>
#include <aws/elasticmapreduce/model/OnDemandResizingSpecification.h>
#include <aws/elasticmapreduce/model/OutputNotebookFormat.h>
#include <aws/elasticmapreduce/model/OutputNotebookS3LocationForOutput.h>
#include <aws/elasticmapreduce/model/OutputNotebookS3LocationFromInput.h>
#include <aws/elasticmapreduce/model/PersistentAppUI.h>
#include <aws/elasticmapreduce/model/PersistentAppUIType.h>
#include <aws/elasticmapreduce/model/PlacementGroupConfig.h>
#include <aws/elasticmapreduce/model/PlacementGroupStrategy.h>
#include <aws/elasticmapreduce/model/PlacementType.h>
#include <aws/elasticmapreduce/model/PortRange.h>
#include <aws/elasticmapreduce/model/ProfilerType.h>
#include <aws/elasticmapreduce/model/PutAutoScalingPolicyRequest.h>
#include <aws/elasticmapreduce/model/PutAutoScalingPolicyResult.h>
#include <aws/elasticmapreduce/model/PutAutoTerminationPolicyRequest.h>
#include <aws/elasticmapreduce/model/PutAutoTerminationPolicyResult.h>
#include <aws/elasticmapreduce/model/PutBlockPublicAccessConfigurationRequest.h>
#include <aws/elasticmapreduce/model/PutBlockPublicAccessConfigurationResult.h>
#include <aws/elasticmapreduce/model/PutManagedScalingPolicyRequest.h>
#include <aws/elasticmapreduce/model/PutManagedScalingPolicyResult.h>
#include <aws/elasticmapreduce/model/ReconfigurationType.h>
#include <aws/elasticmapreduce/model/ReleaseLabelFilter.h>
#include <aws/elasticmapreduce/model/RemoveAutoScalingPolicyRequest.h>
#include <aws/elasticmapreduce/model/RemoveAutoScalingPolicyResult.h>
#include <aws/elasticmapreduce/model/RemoveAutoTerminationPolicyRequest.h>
#include <aws/elasticmapreduce/model/RemoveAutoTerminationPolicyResult.h>
#include <aws/elasticmapreduce/model/RemoveManagedScalingPolicyRequest.h>
#include <aws/elasticmapreduce/model/RemoveManagedScalingPolicyResult.h>
#include <aws/elasticmapreduce/model/RemoveTagsRequest.h>
#include <aws/elasticmapreduce/model/RemoveTagsResult.h>
#include <aws/elasticmapreduce/model/RepoUpgradeOnBoot.h>
#include <aws/elasticmapreduce/model/RunJobFlowRequest.h>
#include <aws/elasticmapreduce/model/RunJobFlowResult.h>
#include <aws/elasticmapreduce/model/ScaleDownBehavior.h>
#include <aws/elasticmapreduce/model/ScalingAction.h>
#include <aws/elasticmapreduce/model/ScalingConstraints.h>
#include <aws/elasticmapreduce/model/ScalingRule.h>
#include <aws/elasticmapreduce/model/ScalingStrategy.h>
#include <aws/elasticmapreduce/model/ScalingTrigger.h>
#include <aws/elasticmapreduce/model/ScriptBootstrapActionConfig.h>
#include <aws/elasticmapreduce/model/SecurityConfigurationSummary.h>
#include <aws/elasticmapreduce/model/SessionMappingDetail.h>
#include <aws/elasticmapreduce/model/SessionMappingSummary.h>
#include <aws/elasticmapreduce/model/SetKeepJobFlowAliveWhenNoStepsRequest.h>
#include <aws/elasticmapreduce/model/SetTerminationProtectionRequest.h>
#include <aws/elasticmapreduce/model/SetUnhealthyNodeReplacementRequest.h>
#include <aws/elasticmapreduce/model/SetVisibleToAllUsersRequest.h>
#include <aws/elasticmapreduce/model/ShrinkPolicy.h>
#include <aws/elasticmapreduce/model/SimpleScalingPolicyConfiguration.h>
#include <aws/elasticmapreduce/model/SimplifiedApplication.h>
#include <aws/elasticmapreduce/model/SpotProvisioningAllocationStrategy.h>
#include <aws/elasticmapreduce/model/SpotProvisioningSpecification.h>
#include <aws/elasticmapreduce/model/SpotProvisioningTimeoutAction.h>
#include <aws/elasticmapreduce/model/SpotResizingSpecification.h>
#include <aws/elasticmapreduce/model/StartNotebookExecutionRequest.h>
#include <aws/elasticmapreduce/model/StartNotebookExecutionResult.h>
#include <aws/elasticmapreduce/model/Statistic.h>
#include <aws/elasticmapreduce/model/Step.h>
#include <aws/elasticmapreduce/model/StepCancellationOption.h>
#include <aws/elasticmapreduce/model/StepConfig.h>
#include <aws/elasticmapreduce/model/StepDetail.h>
#include <aws/elasticmapreduce/model/StepExecutionState.h>
#include <aws/elasticmapreduce/model/StepExecutionStatusDetail.h>
#include <aws/elasticmapreduce/model/StepState.h>
#include <aws/elasticmapreduce/model/StepStateChangeReason.h>
#include <aws/elasticmapreduce/model/StepStateChangeReasonCode.h>
#include <aws/elasticmapreduce/model/StepStatus.h>
#include <aws/elasticmapreduce/model/StepSummary.h>
#include <aws/elasticmapreduce/model/StepTimeline.h>
#include <aws/elasticmapreduce/model/StopNotebookExecutionRequest.h>
#include <aws/elasticmapreduce/model/Studio.h>
#include <aws/elasticmapreduce/model/StudioSummary.h>
#include <aws/elasticmapreduce/model/SupportedInstanceType.h>
#include <aws/elasticmapreduce/model/SupportedProductConfig.h>
#include <aws/elasticmapreduce/model/Tag.h>
#include <aws/elasticmapreduce/model/TerminateJobFlowsRequest.h>
#include <aws/elasticmapreduce/model/Unit.h>
#include <aws/elasticmapreduce/model/UpdateStudioRequest.h>
#include <aws/elasticmapreduce/model/UpdateStudioSessionMappingRequest.h>
#include <aws/elasticmapreduce/model/UsernamePassword.h>
#include <aws/elasticmapreduce/model/VolumeSpecification.h>

using EMRIncludeTest = ::testing::Test;

TEST_F(EMRIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::EMR::EMRClient>("EMRIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
