/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/email/SESClient.h>
#include <aws/email/SESEndpointProvider.h>
#include <aws/email/SESEndpointRules.h>
#include <aws/email/SESErrorMarshaller.h>
#include <aws/email/SESErrors.h>
#include <aws/email/SESRequest.h>
#include <aws/email/SESServiceClientModel.h>
#include <aws/email/SES_EXPORTS.h>
#include <aws/email/model/AddHeaderAction.h>
#include <aws/email/model/AlreadyExistsException.h>
#include <aws/email/model/BehaviorOnMXFailure.h>
#include <aws/email/model/Body.h>
#include <aws/email/model/BounceAction.h>
#include <aws/email/model/BounceType.h>
#include <aws/email/model/BouncedRecipientInfo.h>
#include <aws/email/model/BulkEmailDestination.h>
#include <aws/email/model/BulkEmailDestinationStatus.h>
#include <aws/email/model/BulkEmailStatus.h>
#include <aws/email/model/CannotDeleteException.h>
#include <aws/email/model/CloneReceiptRuleSetRequest.h>
#include <aws/email/model/CloneReceiptRuleSetResult.h>
#include <aws/email/model/CloudWatchDestination.h>
#include <aws/email/model/CloudWatchDimensionConfiguration.h>
#include <aws/email/model/ConfigurationSet.h>
#include <aws/email/model/ConfigurationSetAlreadyExistsException.h>
#include <aws/email/model/ConfigurationSetAttribute.h>
#include <aws/email/model/ConfigurationSetDoesNotExistException.h>
#include <aws/email/model/ConfigurationSetSendingPausedException.h>
#include <aws/email/model/ConnectAction.h>
#include <aws/email/model/Content.h>
#include <aws/email/model/CreateConfigurationSetEventDestinationRequest.h>
#include <aws/email/model/CreateConfigurationSetEventDestinationResult.h>
#include <aws/email/model/CreateConfigurationSetRequest.h>
#include <aws/email/model/CreateConfigurationSetResult.h>
#include <aws/email/model/CreateConfigurationSetTrackingOptionsRequest.h>
#include <aws/email/model/CreateConfigurationSetTrackingOptionsResult.h>
#include <aws/email/model/CreateCustomVerificationEmailTemplateRequest.h>
#include <aws/email/model/CreateReceiptFilterRequest.h>
#include <aws/email/model/CreateReceiptFilterResult.h>
#include <aws/email/model/CreateReceiptRuleRequest.h>
#include <aws/email/model/CreateReceiptRuleResult.h>
#include <aws/email/model/CreateReceiptRuleSetRequest.h>
#include <aws/email/model/CreateReceiptRuleSetResult.h>
#include <aws/email/model/CreateTemplateRequest.h>
#include <aws/email/model/CreateTemplateResult.h>
#include <aws/email/model/CustomMailFromStatus.h>
#include <aws/email/model/CustomVerificationEmailTemplate.h>
#include <aws/email/model/CustomVerificationEmailTemplateAlreadyExistsException.h>
#include <aws/email/model/CustomVerificationEmailTemplateDoesNotExistException.h>
#include <aws/email/model/DeleteConfigurationSetEventDestinationRequest.h>
#include <aws/email/model/DeleteConfigurationSetEventDestinationResult.h>
#include <aws/email/model/DeleteConfigurationSetRequest.h>
#include <aws/email/model/DeleteConfigurationSetResult.h>
#include <aws/email/model/DeleteConfigurationSetTrackingOptionsRequest.h>
#include <aws/email/model/DeleteConfigurationSetTrackingOptionsResult.h>
#include <aws/email/model/DeleteCustomVerificationEmailTemplateRequest.h>
#include <aws/email/model/DeleteIdentityPolicyRequest.h>
#include <aws/email/model/DeleteIdentityPolicyResult.h>
#include <aws/email/model/DeleteIdentityRequest.h>
#include <aws/email/model/DeleteIdentityResult.h>
#include <aws/email/model/DeleteReceiptFilterRequest.h>
#include <aws/email/model/DeleteReceiptFilterResult.h>
#include <aws/email/model/DeleteReceiptRuleRequest.h>
#include <aws/email/model/DeleteReceiptRuleResult.h>
#include <aws/email/model/DeleteReceiptRuleSetRequest.h>
#include <aws/email/model/DeleteReceiptRuleSetResult.h>
#include <aws/email/model/DeleteTemplateRequest.h>
#include <aws/email/model/DeleteTemplateResult.h>
#include <aws/email/model/DeleteVerifiedEmailAddressRequest.h>
#include <aws/email/model/DeliveryOptions.h>
#include <aws/email/model/DescribeActiveReceiptRuleSetRequest.h>
#include <aws/email/model/DescribeActiveReceiptRuleSetResult.h>
#include <aws/email/model/DescribeConfigurationSetRequest.h>
#include <aws/email/model/DescribeConfigurationSetResult.h>
#include <aws/email/model/DescribeReceiptRuleRequest.h>
#include <aws/email/model/DescribeReceiptRuleResult.h>
#include <aws/email/model/DescribeReceiptRuleSetRequest.h>
#include <aws/email/model/DescribeReceiptRuleSetResult.h>
#include <aws/email/model/Destination.h>
#include <aws/email/model/DimensionValueSource.h>
#include <aws/email/model/DsnAction.h>
#include <aws/email/model/EventDestination.h>
#include <aws/email/model/EventDestinationAlreadyExistsException.h>
#include <aws/email/model/EventDestinationDoesNotExistException.h>
#include <aws/email/model/EventType.h>
#include <aws/email/model/ExtensionField.h>
#include <aws/email/model/FromEmailAddressNotVerifiedException.h>
#include <aws/email/model/GetAccountSendingEnabledRequest.h>
#include <aws/email/model/GetAccountSendingEnabledResult.h>
#include <aws/email/model/GetCustomVerificationEmailTemplateRequest.h>
#include <aws/email/model/GetCustomVerificationEmailTemplateResult.h>
#include <aws/email/model/GetIdentityDkimAttributesRequest.h>
#include <aws/email/model/GetIdentityDkimAttributesResult.h>
#include <aws/email/model/GetIdentityMailFromDomainAttributesRequest.h>
#include <aws/email/model/GetIdentityMailFromDomainAttributesResult.h>
#include <aws/email/model/GetIdentityNotificationAttributesRequest.h>
#include <aws/email/model/GetIdentityNotificationAttributesResult.h>
#include <aws/email/model/GetIdentityPoliciesRequest.h>
#include <aws/email/model/GetIdentityPoliciesResult.h>
#include <aws/email/model/GetIdentityVerificationAttributesRequest.h>
#include <aws/email/model/GetIdentityVerificationAttributesResult.h>
#include <aws/email/model/GetSendQuotaRequest.h>
#include <aws/email/model/GetSendQuotaResult.h>
#include <aws/email/model/GetSendStatisticsRequest.h>
#include <aws/email/model/GetSendStatisticsResult.h>
#include <aws/email/model/GetTemplateRequest.h>
#include <aws/email/model/GetTemplateResult.h>
#include <aws/email/model/IdentityDkimAttributes.h>
#include <aws/email/model/IdentityMailFromDomainAttributes.h>
#include <aws/email/model/IdentityNotificationAttributes.h>
#include <aws/email/model/IdentityType.h>
#include <aws/email/model/IdentityVerificationAttributes.h>
#include <aws/email/model/InvalidCloudWatchDestinationException.h>
#include <aws/email/model/InvalidFirehoseDestinationException.h>
#include <aws/email/model/InvalidLambdaFunctionException.h>
#include <aws/email/model/InvalidRenderingParameterException.h>
#include <aws/email/model/InvalidS3ConfigurationException.h>
#include <aws/email/model/InvalidSNSDestinationException.h>
#include <aws/email/model/InvalidSnsTopicException.h>
#include <aws/email/model/InvalidTemplateException.h>
#include <aws/email/model/InvocationType.h>
#include <aws/email/model/KinesisFirehoseDestination.h>
#include <aws/email/model/LambdaAction.h>
#include <aws/email/model/ListConfigurationSetsRequest.h>
#include <aws/email/model/ListConfigurationSetsResult.h>
#include <aws/email/model/ListCustomVerificationEmailTemplatesRequest.h>
#include <aws/email/model/ListCustomVerificationEmailTemplatesResult.h>
#include <aws/email/model/ListIdentitiesRequest.h>
#include <aws/email/model/ListIdentitiesResult.h>
#include <aws/email/model/ListIdentityPoliciesRequest.h>
#include <aws/email/model/ListIdentityPoliciesResult.h>
#include <aws/email/model/ListReceiptFiltersRequest.h>
#include <aws/email/model/ListReceiptFiltersResult.h>
#include <aws/email/model/ListReceiptRuleSetsRequest.h>
#include <aws/email/model/ListReceiptRuleSetsResult.h>
#include <aws/email/model/ListTemplatesRequest.h>
#include <aws/email/model/ListTemplatesResult.h>
#include <aws/email/model/ListVerifiedEmailAddressesRequest.h>
#include <aws/email/model/ListVerifiedEmailAddressesResult.h>
#include <aws/email/model/Message.h>
#include <aws/email/model/MessageDsn.h>
#include <aws/email/model/MessageTag.h>
#include <aws/email/model/MissingRenderingAttributeException.h>
#include <aws/email/model/NotificationType.h>
#include <aws/email/model/PutConfigurationSetDeliveryOptionsRequest.h>
#include <aws/email/model/PutConfigurationSetDeliveryOptionsResult.h>
#include <aws/email/model/PutIdentityPolicyRequest.h>
#include <aws/email/model/PutIdentityPolicyResult.h>
#include <aws/email/model/RawMessage.h>
#include <aws/email/model/ReceiptAction.h>
#include <aws/email/model/ReceiptFilter.h>
#include <aws/email/model/ReceiptFilterPolicy.h>
#include <aws/email/model/ReceiptIpFilter.h>
#include <aws/email/model/ReceiptRule.h>
#include <aws/email/model/ReceiptRuleSetMetadata.h>
#include <aws/email/model/RecipientDsnFields.h>
#include <aws/email/model/ReorderReceiptRuleSetRequest.h>
#include <aws/email/model/ReorderReceiptRuleSetResult.h>
#include <aws/email/model/ReputationOptions.h>
#include <aws/email/model/ResponseMetadata.h>
#include <aws/email/model/RuleDoesNotExistException.h>
#include <aws/email/model/RuleSetDoesNotExistException.h>
#include <aws/email/model/S3Action.h>
#include <aws/email/model/SNSAction.h>
#include <aws/email/model/SNSActionEncoding.h>
#include <aws/email/model/SNSDestination.h>
#include <aws/email/model/SendBounceRequest.h>
#include <aws/email/model/SendBounceResult.h>
#include <aws/email/model/SendBulkTemplatedEmailRequest.h>
#include <aws/email/model/SendBulkTemplatedEmailResult.h>
#include <aws/email/model/SendCustomVerificationEmailRequest.h>
#include <aws/email/model/SendCustomVerificationEmailResult.h>
#include <aws/email/model/SendDataPoint.h>
#include <aws/email/model/SendEmailRequest.h>
#include <aws/email/model/SendEmailResult.h>
#include <aws/email/model/SendRawEmailRequest.h>
#include <aws/email/model/SendRawEmailResult.h>
#include <aws/email/model/SendTemplatedEmailRequest.h>
#include <aws/email/model/SendTemplatedEmailResult.h>
#include <aws/email/model/SetActiveReceiptRuleSetRequest.h>
#include <aws/email/model/SetActiveReceiptRuleSetResult.h>
#include <aws/email/model/SetIdentityDkimEnabledRequest.h>
#include <aws/email/model/SetIdentityDkimEnabledResult.h>
#include <aws/email/model/SetIdentityFeedbackForwardingEnabledRequest.h>
#include <aws/email/model/SetIdentityFeedbackForwardingEnabledResult.h>
#include <aws/email/model/SetIdentityHeadersInNotificationsEnabledRequest.h>
#include <aws/email/model/SetIdentityHeadersInNotificationsEnabledResult.h>
#include <aws/email/model/SetIdentityMailFromDomainRequest.h>
#include <aws/email/model/SetIdentityMailFromDomainResult.h>
#include <aws/email/model/SetIdentityNotificationTopicRequest.h>
#include <aws/email/model/SetIdentityNotificationTopicResult.h>
#include <aws/email/model/SetReceiptRulePositionRequest.h>
#include <aws/email/model/SetReceiptRulePositionResult.h>
#include <aws/email/model/StopAction.h>
#include <aws/email/model/StopScope.h>
#include <aws/email/model/Template.h>
#include <aws/email/model/TemplateDoesNotExistException.h>
#include <aws/email/model/TemplateMetadata.h>
#include <aws/email/model/TestRenderTemplateRequest.h>
#include <aws/email/model/TestRenderTemplateResult.h>
#include <aws/email/model/TlsPolicy.h>
#include <aws/email/model/TrackingOptions.h>
#include <aws/email/model/TrackingOptionsAlreadyExistsException.h>
#include <aws/email/model/TrackingOptionsDoesNotExistException.h>
#include <aws/email/model/UpdateAccountSendingEnabledRequest.h>
#include <aws/email/model/UpdateConfigurationSetEventDestinationRequest.h>
#include <aws/email/model/UpdateConfigurationSetEventDestinationResult.h>
#include <aws/email/model/UpdateConfigurationSetReputationMetricsEnabledRequest.h>
#include <aws/email/model/UpdateConfigurationSetSendingEnabledRequest.h>
#include <aws/email/model/UpdateConfigurationSetTrackingOptionsRequest.h>
#include <aws/email/model/UpdateConfigurationSetTrackingOptionsResult.h>
#include <aws/email/model/UpdateCustomVerificationEmailTemplateRequest.h>
#include <aws/email/model/UpdateReceiptRuleRequest.h>
#include <aws/email/model/UpdateReceiptRuleResult.h>
#include <aws/email/model/UpdateTemplateRequest.h>
#include <aws/email/model/UpdateTemplateResult.h>
#include <aws/email/model/VerificationStatus.h>
#include <aws/email/model/VerifyDomainDkimRequest.h>
#include <aws/email/model/VerifyDomainDkimResult.h>
#include <aws/email/model/VerifyDomainIdentityRequest.h>
#include <aws/email/model/VerifyDomainIdentityResult.h>
#include <aws/email/model/VerifyEmailAddressRequest.h>
#include <aws/email/model/VerifyEmailIdentityRequest.h>
#include <aws/email/model/VerifyEmailIdentityResult.h>
#include <aws/email/model/WorkmailAction.h>

using SESIncludeTest = ::testing::Test;

TEST_F(SESIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::SES::SESClient>("SESIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
