/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/es/ElasticsearchServiceClient.h>
#include <aws/es/ElasticsearchServiceEndpointProvider.h>
#include <aws/es/ElasticsearchServiceEndpointRules.h>
#include <aws/es/ElasticsearchServiceErrorMarshaller.h>
#include <aws/es/ElasticsearchServiceErrors.h>
#include <aws/es/ElasticsearchServiceRequest.h>
#include <aws/es/ElasticsearchServiceServiceClientModel.h>
#include <aws/es/ElasticsearchService_EXPORTS.h>
#include <aws/es/model/AcceptInboundCrossClusterSearchConnectionRequest.h>
#include <aws/es/model/AcceptInboundCrossClusterSearchConnectionResult.h>
#include <aws/es/model/AccessPoliciesStatus.h>
#include <aws/es/model/AddTagsRequest.h>
#include <aws/es/model/AdditionalLimit.h>
#include <aws/es/model/AdvancedOptionsStatus.h>
#include <aws/es/model/AdvancedSecurityOptions.h>
#include <aws/es/model/AdvancedSecurityOptionsInput.h>
#include <aws/es/model/AdvancedSecurityOptionsStatus.h>
#include <aws/es/model/AssociatePackageRequest.h>
#include <aws/es/model/AssociatePackageResult.h>
#include <aws/es/model/AuthorizeVpcEndpointAccessRequest.h>
#include <aws/es/model/AuthorizeVpcEndpointAccessResult.h>
#include <aws/es/model/AuthorizedPrincipal.h>
#include <aws/es/model/AutoTune.h>
#include <aws/es/model/AutoTuneDesiredState.h>
#include <aws/es/model/AutoTuneDetails.h>
#include <aws/es/model/AutoTuneMaintenanceSchedule.h>
#include <aws/es/model/AutoTuneOptions.h>
#include <aws/es/model/AutoTuneOptionsInput.h>
#include <aws/es/model/AutoTuneOptionsOutput.h>
#include <aws/es/model/AutoTuneOptionsStatus.h>
#include <aws/es/model/AutoTuneState.h>
#include <aws/es/model/AutoTuneStatus.h>
#include <aws/es/model/AutoTuneType.h>
#include <aws/es/model/CancelDomainConfigChangeRequest.h>
#include <aws/es/model/CancelDomainConfigChangeResult.h>
#include <aws/es/model/CancelElasticsearchServiceSoftwareUpdateRequest.h>
#include <aws/es/model/CancelElasticsearchServiceSoftwareUpdateResult.h>
#include <aws/es/model/CancelledChangeProperty.h>
#include <aws/es/model/ChangeProgressDetails.h>
#include <aws/es/model/ChangeProgressStage.h>
#include <aws/es/model/ChangeProgressStatusDetails.h>
#include <aws/es/model/CognitoOptions.h>
#include <aws/es/model/CognitoOptionsStatus.h>
#include <aws/es/model/ColdStorageOptions.h>
#include <aws/es/model/CompatibleVersionsMap.h>
#include <aws/es/model/ConfigChangeStatus.h>
#include <aws/es/model/CreateElasticsearchDomainRequest.h>
#include <aws/es/model/CreateElasticsearchDomainResult.h>
#include <aws/es/model/CreateOutboundCrossClusterSearchConnectionRequest.h>
#include <aws/es/model/CreateOutboundCrossClusterSearchConnectionResult.h>
#include <aws/es/model/CreatePackageRequest.h>
#include <aws/es/model/CreatePackageResult.h>
#include <aws/es/model/CreateVpcEndpointRequest.h>
#include <aws/es/model/CreateVpcEndpointResult.h>
#include <aws/es/model/DeleteElasticsearchDomainRequest.h>
#include <aws/es/model/DeleteElasticsearchDomainResult.h>
#include <aws/es/model/DeleteElasticsearchServiceRoleRequest.h>
#include <aws/es/model/DeleteInboundCrossClusterSearchConnectionRequest.h>
#include <aws/es/model/DeleteInboundCrossClusterSearchConnectionResult.h>
#include <aws/es/model/DeleteOutboundCrossClusterSearchConnectionRequest.h>
#include <aws/es/model/DeleteOutboundCrossClusterSearchConnectionResult.h>
#include <aws/es/model/DeletePackageRequest.h>
#include <aws/es/model/DeletePackageResult.h>
#include <aws/es/model/DeleteVpcEndpointRequest.h>
#include <aws/es/model/DeleteVpcEndpointResult.h>
#include <aws/es/model/DeploymentStatus.h>
#include <aws/es/model/DescribeDomainAutoTunesRequest.h>
#include <aws/es/model/DescribeDomainAutoTunesResult.h>
#include <aws/es/model/DescribeDomainChangeProgressRequest.h>
#include <aws/es/model/DescribeDomainChangeProgressResult.h>
#include <aws/es/model/DescribeElasticsearchDomainConfigRequest.h>
#include <aws/es/model/DescribeElasticsearchDomainConfigResult.h>
#include <aws/es/model/DescribeElasticsearchDomainRequest.h>
#include <aws/es/model/DescribeElasticsearchDomainResult.h>
#include <aws/es/model/DescribeElasticsearchDomainsRequest.h>
#include <aws/es/model/DescribeElasticsearchDomainsResult.h>
#include <aws/es/model/DescribeElasticsearchInstanceTypeLimitsRequest.h>
#include <aws/es/model/DescribeElasticsearchInstanceTypeLimitsResult.h>
#include <aws/es/model/DescribeInboundCrossClusterSearchConnectionsRequest.h>
#include <aws/es/model/DescribeInboundCrossClusterSearchConnectionsResult.h>
#include <aws/es/model/DescribeOutboundCrossClusterSearchConnectionsRequest.h>
#include <aws/es/model/DescribeOutboundCrossClusterSearchConnectionsResult.h>
#include <aws/es/model/DescribePackagesFilter.h>
#include <aws/es/model/DescribePackagesFilterName.h>
#include <aws/es/model/DescribePackagesRequest.h>
#include <aws/es/model/DescribePackagesResult.h>
#include <aws/es/model/DescribeReservedElasticsearchInstanceOfferingsRequest.h>
#include <aws/es/model/DescribeReservedElasticsearchInstanceOfferingsResult.h>
#include <aws/es/model/DescribeReservedElasticsearchInstancesRequest.h>
#include <aws/es/model/DescribeReservedElasticsearchInstancesResult.h>
#include <aws/es/model/DescribeVpcEndpointsRequest.h>
#include <aws/es/model/DescribeVpcEndpointsResult.h>
#include <aws/es/model/DissociatePackageRequest.h>
#include <aws/es/model/DissociatePackageResult.h>
#include <aws/es/model/DomainEndpointOptions.h>
#include <aws/es/model/DomainEndpointOptionsStatus.h>
#include <aws/es/model/DomainInfo.h>
#include <aws/es/model/DomainInformation.h>
#include <aws/es/model/DomainPackageDetails.h>
#include <aws/es/model/DomainPackageStatus.h>
#include <aws/es/model/DomainProcessingStatusType.h>
#include <aws/es/model/DryRunResults.h>
#include <aws/es/model/Duration.h>
#include <aws/es/model/EBSOptions.h>
#include <aws/es/model/EBSOptionsStatus.h>
#include <aws/es/model/ESPartitionInstanceType.h>
#include <aws/es/model/ESWarmPartitionInstanceType.h>
#include <aws/es/model/ElasticsearchClusterConfig.h>
#include <aws/es/model/ElasticsearchClusterConfigStatus.h>
#include <aws/es/model/ElasticsearchDomainConfig.h>
#include <aws/es/model/ElasticsearchDomainStatus.h>
#include <aws/es/model/ElasticsearchVersionStatus.h>
#include <aws/es/model/EncryptionAtRestOptions.h>
#include <aws/es/model/EncryptionAtRestOptionsStatus.h>
#include <aws/es/model/EngineType.h>
#include <aws/es/model/ErrorDetails.h>
#include <aws/es/model/Filter.h>
#include <aws/es/model/GetCompatibleElasticsearchVersionsRequest.h>
#include <aws/es/model/GetCompatibleElasticsearchVersionsResult.h>
#include <aws/es/model/GetPackageVersionHistoryRequest.h>
#include <aws/es/model/GetPackageVersionHistoryResult.h>
#include <aws/es/model/GetUpgradeHistoryRequest.h>
#include <aws/es/model/GetUpgradeHistoryResult.h>
#include <aws/es/model/GetUpgradeStatusRequest.h>
#include <aws/es/model/GetUpgradeStatusResult.h>
#include <aws/es/model/InboundCrossClusterSearchConnection.h>
#include <aws/es/model/InboundCrossClusterSearchConnectionStatus.h>
#include <aws/es/model/InboundCrossClusterSearchConnectionStatusCode.h>
#include <aws/es/model/InitiatedBy.h>
#include <aws/es/model/InstanceCountLimits.h>
#include <aws/es/model/InstanceLimits.h>
#include <aws/es/model/Limits.h>
#include <aws/es/model/ListDomainNamesRequest.h>
#include <aws/es/model/ListDomainNamesResult.h>
#include <aws/es/model/ListDomainsForPackageRequest.h>
#include <aws/es/model/ListDomainsForPackageResult.h>
#include <aws/es/model/ListElasticsearchInstanceTypesRequest.h>
#include <aws/es/model/ListElasticsearchInstanceTypesResult.h>
#include <aws/es/model/ListElasticsearchVersionsRequest.h>
#include <aws/es/model/ListElasticsearchVersionsResult.h>
#include <aws/es/model/ListPackagesForDomainRequest.h>
#include <aws/es/model/ListPackagesForDomainResult.h>
#include <aws/es/model/ListTagsRequest.h>
#include <aws/es/model/ListTagsResult.h>
#include <aws/es/model/ListVpcEndpointAccessRequest.h>
#include <aws/es/model/ListVpcEndpointAccessResult.h>
#include <aws/es/model/ListVpcEndpointsForDomainRequest.h>
#include <aws/es/model/ListVpcEndpointsForDomainResult.h>
#include <aws/es/model/ListVpcEndpointsRequest.h>
#include <aws/es/model/ListVpcEndpointsResult.h>
#include <aws/es/model/LogPublishingOption.h>
#include <aws/es/model/LogPublishingOptionsStatus.h>
#include <aws/es/model/LogType.h>
#include <aws/es/model/MasterUserOptions.h>
#include <aws/es/model/ModifyingProperties.h>
#include <aws/es/model/NodeToNodeEncryptionOptions.h>
#include <aws/es/model/NodeToNodeEncryptionOptionsStatus.h>
#include <aws/es/model/OptionState.h>
#include <aws/es/model/OptionStatus.h>
#include <aws/es/model/OutboundCrossClusterSearchConnection.h>
#include <aws/es/model/OutboundCrossClusterSearchConnectionStatus.h>
#include <aws/es/model/OutboundCrossClusterSearchConnectionStatusCode.h>
#include <aws/es/model/OverallChangeStatus.h>
#include <aws/es/model/PackageDetails.h>
#include <aws/es/model/PackageSource.h>
#include <aws/es/model/PackageStatus.h>
#include <aws/es/model/PackageType.h>
#include <aws/es/model/PackageVersionHistory.h>
#include <aws/es/model/PrincipalType.h>
#include <aws/es/model/PropertyValueType.h>
#include <aws/es/model/PurchaseReservedElasticsearchInstanceOfferingRequest.h>
#include <aws/es/model/PurchaseReservedElasticsearchInstanceOfferingResult.h>
#include <aws/es/model/RecurringCharge.h>
#include <aws/es/model/RejectInboundCrossClusterSearchConnectionRequest.h>
#include <aws/es/model/RejectInboundCrossClusterSearchConnectionResult.h>
#include <aws/es/model/RemoveTagsRequest.h>
#include <aws/es/model/ReservedElasticsearchInstance.h>
#include <aws/es/model/ReservedElasticsearchInstanceOffering.h>
#include <aws/es/model/ReservedElasticsearchInstancePaymentOption.h>
#include <aws/es/model/RevokeVpcEndpointAccessRequest.h>
#include <aws/es/model/RevokeVpcEndpointAccessResult.h>
#include <aws/es/model/RollbackOnDisable.h>
#include <aws/es/model/SAMLIdp.h>
#include <aws/es/model/SAMLOptionsInput.h>
#include <aws/es/model/SAMLOptionsOutput.h>
#include <aws/es/model/ScheduledAutoTuneActionType.h>
#include <aws/es/model/ScheduledAutoTuneDetails.h>
#include <aws/es/model/ScheduledAutoTuneSeverityType.h>
#include <aws/es/model/ServiceSoftwareOptions.h>
#include <aws/es/model/SnapshotOptions.h>
#include <aws/es/model/SnapshotOptionsStatus.h>
#include <aws/es/model/StartElasticsearchServiceSoftwareUpdateRequest.h>
#include <aws/es/model/StartElasticsearchServiceSoftwareUpdateResult.h>
#include <aws/es/model/StorageType.h>
#include <aws/es/model/StorageTypeLimit.h>
#include <aws/es/model/TLSSecurityPolicy.h>
#include <aws/es/model/Tag.h>
#include <aws/es/model/TimeUnit.h>
#include <aws/es/model/UpdateElasticsearchDomainConfigRequest.h>
#include <aws/es/model/UpdateElasticsearchDomainConfigResult.h>
#include <aws/es/model/UpdatePackageRequest.h>
#include <aws/es/model/UpdatePackageResult.h>
#include <aws/es/model/UpdateVpcEndpointRequest.h>
#include <aws/es/model/UpdateVpcEndpointResult.h>
#include <aws/es/model/UpgradeElasticsearchDomainRequest.h>
#include <aws/es/model/UpgradeElasticsearchDomainResult.h>
#include <aws/es/model/UpgradeHistory.h>
#include <aws/es/model/UpgradeStatus.h>
#include <aws/es/model/UpgradeStep.h>
#include <aws/es/model/UpgradeStepItem.h>
#include <aws/es/model/VPCDerivedInfo.h>
#include <aws/es/model/VPCDerivedInfoStatus.h>
#include <aws/es/model/VPCOptions.h>
#include <aws/es/model/VolumeType.h>
#include <aws/es/model/VpcEndpoint.h>
#include <aws/es/model/VpcEndpointError.h>
#include <aws/es/model/VpcEndpointErrorCode.h>
#include <aws/es/model/VpcEndpointStatus.h>
#include <aws/es/model/VpcEndpointSummary.h>
#include <aws/es/model/ZoneAwarenessConfig.h>

using ElasticsearchServiceIncludeTest = ::testing::Test;

TEST_F(ElasticsearchServiceIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::ElasticsearchService::ElasticsearchServiceClient>("ElasticsearchServiceIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
