/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/eventbridge/EventBridgeClient.h>
#include <aws/eventbridge/EventBridgeEndpointProvider.h>
#include <aws/eventbridge/EventBridgeEndpointRules.h>
#include <aws/eventbridge/EventBridgeErrorMarshaller.h>
#include <aws/eventbridge/EventBridgeErrors.h>
#include <aws/eventbridge/EventBridgeRequest.h>
#include <aws/eventbridge/EventBridgeServiceClientModel.h>
#include <aws/eventbridge/EventBridge_EXPORTS.h>
#include <aws/eventbridge/model/ActivateEventSourceRequest.h>
#include <aws/eventbridge/model/ApiDestination.h>
#include <aws/eventbridge/model/ApiDestinationHttpMethod.h>
#include <aws/eventbridge/model/ApiDestinationState.h>
#include <aws/eventbridge/model/AppSyncParameters.h>
#include <aws/eventbridge/model/Archive.h>
#include <aws/eventbridge/model/ArchiveState.h>
#include <aws/eventbridge/model/AssignPublicIp.h>
#include <aws/eventbridge/model/AwsVpcConfiguration.h>
#include <aws/eventbridge/model/BatchArrayProperties.h>
#include <aws/eventbridge/model/BatchParameters.h>
#include <aws/eventbridge/model/BatchRetryStrategy.h>
#include <aws/eventbridge/model/CancelReplayRequest.h>
#include <aws/eventbridge/model/CancelReplayResult.h>
#include <aws/eventbridge/model/CapacityProviderStrategyItem.h>
#include <aws/eventbridge/model/Condition.h>
#include <aws/eventbridge/model/Connection.h>
#include <aws/eventbridge/model/ConnectionApiKeyAuthResponseParameters.h>
#include <aws/eventbridge/model/ConnectionAuthResponseParameters.h>
#include <aws/eventbridge/model/ConnectionAuthorizationType.h>
#include <aws/eventbridge/model/ConnectionBasicAuthResponseParameters.h>
#include <aws/eventbridge/model/ConnectionBodyParameter.h>
#include <aws/eventbridge/model/ConnectionHeaderParameter.h>
#include <aws/eventbridge/model/ConnectionHttpParameters.h>
#include <aws/eventbridge/model/ConnectionOAuthClientResponseParameters.h>
#include <aws/eventbridge/model/ConnectionOAuthHttpMethod.h>
#include <aws/eventbridge/model/ConnectionOAuthResponseParameters.h>
#include <aws/eventbridge/model/ConnectionQueryStringParameter.h>
#include <aws/eventbridge/model/ConnectionState.h>
#include <aws/eventbridge/model/ConnectivityResourceConfigurationArn.h>
#include <aws/eventbridge/model/ConnectivityResourceParameters.h>
#include <aws/eventbridge/model/CreateApiDestinationRequest.h>
#include <aws/eventbridge/model/CreateApiDestinationResult.h>
#include <aws/eventbridge/model/CreateArchiveRequest.h>
#include <aws/eventbridge/model/CreateArchiveResult.h>
#include <aws/eventbridge/model/CreateConnectionApiKeyAuthRequestParameters.h>
#include <aws/eventbridge/model/CreateConnectionAuthRequestParameters.h>
#include <aws/eventbridge/model/CreateConnectionBasicAuthRequestParameters.h>
#include <aws/eventbridge/model/CreateConnectionOAuthClientRequestParameters.h>
#include <aws/eventbridge/model/CreateConnectionOAuthRequestParameters.h>
#include <aws/eventbridge/model/CreateConnectionRequest.h>
#include <aws/eventbridge/model/CreateConnectionResult.h>
#include <aws/eventbridge/model/CreateEndpointRequest.h>
#include <aws/eventbridge/model/CreateEndpointResult.h>
#include <aws/eventbridge/model/CreateEventBusRequest.h>
#include <aws/eventbridge/model/CreateEventBusResult.h>
#include <aws/eventbridge/model/CreatePartnerEventSourceRequest.h>
#include <aws/eventbridge/model/CreatePartnerEventSourceResult.h>
#include <aws/eventbridge/model/DeactivateEventSourceRequest.h>
#include <aws/eventbridge/model/DeadLetterConfig.h>
#include <aws/eventbridge/model/DeauthorizeConnectionRequest.h>
#include <aws/eventbridge/model/DeauthorizeConnectionResult.h>
#include <aws/eventbridge/model/DeleteApiDestinationRequest.h>
#include <aws/eventbridge/model/DeleteApiDestinationResult.h>
#include <aws/eventbridge/model/DeleteArchiveRequest.h>
#include <aws/eventbridge/model/DeleteArchiveResult.h>
#include <aws/eventbridge/model/DeleteConnectionRequest.h>
#include <aws/eventbridge/model/DeleteConnectionResult.h>
#include <aws/eventbridge/model/DeleteEndpointRequest.h>
#include <aws/eventbridge/model/DeleteEndpointResult.h>
#include <aws/eventbridge/model/DeleteEventBusRequest.h>
#include <aws/eventbridge/model/DeletePartnerEventSourceRequest.h>
#include <aws/eventbridge/model/DeleteRuleRequest.h>
#include <aws/eventbridge/model/DescribeApiDestinationRequest.h>
#include <aws/eventbridge/model/DescribeApiDestinationResult.h>
#include <aws/eventbridge/model/DescribeArchiveRequest.h>
#include <aws/eventbridge/model/DescribeArchiveResult.h>
#include <aws/eventbridge/model/DescribeConnectionConnectivityParameters.h>
#include <aws/eventbridge/model/DescribeConnectionRequest.h>
#include <aws/eventbridge/model/DescribeConnectionResourceParameters.h>
#include <aws/eventbridge/model/DescribeConnectionResult.h>
#include <aws/eventbridge/model/DescribeEndpointRequest.h>
#include <aws/eventbridge/model/DescribeEndpointResult.h>
#include <aws/eventbridge/model/DescribeEventBusRequest.h>
#include <aws/eventbridge/model/DescribeEventBusResult.h>
#include <aws/eventbridge/model/DescribeEventSourceRequest.h>
#include <aws/eventbridge/model/DescribeEventSourceResult.h>
#include <aws/eventbridge/model/DescribePartnerEventSourceRequest.h>
#include <aws/eventbridge/model/DescribePartnerEventSourceResult.h>
#include <aws/eventbridge/model/DescribeReplayRequest.h>
#include <aws/eventbridge/model/DescribeReplayResult.h>
#include <aws/eventbridge/model/DescribeRuleRequest.h>
#include <aws/eventbridge/model/DescribeRuleResult.h>
#include <aws/eventbridge/model/DisableRuleRequest.h>
#include <aws/eventbridge/model/EcsParameters.h>
#include <aws/eventbridge/model/EnableRuleRequest.h>
#include <aws/eventbridge/model/Endpoint.h>
#include <aws/eventbridge/model/EndpointEventBus.h>
#include <aws/eventbridge/model/EndpointState.h>
#include <aws/eventbridge/model/EventBus.h>
#include <aws/eventbridge/model/EventSource.h>
#include <aws/eventbridge/model/EventSourceState.h>
#include <aws/eventbridge/model/FailoverConfig.h>
#include <aws/eventbridge/model/HttpParameters.h>
#include <aws/eventbridge/model/InputTransformer.h>
#include <aws/eventbridge/model/KinesisParameters.h>
#include <aws/eventbridge/model/LaunchType.h>
#include <aws/eventbridge/model/ListApiDestinationsRequest.h>
#include <aws/eventbridge/model/ListApiDestinationsResult.h>
#include <aws/eventbridge/model/ListArchivesRequest.h>
#include <aws/eventbridge/model/ListArchivesResult.h>
#include <aws/eventbridge/model/ListConnectionsRequest.h>
#include <aws/eventbridge/model/ListConnectionsResult.h>
#include <aws/eventbridge/model/ListEndpointsRequest.h>
#include <aws/eventbridge/model/ListEndpointsResult.h>
#include <aws/eventbridge/model/ListEventBusesRequest.h>
#include <aws/eventbridge/model/ListEventBusesResult.h>
#include <aws/eventbridge/model/ListEventSourcesRequest.h>
#include <aws/eventbridge/model/ListEventSourcesResult.h>
#include <aws/eventbridge/model/ListPartnerEventSourceAccountsRequest.h>
#include <aws/eventbridge/model/ListPartnerEventSourceAccountsResult.h>
#include <aws/eventbridge/model/ListPartnerEventSourcesRequest.h>
#include <aws/eventbridge/model/ListPartnerEventSourcesResult.h>
#include <aws/eventbridge/model/ListReplaysRequest.h>
#include <aws/eventbridge/model/ListReplaysResult.h>
#include <aws/eventbridge/model/ListRuleNamesByTargetRequest.h>
#include <aws/eventbridge/model/ListRuleNamesByTargetResult.h>
#include <aws/eventbridge/model/ListRulesRequest.h>
#include <aws/eventbridge/model/ListRulesResult.h>
#include <aws/eventbridge/model/ListTagsForResourceRequest.h>
#include <aws/eventbridge/model/ListTagsForResourceResult.h>
#include <aws/eventbridge/model/ListTargetsByRuleRequest.h>
#include <aws/eventbridge/model/ListTargetsByRuleResult.h>
#include <aws/eventbridge/model/NetworkConfiguration.h>
#include <aws/eventbridge/model/PartnerEventSource.h>
#include <aws/eventbridge/model/PartnerEventSourceAccount.h>
#include <aws/eventbridge/model/PlacementConstraint.h>
#include <aws/eventbridge/model/PlacementConstraintType.h>
#include <aws/eventbridge/model/PlacementStrategy.h>
#include <aws/eventbridge/model/PlacementStrategyType.h>
#include <aws/eventbridge/model/Primary.h>
#include <aws/eventbridge/model/PropagateTags.h>
#include <aws/eventbridge/model/PutEventsRequest.h>
#include <aws/eventbridge/model/PutEventsRequestEntry.h>
#include <aws/eventbridge/model/PutEventsResult.h>
#include <aws/eventbridge/model/PutEventsResultEntry.h>
#include <aws/eventbridge/model/PutPartnerEventsRequest.h>
#include <aws/eventbridge/model/PutPartnerEventsRequestEntry.h>
#include <aws/eventbridge/model/PutPartnerEventsResult.h>
#include <aws/eventbridge/model/PutPartnerEventsResultEntry.h>
#include <aws/eventbridge/model/PutPermissionRequest.h>
#include <aws/eventbridge/model/PutRuleRequest.h>
#include <aws/eventbridge/model/PutRuleResult.h>
#include <aws/eventbridge/model/PutTargetsRequest.h>
#include <aws/eventbridge/model/PutTargetsResult.h>
#include <aws/eventbridge/model/PutTargetsResultEntry.h>
#include <aws/eventbridge/model/RedshiftDataParameters.h>
#include <aws/eventbridge/model/RemovePermissionRequest.h>
#include <aws/eventbridge/model/RemoveTargetsRequest.h>
#include <aws/eventbridge/model/RemoveTargetsResult.h>
#include <aws/eventbridge/model/RemoveTargetsResultEntry.h>
#include <aws/eventbridge/model/Replay.h>
#include <aws/eventbridge/model/ReplayDestination.h>
#include <aws/eventbridge/model/ReplayState.h>
#include <aws/eventbridge/model/ReplicationConfig.h>
#include <aws/eventbridge/model/ReplicationState.h>
#include <aws/eventbridge/model/RetryPolicy.h>
#include <aws/eventbridge/model/RoutingConfig.h>
#include <aws/eventbridge/model/Rule.h>
#include <aws/eventbridge/model/RuleState.h>
#include <aws/eventbridge/model/RunCommandParameters.h>
#include <aws/eventbridge/model/RunCommandTarget.h>
#include <aws/eventbridge/model/SageMakerPipelineParameter.h>
#include <aws/eventbridge/model/SageMakerPipelineParameters.h>
#include <aws/eventbridge/model/Secondary.h>
#include <aws/eventbridge/model/SqsParameters.h>
#include <aws/eventbridge/model/StartReplayRequest.h>
#include <aws/eventbridge/model/StartReplayResult.h>
#include <aws/eventbridge/model/Tag.h>
#include <aws/eventbridge/model/TagResourceRequest.h>
#include <aws/eventbridge/model/TagResourceResult.h>
#include <aws/eventbridge/model/Target.h>
#include <aws/eventbridge/model/TestEventPatternRequest.h>
#include <aws/eventbridge/model/TestEventPatternResult.h>
#include <aws/eventbridge/model/UntagResourceRequest.h>
#include <aws/eventbridge/model/UntagResourceResult.h>
#include <aws/eventbridge/model/UpdateApiDestinationRequest.h>
#include <aws/eventbridge/model/UpdateApiDestinationResult.h>
#include <aws/eventbridge/model/UpdateArchiveRequest.h>
#include <aws/eventbridge/model/UpdateArchiveResult.h>
#include <aws/eventbridge/model/UpdateConnectionApiKeyAuthRequestParameters.h>
#include <aws/eventbridge/model/UpdateConnectionAuthRequestParameters.h>
#include <aws/eventbridge/model/UpdateConnectionBasicAuthRequestParameters.h>
#include <aws/eventbridge/model/UpdateConnectionOAuthClientRequestParameters.h>
#include <aws/eventbridge/model/UpdateConnectionOAuthRequestParameters.h>
#include <aws/eventbridge/model/UpdateConnectionRequest.h>
#include <aws/eventbridge/model/UpdateConnectionResult.h>
#include <aws/eventbridge/model/UpdateEndpointRequest.h>
#include <aws/eventbridge/model/UpdateEndpointResult.h>
#include <aws/eventbridge/model/UpdateEventBusRequest.h>
#include <aws/eventbridge/model/UpdateEventBusResult.h>

using EventBridgeIncludeTest = ::testing::Test;

TEST_F(EventBridgeIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::EventBridge::EventBridgeClient>("EventBridgeIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
