/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/events/CloudWatchEventsClient.h>
#include <aws/events/CloudWatchEventsEndpointProvider.h>
#include <aws/events/CloudWatchEventsEndpointRules.h>
#include <aws/events/CloudWatchEventsErrorMarshaller.h>
#include <aws/events/CloudWatchEventsErrors.h>
#include <aws/events/CloudWatchEventsRequest.h>
#include <aws/events/CloudWatchEventsServiceClientModel.h>
#include <aws/events/CloudWatchEvents_EXPORTS.h>
#include <aws/events/model/ActivateEventSourceRequest.h>
#include <aws/events/model/ApiDestination.h>
#include <aws/events/model/ApiDestinationHttpMethod.h>
#include <aws/events/model/ApiDestinationState.h>
#include <aws/events/model/Archive.h>
#include <aws/events/model/ArchiveState.h>
#include <aws/events/model/AssignPublicIp.h>
#include <aws/events/model/AwsVpcConfiguration.h>
#include <aws/events/model/BatchArrayProperties.h>
#include <aws/events/model/BatchParameters.h>
#include <aws/events/model/BatchRetryStrategy.h>
#include <aws/events/model/CancelReplayRequest.h>
#include <aws/events/model/CancelReplayResult.h>
#include <aws/events/model/CapacityProviderStrategyItem.h>
#include <aws/events/model/Condition.h>
#include <aws/events/model/Connection.h>
#include <aws/events/model/ConnectionApiKeyAuthResponseParameters.h>
#include <aws/events/model/ConnectionAuthResponseParameters.h>
#include <aws/events/model/ConnectionAuthorizationType.h>
#include <aws/events/model/ConnectionBasicAuthResponseParameters.h>
#include <aws/events/model/ConnectionBodyParameter.h>
#include <aws/events/model/ConnectionHeaderParameter.h>
#include <aws/events/model/ConnectionHttpParameters.h>
#include <aws/events/model/ConnectionOAuthClientResponseParameters.h>
#include <aws/events/model/ConnectionOAuthHttpMethod.h>
#include <aws/events/model/ConnectionOAuthResponseParameters.h>
#include <aws/events/model/ConnectionQueryStringParameter.h>
#include <aws/events/model/ConnectionState.h>
#include <aws/events/model/CreateApiDestinationRequest.h>
#include <aws/events/model/CreateApiDestinationResult.h>
#include <aws/events/model/CreateArchiveRequest.h>
#include <aws/events/model/CreateArchiveResult.h>
#include <aws/events/model/CreateConnectionApiKeyAuthRequestParameters.h>
#include <aws/events/model/CreateConnectionAuthRequestParameters.h>
#include <aws/events/model/CreateConnectionBasicAuthRequestParameters.h>
#include <aws/events/model/CreateConnectionOAuthClientRequestParameters.h>
#include <aws/events/model/CreateConnectionOAuthRequestParameters.h>
#include <aws/events/model/CreateConnectionRequest.h>
#include <aws/events/model/CreateConnectionResult.h>
#include <aws/events/model/CreateEventBusRequest.h>
#include <aws/events/model/CreateEventBusResult.h>
#include <aws/events/model/CreatePartnerEventSourceRequest.h>
#include <aws/events/model/CreatePartnerEventSourceResult.h>
#include <aws/events/model/DeactivateEventSourceRequest.h>
#include <aws/events/model/DeadLetterConfig.h>
#include <aws/events/model/DeauthorizeConnectionRequest.h>
#include <aws/events/model/DeauthorizeConnectionResult.h>
#include <aws/events/model/DeleteApiDestinationRequest.h>
#include <aws/events/model/DeleteApiDestinationResult.h>
#include <aws/events/model/DeleteArchiveRequest.h>
#include <aws/events/model/DeleteArchiveResult.h>
#include <aws/events/model/DeleteConnectionRequest.h>
#include <aws/events/model/DeleteConnectionResult.h>
#include <aws/events/model/DeleteEventBusRequest.h>
#include <aws/events/model/DeletePartnerEventSourceRequest.h>
#include <aws/events/model/DeleteRuleRequest.h>
#include <aws/events/model/DescribeApiDestinationRequest.h>
#include <aws/events/model/DescribeApiDestinationResult.h>
#include <aws/events/model/DescribeArchiveRequest.h>
#include <aws/events/model/DescribeArchiveResult.h>
#include <aws/events/model/DescribeConnectionRequest.h>
#include <aws/events/model/DescribeConnectionResult.h>
#include <aws/events/model/DescribeEventBusRequest.h>
#include <aws/events/model/DescribeEventBusResult.h>
#include <aws/events/model/DescribeEventSourceRequest.h>
#include <aws/events/model/DescribeEventSourceResult.h>
#include <aws/events/model/DescribePartnerEventSourceRequest.h>
#include <aws/events/model/DescribePartnerEventSourceResult.h>
#include <aws/events/model/DescribeReplayRequest.h>
#include <aws/events/model/DescribeReplayResult.h>
#include <aws/events/model/DescribeRuleRequest.h>
#include <aws/events/model/DescribeRuleResult.h>
#include <aws/events/model/DisableRuleRequest.h>
#include <aws/events/model/EcsParameters.h>
#include <aws/events/model/EnableRuleRequest.h>
#include <aws/events/model/EventBus.h>
#include <aws/events/model/EventSource.h>
#include <aws/events/model/EventSourceState.h>
#include <aws/events/model/HttpParameters.h>
#include <aws/events/model/InputTransformer.h>
#include <aws/events/model/KinesisParameters.h>
#include <aws/events/model/LaunchType.h>
#include <aws/events/model/ListApiDestinationsRequest.h>
#include <aws/events/model/ListApiDestinationsResult.h>
#include <aws/events/model/ListArchivesRequest.h>
#include <aws/events/model/ListArchivesResult.h>
#include <aws/events/model/ListConnectionsRequest.h>
#include <aws/events/model/ListConnectionsResult.h>
#include <aws/events/model/ListEventBusesRequest.h>
#include <aws/events/model/ListEventBusesResult.h>
#include <aws/events/model/ListEventSourcesRequest.h>
#include <aws/events/model/ListEventSourcesResult.h>
#include <aws/events/model/ListPartnerEventSourceAccountsRequest.h>
#include <aws/events/model/ListPartnerEventSourceAccountsResult.h>
#include <aws/events/model/ListPartnerEventSourcesRequest.h>
#include <aws/events/model/ListPartnerEventSourcesResult.h>
#include <aws/events/model/ListReplaysRequest.h>
#include <aws/events/model/ListReplaysResult.h>
#include <aws/events/model/ListRuleNamesByTargetRequest.h>
#include <aws/events/model/ListRuleNamesByTargetResult.h>
#include <aws/events/model/ListRulesRequest.h>
#include <aws/events/model/ListRulesResult.h>
#include <aws/events/model/ListTagsForResourceRequest.h>
#include <aws/events/model/ListTagsForResourceResult.h>
#include <aws/events/model/ListTargetsByRuleRequest.h>
#include <aws/events/model/ListTargetsByRuleResult.h>
#include <aws/events/model/NetworkConfiguration.h>
#include <aws/events/model/PartnerEventSource.h>
#include <aws/events/model/PartnerEventSourceAccount.h>
#include <aws/events/model/PlacementConstraint.h>
#include <aws/events/model/PlacementConstraintType.h>
#include <aws/events/model/PlacementStrategy.h>
#include <aws/events/model/PlacementStrategyType.h>
#include <aws/events/model/PropagateTags.h>
#include <aws/events/model/PutEventsRequest.h>
#include <aws/events/model/PutEventsRequestEntry.h>
#include <aws/events/model/PutEventsResult.h>
#include <aws/events/model/PutEventsResultEntry.h>
#include <aws/events/model/PutPartnerEventsRequest.h>
#include <aws/events/model/PutPartnerEventsRequestEntry.h>
#include <aws/events/model/PutPartnerEventsResult.h>
#include <aws/events/model/PutPartnerEventsResultEntry.h>
#include <aws/events/model/PutPermissionRequest.h>
#include <aws/events/model/PutRuleRequest.h>
#include <aws/events/model/PutRuleResult.h>
#include <aws/events/model/PutTargetsRequest.h>
#include <aws/events/model/PutTargetsResult.h>
#include <aws/events/model/PutTargetsResultEntry.h>
#include <aws/events/model/RedshiftDataParameters.h>
#include <aws/events/model/RemovePermissionRequest.h>
#include <aws/events/model/RemoveTargetsRequest.h>
#include <aws/events/model/RemoveTargetsResult.h>
#include <aws/events/model/RemoveTargetsResultEntry.h>
#include <aws/events/model/Replay.h>
#include <aws/events/model/ReplayDestination.h>
#include <aws/events/model/ReplayState.h>
#include <aws/events/model/RetryPolicy.h>
#include <aws/events/model/Rule.h>
#include <aws/events/model/RuleState.h>
#include <aws/events/model/RunCommandParameters.h>
#include <aws/events/model/RunCommandTarget.h>
#include <aws/events/model/SageMakerPipelineParameter.h>
#include <aws/events/model/SageMakerPipelineParameters.h>
#include <aws/events/model/SqsParameters.h>
#include <aws/events/model/StartReplayRequest.h>
#include <aws/events/model/StartReplayResult.h>
#include <aws/events/model/Tag.h>
#include <aws/events/model/TagResourceRequest.h>
#include <aws/events/model/TagResourceResult.h>
#include <aws/events/model/Target.h>
#include <aws/events/model/TestEventPatternRequest.h>
#include <aws/events/model/TestEventPatternResult.h>
#include <aws/events/model/UntagResourceRequest.h>
#include <aws/events/model/UntagResourceResult.h>
#include <aws/events/model/UpdateApiDestinationRequest.h>
#include <aws/events/model/UpdateApiDestinationResult.h>
#include <aws/events/model/UpdateArchiveRequest.h>
#include <aws/events/model/UpdateArchiveResult.h>
#include <aws/events/model/UpdateConnectionApiKeyAuthRequestParameters.h>
#include <aws/events/model/UpdateConnectionAuthRequestParameters.h>
#include <aws/events/model/UpdateConnectionBasicAuthRequestParameters.h>
#include <aws/events/model/UpdateConnectionOAuthClientRequestParameters.h>
#include <aws/events/model/UpdateConnectionOAuthRequestParameters.h>
#include <aws/events/model/UpdateConnectionRequest.h>
#include <aws/events/model/UpdateConnectionResult.h>

using CloudWatchEventsIncludeTest = ::testing::Test;

TEST_F(CloudWatchEventsIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::CloudWatchEvents::CloudWatchEventsClient>("CloudWatchEventsIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
