/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/finspace/FinspaceClient.h>
#include <aws/finspace/FinspaceEndpointProvider.h>
#include <aws/finspace/FinspaceEndpointRules.h>
#include <aws/finspace/FinspaceErrorMarshaller.h>
#include <aws/finspace/FinspaceErrors.h>
#include <aws/finspace/FinspaceRequest.h>
#include <aws/finspace/FinspaceServiceClientModel.h>
#include <aws/finspace/Finspace_EXPORTS.h>
#include <aws/finspace/model/AutoScalingConfiguration.h>
#include <aws/finspace/model/AutoScalingMetric.h>
#include <aws/finspace/model/CapacityConfiguration.h>
#include <aws/finspace/model/ChangeRequest.h>
#include <aws/finspace/model/ChangeType.h>
#include <aws/finspace/model/ChangesetStatus.h>
#include <aws/finspace/model/CodeConfiguration.h>
#include <aws/finspace/model/ConflictException.h>
#include <aws/finspace/model/CreateKxChangesetRequest.h>
#include <aws/finspace/model/CreateKxChangesetResult.h>
#include <aws/finspace/model/CreateKxClusterRequest.h>
#include <aws/finspace/model/CreateKxClusterResult.h>
#include <aws/finspace/model/CreateKxDatabaseRequest.h>
#include <aws/finspace/model/CreateKxDatabaseResult.h>
#include <aws/finspace/model/CreateKxDataviewRequest.h>
#include <aws/finspace/model/CreateKxDataviewResult.h>
#include <aws/finspace/model/CreateKxEnvironmentRequest.h>
#include <aws/finspace/model/CreateKxEnvironmentResult.h>
#include <aws/finspace/model/CreateKxScalingGroupRequest.h>
#include <aws/finspace/model/CreateKxScalingGroupResult.h>
#include <aws/finspace/model/CreateKxUserRequest.h>
#include <aws/finspace/model/CreateKxUserResult.h>
#include <aws/finspace/model/CreateKxVolumeRequest.h>
#include <aws/finspace/model/CreateKxVolumeResult.h>
#include <aws/finspace/model/CustomDNSServer.h>
#include <aws/finspace/model/DeleteKxClusterNodeRequest.h>
#include <aws/finspace/model/DeleteKxClusterNodeResult.h>
#include <aws/finspace/model/DeleteKxClusterRequest.h>
#include <aws/finspace/model/DeleteKxClusterResult.h>
#include <aws/finspace/model/DeleteKxDatabaseRequest.h>
#include <aws/finspace/model/DeleteKxDatabaseResult.h>
#include <aws/finspace/model/DeleteKxDataviewRequest.h>
#include <aws/finspace/model/DeleteKxDataviewResult.h>
#include <aws/finspace/model/DeleteKxEnvironmentRequest.h>
#include <aws/finspace/model/DeleteKxEnvironmentResult.h>
#include <aws/finspace/model/DeleteKxScalingGroupRequest.h>
#include <aws/finspace/model/DeleteKxScalingGroupResult.h>
#include <aws/finspace/model/DeleteKxUserRequest.h>
#include <aws/finspace/model/DeleteKxUserResult.h>
#include <aws/finspace/model/DeleteKxVolumeRequest.h>
#include <aws/finspace/model/DeleteKxVolumeResult.h>
#include <aws/finspace/model/DnsStatus.h>
#include <aws/finspace/model/Environment.h>
#include <aws/finspace/model/EnvironmentStatus.h>
#include <aws/finspace/model/ErrorDetails.h>
#include <aws/finspace/model/ErrorInfo.h>
#include <aws/finspace/model/FederationMode.h>
#include <aws/finspace/model/FederationParameters.h>
#include <aws/finspace/model/GetKxChangesetRequest.h>
#include <aws/finspace/model/GetKxChangesetResult.h>
#include <aws/finspace/model/GetKxClusterRequest.h>
#include <aws/finspace/model/GetKxClusterResult.h>
#include <aws/finspace/model/GetKxConnectionStringRequest.h>
#include <aws/finspace/model/GetKxConnectionStringResult.h>
#include <aws/finspace/model/GetKxDatabaseRequest.h>
#include <aws/finspace/model/GetKxDatabaseResult.h>
#include <aws/finspace/model/GetKxDataviewRequest.h>
#include <aws/finspace/model/GetKxDataviewResult.h>
#include <aws/finspace/model/GetKxEnvironmentRequest.h>
#include <aws/finspace/model/GetKxEnvironmentResult.h>
#include <aws/finspace/model/GetKxScalingGroupRequest.h>
#include <aws/finspace/model/GetKxScalingGroupResult.h>
#include <aws/finspace/model/GetKxUserRequest.h>
#include <aws/finspace/model/GetKxUserResult.h>
#include <aws/finspace/model/GetKxVolumeRequest.h>
#include <aws/finspace/model/GetKxVolumeResult.h>
#include <aws/finspace/model/IPAddressType.h>
#include <aws/finspace/model/IcmpTypeCode.h>
#include <aws/finspace/model/KxAttachedCluster.h>
#include <aws/finspace/model/KxAzMode.h>
#include <aws/finspace/model/KxCacheStorageConfiguration.h>
#include <aws/finspace/model/KxChangesetListEntry.h>
#include <aws/finspace/model/KxCluster.h>
#include <aws/finspace/model/KxClusterCodeDeploymentConfiguration.h>
#include <aws/finspace/model/KxClusterCodeDeploymentStrategy.h>
#include <aws/finspace/model/KxClusterStatus.h>
#include <aws/finspace/model/KxClusterType.h>
#include <aws/finspace/model/KxCommandLineArgument.h>
#include <aws/finspace/model/KxDatabaseCacheConfiguration.h>
#include <aws/finspace/model/KxDatabaseConfiguration.h>
#include <aws/finspace/model/KxDatabaseListEntry.h>
#include <aws/finspace/model/KxDataviewActiveVersion.h>
#include <aws/finspace/model/KxDataviewConfiguration.h>
#include <aws/finspace/model/KxDataviewListEntry.h>
#include <aws/finspace/model/KxDataviewSegmentConfiguration.h>
#include <aws/finspace/model/KxDataviewStatus.h>
#include <aws/finspace/model/KxDeploymentConfiguration.h>
#include <aws/finspace/model/KxDeploymentStrategy.h>
#include <aws/finspace/model/KxEnvironment.h>
#include <aws/finspace/model/KxNAS1Configuration.h>
#include <aws/finspace/model/KxNAS1Type.h>
#include <aws/finspace/model/KxNode.h>
#include <aws/finspace/model/KxNodeStatus.h>
#include <aws/finspace/model/KxSavedownStorageConfiguration.h>
#include <aws/finspace/model/KxSavedownStorageType.h>
#include <aws/finspace/model/KxScalingGroup.h>
#include <aws/finspace/model/KxScalingGroupConfiguration.h>
#include <aws/finspace/model/KxScalingGroupStatus.h>
#include <aws/finspace/model/KxUser.h>
#include <aws/finspace/model/KxVolume.h>
#include <aws/finspace/model/KxVolumeStatus.h>
#include <aws/finspace/model/KxVolumeType.h>
#include <aws/finspace/model/ListKxChangesetsRequest.h>
#include <aws/finspace/model/ListKxChangesetsResult.h>
#include <aws/finspace/model/ListKxClusterNodesRequest.h>
#include <aws/finspace/model/ListKxClusterNodesResult.h>
#include <aws/finspace/model/ListKxClustersRequest.h>
#include <aws/finspace/model/ListKxClustersResult.h>
#include <aws/finspace/model/ListKxDatabasesRequest.h>
#include <aws/finspace/model/ListKxDatabasesResult.h>
#include <aws/finspace/model/ListKxDataviewsRequest.h>
#include <aws/finspace/model/ListKxDataviewsResult.h>
#include <aws/finspace/model/ListKxEnvironmentsRequest.h>
#include <aws/finspace/model/ListKxEnvironmentsResult.h>
#include <aws/finspace/model/ListKxScalingGroupsRequest.h>
#include <aws/finspace/model/ListKxScalingGroupsResult.h>
#include <aws/finspace/model/ListKxUsersRequest.h>
#include <aws/finspace/model/ListKxUsersResult.h>
#include <aws/finspace/model/ListKxVolumesRequest.h>
#include <aws/finspace/model/ListKxVolumesResult.h>
#include <aws/finspace/model/ListTagsForResourceRequest.h>
#include <aws/finspace/model/ListTagsForResourceResult.h>
#include <aws/finspace/model/NetworkACLEntry.h>
#include <aws/finspace/model/PortRange.h>
#include <aws/finspace/model/RuleAction.h>
#include <aws/finspace/model/SuperuserParameters.h>
#include <aws/finspace/model/TagResourceRequest.h>
#include <aws/finspace/model/TagResourceResult.h>
#include <aws/finspace/model/TgwStatus.h>
#include <aws/finspace/model/TickerplantLogConfiguration.h>
#include <aws/finspace/model/TransitGatewayConfiguration.h>
#include <aws/finspace/model/UntagResourceRequest.h>
#include <aws/finspace/model/UntagResourceResult.h>
#include <aws/finspace/model/UpdateKxClusterCodeConfigurationRequest.h>
#include <aws/finspace/model/UpdateKxClusterCodeConfigurationResult.h>
#include <aws/finspace/model/UpdateKxClusterDatabasesRequest.h>
#include <aws/finspace/model/UpdateKxClusterDatabasesResult.h>
#include <aws/finspace/model/UpdateKxDatabaseRequest.h>
#include <aws/finspace/model/UpdateKxDatabaseResult.h>
#include <aws/finspace/model/UpdateKxDataviewRequest.h>
#include <aws/finspace/model/UpdateKxDataviewResult.h>
#include <aws/finspace/model/UpdateKxEnvironmentNetworkRequest.h>
#include <aws/finspace/model/UpdateKxEnvironmentNetworkResult.h>
#include <aws/finspace/model/UpdateKxEnvironmentRequest.h>
#include <aws/finspace/model/UpdateKxEnvironmentResult.h>
#include <aws/finspace/model/UpdateKxUserRequest.h>
#include <aws/finspace/model/UpdateKxUserResult.h>
#include <aws/finspace/model/UpdateKxVolumeRequest.h>
#include <aws/finspace/model/UpdateKxVolumeResult.h>
#include <aws/finspace/model/Volume.h>
#include <aws/finspace/model/VolumeType.h>
#include <aws/finspace/model/VpcConfiguration.h>

using FinspaceIncludeTest = ::testing::Test;

TEST_F(FinspaceIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::finspace::FinspaceClient>("FinspaceIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
