/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <gtest/gtest.h>
#include <aws/testing/AwsTestHelpers.h>

#include <aws/firehose/FirehoseClient.h>
#include <aws/firehose/FirehoseEndpointProvider.h>
#include <aws/firehose/FirehoseEndpointRules.h>
#include <aws/firehose/FirehoseErrorMarshaller.h>
#include <aws/firehose/FirehoseErrors.h>
#include <aws/firehose/FirehoseRequest.h>
#include <aws/firehose/FirehoseServiceClientModel.h>
#include <aws/firehose/Firehose_EXPORTS.h>
#include <aws/firehose/model/AmazonOpenSearchServerlessBufferingHints.h>
#include <aws/firehose/model/AmazonOpenSearchServerlessDestinationConfiguration.h>
#include <aws/firehose/model/AmazonOpenSearchServerlessDestinationDescription.h>
#include <aws/firehose/model/AmazonOpenSearchServerlessDestinationUpdate.h>
#include <aws/firehose/model/AmazonOpenSearchServerlessRetryOptions.h>
#include <aws/firehose/model/AmazonOpenSearchServerlessS3BackupMode.h>
#include <aws/firehose/model/AmazonopensearchserviceBufferingHints.h>
#include <aws/firehose/model/AmazonopensearchserviceDestinationConfiguration.h>
#include <aws/firehose/model/AmazonopensearchserviceDestinationDescription.h>
#include <aws/firehose/model/AmazonopensearchserviceDestinationUpdate.h>
#include <aws/firehose/model/AmazonopensearchserviceIndexRotationPeriod.h>
#include <aws/firehose/model/AmazonopensearchserviceRetryOptions.h>
#include <aws/firehose/model/AmazonopensearchserviceS3BackupMode.h>
#include <aws/firehose/model/AuthenticationConfiguration.h>
#include <aws/firehose/model/BufferingHints.h>
#include <aws/firehose/model/CatalogConfiguration.h>
#include <aws/firehose/model/CloudWatchLoggingOptions.h>
#include <aws/firehose/model/CompressionFormat.h>
#include <aws/firehose/model/Connectivity.h>
#include <aws/firehose/model/ContentEncoding.h>
#include <aws/firehose/model/CopyCommand.h>
#include <aws/firehose/model/CreateDeliveryStreamRequest.h>
#include <aws/firehose/model/CreateDeliveryStreamResult.h>
#include <aws/firehose/model/DataFormatConversionConfiguration.h>
#include <aws/firehose/model/DatabaseColumnList.h>
#include <aws/firehose/model/DatabaseList.h>
#include <aws/firehose/model/DatabaseSnapshotInfo.h>
#include <aws/firehose/model/DatabaseSourceAuthenticationConfiguration.h>
#include <aws/firehose/model/DatabaseSourceConfiguration.h>
#include <aws/firehose/model/DatabaseSourceDescription.h>
#include <aws/firehose/model/DatabaseSourceVPCConfiguration.h>
#include <aws/firehose/model/DatabaseTableList.h>
#include <aws/firehose/model/DatabaseType.h>
#include <aws/firehose/model/DefaultDocumentIdFormat.h>
#include <aws/firehose/model/DeleteDeliveryStreamRequest.h>
#include <aws/firehose/model/DeleteDeliveryStreamResult.h>
#include <aws/firehose/model/DeliveryStreamDescription.h>
#include <aws/firehose/model/DeliveryStreamEncryptionConfiguration.h>
#include <aws/firehose/model/DeliveryStreamEncryptionConfigurationInput.h>
#include <aws/firehose/model/DeliveryStreamEncryptionStatus.h>
#include <aws/firehose/model/DeliveryStreamFailureType.h>
#include <aws/firehose/model/DeliveryStreamStatus.h>
#include <aws/firehose/model/DeliveryStreamType.h>
#include <aws/firehose/model/DescribeDeliveryStreamRequest.h>
#include <aws/firehose/model/DescribeDeliveryStreamResult.h>
#include <aws/firehose/model/Deserializer.h>
#include <aws/firehose/model/DestinationDescription.h>
#include <aws/firehose/model/DestinationTableConfiguration.h>
#include <aws/firehose/model/DirectPutSourceConfiguration.h>
#include <aws/firehose/model/DirectPutSourceDescription.h>
#include <aws/firehose/model/DocumentIdOptions.h>
#include <aws/firehose/model/DynamicPartitioningConfiguration.h>
#include <aws/firehose/model/ElasticsearchBufferingHints.h>
#include <aws/firehose/model/ElasticsearchDestinationConfiguration.h>
#include <aws/firehose/model/ElasticsearchDestinationDescription.h>
#include <aws/firehose/model/ElasticsearchDestinationUpdate.h>
#include <aws/firehose/model/ElasticsearchIndexRotationPeriod.h>
#include <aws/firehose/model/ElasticsearchRetryOptions.h>
#include <aws/firehose/model/ElasticsearchS3BackupMode.h>
#include <aws/firehose/model/EncryptionConfiguration.h>
#include <aws/firehose/model/ExtendedS3DestinationConfiguration.h>
#include <aws/firehose/model/ExtendedS3DestinationDescription.h>
#include <aws/firehose/model/ExtendedS3DestinationUpdate.h>
#include <aws/firehose/model/FailureDescription.h>
#include <aws/firehose/model/HECEndpointType.h>
#include <aws/firehose/model/HiveJsonSerDe.h>
#include <aws/firehose/model/HttpEndpointBufferingHints.h>
#include <aws/firehose/model/HttpEndpointCommonAttribute.h>
#include <aws/firehose/model/HttpEndpointConfiguration.h>
#include <aws/firehose/model/HttpEndpointDescription.h>
#include <aws/firehose/model/HttpEndpointDestinationConfiguration.h>
#include <aws/firehose/model/HttpEndpointDestinationDescription.h>
#include <aws/firehose/model/HttpEndpointDestinationUpdate.h>
#include <aws/firehose/model/HttpEndpointRequestConfiguration.h>
#include <aws/firehose/model/HttpEndpointRetryOptions.h>
#include <aws/firehose/model/HttpEndpointS3BackupMode.h>
#include <aws/firehose/model/IcebergDestinationConfiguration.h>
#include <aws/firehose/model/IcebergDestinationDescription.h>
#include <aws/firehose/model/IcebergDestinationUpdate.h>
#include <aws/firehose/model/IcebergS3BackupMode.h>
#include <aws/firehose/model/InputFormatConfiguration.h>
#include <aws/firehose/model/InvalidKMSResourceException.h>
#include <aws/firehose/model/InvalidSourceException.h>
#include <aws/firehose/model/KMSEncryptionConfig.h>
#include <aws/firehose/model/KeyType.h>
#include <aws/firehose/model/KinesisStreamSourceConfiguration.h>
#include <aws/firehose/model/KinesisStreamSourceDescription.h>
#include <aws/firehose/model/ListDeliveryStreamsRequest.h>
#include <aws/firehose/model/ListDeliveryStreamsResult.h>
#include <aws/firehose/model/ListTagsForDeliveryStreamRequest.h>
#include <aws/firehose/model/ListTagsForDeliveryStreamResult.h>
#include <aws/firehose/model/MSKSourceConfiguration.h>
#include <aws/firehose/model/MSKSourceDescription.h>
#include <aws/firehose/model/NoEncryptionConfig.h>
#include <aws/firehose/model/OpenXJsonSerDe.h>
#include <aws/firehose/model/OrcCompression.h>
#include <aws/firehose/model/OrcFormatVersion.h>
#include <aws/firehose/model/OrcSerDe.h>
#include <aws/firehose/model/OutputFormatConfiguration.h>
#include <aws/firehose/model/ParquetCompression.h>
#include <aws/firehose/model/ParquetSerDe.h>
#include <aws/firehose/model/ParquetWriterVersion.h>
#include <aws/firehose/model/PartitionField.h>
#include <aws/firehose/model/PartitionSpec.h>
#include <aws/firehose/model/ProcessingConfiguration.h>
#include <aws/firehose/model/Processor.h>
#include <aws/firehose/model/ProcessorParameter.h>
#include <aws/firehose/model/ProcessorParameterName.h>
#include <aws/firehose/model/ProcessorType.h>
#include <aws/firehose/model/PutRecordBatchRequest.h>
#include <aws/firehose/model/PutRecordBatchResponseEntry.h>
#include <aws/firehose/model/PutRecordBatchResult.h>
#include <aws/firehose/model/PutRecordRequest.h>
#include <aws/firehose/model/PutRecordResult.h>
#include <aws/firehose/model/Record.h>
#include <aws/firehose/model/RedshiftDestinationConfiguration.h>
#include <aws/firehose/model/RedshiftDestinationDescription.h>
#include <aws/firehose/model/RedshiftDestinationUpdate.h>
#include <aws/firehose/model/RedshiftRetryOptions.h>
#include <aws/firehose/model/RedshiftS3BackupMode.h>
#include <aws/firehose/model/RetryOptions.h>
#include <aws/firehose/model/S3BackupMode.h>
#include <aws/firehose/model/S3DestinationConfiguration.h>
#include <aws/firehose/model/S3DestinationDescription.h>
#include <aws/firehose/model/S3DestinationUpdate.h>
#include <aws/firehose/model/SSLMode.h>
#include <aws/firehose/model/SchemaConfiguration.h>
#include <aws/firehose/model/SchemaEvolutionConfiguration.h>
#include <aws/firehose/model/SecretsManagerConfiguration.h>
#include <aws/firehose/model/Serializer.h>
#include <aws/firehose/model/SnapshotRequestedBy.h>
#include <aws/firehose/model/SnapshotStatus.h>
#include <aws/firehose/model/SnowflakeBufferingHints.h>
#include <aws/firehose/model/SnowflakeDataLoadingOption.h>
#include <aws/firehose/model/SnowflakeDestinationConfiguration.h>
#include <aws/firehose/model/SnowflakeDestinationDescription.h>
#include <aws/firehose/model/SnowflakeDestinationUpdate.h>
#include <aws/firehose/model/SnowflakeRetryOptions.h>
#include <aws/firehose/model/SnowflakeRoleConfiguration.h>
#include <aws/firehose/model/SnowflakeS3BackupMode.h>
#include <aws/firehose/model/SnowflakeVpcConfiguration.h>
#include <aws/firehose/model/SourceDescription.h>
#include <aws/firehose/model/SplunkBufferingHints.h>
#include <aws/firehose/model/SplunkDestinationConfiguration.h>
#include <aws/firehose/model/SplunkDestinationDescription.h>
#include <aws/firehose/model/SplunkDestinationUpdate.h>
#include <aws/firehose/model/SplunkRetryOptions.h>
#include <aws/firehose/model/SplunkS3BackupMode.h>
#include <aws/firehose/model/StartDeliveryStreamEncryptionRequest.h>
#include <aws/firehose/model/StartDeliveryStreamEncryptionResult.h>
#include <aws/firehose/model/StopDeliveryStreamEncryptionRequest.h>
#include <aws/firehose/model/StopDeliveryStreamEncryptionResult.h>
#include <aws/firehose/model/TableCreationConfiguration.h>
#include <aws/firehose/model/Tag.h>
#include <aws/firehose/model/TagDeliveryStreamRequest.h>
#include <aws/firehose/model/TagDeliveryStreamResult.h>
#include <aws/firehose/model/UntagDeliveryStreamRequest.h>
#include <aws/firehose/model/UntagDeliveryStreamResult.h>
#include <aws/firehose/model/UpdateDestinationRequest.h>
#include <aws/firehose/model/UpdateDestinationResult.h>
#include <aws/firehose/model/VpcConfiguration.h>
#include <aws/firehose/model/VpcConfigurationDescription.h>

using FirehoseIncludeTest = ::testing::Test;

TEST_F(FirehoseIncludeTest, TestClientCompiles)
{
  Aws::Client::ClientConfigurationInitValues cfgInit;
  cfgInit.shouldDisableIMDS = true;
  Aws::Client::ClientConfiguration config(cfgInit);
  AWS_UNREFERENCED_PARAM(config);
  // auto pClient = Aws::MakeUnique<Aws::Firehose::FirehoseClient>("FirehoseIncludeTest", config);
  // ASSERT_TRUE(pClient.get());
}
